<?php
/**
 * KSeF Import Type enum file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Model\Enum;

/**
 * KSeF Import Type enum.
 */
enum ImportType: string
{
	case SALES = 'Subject1';
	case COST = 'Subject2';

	public function module(): string
	{
		return match ($this) {
			self::SALES => 'FInvoice',
			self::COST => 'FInvoiceCost',
		};
	}
}
