<?php
/**
 * KSeF Type enum file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Model\Enum;

/**
 * KSeF Type enum.
 */
enum Type
{
	case STRING;
	case FLOAT;
	case INTEGER;
	case BOOL;
	case DATE;

	/**
	 * Cast value to the enum type.
	 *
	 * @param mixed $value
	 *
	 * @return mixed
	 */
	public function cast(mixed $value): mixed
	{
		return match ($this) {
			self::STRING => (string) $value,
			self::FLOAT => (float) $value,
			self::INTEGER => (int) $value,
			self::BOOL => (bool) $value,
			self::DATE => \is_string($value) ? new \DateTime($value) : null,
		};
	}
}
