<?php
/**
 * KSeF Invoice Fa Builder class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Builder;

use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Fa;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\OkresFa;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\OkresFaGroup;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\P_13_1Group;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\P_13_2Group;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\P_13_3Group;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\P_6Group;
use N1ebieski\KSEFClient\Support\Optional;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\KodWaluty;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\KursWalutyZ;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_1;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_13_1;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_13_10;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_13_11;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_13_2;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_13_3;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_13_6_1;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_13_6_2;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_13_6_3;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_13_7;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_13_8;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_13_9;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_14_1;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_14_1W;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_14_2;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_14_2W;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_14_3;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_14_3W;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_15;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_1M;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_2;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_6;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_6_Do;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\P_6_Od;

/**
 * KSeF Invoice Fa Builder class.
 */
final class FaBuilder extends AbstractBuilder
{
	/** {@inheritDoc} */
	public function build(): Fa
	{
		return new Fa(
			kodWaluty: new KodWaluty($this->data['//Fa/KodWaluty']),
			p_1: new P_1($this->data['//Fa/P_1']),
			p_2: new P_2($this->data['//Fa/P_2']),
			p_15: new P_15($this->data['//Fa/P_15']),
			p_1M: !empty($this->data['//Fa/P_1M']) ? new P_1M($this->data['//Fa/P_1M']) : new Optional(),
			p_6Group: (!empty(array_filter($this->data['okresFa'])))
				? new OkresFaGroup(
					new OkresFa(
						new P_6_Od($this->data['okresFa']['//Fa/P_6_Od']),
						new P_6_Do($this->data['okresFa']['//Fa/P_6_Do']),
					)
				)
				: ((!empty($this->data['//Fa/P_6'])) ? new P_6Group(new P_6($this->data['//Fa/P_6'])) : new Optional()),
			p_13_1Group: $this->hasAnyValue(['//Fa/P_13_1', '//Fa/P_14_1', '//Fa/P_14_1w'])
				? new P_13_1Group(
					new P_13_1($this->data['//Fa/P_13_1']),
					new P_14_1($this->data['//Fa/P_14_1']),
					!empty($this->data['//Fa/P_14_1w']) ? new P_14_1W($this->data['//Fa/P_14_1w']) : new Optional(),
				)
				: new Optional(),
			p_13_2Group: $this->hasAnyValue(['//Fa/P_13_2', '//Fa/P_14_2', '//Fa/P_14_2w'])
				? new P_13_2Group(
					new P_13_2($this->data['//Fa/P_13_2']),
					new P_14_2($this->data['//Fa/P_14_2']),
					!empty($this->data['//Fa/P_14_2w']) ? new P_14_2W($this->data['//Fa/P_14_2w']) : new Optional(),
				)
				: new Optional(),
			p_13_3Group: $this->hasAnyValue(['//Fa/P_13_3', '//Fa/P_14_3', '//Fa/P_14_3w'])
				? new P_13_3Group(
					new P_13_3($this->data['//Fa/P_13_3']),
					new P_14_3($this->data['//Fa/P_14_3']),
					!empty($this->data['//Fa/P_14_3w']) ? new P_14_3W($this->data['//Fa/P_14_3w']) : new Optional(),
				)
				: new Optional(),
			p_13_6_1: !empty($this->data['//Fa/P_13_6_1']) ? new P_13_6_1($this->data['//Fa/P_13_6_1']) : new Optional(),
			p_13_6_2: !empty($this->data['//Fa/P_13_6_2']) ? new P_13_6_2($this->data['//Fa/P_13_6_2']) : new Optional(),
			p_13_6_3: !empty($this->data['//Fa/P_13_6_3']) ? new P_13_6_3($this->data['//Fa/P_13_6_3']) : new Optional(),
			p_13_7: !empty($this->data['//Fa/P_13_7']) ? new P_13_7($this->data['//Fa/P_13_7']) : new Optional(),
			p_13_8: !empty($this->data['//Fa/P_13_8']) ? new P_13_8($this->data['//Fa/P_13_8']) : new Optional(),
			p_13_9: !empty($this->data['//Fa/P_13_9']) ? new P_13_9($this->data['//Fa/P_13_9']) : new Optional(),
			p_13_10: !empty($this->data['//Fa/P_13_10']) ? new P_13_10($this->data['//Fa/P_13_10']) : new Optional(),
			p_13_11: !empty($this->data['//Fa/P_13_11']) ? new P_13_11($this->data['//Fa/P_13_11']) : new Optional(),
			kursWalutyZ: !empty($this->data['fa_kursWalutyZ']) ? new KursWalutyZ($this->data['fa_kursWalutyZ']) : new Optional(),
			adnotacje: $this->data['fa_adnotacje'],
			rodzajFaktury: $this->data['//Fa/RodzajFaktury'],
			korektaGroup: !empty($this->data['fa_korektaGroup']) ? $this->data['fa_korektaGroup'] : new Optional(),
			zaliczkaCzesciowa: !empty($this->data['fa_zaliczkaCzesciowa']) ? $this->data['fa_zaliczkaCzesciowa'] : new Optional(),
			tp: new Optional(), /* Not implemented yet */
			fp: new Optional(), /* Not implemented yet */
			dodatkowyOpis: !empty($this->data['//Fa/DodatkowyOpis']) ? $this->data['//Fa/DodatkowyOpis'] : new Optional(),
			fakturaZaliczkowa: !empty($this->data['fa_fakturaZaliczkowa']) ? $this->data['fa_fakturaZaliczkowa'] : new Optional(),
			zwrotAkcyzy: new Optional(), /* Not implemented yet */
			faWiersz: !empty($this->data['faWiersz']) ? $this->data['faWiersz'] : new Optional(),
			rozliczenie: !empty($this->data['fa_rozliczenie']) ? $this->data['fa_rozliczenie'] : new Optional(),
			platnosc: !empty($this->data['fa_platnosc']) ? $this->data['fa_platnosc'] : new Optional(),
			warunkiTransakcji: new Optional(), /* Not implemented yet */
			zamowienie: !empty($this->data['fa_zamowienie']) ? $this->data['fa_zamowienie'] : new Optional(),
		);
	}
}
