<?php
/**
 * KSeF Invoice Footer Builder class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Builder;

use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Informacje;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Rejestry;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Stopka;
use N1ebieski\KSEFClient\Support\Optional;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\BDO;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\KRS;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\PelnaNazwa;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\REGON;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\StopkaFaktury;

/**
 * KSeF Invoice Footer Builder class.
 */
final class FooterBuilder extends AbstractBuilder
{
	/** {@inheritDoc} */
	public function build(): Stopka
	{
		return new Stopka(
			informacje: [
				new Informacje(
					empty($this->data['//Stopka/Informacje/StopkaFaktury']) ? new Optional() : new StopkaFaktury($this->data['//Stopka/Informacje/StopkaFaktury']),
				)
			],
			rejestry: [
				new Rejestry(
					empty($this->data['//Stopka/Rejestry/PelnaNazwa']) ? new Optional() : new PelnaNazwa($this->data['//Stopka/Rejestry/PelnaNazwa']),
					empty($this->data['//Stopka/Rejestry/KRS']) ? new Optional() : new KRS($this->data['//Stopka/Rejestry/KRS']),
					empty($this->data['//Stopka/Rejestry/REGON']) ? new Optional() : new REGON($this->data['//Stopka/Rejestry/REGON']),
					empty($this->data['//Stopka/Rejestry/BDO']) ? new Optional() : new BDO($this->data['//Stopka/Rejestry/BDO']),
				)
			],
		);
	}
}
