<?php
/**
 * KSeF Invoice Header Builder class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Builder;

use App\Integrations\KSeF\KSeF;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Naglowek;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\DataWytworzeniaFa;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\FormCode;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\SystemInfo;

/**
 * KSeF Invoice Header Builder class.
 */
final class HeaderBuilder extends AbstractBuilder
{
	/** {@inheritDoc} */
	public function build(): Naglowek
	{
		return new Naglowek(
			wariantFormularza: FormCode::Fa3,
			dataWytworzeniaFa: new DataWytworzeniaFa(''),
			systemInfo: new SystemInfo(KSeF::SYSTEM_INFO),
		);
	}
}
