<?php
/**
 * KSeF Builder FaCorrectionRule rule class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Builder\Rules;

use App\Fields\Country;
use App\Integrations\KSeF\Model\Enum\Type;
use App\Integrations\KSeF\Service\Mapper\MapperService;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Adres;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\DaneFaKorygowanej;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\KorektaGroup;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\NIPGroup;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\NrKSeFGroup;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\NrKSeFNGroup;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Podmiot2K;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Podmiot2KDaneIdentyfikacyjne;
use N1ebieski\KSEFClient\Support\Optional;
use N1ebieski\KSEFClient\ValueObjects\NIP;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\AdresL1;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\DataWystFaKorygowanej;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\KodKraju;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\Nazwa;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\NrFaKorygowanej;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\NrFaKorygowany;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\NrKSeFFaKorygowanej;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\PrzyczynaKorekty;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\TypKorekty;

/**
 * KSeF Builder FaCorrectionRule rule class.
 */
class FaCorrectionRule implements RuleInterface // todo UPDATE
{
	private ?MapperService $mapperService = null;

	/** {@inheritDoc} */
	public function apply(array &$target, MapperService $mapperService): void
	{
		$this->mapperService = $mapperService;

		$recordModel = $mapperService->getRecord();
		$moduleName = $recordModel->getModuleName();
		$correctionNode = [];

		if ('FCorectingInvoice' === $moduleName) {
			$reason = $this->mapperService->mapField('reason', Type::STRING);
			$type = match ($this->mapperService->mapField('correction_type', Type::STRING)) {
				'PLL_ORIGINAL' => TypKorekty::Pierwotna,
				'PLL_CORRECTIVE' => TypKorekty::Korygujaca,
				'PLL_OTHER' => TypKorekty::Inna,
				'default' => null,
			};
			$invoiceNumber = $this->mapperService->mapField('subject', Type::STRING);

			$subject2 = null;
			$originalInvoiceRecord = \Vtiger_Record_Model::getInstanceById($mapperService->mapField('yf_finvoiceid', Type::STRING));
			if (!empty($originalInvoiceRecord)) {
				$nip = new NIPGroup(new NIP($mapperService->mapField('//Podmiot2/DaneIdentyfikacyjne/NIP', Type::STRING, $originalInvoiceRecord)));
				$name = $mapperService->mapField('//Podmiot2/DaneIdentyfikacyjne/Nazwa', Type::STRING, $originalInvoiceRecord);
				$address1 = $mapperService->mapField('//Podmiot2/Adres/AdresL1', Type::STRING, $originalInvoiceRecord);
				$country = Country::getCountryCode($mapperService->mapField('//Podmiot2/Adres/KodKraju', Type::STRING, $originalInvoiceRecord)) ?? 'PL';
				$subject2 = new Podmiot2K(
					daneIdentyfikacyjne: new Podmiot2KDaneIdentyfikacyjne(
						$nip,
						empty($name) ? new Optional() : new Nazwa($name),
					),
					adres: new Adres(
						new AdresL1($address1),
						new KodKraju($country),
					),
				);

				$previousInvoiceHasKsef = true;
				$details = new DaneFaKorygowanej(
					new DataWystFaKorygowanej($this->mapperService->mapField('//Fa/P_1', Type::STRING, $originalInvoiceRecord)),
					new NrFaKorygowanej($this->mapperService->mapField('//Fa/P_2', Type::STRING, $originalInvoiceRecord)),
					(true === $previousInvoiceHasKsef)
						? new NrKSeFGroup(new NrKSeFFaKorygowanej($this->mapperService->mapField('yf_ksef_number', Type::STRING, $originalInvoiceRecord)))
						: new NrKSeFNGroup(),
				);

				$correctionNode = new KorektaGroup(
					daneFaKorygowanej: [$details],
					przyczynaKorekty: !empty($reason) ? new PrzyczynaKorekty($reason) : new Optional(),
					typKorekty: !empty($type) ? $type : new Optional(),
					okresFaKorygowanej: new Optional(), /* Not implemented yet */
					nrFaKorygowany: !empty($invoiceNumber) ? new NrFaKorygowany($invoiceNumber) : new Optional(),
					podmiot1K: new Optional(), /* Not implemented yet */
					podmiot2K: !empty($subject2) ? new $subject2() : new Optional(),
					p15ZKGroup: new Optional(), /* Not implemented yet */
				);
			}
		}

		$target['fa_korektaGroup'] = $correctionNode;
	}
}
