<?php
/**
 * KSeF Builder FaSettlementInvoiceRule rule class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Builder\Rules;

use App\Integrations\KSeF\Model\Enum\Type;
use App\Integrations\KSeF\Service\Mapper\MapperService;
use App\QueryGenerator;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\FakturaZaliczkowa;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\NrKSeFFaZaliczkowejGroup;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\NrKSeFZNGroup;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\NrFaZaliczkowej;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\NrKSeFFaZaliczkowej;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\RodzajFaktury;

/**
 * KSeF Builder FaSettlementInvoiceRule rule class.
 */
class FaSettlementInvoiceRule implements RuleInterface
{
	private ?MapperService $mapperService = null;

	/** {@inheritDoc} */
	public function apply(array &$target, MapperService $mapperService): void
	{
		$this->mapperService = $mapperService;

		$advancesInvoicesListNode = [];
		if (RodzajFaktury::Roz === $target['//Fa/RodzajFaktury']) {
			$advanceInvoices = $this->getRelatedInvoice($mapperService->getRecord()->getId());
			foreach ($advanceInvoices as $advanceInvoice) {
				$ksefNumber = $this->mapperService->mapField('yf_ksef_number', Type::STRING, $advanceInvoice);
				if (empty($ksefNumber)) {
					$details = new NrKSeFZNGroup(
						nrFaZaliczkowej: new NrFaZaliczkowej($this->mapperService->mapField('//Fa/P_2', Type::STRING, $advanceInvoice)),
					);
				} else {
					$details = new NrKSeFFaZaliczkowejGroup(new NrKSeFFaZaliczkowej($ksefNumber));
				}
				$advancesInvoicesListNode[] = new FakturaZaliczkowa($details);
			}
		}

		$target['fa_fakturaZaliczkowa'] = $advancesInvoicesListNode;
	}

	/**
	 * @param int $recordId
	 *
	 * @return \Vtiger_Record_Model[]
	 */
	private function getRelatedInvoice(int $recordId): array
	{
		$queryGenerator = new QueryGenerator('FInvoice');
		$queryGenerator->permissions = false;
		$queryGenerator->setFields(['id'])
			->addCondition('settlement_invoice', $recordId, 'eid');
		$ids = $queryGenerator->createQuery()->column();

		$results = [];
		foreach ($ids as $id) {
			$results[] = \Vtiger_Record_Model::getInstanceById($id, $queryGenerator->getModule());
		}

		return $results;
	}
}
