<?php
/**
 * KSeF Invoice Subject2 Builder class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Builder;

use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Adres;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\DaneKontaktowe;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Podmiot2;
use N1ebieski\KSEFClient\DTOs\Requests\Sessions\Podmiot2DaneIdentyfikacyjne;
use N1ebieski\KSEFClient\Support\Optional;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\AdresL1;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\Email;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\KodKraju;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\Nazwa;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\NrKlienta;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\Telefon;

/**
 * KSeF Invoice Subject2 Builder class.
 */
final class Subject2Builder extends AbstractBuilder
{
	/** {@inheritDoc} */
	public function build(): Podmiot2
	{
		return new Podmiot2(
			daneIdentyfikacyjne: new Podmiot2DaneIdentyfikacyjne(
				$this->data['//Podmiot2/DaneIdentyfikacyjne/NIP'],
				new Nazwa($this->data['//Podmiot2/DaneIdentyfikacyjne/Nazwa']),
			),
			adres: new Adres(
				new AdresL1($this->data['//Podmiot2/Adres/AdresL1']),
				new KodKraju($this->data['//Podmiot2/Adres/KodKraju']),
			),
			daneKontaktowe: [
				new DaneKontaktowe(
					empty($this->data['//Podmiot2/DaneKontaktowe/Email']) ? new Optional() : new Email($this->data['//Podmiot2/DaneKontaktowe/Email']),
					empty($this->data['//Podmiot2/DaneKontaktowe/Telefon']) ? new Optional() : new Telefon($this->data['//Podmiot2/DaneKontaktowe/Telefon']),
				)
			],
			nrKlienta: 
				empty($this->data['//Podmiot2/NrKlienta']) ? new Optional() : new NrKlienta($this->data['//Podmiot2/NrKlienta'])
		);
	}
}
