<?php

/**
 * Import Invoices - request creation of package.
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Cron;

use App\CronHandler;
use App\Integrations\KSeF\Client\BatchInvoiceClient;
use App\Integrations\KSeF\Model\Enum\ImportType;
use App\Integrations\KSeF\Repository\CertificateRepository;
use App\Pauser;

/**
 * VtigerKSeF_ImportRequest_Cron class.
 *
 * Step 1: send request to KSeF to prepare data for download.
 */
class ImportRequest extends CronHandler
{
	/** {@inheritdoc} */
	public function process()
	{
		$pauser = Pauser::getInstance('KSeF');
		$startDate = $pauser->getValue() ?: date('Y-m-d 04:00:00', strtotime('-90 day'));
		$endDate = date('Y-m-d H:i:s');

		$settingIds = (new CertificateRepository())->findActiveSettingIds();

		$batchInvoiceClient = new BatchInvoiceClient();
		foreach ($settingIds as $id) {
			$batchInvoiceClient->requestBatchImport(
				$id,
				new \DateTime($startDate),
				new \DateTime($endDate),
				ImportType::COST,
			);
		}
		$pauser->setValue($endDate);
	}
}
