<?php
/**
 * Verify and update invoices status in batch.
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Cron;

use App\CronHandler;
use App\Integrations\KSeF\Client\BatchInvoiceClient;
use App\Integrations\KSeF\Model\Enum\Status;
use App\Integrations\KSeF\Repository\QueueRepository;

/**
 * Vtiger_KSeFQueueBatchStatus_Cron class.
 */
class QueueBatchUpdate extends CronHandler
{
	/** {@inheritdoc} */
	public function process()
	{
		$biClient = new BatchInvoiceClient();
		$queueRepository = new QueueRepository();

		foreach ($queueRepository->findSettingIds(Status::IN_PROGRESS) as $settingId) {
			$biClient->updateInvoicesStatus($settingId);
		}
	}
}
