<?php

/**
 * KSeF Record Value Resolver class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Mapper\Resolver;

use App\Integrations\KSeF\Model\Mapper\Pair;
use App\Json;

class RecordValueResolver implements ValueResolverInterface
{
	public function supports(Pair $pair, array|\Vtiger_Record_Model|null $data): bool
	{
		return !\is_array($data) && !Json::isJson($pair->getField()) && !str_contains($pair->getField(), ':');
	}

	public function resolve(
		Pair $pair,
		array|\Vtiger_Record_Model|null $data,
		ValueResolverRegistry $registry
	): mixed {
		if ($data instanceof \Vtiger_Record_Model) {
			$value = $data->get($pair->getField());
		} else {
			$value = $registry->getMapper()->getRecord()->get($pair->getField());
		}

		return $value;
	}
}
