<?php
/**
 * KSeF Value Resolver Interface file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Mapper\Resolver;

use App\Integrations\KSeF\Model\Mapper\Pair;

interface ValueResolverInterface
{
	public function supports(Pair $pair, array|\Vtiger_Record_Model|null $data): bool;

	public function resolve(
		Pair $pair,
		array|\Vtiger_Record_Model|null $data,
		ValueResolverRegistry $registry,
	): mixed;
}
