<?php
/**
 * KSeF Advance Invoice Rule class file.
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Michał Stancelewski <m.stancelewski@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Integrations\KSeF\Service\Reader\RecordBuilder\Rules;

use App\Integrations\KSeF\Service\Reader\RecordBuilder\AbstractRecordBuilder;

/**
 * KSeF Advance Invoice Rule class.
 *
 * Marks invoice as advance invoice (ZAL, KOR_ZAL)
 */
final class AdvanceInvoiceRule implements RuleInterface
{
	private AbstractRecordBuilder $builder;
	private bool $isAdvanceInvoice = false;

	public function __construct(AbstractRecordBuilder $builder)
	{
		$this->builder = $builder;
	}

	/** {@inheritDoc} */
	public function apply(
		\Vtiger_Record_Model $record,
		array $context = [],
	): void {
		$invoiceType = $this->builder->getOptionalString('//Fa/RodzajFaktury');

		if (\in_array($invoiceType, ['ZAL', 'KOR_ZAL'])) {
			$this->isAdvanceInvoice = true;
		}
	}

	/**
	 * Check if current invoice is advance invoice type.
	 *
	 * @return bool
	 */
	public function isAdvanceInvoice(): bool
	{
		return $this->isAdvanceInvoice;
	}
}
