<?php

/**
 * Logger PSR adapter class file.
 *
 * @package   Log
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

declare(strict_types=1);

namespace App\Log;

use App\Log;
use Psr\Log\LoggerInterface;

class LoggerPsrAdapter implements LoggerInterface
{
	public function emergency($message, array $context = []): void
	{
		$this->log('emergency', $message, $context);
	}

	public function alert($message, array $context = []): void
	{
		$this->log('alert', $message, $context);
	}

	public function critical($message, array $context = []): void
	{
		$this->log('critical', $message, $context);
	}

	public function error($message, array $context = []): void
	{
		$this->log('error', $message, $context);
	}

	public function warning($message, array $context = []): void
	{
		$this->log('warning', $message, $context);
	}

	public function notice($message, array $context = []): void
	{
		$this->log('notice', $message, $context);
	}

	public function info($message, array $context = []): void
	{
		$this->log('info', $message, $context);
	}

	public function debug($message, array $context = []): void
	{
		$this->log('debug', $message, $context);
	}

	public function log($level, $message, array $context = []): void
	{
		$yiiLevel = self::mapLevel((string) $level);
		$category = $context['category'] ?? '';
		if (method_exists('\App\Log', $yiiLevel)) {
			Log::$yiiLevel($message, $category);
		}
	}

	protected static function mapLevel(string $level): string
	{
		return match (strtolower($level)) {
			'emergency', 'alert', 'critical', 'error' => 'error',
			'warning' => 'warning',
			'notice', 'info' => 'info',
			'debug' => 'trace',
			default => 'info',
		};
	}
}
