<?php
/**
 * Mail outlook message file.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

namespace App\Mail\Message;

use App\Mail\Account;

/**
 * Mail outlook message class.
 */
abstract class Base extends \App\Base
{
	const MAIL_TYPE_SENT = 0;
	const MAIL_TYPE_RECEIVED = 1;
	const MAIL_TYPE_INTERNAL = 2;
	/**
	 * Mail types map.
	 */
	const MAIL_TYPES = [
		0 => 'Sent',
		1 => 'Received',
		2 => 'Internal',
	];
	/**
	 * Process data.
	 *
	 * @var array
	 */
	public $processData = [];
	/**
	 * Emails fields cache.
	 *
	 * @var string[]
	 */
	protected $emailsFieldsCache = [];
	/**
	 * Number fields cache.
	 *
	 * @var string[]
	 */
	protected $numberFieldsCache = [];

	/**
	 * Get mail type.
	 * 0 = Sent
	 * 1 = Received
	 * 2 = Internal.
	 *
	 * @param Account|null $account
	 * @return int
	 */
	abstract function getMailType(?Account $account = null): int;
}
