<?php
/**
 * Service for handling quotient formula
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Formula\Processor;

use App\Report\Enums\FunctionType;
use App\Report\Formula\FormulaProcessor;
use DivisionByZeroError;

/** QuotientProcessor class */
final class QuotientProcessor implements FormulaProcessor
{
	/** {@inheritDoc} */
	public function process(array $data, FunctionType $function): float
	{
		try {
			return array_reduce(
				$data,
				static fn (float $a, float $b): float => $a / $b,
				$data[0] * $data[0],
			);
		} catch (DivisionByZeroError $exception) {
			return 0;
		}
	}

	/** {@inheritDoc} */
	public function supports(FunctionType $function): bool
	{
		return FunctionType::QUO === $function;
	}
}
