<?php
/**
 * Class attributes reflection service
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Utils;

use ReflectionParameter;

/** ReflectionParameterUtil class */
final class ReflectionParameterUtil
{
	/** Get attribute bases on reflection parameters */
	public static function getAttribute(ReflectionParameter $parameter, string $type): ?object
	{
		foreach ($parameter->getAttributes() as $attribute) {
			if ($attribute->getName() === $type) {
				return $attribute->newInstance();
			}
		}

		return null;
	}
}
