<?php
/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */

class Install_Utils_Model
{
	/**
	 * Function that provides default configuration based on installer setup.
	 *
	 * @return array
	 */
	public static function getDefaultPreInstallParameters(): array
	{
		return [
			'db_server' => 'localhost',
			'db_username' => '',
			'db_password' => '',
			'db_name' => 'yetiforce',
			'mongo_server' => 'localhost',
			'mongo_username' => '',
			'mongo_password' => '',
			'mongo_name' => 'yetiforce',
			'admin_name' => 'admin' . random_int(10000, 99999),
			'admin_firstname' => 'Yeti',
			'admin_lastname' => 'Administrator',
			'admin_password' => '',
			'admin_email' => '',
		];
	}

	/**
	 * Clean data configuration.
	 */
	public static function cleanConfiguration()
	{
		\vtlib\Functions::recurseDelete('config/Db.php');
		\vtlib\Functions::recurseDelete('config/Main.php');
		if (isset($_SESSION['config_file_info'])) {
			unset($_SESSION['config_file_info']);
		}
		$className = '\Config\Main';
		if (class_exists($className)) {
			foreach ((new \ReflectionClass($className))->getStaticProperties() as $name => $value) {
				$className::${$name} = null;
			}
		}
	}
}
