<?php
/**
 * Report field model.
 *
 * @package   Modules
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Adrian Kon <a.kon@yetiforce.com>
 */

class ReportTemplate_FieldReport_Model
{
	private $module;
	private $label;
	private $fieldName;
	private $orderBy = '';
	private $groupBy;
	private string $aggregateFunction = '';
	private string $aggregateLabel = '';
	private $dataType;
	private $blockName;
	private $expressionField = '';

	public static function from(Vtiger_Field_Model $fieldModel): self
	{
		$reportField = new self();
		$fieldLabel = App\Language::translate($fieldModel->getLabel(), $fieldModel->getModuleName());
		$blockLabel = App\Language::translate($fieldModel->getBlockName(), $fieldModel->getModuleName());
		$fieldDataType = $fieldModel->getFieldDataType();
		$reportField->setBlockName($blockLabel);
		$reportField->setModule($fieldModel->getModuleName());
		$reportField->setLabel($fieldLabel);
		$reportField->setFieldName($fieldModel->getName());
		$reportField->setDataType($fieldDataType);

		return $reportField;
	}

	public static function fromInventory($fieldModel): self
	{
		$reportField = new self();
		$fieldLabel = App\Language::translate($fieldModel->getLabel(), $fieldModel->getModuleName());
		$fieldDataType = $fieldModel->getFieldDataType();
		$reportField->setModule($fieldModel->getModuleName());
		$reportField->setLabel($fieldLabel);
		$reportField->setFieldName($fieldModel->getName());
		$reportField->setDataType($fieldDataType);

		return $reportField;
	}

	public function setModule($module)
	{
		$this->module = $module;
	}

	public function getModule()
	{
		return $this->module;
	}

	public function setLabel($label)
	{
		$this->label = $label;
	}

	public function getLabel()
	{
		return $this->label;
	}

	public function setFieldName($fieldName)
	{
		$this->fieldName = $fieldName;
	}

	public function getFieldName()
	{
		return $this->fieldName;
	}

	public function setOrderBy($orderBy)
	{
		$this->orderBy = $orderBy;
	}

	public function getOrderBy()
	{
		return $this->orderBy;
	}

	public function setGroupBy($groupBy)
	{
		$this->groupBy = $groupBy;
	}

	public function getGroupBy()
	{
		return $this->groupBy;
	}

	public function setAggregateFunction(string $aggregateFunction)
	{
		$this->aggregateFunction = $aggregateFunction;
	}

	public function getAggregateFunction()
	{
		return $this->aggregateFunction;
	}

	public function setDataType($dataType)
	{
		$this->dataType = $dataType;
	}

	public function getDataType()
	{
		return $this->dataType;
	}

	public function setBlockName($blockName)
	{
		$this->blockName = $blockName;
	}

	public function getBlockName()
	{
		return $this->blockName;
	}

	public function getIcon(): string
	{
		return match ($this->getDataType()) {

			'currency', 'currencyInventory', => 'fa-solid fa-dollar-sign',
			'double', 'integer' => 'fa-solid fa-calculator',
			'email' => 'fa-solid fa-at',
			'string' => 'fa-solid fa-font',
			'percentage' => 'fa-solid fa-percent',
			'datetime', 'date' => 'fa-solid fa-calendar-days',
			'phone', => 'fa-solid fa-phone',
			default => '',
		};
	}

	public function getExpressionField(): string
	{
		return $this->expressionField;
	}

	public function setExpressionField(string $expressionField): self
	{
		$this->expressionField = $expressionField;

		return $this;
	}

	/**
	* Get the value of aggregateLabel
	*/
	public function getAggregateLabel()
	{
		return $this->aggregateLabel;
	}

	/**
	* Set the value of aggregateLabel
	*
	* @return  self
	*/
	public function setAggregateLabel($aggregateLabel)
	{
		$this->aggregateLabel = $aggregateLabel;

		return $this;
	}
}
