<?php
/**
 * Detail view.
 *
 * @package   Views
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Adrian Kon <a.kon@yetiforce.com>
 */

use App\Report\Provider\FieldsProvider;
use App\Report\Provider\ReportProvider;
use App\Report\Report;

/**
 * Report template detail class.
 */
class ReportTemplate_Detail_View extends Vtiger_Detail_View
{
	/** {@inheritdoc} */
	public function preProcess(App\Request $request, $display = true)
	{
		$viewer = $this->getViewer($request);
		$reportPreview = $this->getReportDataForPreview();
		$viewer->assign('PREVIEW_DATA', $reportPreview['previewData']);
		$viewer->assign('PREVIEW_HEADERS', $reportPreview['previewHeaders']);
		parent::preProcess($request);
	}

	/** {@inheritdoc} */
	public function showModuleDetailView(App\Request $request)
	{
		$viewer = $this->getViewer($request);
		$reportPreview = $this->getReportDataForPreview();
		$viewer->assign('PREVIEW_DATA', $reportPreview['previewData']);
		$viewer->assign('PREVIEW_HEADERS', $reportPreview['previewHeaders']);
		return parent::showModuleDetailView($request);
	}

	/**
	 * Get report data for preview.
	 */
	private function getReportDataForPreview(): array
	{
		$recordId = $this->record->getRecord()->getId();
		$userId = \App\User::getCurrentUserId();
		$previewData = Report::get(ReportProvider::class)->provide($recordId, $userId, true);
		$fieldsProvider = Report::get(FieldsProvider::class)->provide(
			$recordId,
			\count($previewData) > 0 ? $previewData[0] : [],
		);
		return ['previewData' => $previewData, 'previewHeaders' => $fieldsProvider];
	}
}
