<?php

/**
 * Activate Action Class for KSeF Settings.
 *
 * @package   Settings.Action
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */
declare(strict_types=1);

use App\Integrations\KSeF\KSeF;
use App\Language;
use App\Request;

/**
 * Activate action class for KSeF Settings.
 */
class Settings_KSeF_Activate_Action extends Settings_Vtiger_Basic_Action
{
	/** {@inheritdoc} */
	public function process(Request $request)
	{
		$moduleName = $request->getModule(false);
		$response = new Vtiger_Response();
		$message = 'LBL_SUCCESSFULLY_UPDATED';
		$result = false;

		try {
			(new KSeF())->activate();
			$result = true;
		} catch (Throwable $e) {
			$message = 'ERR_OCCURRED_CHECK_LOGS';
		}

		$response->setResult([
			'success' => $result,
			'message' => Language::translate($message, $moduleName),
			'_reload' => $result,
		]);

		$response->emit();
	}
}
