<?php

use App\Exceptions\AppException;
use App\Exceptions\NoPermitted;
use App\Fields\File;
use App\Json;
use App\Purifier;
use App\Request;
use App\Security\AdminAccess;

/**
 * Multi attachment basic file.
 *
 * @package Files
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

/**
 * Multi attachment class to handle files.
 */
class Settings_Vtiger_MultiAttachment_File extends Vtiger_MultiAttachment_File
{
	/** {@inheritDoc} */
	public function postCheckPermission(Request $request)
	{
		return AdminAccess::isPermitted($request->getModule());
	}

	/** {@inheritDoc} */
	public function get(Request $request)
	{
		if ($request->isEmpty('key', true)) {
			throw new NoPermitted('Not Acceptable', 406);
		}
		$recordModel = Vtiger_Record_Model::getInstanceById($request->getInteger('record'), $request->getModule());
		$key = $request->getByType('key', 2);
		$value = Json::decode($recordModel->get($request->getByType('field', 2)));
		foreach ($value as $item) {
			if ($item['key'] === $key) {
				$file = File::loadFromInfo([
					'path' => ROOT_DIRECTORY . DIRECTORY_SEPARATOR . $item['path'],
					'name' => $item['name'],
				]);
				if (file_exists($file->getPath())) {
					header('Pragma: cache');
					header('Cache-control: max-age=86400, public');
					header('Expires: ' . gmdate('D, d M Y H:i:s \G\M\T', time() + 86400));
					header('Content-type: ' . $file->getMimeType());
					header('Content-transfer-encoding: binary');
					header('Content-length: ' . $file->getSize());
					header('Content-disposition: attachment; filename="' . $item['name'] . '"');
					readfile($file->getPath());
					break;
				}
				throw new AppException('ERR_FILE_NOT_FOUND', 404);
			}
		}
	}

	/** {@inheritDoc} */
	public function post(Request $request)
	{
		$moduleName = $request->getModule(false);
		$modelClassName = Vtiger_Loader::getComponentClassName('Model', 'Module', $moduleName);

		/** @var Settings_Vtiger_Module_Model $model */
		$model = $modelClassName::getInstance($moduleName);

		$fieldModel = $model->getFieldByName($request->getByType('field', Purifier::ALNUM));
//		dd($_FILES);
		$attach = $fieldModel->getUITypeModel()->uploadTempFile($_FILES, $request->isEmpty('record') ? 0 : $request->getInteger('record'));
		if ($request->isAjax()) {
			$response = new Vtiger_Response();
			$response->setResult([
				'field' => $fieldModel->getName(),
				'module' => $model->getName(false),
				'parent' => $model->getParentName(),
				'attach' => $attach,
			]);
			$response->emit();
		}
	}
}
