/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */
'use strict';

/**
 * Settings KSeF Edit JavaScript class.
 */
Vtiger_Edit_Js(
	'Settings_KSeF_Edit_Js',
	{},
	{
		/**
		 * Container
		 */
		container: false,

		progressLoader: false,
		/**
		 * Save Event
		 * @param {Event} e
		 */
		saveEvent: function (e) {
			e.preventDefault();
			let form = this.getForm();
			if (form.validationEngine('validate')) {
				this.progressLoader = $.progressIndicator({
					show: true,
					message: app.vtranslate('JS_SAVE_LOADER_INFO'),
					position: 'html',
					blockInfo: {
						enabled: true,
						onBlock: () => {
							this.save();
						}
					}
				});
			}
		},

		save: function() {
			this.preSaveValidation().then((response) => {
				if (response === true) {
					let formData = this.getForm().serializeFormData();
					app
						.saveAjax('save', [], formData)
						.done( (data) => {
							if (data.result && data.success) {
								Settings_Vtiger_Index_Js.showMessage({ text: app.vtranslate('JS_SAVE_SUCCESS') });
								let listInstance = Settings_Vtiger_List_Js.getInstance();
								listInstance.getListViewRecords();
								app.hideModalWindow(this.container.attr('id'));
							} else {
								this.progressLoader.progressIndicator({ mode: 'hide' });
								app.showNotify({ text: app.vtranslate('JS_ERROR'), type: 'error' });
							}
						})
						.fail( () =>  {
							this.progressLoader.progressIndicator({ mode: 'hide' });
							app.showNotify({ text: app.vtranslate('JS_ERROR'), type: 'error' });
						});
				} else {
					this.progressLoader.progressIndicator({ mode: 'hide' });
				}
			})
		},

		/**
		 * PreSave validation
		 */
		preSaveValidation: function () {
			return new Promise((resolve, reject) => {
				let formData = new FormData(this.getForm()[0]);
				formData.delete('mode');
				formData.append('mode', 'preSaveValidation');
				AppConnector.request({
					async: false,
					url: 'index.php',
					type: 'POST',
					data: formData,
					processData: false,
					contentType: false
				})
					.done((data) => {
						let response = data.result;
						for (let i in response) {
							if (response[i].result !== true) {
								app.showNotify({
									text: response[i].message ? response[i].message : app.vtranslate('JS_ERROR'),
									type: 'notice'
								});
								if (response[i].hoverField !== undefined) {
									this.container.find('[name="' + response[i].hoverField + '"]').focus();
								}
							}
						}
						resolve(data.result.length <= 0);
					})
					.fail((textStatus, errorThrown) => {
						app.showNotify({ text: app.vtranslate('JS_ERROR'), type: 'error' });
						app.errorLog(textStatus, errorThrown);
						resolve(false);
				});
			});
		},

		/**
		 * Register Events
		 * @param {jQuery} modalContainer
		 */
		registerEvents: function (modalContainer) {
			this.container = modalContainer;
			let form = this.container.find('form');
			this.setForm(form);
			this.registerBasicEvents(this.container);
			this.container.on('click', '.js-modal__save', (e) => {
				this.saveEvent(e);
			});
		}
	}
);
