'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";jQuery.Class("Vtiger_Field_Js",{/**
		 * Function to get Instance of the class based on moduleName
		 * @param data,data to set
		 * @param moduleName module for which Instance should be created
		 * @return Instance of field class
		 */getInstance:function getInstance(data,moduleName){"undefined"==typeof moduleName&&(moduleName=app.getModuleName());var moduleField=moduleName+"_Field_Js",moduleFieldObj=window[moduleField],fieldClass="";fieldClass="undefined"==typeof moduleFieldObj?Vtiger_Field_Js:moduleFieldObj;var fieldObj=new fieldClass;return "undefined"==typeof data&&(data={}),fieldObj.setData(data),fieldObj}},{data:{},/**
		 * Function to check whether field is mandatory or not
		 * @return true if feld is madatory
		 * @return false if field is not mandatory
		 */isMandatory:function isMandatory(){return this.get("mandatory")},/**
		 * Function to get the value of particular key in object
		 * @return value for the passed key
		 */get:function get(key){return key in this.data?this.data[key]:""},/**
		 * Function to get type attribute of the object
		 * @return type attribute of the object
		 */getType:function getType(){return this.get("type")},/**
		 * Function to get name of the field
		 * @return <String> name of the field
		 */getName:function getName(){return this.get("name")},/**
		 * Function to get value of the field
		 * @return <Object> value of the field or empty of there is not value
		 */getValue:function getValue(){if("value"in this.getData())return this.get("value");return "defaultValue"in this.getData()?this.get("defaultValue"):""},/**
		 * Function to get the whole data
		 * @return <object>
		 */getData:function getData(){return this.data},/**
		 * Function to set data attribute of the class
		 * @return Instance of the class
		 */setData:function setData(fieldInfo){return this.data=fieldInfo,this},getModuleName:function getModuleName(){return app.getModuleName()},/**
		 * Function to get the ui type specific model
		 */getUiTypeModel:function getUiTypeModel(){var currentModule=this.getModuleName(),type=this.getType(),typeClassName=type.charAt(0).toUpperCase()+type.slice(1).toLowerCase(),moduleUiTypeClassName=window[currentModule+"_"+typeClassName+"_Field_Js"],BasicUiTypeClassName=window["Vtiger_"+typeClassName+"_Field_Js"];return "undefined"==typeof moduleUiTypeClassName?"undefined"==typeof BasicUiTypeClassName?this:new BasicUiTypeClassName().setData(this.getData()):new moduleUiTypeClassName().setData(this.getData())},/**
		 * Funtion to get the ui for the field  - generally this will be extend by the child classes to
		 * give ui type specific ui
		 * return <String or Jquery> it can return either plain html or jquery object
		 */getUi:function getUi(){var html="<input type=\"text\" name=\""+this.getName()+"\" class=\"form-control\" />";return html=jQuery(html).val(app.htmlDecode(this.getValue())),this.addValidationToElement(html)},/**
		 * Function to get the ui for a field depending on the ui type
		 * this will get the specific ui depending on the field type
		 * return <String or Jquery> it can return either plain html or jquery object
		 */getUiTypeSpecificHtml:function getUiTypeSpecificHtml(){var uiTypeModel=this.getUiTypeModel();return uiTypeModel.getUi()},/**
		 * Function to add the validation for the element
		 */addValidationToElement:function(element){element=jQuery(element);var addValidationToElement=element,elementInStructure=element.find("[name=\""+this.getName()+"\"]");0<elementInStructure.length&&(addValidationToElement=elementInStructure);var validationHandler="validate[";return this.isMandatory()&&(validationHandler+="required,"),validationHandler+="funcCall[Vtiger_Base_Validator_Js.invokeValidation]]",addValidationToElement.attr("data-validation-engine",validationHandler).attr("data-fieldinfo",JSON.stringify(this.getData())).attr("data-validator",JSON.stringify(this.getData().specialValidator)),element}}),Vtiger_Field_Js("Vtiger_Picklist_Field_Js",{},{/**
		 * Function to get the pick list values
		 * @return <object> key value pair of options
		 */getPickListValues:function getPickListValues(){return this.get("picklistvalues")},/**
		 * Function to get the ui
		 * @return - select element and select2 element
		 */getUi:function getUi(){var html="<select class=\"select2 form-control\" name=\""+this.getName()+"\">",pickListValues=this.getPickListValues(),selectedOption=app.htmlDecode(this.getValue());for(var option in !1===this.get("mandatory")&&(html+="<option value=\"\"></option>"),pickListValues)html+="<option value=\""+option+"\" ",option==selectedOption&&(html+=" selected "),html+=">"+pickListValues[option]+"</option>";html+="</select>";var selectContainer=jQuery(html);return this.addValidationToElement(selectContainer),selectContainer}}),Vtiger_Field_Js("Vtiger_Multipicklist_Field_Js",{},{/**
		 * Function to get the pick list values
		 * @return <object> key value pair of options
		 */getPickListValues:function getPickListValues(){return this.get("picklistvalues")},/**
		 * Function to get the ui
		 * @return - select element and select2 element
		 */getUi:function getUi(){var html="<select class=\"select2 form-control\" multiple name=\""+this.getName()+"[]\">",pickListValues=this.getPickListValues(),selectedOption=app.htmlDecode(this.getValue()),selectedOptionsArray=selectedOption.split(",");for(var option in pickListValues)html+="<option value=\""+option+"\" ",-1!=jQuery.inArray(option,selectedOptionsArray)&&(html+=" selected "),html+=">"+pickListValues[option]+"</option>";html+="</select>";var selectContainer=jQuery(html);return this.addValidationToElement(selectContainer),selectContainer}}),Vtiger_Field_Js("Vtiger_Boolean_Field_Js",{},{/**
		 * Function to check whether the field is checked or not
		 * @return <Boolean>
		 */isChecked:function isChecked(){var value=this.getValue();return !(1!=value&&"1"!=value&&"on"!=value.toLowerCase())},/**
		 * Function to get the ui
		 * @return - checkbox element
		 */getUi:function getUi(){var html="<input type=\"hidden\" name=\""+this.getName()+"\" value=\"0\"/><input type=\"checkbox\" name=\""+this.getName()+"\" ";return this.isChecked()&&(html+="checked"),html+=" />",this.addValidationToElement(html)}}),Vtiger_Field_Js("Vtiger_Date_Field_Js",{},{/**
		 * Function to get the user date format
		 */getDateFormat:function getDateFormat(){return this.get("date-format")},/**
		 * Function to get the ui
		 * @return - input text field
		 */getUi:function getUi(){var html="<div class=\"date input-group\"><input class=\"dateField form-control datepicker\" type=\"text\" name=\""+this.getName()+"\"  data-date-format=\""+this.getDateFormat()+"\"  value=\""+this.getValue()+"\" autocomplete=\"off\"/><div class=\"input-group-append\"><span class=\"input-group-text u-cursor-pointer js-date__btn\" data-js=\"click\"><span class=\"fas fa-calendar-alt\"></span></span></div></div>",element=jQuery(html);return this.addValidationToElement(element)}}),Vtiger_Field_Js("Vtiger_Currency_Field_Js",{},{/**
		 * get the currency symbol configured for the user
		 */getCurrencySymbol:function getCurrencySymbol(){return this.get("currency_symbol")},getUi:function getUi(){var html="<div class=\"input-group\"><span class=\"input-group-append\">"+this.getCurrencySymbol()+"</span><input type=\"text\" class=\"form-control\" name=\""+this.getName()+"\" value=\""+this.getValue()+"\"  /></div>",element=jQuery(html);return this.addValidationToElement(element)}}),Vtiger_Field_Js("Vtiger_Owner_Field_Js",{},{/**
		 * Function to get the picklist values
		 */getPickListValues:function getPickListValues(){return this.get("picklistvalues")},getUi:function getUi(){var html="<select class=\"select2 form-control\" name=\""+this.getName()+"\">",pickListValues=this.getPickListValues(),selectedOption=this.getValue();for(var optGroup in pickListValues){html+="<optgroup label=\""+optGroup+"\">";var optionGroupValues=pickListValues[optGroup];for(var option in optionGroupValues)html+="<option value=\""+option+"\" ",option==selectedOption&&(html+=" selected "),html+=">"+optionGroupValues[option]+"</option>";html+="</optgroup>";}html+="</select>";var selectContainer=jQuery(html);return this.addValidationToElement(selectContainer),selectContainer}}),Vtiger_Picklist_Field_Js("Vtiger_Tree_Field_Js",{},{getReadOnly:function getReadOnly(){var result="";return this.getValue()&&(result=" readonly=\"true\" "),result},/**
		 * Function to get the user date format
		 */getTreeTemplate:function getTreeTemplate(){return this.get("treetemplate")},/**
		 * Function to get the user date format
		 */getModuleName:function getModuleName(){return this.get("modulename")},getUi:function getUi(){var pickListValues=this.getPickListValues(),value=this.getValue()||"",values=value.split(",").map(function(v){return pickListValues[v]||""}),displayValue=values.join(", ",values),multiple=1;"tree"===this.getType()&&(multiple=0);var treeContainer=document.createElement("div");treeContainer.setAttribute("class","js-tree-container fieldValue");var sourceInput=document.createElement("input");sourceInput.setAttribute("name",this.getName()),sourceInput.setAttribute("type","hidden"),sourceInput.setAttribute("value",this.getValue()),sourceInput.setAttribute("class","sourceField"),sourceInput.setAttribute("fieldinfo",JSON.stringify(this.getData())),sourceInput.setAttribute("data-multiple",multiple),sourceInput.setAttribute("data-value","value"),sourceInput.setAttribute("data-treetemplate",this.getTreeTemplate()),sourceInput.setAttribute("data-module-name",this.getModuleName());var inputGroup=document.createElement("div");inputGroup.setAttribute("class","input-group");var clearBtn=document.createElement("span");clearBtn.setAttribute("class","input-group-prepend clearTreeSelection u-cursor-pointer");var clearBtnText=document.createElement("span");clearBtnText.setAttribute("class","input-group-text");var clearBtnTextIcon=document.createElement("span");clearBtnTextIcon.setAttribute("class","fas fa-times-circle"),clearBtnText.appendChild(clearBtnTextIcon),clearBtn.appendChild(clearBtnText);var sourceDisplay=document.createElement("input");sourceDisplay.setAttribute("name",this.getName()+"_display"),sourceDisplay.setAttribute("id",this.getName()+"_display"),sourceDisplay.setAttribute("type","text"),sourceDisplay.setAttribute("class","ml-0 treeAutoComplete form-control"),sourceDisplay.setAttribute("value",displayValue),sourceInput.setAttribute("fieldinfo",JSON.stringify(this.getData())),this.getReadOnly()&&sourceDisplay.setAttribute("readonly","readonly");var searchBtn=document.createElement("span");searchBtn.setAttribute("class","input-group-append js-tree-modal u-cursor-pointer");var searchBtnText=document.createElement("span");searchBtnText.setAttribute("class","input-group-text");var searchBtnTextIcon=document.createElement("span");searchBtnTextIcon.setAttribute("class","fas fa-search"),searchBtnText.appendChild(searchBtnTextIcon),searchBtn.appendChild(searchBtnText),inputGroup.appendChild(clearBtn),inputGroup.appendChild(sourceDisplay),inputGroup.appendChild(searchBtn),treeContainer.appendChild(sourceInput),treeContainer.appendChild(inputGroup);var selectContainer=$(treeContainer);return App.Fields.Tree.register(selectContainer),this.addValidationToElement(selectContainer),selectContainer}}),Vtiger_Multipicklist_Field_Js("Vtiger_Multireferencevalue_Field_Js",{},{}),Vtiger_Multipicklist_Field_Js("Vtiger_Sharedowner_Field_Js",{},{}),Vtiger_Tree_Field_Js("Vtiger_Categorymultipicklist_Field_Js",{},{}),Vtiger_Picklist_Field_Js("Vtiger_Modules_Field_Js",{},{}),Vtiger_Date_Field_Js("Vtiger_Datetime_Field_Js",{},{}),Vtiger_Picklist_Field_Js("Vtiger_Taxs_Field_Js",{},{}),Vtiger_Picklist_Field_Js("Vtiger_InventoryLimit_Field_Js",{},{}),Vtiger_Field_Js("Vtiger_Time_Field_Js",{},{/**
		 * Function to get the user date format
		 */getTimeFormat:function getTimeFormat(){return this.get("time-format")},/**
		 * Function to get the ui
		 * @return - input text field
		 */getUi:function getUi(){var html="<div class=\"input-group time\"><input class=\"clockPicker form-control\" type=\"text\" data-format=\""+this.getTimeFormat()+"\" name=\""+this.getName()+"\"  value=\""+this.getValue()+"\" /><span class=\"input-group-append\"><i class=\"far fa-clock\"></i></span></div>",element=jQuery(html);return this.addValidationToElement(element)}}),Vtiger_Field_Js("Vtiger_Text_Field_Js",{},{/**
		 * Function to get the ui
		 * @return - input text field
		 */getUi:function getUi(){var html="<textarea class=\"form-control-lg form-control\" name=\""+this.getName()+"\"  value=\""+this.getValue()+"\">"+this.getValue()+"</textarea>",element=jQuery(html);return this.addValidationToElement(element)}}),Vtiger_Field_Js("Vtiger_Percentage_Field_Js",{},{/**
		 * Function to get the ui
		 * @return - input percentage field
		 */getUi:function getUi(){var html="<div class=\"input-group\"><input type=\"number\" class=\"form-control\" min=\"0\" max=\"100\" name=\""+this.getName()+"\" value=\""+this.getValue()+"\" step=\"any\"/><span class=\"input-group-append\">%</span></div>",element=jQuery(html);return this.addValidationToElement(element)}}),Vtiger_Field_Js("Vtiger_Recurrence_Field_Js",{},{/**
		 * Function to get the pick list values
		 * @return <object> key value pair of options
		 */getPickListValues:function getPickListValues(){return this.get("picklistvalues")},/**
		 * Function to get the ui
		 * @return - select element and select2 element
		 */getUi:function getUi(){var html="<select class=\"select2 form-control\" name=\""+this.getName()+"\">",pickListValues=this.getPickListValues(),selectedOption=app.htmlDecode(this.getValue());for(var option in pickListValues)html+="<option value=\""+option+"\" ",option==selectedOption&&(html+=" selected "),html+=">"+pickListValues[option]+"</option>";html+="</select>";var selectContainer=jQuery(html);return this.addValidationToElement(selectContainer),selectContainer}});
//# sourceMappingURL=Field.min.js.map
