'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * Contributor(s): YetiForce S.A.
 *************************************************************************************/"use strict";function _slicedToArray(arr,i){return _arrayWithHoles(arr)||_iterableToArrayLimit(arr,i)||_unsupportedIterableToArray(arr,i)||_nonIterableRest()}function _nonIterableRest(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function _iterableToArrayLimit(r,l){var t=null==r?null:"undefined"!=typeof Symbol&&r[Symbol.iterator]||r["@@iterator"];if(null!=t){var e,n,i,u,a=[],f=!0,o=!1;try{if(i=(t=t.call(r)).next,0===l){if(Object(t)!==t)return;f=!1;}else for(;!(f=(e=i.call(t)).done)&&(a.push(e.value),a.length!==l);f=!0);}catch(r){o=!0,n=r;}finally{try{if(!f&&null!=t.return&&(u=t.return(),Object(u)!==u))return}finally{if(o)throw n}}return a}}function _arrayWithHoles(arr){if(Array.isArray(arr))return arr}function _createForOfIteratorHelper(o,allowArrayLike){var it="undefined"!=typeof Symbol&&o[Symbol.iterator]||o["@@iterator"];if(!it){if(Array.isArray(o)||(it=_unsupportedIterableToArray(o))||allowArrayLike&&o&&"number"==typeof o.length){it&&(o=it);var i=0,F=function(){};return {s:F,n:function n(){return i>=o.length?{done:!0}:{done:!1,value:o[i++]}},e:function e(_e){throw _e},f:F}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}var err,normalCompletion=!0,didErr=!1;return {s:function s(){it=it.call(o);},n:function n(){var step=it.next();return normalCompletion=step.done,step},e:function e(_e2){didErr=!0,err=_e2;},f:function f(){try{normalCompletion||null==it.return||it.return();}finally{if(didErr)throw err}}}}function _unsupportedIterableToArray(o,minLen){if(o){if("string"==typeof o)return _arrayLikeToArray(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);return "Object"===n&&o.constructor&&(n=o.constructor.name),"Map"===n||"Set"===n?Array.from(o):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?_arrayLikeToArray(o,minLen):void 0}}function _arrayLikeToArray(arr,len){(null==len||len>arr.length)&&(len=arr.length);for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2}//Calendar Specific validators
// We have placed it here since quick create will not load module specific validators
Vtiger_Base_Validator_Js("Vtiger_Email_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var emailInstance=new Vtiger_Email_Validator_Js;emailInstance.setElement(field);var response=emailInstance.validate();if(!0!=response)return emailInstance.getError()}},{/**
		 *Overwrites base function to avoid trimming and validate white spaces
		 * @return fieldValue
		 * */getFieldValue:function getFieldValue(){return this.getElement().val()},/**
		 * Function to validate the email field data
		 */validate:function validate(){var fieldValue=this.getFieldValue();return this.validateValue(fieldValue)},/**
		 * Function to validate the email field data
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validateValue:function validateValue(fieldValue){if(!/^[a-zA-Z0-9.!#$%&'*+\/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+$/.test(fieldValue))return this.setError(app.vtranslate("JS_PLEASE_ENTER_VALID_EMAIL_ADDRESS")),!1;if(fieldValue.match(/[\(\)\<\>\,\;\:\\\"\[\]]/))return this.setError(app.vtranslate("JS_CONTAINS_ILLEGAL_CHARACTERS")),!1;var field=this.getElement(),fieldData=field.data(),fieldInfo=fieldData.fieldinfo;return !(fieldInfo&&fieldInfo.restrictedDomains&&-1!==fieldInfo.restrictedDomains.indexOf(fieldValue.split("@").pop()))||(this.setError(app.vtranslate("JS_EMAIL_RESTRICTED_DOMAINS")),!1)}}),Vtiger_Base_Validator_Js("Vtiger_Phone_Validator_Js",{},{/**
		 * Function to validate the phone field data
		 */validate:function validate(){var fieldValue=this.getFieldValue();return this.validateValue(fieldValue)},/**
		 * Function to validate the phone field data
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validateValue:function validateValue(fieldValue){if(""==fieldValue)return !0;var field=this.getElement(),form=field.closest("form"),fieldData=field.data(),result=!0;if(1==fieldData.advancedVerification){var thisInstance=this,fieldInfo=fieldData.fieldinfo,group=field.closest(".input-group"),phoneCountryList=group.find(".phoneCountryList"),isReadOnly=field.get(0).readOnly;isReadOnly||field.attr("readonly",!0);var moduleName=form.find("[name=\"module\"]").length?form.find("[name=\"module\"]").val():app.getModuleName();"LayoutEditor"===moduleName&&(moduleName=$("#selectedModuleName").val()),AppConnector.request({async:!1,data:{module:moduleName,action:"Fields",mode:"verifyPhoneNumber",fieldName:fieldInfo.name,phoneNumber:fieldValue,phoneCountry:phoneCountryList.val()}}).done(function(data){!1==data.result.isValidNumber?(thisInstance.setError(data.result.message),result=!1):(field.val(data.result.number),field.attr("title",data.result.geocoding+" "+data.result.carrier),phoneCountryList.val()!=data.result.country&&phoneCountryList.val(data.result.country).trigger("change")),isReadOnly||field.attr("readonly",!1);}).fail(function(error,err){thisInstance.setError(app.vtranslate("JS_ERROR")),result=!1,app.errorLog(error,err);});}return result}}),Vtiger_Base_Validator_Js("Vtiger_UserName_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var usernameInstance=new Vtiger_UserName_Validator_Js;usernameInstance.setElement(field);var response=usernameInstance.validate();if(!0!=response)return usernameInstance.getError()}},{/**
		 * Function to validate the User Name
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var fieldValue=this.getFieldValue(),fieldData=this.getElement().data(),maximumLength="undefined"==typeof fieldData.fieldinfo?"3,64":fieldData.fieldinfo.maximumlength,ranges=maximumLength.split(",");if(fieldValue.length<parseInt(ranges[0]))return this.setError(app.vtranslate("JS_ENTERED_VALUE_IS_TOO_SHORT")),!1;if(fieldValue.length>parseInt(ranges[1]))return this.setError(app.vtranslate("JS_ENTERED_VALUE_IS_TOO_LONG")),!1;return !!/^[a-zA-Z0-9_.@-]+$/.test(fieldValue)||(this.setError(app.vtranslate("JS_CONTAINS_ILLEGAL_CHARACTERS")),!1)}}),Vtiger_Base_Validator_Js("Vtiger_Integer_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var integerInstance=new Vtiger_Integer_Validator_Js;integerInstance.setElement(field);var response=integerInstance.validate();if(!0!=response)return integerInstance.getError()}},{/**
		 * Function to validate the Integre field data
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var fieldValue=this.getFieldValue(),groupSeperator=CONFIG.currencyGroupingSeparator,integerRegex=new RegExp("(^[-+]?[\\d\\"+groupSeperator+"]+)$","g");if(!fieldValue.match(integerRegex)){var errorInfo=app.vtranslate("JS_PLEASE_ENTER_INTEGER_VALUE");return this.setError(errorInfo),!1}var fieldInfo=this.getElement().data().fieldinfo;if(!fieldInfo||!fieldInfo.maximumlength)return !0;var ranges=fieldInfo.maximumlength.split(",");if(2===ranges.length){if(fieldValue>parseFloat(ranges[1])||fieldValue<parseFloat(ranges[0]))return errorInfo=app.vtranslate("JS_ERROR_MAX_VALUE"),this.setError(errorInfo),!1;}else if(fieldValue>parseFloat(ranges[0])||0>fieldValue)return errorInfo=app.vtranslate("JS_ERROR_MAX_VALUE"),this.setError(errorInfo),!1;return !0}}),Vtiger_Base_Validator_Js("Vtiger_Double_Validator_Js",{/**
		 * Function which invokes field validation
		 * @param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var doubleValidator=new Vtiger_Double_Validator_Js;if(doubleValidator.setElement(field),!doubleValidator.validate())return doubleValidator.getError()}},{/**
		 * Function to validate the Decimal field data
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var response=this._super();if(!0===response){var fieldValue=this.getFieldValue();if(!fieldValue.toString().match(/(^[-+]?\d+)(\.\d+)?$/))return this.setError(app.vtranslate("JS_PLEASE_ENTER_DECIMAL_VALUE")),!1;var fieldInfo=this.getElement().data().fieldinfo;if(!fieldInfo||!fieldInfo.maximumlength)return !0;var maximumLength=fieldInfo.maximumlength,minimumLength=-maximumLength;fieldValue=parseFloat(fieldValue);var ranges=maximumLength.split(",");if(2===ranges.length&&(maximumLength=ranges[1],minimumLength=ranges[0]),fieldValue>parseFloat(maximumLength)||fieldValue<parseFloat(minimumLength))return this.setError(app.vtranslate("JS_ERROR_MAX_VALUE")),!1}return response},/**
		 * Overwrites base function to avoid trimming and validate white spaces
		 * @return fieldValue
		 * */getFieldValue:function getFieldValue(){return App.Fields.Double.formatToDb(this.getElement().val())}}),Vtiger_Base_Validator_Js("Vtiger_PositiveNumber_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var positiveNumberInstance=new Vtiger_PositiveNumber_Validator_Js;positiveNumberInstance.setElement(field);var response=positiveNumberInstance.validate();if(!0!=response)return positiveNumberInstance.getError()}},{/**
		 * Function to validate the Positive Numbers
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var response=this._super();if(!0!==response)return response;var fieldValue=this.getFieldValue();if(isNaN(fieldValue)||0>fieldValue||fieldValue.toString().match(/(^[-]+\d+)$/))return this.setError(app.vtranslate("JS_ACCEPT_POSITIVE_NUMBER")),!1;var maximumLength=null;if(maximumLength=this.getElement().data().fieldinfo?this.getElement().data().fieldinfo.maximumlength:this.getElement().data("maximumlength"),!maximumLength)return !0;var ranges=maximumLength.split(",");if(2===ranges.length){if(fieldValue>parseFloat(ranges[1])||fieldValue<parseFloat(ranges[0]))return this.setError(app.vtranslate("JS_ERROR_MAX_VALUE")),!1;}else if(fieldValue>parseFloat(ranges[0])||0>fieldValue)return this.setError(app.vtranslate("JS_ERROR_MAX_VALUE")),!1;return !0},/**
		 * Overwrites base function to avoid trimming and validate white spaces
		 * @return fieldValue
		 * */getFieldValue:function getFieldValue(){return App.Fields.Double.formatToDb(this.getElement().val())}}),Vtiger_PositiveNumber_Validator_Js("Vtiger_Percentage_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var percentageInstance=new Vtiger_Percentage_Validator_Js;if(percentageInstance.setElement(field),!percentageInstance.validate())return percentageInstance.getError()}},{/**
		 * Function to validate the percentage field data
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var response=this._super();return !0===response?!(100<this.getFieldValue())||(this.setError(app.vtranslate("JS_PERCENTAGE_VALUE_SHOULD_BE_LESS_THAN_100")),!1):response},/**
		 * Overwrites base function to avoid trimming and validate white spaces
		 * @return fieldValue
		 * */getFieldValue:function getFieldValue(){return App.Fields.Double.formatToDb(this.getElement().val())}}),Vtiger_Base_Validator_Js("Vtiger_Url_Validator_Js",{invokeValidation:function invokeValidation(field){var validatorInstance=new Vtiger_Url_Validator_Js;validatorInstance.setElement(field);var result=validatorInstance.validate();return !0===result?result:validatorInstance.getError()}},{/**
		 * Function to validate the Url
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var fieldValue=this.getFieldValue(),result=/(^|\s)((https?:\/\/)?[\w-]+(\.[\w-]+)+\.?(:\d+)?(\/\S*)?)/gi.test(fieldValue);if(result||0!==fieldValue.indexOf("http://")&&0!==fieldValue.indexOf("https://")&&0!==fieldValue.indexOf("ftp://")&&0!==fieldValue.indexOf("ftps://")&&0!==fieldValue.indexOf("telnet://")&&0!==fieldValue.indexOf("smb://")&&0!==fieldValue.indexOf("www.")||(result=!0),!result){var errorInfo=app.vtranslate("JS_CONTAINS_ILLEGAL_CHARACTERS");//"Please enter valid url";
return this.setError(errorInfo),!1}return !0}}),Vtiger_Base_Validator_Js("Vtiger_MultiSelect_Validator_Js",{invokeValidation:function invokeValidation(field){var validatorInstance=new Vtiger_MultiSelect_Validator_Js;validatorInstance.setElement(field);var result=validatorInstance.validate();return !0==result?result:validatorInstance.getError()}},{/**
		 * Function to validate the Multi select
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var fieldInstance=this.getElement(),selectElementValue=fieldInstance.val();if(null==selectElementValue){var errorInfo=app.vtranslate("JS_PLEASE_SELECT_ATLEAST_ONE_OPTION");return this.setError(errorInfo),!1}return !0}}),Vtiger_Base_Validator_Js("Vtiger_MultiDomain_Validator_Js",{invokeValidation:function invokeValidation(field){var validatorInstance=new Vtiger_MultiDomain_Validator_Js;validatorInstance.setElement(field);var result=validatorInstance.validate();return !0===result?result:validatorInstance.getError()}},{/**
		 * Function to validate the Multi Domain select
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var fieldInstance=this.getElement(),selectElementValue=fieldInstance.val();if(Array.isArray(selectElementValue)){var _step,_iterator=_createForOfIteratorHelper(selectElementValue);try{for(_iterator.s();!(_step=_iterator.n()).done;){var value=_step.value;if(value&&!/(?:[0-9a-z\u017F\u212A](?:[\x2D0-9a-z\u017F\u212A]{0,61}[0-9a-z\u017F\u212A])?\.)+[0-9a-z\u017F\u212A][\x2D0-9a-z\u017F\u212A]{0,61}[0-9a-z\u017F\u212A]/i.test(value))return this.setError(app.vtranslate("JS_PLEASE_SELECT_VALID_DOMAIN_NAMES")),!1}}catch(err){_iterator.e(err);}finally{_iterator.f();}}return !0}}),Vtiger_Double_Validator_Js("Vtiger_GreaterThanZero_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var GreaterThanZeroInstance=new Vtiger_GreaterThanZero_Validator_Js;GreaterThanZeroInstance.setElement(field);var response=GreaterThanZeroInstance.validate();if(!0!=response)return GreaterThanZeroInstance.getError()}},{/**
		 * Function to validate the Positive Numbers and greater than zero value
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var response=this._super();if(!0!=response)return response;var fieldValue=this.getFieldValue();if(0>=fieldValue){var errorInfo=app.vtranslate("JS_VALUE_SHOULD_BE_GREATER_THAN_ZERO");return this.setError(errorInfo),!1}return !0}}),Vtiger_PositiveNumber_Validator_Js("Vtiger_WholeNumber_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var instance=new Vtiger_WholeNumber_Validator_Js;instance.setElement(field);var response=instance.validate();if(!0!=response)return instance.getError()}},{/**
		 * Function to validate the Positive Numbers and whole Number
		 * @return boolean true if validation is successful or false if validation error occurs
		 */validate:function validate(){var response=this._super();if(!0!==response)return response;var errorInfo,field=this.getElement(),fieldValue=this.getFieldValue(),fieldData=field.data(),fieldInfo=fieldData.fieldinfo;return !(0!=fieldValue%1)||(errorInfo=jQuery.isEmptyObject(fieldInfo)?app.vtranslate("INVALID_NUMBER"):app.vtranslate("INVALID_NUMBER_OF")+" "+fieldInfo.label,this.setError(errorInfo),!1)}}),Vtiger_Base_Validator_Js("Vtiger_lessThanToday_Validator_Js",{},{/**
		 * Function to validate the birthday field
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var field=this.getElement(),fieldData=field.data(),fieldDateFormat=fieldData.dateFormat,fieldInfo=fieldData.fieldinfo,fieldValue=this.getFieldValue();try{var fieldDateInstance=App.Fields.Date.getDateInstance(fieldValue,fieldDateFormat);}catch(err){return this.setError(err),!1}fieldDateInstance.setHours(0,0,0,0);var todayDateInstance=new Date;todayDateInstance.setHours(0,0,0,0);if(0>=todayDateInstance-fieldDateInstance){var errorInfo=fieldInfo.label+" "+app.vtranslate("JS_SHOULD_BE_LESS_THAN_CURRENT_DATE");return this.setError(errorInfo),!1}return !0}}),Vtiger_Base_Validator_Js("Vtiger_lessThanOrEqualToToday_Validator_Js",{},{/**
		 * Function to validate the datesold field
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var field=this.getElement(),fieldData=field.data(),fieldDateFormat=fieldData.dateFormat,fieldInfo=fieldData.fieldinfo,fieldValue=this.getFieldValue();try{var fieldDateInstance=App.Fields.Date.getDateInstance(fieldValue,fieldDateFormat);}catch(err){return this.setError(err),!1}fieldDateInstance.setHours(0,0,0,0);var todayDateInstance=new Date;todayDateInstance.setHours(0,0,0,0);if(0>todayDateInstance-fieldDateInstance){var errorInfo=fieldInfo.label+" "+app.vtranslate("JS_SHOULD_BE_LESS_THAN_OR_EQUAL_TO")+" "+app.vtranslate("JS_CURRENT_DATE");return this.setError(errorInfo),!1}return !0}}),Vtiger_Base_Validator_Js("Vtiger_greaterThanOrEqualToToday_Validator_Js",{},{/**
		 * Function to validate the dateinservice field
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var field=this.getElement(),fieldData=field.data(),fieldDateFormat=fieldData.dateFormat,fieldInfo=fieldData.fieldinfo,fieldValue=this.getFieldValue();try{var fieldDateInstance=App.Fields.Date.getDateInstance(fieldValue,fieldDateFormat);}catch(err){return this.setError(err),!1}fieldDateInstance.setHours(0,0,0,0);var todayDateInstance=new Date;todayDateInstance.setHours(0,0,0,0);if(0<todayDateInstance-fieldDateInstance){var errorInfo=fieldInfo.label+" "+app.vtranslate("JS_SHOULD_BE_GREATER_THAN_OR_EQUAL_TO")+" "+app.vtranslate("JS_CURRENT_DATE");return this.setError(errorInfo),!1}return !0}}),Vtiger_Base_Validator_Js("Vtiger_greaterThanDependentField_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var fieldForValidation=field[0];if("followup_date_start"==jQuery(fieldForValidation).attr("name"))var dependentFieldList=new Array("date_start");var instance=new Vtiger_greaterThanDependentField_Validator_Js;instance.setElement(field);var response=instance.validate(dependentFieldList);if(!0!=response)return instance.getError()}},{/**
		 * Function to validate the birthday field
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(dependentFieldList){var fieldLabel,field=this.getElement(),fieldInfo=field.data("fieldinfo");fieldLabel="undefined"==typeof fieldInfo?jQuery(field).attr("name"):fieldInfo.label;for(var contextFormElem=field.closest("form"),i=0;i<dependentFieldList.length;i++){var dependentField=dependentFieldList[i],dependentFieldInContext=jQuery("input[name="+dependentField+"]",contextFormElem);if(0<dependentFieldInContext.length){var value=void 0,dependentValue=void 0;-1===$.inArray(dependentFieldInContext.data("fieldinfo").type,["currency","number","decimal"])?(value=this.getDateTimeInstance(field),dependentValue=this.getDateTimeInstance(dependentFieldInContext)):(value=App.Fields.Double.formatToDb(field.val()),dependentValue=App.Fields.Double.formatToDb(dependentFieldInContext.val()));var dependentFieldLabel=dependentFieldInContext.data("fieldinfo").label,comparedDateVal=value-dependentValue;if(0>comparedDateVal){var errorInfo=fieldLabel+" "+app.vtranslate("JS_SHOULD_BE_GREATER_THAN_OR_EQUAL_TO")+" "+dependentFieldLabel+"";return this.setError(errorInfo),!1}}}return !0},getDateTimeInstance:function getDateTimeInstance(field){var dateFormat=field.data("dateFormat"),fieldValue=field.val();try{var dateTimeInstance=App.Fields.Date.getDateInstance(fieldValue,dateFormat);}catch(err){return this.setError(err),!1}return dateTimeInstance}}),Vtiger_Base_Validator_Js("Vtiger_dateAndTimeGreaterThanDependentField_Validator_Js",{},{fieldDateTime:"",fieldDateTimeInstance:[],dateFormat:"",/**
		 * Function to validate the date field
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(dependentFieldList){var thisInstance=this,field=this.getElement(),fieldDateTime="",fieldDateTimeInstance=[],contextFormElem=field.closest("form"),view=contextFormElem.attr("name"),j=0;if("EditView"==view&&0<contextFormElem.data("jqv").InvalidFields.length){var invalidFields=contextFormElem.data("jqv").InvalidFields.map(function(e){return e.attributes.name.value});if(0<invalidFields.filter(function(value){return dependentFieldList.includes(value)}).length)return !1}for(var i in dependentFieldList){var dependentField=dependentFieldList[i],dependentFieldInContext=jQuery("input[name="+dependentField+"]",contextFormElem);if(0<dependentFieldInContext.length)if("undefined"==typeof dependentFieldInContext.data("dateFormat")&&fieldDateTime)fieldDateTime+=" "+dependentFieldInContext.val(),fieldDateTimeInstance[j]=App.Fields.Date.getDateInstance(fieldDateTime,dateFormat),j++;else if("undefined"!=typeof dependentFieldInContext.data("dateFormat")){var dateFormat=dependentFieldInContext.data("dateFormat");fieldDateTime=dependentFieldInContext.val();}}return thisInstance.difference(fieldDateTimeInstance)},difference:function difference(fieldDateTimeInstance){if(2==fieldDateTimeInstance.length){var comparedDateVal=fieldDateTimeInstance[1]-fieldDateTimeInstance[0];if(0>comparedDateVal){var errorInfo=app.vtranslate("JS_AN_INCORRECT_RANGE_OF_DATES_WAS_ENTERED");return this.setError(errorInfo),!1}}return !0}}),Vtiger_Base_Validator_Js("Vtiger_futureEventCannotBeHeld_Validator_Js",{},{/**
		 * Function to validate event status , which cannot be held for future events
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(dependentFieldList){for(var field=this.getElement(),fieldLabel=field.data("fieldinfo").label,status=field.val(),contextFormElem=field.closest("form"),i=0;i<dependentFieldList.length;i++){var dependentField=dependentFieldList[i],dependentFieldInContext=jQuery("input[name="+dependentField+"]",contextFormElem);if(0<dependentFieldInContext.length){var dependentFieldLabel=dependentFieldInContext.data("fieldinfo").label,todayDateInstance=new Date,dateFormat=dependentFieldInContext.data("dateFormat"),time=jQuery("input[name=time_start]",contextFormElem),fieldValue=dependentFieldInContext.val()+" "+time.val(),dependentFieldDateInstance=App.Fields.Date.getDateInstance(fieldValue,dateFormat),comparedDateVal=todayDateInstance-dependentFieldDateInstance;if(0>comparedDateVal&&"Held"==status){var errorInfo=fieldLabel+" "+app.vtranslate("JS_FUTURE_EVENT_CANNOT_BE_HELD")+" "+dependentFieldLabel+"";return this.setError(errorInfo),!1}}}return !0}}),Vtiger_Base_Validator_Js("Vtiger_lessThanDependentField_Validator_Js",{},{/**
		 * Function to validate the birthday field
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(dependentFieldList){var field=this.getElement(),fieldInfo=field.data("fieldinfo"),fieldLabel=fieldInfo.label,contextFormElem=field.closest("form");//No need to validate if value is empty
if(0!=field.val().length){for(var i=0;i<dependentFieldList.length;i++){var dependentField=dependentFieldList[i],dependentFieldInContext=jQuery("input[name="+dependentField+"]",contextFormElem);if(0<dependentFieldInContext.length){var value=void 0,dependentValue=void 0;-1===$.inArray(fieldInfo.type,["currency","number","decimal"])?(value=this.getDateTimeInstance(field),dependentValue=this.getDateTimeInstance(dependentFieldInContext)):(value=App.Fields.Double.formatToDb(field.val()),dependentValue=App.Fields.Double.formatToDb(dependentFieldInContext.val()));var dependentFieldLabel=dependentFieldInContext.data("fieldinfo").label;//No need to validate if value is empty
if(0==dependentFieldInContext.val().length)continue;var comparedDateVal=value-dependentValue;if(0<comparedDateVal){var errorInfo=fieldLabel+" "+app.vtranslate("JS_SHOULD_BE_LESS_THAN_OR_EQUAL_TO")+" "+dependentFieldLabel+"";return this.setError(errorInfo),!1}}}return !0}},getDateTimeInstance:function getDateTimeInstance(field){var dateFormat=field.data("dateFormat"),fieldValue=field.val();try{var dateTimeInstance=App.Fields.Date.getDateInstance(fieldValue,dateFormat);}catch(err){return this.setError(err),!1}return dateTimeInstance}}),Vtiger_Base_Validator_Js("Vtiger_Currency_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var currencyValidatorInstance=new Vtiger_Currency_Validator_Js;currencyValidatorInstance.setElement(field);var response=currencyValidatorInstance.validate();if(!0!=response)return currencyValidatorInstance.getError()}},{/**
		 * Function to validate the Currency Field
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var response=this._super();if(!0!=response)return response;var fieldData=this.getElement().data(),decimalSeparator=fieldData.decimalSeparator?fieldData.decimalSeparator:CONFIG.currencyDecimalSeparator,groupSeparator=fieldData.groupSeparator?fieldData.groupSeparator:CONFIG.currencyGroupingSeparator,strippedValue=this.getFieldValue().replace(decimalSeparator,"."),spacePattern=/\s/;(spacePattern.test(decimalSeparator)||spacePattern.test(groupSeparator))&&(strippedValue=strippedValue.replace(/ /g,""));var errorInfo;"$"===groupSeparator&&(groupSeparator="\\$"),"."===groupSeparator&&(groupSeparator="\\.");var regex=new RegExp(groupSeparator,"g");if(strippedValue=strippedValue.replace(regex,""),isNaN(strippedValue))return errorInfo=app.vtranslate("JS_CONTAINS_ILLEGAL_CHARACTERS"),this.setError(errorInfo),!1;var negativeNumber=fieldData.fieldinfo&&"NN"===fieldData.fieldinfo.fieldtype;if(!negativeNumber&&0>strippedValue)return errorInfo=app.vtranslate("JS_ACCEPT_POSITIVE_NUMBER"),this.setError(errorInfo),!1;var maximumLength="undefined"==typeof fieldData.fieldinfo?null:fieldData.fieldinfo.maximumlength;if(maximumLength){maximumLength=String(maximumLength);var ranges=maximumLength.split(",");if(2===ranges.length&&(strippedValue>parseFloat(ranges[1])||strippedValue<parseFloat(ranges[0]))||1===ranges.length&&(strippedValue>parseFloat(ranges[0])||0>strippedValue))return errorInfo=app.vtranslate("JS_ERROR_MAX_VALUE"),this.setError(errorInfo),!1}return !0}}),Vtiger_Currency_Validator_Js("Vtiger_NumberUserFormat_Validator_Js",{/**
	 *Function which invokes field validation
	 * @param accepts field element as parameter
	 * @return error if validation fails true on success
	 */invokeValidation:function invokeValidation(field){var instance=new Vtiger_Currency_Validator_Js;if(instance.setElement(field),!0!==instance.validate())return instance.getError()}}),Vtiger_Base_Validator_Js("Vtiger_ReferenceField_Validator_Js",{},{/**
		 * Function to validate the Positive Numbers and whole Number
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var field=this.getElement(),parentElement=field.closest(".fieldValue"),referenceField=parentElement.find(".sourceField"),referenceFieldValue=referenceField.val();if(""==referenceFieldValue){var errorInfo=app.vtranslate("JS_REQUIRED_FIELD");return this.setError(errorInfo),!1}return !0}}),Vtiger_Base_Validator_Js("Vtiger_Date_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var dateValidatorInstance=new Vtiger_Date_Validator_Js;dateValidatorInstance.setElement(field);var response=dateValidatorInstance.validate();return !0==response?response:dateValidatorInstance.getError()}},{/**
		 * Function to validate the Positive Numbers and whole Number
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var field=this.getElement(),fieldData=field.data(),fieldDateFormat=fieldData.dateFormat,fieldValue=this.getFieldValue();try{if("range"!==fieldData.calendarType)fieldValue=[fieldValue];else if(fieldValue=fieldValue.split(","),2!==fieldValue.length)throw new Error;fieldValue.forEach(function(key){App.Fields.Date.getDateInstance(key,fieldDateFormat);});}catch(err){var errorInfo=app.vtranslate("JS_PLEASE_ENTER_VALID_DATE");return this.setError(errorInfo),!1}return !0}}),Vtiger_Date_Validator_Js("Vtiger_Datetime_Validator_Js",{},{}),Vtiger_Base_Validator_Js("Vtiger_Time_Validator_Js",{/**
		 * Function which invokes field validation
		 * @param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var validatorInstance=new Vtiger_Time_Validator_Js;validatorInstance.setElement(field);var result=validatorInstance.validate();return !0==result?result:validatorInstance.getError()}},{/**
		 * Function to validate the Time Fields
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var format=CONFIG.hourFormat;this.field.data("format")&&-1!=[12,24].indexOf(this.field.data("format"))&&(format=this.field.data("format"));var regexp="";switch(format){case 12:regexp=/^([0][0-9]|1[0-2]):([0-5][0-9])([ ]PM|[ ]AM|PM|AM)$/;break;default:regexp=/^(2[0-3]|[0][0-9]|1[0-9]):([0-5][0-9])$/;}if(!regexp.test(this.getFieldValue())){var errorInfo=app.vtranslate("JS_PLEASE_ENTER_VALID_TIME");return this.setError(errorInfo),!1}return !0}}),Vtiger_Base_Validator_Js("Vtiger_Twitter_Validator_Js",{/**
		 * Function which invokes field validation
		 * @param {jQuery} field - accepts field element as parameter
		 * @return string|true - error text if validation fails, true on success
		 */invokeValidation:function invokeValidation(field){var validatorInstance=new Vtiger_Twitter_Validator_Js;validatorInstance.setElement(field);var result=validatorInstance.validate();return !0==result?result:validatorInstance.getError()}},{/**
		 * Function to validate the Twwiter Account
		 * @return bool true if validation is successfull
		 */validate:function validate(){var fieldValue=this.getFieldValue();return !!fieldValue.match(/^[a-zA-Z0-9_]{1,15}$/g)||(this.setError(app.vtranslate("JS_PLEASE_ENTER_VALID_TWITTER_ACCOUNT")),!1)}}),Vtiger_Email_Validator_Js("Vtiger_MultiEmail_Validator_Js",{/**
		 * Function which invokes field validation
		 * @param {jQuery} field - accepts field element as parameter
		 * @return string|true - error text if validation fails, true on success
		 */invokeValidation:function invokeValidation(field){var validatorInstance=new Vtiger_MultiEmail_Validator_Js;validatorInstance.setElement(field);var result=validatorInstance.validate();return !0==result?result:validatorInstance.getError()}},{/**
		 * Function to validate the Multi email. Check if the email address is duplicated.
		 * @return bool true if validation is successfull
		 */validate:function validate(){var fieldValue=this.getFieldValue();if(""===fieldValue)return !0;if(!1===this.validateValue(fieldValue))return !1;for(var inputField,allFields=$(this.field).closest("div.js-multi-email").eq(0).find(".js-multi-email-item"),arrayLength=allFields.length,amountOfDuplicateEmails=0,i=0;i<arrayLength;++i)if((inputField=$(allFields[i]).find("input.js-multi-email"),""!==inputField.val())&&(inputField.val()===fieldValue&&++amountOfDuplicateEmails,2<=amountOfDuplicateEmails))return this.setError(app.vtranslate("JS_EMAIL_DUPLICATED")),!1;return !0}}),Vtiger_greaterThanDependentField_Validator_Js("Calendar_greaterThanDependentField_Validator_Js",{},{getDateTimeInstance:function getDateTimeInstance(field){var timeField,timeFieldValue,form=field.closest("form");"date_start"===field.attr("name")?(timeField=form.find("[name=\"time_start\"]"),timeFieldValue=timeField.val()):"due_date"===field.attr("name")&&(timeField=form.find("[name=\"time_end\"]"),timeFieldValue=0<timeField.length?timeField.val():"11:59 PM");var dateFieldValue=field.val()+" "+timeFieldValue,dateFormat=field.data("dateFormat");return App.Fields.Date.getDateInstance(dateFieldValue,dateFormat)}}),Vtiger_Base_Validator_Js("Calendar_greaterThanToday_Validator_Js",{},{/**
		 * Function to validate the birthday field
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var field=this.getElement(),fieldData=field.data(),fieldDateFormat=fieldData.dateFormat,fieldInfo=fieldData.fieldinfo,fieldValue=this.getFieldValue();try{var fieldDateInstance=App.Fields.Date.getDateInstance(fieldValue,fieldDateFormat);}catch(err){return this.setError(err),!1}fieldDateInstance.setHours(0,0,0,0);var todayDateInstance=new Date;todayDateInstance.setHours(0,0,0,0);if(0<=todayDateInstance-fieldDateInstance){var errorInfo=fieldInfo.label+" "+app.vtranslate("JS_SHOULD_BE_GREATER_THAN_CURRENT_DATE");return this.setError(errorInfo),!1}return !0}}),Vtiger_Base_Validator_Js("Calendar_RepeatMonthDate_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var repeatMonthDateValidatorInstance=new Calendar_RepeatMonthDate_Validator_Js;repeatMonthDateValidatorInstance.setElement(field);var response=repeatMonthDateValidatorInstance.validate();if(!0!=response)return repeatMonthDateValidatorInstance.getError()}},{/**
		 * Function to validate the Positive Numbers and whole Number
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var fieldValue=this.getFieldValue();if(parseInt(parseFloat(fieldValue))!=fieldValue||""==fieldValue||"31"<parseInt(fieldValue)||0>=parseInt(fieldValue)){var result=app.vtranslate("JS_NUMBER_SHOULD_BE_LESS_THAN_32");return this.setError(result),!1}return !0}}),Vtiger_WholeNumber_Validator_Js("Vtiger_WholeNumberGreaterThanZero_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var WholeNumberGreaterThanZero=new Vtiger_WholeNumberGreaterThanZero_Validator_Js;WholeNumberGreaterThanZero.setElement(field);var response=WholeNumberGreaterThanZero.validate();if(!0!=response)return WholeNumberGreaterThanZero.getError()}},{/**
		 * Function to validate the Positive Numbers and greater than zero value
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var response=this._super();if(!0!=response)return response;var fieldValue=this.getFieldValue();if(0==fieldValue){var errorInfo=app.vtranslate("JS_VALUE_SHOULD_BE_GREATER_THAN_ZERO");return this.setError(errorInfo),!1}return !0},/**
		 * Overwrites base function to avoid trimming and validate white spaces
		 * @return fieldValue
		 */getFieldValue:function getFieldValue(){return App.Fields.Double.formatToDb(this.getElement().val())}}),Vtiger_Base_Validator_Js("Vtiger_AlphaNumeric_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var alphaNumericInstance=new Vtiger_AlphaNumeric_Validator_Js;alphaNumericInstance.setElement(field);var response=alphaNumericInstance.validate();if(!0!=response)return alphaNumericInstance.getError()}},{/**
		 * Function to validate the Positive Numbers
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var field=this.getElement(),fieldValue=field.val();if(!fieldValue.match(/^[a-z0-9 _-]*$/i)){var errorInfo=app.vtranslate("JS_CONTAINS_ILLEGAL_CHARACTERS");return this.setError(errorInfo),!1}return !0}}),Vtiger_Base_Validator_Js("Vtiger_AlphaNumericWithSlashesCurlyBraces_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var alphaNumericInstance=new Vtiger_AlphaNumericWithSlashesCurlyBraces_Validator_Js;alphaNumericInstance.setElement(field);var response=alphaNumericInstance.validate();if(!0!=response)return alphaNumericInstance.getError()}},{/**
		 * Function to validate the Positive Numbers
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var field=this.getElement(),fieldValue=field.val();if(!fieldValue.match(/^[\/a-z\\0-9{}()$|: _-]*$/i)){var errorInfo=app.vtranslate("JS_CONTAINS_ILLEGAL_CHARACTERS");return this.setError(errorInfo),!1}return !0}}),Vtiger_Base_Validator_Js("Vtiger_InputMask_Validator_Js",{/**
		 *Function which invokes field validation
		 *@param accepts field element as parameter
		 * @return error if validation fails true on success
		 */invokeValidation:function invokeValidation(field){var maskInstance=new Vtiger_InputMask_Validator_Js;maskInstance.setElement(field);var response=maskInstance.validate();if(!0!=response)return maskInstance.getError()}},{/**
		 * Function to validate the Positive Numbers
		 * @return  boolean true if validation is successful false if validation error occurs
		 */validate:function validate(){var response=this._super();if(!0!==response)return response;var field=this.getElement();if(field.attr("data-inputmask")){var unMaskedValue=field.inputmask("unmaskedvalue"),getMetaData=field.inputmask("getmetadata"),maskLength=(getMetaData.match(/9/g)||[]).length+(getMetaData.match(/A/g)||[]).length+(getMetaData.match(/'*'/g)||[]).length;if(0!==unMaskedValue.length&&maskLength>unMaskedValue.length)return this.setError(app.vtranslate("JS_INVALID_LENGTH")),!1}return !0}}),Vtiger_Base_Validator_Js("Vtiger_Textparser_Validator_Js",{invokeValidation:function invokeValidation(field){var instance=new Vtiger_TextParser_Validator_Js;instance.setElement(field);var response=instance.validate();if(!0!=response)return instance.getError()}},{validate:function validate(){var response=this._super();if(!0!=response)return response;var field=this.getElement(),fieldValue=field.val();if(!/^\$\((\w+) : ([,"\+\-\[\]\&\w\s\|]+)\)\$$/.test(fieldValue)){var errorInfo=app.vtranslate("JS_INVALID_LENGTH");return this.setError(errorInfo),!1}return !0}}),Vtiger_Base_Validator_Js("Vtiger_YetiForceCompanyName_Validator_Js",{invokeValidation:function invokeValidation(field){var instance=new Vtiger_YetiForceCompanyName_Validator_Js;instance.setElement(field);var response=instance.validate();if(!0!=response)return instance.getError()}},{validate:function validate(){var response=this._super();if(!0!=response)return response;var field=this.getElement(),fieldValue=field.val();return !(0<=fieldValue.toLowerCase().indexOf("yetiforce"))||(this.setError(app.vtranslate("JS_YETIFORCE_COMPANY_NAME_NOT_ALLOWED")),!1)}}),Vtiger_Base_Validator_Js("Vtiger_MultiImage_Validator_Js",{invokeValidation:function invokeValidation(field){var instance=new Vtiger_MultiImage_Validator_Js;if(instance.setElement(field),!0!=instance.validate())return instance.getError()}},{validate:function validate(){var response=this._super();if(!0!=response)return response;var field=this.getElement(),fieldValue=field.val();return !(field.data("fieldinfo").mandatory&&0===JSON.parse(fieldValue).length)||(this.setError(app.vtranslate("JS_REQUIRED_FIELD")),!1)}}),Vtiger_Base_Validator_Js("Vtiger_MaxSizeInByte_Validator_Js",{invokeValidation:function invokeValidation(field){var instance=new Vtiger_MaxSizeInByte_Validator_Js;if(instance.setElement(field),!0!=instance.validate())return instance.getError()}},{validate:function validate(){var response=this._super();if(!0!==response)return response;var field=this.getElement();if("undefined"==typeof field.data("fieldinfo"))return !0;var maximumlength=field.data("fieldinfo").maximumlength;if(maximumlength){maximumlength=String(maximumlength);var fieldValue=field.val(),currentTextLength="function"==typeof TextEncoder?new TextEncoder().encode(fieldValue).byteLength:fieldValue.length,_maximumlength$split=maximumlength.split(","),_maximumlength$split2=_slicedToArray(_maximumlength$split,2),min=_maximumlength$split2[0],max=_maximumlength$split2[1];if(void 0===max&&(max=min,min=null),currentTextLength&&min&&currentTextLength<parseInt(min))return this.setError(app.vtranslate("JS_ENTERED_VALUE_IS_TOO_SHORT")),!1;if(max&&currentTextLength>parseInt(max))return this.setError(app.vtranslate("JS_MAXIMUM_TEXT_SIZE_IN_BYTES")+": "+parseInt(max)),!1}return !0}}),Vtiger_Base_Validator_Js("Vtiger_FieldName_Validator_Js",{invokeValidation:function invokeValidation(field){var instance=new Vtiger_FieldName_Validator_Js;if(instance.setElement(field),!0!=instance.validate())return instance.getError()}},{/**
		 * Function to validate the field name
		 * @return true if validation is successfull
		 * @return false if validation error occurs
		 */validate:function validate(){var fieldValue=this.getFieldValue();return "data"!==fieldValue||(this.setError(app.vtranslate("JS_CONTAINS_ILLEGAL_CHARACTERS")),!1)}}),Vtiger_Double_Validator_Js("Vtiger_Advpercentage_Validator_Js",{}),Vtiger_Base_Validator_Js("Vtiger_Mapcoordinates_Validator_Js",{/**
		 * Function which invokes field validation
		 * @param {jQuery} field - accepts field element as parameter
		 * @return string|true - error text if validation fails, true on success
		 */invokeValidation:function invokeValidation(field){var validatorInstance=new Vtiger_Mapcoordinates_Validator_Js;validatorInstance.setElement(field);var result=validatorInstance.validate();return !0==result?result:validatorInstance.getError()}},{/**
		 * Function to validate the coordinates field data
		 * @return {boolean}
		 */validate:function validate(){var fieldValue=this.getFieldValue();if(""!==fieldValue){var element=this.getElement(),key=element.data("key"),result=!1;switch(element.data("type")){case"decimal":result=this.validateDecimal(fieldValue,key);break;case"degrees":result=this.validateDegrees(fieldValue,key);break;default:result=this.validateCodeplus(fieldValue);}return result||this.setError(app.vtranslate("JS_INVALID_COORDINATES")),result}},/**
		 * Function to validate the coordinates decimal field data
		 * @return {boolean}
		 */validateDecimal:function validateDecimal(fieldValue,key){var result=!1;return result="lat"===key?/^\(?[+-]?(90(\.0+)?|[1-8]?\d(\.\d+)?)$/.test(fieldValue):/^\s?[+-]?(180(\.0+)?|1[0-7]\d(\.\d+)?|\d{1,2}(\.\d+)?)\)?$/.test(fieldValue),result},/**
		 * Function to validate the coordinates degrees field data
		 * @return {boolean}
		 */validateDegrees:function validateDegrees(fieldValue,key){var result=!1;if("lat"===key){result=/^[+-]?((90[°|\s]\s*)(0{1,2}['|\s]\s*)(0{1,2}([.|,]0{1,20})?["|\s]\s*)|(([1-8]\d|\d)[°|\s]\s*)(([0-5]\d|\d)['|\s]\s*)(([0-5]\d|\d)([.|,]\d{1,20})?["|\s]\s*))[NSns]$/i.test(fieldValue);}else {result=/^[+-]?((180[°|\s]\s*)(0{1,2}['|\s]\s*)(0{1,2}([.|,]0{1,20})?["|\s]\s*)|((1[0-7]\d|\d\d|\d)[°|\s]\s*)(([0-5]\d|\d)['|\s]\s*)(([0-5]\d|\d)([.|,]\d{1,20})?["|\s]\s*))[EWew]$/i.test(fieldValue);}return result},/**
		 * Function to validate the coordinates code plus field data
		 * @return {boolean}
		 */validateCodeplus:function validateCodeplus(fieldValue){return /^[a-z0-9 +]+$/i.test(fieldValue)}});
//# sourceMappingURL=FieldValidator.min.js.map
