<?php

declare(strict_types=1);

namespace N1ebieski\KSEFClient\DTOs\Requests\Sessions;

use DOMDocument;
use N1ebieski\KSEFClient\ValueObjects\Requests\XmlNamespace;
use DOMElement;
use N1ebieski\KSEFClient\Contracts\DomSerializableInterface;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\DataWystFaKorygowanej;
use N1ebieski\KSEFClient\ValueObjects\Requests\Sessions\NrFaKorygowanej;

final class DaneFaKorygowanej implements DomSerializableInterface
{
    /**
     * @param DataWystFaKorygowanej $dataWystFaKorygowanej Data wystawienia faktury korygowanej
     * @param NrFaKorygowanej $nrFaKorygowanej Numer faktury korygowanej
     */
    public function __construct(
        public readonly DataWystFaKorygowanej $dataWystFaKorygowanej,
        public readonly NrFaKorygowanej $nrFaKorygowanej,
        public readonly NrKSeFGroup | NrKSeFNGroup $nrKSeFGroup
    ) {
    }

    public function toDom(): DOMDocument
    {
        $dom = new DOMDocument('1.0', 'UTF-8');
        $dom->formatOutput = true;

        $daneFaKorygowanej = $dom->createElementNS((string) XmlNamespace::Fa3->value, 'DaneFaKorygowanej');
        $dom->appendChild($daneFaKorygowanej);

        $dataWystFaKorygowanej = $dom->createElementNS((string) XmlNamespace::Fa3->value, 'DataWystFaKorygowanej');
        $dataWystFaKorygowanej->appendChild($dom->createTextNode((string) $this->dataWystFaKorygowanej));

        $daneFaKorygowanej->appendChild($dataWystFaKorygowanej);

        $nrFaKorygowanej = $dom->createElementNS((string) XmlNamespace::Fa3->value, 'NrFaKorygowanej');
        $nrFaKorygowanej->appendChild($dom->createTextNode((string) $this->nrFaKorygowanej));

        $daneFaKorygowanej->appendChild($nrFaKorygowanej);

        /** @var DOMElement $nrKSeFGroup */
        $nrKSeFGroup = $this->nrKSeFGroup->toDom()->documentElement;

        foreach ($nrKSeFGroup->childNodes as $child) {
            $daneFaKorygowanej->appendChild($dom->importNode($child, true));
        }

        return $dom;
    }
}
