<?php
/**
 * Cron.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Tomasz Kur <t.kur@yetiforce.com>
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App;

/**
 * Class to execute task.
 */
abstract class CronHandler
{
	/** @var \vtlib\Cron Cron task instance. */
	protected $cronTask;

	/** @var string Cron task logs. */
	protected $logs = '';

	/**
	 * Main function to execute task.
	 *
	 * @return void
	 */
	abstract public function process();

	/**
	 * Construct.
	 *
	 * @param \vtlib\Cron $cronTask
	 */
	public function __construct(\vtlib\Cron $cronTask)
	{
		$this->cronTask = $cronTask;
	}

	/**
	 * Check cron task timeout.
	 *
	 * @return bool
	 */
	public function checkTimeout(): bool
	{
		return $this->cronTask->checkTimeout();
	}

	/**
	 * Update cron task last action time.
	 *
	 * @return void
	 */
	public function updateLastActionTime(): void
	{
		$this->cronTask->updateLastActionTime();
	}

	/**
	 * Get cron task logs.
	 *
	 * @return string
	 */
	public function getTaskLog(): string
	{
		return $this->logs;
	}

	/**
	 * Add text to logs.
	 *
	 * @param string $log
	 *
	 * @return void
	 */
	public function addTaskLog(string $log): void
	{
		$this->logs .= $log;
	}

	/**
	 * Add error message to log.
	 *
	 * @param string $message
	 *
	 * @return void
	 */
	public function addErrorLog(string $message): void
	{
		$this->addTaskLog($message);
		$this->cronTask->setError($message . '||' . date('Y-m-d H:i:s'));
		$this->cronTask->log($message, 'error');
		\App\Log::warning($message, static::class);
	}
}
