<?php
/**
 * Viewer class.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

namespace App;

/**
 * Viewer class.
 */
class Viewer
{
	const DEFAUL_VIEWER = 'Smarty';

	private static $instance;
	private $viewer;

	/**
	 * Constructor.
	 *
	 * @param string $viewer
	 * @param string $media  Layout/Media name
	 */
	public function __construct(string $viewer = self::DEFAUL_VIEWER, string $media = '')
	{
		$className = "\\App\\Viewer\\{$viewer}";
		$this->viewer = new $className($media);
	}

	/**
	 * Function to get the module specific template path for a given template.
	 *
	 * @param string $templateName
	 * @param string $moduleName
	 *
	 * @return string - Module specific template path if exists, otherwise default template path for the given template name
	 */
	public function getTemplatePath(string $templateName, ?string $moduleName = ''): string
	{
		return $this->viewer->getTemplatePath($templateName, $moduleName);
	}

	/**
	 * Function to display/fetch the file contents.
	 *
	 * @param string $templateName
	 * @param string $moduleName
	 * @param bool   $fetch
	 *
	 * @return string html data
	 */
	public function view($templateName, $moduleName = '', $fetch = false)
	{
		return $this->viewer->view($templateName, $moduleName, $fetch);
	}

	/**
	 * Set template directory.
	 *
	 * @param string|array $templateDir directory(s) of template sources
	 *
	 * @return self
	 */
	public function setTemplateDir($templateDir): self
	{
		$this->viewer->setTemplateDir($templateDir);

		return $this;
	}

	/**
	 * Assigns a variable.
	 *
	 * @param array|string $key   the template variable name(s)
	 * @param mixed        $value the value to assign
	 *
	 * @return Data current Data (or Smarty or \Smarty\Template) instance for
	 *              chaining
	 */
	public function assign($key, $value = null)
	{
		$this->viewer->assign($key, $value);

		return $this;
	}

	/**
	 * Returns a single or all template variables.
	 *
	 * @param string $varName
	 *
	 * @return mixed variable value or or array of variables
	 */
	public function getTemplateVars(?string $varName = null)
	{
		return $this->viewer->getTemplateVars($varName);
	}

	/**
	 * Static function to get the Instance of the Class Object.
	 *
	 * @param string $viewer
	 * @param string $media
	 *
	 * @return self
	 */
	public static function getInstance(string $viewer = self::DEFAUL_VIEWER, string $media = ''): self
	{
		if (!self::$instance) {
			$instance = new self($viewer, $media);
			self::$instance = $instance;
		}

		return self::$instance;
	}

	/** PHP Template Engine */
	public function getViewer()
	{
		return $this->viewer;
	}

	/**
	 * log message into the file if in debug mode.
	 *
	 * @param type $message
	 * @param type $delimiter
	 */
	protected function log($message, $delimiter = "\n")
	{
		$this->log($message, $delimiter);
	}
}
