{*<!-- {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} -->*}
{strip}
	<input type="hidden" id="view" value="{$VIEW}" />
	<div class="tpl-Settings-Inventory-Taxes" id="inventory">
		<div class="o-breadcrumb widget_header form-row">
			<div class="col-12">
				{include file=\App\Layout::getTemplatePath('BreadCrumbs.tpl', $MODULE_NAME)}
			</div>
		</div>
		<div class="contents form-row">
			<div class="col-md-12">
				<button type="button" class="btn btn-primary addInventory my-2"
					data-url="{$RECORD_MODEL->getCreateUrl()}" data-type="0"><span
						class="fas fa-plus mr-1"></span>{\App\Language::translate('LBL_ADD', $QUALIFIED_MODULE)} {\App\Language::translate($PAGE_LABELS.title_single, $QUALIFIED_MODULE)}
				</button>
				<table class="table tableRWD inventoryTable themeTableColor">
					<thead>
						<tr class="blockHeader">
							<th class="themeTextColor textAlignCenter {$WIDTHTYPE}">{\App\Language::translate('LBL_NAME', $QUALIFIED_MODULE)}</th>
							<th class="themeTextColor textAlignCenter {$WIDTHTYPE}">{\App\Language::translate('LBL_VALUE', $QUALIFIED_MODULE)}</th>
							<th class="themeTextColor textAlignCenter {$WIDTHTYPE}">{\App\Language::translate('LBL_STATUS', $QUALIFIED_MODULE)}</th>
							<th class="themeTextColor textAlignCenter {$WIDTHTYPE}">{\App\Language::translate('LBL_DEFAULT', $QUALIFIED_MODULE)}</th>
							<th></th>
						</tr>
					</thead>
					<tbody>
						{foreach item=RECORD from=$INVENTORY_DATA}
							<tr data-id="{$RECORD->getId()}">
								<td class="textAlignCenter {$WIDTHTYPE}">
									<label class="name m-0">{\App\Purifier::encodeHtml($RECORD->getName())}</label>
								</td>
								<td class="textAlignCenter {$WIDTHTYPE}">
									<span class="value">{$RECORD->getValue()} {if empty($CURRENCY_BOOL)}%{else}{$CURRENCY.currency_symbol}{/if}</span>
								</td>
								<td class="textAlignCenter {$WIDTHTYPE}">
									<input type="checkbox" data-field-name="status"
										class="status js-update-field"
										{if !$RECORD->getStatus()}checked="checked" {/if} />
								</td>
								<td class="textAlignCenter {$WIDTHTYPE}">
									<div class="float-right w-50 d-flex justify-content-between mr-2">
										<input type="checkbox" data-field-name="default"
											class="default js-update-field"
											{if $RECORD->getDefault()}checked{/if} />

									</div>
								</td>
								<td class="textAlignRight">
									<div class="actions">
										<button class="btn btn-outline-primary btn-sm editInventory u-cursor-pointer mr-1"
											data-url="{$RECORD->getEditUrl()}"><span
												title="{\App\Language::translate('LBL_EDIT', $MODULE)}"
												class="yfi yfi-full-editing-view alignBottom"></span></button>
										<button class="removeInventory u-cursor-pointer btn btn-outline-primary btn-sm"
											data-url="{$RECORD->getEditUrl()}"><span
												title="{\App\Language::translate('LBL_DELETE', $MODULE)}"
												class="fas fa-trash-alt alignBottom"></span></button>
									</div>
								</td>
							</tr>
						{/foreach}
					</tbody>
				</table>
			</div>
		</div>
	</div>
{/strip}
