<?php

/**
 * OSSMailScanner CRMEntity class.
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 */

include_once 'modules/Vtiger/CRMEntity.php';

class PaymentsOut extends Vtiger_CRMEntity
{
	public $column_fields = [];

	public $list_fields_name = [
		'LBL_PAYMENTSNO' => 'paymentsno',
		'LBL_PAYMENTSNAME' => 'paymentsname',
		'LBL_PAYMENTSVALUE' => 'paymentsvalue',
		'LBL_PAYMENTSCURRENCY' => 'paymentscurrency',
		'LBL_PAYMENTSSTATUS' => 'paymentsout_status',
	];

	/**
	 * @var string[] List of fields in the RelationListView
	 */
	public $relationFields = [];

	// For Popup listview and UI type support
	public $search_fields = [
		'LBL_PAYMENTSVALUE' => ['paymentsout', 'paymentsvalue'],
		'LBL_PAYMENTSNO' => ['paymentsout', 'paymentsno'],
		'LBL_PAYMENTSNAME' => ['paymentsout', 'paymentsname'],
	];
	public $search_fields_name = [];

	// For Popup window record selection
	public $popup_fields = ['paymentsname'];

	// For Alphabetical search
	public $def_basicsearch_col = 'paymentsname';

	// Column value to use on detail view record text display
	public $def_detailview_recname = 'paymentsname';

	// Callback function list during Importing
	public $special_functions = ['set_import_assigned_user'];

	public $default_order_by = '';

	public $default_sort_order = 'ASC';

	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	public $mandatory_fields = ['createdtime', 'modifiedtime', 'paymentsname'];
}
