<?php

/**
 * Password Action Class.
 *
 * @package Settings.Action
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Adrian Kon <a.kon@yetiforce.com>
 */

/**
 * Controller for api address password action.
 */
class Settings_ApiAddress_Password_Action extends Settings_Vtiger_Password_Action
{
	use \App\Controller\ExposeMethod;

	/** {@inheritdoc} */
	public function __construct()
	{
		parent::__construct();
		$this->exposeMethod('getPwd');
	}

	/** {@inheritdoc} */
	public function getPwd(App\Request $request)
	{
		$provider = \App\Map\Address::getInstance($request->getByType('provider', \App\Purifier::STANDARD));
		\Settings_Vtiger_Tracker_Model::addBasic('show hidden data');
		$response = new Vtiger_Response();
		$response->setResult(['success' => true, 'text' => $provider->config['key'] ?? '']);
		$response->emit();
	}
}
