<?php
/**
 * Token controller file to handle communication via web services.
 *
 * @package API
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace Api\Token;

/**
 * Token controller class to handle communication via web services.
 */
class Controller extends \Api\Controller
{
	/** {@inheritdoc}  */
	public function handleError(\Throwable $e): void
	{
		if ($e instanceof \Api\Core\Exception) {
			$e->logError();
		}
		if (is_numeric($e->getCode())) {
			http_response_code($e->getCode());
		}
		echo 'Internal Server Error [' . $e->getCode() . ']';
	}

	/** {@inheritdoc}  */
	protected function getActionClassName(): string
	{
		return 'Api\Token\Action';
	}
}
