<?php
/**
 * Class provide functionality to add generated document to Documents Module
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

namespace App\DocumentBuilder\Integrations;

use App\Report\Model\Template;
use App\Fields\File;
use Documents_Record_Model;
use Settings_TreesManager_Record_Model;
use Vtiger_Relation_Model;
use Vtiger_Module_Model;
use Documents;
use ReportTemplate;

/** DocumentModuleIntegration class */
final class DocumentModuleIntegration
{
	/** @var string Default documents folder name */
	private const DOCUMENT_FOLDER_NAME = 'Raporty';

	/** @var int ID of folder dedicated for system documents */
	private const SYSTEM_FOLDER_ID = 1;

	/** Create document entry based on report Template file */
	public function createDocumentEntry(Template $report, string $filePath): Documents_Record_Model
	{
		$mockedCatalogId = $this->getReportsFolderId();

		$file = File::saveFromContent(
			File::loadFromPath($filePath),
		);

		$documentRecord = Documents_Record_Model::getInstanceById($file['crmid']);
		$documentRecord->setFieldValue('notes_title', $report->getName());
		$documentRecord->setFieldValue('folderid', $mockedCatalogId);
		$documentRecord->save();

		$relation = Vtiger_Relation_Model::getInstance(
			Vtiger_Module_Model::getInstance(ReportTemplate::class),
			Vtiger_Module_Model::getInstance(Documents::class),
		);
		$relation->addRelation($report->getId(), [$documentRecord->getId()]);

		return $documentRecord;
	}

	/**
	 * @return string catalog id related with Documents module (like: T3)
	 */
	private function getReportsFolderId(): string
	{
		$systemTreeModule = Settings_TreesManager_Record_Model::getInstanceById(self::SYSTEM_FOLDER_ID);
		$catalogs = $systemTreeModule->getTree();

		$reportCatalog = array_values(
			array_filter($catalogs, static fn($catalog): bool => self::DOCUMENT_FOLDER_NAME === $catalog['text']),
		);

		return count($reportCatalog) > 0
			? sprintf('T%d', $reportCatalog[0]['id'])
			// add Value return also ID after save catalog
			: $systemTreeModule->addValue(self::DOCUMENT_FOLDER_NAME);
	}
}
