<?php

/**
 * Comarch correction invoice synchronization map file.
 *
 * The file is part of the paid functionality. Using the file is allowed only after purchasing a subscription.
 * File modification allowed only with the consent of the system producer.
 *
 * @package Integration
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Mariusz Krzaczkowski <m.krzaczkowski@yetiforce.com>
 */

namespace App\Integrations\Comarch\Xl\Maps;

/**
 * Comarch correction invoice synchronization map class.
 */
class CorrectionInvoice extends \App\Integrations\Comarch\InventoryMap
{
	/** {@inheritdoc} */
	const API_NAME_ID = 'trN_GIDNumer';
	/** {@inheritdoc} */
	protected $moduleName = 'FCorectingInvoice';
	/** {@inheritdoc} */
	protected $fieldMap = [
		'finvoiceid' => [
			'names' => ['get' => 'trN_ZwrNumer', 'create' => 'NumerDokumentuGlownego'],
			'fn' => 'findBySynchronizer', 'synchronizer' => 'Invoices',
		],
		'accountid' => [
			'names' => ['get' => 'knt_Akronim', 'create' => 'Akronim'],
			'fn' => 'findBySynchronizer', 'synchronizer' => 'Accounts', 'fieldName' => 'account_short_name',
			'importIfNotExist' => true,  'importFn' => 'importByAkronim'
		],
		'subject' => ['names' => ['get' => 'trN_GIDNumer']],
		'vat_id_a' => ['names' => ['get' => 'knt_Nip']],
		'company_name_a' => ['names' => ['get' => 'knt_Nazwa1']],
		'comarch_number' => ['names' => ['get' => 'numerDokumentu'], 'direction' => 'yf'],
		'addresslevel5a' => [
			'names' => ['get' => 'knA_GIDNumer', 'create' => 'AdrNumer'], 'accountKey' => 'knt_Akronim',
			'fn' => 'convertAddress', 'addressType' => 'a', 'accountField' => 'accountid',
			'addressFields' => [
				'addresslevel1', 'addresslevel2', 'addresslevel5', 'addresslevel7', 'addresslevel8',
				'buildingnumber', 'email_', 'phone_', 'company_name_', 'vat_id_'
			]
		],
		'payment_methods' => [
			'names' => ['get' => 'trN_FormaNr', 'create' => 'Forma'],
			'fn' => 'findBySynchronizer', 'synchronizer' => 'PaymentMethods'
		],
		'issue_time' => [
			'names' => ['get' => 'dataWystawienia', 'create' => 'DataWystawienia']
		],
		'saledate' => ['names' => ['get' => 'dataTransakcji', 'create' => 'DataTransakcji']],
		'paymentdate' => [
			'names' => ['get' => 'dataPlatnosci',    'create' => 'Termin'],
			'fn' => 'convertPaymentDate', 'synchronizer' => 'PaymentMethods'
		],
		'externalcomment' => ['names' => ['get' => 'tnO_Opis', 'create' => 'Opis']],
		'currency_id' => [
			'names' => ['get' => 'rkB_Waluta', 'create' => 'Waluta'],
			'fn' => 'convertCurrency',  'direction' => 'api'
		],
	];
	/** {@inheritdoc} */
	protected $invFieldMap = [
		'name' => [
			'names' => ['get' => 'trE_TwrKod', 'create' => 'TowarKod'],
			'fn' => 'findBySynchronizer', 'synchronizer' => 'Products', 'fieldName' => 'product_code'
		],
		'qty' => [
			'names' => ['get' => 'trE_Ilosc', 'create' => 'Ilosc'],
			'fn' => 'convertQuantity',
		],
		'price' => [
			'names' => ['get' => 'trE_Cena', 'create' => 'Cena'],
		],
		'unit' => [
			'names' => ['get' => 'trE_JmZ', 'create' => 'JM'],
			'fn' => 'findBySynchronizer', 'synchronizer' => 'ProductUnit'
		],
		'comment1' => [
			'names' => ['get' => 'teO_Opis', 'create' => 'Opis'],
			'fn' => 'convertInvDesc',
		],
		'taxparam' => [
			'names' => ['get' => 'trE_GrupaPod', 'create' => 'Vat'],
			'fn' => 'convertInvTax', 'synchronizer' => 'Taxes'
		],
		'currency' => [
			'names' => ['get' => 'trE_Waluta', 'create' => 'Waluta'],
			'fn' => 'convertCurrency', 'direction' => 'yf'
		],
	];
	/** {@inheritdoc} */
	protected $defaultDataYf = [
		'fieldMap' => [
			'finvoice_type' => 'PLL_DOMESTIC_INVOICE'
		],
		'invFieldMap' => [
			'comment1' => '',
			'discountmode' => 1,
			'discountparam' => '{"aggregationType":"individual","individualDiscountType":"amount","individualDiscount":0}',
		]
	];
	/** {@inheritdoc} */
	protected $defaultDataApi = [
		'Typ' => 2041
	];

	/**
	 * Convert inventory quantity in YF/API.
	 *
	 * @param mixed $value
	 * @param array $field
	 * @param bool  $fromApi
	 *
	 * @return int|string int (YF) or string (API)
	 */
	protected function convertQuantity($value, array $field, bool $fromApi)
	{
		if ($fromApi) {
			$parentApiData = $this->parentMap->getDataApi('fieldMap', false);
			$invoiceApiData = $this->synchronizer->controller
				->getSync('Invoices')->getByIdFromApi($parentApiData['trN_ZwrNumer']);
			$oldQuantity = 0;
			foreach ($invoiceApiData['pozycje'] as $item) {
				if ($item['tre_Pozycja'] == $this->dataApi['tre_Pozycja']) {
					$oldQuantity = $item['trE_Ilosc'];
					break;
				}
			}
			return $value + $oldQuantity;
		}
		// TODO
		return $value;
	}
}
