<?php
/**
 * Class to get tile layer.
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Klaudia Łozowska <k.lozowska@yetiforce.com>
 */

declare(strict_types=1);

namespace App\Map\TileLayer;

use App\Map\BaseDriver;

/**
 * Base Connector to get tile layer.
 */
abstract class Base extends BaseDriver
{
	/**
	 * Webpage.
	 *
	 * @var string
	 */
	protected string $url;

	/**
	 * Url template.
	 *
	 * @var string
	 */
	protected string $urlTemplate;

	/**
	 * Get URL.
	 *
	 * @return string
	 */
	public function getUrl(): string
	{
		return $this->url;
	}

	/**
	 * Get URL template.
	 *
	 * @return string
	 */
	public function getUrlTemplate(): string
	{
		return $this->urlTemplate;
	}

	/**
	 * Returns domains which are used by maps providers for external assets imports
	 */
	public function getAssetsDomains(): array
	{
		return [
			'allowedImageDomains' => [
				str_replace('{s}', '*', parse_url($this->getUrlTemplate(), PHP_URL_HOST))
			]
		];
	}
}
