<?php
/**
 * Service for build expression used in Query Generator
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Builder;

use App\Report\Enums\FunctionType;
use App\Report\Model\Expression;
use App\Report\Model\Query;

/** ExpressionBuilder class */
final class ExpressionBuilder
{
	/** Build expression */
	public function build(array $data, Query $query): Expression
	{
		return new Expression(
			$data['expression_id'],
			$query,
			$data['field'],
			$data['function'] ? FunctionType::from($data['function']) : null,
			(bool) $data['group_by'],
			$data['order_by'],
			$data['sort'],
		);
	}
}
