<?php

namespace App\TextParser;

use App\Fields\Currency;
use App\Language;

/**
 * Table tax two lang class.
 *
 * @package TextParser
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Arkadiusz Sołek <a.solek@yetiforce.com>
 */
class TableTaxSTwoLang extends Base
{
	/** @var string Class name */
	public $name = 'LBL_TABLE_TAX_S_TWO_LANG';

	/** @var mixed Parser type */
	public $type = 'pdf';

	/**
	 * Process.
	 *
	 * @return string
	 */
	public function process()
	{
		if (!$this->textParser->recordModel || !$this->textParser->recordModel->getModule()->isInventory()) {
			return '';
		}

		$html = '';
		$inventory = \Vtiger_Inventory_Model::getInstance($this->textParser->moduleName);
		$fields = $inventory->getFieldsByBlocks();
		$currencySymbol = $inventory->getCurrency($this->textParser->recordModel)['currency_symbol'] ?? '';

		if (!empty($fields[0])) {
			if ($inventory->isField('tax') && $inventory->isField('net')) {
				$taxSummary = $inventory->getField('tax')->getTaxSummary($this->textParser->recordModel);

				$html .= '
						<table class="table-tax-s-two-lang" style="width:100%;border-collapse:collapse;border:1px solid #ddd;">
							<thead>
								<tr>
									<th colspan="2" style="padding:0px 4px;text-align:center;">' . Language::translate('LBL_TAX_SUMMARY', $this->textParser->moduleName) . ' / ' . Language::translate('LBL_TAX_SUMMARY', $this->textParser->moduleName, Language::DEFAULT_LANG) . '</th>
								</tr>
							</thead>
							<tbody>';
				foreach ($taxSummary['groups'] as $key => $tax) {
					$html .= '<tr>
								<td class="name" style="text-align:left;padding:0px 4px;">' . $key . '</td>
								<td class="value" style="padding:0px 4px;text-align:right;">' . Currency::formatToDisplay($tax, null, true) . ' ' . $currencySymbol . '</td>
							</tr>';
				}
				$html .= '<tr class="summary">
							<th class="name" style="padding:0px 4px;text-align:left;">' . Language::translate('LBL_AMOUNT', $this->textParser->moduleName) . ' / ' . Language::translate('LBL_AMOUNT', $this->textParser->moduleName, Language::DEFAULT_LANG) . '</th>
							<th class="value" style="text-align:right;padding:0px 4px;">' . Currency::formatToDisplay($taxSummary['total'], null, true) . ' ' . $currencySymbol . '</th>
						 </tr>
						</tbody>
					</table>';
			}
		}
		return $html;
	}
}
