<?php
/**
 * Main file that includes basic operations on relations.
 *
 * @package   Relation
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

/**
 * Accounts_GetDependentsList_Relation class.
 */
class Accounts_GetDependentsList_Relation extends Vtiger_GetDependentsList_Relation
{
	public function getQueryForReport(\App\QueryGenerator $queryGenerator): void
	{
		$fieldModel = $this->relationModel->getRelationField();
		$queryGenerator
			->addJoin(
				[
					'LEFT JOIN',
					$fieldModel->getTableName(),
					sprintf(
						'%s.%s = %s',
						$fieldModel->getTableName(),
						$fieldModel->getColumnName(),
						$queryGenerator->getColumnName('id'),
					),
				],
			)
			->addJoin(['LEFT JOIN', 'vtiger_entity_stats', 'vtiger_crmentity.crmid = vtiger_entity_stats.crmid']);
	}
}
