<?php
/**
 * Mail account verification cron file.
 *
 * @package   Cron
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Radosław Skrzypczak <r.skrzypczak@yetiforce.com>
 */

use App\Mail\Account;
use App\Mail\Account\Entity\Enum\Status;
use App\Mail\Account\Repository\AccountPrivateRepository;

/**
 * Mail account verification cron class.
 */
class OSSMailScanner_Verification_Cron extends \App\CronHandler
{
	/** {@inheritdoc} */
	public function process()
	{
		$pauser = \App\Pauser::getInstance('MailAccountVerification');
		$lastId = (int) $pauser->getValue();
		$deactivationTime = \App\Mail::getConfig('scanner', 'deactivation_time');
		$allDone = true;

		$repository = new AccountPrivateRepository();
		foreach ($repository->getAllByStatus(Status::STATUS_LOCKED, $lastId) as $entity) {
			$pauser->setValue((string) $entity->getId());
			$mailAccount = new Account($entity, $repository);
			try {
				$mailbox = $mailAccount->openImap();
				if ($mailbox->isConnected()) {
					$mailAccount->unlock();
				}
			} catch (\Throwable $th) {
				$lastLogin = $mailAccount->getSource()->getLastLogin();
				$hours = \App\Fields\DateTime::getDiff((string) $lastLogin, date('Y-m-d H:i:s'), 'hours');
				if (!$lastLogin || (int) $hours >= (int) $deactivationTime) {
					$mailAccount->deactivate($th->getMessage());
				}
			}
			if ($this->checkTimeout()) {
				$allDone = false;
				break;
			}
		}

		if ($allDone) {
			$pauser->destroy();
		}
	}
}
