<?php
/**
 * Save action.
 *
 * @package   Actions
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author    Adrian Kon <a.kon@yetiforce.com>
 */
class ReportTemplate_Save_Action extends Vtiger_Save_Action
{
	/** {@inheritdoc} */
	public function getRecordModelFromRequest(App\Request $request): Vtiger_Record_Model
	{
		parent::getRecordModelFromRequest($request);

		if ($request->has('query')) {
			$request->set('query', $this->prepareQuery($request->get('query')));
			$this->record->setQueryDataFromRequest($request);
		}
		if ($request->has('recordId')) {
			$this->record->set('temp_id', $request->getInteger('recordId'));
		}
		return $this->record;
	}

	public function prepareQuery($query)
	{
		$query['base_module_id'] = App\Module::getModuleId($query['base_module_id']);
		return $query;
	}
}
