'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/"use strict";Vtiger_Detail_Js("Project_Detail_Js",{},{/**
		 * Function to register event for create related record
		 * in summary view widgets
		 */registerSummaryViewContainerEvents:function registerSummaryViewContainerEvents(summaryViewContainer){this._super(summaryViewContainer);},/**
		 * Function to load module summary of Projects
		 */loadModuleSummary:function loadModuleSummary(){var summaryParams={};summaryParams.module=app.getModuleName(),summaryParams.view="Detail",summaryParams.mode="showModuleSummaryView",summaryParams.record=jQuery("#recordId").val(),AppConnector.request(summaryParams).done(function(data){jQuery(".js-widget-general-info").html(data);});},/**
		 * Load gantt component
		 */loadGantt:function loadGantt(){var ganttContainer=$(".c-gantt",this.detailViewContentHolder);if(ganttContainer.length){var gantt=new Project_Gantt_Js(this.detailViewContentHolder);gantt.registerEvents();}},/**
		 * Load gantt component when needed
		 */registerGantt:function registerGantt(){var _this=this;this.loadGantt(),app.event.on("DetailView.Tab.AfterLoad",function(e,data,instance){instance.detailViewContentHolder.ready(function(){_this.loadGantt();});});},/**
		 * Function to get response from hierarchy
		 * @param {array} params
		 * @returns {jQuery}
		 */getHierarchyResponseData:function getHierarchyResponseData(params){var thisInstance=this,aDeferred=$.Deferred();return $.isEmptyObject(thisInstance.hierarchyResponseCache)?AppConnector.request(params).then(function(data){thisInstance.hierarchyResponseCache=data,aDeferred.resolve(thisInstance.hierarchyResponseCache);}):aDeferred.resolve(thisInstance.hierarchyResponseCache),aDeferred.promise()},/**
		 * Function to display the hierarchy response data
		 * @param {array} data
		 */displayHierarchyResponseData:function displayHierarchyResponseData(data){var callbackFunction=function(){app.showScrollBar($("#hierarchyScroll"),{height:"300px",railVisible:!0,size:"6px"});};app.showModalWindow(data,function(modalContainer){App.Components.Scrollbar.xy($("#hierarchyScroll",modalContainer)),"function"==typeof callbackFunction&&300<$("#hierarchyScroll",modalContainer).height()&&callbackFunction();});},/**
		 * Registers read count of hierarchy if it is possible
		 */registerHierarchyRecordCount:function registerHierarchyRecordCount(){var hierarchyButton=$(".js-detail-hierarchy"),params={module:app.getModuleName(),action:"RelationAjax",record:app.getRecordId(),mode:"getHierarchyCount"};hierarchyButton.length&&AppConnector.request(params).then(function(response){response.success&&$(".hierarchy .badge").html(response.result);});},/**
		 * Shows hierarchy
		 */registerShowHierarchy:function registerShowHierarchy(){var thisInstance=this,hierarchyButton=$(".detailViewTitle"),params={module:app.getModuleName(),view:"Hierarchy",record:app.getRecordId()};hierarchyButton.on("click",".js-detail-hierarchy",function(){var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});thisInstance.getHierarchyResponseData(params).then(function(data){thisInstance.displayHierarchyResponseData(data),progressIndicatorElement.progressIndicator({mode:"hide"});});});},/**
		 * Register events
		 */registerEvents:function registerEvents(){var detailContentsHolder=this.getContentHolder(),thisInstance=this;this._super(),detailContentsHolder.on("click",".moreRecentTickets",function(){var recentTicketsTab=thisInstance.getTabByLabel(thisInstance.detailViewRecentTicketsTabLabel);recentTicketsTab.trigger("click");}),this.registerGantt(),this.registerHierarchyRecordCount(),this.registerShowHierarchy();}});
//# sourceMappingURL=Detail.min.js.map
