'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/"use strict";jQuery.Class("Settings_Vtiger_Tax_Js",{},{//Stored history of TaxName and duplicate check result
duplicateCheckCache:{},/**
		 * This function will show the model for Add/Edit tax
		 */editTax:function editTax(url,currentTrElement){var aDeferred=jQuery.Deferred(),thisInstance=this,progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}});return AppConnector.request(url).done(function(data){var callBackFunction=function(){thisInstance.duplicateCheckCache={};var form=jQuery("#editTax"),params=app.validationEngineOptions;params.onValidationComplete=function(form,valid){if(valid)return thisInstance.saveTaxDetails(form,currentTrElement),valid},form.validationEngine(params),form.on("submit",function(e){e.preventDefault();});};progressIndicatorElement.progressIndicator({mode:"hide"}),app.showModalWindow(data,function(data){"function"==typeof callBackFunction&&callBackFunction(data);},{width:"500px"});}).fail(function(error){aDeferred.reject(error);}),aDeferred.promise()},/*
		 * Function to Save the Tax Details
		 */saveTaxDetails:function saveTaxDetails(form,currentTrElement){var thisInstance=this,params=form.serializeFormData();"undefined"==typeof params&&(params={}),thisInstance.validateTaxName(params).done(function(){var progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}});params.module=app.getModuleName(),params.parent=app.getParentModuleName(),params.action="TaxAjax",AppConnector.request(params).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),app.hideModalWindow(),"true"==form.find(".addTaxView").val()?thisInstance.addTaxDetails(data.result):thisInstance.updateTaxDetails(data.result,currentTrElement);//show notification after tax details saved
var params={text:app.vtranslate("JS_TAX_SAVED_SUCCESSFULLY")};Settings_Vtiger_Index_Js.showMessage(params);});});},/*
		 * Function to add the Tax Details in the list after saving
		 */addTaxDetails:function addTaxDetails(details){var taxTable,container=jQuery("#TaxCalculationsContainer");//Based on tax type, we will add the tax details row
taxTable="0"===details.type?jQuery(".inventoryTaxTable",container):jQuery(".shippingTaxTable",container);var trElementForTax=jQuery("<tr data-taxid=\""+details.taxid+"\" data-taxtype=\""+details.type+"\"><td style=\"border-left: none;\" class=\"textAlignCenter "+details.row_type+"\"><label class=\"taxLabel\">"+details.taxlabel+"</label></td><td style=\"border-left: none;\" class=\"textAlignCenter "+details.row_type+"\"><span class=\"taxPercentage\">"+details.percentage+"%</span></td><td style=\"border-left: none;\" class=\"textAlignCenter "+details.row_type+"\"><input class=\"editTaxStatus\" type=\"checkbox\" checked><div class=\"pull-right actions\"><a class=\"editTax u-cursor-pointer\" data-url=\""+details._editurl+"\"><i class=\"yfi yfi-full-editing-view alignBottom\" title=\""+app.vtranslate("JS_EDIT")+"\"></i></a></div></td></tr>");taxTable.append(trElementForTax);},/*
		 * Function to update the tax details in the list after edit
		 */updateTaxDetails:function updateTaxDetails(data,currentTrElement){currentTrElement.find(".taxLabel").text(data.taxlabel),currentTrElement.find(".taxPercentage").text(data.percentage+"%"),"0"==data.deleted?currentTrElement.find(".editTaxStatus").attr("checked","true"):currentTrElement.find(".editTaxStatus").removeAttr("checked");},/*
		 * Function to validate the TaxName to avoid duplicates
		 */validateTaxName:function validateTaxName(data){var thisInstance=this,aDeferred=jQuery.Deferred(),taxName=data.taxlabel,form=jQuery("#editTax"),taxLabelElement=form.find("[name=\"taxlabel\"]");if(!(taxName in thisInstance.duplicateCheckCache))thisInstance.checkDuplicateName(data).done(function(data){thisInstance.duplicateCheckCache[taxName]=data.success,aDeferred.resolve();}).fail(function(data){thisInstance.duplicateCheckCache[taxName]=data.success,thisInstance.duplicateCheckCache.message=data.message,taxLabelElement.validationEngine("showPrompt",data.message,"error","bottomLeft",!0),aDeferred.reject(data);});else if(!0==thisInstance.duplicateCheckCache[taxName]){var result=thisInstance.duplicateCheckCache.message;taxLabelElement.validationEngine("showPrompt",result,"error","bottomLeft",!0),aDeferred.reject();}else aDeferred.resolve();return aDeferred.promise()},/*
		 * Function to check Duplication of Tax Name
		 */checkDuplicateName:function checkDuplicateName(details){var aDeferred=jQuery.Deferred(),taxName=details.taxlabel,taxId=details.taxid,moduleName=app.getModuleName(),params={module:moduleName,parent:app.getParentModuleName(),action:"TaxAjax",mode:"checkDuplicateName",taxlabel:taxName,taxid:taxId,type:details.type};return AppConnector.request(params).done(function(data){var response=data.result,result=response.success;!0==result?aDeferred.reject(response):aDeferred.resolve(response);}).fail(function(error,err){aDeferred.reject(error,err);}),aDeferred.promise()},/*
		 * Function to update tax status as enabled or disabled
		 */updateTaxStatus:function updateTaxStatus(currentTarget){var aDeferred=jQuery.Deferred(),currentTrElement=currentTarget.closest("tr"),taxId=currentTrElement.data("taxid"),taxType=currentTrElement.data("taxtype"),deleted=currentTarget.is(":checked")?0:1,progressIndicatorElement=jQuery.progressIndicator({position:"html",blockInfo:{enabled:!0}}),params={module:app.getModuleName(),parent:app.getParentModuleName(),action:"TaxAjax",taxid:taxId,type:taxType,deleted:deleted};return AppConnector.request(params).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.resolve(data);}).fail(function(error){progressIndicatorElement.progressIndicator({mode:"hide"}),aDeferred.reject(error);}),aDeferred.promise()},/*
		 * Function to register all actions in the Tax List
		 */registerActions:function registerActions(){var thisInstance=this,container=jQuery("#TaxCalculationsContainer");//register click event for Add New Tax button
//register event for edit tax icon
//register event for checkbox to change the tax Status
container.find(".addTax").on("click",function(e){var addTaxButton=jQuery(e.currentTarget),createTaxUrl=addTaxButton.data("url")+"&type="+addTaxButton.data("type");thisInstance.editTax(createTaxUrl);}),container.on("click",".editTax",function(e){var editTaxButton=jQuery(e.currentTarget),currentTrElement=editTaxButton.closest("tr");thisInstance.editTax(editTaxButton.data("url"),currentTrElement);}),container.on("click",".editTaxStatus",function(e){var currentTarget=jQuery(e.currentTarget);thisInstance.updateTaxStatus(currentTarget).done(function(){var params={};params.text=currentTarget.is(":checked")?app.vtranslate("JS_TAX_ENABLED"):app.vtranslate("JS_TAX_DISABLED"),Settings_Vtiger_Index_Js.showMessage(params);});});},registerEvents:function registerEvents(){this.registerActions();}}),jQuery(document).ready(function(){var taxInstance=new Settings_Vtiger_Tax_Js;taxInstance.registerEvents();});
//# sourceMappingURL=Tax.min.js.map
