'use strict';

/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/"use strict";Vtiger_AdvanceFilter_Js("Workflows_AdvanceFilter_Js",{},{validationSupportedFieldConditionMap:{email:["e","n"],date:["is"],datetime:["is"]},//Hols field type for which there is validations always needed
allConditionValidationNeededFieldList:["double","integer"],// comparators which do not have any field Specific UI.
comparatorsWithNoValueBoxMap:["is record open","is record closed","has changed","not has changed","is empty","is not empty","is Watching Record","is Not Watching Record","not created by owner"],getFieldSpecificType:function getFieldSpecificType(fieldSelected){var fieldInfo=fieldSelected.data("fieldinfo"),type=fieldInfo.type;return type},getModuleName:function getModuleName(){return app.getModuleName()},/**
		 * Function to add new condition row
		 * @params : condtionGroupElement - group where condtion need to be added
		 * @return : current instance
		 */addNewCondition:function addNewCondition(conditionGroupElement){var basicElement=jQuery(".basic",conditionGroupElement),newRowElement=basicElement.find(".js-conditions-row").clone(!0,!0);jQuery("select",newRowElement).addClass("select2");var conditionList=jQuery(".conditionList",conditionGroupElement);return conditionList.append(newRowElement),App.Fields.Picklist.changeSelectElementView(newRowElement),newRowElement.find("[name=\"columnname\"]").find("optgroup:first option:first").attr("selected","selected").trigger("change"),this},/**
		 * Function to load condition list for the selected field
		 * (overrrided to remove "has changed" condition for related record fields in workflows)
		 * @params : fieldSelect - select element which will represents field list
		 * @return : select element which will represent the condition element
		 */loadConditions:function loadConditions(fieldSelect){var row=fieldSelect.closest("div.js-conditions-row"),conditionSelectElement=row.find("select[name=\"comparator\"]"),conditionSelected=conditionSelectElement.val(),fieldSelected=fieldSelect.find("option:selected"),fieldLabel=fieldSelected.val(),match=fieldLabel.match(/\((\w+)\) (\w+)/),fieldSpecificType=this.getFieldSpecificType(fieldSelected),conditionList=this.getConditionListFromType(fieldSpecificType),fieldInfo=fieldSelected.data("fieldinfo");"undefined"==typeof conditionList&&(conditionList={},conditionList.none="None");var options="";for(var key in conditionList)//IE Browser consider the prototype properties also, it should consider has own properties only.
if(conditionList.hasOwnProperty(key)){var conditionValue=conditionList[key],conditionLabel=this.getConditionLabel(conditionValue);if("picklist"===fieldInfo.type&&-1!==jQuery.inArray(conditionValue,["is record open","is record closed"])&&"undefined"!=typeof fieldInfo.field_params&&"undefined"!=typeof fieldInfo.field_params.isProcessStatusField&&!fieldInfo.field_params.isProcessStatusField)continue;null==match?(options+="<option value=\""+conditionValue+"\"",conditionValue==conditionSelected&&(options+=" selected=\"selected\" "),options+=">"+conditionLabel+"</option>"):"has changed"!=conditionValue&&(options+="<option value=\""+conditionValue+"\"",conditionValue==conditionSelected&&(options+=" selected=\"selected\" "),options+=">"+conditionLabel+"</option>");}return conditionSelectElement.empty().html(options).trigger("change"),conditionSelectElement},/**
		 * Function to retrieve the values of the filter
		 * @return : object
		 */getValues:function getValues(){var thisInstance=this,fieldList=new Array("columnname","comparator","value","valuetype","column_condition"),values={},columnIndex=0,conditionGroups=jQuery(".conditionGroup",this.getFilterContainer());return conditionGroups.each(function(index,domElement){var groupElement=jQuery(domElement),conditions=jQuery(".conditionList .js-conditions-row",groupElement),iterationValues={};return !!(0>=conditions.length)||void(conditions.each(function(i,conditionDomElement){var rowElement=$(conditionDomElement),fieldSelectElement=$("[name=\"columnname\"]",rowElement),valueSelectElement=$("[data-value=\"value\"]",rowElement);//To not send empty fields to server
if(thisInstance.isEmptyFieldSelected(fieldSelectElement))return !0;var key,field,fieldType=fieldSelectElement.find("option:selected").data("fieldinfo").type,rowValues={};if(-1<$.inArray(fieldType,["picklist","multipicklist","multiReferenceValue"])){for(key in fieldList)if(field=fieldList[key],"value"===field&&valueSelectElement.is("input")){var pickListValues=valueSelectElement.data("picklistvalues"),valuesArr=valueSelectElement.val().split(","),newValuesArr=[];for(i=0;i<valuesArr.length;i++)"undefined"==typeof pickListValues[valuesArr[i]]?newValuesArr.push(valuesArr[i]):newValuesArr.push(pickListValues[valuesArr[i]]);rowValues[field]=newValuesArr.join(",");}else if("value"===field&&valueSelectElement.is("select")&&"picklist"===fieldType)rowValues[field]=valueSelectElement.val();else if("value"===field&&valueSelectElement.is("select")&&-1<$.inArray(fieldType,["multipicklist","multiReferenceValue","categoryMultipicklist"])){var value=valueSelectElement.val();rowValues[field]=null==value?value:value.join(",");}else rowValues[field]=$("[name=\""+field+"\"]",rowElement).val();}else for(key in fieldList)field=fieldList[key],rowValues[field]="value"===field?valueSelectElement.val():$("[name=\""+field+"\"]",rowElement).val();("false"===$("[name=\"valuetype\"]",rowElement).val()||0===$("[name=\"valuetype\"]",rowElement).length)&&(rowValues.valuetype="rawtext"),rowValues.groupid=0===index?0:1,rowElement.is(":last-child")&&(rowValues.column_condition=""),iterationValues[columnIndex]=rowValues,columnIndex++;}),!$.isEmptyObject(iterationValues)&&(values[index+1]={},values[index+1].columns=iterationValues),0<groupElement.find("div.groupCondition").length&&(values[index+1].condition=groupElement.find("div.groupCondition [name=\"condition\"]").val()))}),values},/**
		 * Functiont to get the field specific ui for the selected field
		 * @prarms : fieldSelectElement - select element which will represents field list
		 * @return : jquery object which represents the ui for the field
		 */getFieldSpecificUi:function getFieldSpecificUi(fieldSelectElement){var fieldSelected=fieldSelectElement.find("option:selected"),fieldInfo=fieldSelected.data("fieldinfo");return -1==jQuery.inArray(fieldInfo.comparatorElementVal,this.comparatorsWithNoValueBoxMap)?this._super(fieldSelectElement):jQuery("")}}),Vtiger_Field_Js("Workflows_Field_Js",{},{getUiTypeSpecificHtml:function getUiTypeSpecificHtml(){var uiTypeModel=this.getUiTypeModel();return uiTypeModel.getUi()},getModuleName:function getModuleName(){var currentModule=app.getModuleName();return currentModule},/**
		 * Funtion to get the ui for the field  - generally this will be extend by the child classes to
		 * give ui type specific ui
		 * return <String or Jquery> it can return either plain html or jquery object
		 */getUi:function getUi(){var html="<input type=\"text\" class=\"getPopupUi form-control\" name=\""+this.getName()+"\"  /><input type=\"hidden\" name=\"valuetype\" value=\""+this.get("workflow_valuetype")+"\" />";return html=jQuery(html),html.filter(".getPopupUi").val(app.htmlDecode(this.getValue())),this.addValidationToElement(html)}}),Vtiger_Date_Field_Js("Workflows_Date_Field_Js",{},{/**
		 * Function to get the user date format
		 */getDateFormat:function getDateFormat(){return this.get("date-format")},/**
		 * Function to get the ui
		 * @return - input text field
		 */getUi:function getUi(){var html,element,comparatorSelectedOptionVal=this.get("comparatorElementVal"),dateSpecificConditions=this.get("dateSpecificConditions");if(0<comparatorSelectedOptionVal.length){if("between"===comparatorSelectedOptionVal||"custom"===comparatorSelectedOptionVal)return html="<div class=\"date\"><input class=\"form-control dateRangeField\" data-calendar-type=\"range\" name=\""+this.getName()+"\" data-date-format=\""+this.getDateFormat()+"\" type=\"text\" value=\""+this.getValue()+"\"></div>",element=jQuery(html),this.addValidationToElement(element);if(this._specialDateComparator(comparatorSelectedOptionVal))return html="<input name=\""+this.getName()+"\" type=\"text\" value=\""+this.getValue()+"\" data-validation-engine=\"validate[funcCall[Vtiger_Base_Validator_Js.invokeValidation]]\" data-validator=\"[{\"name\":\"PositiveNumber\"}]\"><input type=\"hidden\" name=\"valuetype\" value=\""+this.get("workflow_valuetype")+"\" />",jQuery(html);if(comparatorSelectedOptionVal in dateSpecificConditions){var startValue=dateSpecificConditions[comparatorSelectedOptionVal].startdate,endValue=dateSpecificConditions[comparatorSelectedOptionVal].enddate;return html="<input name=\""+this.getName()+"\"  type=\"text\" ReadOnly=\"true\" value=\""+startValue+","+endValue+"\">",jQuery(html)}if("is today"===comparatorSelectedOptionVal);//show nothing
else return this._super()}else return html="<input type=\"text\" class=\"getPopupUi date form-control\" name=\""+this.getName()+"\"  data-date-format=\""+this.getDateFormat()+"\"  value=\""+this.getValue()+"\" /><input type=\"hidden\" name=\"valuetype\" value=\""+this.get("workflow_valuetype")+"\" />",element=jQuery(html),this.addValidationToElement(element)},_specialDateComparator:function _specialDateComparator(comp){var specialComparators=["less than days ago","more than days ago","in less than","in more than","days ago","days later"];for(var index in specialComparators)if(comp==specialComparators[index])return !0;return !1}}),Vtiger_Date_Field_Js("Workflows_Datetime_Field_Js",{},{/**
		 * Function to get the user date format
		 */getDateFormat:function getDateFormat(){return this.get("date-format")},/**
		 * Function to get the ui
		 * @return - input text field
		 */getUi:function getUi(){var html,element;return this._specialDateTimeComparator(this.get("comparatorElementVal"))?(html="<input name=\""+this.getName()+"\" type=\"text\" value=\""+this.getValue()+"\" data-validator=\"[{name:PositiveNumber}]\"><input type=\"hidden\" name=\"valuetype\" value=\""+this.get("workflow_valuetype")+"\" />",element=$(html)):(html="<input type=\"text\" class=\"getPopupUi date form-control\" name=\""+this.getName()+"\"  data-date-format=\""+this.getDateFormat()+"\"  value=\""+this.getValue()+"\" /><input type=\"hidden\" name=\"valuetype\" value=\""+this.get("workflow_valuetype")+"\" />",element=$(html)),element},_specialDateTimeComparator:function _specialDateTimeComparator(comp){var specialComparators=["less than hours before","less than hours later","more than hours later","more than hours before","less than minutes before","less than minutes later","more than minutes later","more than minutes before"];for(var index in specialComparators)if(comp==specialComparators[index])return !0;return !1}}),Vtiger_Currency_Field_Js("Workflows_Currency_Field_Js",{},{getUi:function getUi(){var html="<input type=\"text\" class=\"getPopupUi marginLeftZero form-control\" name=\""+this.getName()+"\" value=\""+this.getValue()+"\"  /><input type=\"hidden\" name=\"valuetype\" value=\""+this.get("workflow_valuetype")+"\" />",element=jQuery(html);return this.addValidationToElement(element)}}),Vtiger_Time_Field_Js("Workflows_Time_Field_Js",{},{/**
		 * Function to get the ui
		 * @return - input text field
		 */getUi:function getUi(){var html="<input type=\"text\" class=\"getPopupUi time form-control\" name=\""+this.getName()+"\"  value=\""+this.getValue()+"\" /><input type=\"hidden\" name=\"valuetype\" value=\""+this.get("workflow_valuetype")+"\" />",element=jQuery(html);return this.addValidationToElement(element)}}),Vtiger_Field_Js("Vtiger_Percentage_Field_Js",{},{/**
		 * Function to get the ui
		 * @return - input percentage field
		 */getUi:function getUi(){var html="<input type=\"text\" class=\"getPopupUi form-control\" name=\""+this.getName()+"\" value=\""+this.getValue()+"\" /><input type=\"hidden\" name=\"valuetype\" value=\""+this.get("workflow_valuetype")+"\" />",element=jQuery(html);return this.addValidationToElement(element)}}),Vtiger_Field_Js("Vtiger_Text_Field_Js",{},{/**
		 * Function to get the ui
		 * @return - input text field
		 */getUi:function getUi(){var html="<input type=\"text\" class=\"getPopupUi form-control\" name=\""+this.getName()+"\" value=\""+this.getValue()+"\" /><input type=\"hidden\" name=\"valuetype\" value=\""+this.get("workflow_valuetype")+"\" />",element=jQuery(html);return this.addValidationToElement(element)}}),Vtiger_Field_Js("Vtiger_Boolean_Field_Js",{},{/**
		 * Function to get the ui
		 * @return - input text field
		 */getUi:function getUi(){var html="<input type=\"text\" class=\"getPopupUi form-control boolean\" name=\""+this.getName()+"\" value=\""+this.getValue()+"\" /><input type=\"hidden\" name=\"valuetype\" value=\""+this.get("workflow_valuetype")+"\" />",element=jQuery(html);return this.addValidationToElement(element)}}),Vtiger_Owner_Field_Js("Workflows_Owner_Field_Js",{},{getUi:function getUi(){var html="<select class=\"select2\" data-value=\"value\" name=\""+this.getName()+"\">",pickListValues=this.getPickListValues(),selectedOption=this.getValue();for(var optGroup in pickListValues){html+="<optgroup label=\""+optGroup+"\">";var optionGroupValues=pickListValues[optGroup];for(var option in optionGroupValues)html+="<option value=\""+option+"\" ",option==selectedOption&&(html+=" selected "),html+=">"+optionGroupValues[option]+"</option>";html+="</optgroup>";}html+="</select>";var selectContainer=jQuery(html);return this.addValidationToElement(selectContainer),selectContainer}}),Workflows_Owner_Field_Js("Workflows_Sharedowner_Field_Js",{},{}),Vtiger_Picklist_Field_Js("Workflows_Picklist_Field_Js",{},{}),Workflows_Owner_Field_Js("Workflows_Usercreator_Field_Js",{},{}),Vtiger_Picklist_Field_Js("Workflows_Country_Field_Js",{},{}),Vtiger_Picklist_Field_Js("Workflows_Userrole_Field_Js",{},{});
//# sourceMappingURL=AdvanceFilter.min.js.map
