'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */$.Class("Base_RecordConverter_JS",{},{container:!1,/**
		 * Function get values for request query
		 * @returns {{module: string, view: string, fieldMerge: string, onlyBody: boolean, destinyModule: string, sourceView: string}}
		 */getParams:function getParams(){var params={module:this.container.data("module"),view:this.container.data("view"),convertId:this.container.find(".js-convert-type option:selected").val(),sourceView:this.container.find("[name=\"sourceView\"]").val()};if("List"===app.getViewName()){var listInstance=Vtiger_List_Js.getInstance();if(params.selected_ids=listInstance.readSelectedIds(!0),params.excluded_ids=listInstance.readExcludedIds(!0),params.cvId=listInstance.getCurrentCvId(),listInstance.getListSearchInstance()){var searchValue=listInstance.getListSearchInstance().getAlphabetSearchValue();params.search_params=JSON.stringify(listInstance.getListSearchInstance().getListSearchParams()),"undefined"!=typeof searchValue&&0<searchValue.length&&(params.search_key=listInstance.getListSearchInstance().getAlphabetSearchField(),params.search_value=searchValue,params.operator="s");}}else params.selected_ids=app.getRecordId();return params},/**
		 * Function load modal window
		 * @returns {object}
		 */loadModalWindow:function loadModalWindow(){var body=this.container.find(".js-modal-body"),aDeferred=$.Deferred(),progressIndicatorElement=$.progressIndicator({blockInfo:{enabled:!0}});return app.hideModalWindow(body.closest(".js-modal-container").attr("id")),app.showModalWindow({url:app.convertObjectToUrl(this.getParams()),cb:function cb(){progressIndicatorElement.progressIndicator({mode:"hide"});}}),aDeferred.promise()},/**
		 * Function listener to change convert type
		 */registerChangeConvertType:function registerChangeConvertType(){var _this=this;this.container.on("change",".js-convert-type",function(){_this.loadModalWindow();});},/**
		 * Function listener to send a form
		 * * @returns {object}
		 */registerSubmitForm:function registerSubmitForm(){var self=this;self.container.on("click","[name='saveButton']",function(){var formMapping=self.container.find("form.js-form-converter");if(formMapping.validationEngine("validate")){var formData=formMapping.serializeFormData(),postData={};if("List"===app.getViewName()){var listInstance=Vtiger_List_Js.getInstance();postData=listInstance.getDefaultParams(),postData.selected_ids=listInstance.readSelectedIds(!0),postData.excluded_ids=listInstance.readExcludedIds(!0),postData.cvid=listInstance.getCurrentCvId();}else postData={selected_ids:app.getRecordId()};postData.viewInfo=app.getViewName();var aDeferred=$.Deferred(),progressIndicatorElement=$.progressIndicator({blockInfo:{enabled:!0,elementToBlock:self.container.find(".modal-body")}});return AppConnector.request($.extend(formData,postData)).done(function(responseData){progressIndicatorElement.progressIndicator({mode:"hide"}),responseData=JSON.parse(responseData),responseData.result.redirect?window.location.href=responseData.result.redirect:(responseData.result.createdRecords&&Vtiger_Helper_Js.showMessage({text:app.vtranslate(responseData.result.createdRecords),type:"success"}),responseData.result.error&&Vtiger_Helper_Js.showMessage({text:app.vtranslate(responseData.result.error),type:"error"}),app.hideModalWindow()),aDeferred.resolve(responseData);},function(textStatus,errorThrown){aDeferred.reject(textStatus,errorThrown),progressIndicatorElement.progressIndicator({mode:"hide"});}),aDeferred.promise()}});},/**
		 * Register events function
		 * @param modalContainer
		 */registerEvents:function registerEvents(modalContainer){this.container=modalContainer,this.registerChangeConvertType(),this.registerSubmitForm(),this.container.find("form.js-form-converter").validationEngine(app.validationEngineOptions);}});
//# sourceMappingURL=RecordConverter.min.js.map
