<?php
/**
 * Available function for reports
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 * @author Łukasz Krawczyk <l.krawczyk@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Enums;

/** FunctionType enum class */
enum FunctionType: string
{
	public const AGGREGATES = [self::COUNT, self::SUM, self::AVG, self::MIN, self::MAX];

	case COUNT = 'count';
	case SUM = 'sum';
	case AVG = 'avg';
	case MAX = 'max';
	case MIN = 'min';
	case YEAR = 'year';
	case MONTH = 'month';
	case DIFF = 'diff';
	case PROD = 'prod';
	case QUO = 'quo';

	/** Check if function is mysql aggregate function */
	public function isAggregate(): bool
	{
		return true === in_array($this, self::AGGREGATES);
	}
}
