<?php
/**
 * Available operators for reports
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Enums;

enum Operator: string
{
	//Date Operator
	case SMALLER_THAN_NOW = 'smallerthannow';
	case GREATER_THAN_NOW = 'greaterthannow';
	case PREVIOUS_FY = 'prevfy';
	case CURRENT_FY = 'thisfy';
	case NEXT_FY = 'nextfy';
	case PREVIOUS_FQ = 'prevfq';
	case CURRENT_FQ = 'thisfq';
	case NEXT_FQ = 'nextfq';
	case PREVIOUS_WORKING_DAY = 'previousworkingday';
	case NEXT_WORKING_DAY = 'nextworkingday';
	case YESTERDAY = 'yesterday';
	case TODAY = 'today';
	case UNTIL_TODAY = 'untiltoday';
	case TOMORROW = 'tomorrow';
	case LAST_WEEK = 'lastweek';
	case CURRENT_WEEK = 'thisweek';
	case NEXT_WEEK = 'nextweek';
	case LAST_MONTH = 'lastmonth';
	case CURRENT_MONTH = 'thismonth';
	case NEXT_MONTH = 'nextmonth';
	case LAST_7_DAYS = 'last7days';
	case LAST_15_DAYS = 'last15days';
	case LAST_30_DAYS = 'last30days';
	case LAST_60_DAYS = 'last60days';
	case LAST_90_DAYS = 'last90days';
	case LAST_120_DAYS = 'last120days';
	case NEXT_15_DAYS = 'next15days';
	case NEXT_30_DAYS = 'next30days';
	case NEXT_60_DAYS = 'next60days';
	case NEXT_90_DAYS = 'next90days';
	case NEXT_120_DAYS = 'next120days';
	case DATE_CONDITION_MORE_THAN_DAYS_AGO = 'moreThanDaysAgo';

	//Field Operator
	case EQUALS_FIELD = 'ef';
	case NOT_EQUAL_TO_FIELD = 'nf';
	case LESS_THAN_FIELD = 'lf';
	case GREATER_THAN_FIELD = 'gf';
	case LESS_THAN_OR_EQUAL_FIELD = 'mf';
	case GREATER_OR_EQUAL_FIELD = 'hf';

	//Non Value Operator
	case CURRENTLY_LOGGED_USER = 'om';
	case USER_CURRENTLY_NOT_LOGGED = 'nom';
	case CURRENTLY_LOGGED_USER_GROUP = 'ogr';
	case USERS_GROUP_LOGGED_IN_USER = 'ogu';
	case IS_WATCHING_RECORD = 'wr';
	case IS_NOT_WATCHING_RECORD = 'nwr';
	case HAS_CHANGED = 'hs';
	case HAS_CHANGED_TO = 'hst';
	case IS_RECORD_OPEN = 'ro';
	case IS_RECORD_CLOSED = 'rc';
	case NOT_CREATED_BY_OWNER = 'nco';

	//Standard Operator
	case EQUALS = 'e';
	case NOT_EQUAL_TO = 'n';
	case STARTS_WITH = 's';
	case ENDS_WITH = 'ew';
	case CONTAINS = 'c';
	case CONTAINS_HIERARCHY = 'ch';
	case DOES_NOT_CONTAIN = 'k';
	case DOES_NOT_CONTAIN_HIERARCHY = 'kh';
	case LESS_THAN = 'l';
	case GREATER_THAN = 'g';
	case LESS_THAN_OR_EQUAL = 'm';
	case GREATER_OR_EQUAL = 'h';
	case BEFORE = 'b';
	case AFTER = 'a';
	case BETWEEN = 'bw';
	case  IS_EMPTY = 'y';
	case IS_NOT_EMPTY = 'ny';
}
