<?php
/**
 * Report Template model
 *
 * @package App
 *
 * @copyright YetiForce S.A.
 * @license YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 * @author Leszek Koziatek <l.koziatek@yetiforce.com>
 */
declare(strict_types=1);

namespace App\Report\Model;

final class Template
{
	public function __construct(
		private int $id,
		private string $name,
		private Query $query,
		private ?string $description = null,
		private ?string $number = null
	) {
	}

	/** Get Template id */
	public function getId(): int
	{
		return $this->id;
	}

	/** Get Template name */
	public function getName(): string
	{
		return $this->name;
	}

	/** Get Template Query */
	public function getQuery(): Query
	{
		return $this->query;
	}

	/** Get Template description */
	public function getDescription(): ?string
	{
		return $this->description;
	}

	/** Get template number */
	public function getNumber(): ?string
	{
		return $this->number;
	}
}
