<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20240403171458 extends AbstractMigration
{
	public function getDescription(): string
	{
		return 'Initial migration containing data';
	}

	public function up(Schema $schema): void
	{
		$this->addSql('SET FOREIGN_KEY_CHECKS = 0');

		$this->addSql(<<<'STR'
			insert  into `a_yf_bruteforce`(`attempsnumber`,`timelock`,`active`,`sent`) values
			(10,15,1,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `a_yf_discounts_config`(`param`,`value`) values
			('aggregation','0'),
			('default_mode','1'),
			('discounts','0,1,2');
			STR);

		$this->addSql(<<<'STR'
			insert  into `a_yf_map_coordinates_driver_config`(`id`,`driver`,`api_key`,`active`) values
			(1,'GoogleGeocoding',NULL,0),
			(2,'Nominatim',NULL,1),
			(3,'OpenCage',NULL,0),
			(4,'GraphHopper',NULL,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `a_yf_map_routing_driver_config`(`id`,`driver`,`api_key`,`params`,`active`) values
			(1,'GoogleRoutes',NULL,'{\"travelMode\":\"DRIVE\",\"routingPreference\":\"TRAFFIC_UNAWARE\"}',0),
			(2,'Osrm',NULL,NULL,1),
			(3,'GraphHopper',NULL,'{\"profile\":\"car\"}',0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `a_yf_map_tile_layer_driver_config`(`id`,`driver`,`api_key`,`active`) values
			(1,'OpenStreetMapDefault',NULL,1),
			(2,'OpenStreetMapHOT',NULL,0),
			(3,'EsriWorldTopoMap',NULL,0),
			(4,'EsriWorldImagery',NULL,0),
			(5,'GoogleMaps',NULL,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `a_yf_mapped_config`(`id`,`tabid`,`reltabid`,`status`,`conditions`,`permissions`,`params`) values
			(1,104,106,1,'[]','','{\"autofill\":\"on\"}'),
			(2,6,18,1,'[]','','{\"autofill\":\"on\"}'),
			(3,90,95,1,'[]',NULL,'{\"autofill\":\"on\"}'),
			(4,90,100,1,'[]',NULL,'[]'),
			(5,100,98,1,'[]',NULL,'[]'),
			(6,90,98,1,'[]',NULL,'[]');
			STR);

		$this->addSql(<<<'STR'
			insert  into `a_yf_mapped_fields`(`id`,`mappedid`,`type`,`source`,`target`,`default`) values
			(1,1,'INVENTORY','name','name',''),
			(2,1,'INVENTORY','ean','ean',''),
			(3,1,'INVENTORY','unit','unit',''),
			(4,1,'INVENTORY','qty','qty',''),
			(5,1,'INVENTORY','price','price',''),
			(6,1,'INVENTORY','comment1','comment1',''),
			(7,1,'INVENTORY','total','total',''),
			(8,1,'V','2226','2250',''),
			(9,1,'SELF','id','2262',''),
			(10,2,'V','1','288',''),
			(11,2,'E','9','291',''),
			(73,3,'V','1834','2040',''),
			(74,3,'V','1839','2043',NULL),
			(75,3,'INVENTORY','comment1','comment1',''),
			(76,3,'INVENTORY','gross','gross',''),
			(77,3,'INVENTORY','tax','tax',''),
			(78,3,'INVENTORY','total','total',''),
			(79,3,'INVENTORY','price','price',''),
			(80,3,'INVENTORY','qty','qty',''),
			(81,3,'INVENTORY','name','name',''),
			(82,3,'INVENTORY','taxmode','taxmode',''),
			(83,3,'INVENTORY','net','net',''),
			(84,3,'INVENTORY','discountmode','discountmode',''),
			(85,3,'INVENTORY','discount','discount',''),
			(86,3,'V','2826','2825','PLL_NOT_PAID'),
			(87,3,'V','2818','2044',''),
			(88,3,'V','1835','2573',''),
			(89,4,'V','1839','2195',NULL),
			(90,4,'SELF','id','2345',NULL),
			(91,4,'V','2792','2157',NULL),
			(92,4,'INVENTORY','total','total',''),
			(93,4,'INVENTORY','qty','qty',''),
			(94,4,'INVENTORY','price','price',''),
			(95,4,'INVENTORY','name','name',''),
			(96,4,'INVENTORY','comment1','comment1',''),
			(97,4,'V','1843','2158','0'),
			(98,4,'V','1845','2193',''),
			(99,4,'V','1846','2194',''),
			(100,4,'V','1834','2156',''),
			(101,5,'V','2156','2116',''),
			(102,5,'V','2157','2170',NULL),
			(103,5,'D','2196','2192',''),
			(104,5,'V','2158','2117','0'),
			(105,5,'V','2193','2189',''),
			(106,5,'V','2194','2190',''),
			(107,5,'INVENTORY','name','name',''),
			(108,5,'INVENTORY','ean','ean',''),
			(109,5,'INVENTORY','unit','unit',''),
			(110,5,'INVENTORY','subunit','subunit',''),
			(111,5,'INVENTORY','qty','qty',''),
			(112,5,'INVENTORY','price','price',''),
			(113,5,'INVENTORY','total','total',''),
			(114,5,'INVENTORY','comment1','comment1',''),
			(115,6,'V','1834','2116',''),
			(116,6,'V','2792','2170',NULL),
			(117,6,'V','1843','2117','0'),
			(118,6,'INVENTORY','name','name',''),
			(119,6,'INVENTORY','qty','qty',''),
			(120,6,'INVENTORY','price','price',''),
			(121,6,'INVENTORY','comment1','comment1',''),
			(122,6,'INVENTORY','total','total',''),
			(123,6,'INVENTORY','subunit','subunit',''),
			(124,6,'INVENTORY','unit','unit','');
			STR);

		$this->addSql(<<<'STR'
			insert  into `a_yf_module_package`(`id`,`name`,`label`,`description`,`icon`,`sequence`,`default_active`) values
			(1,'Sales','LBL_MODULE_PACKAGE_SALES','LBL_MODULE_PACKAGE_SALES_DESCRIPTION','fa-coins',0,1),
			(2,'Accounting','LBL_MODULE_PACKAGE_ACCOUNTING','LBL_MODULE_PACKAGE_ACCOUNTING_DESCRIPTION','fa-file-invoice-dollar',1,0),
			(3,'ProjectManagement','LBL_MODULE_PACKAGE_PROJECT_MANAGEMENT','LBL_MODULE_PACKAGE_PROJECT_MANAGEMENT_DESCRIPTION','fa-list-check',2,0),
			(4,'Marketing','LBL_MODULE_PACKAGE_MARKETING','LBL_MODULE_PACKAGE_MARKETING_DESCRIPTION','fa-ranking-star',3,0),
			(5,'Support','LBL_MODULE_PACKAGE_SUPPORT','LBL_MODULE_PACKAGE_SUPPORT_DESCRIPTION','fa-suitcase-medical',4,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `a_yf_module_reference`(`id`,`module_id`,`ref_table`,`ref_column`,`sort`,`is_custom_field_table`) values
			(1,4,'vtiger_crmentity','crmid',1,0),
			(2,4,'vtiger_contactdetails','contactid',2,0),
			(3,4,'vtiger_contactaddress','contactaddressid',3,0),
			(4,4,'vtiger_contactsubdetails','contactsubscriptionid',4,0),
			(5,4,'vtiger_contactscf','contactid',5,1),
			(6,4,'vtiger_customerdetails','customerid',6,0),
			(7,4,'vtiger_entity_stats','crmid',7,0),
			(8,6,'vtiger_crmentity','crmid',1,0),
			(9,6,'vtiger_account','accountid',2,0),
			(10,6,'vtiger_accountaddress','accountaddressid',3,0),
			(11,6,'vtiger_accountscf','accountid',4,1),
			(12,6,'vtiger_entity_stats','crmid',5,0),
			(13,7,'vtiger_crmentity','crmid',1,0),
			(14,7,'vtiger_leaddetails','leadid',2,0),
			(15,7,'vtiger_leadsubdetails','leadsubscriptionid',3,0),
			(16,7,'vtiger_leadaddress','leadaddressid',4,0),
			(17,7,'vtiger_leadscf','leadid',5,1),
			(18,7,'vtiger_entity_stats','crmid',6,0),
			(19,8,'vtiger_crmentity','crmid',1,0),
			(20,8,'vtiger_notes','notesid',2,0),
			(21,8,'vtiger_notescf','notesid',3,1),
			(22,9,'vtiger_crmentity','crmid',1,0),
			(23,9,'vtiger_activity','activityid',2,0),
			(24,9,'vtiger_activitycf','activityid',3,1),
			(25,13,'vtiger_crmentity','crmid',1,0),
			(26,13,'vtiger_troubletickets','ticketid',2,0),
			(27,13,'vtiger_ticketcf','ticketid',3,1),
			(28,13,'vtiger_entity_stats','crmid',4,0),
			(29,14,'vtiger_crmentity','crmid',1,0),
			(30,14,'vtiger_products','productid',2,0),
			(31,14,'vtiger_productcf','productid',3,1),
			(32,15,'vtiger_crmentity','crmid',1,0),
			(33,15,'vtiger_faq','id',2,0),
			(34,15,'vtiger_faqcf','faqid',3,1),
			(35,18,'vtiger_crmentity','crmid',1,0),
			(36,18,'vtiger_vendor','vendorid',2,0),
			(37,18,'vtiger_vendoraddress','vendorid',3,0),
			(38,18,'vtiger_vendorcf','vendorid',4,1),
			(39,18,'vtiger_entity_stats','crmid',5,0),
			(40,19,'vtiger_crmentity','crmid',1,0),
			(41,19,'vtiger_pricebook','pricebookid',2,0),
			(42,19,'vtiger_pricebookcf','pricebookid',3,1),
			(43,26,'vtiger_crmentity','crmid',1,0),
			(44,26,'vtiger_campaign','campaignid',2,0),
			(45,26,'vtiger_campaignscf','campaignid',3,1),
			(46,26,'vtiger_entity_stats','crmid',4,0),
			(47,29,'vtiger_users','id',1,0),
			(48,29,'vtiger_user2role','userid',2,0),
			(49,34,'vtiger_crmentity','crmid',1,0),
			(50,34,'vtiger_servicecontracts','servicecontractsid',2,0),
			(51,34,'vtiger_servicecontractscf','servicecontractsid',3,1),
			(52,34,'vtiger_entity_stats','crmid',4,0),
			(53,35,'vtiger_crmentity','crmid',1,0),
			(54,35,'vtiger_service','serviceid',2,0),
			(55,35,'vtiger_servicecf','serviceid',3,1),
			(56,37,'vtiger_crmentity','crmid',1,0),
			(57,37,'vtiger_assets','assetsid',2,0),
			(58,37,'vtiger_assetscf','assetsid',3,1),
			(59,40,'vtiger_crmentity','crmid',1,0),
			(60,40,'vtiger_modcomments','modcommentsid',2,0),
			(61,40,'vtiger_modcommentscf','modcommentsid',3,1),
			(62,41,'vtiger_crmentity','crmid',1,0),
			(63,41,'vtiger_projectmilestone','projectmilestoneid',2,0),
			(64,41,'vtiger_projectmilestonecf','projectmilestoneid',3,1),
			(65,42,'vtiger_crmentity','crmid',1,0),
			(66,42,'vtiger_projecttask','projecttaskid',2,0),
			(67,42,'vtiger_projecttaskcf','projecttaskid',3,1),
			(68,43,'vtiger_crmentity','crmid',1,0),
			(69,43,'vtiger_project','projectid',2,0),
			(70,43,'vtiger_projectcf','projectid',3,1),
			(71,43,'vtiger_entity_stats','crmid',4,0),
			(72,45,'vtiger_crmentity','crmid',1,0),
			(73,45,'vtiger_smsnotifier','smsnotifierid',2,0),
			(74,45,'vtiger_smsnotifiercf','smsnotifierid',3,1),
			(75,51,'vtiger_crmentity','crmid',1,0),
			(76,51,'vtiger_osstimecontrol','osstimecontrolid',2,0),
			(77,51,'vtiger_osstimecontrolcf','osstimecontrolid',3,1),
			(78,54,'vtiger_crmentity','crmid',1,0),
			(79,54,'vtiger_ossmailview','ossmailviewid',2,0),
			(80,54,'vtiger_ossmailviewcf','ossmailviewid',3,1),
			(81,57,'vtiger_crmentity','crmid',1,0),
			(82,57,'vtiger_ossoutsourcedservices','ossoutsourcedservicesid',2,0),
			(83,57,'vtiger_ossoutsourcedservicescf','ossoutsourcedservicesid',3,1),
			(84,58,'vtiger_crmentity','crmid',1,0),
			(85,58,'vtiger_osssoldservices','osssoldservicesid',2,0),
			(86,58,'vtiger_osssoldservicescf','osssoldservicesid',3,1),
			(87,59,'vtiger_crmentity','crmid',1,0),
			(88,59,'vtiger_outsourcedproducts','outsourcedproductsid',2,0),
			(89,59,'vtiger_outsourcedproductscf','outsourcedproductsid',3,1),
			(90,61,'vtiger_crmentity','crmid',1,0),
			(91,61,'vtiger_ossemployees','ossemployeesid',2,0),
			(92,61,'vtiger_ossemployeescf','ossemployeesid',3,1),
			(93,61,'vtiger_entity_stats','crmid',4,0),
			(94,74,'vtiger_crmentity','crmid',1,0),
			(95,74,'vtiger_callhistory','callhistoryid',2,0),
			(96,74,'vtiger_callhistorycf','callhistoryid',3,1),
			(97,75,'vtiger_crmentity','crmid',1,0),
			(98,75,'vtiger_ideas','ideasid',2,0),
			(99,75,'vtiger_ideascf','ideasid',3,1),
			(100,78,'vtiger_crmentity','crmid',1,0),
			(101,78,'vtiger_holidaysentitlement','holidaysentitlementid',2,0),
			(102,78,'vtiger_holidaysentitlementcf','holidaysentitlementid',3,1),
			(103,79,'vtiger_crmentity','crmid',1,0),
			(104,79,'vtiger_paymentsin','paymentsinid',2,0),
			(105,79,'vtiger_paymentsincf','paymentsinid',3,1),
			(106,80,'vtiger_crmentity','crmid',1,0),
			(107,80,'vtiger_paymentsout','paymentsoutid',2,0),
			(108,80,'vtiger_paymentsoutcf','paymentsoutid',3,1),
			(109,81,'vtiger_crmentity','crmid',1,0),
			(110,81,'vtiger_lettersin','lettersinid',2,0),
			(111,81,'vtiger_lettersincf','lettersinid',3,1),
			(112,82,'vtiger_crmentity','crmid',1,0),
			(113,82,'vtiger_lettersout','lettersoutid',2,0),
			(114,82,'vtiger_lettersoutcf','lettersoutid',3,1),
			(115,83,'vtiger_crmentity','crmid',1,0),
			(116,83,'u_yf_announcement','announcementid',2,0),
			(117,83,'u_yf_announcementcf','announcementid',3,1),
			(118,84,'vtiger_crmentity','crmid',1,0),
			(119,84,'vtiger_reservations','reservationsid',2,0),
			(120,84,'vtiger_reservationscf','reservationsid',3,1),
			(121,85,'vtiger_crmentity','crmid',1,0),
			(122,85,'u_yf_squoteenquiries','squoteenquiriesid',2,0),
			(123,85,'u_yf_squoteenquiriescf','squoteenquiriesid',3,1),
			(124,85,'vtiger_entity_stats','crmid',4,0),
			(125,86,'vtiger_crmentity','crmid',1,0),
			(126,86,'u_yf_ssalesprocesses','ssalesprocessesid',2,0),
			(127,86,'u_yf_ssalesprocessescf','ssalesprocessesid',3,1),
			(128,86,'vtiger_entity_stats','crmid',4,0),
			(129,87,'vtiger_crmentity','crmid',1,0),
			(130,87,'u_yf_srequirementscards','srequirementscardsid',2,0),
			(131,87,'u_yf_srequirementscardscf','srequirementscardsid',3,1),
			(132,87,'vtiger_entity_stats','crmid',4,0),
			(133,88,'vtiger_crmentity','crmid',1,0),
			(134,88,'u_yf_scalculations','scalculationsid',2,0),
			(135,88,'u_yf_scalculationscf','scalculationsid',3,1),
			(136,88,'vtiger_entity_stats','crmid',4,0),
			(137,89,'vtiger_crmentity','crmid',1,0),
			(138,89,'u_yf_squotes','squotesid',2,0),
			(139,89,'u_yf_squotescf','squotesid',3,1),
			(140,89,'u_yf_squotes_address','squotesaddressid',4,0),
			(141,89,'vtiger_entity_stats','crmid',5,0),
			(142,90,'vtiger_crmentity','crmid',1,0),
			(143,90,'u_yf_ssingleorders','ssingleordersid',2,0),
			(144,90,'u_yf_ssingleorderscf','ssingleordersid',3,1),
			(145,90,'u_yf_ssingleorders_address','ssingleordersaddressid',4,0),
			(146,90,'vtiger_entity_stats','crmid',5,0),
			(147,91,'vtiger_crmentity','crmid',1,0),
			(148,91,'u_yf_srecurringorders','srecurringordersid',2,0),
			(149,91,'u_yf_srecurringorderscf','srecurringordersid',3,1),
			(150,91,'u_yf_recurring_info','srecurringordersid',4,0),
			(151,91,'u_yf_srecurringorders_address','srecurringordersaddressid',5,0),
			(152,91,'vtiger_entity_stats','crmid',6,0),
			(153,92,'vtiger_crmentity','crmid',1,0),
			(154,92,'u_yf_partners','partnersid',2,0),
			(155,92,'u_yf_partnerscf','partnersid',3,1),
			(156,92,'u_yf_partners_address','partneraddressid',4,0),
			(157,92,'vtiger_entity_stats','crmid',5,0),
			(158,93,'vtiger_crmentity','crmid',1,0),
			(159,93,'u_yf_competition','competitionid',2,0),
			(160,93,'u_yf_competitioncf','competitionid',3,1),
			(161,93,'u_yf_competition_address','competitionaddressid',4,0),
			(162,93,'vtiger_entity_stats','crmid',5,0),
			(163,94,'vtiger_crmentity','crmid',1,0),
			(164,94,'u_yf_fbookkeeping','fbookkeepingid',2,0),
			(165,94,'u_yf_fbookkeepingcf','fbookkeepingid',3,1),
			(166,95,'vtiger_crmentity','crmid',1,0),
			(167,95,'u_yf_finvoice','finvoiceid',2,0),
			(168,95,'u_yf_finvoicecf','finvoiceid',3,1),
			(169,95,'u_yf_finvoice_address','finvoiceaddressid',4,0),
			(170,96,'vtiger_crmentity','crmid',1,0),
			(171,96,'u_yf_knowledgebase','knowledgebaseid',2,0),
			(172,96,'u_yf_knowledgebasecf','knowledgebaseid',3,1),
			(173,97,'vtiger_crmentity','crmid',1,0),
			(174,97,'u_yf_istorages','istorageid',2,0),
			(175,97,'u_yf_istoragescf','istorageid',3,1),
			(176,97,'u_yf_istorages_address','istorageaddressid',4,0),
			(177,98,'vtiger_crmentity','crmid',1,0),
			(178,98,'u_yf_igrn','igrnid',2,0),
			(179,98,'u_yf_igrncf','igrnid',3,1),
			(180,99,'vtiger_crmentity','crmid',1,0),
			(181,99,'u_yf_finvoiceproforma','finvoiceproformaid',2,0),
			(182,99,'u_yf_finvoiceproformacf','finvoiceproformaid',3,1),
			(183,99,'u_yf_finvoiceproforma_address','finvoiceproformaaddressid',4,0),
			(184,100,'vtiger_crmentity','crmid',1,0),
			(185,100,'u_yf_igdn','igdnid',2,0),
			(186,100,'u_yf_igdncf','igdnid',3,1),
			(187,101,'vtiger_crmentity','crmid',1,0),
			(188,101,'u_yf_iidn','iidnid',2,0),
			(189,101,'u_yf_iidncf','iidnid',3,1),
			(190,102,'vtiger_crmentity','crmid',1,0),
			(191,102,'u_yf_igin','iginid',2,0),
			(192,102,'u_yf_igincf','iginid',3,1),
			(193,103,'vtiger_crmentity','crmid',1,0),
			(194,103,'u_yf_ipreorder','ipreorderid',2,0),
			(195,103,'u_yf_ipreordercf','ipreorderid',3,1),
			(196,104,'vtiger_crmentity','crmid',1,0),
			(197,104,'u_yf_istdn','istdnid',2,0),
			(198,104,'u_yf_istdncf','istdnid',3,1),
			(199,105,'vtiger_crmentity','crmid',1,0),
			(200,105,'u_yf_istn','istnid',2,0),
			(201,105,'u_yf_istncf','istnid',3,1),
			(202,106,'vtiger_crmentity','crmid',1,0),
			(203,106,'u_yf_istrn','istrnid',2,0),
			(204,106,'u_yf_istrncf','istrnid',3,1),
			(205,107,'vtiger_crmentity','crmid',1,0),
			(206,107,'u_yf_fcorectinginvoice','fcorectinginvoiceid',2,0),
			(207,107,'u_yf_fcorectinginvoicecf','fcorectinginvoiceid',3,1),
			(208,107,'u_yf_fcorectinginvoice_address','fcorectinginvoiceaddressid',4,0),
			(209,108,'vtiger_crmentity','crmid',1,0),
			(210,108,'u_yf_igrnc','igrncid',2,0),
			(211,108,'u_yf_igrnccf','igrncid',3,1),
			(212,109,'vtiger_crmentity','crmid',1,0),
			(213,109,'u_yf_igdnc','igdncid',2,0),
			(214,109,'u_yf_igdnccf','igdncid',3,1),
			(215,111,'vtiger_crmentity','crmid',1,0),
			(216,111,'u_yf_notification','notificationid',2,0),
			(217,112,'vtiger_crmentity','crmid',1,0),
			(218,112,'u_yf_emailtemplates','emailtemplatesid',2,0),
			(219,113,'vtiger_crmentity','crmid',1,0),
			(220,113,'u_yf_cfixedassets','cfixedassetsid',2,0),
			(221,113,'u_yf_cfixedassetscf','cfixedassetsid',3,1),
			(222,114,'vtiger_crmentity','crmid',1,0),
			(223,114,'u_yf_cinternaltickets','cinternalticketsid',2,0),
			(224,114,'u_yf_cinternalticketscf','cinternalticketsid',3,1),
			(225,115,'vtiger_crmentity','crmid',1,0),
			(226,115,'u_yf_finvoicecost','finvoicecostid',2,0),
			(227,115,'u_yf_finvoicecostcf','finvoicecostid',3,1),
			(228,115,'u_yf_finvoicecost_address','finvoicecostaddressid',4,0),
			(229,116,'vtiger_crmentity','crmid',1,0),
			(230,116,'u_yf_cmileagelogbook','cmileagelogbookid',2,0),
			(231,116,'u_yf_cmileagelogbookcf','cmileagelogbookid',3,1),
			(232,117,'vtiger_crmentity','crmid',1,0),
			(233,117,'u_yf_svendorenquiries','svendorenquiriesid',2,0),
			(234,117,'u_yf_svendorenquiriescf','svendorenquiriesid',3,1),
			(235,117,'vtiger_entity_stats','crmid',4,0),
			(236,119,'vtiger_crmentity','crmid',1,0),
			(237,119,'u_yf_multicompany','multicompanyid',2,0),
			(238,119,'u_yf_multicompanycf','multicompanyid',3,1),
			(239,121,'vtiger_crmentity','crmid',1,0),
			(240,121,'u_yf_datasetregister','datasetregisterid',2,0),
			(241,121,'u_yf_datasetregistercf','datasetregisterid',3,1),
			(242,122,'vtiger_crmentity','crmid',1,0),
			(243,122,'u_yf_activityregister','activityregisterid',2,0),
			(244,122,'u_yf_activityregistercf','activityregisterid',3,1),
			(245,123,'vtiger_crmentity','crmid',1,0),
			(246,123,'u_yf_locationregister','locationregisterid',2,0),
			(247,123,'u_yf_locationregistercf','locationregisterid',3,1),
			(248,124,'vtiger_crmentity','crmid',1,0),
			(249,124,'u_yf_incidentregister','incidentregisterid',2,0),
			(250,124,'u_yf_incidentregistercf','incidentregisterid',3,1),
			(251,125,'vtiger_crmentity','crmid',1,0),
			(252,125,'u_yf_auditregister','auditregisterid',2,0),
			(253,125,'u_yf_auditregistercf','auditregisterid',3,1),
			(254,127,'vtiger_crmentity','crmid',1,0),
			(255,127,'u_yf_approvals','approvalsid',2,0),
			(256,128,'vtiger_crmentity','crmid',1,0),
			(257,128,'u_yf_approvalsregister','approvalsregisterid',2,0),
			(258,130,'vtiger_crmentity','crmid',1,0),
			(259,130,'u_yf_locations','locationsid',2,0),
			(260,130,'u_yf_locations_address','locationaddressid',3,0),
			(261,131,'vtiger_crmentity','crmid',1,0),
			(262,131,'u_yf_occurrences','occurrencesid',2,0),
			(263,132,'vtiger_crmentity','crmid',1,0),
			(264,132,'u_yf_productcategory','productcategoryid',2,0),
			(265,132,'u_yf_productcategorycf','productcategoryid',3,1),
			(266,133,'vtiger_crmentity','crmid',1,0),
			(267,133,'u_yf_bankaccounts','bankaccountsid',2,0),
			(268,133,'u_yf_bankaccountscf','bankaccountsid',3,1),
			(269,134,'vtiger_crmentity','crmid',1,0),
			(270,134,'u_yf_queue','queueid',2,0),
			(271,135,'vtiger_crmentity','crmid',1,0),
			(272,135,'u_yf_passwords','passwordsid',2,0),
			(273,136,'vtiger_crmentity','crmid',1,0),
			(274,136,'u_yf_smstemplates','smstemplatesid',2,0),
			(275,136,'u_yf_smstemplatescf','smstemplatesid',3,1),
			(276,138,'vtiger_crmentity','crmid',1,0),
			(277,138,'u_yf_report_template','id',2,0),
			(278,138,'u_yf_report_template_cf','id',3,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `a_yf_modules_packages`(`package_id`,`module_id`) values
			(1,7),
			(1,19),
			(1,88),
			(1,89),
			(1,91),
			(1,87),
			(1,86),
			(1,85),
			(1,90),
			(2,94),
			(2,107),
			(2,95),
			(2,115),
			(2,99),
			(2,79),
			(2,80),
			(5,15),
			(5,13),
			(5,96),
			(5,34),
			(3,43),
			(3,41),
			(3,42),
			(4,7),
			(4,26),
			(4,131),
			(4,130);
			STR);

		$this->addSql(<<<STR
			insert  into `a_yf_pdf`(`pdfid`,`generator`,`module_name`,`header_content`,`body_content`,`footer_content`,`status`,`primary_name`,`secondary_name`,`meta_author`,`meta_keywords`,`metatags_status`,`meta_subject`,`meta_title`,`page_format`,`margin_chkbox`,`margin_top`,`margin_bottom`,`margin_left`,`margin_right`,`header_height`,`footer_height`,`page_orientation`,`language`,`filename`,`visibility`,`default`,`conditions`,`watermark_type`,`watermark_text`,`watermark_angle`,`watermark_image`,`template_members`,`one_pdf`,`type`,`styles`) values
			(33,'YetiForcePDF','FInvoice','<div>\n<table style=\\"font-family:\\'DejaVu Sans\\';font-size:10px;width:100%;\\">\n	<tbody>\n		<tr>\n			<td style=\\"text-align:left;width:50%;\\">$(translate : Other.PDF|LBL_INVOICE_NUMBER)$ $(record : number)$</td>\n			<td style=\\"text-align:right;width:50%;\\">$(translate : Other.PDF|Issued Date)$ $(record : issue_time)$</td>\n		</tr>\n	</tbody>\n</table>\n</div>\n','<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:9px;margin-bottom:6px;width:100%;\\">\n	<thead>\n		<tr>\n			<th style=\\"text-align:center;width:25%;\\">$(translate : Other.PDF|Issued Date)$</th>\n			<th style=\\"text-align:center;width:25%;\\">$(translate : Other.PDF|LBL_SALE_DATE)$</th>\n			<th style=\\"text-align:center;width:25%;\\">$(translate : FInvoice|FL_PAYMENT_DATE)$</th>\n			<th style=\\"text-align:center;width:25%;\\">$(translate : Other.PDF|LBL_PAYMENT_METHOD)$</th>\n		</tr>\n	</thead>\n	<tbody>\n		<tr>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;text-align:center;\\">$(record : issue_time)$</td>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;text-align:center;\\">$(record : saledate)$</td>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;text-align:center;\\">$(record : paymentdate)$</td>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;text-align:center;\\">$(record : finvoice_formpayment)$</td>\n		</tr>\n	</tbody>\n</table>\n<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:9px;line-height:1.1em;text-align:center;width:100%;\\">\n	<thead>\n		<tr>\n			<th style=\\"font-size:9px;width:50%;\\">$(translate : Other.PDF|LBL_DEALER)$</th>\n			<th style=\\"font-size:9px;width:50%;\\">$(translate : Other.PDF|LBL_BUYER)$</th>\n		</tr>\n	</thead>\n	<tbody>\n		<tr>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;line-height:1.2;vertical-align:top;\\">$(organization : 1|company_name)$<br>\n			$(organization : 1|addresslevel8a)$ $(organization : 1|buildingnumbera)$<br>\n			$(organization : 1|addresslevel7a)$ $(organization : 1|addresslevel5a)$<br>\n			$(translate : Other.PDF|LBL_VATID)$: $(organization : 1|vat)$</td>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;line-height:1.2;vertical-align:top;\\">$(relatedRecord : accountid|accountname|Accounts)$<br>\n			$(relatedRecord : accountid|addresslevel8a|Accounts)$ $(relatedRecord : accountid|buildingnumbera|Accounts)$<br>\n			$(relatedRecord : accountid|addresslevel7a|Accounts)$ $(relatedRecord : accountid|addresslevel5a|Accounts)$<br>\n			$(translate : Other.PDF|LBL_VATID)$: $(relatedRecord : accountid|vat_id|Accounts)$</td>\n		</tr>\n	</tbody>\n</table>\n<div style=\\"font-family:\\'DejaVu Sans\\';margin-top:12px;text-align:center;\\">\n<h3>$(translate : Other.PDF|LBL_INVOICE_NUMBER)$: $(record : number)$</h3>\n</div>\n<div style=\\"font-family:\\'DejaVu Sans\\';font-size:8px;margin-bottom:20px;margin-left:0px;margin-right:0px;margin-top:10px;\\">$(custom : ProductsTableShortVersion)$</div>\n<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:8px;margin:0px 0px 20px 0px;width:100%;\\">\n	<tbody>\n		<tr>\n			<td style=\\"vertical-align:top;width:50%;\\">$(custom : TableTaxSummary)$</td>\n			<td style=\\"vertical-align:top;width:50%;\\">$(custom : TableDiscountSummary)$</td>\n		</tr>\n	</tbody>\n</table>\n<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:8px;width:100%;\\">\n	<tbody>\n		<tr>\n			<td style=\\"vertical-align:top;width:50%;\\">$(custom : TableCurrencySummary)$</td>\n			<td style=\\"vertical-align:top;width:50%;\\">\n			<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;width:100%;\\">\n				<thead>\n					<tr>\n						<th style=\\"font-size:10px;\\">$(translate : Other.PDF|LBL_TO_PAY)$</th>\n					</tr>\n				</thead>\n				<tbody>\n					<tr>\n						<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;font-size:12px;font-weight:bold;text-align:center;\\">$(record : sum_gross)$</td>\n					</tr>\n				</tbody>\n			</table>\n			</td>\n		</tr>\n	</tbody>\n</table>\n<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:9px;margin:20px 0px;text-align:left;width:100%;\\">\n	<thead>\n		<tr>\n			<th style=\\"text-align:left;\\">\n			<div style=\\"margin-left:4px;\\">$(translate : Other.PDF|LBL_COMMENTS)$</div>\n			</th>\n		</tr>\n	</thead>\n	<tbody>\n		<tr>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;padding:10px;\\">$(record : attention)$</td>\n		</tr>\n	</tbody>\n</table>\n<div style=\\"font-family:\\'DejaVu Sans\\';font-size:8px;text-align:left;\\">$(translate : Other.PDF|LBL_STAGE)$: $(record : assigned_user_id)$</div>\n','<table style=\\"font-family:\\'DejaVu Sans\\';font-size:8px;width:100%;\\">\n<tbody>\n	<tr>\n		<td style=\\"text-align:right;width:50%;\\">$(custom : CurrentPage)$/$(custom : AllPages)$</td>\n	</tr>\n</tbody>\n</table>',1,'SINGLE_FInvoice','SINGLE_FInvoice','','',1,'','','A4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'PLL_PORTRAIT','','','PLL_LISTVIEW,PLL_DETAILVIEW',1,'[]',0,'',0,'','',NULL,0,NULL),
			(34,'YetiForcePDF','FInvoiceProforma','<div>\n<table style=\\"font-family:\\'DejaVu Sans\\';font-size:10px;width:100%;\\">\n	<tbody>\n		<tr>\n			<td style=\\"text-align:left;width:50%;\\">$(translate : FInvoiceProforma|SINGLE_FInvoiceProforma)$ $(record : number)$</td>\n			<td style=\\"text-align:right;width:50%;\\">$(translate : Other.PDF|LBL_SALE_DATE)$ $(record : saledate)$</td>\n		</tr>\n	</tbody>\n</table>\n</div>\n','<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:9px;margin-bottom:6px;width:100%;\\">\n	<thead>\n		<tr>\n			<th style=\\"text-align:center;width:25%;\\">$(translate : Other.PDF|LBL_SALE_DATE)$</th>\n			<th style=\\"text-align:center;width:25%;\\">$(translate : FInvoiceProforma|FL_PAYMENT_DATE)$</th>\n			<th style=\\"text-align:center;width:25%;\\">$(translate : Other.PDF|LBL_PAYMENT_METHOD)$</th>\n		</tr>\n	</thead>\n	<tbody>\n		<tr>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;text-align:center;\\">$(record : saledate)$</td>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;text-align:center;\\">$(record : paymentdate)$</td>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;text-align:center;\\">$(record : finvoiceproforma_formpayment)$</td>\n		</tr>\n	</tbody>\n</table>\n<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:9px;line-height:1.1em;text-align:center;width:100%;\\">\n	<thead>\n		<tr>\n			<th style=\\"font-size:9px;width:50%;\\">$(translate : Other.PDF|LBL_DEALER)$</th>\n			<th style=\\"font-size:9px;width:50%;\\">$(translate : Other.PDF|LBL_BUYER)$</th>\n		</tr>\n	</thead>\n	<tbody>\n		<tr>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;line-height:1.2;vertical-align:top;\\">$(organization : 1|company_name)$<br>\n			$(organization : 1|addresslevel8a)$ $(organization : 1|buildingnumbera)$<br>\n			$(organization : 1|addresslevel7a)$ $(organization : 1|addresslevel5a)$<br>\n			$(translate : Other.PDF|LBL_VATID)$: $(organization : 1|vat)$</td>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;line-height:1.2;vertical-align:top;\\">$(relatedRecord : accountid|accountname|Accounts)$<br>\n			$(relatedRecord : accountid|addresslevel8a|Accounts)$ $(relatedRecord : accountid|buildingnumbera|Accounts)$<br>\n			$(relatedRecord : accountid|addresslevel7a|Accounts)$ $(relatedRecord : accountid|addresslevel5a|Accounts)$<br>\n			$(translate : Other.PDF|LBL_VATID)$: $(relatedRecord : accountid|vat_id|Accounts)$</td>\n		</tr>\n	</tbody>\n</table>\n<div style=\\"font-family:\\'DejaVu Sans\\';margin-top:12px;text-align:center;\\">\n<h3>$(translate : FInvoiceProforma|SINGLE_FInvoiceProforma)$: $(record : number)$</h3>\n</div>\n<div style=\\"font-family:\\'DejaVu Sans\\';font-size:8px;margin-bottom:20px;margin-left:0px;margin-right:0px;margin-top:10px;\\">$(custom : ProductsTableShortVersion)$</div>\n<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:8px;margin:0px 0px 20px 0px;width:100%;\\">\n	<tbody>\n		<tr>\n			<td style=\\"vertical-align:top;width:50%;\\">$(custom : TableTaxSummary)$</td>\n			<td style=\\"vertical-align:top;width:50%;\\">$(custom : TableDiscountSummary)$</td>\n		</tr>\n	</tbody>\n</table>\n<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:8px;width:100%;\\">\n	<tbody>\n		<tr>\n			<td style=\\"vertical-align:top;width:50%;\\">$(custom : TableCurrencySummary)$</td>\n			<td style=\\"vertical-align:top;width:50%;\\">\n			<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;width:100%;\\">\n				<thead>\n					<tr>\n						<th style=\\"font-size:10px;\\">$(translate : Other.PDF|LBL_TO_PAY)$</th>\n					</tr>\n				</thead>\n				<tbody>\n					<tr>\n						<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;font-size:12px;font-weight:bold;text-align:center;\\">$(record : sum_gross)$</td>\n					</tr>\n				</tbody>\n			</table>\n			</td>\n		</tr>\n	</tbody>\n</table>\n<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:9px;margin:20px 0px;text-align:left;width:100%;\\">\n	<thead>\n		<tr>\n			<th style=\\"text-align:left;\\">\n			<div style=\\"margin-left:4px;\\">$(translate : Other.PDF|LBL_COMMENTS)$</div>\n			</th>\n		</tr>\n	</thead>\n	<tbody>\n		<tr>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;padding:10px;\\">$(record : attention)$</td>\n		</tr>\n	</tbody>\n</table>\n<div style=\\"font-family:\\'DejaVu Sans\\';font-size:8px;text-align:left;\\">$(translate : Other.PDF|LBL_STAGE)$: $(record : assigned_user_id)$</div>\n','<table style=\\"font-family:\\'DejaVu Sans\\';font-size:8px;width:100%;\\">\n<tbody>\n	<tr>\n		<td style=\\"text-align:right;width:50%;\\">$(custom : CurrentPage)$/$(custom : AllPages)$</td>\n	</tr>\n</tbody>\n</table>',1,'SINGLE_FInvoiceProforma','SINGLE_FInvoiceProforma','','',1,'','','A4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'PLL_PORTRAIT','','','PLL_LISTVIEW,PLL_DETAILVIEW',1,'[]',0,'',0,'','',NULL,0,NULL),
			(35,'YetiForcePDF','FCorectingInvoice','<div>\n<table style=\\"font-family:\\'DejaVu Sans\\';font-size:10px;width:100%;\\">\n	<tbody>\n		<tr>\n			<td style=\\"text-align:left;width:50%;\\">$(translate : FCorectingInvoice|SINGLE_FCorectingInvoice)$ $(record : number)$</td>\n			<td style=\\"text-align:right;width:50%;\\">$(translate : Other.PDF|LBL_SALE_DATE)$ $(record : saledate)$</td>\n		</tr>\n	</tbody>\n</table>\n</div>','<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:9px;margin-bottom:6px;width:100%;\\">\n	<thead>\n		<tr>\n			<th style=\\"text-align:center;width:25%;\\">$(translate : Other.PDF|LBL_SALE_DATE)$</th>\n			<th style=\\"text-align:center;width:25%;\\">$(translate : FCorectingInvoice|FL_PAYMENT_DATE)$</th>\n			<th style=\\"text-align:center;width:25%;\\">$(translate : Other.PDF|LBL_PAYMENT_METHOD)$</th>\n		</tr>\n	</thead>\n	<tbody>\n		<tr>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;text-align:center;height:17px;\\">$(record : saledate)$</td>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;text-align:center;height:17px;\\">$(record : paymentdate)$</td>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;text-align:center;height:17px;\\">$(record : payment_methods)$</td>\n		</tr>\n	</tbody>\n</table>\n<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:9px;line-height:1.1em;text-align:center;width:100%;\\">\n	<thead>\n		<tr>\n			<th style=\\"font-size:9px;width:50%;\\">$(translate : Other.PDF|LBL_DEALER)$</th>\n			<th style=\\"font-size:9px;width:50%;\\">$(translate : Other.PDF|LBL_BUYER)$</th>\n		</tr>\n	</thead>\n	<tbody>\n		<tr>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;line-height:1.2;vertical-align:top;\\">\n			<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;width:100%;\\">\n				<tbody>\n					<tr>\n						<td>\u{a0}</td>\n						<td style=\\"vertical-align:top;\\">$(organization : 1|company_name)$<br>\n						$(organization : 1|addresslevel8a)$ $(organization : 1|buildingnumbera)$<br>\n						$(organization : 1|addresslevel7a)$ $(organization : 1|addresslevel5a)$<br>\n						$(translate : Other.PDF|LBL_VATID)$: $(organization : 1|vat)$</td>\n					</tr>\n				</tbody>\n			</table>\n			</td>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;line-height:1.2;vertical-align:top;\\">$(relatedRecord : accountid|accountname|Accounts)$<br>\n			$(relatedRecord : accountid|addresslevel8a|Accounts)$ $(relatedRecord : accountid|buildingnumbera|Accounts)$<br>\n			$(relatedRecord : accountid|addresslevel7a|Accounts)$ $(relatedRecord : accountid|addresslevel5a|Accounts)$<br>\n			$(translate : Other.PDF|LBL_VATID)$: $(relatedRecord : accountid|vat_id|Accounts)$</td>\n		</tr>\n	</tbody>\n</table>\n<div style=\\"font-family:\\'DejaVu Sans\\';margin-top:12px;text-align:center;\\">\n<h3>$(translate : FCorectingInvoice|SINGLE_FCorectingInvoice)$: $(record : number)$</h3>\n</div>\n<div style=\\"font-family:\\'DejaVu Sans\\';font-size:8px;margin-left:0px;margin-right:0px;margin-top:10px;\\">$(translate : Other.PDF|LBL_TO_FINVOICE_NUMBER)$: $(relatedRecord : finvoiceid|number|FInvoice)$</div>\n<div style=\\"font-family:\\'DejaVu Sans\\';font-size:8px;margin-bottom:20px;margin-left:0px;margin-right:0px;margin-top:10px;\\"><strong>$(translate : FCorectingInvoice|LBL_BEFORE_CORRECTION)$</strong><br>\n$(custom : ProductsTableCorrectingBefore)$</div>\n<div style=\\"font-family:\\'DejaVu Sans\\';font-size:8px;margin-bottom:5px;margin-left:0px;margin-right:0px;margin-top:10px;\\"><strong>$(translate : FCorectingInvoice|LBL_AFTER_CORRECTION)$</strong><br>\n$(custom : ProductsTableCorrectingAfter)$</div>\n<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:8px;margin:0px 0px 20px 0px;width:100%;\\">\n	<tbody>\n		<tr>\n			<td style=\\"vertical-align:top;width:50%;\\">$(custom : TableTaxSummary)$</td>\n			<td style=\\"vertical-align:top;width:50%;\\">$(custom : TableCurrencySummary)$</td>\n		</tr>\n		<tr>\n			<td style=\\"vertical-align:top;width:50%;\\">$(custom : TableDiscountSummary)$</td>\n		</tr>\n	</tbody>\n</table>\n<strong style=\\"font-family:\\'DejaVu Sans\\';font-size:8px;\\">$(translate : FCorectingInvoice|LBL_CORRECTION_SUMMARY)$</strong>\n<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:8px;margin:0px 0px 20px 0px;width:100%;\\">\n	<tbody>\n		<tr>\n			<td style=\\"vertical-align:top;width:50%;\\">$(custom : TableCorrectTaxSummary)$</td>\n			<td style=\\"vertical-align:top;width:50%;\\">$(custom : TableCorrectDiscountSummary)$</td>\n		</tr>\n	</tbody>\n</table>\n<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:8px;width:100%;\\">\n	<tbody>\n		<tr>\n			<td style=\\"vertical-align:top;width:50%;\\"></td>\n			<td style=\\"vertical-align:top;width:50%;\\">\n			<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;width:100%;\\">\n				<thead>\n					<tr>\n						<th style=\\"font-size:10px;\\">$(translate : Other.PDF|LBL_TO_PAY)$</th>\n					</tr>\n				</thead>\n				<tbody>\n					<tr>\n						<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;font-size:12px;font-weight:bold;text-align:center;\\">$(custom : AmountToPay)$</td>\n					</tr>\n				</tbody>\n			</table>\n			</td>\n		</tr>\n	</tbody>\n</table>\n<table cellspacing=\\"0\\" style=\\"border-collapse:collapse;font-family:\\'DejaVu Sans\\';font-size:9px;margin:20px 0px;text-align:left;width:100%;\\">\n	<thead>\n		<tr>\n			<th style=\\"text-align:left;\\">\n			<div style=\\"margin-left:4px;\\">$(translate : Other.PDF|LBL_COMMENTS)$</div>\n			</th>\n		</tr>\n	</thead>\n	<tbody>\n		<tr>\n			<td style=\\"border-color:#dddddd;border-style:solid;border-width:1px;padding:10px;\\">$(record : attention)$</td>\n		</tr>\n	</tbody>\n</table>\n<div style=\\"font-family:\\'DejaVu Sans\\';font-size:8px;text-align:left;\\">$(translate : Other.PDF|LBL_STAGE)$: $(record : assigned_user_id)$</div>','<table style=\\"font-family:\\'DejaVu Sans\\';font-size:8px;width:100%;\\">\n	<tbody>\n		<tr>\n			<td style=\\"text-align:right;width:50%;\\">$(custom : CurrentPage)$/$(custom : AllPages)$</td>\n		</tr>\n	</tbody>\n</table>',1,'SINGLE_FCorectingInvoice','SINGLE_FCorectingInvoice','','',1,'','','A4',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'PLL_PORTRAIT','','','PLL_LISTVIEW,PLL_DETAILVIEW',1,'[]',0,'',0,'','',NULL,0,NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `a_yf_record_list_filter`(`id`,`relationid`,`rel_relationid`,`dest_relationid`,`label`) values
			(1,347,10,1,NULL),
			(2,354,126,1,NULL),
			(3,424,452,1,NULL),
			(4,635,579,1,NULL),
			(5,603,117,95,NULL),
			(6,604,218,95,NULL),
			(7,601,95,117,NULL),
			(8,602,95,218,NULL),
			(9,661,452,452,NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `a_yf_settings_modules`(`id`,`name`,`status`,`created_time`) values
			(1,'AdvancedPermission',1,'2020-09-09 12:08:50'),
			(2,'ApiAddress',1,'2020-09-09 12:08:50'),
			(3,'AutomaticAssignment',1,'2020-09-09 12:08:50'),
			(4,'Backup',1,'2020-09-09 12:08:50'),
			(5,'BruteForce',1,'2020-09-09 12:08:50'),
			(6,'BusinessHours',1,'2020-09-09 12:08:50'),
			(7,'Calendar',1,'2020-09-09 12:08:50'),
			(8,'Colors',1,'2020-09-09 12:08:50'),
			(9,'Companies',1,'2020-09-09 12:08:50'),
			(10,'ConfReport',1,'2020-09-09 12:08:50'),
			(11,'Countries',1,'2020-09-09 12:08:50'),
			(12,'CronTasks',1,'2020-09-09 12:08:50'),
			(13,'Currency',1,'2020-09-09 12:08:50'),
			(14,'CurrencyUpdate',1,'2020-09-09 12:08:50'),
			(15,'CustomView',1,'2020-09-09 12:08:50'),
			(16,'Dav',1,'2020-09-09 12:08:50'),
			(17,'EventHandler',1,'2020-09-09 12:08:50'),
			(18,'FinancialProcesses',1,'2020-09-09 12:08:50'),
			(19,'GlobalPermission',1,'2020-09-09 12:08:50'),
			(20,'Groups',1,'2020-09-09 12:08:50'),
			(21,'Help',1,'2020-09-09 12:08:50'),
			(23,'InterestsConflict',1,'2020-09-09 12:08:50'),
			(24,'Inventory',1,'2020-09-09 12:08:50'),
			(25,'LangManagement',1,'2020-09-09 12:08:50'),
			(26,'LayoutEditor',1,'2020-09-09 12:08:50'),
			(27,'Leads',1,'2020-09-09 12:08:50'),
			(28,'Log',1,'2020-09-09 12:08:50'),
			(29,'LoginHistory',1,'2020-09-09 12:08:50'),
			(30,'Logs',1,'2020-09-09 12:08:50'),
			(32,'Mail',1,'2020-09-09 12:08:50'),
			(33,'MailIntegration',1,'2020-09-09 12:08:50'),
			(34,'MailSmtp',1,'2020-09-09 12:08:50'),
			(35,'Map',1,'2020-09-09 12:08:50'),
			(36,'MappedFields',1,'2020-09-09 12:08:50'),
			(37,'MarketingProcesses',1,'2020-09-09 12:08:50'),
			(39,'Menu',1,'2020-09-09 12:08:50'),
			(40,'ModTracker',1,'2020-09-09 12:08:50'),
			(41,'ModuleManager',1,'2020-09-09 12:08:50'),
			(42,'Notifications',1,'2020-09-09 12:08:50'),
			(43,'OSSMail',1,'2020-09-09 12:08:50'),
			(44,'OSSMailScanner',1,'2020-09-09 12:08:50'),
			(45,'OSSMailView',1,'2020-09-09 12:08:50'),
			(47,'Password',1,'2020-09-09 12:08:50'),
			(48,'PBX',1,'2020-09-09 12:08:50'),
			(49,'PDF',1,'2020-09-09 12:08:50'),
			(50,'Picklist',1,'2020-09-09 12:08:50'),
			(51,'PickListDependency',1,'2020-09-09 12:08:50'),
			(52,'Profiles',1,'2020-09-09 12:08:50'),
			(53,'PublicHoliday',1,'2020-09-09 12:08:50'),
			(54,'QuickCreateEditor',1,'2020-09-09 12:08:50'),
			(55,'RealizationProcesses',1,'2020-09-09 12:08:50'),
			(56,'RecordAllocation',1,'2020-09-09 12:08:50'),
			(57,'Roles',1,'2020-09-09 12:08:50'),
			(58,'SalesProcesses',1,'2020-09-09 12:08:50'),
			(59,'Search',1,'2020-09-09 12:08:50'),
			(60,'SharingAccess',1,'2020-09-09 12:08:50'),
			(61,'SlaPolicy',1,'2020-09-09 12:08:50'),
			(62,'SMSNotifier',1,'2020-09-09 12:08:50'),
			(64,'SupportProcesses',1,'2020-09-09 12:08:50'),
			(65,'TimeControlProcesses',1,'2020-09-09 12:08:50'),
			(66,'TreesManager',1,'2020-09-09 12:08:50'),
			(67,'TwoFactorAuthentication',1,'2020-09-09 12:08:50'),
			(68,'Updates',1,'2020-09-09 12:08:50'),
			(69,'Users',1,'2020-09-09 12:08:50'),
			(70,'WebserviceApps',1,'2020-09-09 12:08:50'),
			(71,'WebserviceUsers',1,'2020-09-09 12:08:50'),
			(72,'Widgets',1,'2020-09-09 12:08:50'),
			(73,'WidgetsManagement',1,'2020-09-09 12:08:50'),
			(74,'Workflows',1,'2020-09-09 12:08:50'),
			(75,'RecordNumbering',1,'2020-09-15 09:08:50'),
			(76,'ConfigEditor',1,'2020-09-15 12:08:50'),
			(77,'Watchdog',1,'2020-09-15 13:08:50'),
			(78,'Dependencies',1,'2020-09-16 08:08:50'),
			(80,'FieldsDependency',1,'2020-10-13 09:49:22'),
			(81,'Proxy',1,'2021-02-02 08:38:48'),
			(82,'Kanban',1,'2021-08-13 11:36:47'),
			(83,'MeetingServices',1,'2021-11-18 16:39:26'),
			(84,'Media',1,'2022-06-07 17:18:53'),
			(86,'RecordCollector',1,'2022-06-27 11:20:43'),
			(87,'WooCommerce',1,'2024-01-22 11:20:43'),
			(88,'MailServers',1,'2022-11-08 11:59:24'),
			(89,'MailSignature',1,'2023-05-16 15:32:28'),
			(90,'Comarch',1,'2023-05-16 15:32:28'),
			(91,'UserAuth',1,'2023-07-27 19:27:20');
			STR);

		$this->addSql(<<<'STR'
			insert  into `a_yf_taxes_config`(`param`,`value`) values
			('aggregation','0'),
			('default_mode','1'),
			('taxs','0,1,2,3');
			STR);

		$this->addSql(<<<'STR'
			insert  into `a_yf_taxes_global`(`id`,`name`,`value`,`status`,`default`,`show_name`) values
			(1,'VAT',23.00,0,0,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `com_vtiger_workflow_tasktypes`(`id`,`tasktypename`,`label`,`classname`,`classpath`,`templatepath`,`modules`,`sourcemodule`) values
			(1,'VTEmailTask','Send Mail','VTEmailTask','modules/com_vtiger_workflow/tasks/VTEmailTask.php','','{\"include\":[],\"exclude\":[]}',''),
			(2,'VTEntityMethodTask','Invoke Custom Function','VTEntityMethodTask','modules/com_vtiger_workflow/tasks/VTEntityMethodTask.php','','{\"include\":[],\"exclude\":[]}',''),
			(3,'VTCreateTodoTask','Create Todo','VTCreateTodoTask','modules/com_vtiger_workflow/tasks/VTCreateTodoTask.php','','{\"include\":[\"Accounts\",\"Leads\",\"Contacts\",\"HelpDesk\",\"Campaigns\",\"Project\",\"ServiceContracts\",\"Vendors\",\"Partners\",\"Competition\",\"OSSEmployees\",\"SSalesProcesses\",\"SQuoteEnquiries\",\"SRequirementsCards\",\"SCalculations\",\"SQuotes\",\"SSingleOrders\",\"SRecurringOrders\"],\"exclude\":[\"Calendar\",\"FAQ\",\"Events\"]}',''),
			(4,'VTCreateEventTask','Create Event','VTCreateEventTask','modules/com_vtiger_workflow/tasks/VTCreateEventTask.php','','{\"include\":[\"Accounts\",\"Leads\",\"Contacts\",\"HelpDesk\",\"Campaigns\",\"Project\",\"ServiceContracts\",\"Vendors\",\"Partners\",\"Competition\",\"OSSEmployees\",\"SSalesProcesses\",\"SQuoteEnquiries\",\"SRequirementsCards\",\"SCalculations\",\"SQuotes\",\"SSingleOrders\",\"SRecurringOrders\"],\"exclude\":[\"Calendar\",\"FAQ\",\"Events\"]}',''),
			(5,'VTUpdateFieldsTask','Update Fields','VTUpdateFieldsTask','modules/com_vtiger_workflow/tasks/VTUpdateFieldsTask.php','','{\"include\":[],\"exclude\":[]}',''),
			(6,'VTCreateEntityTask','Create Entity','VTCreateEntityTask','modules/com_vtiger_workflow/tasks/VTCreateEntityTask.php','','{\"include\":[],\"exclude\":[]}',''),
			(7,'VTSMSTask','SMS Task','VTSMSTask','modules/com_vtiger_workflow/tasks/VTSMSTask.php','','{\"include\":[\"Accounts\",\"Leads\",\"Vendors\",\"Partners\",\"Competition\",\"OSSEmployees\",\"Contacts\"],\"exclude\":[]}','SMSNotifier'),
			(8,'VTEmailTemplateTask','Email Template Task','VTEmailTemplateTask','modules/com_vtiger_workflow/tasks/VTEmailTemplateTask.php','','{\"include\":[],\"exclude\":[]}',NULL),
			(9,'VTSendPdf','Send Pdf','VTSendPdf','modules/com_vtiger_workflow/tasks/VTSendPdf.php','','{\"include\":[],\"exclude\":[]}',NULL),
			(11,'VTSendNotificationTask','Send Notification','VTSendNotificationTask','modules/com_vtiger_workflow/tasks/VTSendNotificationTask.php','','{\"include\":[\"Calendar\",\"Events\"],\"exclude\":[]}',NULL),
			(12,'VTAddressBookTask','Create Address Book','VTAddressBookTask','modules/com_vtiger_workflow/tasks/VTAddressBookTask.php','','{\"include\":[\"Contacts\",\"OSSEmployees\",\"Accounts\",\"Leads\",\"Vendors\"],\"exclude\":[]}',NULL),
			(13,'VTUpdateCalendarDates','LBL_UPDATE_DATES_CREATED_EVENTS_AUTOMATICALLY','VTUpdateCalendarDates','modules/com_vtiger_workflow/tasks/VTUpdateCalendarDates.php','','{\"include\":[\"Accounts\",\"Contacts\",\"Leads\",\"OSSEmployees\",\"Vendors\",\"Campaigns\",\"HelpDesk\",\"Project\",\"ServiceContracts\"],\"exclude\":[\"Calendar\",\"FAQ\",\"Events\"]}',NULL),
			(14,'VTUpdateWorkTime','LBL_UPDATE_WORK_TIME_AUTOMATICALLY','VTUpdateWorkTime','modules/com_vtiger_workflow/tasks/VTUpdateWorkTime.php','','{\"include\":[\"OSSTimeControl\"],\"exclude\":[]}',NULL),
			(15,'VTUpdateRelatedFieldTask','LBL_UPDATE_RELATED_FIELD','VTUpdateRelatedFieldTask','modules/com_vtiger_workflow/tasks/VTUpdateRelatedFieldTask.php','','{\"include\":[],\"exclude\":[]}',''),
			(16,'VTWatchdog','LBL_NOTIFICATIONS','VTWatchdog','modules/com_vtiger_workflow/tasks/VTWatchdog.php','','{\"include\":[],\"exclude\":[]}',NULL),
			(17,'VTAutoAssign','LBL_AUTO_ASSIGN','VTAutoAssign','modules/com_vtiger_workflow/tasks/VTAutoAssign.php','','{\"include\":[],\"exclude\":[]}',NULL),
			(18,'SumFieldFromDependent','LBL_SUM_FIELD_FROM_DEPENDENT','SumFieldFromDependent','modules/com_vtiger_workflow/tasks/SumFieldFromDependent.php','','{\"include\":[],\"exclude\":[]}',''),
			(19,'VTEmailReport','LBL_EMAIL_REPORT','VTEmailReport','modules/com_vtiger_workflow/tasks/VTEmailReport.php','','{\"include\":[],\"exclude\":[]}',NULL),
			(20,'Webhook','Webhook','Webhook','modules/com_vtiger_workflow/tasks/Webhook.php','','{\"include\":[],\"exclude\":[]}',NULL),
			(21,'RecordCollector','LBL_RECORD_COLLECTOR','RecordCollector','modules/com_vtiger_workflow/tasks/RecordCollector.php','','{\"include\":[],\"exclude\":[]}',NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `com_vtiger_workflows`(`workflow_id`,`module_name`,`summary`,`test`,`execution_condition`,`defaultworkflow`,`type`,`filtersavedinnew`,`schtypeid`,`schdayofmonth`,`schdayofweek`,`schannualdates`,`schtime`,`nexttrigger_time`,`params`,`sequence`) values
			(14,'Calendar','Workflow for Calendar Todos when Send Notification is True','[{\"fieldname\":\"sendnotification\",\"operation\":\"is\",\"value\":\"1\",\"valuetype\":\"rawtext\",\"joincondition\":\"\",\"groupjoin\":\"and\",\"groupid\":\"0\"}]',4,1,'basic',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
			(26,'HelpDesk','Ticket change: Send Email to Record Contact','[{\"fieldname\":\"ticketstatus\",\"operation\":\"has changed\",\"value\":\"\",\"valuetype\":\"rawtext\",\"joincondition\":\"and\",\"groupjoin\":\"and\",\"groupid\":\"0\"},{\"fieldname\":\"ticketstatus\",\"operation\":\"is not\",\"value\":\"Closed\",\"valuetype\":\"rawtext\",\"joincondition\":\"\",\"groupjoin\":\"and\",\"groupid\":\"0\"}]',4,NULL,'basic',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
			(29,'HelpDesk','Ticket Closed: Send Email to Record Contact','[{\"fieldname\":\"ticketstatus\",\"operation\":\"has changed\",\"value\":\"\",\"valuetype\":\"rawtext\",\"joincondition\":\"and\",\"groupjoin\":\"and\",\"groupid\":\"0\"},{\"fieldname\":\"ticketstatus\",\"operation\":\"is\",\"value\":\"Closed\",\"valuetype\":\"rawtext\",\"joincondition\":\"\",\"groupjoin\":\"and\",\"groupid\":\"0\"}]',4,NULL,'basic',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
			(31,'HelpDesk','Ticket Creation: Send Email to Record Owner','[]',1,NULL,'basic',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
			(53,'Contacts','Send Customer Login Details','[{\"fieldname\":\"emailoptout\",\"operation\":\"is\",\"value\":\"1\",\"valuetype\":\"rawtext\",\"joincondition\":\"and\",\"groupjoin\":\"and\",\"groupid\":\"0\"},{\"fieldname\":\"portal\",\"operation\":\"has changed\",\"value\":null,\"valuetype\":\"rawtext\",\"joincondition\":\"and\",\"groupjoin\":\"and\",\"groupid\":\"0\"},{\"fieldname\":\"portal\",\"operation\":\"is\",\"value\":\"1\",\"valuetype\":\"rawtext\",\"joincondition\":\"\",\"groupjoin\":\"and\",\"groupid\":\"0\"}]',4,NULL,'basic',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
			(55,'Contacts','Generate mail address book','[]',3,NULL,'basic',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
			(57,'ModComments','New comment added to ticket - Owner','[{\"fieldname\":\"customer\",\"operation\":\"is not empty\",\"value\":null,\"valuetype\":\"rawtext\",\"joincondition\":\"\",\"groupjoin\":\"and\",\"groupid\":\"0\"}]',1,NULL,'basic',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
			(58,'ModComments','New comment added to ticket - account','[{\"fieldname\":\"customer\",\"operation\":\"is empty\",\"value\":null,\"valuetype\":\"rawtext\",\"joincondition\":\"\",\"groupjoin\":\"and\",\"groupid\":\"0\"}]',1,NULL,'basic',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
			(59,'ModComments','New comment added to ticket - contact','[{\"fieldname\":\"customer\",\"operation\":\"is empty\",\"value\":null,\"valuetype\":\"rawtext\",\"joincondition\":\"\",\"groupjoin\":\"and\",\"groupid\":\"0\"}]',1,NULL,'basic',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
			(69,'OSSTimeControl','LBL_UPDATE_WORK_TIME','[]',7,NULL,'basic',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
			(70,'Users','LBL_NEW_USER_CREATED','[]',1,NULL,'basic',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
			(71,'SSingleOrders','It sums up all open sales orders','[]',3,NULL,'basic',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
			(72,'SSingleOrders','It sums up all open sales orders','[]',5,NULL,'basic',6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
			(73,'SSingleOrders','Create IGDN','[{\"fieldname\":\"ssingleorders_status\",\"operation\":\"is\",\"value\":\"PLL_COMPLETE\",\"valuetype\":\"rawtext\",\"joincondition\":\"\",\"groupjoin\":\"and\",\"groupid\":1}]',3,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0),
			(77,'SSingleOrders','Cancel IGDN','[{\"fieldname\":\"ssingleorders_status\",\"operation\":\"has changed to\",\"value\":\"PLL_NEW\",\"valuetype\":\"rawtext\",\"joincondition\":\"or\",\"groupjoin\":\"and\",\"groupid\":1},{\"fieldname\":\"ssingleorders_status\",\"operation\":\"has changed to\",\"value\":\"PLL_PAYMENT_REVIEW\",\"valuetype\":\"rawtext\",\"joincondition\":\"or\",\"groupjoin\":\"and\",\"groupid\":1},{\"fieldname\":\"ssingleorders_status\",\"operation\":\"has changed to\",\"value\":\"PLL_ON_HOLD\",\"valuetype\":\"rawtext\",\"joincondition\":\"or\",\"groupjoin\":\"and\",\"groupid\":1},{\"fieldname\":\"ssingleorders_status\",\"operation\":\"has changed to\",\"value\":\"PLL_PROCESSING\",\"valuetype\":\"rawtext\",\"joincondition\":\"or\",\"groupjoin\":\"and\",\"groupid\":1},{\"fieldname\":\"ssingleorders_status\",\"operation\":\"has changed to\",\"value\":\"PLL_CLOSED\",\"valuetype\":\"rawtext\",\"joincondition\":\"or\",\"groupjoin\":\"and\",\"groupid\":1},{\"fieldname\":\"ssingleorders_status\",\"operation\":\"has changed to\",\"value\":\"PLL_CANCELLED\",\"valuetype\":\"rawtext\",\"joincondition\":\"\",\"groupjoin\":\"and\",\"groupid\":1}]',4,NULL,NULL,6,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `com_vtiger_workflowtasks`(`task_id`,`workflow_id`,`summary`,`task`,`sequence`) values
			(108,31,'Notify Owner On Ticket Create','O:19:\"VTEmailTemplateTask\":10:{s:18:\"executeImmediately\";b:1;s:10:\"workflowId\";s:2:\"31\";s:7:\"summary\";s:29:\"Notify Owner On Ticket Create\";s:6:\"active\";b:0;s:7:\"trigger\";N;s:8:\"template\";s:2:\"43\";s:11:\"attachments\";s:0:\"\";s:5:\"email\";s:49:\"$(relatedRecord : assigned_user_id|email1|Users)$\";s:10:\"copy_email\";s:0:\"\";s:2:\"id\";i:108;}',0),
			(119,14,'Notification Email to Record Owner','O:19:\"VTEmailTemplateTask\":10:{s:18:\"executeImmediately\";b:1;s:10:\"workflowId\";s:2:\"14\";s:7:\"summary\";s:34:\"Notification Email to Record Owner\";s:6:\"active\";b:0;s:7:\"trigger\";N;s:8:\"template\";s:2:\"46\";s:11:\"attachments\";s:0:\"\";s:5:\"email\";s:49:\"$(relatedRecord : assigned_user_id|email1|Users)$\";s:10:\"copy_email\";s:0:\"\";s:2:\"id\";i:119;}',0),
			(120,53,'Send Customer Login Details','O:19:\"VTEmailTemplateTask\":11:{s:18:\"executeImmediately\";b:1;s:8:\"contents\";N;s:10:\"workflowId\";s:2:\"53\";s:7:\"summary\";s:27:\"Send Customer Login Details\";s:6:\"active\";b:0;s:7:\"trigger\";N;s:8:\"template\";s:2:\"44\";s:11:\"attachments\";s:0:\"\";s:5:\"email\";s:18:\"$(record : email)$\";s:10:\"copy_email\";s:0:\"\";s:2:\"id\";i:120;}',0),
			(123,55,'Generate mail address book','O:17:\"VTAddressBookTask\":7:{s:18:\"executeImmediately\";b:0;s:10:\"workflowId\";s:2:\"55\";s:7:\"summary\";s:26:\"Generate mail address book\";s:6:\"active\";b:1;s:7:\"trigger\";N;s:4:\"test\";s:0:\"\";s:2:\"id\";i:123;}',0),
			(133,26,'Notify Contact On Ticket Change','O:18:\"VTEntityMethodTask\":7:{s:18:\"executeImmediately\";b:1;s:10:\"workflowId\";s:2:\"26\";s:7:\"summary\";s:31:\"Notify Contact On Ticket Change\";s:6:\"active\";b:0;s:7:\"trigger\";N;s:10:\"methodName\";s:28:\"helpDeskChangeNotifyContacts\";s:2:\"id\";i:133;}',0),
			(134,29,'Notify contacts about closing of ticket.','O:18:\"VTEntityMethodTask\":7:{s:18:\"executeImmediately\";b:1;s:10:\"workflowId\";s:2:\"29\";s:7:\"summary\";s:40:\"Notify contacts about closing of ticket.\";s:6:\"active\";b:0;s:7:\"trigger\";N;s:10:\"methodName\";s:28:\"helpDeskClosedNotifyContacts\";s:2:\"id\";i:134;}',0),
			(135,59,'Notify Contact On New comment added to ticket','O:18:\"VTEntityMethodTask\":7:{s:18:\"executeImmediately\";b:1;s:10:\"workflowId\";i:59;s:7:\"summary\";s:45:\"Notify Contact On New comment added to ticket\";s:6:\"active\";b:0;s:7:\"trigger\";N;s:10:\"methodName\";s:26:\"helpDeskNewCommentContacts\";s:2:\"id\";i:135;}',0),
			(136,58,'Notify Account On New comment added to ticket','O:18:\"VTEntityMethodTask\":7:{s:18:\"executeImmediately\";b:1;s:10:\"workflowId\";i:58;s:7:\"summary\";s:45:\"Notify Account On New comment added to ticket\";s:6:\"active\";b:0;s:7:\"trigger\";N;s:10:\"methodName\";s:25:\"helpDeskNewCommentAccount\";s:2:\"id\";i:136;}',0),
			(137,57,'Notify Owner On new comment added to ticket from portal','O:18:\"VTEntityMethodTask\":7:{s:18:\"executeImmediately\";b:1;s:10:\"workflowId\";i:57;s:7:\"summary\";s:55:\"Notify Owner On new comment added to ticket from portal\";s:6:\"active\";b:0;s:7:\"trigger\";N;s:10:\"methodName\";s:23:\"helpDeskNewCommentOwner\";s:2:\"id\";i:137;}',0),
			(138,69,'Update working time','O:16:\"VTUpdateWorkTime\":6:{s:18:\"executeImmediately\";b:0;s:10:\"workflowId\";i:69;s:7:\"summary\";s:19:\"Update working time\";s:6:\"active\";b:1;s:7:\"trigger\";N;s:2:\"id\";i:138;}',0),
			(139,70,'New user created','O:18:\"VTEntityMethodTask\":8:{s:18:\"executeImmediately\";b:1;s:8:\"contents\";N;s:10:\"workflowId\";i:70;s:7:\"summary\";s:16:\"New user created\";s:6:\"active\";b:0;s:7:\"trigger\";N;s:10:\"methodName\";s:7:\"newUser\";s:2:\"id\";i:139;}',0),
			(140,71,'It sums up all open sales orders','O:21:\"SumFieldFromDependent\":10:{s:18:\"executeImmediately\";b:1;s:8:\"contents\";N;s:10:\"workflowId\";i:71;s:7:\"summary\";s:32:\"It sums up all open sales orders\";s:6:\"active\";b:1;s:7:\"trigger\";N;s:11:\"targetField\";s:36:\"accountid::Accounts::sum_open_orders\";s:11:\"sourceField\";s:9:\"sum_gross\";s:10:\"conditions\";a:2:{s:9:\"condition\";s:2:\"OR\";s:5:\"rules\";a:2:{i:0;a:3:{s:9:\"fieldname\";s:34:\"ssingleorders_status:SSingleOrders\";s:8:\"operator\";s:1:\"e\";s:5:\"value\";s:43:\"PLL_NEW##PLL_PAYMENT_REVIEW##PLL_PROCESSING\";}i:1;a:3:{s:9:\"fieldname\";s:34:\"ssingleorders_status:SSingleOrders\";s:8:\"operator\";s:1:\"y\";s:5:\"value\";s:0:\"\";}}}s:2:\"id\";i:140;}',0),
			(141,72,'It sums up all open sales orders','O:21:\"SumFieldFromDependent\":10:{s:18:\"executeImmediately\";b:1;s:8:\"contents\";N;s:10:\"workflowId\";i:72;s:7:\"summary\";s:32:\"It sums up all open sales orders\";s:6:\"active\";b:1;s:7:\"trigger\";N;s:11:\"targetField\";s:36:\"accountid::Accounts::sum_open_orders\";s:11:\"sourceField\";s:9:\"sum_gross\";s:10:\"conditions\";a:2:{s:9:\"condition\";s:2:\"OR\";s:5:\"rules\";a:2:{i:0;a:3:{s:9:\"fieldname\";s:34:\"ssingleorders_status:SSingleOrders\";s:8:\"operator\";s:1:\"e\";s:5:\"value\";s:43:\"PLL_NEW##PLL_PAYMENT_REVIEW##PLL_PROCESSING\";}i:1;a:3:{s:9:\"fieldname\";s:34:\"ssingleorders_status:SSingleOrders\";s:8:\"operator\";s:1:\"y\";s:5:\"value\";s:0:\"\";}}}s:2:\"id\";i:141;}',0),
			(142,73,'Create IGDN','O:18:\"VTCreateEntityTask\":11:{s:18:\"executeImmediately\";b:1;s:8:\"contents\";N;s:10:\"workflowId\";i:73;s:7:\"summary\";s:11:\"Create IGDN\";s:6:\"active\";b:0;s:7:\"trigger\";N;s:11:\"entity_type\";s:4:\"IGDN\";s:15:\"reference_field\";s:15:\"ssingleordersid\";s:19:\"field_value_mapping\";s:94:\"[{\"fieldname\":\"igdn_status\",\"value\":\"PLL_ACCEPTED\",\"valuetype\":\"rawtext\",\"modulename\":\"IGDN\"}]\";s:12:\"mappingPanel\";s:1:\"1\";s:2:\"id\";i:142;}',0),
			(148,77,'Cancel IGDN','O:24:\"VTUpdateRelatedFieldTask\":8:{s:18:\"executeImmediately\";b:0;s:8:\"contents\";N;s:10:\"workflowId\";i:77;s:7:\"summary\";s:11:\"Cancel IGDN\";s:6:\"active\";b:0;s:7:\"trigger\";N;s:19:\"field_value_mapping\";s:81:\"[{\"fieldname\":\"IGDN::igdn_status\",\"value\":\"PLL_CANCELLED\",\"valuetype\":\"rawtext\"}]\";s:2:\"id\";i:148;}',0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `com_vtiger_workflowtasks_entitymethod`(`workflowtasks_entitymethod_id`,`module_name`,`method_name`,`function_path`,`function_name`) values
			(8,'ModComments','helpDeskNewCommentAccount','modules/HelpDesk/workflows/HelpDeskWorkflow.php','HelpDeskWorkflow'),
			(9,'ModComments','helpDeskNewCommentContacts','modules/HelpDesk/workflows/HelpDeskWorkflow.php','HelpDeskWorkflow'),
			(15,'HelpDesk','helpDeskChangeNotifyContacts','modules/HelpDesk/workflows/HelpDeskWorkflow.php','HelpDeskWorkflow'),
			(16,'HelpDesk','helpDeskClosedNotifyContacts','modules/HelpDesk/workflows/HelpDeskWorkflow.php','HelpDeskWorkflow'),
			(17,'ModComments','helpDeskNewCommentOwner','modules/HelpDesk/workflows/HelpDeskWorkflow.php','HelpDeskWorkflow'),
			(18,'Users','newUser','modules/Users/workflows/UsersWorkflow.php','UsersWorkflow');
			STR);

		$this->addSql(<<<'STR'
			insert  into `s_yf_address_finder_config`(`id`,`name`,`type`,`val`) values
			(1,'min_length','global','3'),
			(2,'result_num','global','10'),
			(3,'default_provider','global','');
			STR);

		$this->addSql(<<<'STR'
			insert  into `s_yf_auto_record_flow_updater`(`id`,`status`,`source_module`,`target_module`,`source_field`,`target_field`,`default_value`,`relation_field`,`rules`) values
			(1,0,42,41,'projecttaskstatus','projectmilestone_status','PLL_PLANNED','parentid','{\"PLL_PLANNED\":{\"condition\":\"or\",\"rules\":[{\"operator\":\"allRecordsEqual\",\"value\":\"PLL_PLANNED\"},{\"operator\":\"noRecords\"}]},\"PLL_IN_PROGRESSING\":{\"rules\":[{\"operator\":\"isExist\",\"value\":\"PLL_IN_PROGRESSING\"}]},\"PLL_ON_HOLD\":{\"condition\":\"and\",\"rules\":[{\"operator\":\"allRecordsEqual\",\"value\":\"PLL_ON_HOLD\",\"automation\":1}]},\"PLL_COMPLETED\":{\"condition\":\"or\",\"rules\":[{\"operator\":\"allRecordsEqual\",\"value\":\"PLL_COMPLETED\"},{\"operator\":\"onlyContains\",\"value\":[\"PLL_COMPLETED\",\"PLL_CANCELLED\"]}]},\"PLL_IN_APPROVAL\":{\"condition\":\"and\",\"rules\":[{\"operator\":\"allRecordsEqual\",\"value\":\"PLL_IN_APPROVAL\",\"automation\":1}]},\"PLL_CANCELLED\":{\"condition\":\"and\",\"rules\":[{\"operator\":\"allRecordsEqual\",\"value\":\"PLL_CANCELLED\"}]}}'),
			(2,0,41,43,'projectmilestone_status','projectstatus','PLL_PLANNED','parentid','{\"PLL_PLANNED\":{\"condition\":\"or\",\"rules\":[{\"operator\":\"allRecordsEqual\",\"value\":\"PLL_PLANNED\"},{\"operator\":\"noRecords\"}]},\"PLL_IN_PROGRESSING\":{\"rules\":[{\"operator\":\"isExist\",\"value\":\"PLL_IN_PROGRESSING\"}]},\"PLL_ON_HOLD\":{\"condition\":\"and\",\"rules\":[{\"operator\":\"allRecordsEqual\",\"value\":\"PLL_ON_HOLD\",\"automation\":1}]},\"PLL_COMPLETED\":{\"condition\":\"or\",\"rules\":[{\"operator\":\"allRecordsEqual\",\"value\":\"PLL_COMPLETED\"},{\"operator\":\"onlyContains\",\"value\":[\"PLL_COMPLETED\",\"PLL_CANCELLED\"]}]},\"PLL_IN_APPROVAL\":{\"condition\":\"and\",\"rules\":[{\"operator\":\"allRecordsEqual\",\"value\":\"PLL_IN_APPROVAL\",\"automation\":1}]},\"PLL_CANCELLED\":{\"condition\":\"and\",\"rules\":[{\"operator\":\"allRecordsEqual\",\"value\":\"PLL_CANCELLED\"}]}}');
			STR);

		$this->addSql(<<<'STR'
			insert  into `s_yf_companies`(`id`,`name`,`industry`,`vat_id`,`country`,`website`,`email`) values
			(1,'',NULL,'','','',NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `s_yf_fields_anonymization`(`field_id`,`anonymization_target`) values
			(476,'[0]'),
			(477,'[0]');
			STR);

		$this->addSql(<<<'STR'
			insert  into `s_yf_fields_dependency`(`id`,`tabid`,`status`,`name`,`views`,`gui`,`mandatory`,`fields`,`conditions`,`conditionsFields`) values
			(1,6,1,'Legal form','[\"Create\",\"Edit\",\"Detail\",\"QuickCreate\",\"QuickEdit\"]',1,0,'[\"vat_id\",\"registration_number_2\",\"registration_number_1\",\"siccode\"]','{\"condition\":\"OR\",\"rules\":[{\"fieldname\":\"legal_form:Accounts\",\"operator\":\"n\",\"value\":\"PLL_NATURAL_PERSON\"}]}','[\"legal_form\"]');
			STR);

		$this->addSql(<<<'STR'
			insert  into `s_yf_picklist_dependency`(`id`,`tabid`,`source_field`) values
			(1,7,1321),
			(2,14,2269);
			STR);

		$this->addSql(<<<'STR'
			insert  into `s_yf_picklist_dependency_data`(`id`,`source_id`,`conditions`) values
			(1,1,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Administration\"}]}'),
			(1,2,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Administration\"}]}'),
			(1,3,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Administration\"}]}'),
			(1,4,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Administration\"}]}'),
			(1,5,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Administration\"}]}'),
			(1,6,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Administration\"}]}'),
			(1,7,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Administration\"}]}'),
			(1,8,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Administration\"}]}'),
			(1,9,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Administration\"}]}'),
			(1,10,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Administration\"}]}'),
			(1,11,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Administration\"}]}'),
			(1,12,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Administration\"}]}'),
			(1,14,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Construction Industry\"}]}'),
			(1,15,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Construction Industry\"}]}'),
			(1,16,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Education\"}]}'),
			(1,17,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Education\"}]}'),
			(1,18,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Finance\"}]}'),
			(1,19,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Finance\"}]}'),
			(1,20,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Finance\"}]}'),
			(1,21,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Finance\"}]}'),
			(1,22,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Finance\"}]}'),
			(1,23,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Trade\"}]}'),
			(1,24,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Trade\"}]}'),
			(1,25,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Trade\"}]}'),
			(1,26,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Industry / Manufacturing\"}]}'),
			(1,27,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Industry / Manufacturing\"}]}'),
			(1,28,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Industry / Manufacturing\"}]}'),
			(1,29,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Industry / Manufacturing\"}]}'),
			(1,30,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Industry / Manufacturing\"}]}'),
			(1,31,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Industry / Manufacturing\"}]}'),
			(1,32,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Industry / Manufacturing\"}]}'),
			(1,33,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Industry / Manufacturing\"}]}'),
			(1,34,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Industry / Manufacturing\"}]}'),
			(1,35,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Industry / Manufacturing\"}]}'),
			(1,36,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Industry / Manufacturing\"}]}'),
			(1,37,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Industry / Manufacturing\"}]}'),
			(1,38,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Industry / Manufacturing\"}]}'),
			(1,39,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Uniformed Services\"}]}'),
			(1,40,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Uniformed Services\"}]}'),
			(1,41,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Technologies\"}]}'),
			(1,42,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Technologies\"}]}'),
			(1,43,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Technologies\"}]}'),
			(1,13,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"industry:Leads\",\"operator\":\"e\",\"value\":\"Administration##Construction Industry##Education##Finance##Trade##Industry / Manufacturing##Technologies\"}]}'),
			(2,1,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"usageunit:Products\",\"operator\":\"e\",\"value\":\"kg\"}]}'),
			(2,2,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"usageunit:Products\",\"operator\":\"e\",\"value\":\"kg\"}]}'),
			(2,3,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"usageunit:Products\",\"operator\":\"e\",\"value\":\"kg\"}]}'),
			(2,4,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"usageunit:Products\",\"operator\":\"e\",\"value\":\"kg\"}]}'),
			(2,5,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"usageunit:Products\",\"operator\":\"e\",\"value\":\"l\"}]}'),
			(2,6,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"usageunit:Products\",\"operator\":\"e\",\"value\":\"l\"}]}'),
			(2,7,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"usageunit:Products\",\"operator\":\"e\",\"value\":\"l\"}]}'),
			(2,8,'{\"condition\":\"AND\",\"rules\":[{\"fieldname\":\"usageunit:Products\",\"operator\":\"e\",\"value\":\"l\"}]}');
			STR);

		$this->addSql(<<<'STR'
			insert  into `s_yf_record_quick_changer`(`id`,`tabid`,`conditions`,`values`,`btn_name`,`class`,`icon`) values
			(1,90,'{\"ssingleorders_status\":\"PLL_ACCEPTED\"} ','{\"ssingleorders_status\":\"PLL_CANCELLED\"} ','BTN_CANCEL','btn-outline-danger','mdi mdi-cancel'),
			(2,100,'{\"igdn_status\":\"PLL_ACCEPTED\"}','{\"igdn_status\":\"PLL_CANCELLED\"}','BTN_CANCEL','btn-outline-danger','mdi mdi-cancel'),
			(3,101,'{\"iidn_status\":\"PLL_ACCEPTED\"}','{\"iidn_status\":\"PLL_CANCELLED\"}','BTN_CANCEL','btn-outline-danger','mdi mdi-cancel'),
			(4,102,'{\"igin_status\":\"PLL_ACCEPTED\"}','{\"igin_status\":\"PLL_CANCELLED\"}','BTN_CANCEL','btn-outline-danger','mdi mdi-cancel'),
			(5,103,'{\"ipreorder_status\":\"PLL_ACCEPTED\"}','{\"ipreorder_status\":\"PLL_CANCELLED\"}','BTN_CANCEL','btn-outline-danger','mdi mdi-cancel'),
			(6,104,'{\"istdn_status\":\"PLL_ACCEPTED\"}','{\"istdn_status\":\"PLL_CANCELLED\"}','BTN_CANCEL','btn-outline-danger','mdi mdi-cancel'),
			(7,106,'{\"istrn_status\":\"PLL_ACCEPTED\"}','{\"istrn_status\":\"PLL_CANCELLED\"}','BTN_CANCEL','btn-outline-danger','mdi mdi-cancel'),
			(8,108,'{\"igrnc_status\":\"PLL_ACCEPTED\"}','{\"igrnc_status\":\"PLL_CANCELLED\"}','BTN_CANCEL','btn-outline-danger','mdi mdi-cancel'),
			(9,109,'{\"igdnc_status\":\"PLL_ACCEPTED\"}','{\"igdnc_status\":\"PLL_CANCELLED\"}','BTN_CANCEL','btn-outline-danger','mdi mdi-cancel'),
			(10,98,'{\"igrn_status\":\"PLL_ACCEPTED\"}','{\"igrn_status\":\"PLL_CANCELLED\"}','BTN_CANCEL','btn-outline-danger','mdi mdi-cancel');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_chat_global`(`global_room_id`,`name`) values
			(1,'LBL_GENERAL');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_chat_rooms`(`id`,`type`,`sequence`,`active`) values
			(1,'crm',NULL,1),
			(2,'global',NULL,1),
			(3,'group',NULL,1),
			(4,'private',NULL,1),
			(5,'user',NULL,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_countries`(`id`,`name`,`code`,`status`,`sortorderid`,`phone`,`uitype`) values
			(1,'Afghanistan','AF',0,1,0,0),
			(2,'Albania','AL',0,2,0,0),
			(3,'Algeria','DZ',0,3,0,0),
			(4,'American Samoa','AS',0,4,0,0),
			(5,'Andorra','AD',0,5,0,0),
			(6,'Angola','AO',0,6,0,0),
			(7,'Anguilla','AI',0,7,0,0),
			(8,'Antarctica','AQ',0,8,0,0),
			(9,'Antigua And Barbuda','AG',0,9,0,0),
			(10,'Argentina','AR',0,10,0,0),
			(11,'Armenia','AM',0,11,0,0),
			(12,'Aruba','AW',0,12,0,0),
			(13,'Australia','AU',0,13,0,0),
			(14,'Austria','AT',0,14,0,0),
			(15,'Azerbaijan','AZ',0,15,0,0),
			(16,'Bahamas','BS',0,16,0,0),
			(17,'Bahrain','BH',0,17,0,0),
			(18,'Bangladesh','BD',0,18,0,0),
			(19,'Barbados','BB',0,19,0,0),
			(20,'Belarus','BY',0,20,0,0),
			(21,'Belgium','BE',0,21,0,0),
			(22,'Belize','BZ',0,22,0,0),
			(23,'Benin','BJ',0,23,0,0),
			(24,'Bermuda','BM',0,24,0,0),
			(25,'Bhutan','BT',0,25,0,0),
			(26,'Bolivia','BO',0,26,0,0),
			(27,'Bosnia And Herzegovina','BA',0,28,0,0),
			(28,'Botswana','BW',0,29,0,0),
			(29,'Bouvet Island','BV',0,30,0,0),
			(30,'Brazil','BR',0,31,0,0),
			(31,'British Indian Ocean Territory','IO',0,32,0,0),
			(32,'Brunei Darussalam','BN',0,33,0,0),
			(33,'Bulgaria','BG',0,34,0,0),
			(34,'Burkina Faso','BF',0,35,0,0),
			(35,'Burundi','BI',0,36,0,0),
			(36,'Cambodia','KH',0,37,0,0),
			(37,'Cameroon','CM',0,38,0,0),
			(38,'Canada','CA',0,39,0,0),
			(39,'Cape Verde','CV',0,40,0,0),
			(40,'Cayman Islands','KY',0,41,0,0),
			(41,'Central African Republic','CF',0,42,0,0),
			(42,'Chad','TD',0,43,0,0),
			(43,'Chile','CL',0,44,0,0),
			(44,'China','CN',0,45,0,0),
			(45,'Christmas Island','CX',0,46,0,0),
			(46,'Cocos (keeling) Islands','CC',0,47,0,0),
			(47,'Colombia','CO',0,48,0,0),
			(48,'Comoros','KM',0,49,0,0),
			(49,'Congo','CG',0,50,0,0),
			(50,'Congo, The Democratic Republic Of The','CD',0,51,0,0),
			(51,'Cook Islands','CK',0,52,0,0),
			(52,'Costa Rica','CR',0,53,0,0),
			(53,'Cote D\'ivoire','CI',0,54,0,0),
			(54,'Croatia','HR',0,55,0,0),
			(55,'Cuba','CU',0,56,0,0),
			(56,'Cyprus','CY',0,58,0,0),
			(57,'Czech Republic','CZ',0,59,0,0),
			(58,'Denmark','DK',0,60,0,0),
			(59,'Djibouti','DJ',0,61,0,0),
			(60,'Dominica','DM',0,62,0,0),
			(61,'Dominican Republic','DO',0,63,0,0),
			(62,'East Timor','TP',0,64,0,0),
			(63,'Ecuador','EC',0,65,0,0),
			(64,'Egypt','EG',0,66,0,0),
			(65,'El Salvador','SV',0,67,0,0),
			(66,'Equatorial Guinea','GQ',0,68,0,0),
			(67,'Eritrea','ER',0,69,0,0),
			(68,'Estonia','EE',0,70,0,0),
			(69,'Ethiopia','ET',0,71,0,0),
			(70,'Falkland Islands (malvinas)','FK',0,72,0,0),
			(71,'Faroe Islands','FO',0,73,0,0),
			(72,'Fiji','FJ',0,74,0,0),
			(73,'Finland','FI',0,75,0,0),
			(74,'France','FR',0,76,0,0),
			(75,'French Guiana','GF',0,77,0,0),
			(76,'French Polynesia','PF',0,78,0,0),
			(77,'French Southern Territories','TF',0,79,0,0),
			(78,'Gabon','GA',0,80,0,0),
			(79,'Gambia','GM',0,81,0,0),
			(80,'Georgia','GE',0,82,0,0),
			(81,'Germany','DE',0,83,0,0),
			(82,'Ghana','GH',0,84,0,0),
			(83,'Gibraltar','GI',0,85,0,0),
			(84,'Greece','GR',0,86,0,0),
			(85,'Greenland','GL',0,87,0,0),
			(86,'Grenada','GD',0,88,0,0),
			(87,'Guadeloupe','GP',0,89,0,0),
			(88,'Guam','GU',0,90,0,0),
			(89,'Guatemala','GT',0,91,0,0),
			(90,'Guinea','GN',0,93,0,0),
			(91,'Guinea-bissau','GW',0,94,0,0),
			(92,'Guyana','GY',0,95,0,0),
			(93,'Haiti','HT',0,96,0,0),
			(94,'Heard Island And Mcdonald Islands','HM',0,97,0,0),
			(95,'Holy See (vatican City State)','VA',0,98,0,0),
			(96,'Honduras','HN',0,99,0,0),
			(97,'Hong Kong','HK',0,100,0,0),
			(98,'Hungary','HU',0,101,0,0),
			(99,'Iceland','IS',0,102,0,0),
			(100,'India','IN',0,103,0,0),
			(101,'Indonesia','ID',0,104,0,0),
			(102,'Iran, Islamic Republic Of','IR',0,105,0,0),
			(103,'Iraq','IQ',0,106,0,0),
			(104,'Ireland','IE',0,107,0,0),
			(105,'Israel','IL',0,109,0,0),
			(106,'Italy','IT',0,110,0,0),
			(107,'Jamaica','JM',0,111,0,0),
			(108,'Japan','JP',0,112,0,0),
			(109,'Jordan','JO',0,114,0,0),
			(110,'Kazakstan','KZ',0,115,0,0),
			(111,'Kenya','KE',0,116,0,0),
			(112,'Kiribati','KI',0,117,0,0),
			(113,'Korea, Democratic People\'s Republic Of','KP',0,118,0,0),
			(114,'Korea, Republic Of','KR',0,119,0,0),
			(115,'Kosovo','KV',0,120,0,0),
			(116,'Kuwait','KW',0,121,0,0),
			(117,'Kyrgyzstan','KG',0,122,0,0),
			(118,'Lao People\'s Democratic Republic','LA',0,123,0,0),
			(119,'Latvia','LV',0,124,0,0),
			(120,'Lebanon','LB',0,125,0,0),
			(121,'Lesotho','LS',0,126,0,0),
			(122,'Liberia','LR',0,127,0,0),
			(123,'Libyan Arab Jamahiriya','LY',0,128,0,0),
			(124,'Liechtenstein','LI',0,129,0,0),
			(125,'Lithuania','LT',0,130,0,0),
			(126,'Luxembourg','LU',0,131,0,0),
			(127,'Macau','MO',0,132,0,0),
			(128,'Macedonia, The Former Yugoslav Republic Of','MK',0,133,0,0),
			(129,'Madagascar','MG',0,134,0,0),
			(130,'Malawi','MW',0,135,0,0),
			(131,'Malaysia','MY',0,136,0,0),
			(132,'Maldives','MV',0,137,0,0),
			(133,'Mali','ML',0,138,0,0),
			(134,'Malta','MT',0,139,0,0),
			(135,'Marshall Islands','MH',0,140,0,0),
			(136,'Martinique','MQ',0,141,0,0),
			(137,'Mauritania','MR',0,142,0,0),
			(138,'Mauritius','MU',0,143,0,0),
			(139,'Mayotte','YT',0,144,0,0),
			(140,'Mexico','MX',0,145,0,0),
			(141,'Micronesia, Federated States Of','FM',0,146,0,0),
			(142,'Moldova, Republic Of','MD',0,147,0,0),
			(143,'Monaco','MC',0,148,0,0),
			(144,'Mongolia','MN',0,149,0,0),
			(145,'Montserrat','MS',0,151,0,0),
			(146,'Montenegro','ME',0,150,0,0),
			(147,'Morocco','MA',0,152,0,0),
			(148,'Mozambique','MZ',0,153,0,0),
			(149,'Myanmar','MM',0,154,0,0),
			(150,'Namibia','NA',0,155,0,0),
			(151,'Nauru','NR',0,156,0,0),
			(152,'Nepal','NP',0,157,0,0),
			(153,'Netherlands','NL',0,158,0,0),
			(154,'Netherlands Antilles','AN',0,159,0,0),
			(155,'New Caledonia','NC',0,160,0,0),
			(156,'New Zealand','NZ',0,161,0,0),
			(157,'Nicaragua','NI',0,162,0,0),
			(158,'Niger','NE',0,163,0,0),
			(159,'Nigeria','NG',0,164,0,0),
			(160,'Niue','NU',0,165,0,0),
			(161,'Norfolk Island','NF',0,166,0,0),
			(162,'Northern Mariana Islands','MP',0,167,0,0),
			(163,'Norway','NO',0,168,0,0),
			(164,'Oman','OM',0,169,0,0),
			(165,'Pakistan','PK',0,170,0,0),
			(166,'Palau','PW',0,171,0,0),
			(167,'Palestinian Territory, Occupied','PS',0,172,0,0),
			(168,'Panama','PA',0,173,0,0),
			(169,'Papua New Guinea','PG',0,174,0,0),
			(170,'Paraguay','PY',0,175,0,0),
			(171,'Peru','PE',0,176,0,0),
			(172,'Philippines','PH',0,177,0,0),
			(173,'Pitcairn','PN',0,178,0,0),
			(174,'Poland','PL',0,179,0,0),
			(175,'Portugal','PT',0,180,0,0),
			(176,'Puerto Rico','PR',0,181,0,0),
			(177,'Qatar','QA',0,182,0,0),
			(178,'Reunion','RE',0,183,0,0),
			(179,'Romania','RO',0,184,0,0),
			(180,'Russian Federation','RU',0,185,0,0),
			(181,'Rwanda','RW',0,186,0,0),
			(182,'Saint Helena','SH',0,188,0,0),
			(183,'Saint Kitts And Nevis','KN',0,189,0,0),
			(184,'Saint Lucia','LC',0,190,0,0),
			(185,'Saint Pierre And Miquelon','PM',0,192,0,0),
			(186,'Saint Vincent And The Grenadines','VC',0,193,0,0),
			(187,'Samoa','WS',0,194,0,0),
			(188,'San Marino','SM',0,195,0,0),
			(189,'Sao Tome And Principe','ST',0,196,0,0),
			(190,'Saudi Arabia','SA',0,197,0,0),
			(191,'Senegal','SN',0,198,0,0),
			(192,'Serbia','RS',0,199,0,0),
			(193,'Seychelles','SC',0,200,0,0),
			(194,'Sierra Leone','SL',0,201,0,0),
			(195,'Singapore','SG',0,202,0,0),
			(196,'Slovakia','SK',0,204,0,0),
			(197,'Slovenia','SI',0,205,0,0),
			(198,'Solomon Islands','SB',0,206,0,0),
			(199,'Somalia','SO',0,207,0,0),
			(200,'South Africa','ZA',0,208,0,0),
			(201,'South Georgia And The South Sandwich Islands','GS',0,209,0,0),
			(202,'Spain','ES',0,211,0,0),
			(203,'Sri Lanka','LK',0,212,0,0),
			(204,'Sudan','SD',0,213,0,0),
			(205,'Suriname','SR',0,214,0,0),
			(206,'Svalbard And Jan Mayen','SJ',0,215,0,0),
			(207,'Swaziland','SZ',0,216,0,0),
			(208,'Sweden','SE',0,217,0,0),
			(209,'Switzerland','CH',0,218,0,0),
			(210,'Syrian Arab Republic','SY',0,219,0,0),
			(211,'Taiwan, Province Of China','TW',0,220,0,0),
			(212,'Tajikistan','TJ',0,221,0,0),
			(213,'Tanzania, United Republic Of','TZ',0,222,0,0),
			(214,'Thailand','TH',0,223,0,0),
			(215,'Togo','TG',0,225,0,0),
			(216,'Tokelau','TK',0,226,0,0),
			(217,'Tonga','TO',0,227,0,0),
			(218,'Trinidad And Tobago','TT',0,228,0,0),
			(219,'Tunisia','TN',0,229,0,0),
			(220,'Turkey','TR',0,230,0,0),
			(221,'Turkmenistan','TM',0,231,0,0),
			(222,'Turks And Caicos Islands','TC',0,232,0,0),
			(223,'Tuvalu','TV',0,233,0,0),
			(224,'Uganda','UG',0,234,0,0),
			(225,'Ukraine','UA',0,235,0,0),
			(226,'United Arab Emirates','AE',0,236,0,0),
			(227,'United Kingdom','GB',0,237,0,0),
			(228,'United States','US',0,238,0,0),
			(229,'United States Minor Outlying Islands','UM',0,239,0,0),
			(230,'Uruguay','UY',0,240,0,0),
			(231,'Uzbekistan','UZ',0,241,0,0),
			(232,'Vanuatu','VU',0,242,0,0),
			(233,'Venezuela','VE',0,243,0,0),
			(234,'Viet Nam','VN',0,244,0,0),
			(235,'Virgin Islands, British','VG',0,245,0,0),
			(236,'Virgin Islands, U.s.','VI',0,246,0,0),
			(237,'Wallis And Futuna','WF',0,247,0,0),
			(238,'Western Sahara','EH',0,248,0,0),
			(239,'Yemen','YE',0,249,0,0),
			(240,'Zambia','ZM',0,250,0,0),
			(241,'Zimbabwe','ZW',0,251,0,0),
			(242,'South Sudan','SS',0,210,0,0),
			(243,'Bonaire, Sint Eustatius and Saba','BQ',0,27,0,0),
			(244,'Curaçao','CW',0,57,0,0),
			(245,'Guernesey','GG',0,92,0,0),
			(246,'Isle of Man','IM',0,108,0,0),
			(247,'Jersey','JE',0,113,0,0),
			(248,'Saint Barthélemy','BL',0,187,0,0),
			(249,'Saint Martin (French part)','MF',0,191,0,0),
			(250,'Sint Maarten (Dutch part)','SX',0,203,0,0),
			(251,'Timor-Leste','TL',0,224,0,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_cv_condition`(`id`,`group_id`,`field_name`,`module_name`,`source_field_name`,`operator`,`value`,`index`) values
			(1,1,'notification_status','Notification','','e','PLL_UNREAD',0),
			(2,2,'internal_tickets_status','CInternalTickets','','n','PLL_CANCELLED##PLL_ACCEPTED',0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_cv_condition_group`(`id`,`cvid`,`condition`,`parent_id`,`index`) values
			(1,104,'AND',0,0),
			(2,117,'AND',0,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_dashboard_type`(`dashboard_id`,`name`,`system`) values
			(1,'LBL_MAIN_PAGE',1);
			STR);

		$this->addSql(<<<STR
			insert  into `u_yf_emailtemplates`(`emailtemplatesid`,`name`,`number`,`email_template_type`,`module`,`subject`,`content`,`sys_name`,`email_template_priority`,`smtp_id`) values
			(37,'Notify Contacts On Ticket Closed','N3','PLL_RECORD','HelpDesk','[$(record : ticket_no)$] $(record : ticket_title)$','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>[$(record : ticket_no)$]: $(record : ticket_title)$</h1>\r\n							<p>$(translate : HelpDesk|LBL_MAIL_NOTICE_CLOSED)$</p>\r\n							<table border=\\"0\\">\r\n								<tbody>\r\n									<tr>\r\n										<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n											<div><i>$(translate : HelpDesk|Solution)$</i></div>\r\n										</td>\r\n										<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n											$(record : solution)$\r\n										</td>\r\n									</tr>\r\n								</tbody>\r\n							</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','NotifyContactOnTicketClosed','1',NULL),
			(39,'Notify Contacts On Ticket Create','N5','PLL_RECORD','HelpDesk','[$(record : ticket_no)$] $(record : ticket_title)$','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>[$(record : ticket_no)$]: $(record : ticket_title)$</h1>\r\n							<p>$(translate : HelpDesk|LBL_MAIL_NOTICE_CREATE)$</p>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','NotifyContactOnTicketCreate','1',NULL),
			(41,'Notify Contacts On Ticket Change','N7','PLL_RECORD','HelpDesk','[$(record : ticket_no)$] $(record : ticket_title)$','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>[$(record : ticket_no)$]: $(record : ticket_title)$</h1>\r\n							<p>$(translate : HelpDesk|LBL_MAIL_NOTICE_MODIFICATION)$</p>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','NotifyContactOnTicketChange','1',NULL),
			(43,'Notify Owner On Ticket Create','N9','PLL_RECORD','HelpDesk','[$(record : ticket_no)$] $(record : ticket_title)$','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>[$(record : ticket_no)$]: $(record : ticket_title)$</h1>\r\n							<p>$(translate : HelpDesk|LBL_MAIL_NOTICE_OWNER_CREATED)$</p>\r\n							<table border=\\"0\\">\r\n								<tbody>\r\n									<tr>\r\n										<td style=\\"padding:0 1em 10px 0;font-size:13px;color:#888;white-space:nowrap;\\">\r\n											<div><i>$(translate : HelpDesk|Status)$</i></div>\r\n										</td>\r\n										<td style=\\"padding-bottom:10px;font-size:13px;color:#222;\\">\r\n											$(record : ticketstatus)$\r\n										</td>\r\n									</tr>\r\n									<tr>\r\n										<td style=\\"padding:0 1em 10px 0;font-size:13px;color:#888;white-space:nowrap;\\">\r\n											<div><i>$(translate : HelpDesk|Priority)$</i></div>\r\n										</td>\r\n										<td style=\\"padding-bottom:10px;font-size:13px;color:#222;\\">\r\n											$(record : ticketpriorities)$\r\n										</td>\r\n									</tr>\r\n									<tr>\r\n										<td style=\\"padding:0 1em 10px 0;font-size:13px;color:#888;white-space:nowrap;\\">\r\n											<div><i>$(translate : HelpDesk|Assigned To)$</i></div>\r\n										</td>\r\n										<td style=\\"padding-bottom:10px;font-size:13px;color:#222;\\">\r\n											$(record : assigned_user_id)$\r\n										</td>\r\n									</tr>\r\n									<tr>\r\n										<td style=\\"padding:0 1em 10px 0;font-size:13px;color:#888;white-space:nowrap;\\">\r\n											<div><i>$(translate : HelpDesk|Related To)$</i></div>\r\n										</td>\r\n										<td style=\\"padding-bottom:10px;font-size:13px;color:#222;\\">\r\n											$(record : parent_id)$\r\n										</td>\r\n									</tr>\r\n									<tr>\r\n										<td style=\\"padding:0 1em 10px 0;font-size:13px;color:#888;white-space:nowrap;\\">\r\n											<div><i>$(translate : HelpDesk|FL_SERVICE_CONTRACTS)$</i></div>\r\n										</td>\r\n										<td style=\\"padding-bottom:10px;font-size:13px;color:#222;\\">\r\n											$(record : servicecontractsid)$\r\n										</td>\r\n									</tr>\r\n									<tr>\r\n										<td style=\\"padding:0 1em 10px 0;font-size:13px;color:#888;white-space:nowrap;\\">\r\n											<div><i>$(translate : HelpDesk|Description)$</i></div>\r\n										</td>\r\n										<td style=\\"padding-bottom:10px;font-size:13px;color:#222;\\">\r\n											$(record : description)$\r\n										</td>\r\n									</tr>\r\n								</tbody>\r\n							</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n',NULL,'1',NULL),
			(44,'Customer Portal Login Details','N10','PLL_RECORD','Contacts','Customer Portal Login Details','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>$(translate : HelpDesk|LBL_NOTICE_WELCOME)$ YetiForce S.A. </h1>\r\n							<p>Dear $(record : first_name)$ $(record : last_name)$, <br />\r\n								Created for your account in the customer portal, below sending data access<br />\r\n								Login: $(record : email)$<br />\r\n								Password: </p>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n',NULL,'1',NULL),
			(45,'Send invitations','N11','PLL_RECORD','Calendar','$(record : activitytype)$ $(record : subject)$','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>$(record : activitytype)$ $(record : subject)$</h1>\r\n							<table border=\\"0\\">\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Events|Start Date & Time)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : date_start)$ $(record : time_start)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|End Time)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : due_date)$ $(record : time_end)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|FL_PROCESS)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : process)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|FL_RELATION)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : link)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Activity Type)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : activitytype)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Priority)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : taskpriority)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Location)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										<span><span>$(record : location)$</span><span> (<a href=\\"https://maps.google.pl/maps?q=$(record%20:%20location)$\\">mapa</a>)</span></span>\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Status)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : activitystatus)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Description)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : description)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Assigned To)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : assigned_user_id)$\r\n									</td>\r\n								</tr>\r\n							</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n',NULL,'1',NULL),
			(46,'Send Notification Email to Record Owner','N12','PLL_RECORD','Calendar','Task : $(record : subject)$','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>Activity Notification Details</h1>\r\n							<table border=\\"0\\">\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Subject)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : subject)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Start Date & Time)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : date_start)$ $(record : time_start)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|End Time)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : due_date) $(record : time_end)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Status)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : activitystatus)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Priority)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : taskpriority)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|FL_PROCESS)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : process)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|FL_RELATION)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : link)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Location)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : location)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Description)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : description)$\r\n									</td>\r\n								</tr>\r\n							</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n',NULL,'1',NULL),
			(93,'Activity Reminder Notification','N13','PLL_RECORD','Calendar','Reminder:  $(record : subject)$','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>This is a reminder notification for the Activity</h1>\r\n							<table border=\\"0\\">\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Subject)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : subject)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Start Date & Time)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : date_start)$ $(record : time_start)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|FL_RELATION)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : link)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|FL_PROCESS)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : process)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : Calendar|Description)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : description)$\r\n									</td>\r\n								</tr>\r\n							</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','ActivityReminderNotificationTask','1',NULL),
			(95,'Test mail about the mail server configuration.','N15','PLL_RECORD','Users','Test mail about the mail server configuration.','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>Test mail about the mail server configuration.</h1>\r\n							<p>Dear $(record : first_name)$ $(record : last_name)$,<br />\r\n								This is a test mail sent to confirm if a mail is actually being sent through the smtp server\r\n								that you have configured. Feel free to delete this mail.<br />CRM address: $(general : SiteUrl)$</p>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','TestMailAboutTheMailServerConfiguration','1',NULL),
			(103,'ResetPassword','N16','PLL_RECORD','Users','Password change','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<p>Dear user,<br />\r\n								We received a request to change the password to your account.<br />\r\n								In order to set a new password click the following link (valid until $(params : expirationDate)$):<br /><br />\r\n								<a href=\\"$(params : url)$\\" target=\\"_blank\\">$(params : url)$</a><br />\r\n								$(params : token)$\r\n								<br /><br />\r\n								If you didn\\'t request the passwords change please report it to the administrator or use the password change option available on the login page.\r\n							</p>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','UsersResetPassword','9',NULL),
			(104,'Notify the contact about the new account in the portal','N17','PLL_RECORD','Contacts','Welcome to the YetiForce Client Portal!','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>Welcome to the YetiForce Client Portal!</h1>\r\n							<p>\r\n								Dear $(params : login)$,<br />\r\n								Your account has been created successfully. Below are your username and password:<br /><br />\r\n								Portal address: $(params : acceptable_url)$<br />\r\n								Your username: $(params : login)$<br />\r\n								Your password: $(params : password)$<br /><br />\r\n\r\n								Please log in to access all of the Portal features.<br /><br />\r\n								If you have any questions or need any assistance, please send us an email to help@yetiforce.com.\r\n							</p>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','YetiPortalRegister','1',NULL),
			(105,'Notify Owner On new comment added to ticket from portal','N18','PLL_RECORD','ModComments','$(translate : ModComments|LBL_ADDED_COMMENT_TO_TICKET)$','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>$(translate : ModComments|LBL_ADDED_COMMENT_TO_TICKET)$ - $(record : related_to)$</h1>\r\n							<table border=\\"0\\">\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\" >\r\n										<div><i>$(translate : ModComments|LBL_NEW_COMMENT_FOR_TICKET)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\" >\r\n										$(translate : ModComments|LBL_NOTICE_CREATED)$ $(record : customer)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\" >\r\n										<div><i>$(translate : ModComments|Comment)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\" >\r\n										$(record : commentcontent)$\r\n									</td>\r\n								</tr>\r\n							</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','NewCommentAddedToTicketOwner','1',NULL),
			(106,'Notify Contact On New comment added to ticket','N19','PLL_RECORD','ModComments','$(translate : ModComments|LBL_ADDED_COMMENT_TO_TICKET)$','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>$(translate : ModComments|LBL_ADDED_COMMENT_TO_TICKET)$ - $(record : related_to)$</h1>\r\n							<table border=\\"0\\">\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\" >\r\n										<div><i>$(translate : ModComments|LBL_NEW_COMMENT_FOR_TICKET)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\" >\r\n										$(translate : ModComments|LBL_NOTICE_CREATED)$ $(record : created_user_id)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\" >\r\n										<div><i>$(translate : ModComments|Comment)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\" >\r\n										$(record : commentcontent)$\r\n									</td>\r\n								</tr>\r\n							</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','NewCommentAddedToTicketContact','1',NULL),
			(107,'Security risk has been detected - Brute Force','N20','PLL_RECORD','Users','Security risk has been detected','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>Failed login attempts have been detected. - $(general : SiteUrl)$</h1>\r\n							<p>\r\n								$(custom : Bruteforce|Users)$\r\n							</p>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','BruteForceSecurityRiskHasBeenDetected','1',NULL),
			(109,'Notify Account On New comment added to ticket','N21','PLL_RECORD','ModComments','$(translate : ModComments|LBL_ADDED_COMMENT_TO_TICKET)$','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>$(translate : ModComments|LBL_ADDED_COMMENT_TO_TICKET)$ - $(record : related_to)$</h1>\r\n							<table border=\\"0\\">\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : ModComments|LBL_NEW_COMMENT_FOR_TICKET)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(translate : ModComments|LBL_NOTICE_CREATED)$ $(record : created_user_id)$\r\n									</td>\r\n								</tr>\r\n								<tr>\r\n									<td style=\\"padding:0 1em 10px 0;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#888;white-space:nowrap;\\">\r\n										<div><i>$(translate : ModComments|Comment)$</i></div>\r\n									</td>\r\n									<td style=\\"padding-bottom:10px;font-family:Arial, \\'Sans-serif\\';font-size:13px;color:#222;\\">\r\n										$(record : commentcontent)$\r\n									</td>\r\n								</tr>\r\n							</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','NewCommentAddedToTicketAccount','1',NULL),
			(110,'Send notifications','N22','PLL_RECORD','Notification','Notifications $(general : CurrentDate)$','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>$(translate : Notification|Notification)$ $(general : CurrentDate)$</h1>\r\n							<p>\r\n								$(custom : Notifications|Notification)$\r\n							</p>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','SendNotificationsViaMail','1',NULL),
			(112,'System warnings','N24','PLL_RECORD','Users','$(translate : Settings.Base|LBL_SYSTEM_WARNINGS)$','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>$(translate : Settings.Base|LBL_SYSTEM_WARNINGS)$</h1>\r\n							<p>\r\n								$(params : warnings)$\r\n							</p>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','SystemWarnings','7',NULL),
			(113,'Import Cron','N25','PLL_MAIL','Accounts','$(translate : Other.Mailer|LBL_CRON_EMAIL_SUBJECT)$','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>$(translate : Other.Mailer|LBL_CRON_COMPLETED_IMPORT)$ $(params : module)$</h1>\r\n							<table border=\\"0\\">\r\n								<tbody>\r\n									<tr>\r\n										<td>\r\n											<div><i>$(translate : Import|LBL_TOTAL_RECORDS_IMPORTED)$ </i></div>\r\n										</td>\r\n										<td>\r\n											$(params : imported)$/$(params : total)$\r\n										</td>\r\n									</tr>\r\n									<tr>\r\n										<td>\r\n											<div><i>$(translate : Import|LBL_NUMBER_OF_RECORDS_CREATED)$</i></div>\r\n										</td>\r\n										<td>\r\n											$(params : created)$\r\n										</td>\r\n									</tr>\r\n									<tr>\r\n										<td>\r\n											<div><i>$(translate : Import|LBL_NUMBER_OF_RECORDS_UPDATED)$</i></div>\r\n										</td>\r\n										<td>\r\n											$(params : updated)$\r\n										</td>\r\n									</tr>\r\n									<tr>\r\n										<td>\r\n											<div><i>$(translate : Import|LBL_NUMBER_OF_RECORDS_SKIPPED)$</i></div>\r\n										</td>\r\n										<td>\r\n											$(params : skipped)$\r\n										</td>\r\n									</tr>\r\n									<tr>\r\n										<td>\r\n											<div><i>$(translate : Import|LBL_NUMBER_OF_RECORDS_MERGED)$</i></div>\r\n										</td>\r\n										<td>\r\n											$(params : merged)$\r\n										</td>\r\n									</tr>\r\n									<tr>\r\n										<td>\r\n											<div><i>$(translate : Import|LBL_TOTAL_RECORDS_FAILED)$</i></div>\r\n										</td>\r\n										<td>\r\n											$(params : failed)$/$(params : total)$\r\n										</td>\r\n									</tr>\r\n								</tbody>\r\n								</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','ImportCron','1',NULL),
			(114,'New user','N31','PLL_RECORD','Users','A new user has been created','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>A new user has been created</h1>\r\n							<p>\r\n								Dear user,<br />\r\nA new user has been created. Below you can find your password and access data to your\r\naccount.<br />\r\n<br />\r\n$(translate : Other.TextParser|LBL_SITE_URL)$:\u{a0}$(general : SiteUrl)$<br />\r\n$(translate : Users|User Name)$:\u{a0}$(record : user_name)$<br />\r\n$(translate : Users|Password)$:\u{a0}$(params : password)$\r\n							</p>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','NewUser','9',NULL),
			(115,'Interests conflict - E-mail with the outcome of the request for access to the record','N27','PLL_RECORD','Users','Interests conflict - request for access to the record','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>Interests conflict - request for access to the record</h1>\r\n							<p>\r\n								User $(params : user)$ requests access to record $(params : record)$\r\n							</p>\r\n							<p>\r\n								User\\'s comment: <br> $(params : comment)$\r\n							</p>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','InterestsConflictAccessRequest','1',NULL),
			(116,'Interests conflict - E-mail sent to the person requesting access.','N28','PLL_RECORD','Users','Interests conflict - response to the request for access to the record','<table align=\\"center\\" bgcolor=\\"#ffffff\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table_full editable-bg-color bg_color_ffffff editable-bg-image\\" style=\\"max-width:1024px;min-width:320px;\\">\r\n	<tbody>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"border:1px solid #f2f2f2;border-radius:5px;padding:10px;\\">\r\n						<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"no_float\\">\r\n							<tbody>\r\n								<tr>\r\n									<td align=\\"center\\" class=\\"editable-img\\">$(organization : logo)$</td>\r\n								</tr>\r\n							</tbody>\r\n						</table>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"25\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr style=\\"text-align:left;\\">\r\n						<td bgcolor=\\"#fcfcfc\\" style=\\"padding:30px 20px 30px 20px;border:1px solid #f2f2f2;border-radius:5px;\\">\r\n							<h1>Interests conflict - response to the request for access to the record</h1>\r\n							<p>\r\n								Hello $(record : RecordLabel)$,<br>\r\n	your request for access to the record $(params : record)$ has been processed. <br>Request status: $(params : status)$\r\n							</p>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"40\\">&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n			<table align=\\"center\\" border=\\"0\\" cellpadding=\\"0\\" cellspacing=\\"0\\" class=\\"table1\\" style=\\"width:100%;\\">\r\n				<tbody>\r\n					<tr>\r\n						<td align=\\"center\\" class=\\"text_color_c6c6c6\\" style=\\"line-height:1;font-size:14px;font-weight:400;font-family:\\'Open Sans\\', Helvetica, sans-serif;\\">\r\n						<div class=\\"editable-text\\"><span class=\\"text_container\\">&copy; 2021 YetiForce S.A. All Rights Reserved.</span></div>\r\n						</td>\r\n					</tr>\r\n				</tbody>\r\n			</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td height=\\"20\\">&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n','InterestsConflictAccessResponse','1',NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_fcorectinginvoice_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',0,1,0,'{\"modules\":[\"Products\",\"Services\"],\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',3,1,0,'{}',1),
			(3,'discount','LBL_DISCOUNT','Discount',0,'0',6,1,0,'{}',1),
			(4,'comment1','LBL_COMMENT','Comment',0,'',12,2,0,'{}',0),
			(5,'currency','LBL_CURRENCY','Currency',0,'',13,0,0,'',1),
			(6,'discountmode','LBL_DISCOUNT_MODE','DiscountMode',0,'0',14,0,0,'',1),
			(7,'taxmode','LBL_TAX_MODE','TaxMode',0,'0',15,0,0,'',1),
			(8,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',4,1,0,'',1),
			(9,'gross','LBL_GROSS_PRICE','GrossPrice',0,'0',10,1,0,'',1),
			(10,'net','LBL_DISCOUNT_PRICE','NetPrice',0,'0',7,1,0,'',1),
			(11,'tax','LBL_TAX','Tax',0,'0',9,1,0,'',1),
			(12,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',5,1,0,'',1),
			(13,'unit','LBL_UNIT','Value',0,'',1,1,10,NULL,1),
			(14,'subunit','FL_SUBUNIT','Value',0,'',2,1,10,NULL,1),
			(15,'tax_percent','LBL_TAX_IN_PERCENT','TaxPercent',0,'0',8,1,0,'{\"summary_enabled\":1}',1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_fcorectinginvoice_invmap`(`module`,`field`,`tofield`) values
			('Products','subunit','subunit'),
			('Products','usageunit','unit'),
			('Services','service_usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_finvoice_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',0,1,0,'{\"modules\":[\"Products\",\"Services\"],\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',3,1,0,'{}',1),
			(3,'discount','LBL_DISCOUNT','Discount',0,'0',6,1,0,'{}',1),
			(4,'comment1','LBL_COMMENT','Comment',0,'',12,2,0,'{}',0),
			(5,'currency','LBL_CURRENCY','Currency',0,'',13,0,0,NULL,1),
			(6,'discountmode','LBL_DISCOUNT_MODE','DiscountMode',0,'',14,0,0,NULL,1),
			(7,'taxmode','LBL_TAX_MODE','TaxMode',0,'',15,0,0,NULL,1),
			(8,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',4,1,0,NULL,1),
			(9,'gross','LBL_GROSS_PRICE','GrossPrice',0,'0',10,1,0,NULL,1),
			(10,'net','LBL_DISCOUNT_PRICE','NetPrice',0,'0',7,1,0,NULL,1),
			(12,'tax','LBL_TAX','Tax',0,'0',9,1,0,NULL,1),
			(13,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',5,1,0,NULL,1),
			(14,'unit','LBL_UNIT','Value',0,'',1,1,10,NULL,1),
			(15,'subunit','FL_SUBUNIT','Value',0,'',2,1,10,NULL,1),
			(16,'tax_percent','LBL_TAX_IN_PERCENT','TaxPercent',0,'0',8,1,0,'{\"summary_enabled\":1}',1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_finvoice_invmap`(`module`,`field`,`tofield`) values
			('Products','subunit','subunit'),
			('Products','usageunit','unit'),
			('Services','service_usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_finvoicecost_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',0,1,0,'{\"modules\":[\"Products\",\"Services\"],\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',3,1,0,'{}',1),
			(3,'discount','LBL_DISCOUNT','Discount',0,'0',6,1,0,'{}',1),
			(4,'comment1','LBL_COMMENT','Comment',0,'',11,2,0,'{}',0),
			(5,'currency','LBL_CURRENCY','Currency',0,'',12,0,0,'',1),
			(6,'discountmode','LBL_DISCOUNT_MODE','DiscountMode',0,'0',13,0,0,'',1),
			(7,'taxmode','LBL_TAX_MODE','TaxMode',0,'0',14,0,0,'',1),
			(8,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',4,1,0,'',1),
			(9,'gross','LBL_GROSS_PRICE','GrossPrice',0,'0',9,1,0,'',1),
			(10,'net','LBL_DISCOUNT_PRICE','NetPrice',0,'0',7,1,0,'',1),
			(11,'tax','LBL_TAX','Tax',0,'0',8,1,0,'',1),
			(12,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',5,1,0,'',1),
			(13,'unit','LBL_UNIT','Value',0,'',1,1,10,'',1),
			(14,'subunit','FL_SUBUNIT','Value',0,'',2,1,10,'',1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_finvoiceproforma_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'currency','LBL_CURRENCY','Currency',0,'',1,0,0,'',1),
			(2,'discountmode','LBL_DISCOUNT_MODE','DiscountMode',0,'0',2,0,0,'',1),
			(3,'taxmode','LBL_TAX_MODE','TaxMode',0,'0',3,0,0,'',1),
			(4,'name','LBL_ITEM_NAME','Name',0,'',0,1,0,'{\"modules\":[\"Products\",\"Services\"],\"limit\":\" \"}',1),
			(5,'qty','LBL_QUANTITY','Quantity',0,'1',3,1,0,'{}',1),
			(6,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',4,1,0,'{}',1),
			(7,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',5,1,0,'{}',1),
			(8,'discount','LBL_DISCOUNT','Discount',0,'0',6,1,0,'{}',1),
			(9,'net','LBL_DISCOUNT_PRICE','NetPrice',0,'0',7,1,0,'{}',1),
			(10,'tax','LBL_TAX','Tax',0,'0',9,1,0,'{}',1),
			(11,'gross','LBL_GROSS_PRICE','GrossPrice',0,'0',10,1,0,'{}',1),
			(12,'comment1','LBL_COMMENT','Comment',0,'',13,2,0,'{}',0),
			(13,'unit','LBL_UNIT','Value',0,'',1,1,10,NULL,1),
			(14,'subunit','FL_SUBUNIT','Value',0,'',2,1,10,NULL,1),
			(15,'tax_percent','LBL_TAX_IN_PERCENT','TaxPercent',0,'0',8,1,0,'{\"summary_enabled\":1}',1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_finvoiceproforma_invmap`(`module`,`field`,`tofield`) values
			('Products','subunit','subunit'),
			('Products','usageunit','unit'),
			('Services','service_usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_igdn_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',1,1,0,'{\"modules\":\"Products\",\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',5,1,0,'{}',1),
			(3,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',6,1,0,'{}',1),
			(4,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',7,1,0,'{}',1),
			(5,'comment1','LBL_COMMENT','Comment',0,'',5,2,0,'{}',0),
			(6,'seq','LBL_ITEM_NUMBER','ItemNumber',0,'',0,1,0,NULL,1),
			(7,'unit','LBL_UNIT','Value',0,'',3,1,10,NULL,1),
			(8,'ean','LBL_EAN','Value',0,'',2,1,10,NULL,1),
			(9,'subunit','FL_SUBUNIT','Value',0,'',4,1,10,NULL,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_igdn_invmap`(`module`,`field`,`tofield`) values
			('Products','ean','ean'),
			('Products','subunit','subunit'),
			('Products','usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_igdnc_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',1,1,0,'{\"modules\":\"Products\",\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',5,1,0,'{}',1),
			(3,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',6,1,0,'{}',1),
			(4,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',7,1,0,'{}',1),
			(5,'comment1','LBL_COMMENT','Comment',0,'',5,2,0,'{}',0),
			(6,'seq','LBL_ITEM_NUMBER','ItemNumber',0,'',0,1,0,'',1),
			(7,'unit','LBL_UNIT','Value',0,'',3,1,10,'',1),
			(8,'ean','LBL_EAN','Value',0,'',2,1,10,'',1),
			(9,'subunit','FL_SUBUNIT','Value',0,'',4,1,10,'',1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_igdnc_invmap`(`module`,`field`,`tofield`) values
			('Products','ean','ean'),
			('Products','subunit','subunit'),
			('Products','usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_igin_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(6,'name','LBL_ITEM_NAME','Name',0,'',1,1,0,'{\"modules\":\"Products\",\"limit\":\" \"}',1),
			(7,'qty','LBL_QUANTITY','Quantity',0,'1',5,1,0,'{}',1),
			(8,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',6,1,0,'{}',1),
			(9,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',7,1,0,'{}',1),
			(10,'comment1','LBL_COMMENT','Comment',0,'',5,2,0,'{}',0),
			(11,'seq','LBL_ITEM_NUMBER','ItemNumber',0,'',0,1,0,NULL,1),
			(12,'unit','LBL_UNIT','Value',0,'',3,1,10,NULL,1),
			(13,'ean','LBL_EAN','Value',0,'',2,1,10,NULL,1),
			(14,'subunit','FL_SUBUNIT','Value',0,'',4,1,10,NULL,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_igin_invmap`(`module`,`field`,`tofield`) values
			('Products','ean','ean'),
			('Products','subunit','subunit'),
			('Products','usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_igrn_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',1,1,0,'{\"modules\":\"Products\",\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',5,1,0,'{}',1),
			(3,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',6,1,0,'{}',1),
			(4,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',7,1,0,'{}',1),
			(5,'comment1','LBL_COMMENT','Comment',0,'',5,2,0,'{}',0),
			(6,'seq','LBL_ITEM_NUMBER','ItemNumber',0,'',0,1,0,NULL,1),
			(7,'unit','LBL_UNIT','Value',0,'',3,1,10,NULL,1),
			(8,'ean','LBL_EAN','Value',0,'',2,1,10,NULL,1),
			(9,'subunit','FL_SUBUNIT','Value',0,'',4,1,10,NULL,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_igrn_invmap`(`module`,`field`,`tofield`) values
			('Products','ean','ean'),
			('Products','subunit','subunit'),
			('Products','usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_igrnc_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',1,1,0,'{\"modules\":\"Products\",\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',5,1,0,'{}',1),
			(3,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',6,1,0,'{}',1),
			(4,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',7,1,0,'{}',1),
			(5,'comment1','LBL_COMMENT','Comment',0,'',5,2,0,'{}',0),
			(6,'seq','LBL_ITEM_NUMBER','ItemNumber',0,'',0,1,0,'',1),
			(7,'unit','LBL_UNIT','Value',0,'',3,1,10,'',1),
			(8,'ean','LBL_EAN','Value',0,'',2,1,10,'',1),
			(9,'subunit','FL_SUBUNIT','Value',0,'',4,1,10,'',1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_igrnc_invmap`(`module`,`field`,`tofield`) values
			('Products','ean','ean'),
			('Products','subunit','subunit'),
			('Products','usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_iidn_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',1,1,0,'{\"modules\":\"Products\",\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',5,1,0,'{}',1),
			(3,'comment1','LBL_COMMENT','Comment',0,'',5,2,0,'{}',0),
			(4,'seq','LBL_ITEM_NUMBER','ItemNumber',0,'',0,1,0,NULL,1),
			(5,'unit','LBL_UNIT','Value',0,'',3,1,10,NULL,1),
			(6,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',6,1,0,'{}',1),
			(7,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',7,1,0,'{}',1),
			(8,'ean','LBL_EAN','Value',0,'',2,1,10,NULL,1),
			(9,'subunit','FL_SUBUNIT','Value',0,'',4,1,10,NULL,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_iidn_invmap`(`module`,`field`,`tofield`) values
			('Products','ean','ean'),
			('Products','subunit','subunit'),
			('Products','usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_ipreorder_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',1,1,0,'{\"modules\":\"Products\",\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',5,1,0,'{}',1),
			(3,'comment1','LBL_COMMENT','Comment',0,'',5,2,0,'{}',0),
			(4,'seq','LBL_ITEM_NUMBER','ItemNumber',0,'',0,1,0,'{}',1),
			(6,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',6,1,0,'{}',1),
			(7,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',7,1,0,'{}',1),
			(8,'unit','LBL_UNIT','Value',0,'',3,1,10,'{}',1),
			(9,'ean','LBL_EAN','Value',0,'',2,1,10,'{}',1),
			(10,'subunit','FL_SUBUNIT','Value',0,'',4,1,10,NULL,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_ipreorder_invmap`(`module`,`field`,`tofield`) values
			('Products','ean','ean'),
			('Products','subunit','subunit'),
			('Products','usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_istdn_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',1,1,0,'{\"modules\":\"Products\",\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',5,1,0,'{}',1),
			(3,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',6,1,0,'{}',1),
			(4,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',7,1,0,'{}',1),
			(5,'comment1','LBL_COMMENT','Comment',0,'',5,2,0,'{}',0),
			(6,'seq','LBL_ITEM_NUMBER','ItemNumber',0,'',0,1,0,'',1),
			(7,'unit','LBL_UNIT','Value',0,'',3,1,10,'',1),
			(8,'ean','LBL_EAN','Value',0,'',2,1,10,'',1),
			(9,'subunit','FL_SUBUNIT','Value',0,'',4,1,10,NULL,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_istdn_invmap`(`module`,`field`,`tofield`) values
			('Products','ean','ean'),
			('Products','subunit','subunit'),
			('Products','usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_istrn_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',1,1,0,'{\"modules\":\"Products\",\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',5,1,0,'{}',1),
			(3,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',6,1,0,'{}',1),
			(4,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',7,1,0,'{}',1),
			(5,'comment1','LBL_COMMENT','Comment',0,'',5,2,0,'{}',0),
			(6,'seq','LBL_ITEM_NUMBER','ItemNumber',0,'',0,1,0,'',1),
			(7,'unit','LBL_UNIT','Value',0,'',3,1,10,'',1),
			(8,'ean','LBL_EAN','Value',0,'',2,1,10,'',1),
			(9,'subunit','FL_SUBUNIT','Value',0,'',4,1,10,NULL,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_istrn_invmap`(`module`,`field`,`tofield`) values
			('Products','ean','ean'),
			('Products','subunit','subunit'),
			('Products','usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_multicompany`(`multicompanyid`,`company_name`,`parent_id`,`number`,`mulcomp_status`,`email1`,`email2`,`phone`,`phone_extra`,`mobile`,`mobile_extra`,`fax`,`fax_extra`,`vat`,`companyid1`,`companyid2`,`buildingnumbera`,`localnumbera`,`addresslevel8a`,`addresslevel7a`,`addresslevel6a`,`addresslevel5a`,`addresslevel4a`,`addresslevel3a`,`addresslevel2a`,`addresslevel1a`,`poboxa`,`website`,`logo`) values
			(1,'YetiForce S.A. ',0,'MC1','PLL_ACTIVE','','','','','','','','','','','','','','','','','','','','','','','','[{\"name\":\"logo_yetiforce.png\",\"size\":\"3 KB\",\"path\":\"public_html/layouts/resources/Logo/logo_login_page.png\",\"key\":\"11111111111111111111111111111111111111111111111111\"}]');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_multicompanycf`(`multicompanyid`,`public_notes`,`internal_notes`) values
			(1,'','');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_openstreetmap_address_updater`(`crmid`) values
			(0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_picklist_close_state`(`valueid`,`fieldid`,`value`) values
			(958,2606,'PLL_DELIVERED'),
			(962,2606,'PLL_REPLY');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_scalculations_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',0,1,0,'{\"modules\":[\"Products\",\"Services\"],\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',3,1,0,'{}',1),
			(4,'comment1','LBL_COMMENT','Comment',0,'',3,2,0,'{}',0),
			(5,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',4,1,0,NULL,1),
			(6,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',5,1,0,NULL,1),
			(7,'purchase','LBL_PURCHASE','Purchase',0,'0',6,1,0,NULL,1),
			(8,'marginp','LBL_MARGIN_PERCENT','MarginP',0,'0',7,1,0,NULL,1),
			(9,'margin','LBL_MARGIN','Margin',0,'0',8,1,0,NULL,1),
			(10,'unit','LBL_UNIT','Value',0,'',1,1,10,NULL,1),
			(11,'subunit','FL_SUBUNIT','Value',0,'',2,1,10,NULL,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_scalculations_invmap`(`module`,`field`,`tofield`) values
			('Products','subunit','subunit'),
			('Products','usageunit','unit'),
			('Services','service_usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_squotes_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',0,1,0,'{\"modules\":[\"Products\",\"Services\"],\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',3,1,0,'{}',1),
			(3,'discount','LBL_DISCOUNT','Discount',0,'0',6,1,0,'{}',1),
			(4,'marginp','LBL_MARGIN_PERCENT','MarginP',0,'0',9,1,0,'{}',1),
			(5,'margin','LBL_MARGIN','Margin',0,'0',10,1,0,'{}',1),
			(6,'comment1','LBL_COMMENT','Comment',0,'',6,2,0,'{}',0),
			(7,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',4,1,0,NULL,1),
			(8,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',5,1,0,NULL,1),
			(9,'purchase','LBL_PURCHASE','Purchase',0,'0',8,1,0,NULL,1),
			(10,'tax','LBL_TAX','Tax',0,'0',11,1,0,NULL,1),
			(11,'gross','LBL_GROSS_PRICE','GrossPrice',0,'0',12,1,0,NULL,1),
			(12,'discountmode','LBL_DISCOUNT_MODE','DiscountMode',0,'0',10,0,0,NULL,1),
			(13,'taxmode','LBL_TAX_MODE','TaxMode',0,'0',11,0,0,NULL,1),
			(14,'currency','LBL_CURRENCY','Currency',0,'',12,0,0,NULL,1),
			(15,'net','LBL_DISCOUNT_PRICE','NetPrice',0,'0',7,1,0,NULL,1),
			(17,'unit','LBL_UNIT','Value',0,'',1,1,10,NULL,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_squotes_invmap`(`module`,`field`,`tofield`) values
			('Products','subunit','subunit'),
			('Products','usageunit','unit'),
			('Services','service_usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_srecurringorders_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',0,1,0,'{\"modules\":[\"Products\",\"Services\"],\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',3,1,0,'{}',1),
			(3,'discount','LBL_DISCOUNT','Discount',0,'0',6,1,0,'{}',1),
			(4,'marginp','LBL_MARGIN_PERCENT','MarginP',0,'0',9,1,0,'{}',1),
			(5,'margin','LBL_MARGIN','Margin',0,'0',10,1,0,'{}',1),
			(6,'tax','LBL_TAX','Tax',0,'0',11,1,0,'{}',1),
			(7,'comment1','LBL_COMMENT','Comment',0,'',7,2,0,'{}',0),
			(8,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',4,1,0,NULL,1),
			(9,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',5,1,0,NULL,1),
			(10,'net','LBL_DISCOUNT_PRICE','NetPrice',0,'0',7,1,0,NULL,1),
			(11,'purchase','LBL_PURCHASE','Purchase',0,'0',8,1,0,NULL,1),
			(12,'gross','LBL_GROSS_PRICE','GrossPrice',0,'0',12,1,0,NULL,1),
			(13,'discountmode','LBL_DISCOUNT_MODE','DiscountMode',0,'0',11,0,0,NULL,1),
			(14,'taxmode','LBL_TAX_MODE','TaxMode',0,'0',12,0,0,NULL,1),
			(15,'currency','LBL_CURRENCY','Currency',0,'',13,0,0,NULL,1),
			(16,'unit','LBL_UNIT','Value',0,'',1,1,10,NULL,1),
			(17,'subunit','FL_SUBUNIT','Value',0,'',2,1,10,NULL,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_srecurringorders_invmap`(`module`,`field`,`tofield`) values
			('Products','subunit','subunit'),
			('Products','usageunit','unit'),
			('Services','service_usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_srequirementscards_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',0,1,0,'{\"modules\":[\"Products\",\"Services\"],\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',3,1,0,'{}',1),
			(3,'comment1','LBL_COMMENT','Comment',0,'',3,2,0,'{}',0),
			(4,'unit','LBL_UNIT','Value',0,'',1,1,10,NULL,1),
			(5,'subunit','FL_SUBUNIT','Value',0,'',2,1,10,NULL,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_srequirementscards_invmap`(`module`,`field`,`tofield`) values
			('Products','subunit','subunit'),
			('Products','usageunit','unit'),
			('Services','service_usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_ssingleorders_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',0,1,0,'{\"modules\":[\"Products\",\"Services\"],\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',3,1,0,'{}',1),
			(3,'discount','LBL_DISCOUNT','Discount',0,'0',6,1,0,'{}',1),
			(4,'marginp','LBL_MARGIN_PERCENT','MarginP',0,'0',9,1,0,'{}',1),
			(5,'margin','LBL_MARGIN','Margin',0,'0',10,1,0,'{}',1),
			(6,'tax','LBL_TAX','Tax',0,'0',11,1,0,'{}',1),
			(7,'comment1','LBL_COMMENT','Comment',0,'',7,2,0,'{}',0),
			(8,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',4,1,0,NULL,1),
			(9,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',5,1,0,NULL,1),
			(10,'net','LBL_DISCOUNT_PRICE','NetPrice',0,'0',7,1,0,NULL,1),
			(11,'purchase','LBL_PURCHASE','Purchase',0,'0',8,1,0,NULL,1),
			(12,'gross','LBL_GROSS_PRICE','GrossPrice',0,'0',12,1,0,NULL,1),
			(13,'discountmode','LBL_DISCOUNT_MODE','DiscountMode',0,'0',11,0,0,NULL,1),
			(14,'taxmode','LBL_TAX_MODE','TaxMode',0,'0',12,0,0,NULL,1),
			(15,'currency','LBL_CURRENCY','Currency',0,'',13,0,0,NULL,1),
			(16,'unit','LBL_UNIT','Unit',0,'',1,1,10,NULL,1),
			(17,'subunit','FL_SUBUNIT','Value',0,'',2,1,10,NULL,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_ssingleorders_invmap`(`module`,`field`,`tofield`) values
			('Products','subunit','subunit'),
			('Products','usageunit','unit'),
			('Services','service_usageunit','unit');
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_svendorenquiries_invfield`(`id`,`columnname`,`label`,`invtype`,`presence`,`defaultvalue`,`sequence`,`block`,`displaytype`,`params`,`colspan`) values
			(1,'name','LBL_ITEM_NAME','Name',0,'',0,1,0,'{\"modules\":[\"Products\",\"Services\"],\"limit\":\" \"}',1),
			(2,'qty','LBL_QUANTITY','Quantity',0,'1',3,1,0,'{}',1),
			(3,'comment1','LBL_COMMENT','Comment',0,'',3,2,0,'{}',0),
			(4,'price','LBL_UNIT_PRICE','UnitPrice',0,'0',4,1,0,'',1),
			(5,'total','LBL_TOTAL_PRICE','TotalPrice',0,'0',5,1,0,'',1),
			(6,'purchase','LBL_PURCHASE','Purchase',0,'0',6,1,0,'',1),
			(7,'marginp','LBL_MARGIN_PERCENT','MarginP',0,'0',7,1,0,'',1),
			(8,'margin','LBL_MARGIN','Margin',0,'0',8,1,0,'',1),
			(9,'unit','LBL_UNIT','Value',0,'',1,1,10,'',1),
			(10,'subunit','FL_SUBUNIT','Value',0,'',2,1,10,'',1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `u_yf_users_labels`(`id`,`label`) values
			(1,'Administrator ');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_accounts_available_taxes`(`accounts_available_taxesid`,`accounts_available_taxes`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'LBL_REGIONAL_TAX',1,931,1),
			(2,'LBL_GROUP_TAX',1,932,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_accounts_status`(`accounts_statusid`,`accounts_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_PROMISING_CLIENT',1,705,1),
			(2,'PLL_ACTIVE_CLIENT',1,706,2),
			(3,'PLL_SPECIAL_CLIENT',1,707,3),
			(4,'PLL_LOST_CLIENT',1,708,4),
			(5,'PLL_UNOBTAINED_CLIENT',1,709,5),
			(6,'PLL_INACTIVE_CLIENT',1,710,6),
			(7,'PLL_CLOSED_CLIENT',1,711,7),
			(8,'PLL_BLACKLISTED_CLIENT',1,712,8);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_accounttype`(`accounttypeid`,`accounttype`,`presence`,`picklist_valueid`,`sortorderid`) values
			(2,'Analyst',1,2,1),
			(3,'Competitor',1,3,2),
			(4,'Customer',1,4,3),
			(5,'Integrator',1,5,4),
			(6,'Investor',1,6,5),
			(7,'Partner',1,7,6),
			(8,'Press',1,8,7),
			(9,'Prospect',1,9,8),
			(10,'Reseller',1,10,9),
			(11,'Other',1,11,10);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_actionmapping`(`actionid`,`actionname`,`securitycheck`) values
			(0,'Save',0),
			(0,'SavePriceBook',1),
			(0,'SaveVendor',1),
			(1,'DetailViewAjax',1),
			(1,'EditView',0),
			(1,'PriceBookEditView',1),
			(1,'QuickCreate',1),
			(1,'VendorEditView',1),
			(2,'Delete',0),
			(2,'DeletePriceBook',1),
			(2,'DeleteVendor',1),
			(3,'index',0),
			(3,'Popup',1),
			(4,'DetailView',0),
			(4,'PriceBookDetailView',1),
			(4,'VendorDetailView',1),
			(5,'Import',0),
			(6,'Export',0),
			(7,'CreateView',0),
			(8,'Merge',0),
			(9,'ConvertLead',0),
			(13,'ModTracker',0),
			(14,'CreateCustomFilter',0),
			(15,'DuplicateRecord',0),
			(16,'EditableComments',0),
			(17,'MassEdit',0),
			(18,'MassDelete',0),
			(19,'MassAddComment',0),
			(20,'MassComposeEmail',0),
			(21,'MassSendSMS',0),
			(22,'MassTransferOwnership',0),
			(23,'MassMoveDocuments',0),
			(24,'ReadRecord',0),
			(25,'WorkflowTrigger',0),
			(26,'Dashboard',0),
			(27,'CreateDashboardFilter',0),
			(28,'QuickExportToExcel',0),
			(30,'DetailTransferOwnership',0),
			(31,'ActivityPostponed',0),
			(32,'ActivityCancel',0),
			(33,'ActivityComplete',0),
			(34,'ExportPdf',0),
			(35,'PrintMail',0),
			(36,'RecordMapping',0),
			(37,'RecordMappingList',0),
			(38,'OpenRecord',0),
			(39,'CloseRecord',0),
			(40,'FavoriteRecords',0),
			(41,'WatchingRecords',0),
			(42,'WatchingModule',0),
			(46,'RemoveRelation',0),
			(47,'ReceivingMailNotifications',0),
			(48,'ReviewingUpdates',0),
			(49,'CreateDashboardChartFilter',0),
			(51,'TimeLineList',0),
			(52,'MassArchived',0),
			(53,'MassActive',0),
			(54,'ArchiveRecord',0),
			(55,'ActiveRecord',0),
			(56,'MassTrash',0),
			(57,'MoveToTrash',0),
			(58,'RecordConventer',0),
			(59,'AutoAssignRecord',0),
			(60,'AssignToYourself',0),
			(61,'RecordPdfInventory',0),
			(62,'SetQtyProducts',0),
			(63,'RecordCollector',0),
			(64,'MeetingUrl',0),
			(65,'InterestsConflictUsers',0),
			(66,'Kanban',0),
			(67,'CustomViewAdvCond',0),
			(68,'RecordActivityNotifier',0),
			(69,'WorkflowTriggerWhenRecordIsBlocked',0),
			(70,'ServiceContractsSla',0),
			(71,'TilesView',0),
			(72,'LeaderCanManageGroupMembership',0),
			(73,'CalendarExtraSources',0),
			(74,'CalendarExtraSourcesCreate',0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_activity_view`(`activity_viewid`,`activity_view`,`sortorderid`,`presence`) values
			(1,'Today',0,1),
			(2,'This Week',1,1),
			(3,'This Month',2,1),
			(4,'This Year',3,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_activityregister_status`(`activityregister_statusid`,`activityregister_status`,`presence`,`sortorderid`) values
			(1,'PLL_DRAFT',1,1),
			(2,'PLL_WAITING_FOR_ACCEPTANCE',1,2),
			(3,'PLL_IN_REALIZATION',1,3),
			(4,'PLL_COMPLETED',1,4),
			(5,'PLL_CANCELLED',1,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_activitystatus`(`activitystatusid`,`activitystatus`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_PLANNED',0,173,0),
			(2,'PLL_IN_REALIZATION',0,174,1),
			(3,'PLL_OVERDUE',0,175,2),
			(4,'PLL_POSTPONED',0,176,3),
			(5,'PLL_CANCELLED',0,177,4),
			(6,'PLL_COMPLETED',0,178,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_activitytype`(`activitytypeid`,`activitytype`,`presence`,`sortorderid`,`color`,`icon`) values
			(1,'Call',0,0,'80B584',NULL),
			(2,'Meeting',0,1,'FFD500',NULL),
			(3,'Task',0,2,'00d4f5',NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_announcementstatus`(`announcementstatusid`,`announcementstatus`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_DRAFT',1,697,1),
			(2,'PLL_FOR_ACCEPTANCE',1,698,2),
			(3,'PLL_PUBLISHED',0,699,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_approvals_register_status`(`approvals_register_statusid`,`approvals_register_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_FOR_VERIFICATION',1,937,1),
			(2,'PLL_ACCEPTED',0,938,2),
			(3,'PLL_REJECTED',1,939,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_approvals_register_type`(`approvals_register_typeid`,`approvals_register_type`,`presence`,`sortorderid`) values
			(1,'PLL_ACCEPTANCE',0,1),
			(2,'PLL_RESIGNATION',0,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_approvals_status`(`approvals_statusid`,`approvals_status`,`presence`,`sortorderid`) values
			(1,'PLL_DRAFT',1,1),
			(2,'PLL_ACTIVE',0,2),
			(3,'PLL_INACTIVE',1,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_assets_renew`(`assets_renewid`,`assets_renew`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_PLANNED',0,682,1),
			(2,'PLL_WAITING_FOR_RENEWAL',0,683,2),
			(3,'PLL_RENEWED_VERIFICATION',0,684,3),
			(4,'PLL_NOT_RENEWED_VERIFICATION',0,685,4),
			(5,'PLL_RENEWED',0,686,6),
			(6,'PLL_NOT_RENEWED',0,687,7),
			(7,'PLL_NOT_APPLICABLE',0,688,8),
			(8,'PLL_NOT_APPLICABLE_VERIFICATION',0,702,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_assetstatus`(`assetstatusid`,`assetstatus`,`presence`,`picklist_valueid`,`sortorderid`) values
			(3,'PLL_DRAFT',1,508,3),
			(4,'PLL_WAITING_FOR_VERIFICATION',1,509,4),
			(5,'PLL_WAITING_FOR_ACCEPTANCE',1,510,5),
			(6,'PLL_ACCEPTED',0,511,6),
			(7,'PLL_CANCELLED',0,672,7);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_asteriskextensions`(`userid`,`asterisk_extension`,`use_asterisk`) values
			(1,NULL,NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_auditregister_status`(`auditregister_statusid`,`auditregister_status`,`presence`,`sortorderid`) values
			(1,'PLL_DRAFT',1,1),
			(2,'PLL_WAITING_FOR_ACCEPTANCE',1,2),
			(3,'PLL_IN_REALIZATION',1,3),
			(4,'PLL_COMPLETED',1,4),
			(5,'PLL_CANCELLED',1,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_auditregister_type`(`auditregister_typeid`,`auditregister_type`,`presence`,`sortorderid`) values
			(1,'PLL_INTERNAL',1,1),
			(2,'PLL_EXTERNAL',1,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_authy_methods`(`authy_methodsid`,`authy_methods`,`presence`,`sortorderid`) values
			(1,'-',1,1),
			(2,'PLL_AUTHY_TOTP',1,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_bankaccount_status`(`bankaccount_statusid`,`bankaccount_status`,`presence`,`sortorderid`) values
			(1,'PLL_DRAFT',1,1),
			(2,'PLL_ACTIVE',1,2),
			(3,'PLL_INACTIVE',1,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_blocks`(`blockid`,`tabid`,`blocklabel`,`sequence`,`show_title`,`visible`,`create_view`,`edit_view`,`detail_view`,`display_status`,`iscustom`,`icon`) values
			(4,4,'LBL_CONTACT_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(5,4,'LBL_CUSTOM_INFORMATION',3,0,0,0,0,0,0,0,NULL),
			(6,4,'LBL_CUSTOMER_PORTAL_INFORMATION',4,0,0,0,0,0,0,0,NULL),
			(7,4,'LBL_ADDRESS_INFORMATION',6,0,0,0,0,0,0,0,NULL),
			(8,4,'LBL_DESCRIPTION_INFORMATION',8,0,0,0,0,0,0,0,NULL),
			(9,6,'LBL_ACCOUNT_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(10,6,'LBL_ADDRESS_MAILING_INFORMATION',8,0,0,0,0,0,0,0,NULL),
			(11,6,'LBL_ADDRESS_INFORMATION',7,0,0,0,0,0,0,0,NULL),
			(12,6,'LBL_DESCRIPTION_INFORMATION',10,0,0,0,0,0,2,0,NULL),
			(13,7,'LBL_LEAD_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(14,7,'LBL_CUSTOM_INFORMATION',4,0,0,0,0,0,0,0,NULL),
			(15,7,'LBL_ADDRESS_INFORMATION',5,0,0,0,0,0,0,0,NULL),
			(16,7,'LBL_DESCRIPTION_INFORMATION',7,0,0,0,0,0,0,0,NULL),
			(17,8,'LBL_NOTE_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(18,8,'LBL_FILE_INFORMATION',3,1,0,0,0,0,2,0,NULL),
			(19,9,'LBL_TASK_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(20,9,'LBL_DESCRIPTION_INFORMATION',2,1,0,0,0,0,2,0,NULL),
			(25,13,'LBL_TICKET_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(26,13,'',3,1,0,0,0,0,2,0,NULL),
			(27,13,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(28,13,'LBL_DESCRIPTION_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(29,13,'LBL_TICKET_RESOLUTION',5,0,0,1,0,0,2,0,NULL),
			(31,14,'LBL_PRODUCT_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(32,14,'LBL_PRICING_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(33,14,'LBL_STOCK_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(34,14,'LBL_CUSTOM_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(35,14,'LBL_IMAGE_INFORMATION',5,0,0,0,0,0,2,0,NULL),
			(36,14,'LBL_DESCRIPTION_INFORMATION',6,0,0,0,0,0,2,0,NULL),
			(37,15,'LBL_FAQ_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(38,15,'LBL_CUSTOM_INFORMATION',5,0,0,1,0,0,2,0,NULL),
			(40,9,'LBL_REMINDER_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(42,18,'LBL_VENDOR_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(43,18,'LBL_ADDRESS_MAILING_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(44,18,'LBL_ADDRESS_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(45,18,'LBL_DESCRIPTION_INFORMATION',6,0,0,0,0,0,2,0,NULL),
			(46,19,'LBL_PRICEBOOK_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(47,19,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(48,19,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(73,4,'LBL_IMAGE_INFORMATION',9,0,0,0,0,0,0,0,NULL),
			(74,26,'LBL_CAMPAIGN_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(75,26,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(76,26,'LBL_EXPECTATIONS_AND_ACTUALS',3,0,0,0,0,0,2,0,NULL),
			(77,29,'LBL_USERLOGIN_ROLE',1,0,0,0,0,0,2,0,'fas fa-user-tie'),
			(78,29,'LBL_CURRENCY_CONFIGURATION',4,0,0,0,0,0,2,0,'fas fa-money-check-alt'),
			(79,29,'LBL_MORE_INFORMATION',13,0,0,0,0,0,2,0,'fas fa-info-circle'),
			(80,29,'LBL_PBX',9,0,0,0,0,0,1,1,'fa-solid fa-square-phone'),
			(81,26,'LBL_DESCRIPTION_INFORMATION',5,0,0,0,0,0,2,0,NULL),
			(83,29,'LBL_USER_ADV_OPTIONS',7,0,0,0,0,0,2,0,'fas fa-user-lock'),
			(84,8,'LBL_DESCRIPTION',2,0,0,0,0,0,2,0,NULL),
			(87,9,'LBL_RELATED_TO',3,0,0,0,0,0,2,0,NULL),
			(89,34,'LBL_SERVICE_CONTRACT_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(90,34,'LBL_CUSTOM_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(91,35,'LBL_SERVICE_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(92,35,'LBL_PRICING_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(93,35,'LBL_CUSTOM_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(94,35,'LBL_DESCRIPTION_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(95,37,'LBL_ASSET_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(96,37,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(97,37,'LBL_DESCRIPTION_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(98,40,'LBL_MODCOMMENTS_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(99,40,'LBL_OTHER_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(100,40,'LBL_CUSTOM_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(101,41,'LBL_PROJECT_MILESTONE_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(102,41,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(103,41,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(104,42,'LBL_PROJECT_TASK_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(105,42,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(106,42,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(107,43,'LBL_PROJECT_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(108,43,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(109,43,'LBL_DESCRIPTION_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(110,45,'LBL_SMSNOTIFIER_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(111,45,'LBL_CUSTOM_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(117,9,'LBL_RECURRENCE_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(118,29,'LBL_CALENDAR_SETTINGS',3,0,0,0,0,0,2,0,'far fa-calendar-alt'),
			(128,51,'LBL_MAIN_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(129,51,'LBL_BLOCK',2,0,0,0,0,0,0,0,NULL),
			(130,51,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(134,54,'LBL_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(135,54,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(136,54,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,0,0,NULL),
			(137,54,'LBL_ORIGN_MESSAGE',4,0,0,0,0,0,0,0,NULL),
			(138,57,'LBL_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(139,57,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(140,57,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(141,58,'LBL_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(142,58,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(143,58,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(144,59,'LBL_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(145,59,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(146,59,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(150,7,'Contact Information',2,0,0,0,0,0,2,0,NULL),
			(151,61,'LBL_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(152,61,'LBL_CONTACTS',2,0,0,0,0,0,2,0,NULL),
			(153,61,'LBL_PERMANENT_ADDRESS',3,0,0,0,0,0,2,0,NULL),
			(154,61,'LBL_CORRESPONDANCE_ADDRESS',4,0,0,0,0,0,2,0,NULL),
			(178,4,'LBL_ADDRESS_MAILING_INFORMATION',7,0,0,0,0,0,0,0,NULL),
			(179,18,'LBL_ADDRESS_DELIVERY_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(181,6,'LBL_ADDRESS_DELIVERY_INFORMATION',9,0,0,0,0,0,0,0,NULL),
			(191,7,'LBL_REGISTRATION_INFO',3,0,0,0,0,0,0,0,NULL),
			(192,37,'BLOCK_INFORMATION_TIME',3,0,0,0,0,0,2,0,NULL),
			(194,6,'LBL_REGISTRATION_INFO',5,0,0,0,0,0,2,0,NULL),
			(195,6,'LBL_CONTACT_INFO',2,0,0,0,0,0,2,0,NULL),
			(196,6,'LBL_ADVANCED_BLOCK',4,0,0,0,0,0,2,0,NULL),
			(197,4,'LBL_CONTACT_INFO',2,0,0,0,0,0,2,0,NULL),
			(198,6,'LBL_FINANSIAL_SUMMARY',3,0,0,0,0,0,2,0,NULL),
			(232,74,'LBL_CALLHISTORY_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(233,74,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(234,74,'LBL_PHONE_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(235,74,'LBL_RELATED_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(236,75,'LBL_IDEAS_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(238,75,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(247,78,'LBL_HOLIDAYSENTITLEMENT_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(248,78,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(250,79,'LBL_MAIN_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(251,79,'LBL_PAYMENT_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(252,80,'LBL_MAIN_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(253,80,'LBL_PAYMENT_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(254,81,'LBL_MAIN_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(255,81,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(256,82,'LBL_MAIN_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(257,82,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(258,83,'LBL_ANNOUNCEMENTS_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(259,83,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(260,83,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(261,84,'LBL_MAIN_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(262,84,'LBL_BLOCK',2,0,0,0,0,0,2,0,NULL),
			(263,84,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(265,85,'LBL_QUOTESENQUIRES_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(266,85,'LBL_DESCRIPTION_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(267,85,'LBL_STATISTICS',3,0,0,0,0,0,2,0,NULL),
			(268,85,'LBL_CUSTOM_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(269,86,'LBL_SSALESPROCESSES_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(270,86,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(271,86,'LBL_DESCRIPTION_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(272,87,'LBL_SREQUIREMENTSCARDS_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(273,87,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(274,87,'LBL_STATISTICS',4,0,0,0,0,0,2,0,NULL),
			(275,87,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(276,88,'LBL_SCALCULATIONS_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(277,88,'LBL_DESCRIPTION_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(278,88,'LBL_STATISTICS',3,0,0,0,0,0,2,0,NULL),
			(279,88,'LBL_CUSTOM_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(280,89,'LBL_SQUOTES_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(281,89,'LBL_DESCRIPTION_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(282,89,'LBL_STATISTICS',3,0,0,0,0,0,2,0,NULL),
			(283,89,'LBL_CUSTOM_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(284,90,'LBL_SSINGLEORDERS_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(285,90,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(286,90,'LBL_STATISTICS',4,0,0,0,0,0,2,0,NULL),
			(287,90,'LBL_CUSTOM_INFORMATION',5,0,0,0,0,0,2,0,NULL),
			(288,91,'LBL_SRECURRINGORDERS_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(289,91,'LBL_DESCRIPTION_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(290,91,'LBL_STATISTICS',3,0,0,0,0,0,2,0,NULL),
			(291,91,'LBL_CUSTOM_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(292,91,'LBL_PERIODIC_GENERATION',5,0,0,0,0,0,2,0,NULL),
			(293,89,'LBL_ADDRESS_INFORMATION',5,0,0,0,0,0,2,0,NULL),
			(295,90,'LBL_ADDRESS_BILLING',6,0,0,0,0,0,2,0,NULL),
			(297,91,'LBL_ADDRESS_INFORMATION',6,0,0,0,0,0,2,0,NULL),
			(299,92,'LBL_PARTNERS_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(300,92,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(301,92,'LBL_ADDRESS_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(302,92,'LBL_DESCRIPTION_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(303,93,'LBL_COMPETITION_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(304,93,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(305,93,'LBL_ADDRESS_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(306,93,'LBL_DESCRIPTION_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(307,94,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(308,94,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(309,94,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(310,95,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(311,95,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(312,95,'LBL_ADDRESS_BILLING',3,0,0,0,0,0,2,0,NULL),
			(314,96,'LBL_KNOWLEDGEBASE_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(315,96,'LBL_ARTICLE',2,0,0,0,0,0,2,0,NULL),
			(316,97,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(317,97,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(318,97,'LBL_DESCRIPTION_BLOCK',4,0,0,0,0,0,0,0,NULL),
			(319,86,'LBL_ATTENTION',5,0,0,0,0,0,2,0,NULL),
			(320,86,'LBL_FINANCES',3,0,0,0,0,0,2,0,NULL),
			(321,98,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(322,98,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(323,99,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(324,99,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(325,99,'LBL_ADDRESS_BILLING',3,0,0,0,0,0,2,0,NULL),
			(327,100,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(328,100,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(329,101,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(330,101,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(331,102,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(332,102,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(333,103,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(334,103,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(335,98,'LBL_DESCRIPTION_BLOCK',3,0,0,0,0,0,0,0,NULL),
			(336,98,'LBL_ATTENTION_BLOCK',4,0,0,0,0,0,0,0,NULL),
			(337,100,'LBL_DESCRIPTION_BLOCK',3,0,0,0,0,0,0,0,NULL),
			(338,100,'LBL_ATTENTION_BLOCK',4,0,0,0,0,0,0,0,NULL),
			(339,101,'LBL_DESCRIPTION_BLOCK',3,0,0,0,0,0,0,0,NULL),
			(340,101,'LBL_ATTENTION_BLOCK',4,0,0,0,0,0,0,0,NULL),
			(341,102,'LBL_DESCRIPTION_BLOCK',3,0,0,0,0,0,0,0,NULL),
			(342,102,'LBL_ATTENTION_BLOCK',4,0,0,0,0,0,0,0,NULL),
			(343,97,'LBL_ATTENTION_BLOCK',5,0,0,0,0,0,0,0,NULL),
			(344,103,'LBL_DESCRIPTION_BLOCK',3,0,0,0,0,0,0,0,NULL),
			(345,103,'LBL_ATTENTION_BLOCK',4,0,0,0,0,0,0,0,NULL),
			(346,97,'LBL_ADDRESS_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(347,104,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(348,104,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(349,104,'LBL_DESCRIPTION_BLOCK',3,0,0,0,0,0,0,0,NULL),
			(350,104,'LBL_ATTENTION_BLOCK',4,0,0,0,0,0,0,0,NULL),
			(351,105,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(352,105,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(353,105,'LBL_DESCRIPTION_BLOCK',3,0,0,0,0,0,0,0,NULL),
			(354,105,'LBL_ATTENTION_BLOCK',4,0,0,0,0,0,0,0,NULL),
			(355,106,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(356,106,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(357,106,'LBL_DESCRIPTION_BLOCK',3,0,0,0,0,0,0,0,NULL),
			(358,106,'LBL_ATTENTION_BLOCK',4,0,0,0,0,0,0,0,NULL),
			(361,107,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(362,107,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(363,107,'LBL_ADDRESS_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(365,108,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(366,108,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(367,108,'LBL_DESCRIPTION_BLOCK',3,0,0,0,0,0,0,0,NULL),
			(368,108,'LBL_ATTENTION_BLOCK',4,0,0,0,0,0,0,0,NULL),
			(369,109,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(370,109,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(371,109,'LBL_DESCRIPTION_BLOCK',3,0,0,0,0,0,0,0,NULL),
			(372,109,'LBL_ATTENTION_BLOCK',4,0,0,0,0,0,0,0,NULL),
			(374,111,'LBL_NOTIFICATION_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(375,111,'LBL_NOTIFICATION_CONTENTS',3,0,0,0,0,0,2,0,NULL),
			(376,112,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(377,112,'LBL_CONTENT_MAIL',2,0,0,0,0,0,2,0,NULL),
			(378,112,'LBL_CUSTOM_INFORMATION',3,0,0,0,0,0,0,0,NULL),
			(379,113,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(380,113,'LBL_VEHICLE',2,0,0,0,0,0,2,0,NULL),
			(381,113,'LBL_ATTENTION_BLOCK',3,0,0,0,0,0,2,0,NULL),
			(382,113,'LBL_DESCRIPTION_BLOCK',4,0,0,0,0,0,2,0,NULL),
			(383,114,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(384,114,'LBL_ADDITIONAL_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(385,114,'LBL_DESCRIPTION_BLOCK',3,0,0,0,0,0,2,0,NULL),
			(386,114,'LBL_ATTENTION_BLOCK',4,0,0,0,0,0,2,0,NULL),
			(387,114,'LBL_TICKET_RESOLUTION',5,0,0,0,0,0,2,0,NULL),
			(388,115,'LBL_BASIC_DETAILS',1,0,0,0,0,0,2,0,NULL),
			(389,115,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(390,115,'LBL_ADDRESS_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(392,115,'LBL_DESCRIPTION_BLOCK',5,0,0,0,0,0,2,0,NULL),
			(393,115,'LBL_ATTENTION_BLOCK',6,0,0,0,0,0,2,0,NULL),
			(394,116,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(395,116,'LBL_ATTENTION_BLOCK',3,0,0,0,0,0,2,0,NULL),
			(396,116,'LBL_DESCRIPTION_BLOCK',4,0,0,0,0,0,2,0,NULL),
			(397,116,'LBL_ADDITIONAL_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(398,95,'LBL_DESCRIPTION_BLOCK',5,0,0,0,0,0,2,0,NULL),
			(399,95,'LBL_ATTENTION_BLOCK',6,0,0,0,0,0,2,0,NULL),
			(400,117,'LBL_SCALCULATIONS_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(401,117,'LBL_DESCRIPTION_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(402,117,'LBL_STATISTICS',3,0,0,0,0,0,2,0,NULL),
			(403,117,'LBL_CUSTOM_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(404,119,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(405,119,'LBL_SYSTEM_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(406,119,'LBL_ADDITIONAL_INFORMATION',6,0,0,0,0,0,2,0,NULL),
			(407,119,'LBL_CONTACT_INFORMATION',2,0,0,0,0,0,2,0,NULL),
			(408,119,'LBL_REGISTRATION_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(409,119,'LBL_ADDRESS_INFORMATION',5,0,0,0,0,0,2,0,NULL),
			(410,121,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(411,121,'LBL_CUSTOM_INFORMATION',5,0,0,0,0,0,2,0,NULL),
			(412,121,'LBL_DESCRIPTION',3,0,0,0,0,0,2,0,NULL),
			(413,121,'LBL_COMMENTS',4,0,0,0,0,0,2,0,NULL),
			(414,121,'LBL_REGISTER_DATE',2,0,0,0,0,0,2,0,NULL),
			(415,122,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(416,122,'LBL_CUSTOM_INFORMATION',5,0,0,0,0,0,2,0,NULL),
			(417,122,'LBL_DATES',2,0,0,0,0,0,2,0,NULL),
			(418,122,'LBL_DESCRIPTION',3,0,0,0,0,0,2,0,NULL),
			(419,122,'LBL_COMMENTS',4,0,0,0,0,0,2,0,NULL),
			(420,123,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(421,123,'LBL_CUSTOM_INFORMATION',5,0,0,0,0,0,2,0,NULL),
			(422,123,'LBL_ADDRESS',2,0,0,0,0,0,2,0,NULL),
			(423,123,'LBL_DESCRIPTION',3,0,0,0,0,0,2,0,NULL),
			(424,123,'LBL_COMMENTS',4,0,0,0,0,0,2,0,NULL),
			(425,124,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(426,124,'LBL_CUSTOM_INFORMATION',7,0,0,0,0,0,2,0,NULL),
			(427,124,'LBL_BREACH_CIRCUMSTANCES',3,0,0,0,0,0,2,0,NULL),
			(428,124,'LBL_NATURE_OF_BREACH',4,0,0,0,0,0,2,0,NULL),
			(429,124,'LBL_POSSIBLE_CONSEQUENCES',5,0,0,0,0,0,2,0,NULL),
			(430,124,'LBL_SECURITY_MEASURES',6,0,0,0,0,0,2,0,NULL),
			(431,124,'LBL_INCIDENT_DATES',2,0,0,0,0,0,2,0,NULL),
			(432,125,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,2,0,NULL),
			(433,125,'LBL_CUSTOM_INFORMATION',4,0,0,0,0,0,2,0,NULL),
			(434,125,'LBL_DESCRIPTION',2,0,0,0,0,0,2,0,NULL),
			(435,125,'LBL_COMMENTS',3,0,0,0,0,0,2,0,NULL),
			(436,107,'LBL_COMMENTS',4,0,0,0,0,0,2,0,NULL),
			(437,29,'LBL_GLOBAL_SEARCH_SETTINGS',11,0,0,0,0,0,2,0,'fas fa-search'),
			(438,96,'LBL_CUSTOM_INFORMATION',3,0,0,0,0,0,2,0,NULL),
			(439,6,'LBL_FOR_THE_PORTAL',11,0,0,0,0,0,2,0,NULL),
			(442,15,'LBL_ARTICLE',2,0,0,0,0,0,2,0,NULL),
			(443,111,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,1,0,NULL),
			(444,13,'BL_RECORD_STATUS_TIMES',6,0,0,0,0,0,1,0,'fas fa-business-time'),
			(445,34,'LBL_DESCRIPTION_INFORMATION',4,0,0,0,0,0,1,0,NULL),
			(446,127,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,1,0,NULL),
			(447,127,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,1,0,NULL),
			(448,127,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,1,0,NULL),
			(449,128,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,1,0,NULL),
			(450,128,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,1,0,NULL),
			(451,128,'LBL_DESCRIPTION_INFORMATION',3,0,0,0,0,0,1,0,NULL),
			(452,29,'LBL_USER_MAIL',8,0,0,0,0,0,2,0,'fas fa-mail-bulk'),
			(453,29,'LBL_USER_INTEGRATION',10,0,0,0,0,0,2,0,'fas fa-sync-alt'),
			(454,29,'LBL_USER_GUI',6,0,0,0,0,0,2,0,'fas fa-layer-group'),
			(455,29,'LBL_USER_AUTOMATION',12,0,0,0,0,0,2,0,'fas fa-fan'),
			(456,130,'LBL_LOCATIONS_INFORMATION',1,0,0,0,0,0,1,0,NULL),
			(457,130,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,1,0,NULL),
			(458,130,'LBL_ADDRESS_INFORMATION',3,0,0,0,0,0,1,0,NULL),
			(459,130,'LBL_DESCRIPTION_INFORMATION',4,0,0,0,0,0,1,0,NULL),
			(460,131,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,1,0,NULL),
			(461,131,'LBL_DESCRIPTION_INFORMATION',2,0,0,0,0,0,1,0,NULL),
			(462,131,'LBL_CUSTOM_INFORMATION',3,0,0,0,0,0,0,0,NULL),
			(463,90,'LBL_ADDRESS_SHIPPING',7,0,0,0,0,0,2,0,NULL),
			(464,132,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,1,0,NULL),
			(465,132,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,1,0,NULL),
			(466,95,'LBL_ADDRESS_SHIPPING',4,0,0,0,0,0,2,0,NULL),
			(467,99,'LBL_ADDRESS_SHIPPING',4,0,0,0,0,0,2,0,NULL),
			(468,29,'LBL_USER_CONTACT_INFORMATION',2,0,0,0,0,0,2,0,'fas fa-address-book'),
			(469,29,'LBL_USER_CONFIGURATION_WORKING_TIME',5,0,0,0,0,0,2,0,'yfm-OSSTimeControl'),
			(470,133,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,1,0,NULL),
			(471,133,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,1,0,NULL),
			(472,134,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,1,0,NULL),
			(473,134,'LBL_DESCRIPTION_INFORMATION',2,0,0,0,0,0,1,1,NULL),
			(474,134,'LBL_CUSTOM_INFORMATION',3,0,0,0,0,0,1,0,NULL),
			(475,135,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,1,0,NULL),
			(476,135,'LBL_DESCRIPTION_INFORMATION',2,0,0,0,0,0,0,0,NULL),
			(477,135,'LBL_CUSTOM_INFORMATION',3,0,0,0,0,0,1,0,NULL),
			(478,136,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,1,0,NULL),
			(479,136,'BL_SMS_CONTENT',2,0,0,0,0,0,1,0,NULL),
			(480,136,'LBL_CUSTOM_INFORMATION',3,0,0,0,0,0,1,0,NULL),
			(481,45,'BL_SMS_CONTENT',2,0,0,0,0,0,1,0,NULL),
			(485,138,'LBL_BASIC_INFORMATION',1,0,0,0,0,0,1,0,NULL),
			(486,138,'LBL_CUSTOM_INFORMATION',2,0,0,0,0,0,1,0,NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_calendar_config`(`type`,`name`,`label`,`value`) values
			('reminder','update_event','LBL_UPDATE_EVENT','0'),
			('info','notworkingdays','LBL_NOTWORKING_DAYS',NULL),
			('reminder','shared_persons','LBL_RM_SHARING_ON',NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_callhistorytype`(`callhistorytypeid`,`callhistorytype`,`sortorderid`,`presence`,`color`) values
			(1,'Outgoing missed',1,1,'FFF176'),
			(2,'Outgoing received',2,1,'81C784'),
			(3,'Incoming',3,1,'4DD0E1'),
			(4,'Missed',4,1,'F44336'),
			(5,'Voicemail',5,1,'90A4AE');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_campaignstatus`(`campaignstatusid`,`campaignstatus`,`presence`,`picklist_valueid`,`sortorderid`) values
			(2,'Planning',1,15,1),
			(3,'Active',1,16,2),
			(4,'Inactive',1,17,3),
			(5,'Completed',1,18,4),
			(6,'Cancelled',1,19,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_campaigntype`(`campaigntypeid`,`campaigntype`,`presence`,`picklist_valueid`,`sortorderid`) values
			(2,'Conference',1,21,1),
			(3,'Webinar',1,22,2),
			(4,'Trade Show',1,23,3),
			(5,'Public Relations',1,24,4),
			(6,'Partners',1,25,5),
			(7,'Referral Program',1,26,6),
			(8,'Advertisement',1,27,7),
			(9,'Banner Ads',1,28,8),
			(10,'Direct Mail',1,29,9),
			(11,'Email',1,30,10),
			(12,'Telemarketing',1,31,11),
			(13,'Others',1,32,12);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_cmileage_logbook_status`(`cmileage_logbook_statusid`,`cmileage_logbook_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_DRAFT',1,760,1),
			(2,'PLL_FOR_APPROVAL',1,761,2),
			(3,'PLL_ACCEPTED',1,762,3),
			(4,'PLL_CANCELLED',1,763,4);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_contactstatus`(`contactstatusid`,`contactstatus`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Active',1,559,1),
			(2,'Inactive',1,560,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_contract_priority`(`contract_priorityid`,`contract_priority`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Low',1,220,1),
			(2,'Normal',1,221,2),
			(3,'High',1,222,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_contract_status`(`contract_statusid`,`contract_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Undefined',1,214,1),
			(2,'In Planning',1,215,2),
			(3,'In Progress',0,216,3),
			(4,'On Hold',1,217,4),
			(5,'Complete',0,218,5),
			(6,'Archived',1,219,6);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_contract_type`(`contract_typeid`,`contract_type`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Support',1,223,1),
			(2,'Services',1,224,2),
			(3,'Administrative',1,225,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_convertleadmapping`(`cfmid`,`leadfid`,`accountfid`,`editable`) values
			(1,43,1,0),
			(2,49,14,1),
			(3,40,3,1),
			(5,44,5,1),
			(7,46,9,0),
			(8,48,4,1),
			(21,65,36,1),
			(24,41,0,0),
			(25,42,0,1),
			(28,47,0,1),
			(30,53,10,1),
			(31,51,17,1),
			(32,1291,1285,1),
			(33,1292,1286,1),
			(34,1065,1089,1),
			(35,1066,1091,1),
			(36,1067,1093,1),
			(37,1068,1095,1),
			(38,1069,1097,1),
			(39,1070,1099,1),
			(40,1071,1101,1),
			(41,1072,1103,1),
			(42,967,970,1),
			(43,969,972,1),
			(44,1737,1738,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_crmentity`(`crmid`,`smcreatorid`,`smownerid`,`shownerid`,`modifiedby`,`setype`,`description`,`attention`,`createdtime`,`modifiedtime`,`viewedtime`,`status`,`version`,`presence`,`deleted`,`was_read`,`private`,`users`) values
			(1,1,1,NULL,1,'MultiCompany',NULL,NULL,'2018-11-30 10:05:50','2018-11-30 10:05:50',NULL,NULL,0,1,0,0,0,',1,'),
			(2,1,1,NULL,1,'OSSEmployees',NULL,NULL,'2018-12-11 11:54:23','2018-12-11 11:54:23',NULL,NULL,0,1,0,0,0,',1,'),
			(37,1,1,0,1,'EmailTemplates',NULL,NULL,'2014-09-22 23:53:15','2017-01-11 10:28:40',NULL,NULL,0,1,0,NULL,0,NULL),
			(39,1,1,0,1,'EmailTemplates',NULL,NULL,'2014-09-22 23:57:26','2017-01-11 10:59:31','2015-10-23 08:33:00',NULL,0,1,0,0,0,NULL),
			(41,1,1,0,1,'EmailTemplates',NULL,NULL,'2014-09-23 00:05:38','2017-01-11 10:59:37',NULL,NULL,0,1,0,NULL,0,NULL),
			(43,1,1,0,1,'EmailTemplates',NULL,NULL,'2014-09-23 00:07:37','2017-01-11 11:15:12',NULL,NULL,0,1,0,NULL,0,NULL),
			(44,1,1,0,1,'EmailTemplates',NULL,NULL,'2014-09-23 21:39:36','2017-01-11 11:18:45',NULL,NULL,0,1,0,NULL,0,NULL),
			(45,1,1,0,1,'EmailTemplates',NULL,NULL,'2014-09-23 22:57:01','2017-01-11 11:46:19',NULL,NULL,0,1,0,NULL,0,NULL),
			(46,1,1,0,1,'EmailTemplates',NULL,NULL,'2014-09-23 23:04:19','2017-01-11 12:12:54',NULL,NULL,0,1,0,NULL,0,NULL),
			(93,1,1,0,1,'EmailTemplates',NULL,NULL,'2014-09-24 20:51:12','2017-01-11 12:16:56',NULL,NULL,0,1,0,NULL,0,NULL),
			(95,1,1,0,1,'EmailTemplates',NULL,NULL,'2014-09-24 21:58:51','2017-01-11 12:44:36',NULL,NULL,0,1,0,NULL,0,NULL),
			(103,1,1,0,1,'EmailTemplates',NULL,NULL,'2015-01-24 11:33:24','2017-01-11 12:50:01','2015-02-12 08:37:31',NULL,0,1,0,NULL,0,NULL),
			(104,1,1,0,1,'EmailTemplates',NULL,NULL,'2015-02-12 09:08:42','2017-01-11 12:53:07','2015-02-12 09:26:03',NULL,0,1,0,0,0,NULL),
			(105,1,1,0,1,'EmailTemplates',NULL,NULL,'2015-02-17 10:11:08','2017-01-11 13:02:35','2015-10-23 08:35:22',NULL,0,1,0,0,0,NULL),
			(106,1,1,0,1,'EmailTemplates',NULL,NULL,'2015-02-18 08:35:26','2017-01-11 13:06:50','2015-10-23 08:34:38',NULL,0,1,0,0,0,NULL),
			(107,1,1,0,1,'EmailTemplates',NULL,NULL,'2015-02-26 09:59:53','2017-01-11 13:09:22','2015-02-26 09:59:53',NULL,0,1,0,0,0,NULL),
			(109,1,1,0,1,'EmailTemplates',NULL,NULL,'2015-10-23 08:16:58','2017-01-11 13:25:18','2015-10-23 08:34:54',NULL,0,1,0,0,0,NULL),
			(110,1,1,NULL,1,'EmailTemplates',NULL,NULL,'2016-05-24 12:40:24','2017-01-11 13:35:37','2016-05-24 12:40:24',NULL,0,1,0,0,0,NULL),
			(112,1,1,NULL,1,'EmailTemplates',NULL,NULL,'2017-06-07 00:42:02','2017-06-07 00:42:02',NULL,NULL,0,1,0,0,0,',1,'),
			(113,1,1,NULL,1,'EmailTemplates',NULL,NULL,'2018-07-23 12:11:25','2018-07-23 12:11:25',NULL,NULL,0,1,0,0,0,',1,'),
			(114,1,1,NULL,1,'EmailTemplates',NULL,NULL,'2019-01-14 15:00:23','2019-01-14 15:00:23',NULL,NULL,0,1,0,0,0,',1,'),
			(115,1,1,NULL,1,'EmailTemplates',NULL,NULL,'2020-08-14 14:22:33','2020-08-14 14:22:33',NULL,NULL,0,1,0,0,0,',1,'),
			(116,1,1,NULL,1,'EmailTemplates',NULL,NULL,'2020-08-14 14:22:46','2020-08-14 14:22:46',NULL,NULL,0,1,0,0,0,',1,');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_cron_task`(`id`,`status`,`name`,`handler_class`,`frequency`,`laststart`,`last_update`,`lastend`,`sequence`,`max_exe_time`,`module`,`description`,`lase_error`) values
			(1,1,'LBL_WORKFLOW','Vtiger_Workflow_Cron',900,NULL,NULL,NULL,1,NULL,'com_vtiger_workflow','Recommended frequency for Workflow is 5 mins',NULL),
			(2,1,'LBL_ADDRESS_BOOK','Vtiger_AddressBook_Cron',86400,NULL,NULL,NULL,20,NULL,'Vtiger','',NULL),
			(3,1,'LBL_SEND_REMINDER','Calendar_SendReminder_Cron',900,NULL,NULL,NULL,10,NULL,'Calendar','Recommended frequency for SendReminder is 15 mins',NULL),
			(4,1,'LBL_CURRENCY_UPDATE','Settings_CurrencyUpdate_CurrencyUpdate_Cron',86400,NULL,NULL,NULL,34,NULL,'CurrencyUpdate','Recommended frequency for Currency Update is 24 hours',NULL),
			(5,1,'LBL_MAILER','Vtiger_Mailer_Cron',300,NULL,NULL,NULL,6,NULL,'Vtiger',NULL,NULL),
			(7,1,'LBL_BROWSING_HISTORY','Vtiger_BrowsingHistory_Cron',86400,NULL,NULL,NULL,26,NULL,'Vtiger',NULL,NULL),
			(8,1,'LBL_SCHEDULED_IMPORT','Import_ScheduledImport_Cron',900,NULL,NULL,NULL,2,NULL,'Import','',NULL),
			(10,1,'LBL_MAIL_SCANNER_ACTION','OSSMailScanner_Scann_Cron',200,NULL,NULL,NULL,3,NULL,'OSSMailScanner','Recommended frequency for MailScanner is 5 mins',NULL),
			(11,1,'LBL_MAIL_SCANNER_VERIFICATION','OSSMailScanner_Verification_Cron',43200,NULL,NULL,NULL,4,NULL,'OSSMailScanner','',NULL),
			(12,1,'LBL_MAIL_SCANNER_BIND','OSSMailScanner_Bind_Cron',3600,NULL,NULL,NULL,5,NULL,'OSSMailScanner','',NULL),
			(13,1,'LBL_BATCH_PROCESSES','Vtiger_BatchProcesses_Cron',600,NULL,NULL,NULL,28,NULL,'Vtiger',NULL,NULL),
			(14,1,'LBL_CARD_DAV','Contacts_CardDav_Cron',300,NULL,NULL,NULL,7,NULL,'Contacts',NULL,NULL),
			(15,1,'LBL_CAL_DAV','Calendar_CalDav_Cron',300,NULL,NULL,NULL,8,NULL,'Calendar',NULL,NULL),
			(16,1,'LBL_ACTIVITY_STATE','Calendar_ActivityState_Cron',1800,NULL,NULL,NULL,9,NULL,'Calendar','',NULL),
			(17,1,'LBL_MULTI_REFERENCE_VALUE','Vtiger_MultiReference_Cron',900,NULL,NULL,NULL,12,NULL,'com_vtiger_workflow',NULL,NULL),
			(18,1,'LBL_CRMACTIVITY_DAYS','Calendar_SetCrmActivity_Cron',86400,NULL,NULL,NULL,13,5,'Calendar','',NULL),
			(19,1,'LBL_ASSETS_RENEWAL','Assets_Renewal_Cron',86400,NULL,NULL,NULL,14,NULL,'Assets','',NULL),
			(20,1,'LBL_SOLD_SERVICES_RENEWAL','OSSSoldServices_Renewal_Cron',86400,NULL,NULL,NULL,15,NULL,'OSSSoldServices','',NULL),
			(21,1,'LBL_SEND_NOTIFICATIONS','Notification_Notifications_Cron',900,NULL,NULL,NULL,11,NULL,'Notification','',NULL),
			(22,1,'LBL_RECORD_LABEL_UPDATER','Vtiger_LabelUpdater_Cron',900,NULL,NULL,NULL,16,NULL,'Vtiger','',NULL),
			(23,1,'LBL_PRIVILEGES_UPDATER','Vtiger_PrivilegesUpdater_Cron',900,NULL,NULL,NULL,17,NULL,'Vtiger','',NULL),
			(24,1,'LBL_UPDATER_COORDINATES','OpenStreetMap_UpdaterCoordinates_Cron',60,NULL,NULL,NULL,18,NULL,'OpenStreetMap','',NULL),
			(25,1,'LBL_UPDATER_RECORDS_COORDINATES','OpenStreetMap_UpdaterRecordsCoordinates_Cron',300,NULL,NULL,NULL,19,NULL,'OpenStreetMap','',NULL),
			(26,1,'LBL_MARK_RECORDS_AS_REVIEWED','ModTracker_ReviewChanges_Cron',900,NULL,NULL,NULL,21,NULL,'ModTracker','',NULL),
			(27,1,'LBL_CACHE','Vtiger_Cache_Cron',86400,NULL,NULL,NULL,22,NULL,'Vtiger',NULL,NULL),
			(28,1,'LBL_NEVER_ENDING_RECURRING_EVENTS','Calendar_RecurringEvents_Cron',86400,NULL,NULL,NULL,23,NULL,'Calendar',NULL,NULL),
			(29,1,'LBL_CLEAR_FILE_UPLOAD_TEMP','Vtiger_FileUploadTemp_Cron',86400,NULL,NULL,NULL,24,NULL,'Vtiger',NULL,NULL),
			(30,1,'LBL_SMSNOTIFIER','SMSNotifier_SMSNotifier_Cron',300,NULL,NULL,NULL,25,NULL,'SMSNotifier',NULL,NULL),
			(31,1,'LBK_SYSTEM_WARNINGS','Vtiger_SystemWarnings_Cron',86400,NULL,NULL,NULL,27,NULL,'Vtiger',NULL,NULL),
			(32,1,'LBL_BATCH_METHODS','Vtiger_BatchMethods_Cron',60,NULL,NULL,NULL,30,NULL,'Vtiger',NULL,NULL),
			(33,1,'LBL_SESSION_CLEANER','Vtiger_SessionCleaner_Cron',60,NULL,NULL,NULL,31,NULL,'Vtiger','',NULL),
			(37,1,'LBL_MAIL_RBL','Vtiger_MailRbl_Cron',7200,NULL,NULL,NULL,35,NULL,'Vtiger',NULL,NULL),
			(38,0,'LBL_INTEGRATION_PL_GUS_REGON','Vtiger_IntegrationPLGusRegon_Cron',43200,NULL,NULL,NULL,29,NULL,'Vtiger',NULL,NULL),
			(40,1,'LBL_MAIL_SCANNER_NOTIFICATION','OSSMailScanner_Notifications_Cron',28800,NULL,NULL,NULL,36,NULL,'OSSMailScanner','',NULL),
			(41,0,'LBL_WOOCOMMERCE','Vtiger_WooCommerce_Cron',300,NULL,NULL,NULL,37,NULL,NULL,NULL,NULL),
			(42,0,'LBL_COMARCH','Vtiger_Comarch_Cron',300,NULL,NULL,NULL,38,NULL,NULL,NULL,NULL),
			(43,0,'LBL_DISPOSAL_LOGS_DATA','Vtiger_DisposalLogsData_Cron',86400,NULL,NULL,NULL,39,NULL,NULL,NULL,NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_currencies`(`currencyid`,`currency_name`,`currency_code`,`currency_symbol`) values
			(1,'Albania, Leke','ALL','Lek'),
			(2,'Argentina, Pesos','ARS','$'),
			(3,'Aruba, Guilders','AWG','ƒ'),
			(4,'Australia, Dollars','AUD','$'),
			(5,'Azerbaijan, New Manats','AZN','ман'),
			(6,'Bahamas, Dollars','BSD','$'),
			(7,'Bahrain, Dinar','BHD','BD'),
			(8,'Barbados, Dollars','BBD','$'),
			(9,'Belarus, Rubles','BYR','p.'),
			(10,'Belize, Dollars','BZD','BZ$'),
			(11,'Bermuda, Dollars','BMD','$'),
			(12,'Bolivia, Bolivianos','BOB','$b'),
			(13,'China, Yuan Renminbi','CNY','¥'),
			(14,'Convertible Marka','BAM','KM'),
			(15,'Botswana, Pulas','BWP','P'),
			(16,'Bulgaria, Leva','BGN','лв'),
			(17,'Brazil, Reais','BRL','R$'),
			(18,'Great Britain Pounds','GBP','£'),
			(19,'Brunei Darussalam, Dollars','BND','$'),
			(20,'Canada, Dollars','CAD','$'),
			(21,'Cayman Islands, Dollars','KYD','$'),
			(22,'Chile, Pesos','CLP','$'),
			(23,'Colombia, Pesos','COP','$'),
			(24,'Costa Rica, Colón','CRC','₡'),
			(25,'Croatia, Kuna','HRK','kn'),
			(26,'Cuba, Pesos','CUP','₱'),
			(27,'Czech Republic, Koruny','CZK','Kč'),
			(28,'Cyprus, Pounds','CYP','£'),
			(29,'Denmark, Kroner','DKK','kr'),
			(30,'Dominican Republic, Pesos','DOP','RD$'),
			(31,'East Caribbean, Dollars','XCD','$'),
			(32,'Egypt, Pounds','EGP','£'),
			(33,'El Salvador, Colón','SVC','₡'),
			(34,'England, Pounds','GBP','£'),
			(35,'Estonia, Krooni','EEK','kr'),
			(36,'Euro','EUR','€'),
			(37,'Falkland Islands, Pounds','FKP','£'),
			(38,'Fiji, Dollars','FJD','$'),
			(39,'Ghana, Cedis','GHC','¢'),
			(40,'Gibraltar, Pounds','GIP','£'),
			(41,'Guatemala, Quetzales','GTQ','Q'),
			(42,'Guernsey, Pounds','GGP','£'),
			(43,'Guyana, Dollars','GYD','$'),
			(44,'Honduras, Lempiras','HNL','L'),
			(45,'Hong Kong, Dollars','HKD','HK$'),
			(46,'Hungary, Forint','HUF','Ft'),
			(47,'Iceland, Krona','ISK','kr'),
			(48,'India, Rupees','INR','₹'),
			(49,'Indonesia, Rupiahs','IDR','Rp'),
			(50,'Iran, Rials','IRR','﷼'),
			(51,'Isle of Man, Pounds','IMP','£'),
			(52,'Israel, New Shekels','ILS','₪'),
			(53,'Jamaica, Dollars','JMD','J$'),
			(54,'Japan, Yen','JPY','¥'),
			(55,'Jersey, Pounds','JEP','£'),
			(56,'Jordan, Dinar','JOD','JOD'),
			(57,'Kazakhstan, Tenge','KZT','〒'),
			(58,'Kenya, Shilling','KES','KES'),
			(59,'Korea (North), Won','KPW','₩'),
			(60,'Korea (South), Won','KRW','₩'),
			(61,'Kuwait, Dinar','KWD','KWD'),
			(62,'Kyrgyzstan, Soms','KGS','лв'),
			(63,'Laos, Kips','LAK','₭'),
			(64,'Latvia, Lati','LVL','Ls'),
			(65,'Lebanon, Pounds','LBP','£'),
			(66,'Liberia, Dollars','LRD','$'),
			(67,'Switzerland Francs','CHF','CHF'),
			(68,'Lithuania, Litai','LTL','Lt'),
			(69,'MADAGASCAR, Malagasy Ariary','MGA','MGA'),
			(70,'Macedonia, Denars','MKD','ден'),
			(71,'Malaysia, Ringgits','MYR','RM'),
			(72,'Malta, Liri','MTL','₤'),
			(73,'Mauritius, Rupees','MUR','₨'),
			(74,'Mexico, Pesos','MXN','$'),
			(75,'Mongolia, Tugriks','MNT','₮'),
			(76,'Mozambique, Meticais','MZN','MT'),
			(77,'Namibia, Dollars','NAD','$'),
			(78,'Nepal, Rupees','NPR','₨'),
			(79,'Netherlands Antilles, Guilders','ANG','ƒ'),
			(80,'New Zealand, Dollars','NZD','$'),
			(81,'Nicaragua, Cordobas','NIO','C$'),
			(82,'Nigeria, Nairas','NGN','₦'),
			(83,'North Korea, Won','KPW','₩'),
			(84,'Norway, Krone','NOK','kr'),
			(85,'Oman, Rials','OMR','﷼'),
			(86,'Pakistan, Rupees','PKR','₨'),
			(87,'Panama, Balboa','PAB','B/.'),
			(88,'Paraguay, Guarani','PYG','Gs'),
			(89,'Peru, Nuevos Soles','PEN','S/.'),
			(90,'Philippines, Pesos','PHP','Php'),
			(91,'Poland, Zlotych','PLN','zł'),
			(92,'Qatar, Rials','QAR','﷼'),
			(93,'Romania, New Lei','RON','lei'),
			(94,'Russia, Rubles','RUB','₽'),
			(95,'Saint Helena, Pounds','SHP','£'),
			(96,'Saudi Arabia, Riyals','SAR','﷼'),
			(97,'Serbia, Dinars','RSD','Дин.'),
			(98,'Seychelles, Rupees','SCR','₨'),
			(99,'Singapore, Dollars','SGD','$'),
			(100,'Solomon Islands, Dollars','SBD','$'),
			(101,'Somalia, Shillings','SOS','S'),
			(102,'South Africa, Rand','ZAR','R'),
			(103,'South Korea, Won','KRW','₩'),
			(104,'Sri Lanka, Rupees','LKR','₨'),
			(105,'Sweden, Kronor','SEK','kr'),
			(106,'Switzerland, Francs','CHF','CHF'),
			(107,'Suriname, Dollars','SRD','$'),
			(108,'Syria, Pounds','SYP','£'),
			(109,'Taiwan, New Dollars','TWD','NT$'),
			(110,'Thailand, Baht','THB','฿'),
			(111,'Trinidad and Tobago, Dollars','TTD','TT$'),
			(112,'Turkey, New Lira','TRY','YTL'),
			(113,'Turkey, Liras','TRL','₤'),
			(114,'Tuvalu, Dollars','TVD','$'),
			(115,'Ukraine, Hryvnia','UAH','₴'),
			(116,'United Arab Emirates, Dirham','AED','AED'),
			(117,'United Kingdom, Pounds','GBP','£'),
			(118,'United Republic of Tanzania, Shilling','TZS','TZS'),
			(119,'USA, Dollars','USD','$'),
			(120,'Uruguay, Pesos','UYU','$U'),
			(121,'Uzbekistan, Sums','UZS','лв'),
			(122,'Venezuela, Bolivares Fuertes','VEF','Bs'),
			(123,'Vietnam, Dong','VND','₫'),
			(124,'Zambia, Kwacha','ZMK','ZMK'),
			(125,'Yemen, Rials','YER','﷼'),
			(126,'Zimbabwe Dollars','ZWD','Z$'),
			(127,'Malawi, Kwacha','MWK','MK'),
			(128,'Tunisian, Dinar','TD','TD'),
			(129,'Moroccan, Dirham','MAD','DH'),
			(130,'Iraqi Dinar','IQD','ID'),
			(131,'Maldivian Ruffiya','MVR','MVR'),
			(132,'Ugandan Shilling','UGX','Sh'),
			(133,'Sudanese Pound','SDG','£'),
			(134,'CFA Franc BCEAO','XOF','CFA'),
			(135,'CFA Franc BEAC','XAF','CFA'),
			(136,'Haiti, Gourde','HTG','G'),
			(137,'Libya, Dinar','LYD','LYD'),
			(138,'CFP Franc','XPF','F'),
			(139,'South Sudanese pound','SSP','SS£'),
			(140,'Afghani','AFN','Af'),
			(141,'Armenian Dram','AMD','Դ'),
			(142,'Kwanza','AOA','Kz'),
			(143,'Taka','BDT','৳'),
			(144,'Burundi Franc','BIF','₣'),
			(145,'Boliviano Mvdol','BOV','$b'),
			(146,'Ngultrum','BTN','Nu'),
			(147,'Belarussian Ruble','BYN','p.'),
			(148,'Congolese Franc','CDF','FC'),
			(149,'Unidad de Fomento','CLF','$'),
			(150,'Unidad de Valor Real','COU','$'),
			(151,'Peso Convertible','CUC','CUC$'),
			(152,'Cabo Verde Escudo','CVE','$'),
			(153,'Djibouti Franc','DJF','Fdj'),
			(154,'Algerian Dinar','DZD','دج'),
			(155,'Nakfa','ERN','Nkf'),
			(156,'Ethiopian Birr','ETB','Br'),
			(157,'Lari','GEL','₾'),
			(158,'Dalasi','GMD','D'),
			(159,'Guinean Franc','GNF','FG'),
			(160,'Riel','KHR','៛'),
			(161,'Comorian Franc','KMF','CF'),
			(162,'Loti','LSL','L'),
			(163,'Moldovan Leu','MDL','L'),
			(164,'Kyat','MMK','K'),
			(165,'Pataca','MOP','	MOP$'),
			(166,'Ouguiya','MRU','UM'),
			(167,'Kina','PGK','K'),
			(168,'Rwanda Franc','RWF','R₣'),
			(169,'Leone','SLL','Le'),
			(170,'Dobra','STN','Db'),
			(171,'Lilangeni','SZL','L'),
			(172,'Somoni','TJS','SM'),
			(173,'Turkmenistan New Manat','TMT','m'),
			(174,'Tunisian Dinar','TND','د.ت'),
			(175,'Pa’anga','TOP','T$'),
			(176,'Bolívar Soberano','VES','Bs. S.'),
			(177,'Vatu','VUV','VT'),
			(178,'Tala','WST','WS$'),
			(179,'Zambian Kwacha','ZMW','ZK');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_currency_decimal_separator`(`currency_decimal_separatorid`,`currency_decimal_separator`,`sortorderid`,`presence`) values
			(1,'.',0,1),
			(2,',',1,1),
			(3,'\'',2,1),
			(4,' ',3,1),
			(5,'$',4,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_currency_grouping_pattern`(`currency_grouping_patternid`,`currency_grouping_pattern`,`sortorderid`,`presence`) values
			(1,'123,456,789',0,1),
			(2,'123456789',1,1),
			(3,'123456,789',2,1),
			(4,'12,34,56,789',3,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_currency_grouping_separator`(`currency_grouping_separatorid`,`currency_grouping_separator`,`sortorderid`,`presence`) values
			(1,'.',2,1),
			(2,',',3,1),
			(3,'\'',4,1),
			(4,' ',1,1),
			(5,'$',5,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_currency_info`(`id`,`currency_name`,`currency_code`,`currency_symbol`,`conversion_rate`,`currency_status`,`defaultid`,`deleted`) values
			(1,'Poland, Zlotych','PLN','zł',1.000000000,'Active',-11,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_currency_symbol_placement`(`currency_symbol_placementid`,`currency_symbol_placement`,`sortorderid`,`presence`) values
			(1,'$1.0',0,1),
			(2,'1.0$',1,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_customview`(`cvid`,`viewname`,`setdefault`,`setmetrics`,`entitytype`,`status`,`userid`,`privileges`,`featured`,`sequence`,`presence`,`description`,`sort`,`color`,`advanced_conditions`) values
			(1,'All',1,0,'Leads',0,1,0,0,NULL,0,NULL,'','',NULL),
			(4,'All',1,0,'Accounts',0,1,0,0,NULL,0,NULL,'','',NULL),
			(7,'All',1,0,'Contacts',0,1,0,0,NULL,0,NULL,'','',NULL),
			(13,'All',1,0,'HelpDesk',0,1,0,0,NULL,0,NULL,'','',NULL),
			(19,'All',1,0,'Calendar',0,1,0,0,NULL,0,NULL,'','',NULL),
			(22,'All',1,0,'Documents',0,1,0,0,NULL,0,NULL,'','',NULL),
			(23,'All',1,0,'PriceBooks',0,1,0,0,NULL,0,NULL,'','',NULL),
			(24,'All',1,0,'Products',0,1,0,0,NULL,0,NULL,'','',NULL),
			(27,'All',1,0,'Vendors',0,1,0,0,NULL,0,NULL,'','',NULL),
			(28,'All',1,0,'Faq',0,1,0,0,NULL,0,'','','',NULL),
			(29,'All',1,0,'Campaigns',0,1,0,0,NULL,0,NULL,'','',NULL),
			(39,'All',1,0,'ServiceContracts',0,1,0,0,NULL,0,NULL,'','',NULL),
			(40,'All',1,0,'Services',0,1,0,0,NULL,0,NULL,'','',NULL),
			(41,'All',1,0,'Assets',0,1,0,0,NULL,0,NULL,'','',NULL),
			(42,'All',0,0,'ModComments',0,1,0,0,NULL,0,NULL,'','',NULL),
			(43,'All',1,0,'ProjectMilestone',0,1,0,0,NULL,0,NULL,'','',NULL),
			(44,'All',1,0,'ProjectTask',0,1,0,0,NULL,0,NULL,'','',NULL),
			(45,'All',1,0,'Project',0,1,0,0,NULL,0,NULL,'','',NULL),
			(46,'All',0,0,'SMSNotifier',0,1,0,0,NULL,0,NULL,'','',NULL),
			(49,'All',1,0,'OSSTimeControl',0,1,0,0,NULL,0,NULL,'','',NULL),
			(50,'All',1,0,'OSSMailView',0,1,0,0,NULL,0,NULL,'','',NULL),
			(52,'All',1,0,'OSSOutsourcedServices',0,1,0,0,NULL,0,NULL,'','',NULL),
			(53,'All',1,0,'OSSSoldServices',0,1,0,0,NULL,0,NULL,'','',NULL),
			(54,'All',1,0,'OutsourcedProducts',0,1,0,0,NULL,0,NULL,'','',NULL),
			(56,'All',1,0,'OSSEmployees',0,1,0,0,NULL,0,'','','',NULL),
			(68,'All',1,0,'CallHistory',0,1,1,0,NULL,0,NULL,'','',NULL),
			(69,'All',1,0,'Ideas',0,1,1,0,NULL,0,NULL,'','',NULL),
			(72,'All',1,0,'HolidaysEntitlement',0,1,1,0,NULL,0,NULL,'','',NULL),
			(73,'All',1,0,'PaymentsIn',0,1,1,0,NULL,0,NULL,'','',NULL),
			(74,'All',1,0,'PaymentsOut',0,1,1,0,NULL,0,NULL,'','',NULL),
			(75,'All',1,0,'LettersIn',0,1,1,0,NULL,0,NULL,'','',NULL),
			(76,'All',1,0,'LettersOut',0,1,1,0,NULL,0,NULL,'','',NULL),
			(77,'All',1,0,'Announcements',0,1,1,0,NULL,0,NULL,'','',NULL),
			(78,'All',1,0,'Reservations',0,1,1,0,NULL,0,NULL,'','',NULL),
			(79,'All',1,0,'SQuoteEnquiries',0,1,1,0,NULL,0,NULL,'','',NULL),
			(80,'All',1,0,'SSalesProcesses',0,1,1,0,NULL,0,NULL,'','',NULL),
			(81,'All',1,0,'SRequirementsCards',0,1,1,0,NULL,0,NULL,'','',NULL),
			(82,'All',1,0,'SCalculations',0,1,1,0,NULL,0,NULL,'','',NULL),
			(83,'All',1,0,'SQuotes',0,1,1,0,NULL,0,NULL,'','',NULL),
			(84,'All',1,0,'SSingleOrders',0,1,1,0,NULL,0,NULL,'','',NULL),
			(85,'All',1,0,'SRecurringOrders',0,1,1,0,NULL,0,NULL,'','',NULL),
			(86,'All',1,0,'Partners',0,1,1,0,NULL,0,NULL,'','',NULL),
			(87,'All',1,0,'Competition',0,1,1,0,NULL,0,NULL,'','',NULL),
			(88,'All',1,0,'FBookkeeping',0,1,1,0,NULL,0,NULL,'','',NULL),
			(89,'All',1,0,'FInvoice',0,1,1,0,NULL,0,NULL,'','',NULL),
			(90,'All',1,0,'KnowledgeBase',0,1,1,0,NULL,0,'','','',NULL),
			(91,'All',1,0,'IStorages',0,1,1,0,NULL,0,NULL,'','',NULL),
			(92,'All',1,0,'IGRN',0,1,1,0,NULL,0,NULL,'','',NULL),
			(93,'All',1,0,'FInvoiceProforma',0,1,1,0,NULL,0,NULL,'','',NULL),
			(94,'All',1,0,'IGDN',0,1,1,0,NULL,0,NULL,'','',NULL),
			(95,'All',1,0,'IIDN',0,1,1,0,NULL,0,NULL,'','',NULL),
			(96,'All',1,0,'IGIN',0,1,1,0,NULL,0,NULL,'','',NULL),
			(97,'All',1,0,'IPreOrder',0,1,1,0,NULL,0,NULL,'','',NULL),
			(98,'All',1,0,'ISTDN',0,1,1,0,NULL,0,NULL,'','',NULL),
			(99,'All',1,0,'ISTN',0,1,1,0,NULL,0,NULL,'','',NULL),
			(100,'All',1,0,'ISTRN',0,1,1,0,NULL,0,NULL,'','',NULL),
			(101,'All',1,0,'FCorectingInvoice',0,1,1,0,NULL,0,NULL,'','',NULL),
			(102,'All',1,0,'IGRNC',0,1,1,0,NULL,0,NULL,'','',NULL),
			(103,'All',1,0,'IGDNC',0,1,1,0,NULL,0,NULL,'','',NULL),
			(104,'LBL_UNREAD',1,0,'Notification',0,1,1,0,1,0,NULL,NULL,'',NULL),
			(105,'All',1,0,'EmailTemplates',0,1,1,0,0,0,'',NULL,'',NULL),
			(106,'All',1,0,'CFixedAssets',0,1,1,0,0,0,'','','',NULL),
			(107,'All',1,0,'CInternalTickets',0,1,1,0,0,0,'','','',NULL),
			(108,'All',1,0,'FInvoiceCost',0,1,1,0,0,0,'','','',NULL),
			(109,'All',1,0,'CMileageLogbook',0,1,1,0,0,0,'','','',NULL),
			(110,'All',1,0,'SVendorEnquiries',0,1,1,0,0,0,'','','',NULL),
			(111,'All',1,0,'MultiCompany',0,1,1,0,0,0,'',NULL,'',NULL),
			(112,'All',1,0,'DataSetRegister',0,1,1,0,0,0,'',NULL,'',NULL),
			(113,'All',1,0,'ActivityRegister',0,1,1,0,0,0,'',NULL,'',NULL),
			(114,'All',1,0,'LocationRegister',0,1,1,0,0,0,'',NULL,'',NULL),
			(115,'All',1,0,'IncidentRegister',0,1,1,0,0,0,'',NULL,'',NULL),
			(116,'All',1,0,'AuditRegister',0,1,1,0,0,0,'',NULL,'',NULL),
			(117,'Open',0,0,'CInternalTickets',1,1,1,NULL,1,1,'','','',NULL),
			(118,'All',1,0,'Approvals',0,1,1,0,0,0,'','','',NULL),
			(119,'All',1,0,'ApprovalsRegister',0,1,1,0,0,0,'','','',NULL),
			(120,'All',1,0,'Locations',0,1,1,0,0,0,'','','',NULL),
			(121,'All',1,0,'Occurrences',0,1,1,0,0,0,'','','',NULL),
			(122,'All',1,0,'ProductCategory',0,1,1,0,0,0,'',NULL,'',NULL),
			(123,'All',1,0,'BankAccounts',0,1,1,0,0,0,'','','',NULL),
			(124,'All',1,0,'Queue',0,1,1,0,0,0,'','','',NULL),
			(125,'All',1,0,'Passwords',0,1,1,0,0,0,'','','',NULL),
			(126,'All',1,0,'SMSTemplates',0,1,1,0,0,0,'','','',NULL),
			(128,'All',1,0,'ReportTemplate',0,1,1,0,0,0,NULL,NULL,'',NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_cvcolumnlist`(`cvid`,`columnindex`,`field_name`,`module_name`,`source_field_name`,`label`) values
			(1,0,'company','Leads',NULL,''),
			(1,1,'leadstatus','Leads',NULL,''),
			(1,2,'industry','Leads',NULL,''),
			(1,3,'phone','Leads',NULL,''),
			(1,4,'website','Leads',NULL,''),
			(1,5,'email','Leads',NULL,''),
			(1,6,'assigned_user_id','Leads',NULL,''),
			(4,0,'accountname','Accounts',NULL,''),
			(4,1,'accounttype','Accounts',NULL,''),
			(4,2,'legal_form','Accounts',NULL,''),
			(4,3,'accounts_status','Accounts',NULL,''),
			(4,4,'website','Accounts',NULL,''),
			(4,5,'phone','Accounts',NULL,''),
			(4,6,'assigned_user_id','Accounts',NULL,''),
			(7,1,'firstname','Contacts',NULL,''),
			(7,2,'lastname','Contacts',NULL,''),
			(7,4,'parent_id','Contacts',NULL,''),
			(7,5,'email','Contacts',NULL,''),
			(7,6,'phone','Contacts',NULL,''),
			(7,7,'assigned_user_id','Contacts',NULL,''),
			(13,1,'ticket_title','HelpDesk',NULL,''),
			(13,2,'parent_id','HelpDesk',NULL,''),
			(13,3,'ticketstatus','HelpDesk',NULL,''),
			(13,4,'ticketpriorities','HelpDesk',NULL,''),
			(13,5,'assigned_user_id','HelpDesk',NULL,''),
			(19,1,'activitytype','Calendar',NULL,''),
			(19,2,'subject','Calendar',NULL,''),
			(19,4,'date_start','Calendar',NULL,''),
			(19,5,'due_date','Calendar',NULL,''),
			(19,6,'assigned_user_id','Calendar',NULL,''),
			(22,0,'notes_title','Documents',NULL,''),
			(22,1,'filename','Documents',NULL,''),
			(22,2,'ossdc_status','Documents',NULL,''),
			(22,3,'folderid','Documents',NULL,''),
			(22,4,'assigned_user_id','Documents',NULL,''),
			(23,1,'bookname','PriceBooks',NULL,''),
			(23,2,'active','PriceBooks',NULL,''),
			(23,3,'currency_id','PriceBooks',NULL,''),
			(24,0,'productname','Products',NULL,''),
			(24,1,'pscategory','Products',NULL,''),
			(24,3,'unit_price','Products',NULL,''),
			(24,4,'qtyinstock','Products',NULL,''),
			(24,5,'discontinued','Products',NULL,''),
			(24,6,'sales_start_date','Products',NULL,''),
			(27,1,'vendorname','Vendors',NULL,''),
			(27,2,'phone','Vendors',NULL,''),
			(27,3,'email','Vendors',NULL,''),
			(27,4,'category','Vendors',NULL,''),
			(27,5,'assigned_user_id','Vendors',NULL,''),
			(28,0,'modifiedtime','Faq',NULL,''),
			(28,1,'subject','Faq',NULL,''),
			(28,2,'category','Faq',NULL,''),
			(28,3,'faqstatus','Faq',NULL,''),
			(28,4,'featured','Faq',NULL,''),
			(28,5,'assigned_user_id','Faq',NULL,''),
			(29,1,'campaignname','Campaigns',NULL,''),
			(29,2,'campaigntype','Campaigns',NULL,''),
			(29,3,'campaignstatus','Campaigns',NULL,''),
			(29,4,'expectedrevenue','Campaigns',NULL,''),
			(29,5,'closingdate','Campaigns',NULL,''),
			(29,6,'assigned_user_id','Campaigns',NULL,''),
			(39,1,'subject','ServiceContracts',NULL,''),
			(39,2,'sc_related_to','ServiceContracts',NULL,''),
			(39,3,'assigned_user_id','ServiceContracts',NULL,''),
			(39,4,'start_date','ServiceContracts',NULL,''),
			(39,5,'due_date','ServiceContracts',NULL,''),
			(39,7,'progress','ServiceContracts',NULL,''),
			(39,8,'contract_status','ServiceContracts',NULL,''),
			(40,0,'servicename','Services',NULL,''),
			(40,1,'unit_price','Services',NULL,''),
			(40,2,'sales_start_date','Services',NULL,''),
			(40,3,'sales_end_date','Services',NULL,''),
			(40,4,'pscategory','Services',NULL,''),
			(40,6,'discontinued','Services',NULL,''),
			(41,0,'assetname','Assets',NULL,''),
			(41,1,'product','Assets',NULL,''),
			(41,2,'parent_id','Assets',NULL,''),
			(41,3,'dateinservice','Assets',NULL,''),
			(41,6,'assetstatus','Assets',NULL,''),
			(42,0,'commentcontent','ModComments',NULL,''),
			(42,1,'related_to','ModComments',NULL,''),
			(42,2,'modifiedtime','ModComments',NULL,''),
			(42,3,'assigned_user_id','ModComments',NULL,''),
			(43,0,'projectmilestonename','ProjectMilestone',NULL,''),
			(43,1,'projectmilestonedate','ProjectMilestone',NULL,''),
			(43,2,'description','ProjectMilestone',NULL,''),
			(43,3,'projectid','ProjectMilestone',NULL,''),
			(43,4,'projectmilestone_priority','ProjectMilestone',NULL,''),
			(43,5,'projectmilestonetype','ProjectMilestone',NULL,''),
			(44,2,'projecttaskname','ProjectTask',NULL,''),
			(44,3,'projectid','ProjectTask',NULL,''),
			(44,4,'projecttaskpriority','ProjectTask',NULL,''),
			(44,5,'projecttaskprogress','ProjectTask',NULL,''),
			(44,6,'startdate','ProjectTask',NULL,''),
			(44,7,'enddate','ProjectTask',NULL,''),
			(44,8,'assigned_user_id','ProjectTask',NULL,''),
			(45,0,'projectname','Project',NULL,''),
			(45,1,'linktoaccountscontacts','Project',NULL,''),
			(45,2,'startdate','Project',NULL,''),
			(45,3,'targetenddate','Project',NULL,''),
			(45,4,'actualenddate','Project',NULL,''),
			(45,5,'targetbudget','Project',NULL,''),
			(45,6,'progress','Project',NULL,''),
			(45,7,'projectstatus','Project',NULL,''),
			(45,8,'assigned_user_id','Project',NULL,''),
			(46,0,'message','SMSNotifier',NULL,''),
			(46,1,'assigned_user_id','SMSNotifier',NULL,''),
			(46,2,'createdtime','SMSNotifier',NULL,''),
			(46,3,'modifiedtime','SMSNotifier',NULL,''),
			(46,4,'smsnotifier_status','SMSNotifier',NULL,''),
			(49,0,'name','OSSTimeControl',NULL,''),
			(49,1,'date_start','OSSTimeControl',NULL,''),
			(49,2,'time_start','OSSTimeControl',NULL,''),
			(49,3,'due_date','OSSTimeControl',NULL,''),
			(49,4,'time_end','OSSTimeControl',NULL,''),
			(49,5,'assigned_user_id','OSSTimeControl',NULL,''),
			(50,0,'createdtime','OSSMailView',NULL,''),
			(50,1,'from_email','OSSMailView',NULL,''),
			(50,2,'subject','OSSMailView',NULL,''),
			(50,3,'ossmailview_sendtype','OSSMailView',NULL,''),
			(50,4,'attachments_exist','OSSMailView',NULL,''),
			(50,5,'assigned_user_id','OSSMailView',NULL,''),
			(52,0,'productname','OSSOutsourcedServices',NULL,''),
			(52,1,'osservicesstatus','OSSOutsourcedServices',NULL,''),
			(52,2,'pscategory','OSSOutsourcedServices',NULL,''),
			(52,4,'dateinservice','OSSOutsourcedServices',NULL,''),
			(52,5,'parent_id','OSSOutsourcedServices',NULL,''),
			(53,0,'productname','OSSSoldServices',NULL,''),
			(53,1,'serviceid','OSSSoldServices',NULL,''),
			(53,2,'parent_id','OSSSoldServices',NULL,''),
			(53,4,'ssservicesstatus','OSSSoldServices',NULL,''),
			(53,6,'dateinservice','OSSSoldServices',NULL,''),
			(54,0,'productname','OutsourcedProducts',NULL,''),
			(54,1,'oproductstatus','OutsourcedProducts',NULL,''),
			(54,2,'pscategory','OutsourcedProducts',NULL,''),
			(54,4,'parent_id','OutsourcedProducts',NULL,''),
			(54,6,'dateinservice','OutsourcedProducts',NULL,''),
			(56,0,'last_name','OSSEmployees',NULL,''),
			(56,1,'name','OSSEmployees',NULL,''),
			(56,2,'employee_status','OSSEmployees',NULL,''),
			(56,3,'multicompanyid','OSSEmployees',NULL,''),
			(56,4,'assigned_user_id','OSSEmployees',NULL,''),
			(56,5,'createdtime','OSSEmployees',NULL,''),
			(56,6,'modifiedtime','OSSEmployees',NULL,''),
			(68,0,'from_number','CallHistory',NULL,''),
			(68,1,'to_number','CallHistory',NULL,''),
			(68,2,'duration','CallHistory',NULL,''),
			(68,4,'start_time','CallHistory',NULL,''),
			(69,0,'subject','Ideas',NULL,''),
			(69,1,'ideasstatus','Ideas',NULL,''),
			(69,2,'assigned_user_id','Ideas',NULL,''),
			(69,3,'createdtime','Ideas',NULL,''),
			(69,4,'modifiedtime','Ideas',NULL,''),
			(72,0,'ossemployeesid','HolidaysEntitlement',NULL,''),
			(72,1,'holidaysentitlement_year','HolidaysEntitlement',NULL,''),
			(72,2,'days','HolidaysEntitlement',NULL,''),
			(72,3,'assigned_user_id','HolidaysEntitlement',NULL,''),
			(72,4,'createdtime','HolidaysEntitlement',NULL,''),
			(72,5,'modifiedtime','HolidaysEntitlement',NULL,''),
			(73,1,'assigned_user_id','PaymentsIn',NULL,''),
			(73,2,'createdtime','PaymentsIn',NULL,''),
			(73,3,'modifiedtime','PaymentsIn',NULL,''),
			(73,4,'paymentsno','PaymentsIn',NULL,''),
			(73,5,'paymentsname','PaymentsIn',NULL,''),
			(73,6,'paymentsvalue','PaymentsIn',NULL,''),
			(74,1,'assigned_user_id','PaymentsOut',NULL,''),
			(74,2,'createdtime','PaymentsOut',NULL,''),
			(74,3,'modifiedtime','PaymentsOut',NULL,''),
			(74,4,'paymentsno','PaymentsOut',NULL,''),
			(74,5,'paymentsname','PaymentsOut',NULL,''),
			(74,6,'paymentsvalue','PaymentsOut',NULL,''),
			(75,0,'number','LettersIn',NULL,''),
			(75,1,'title','LettersIn',NULL,''),
			(75,3,'assigned_user_id','LettersIn',NULL,''),
			(75,4,'createdtime','LettersIn',NULL,''),
			(75,6,'lin_type_ship','LettersIn',NULL,''),
			(75,7,'lin_type_doc','LettersIn',NULL,''),
			(76,0,'number','LettersOut',NULL,''),
			(76,1,'title','LettersOut',NULL,''),
			(76,3,'assigned_user_id','LettersOut',NULL,''),
			(76,4,'createdtime','LettersOut',NULL,''),
			(76,6,'lout_type_ship','LettersOut',NULL,''),
			(76,7,'lout_type_doc','LettersOut',NULL,''),
			(77,0,'subject','Announcements',NULL,''),
			(77,1,'assigned_user_id','Announcements',NULL,''),
			(77,2,'announcementstatus','Announcements',NULL,''),
			(77,3,'createdtime','Announcements',NULL,''),
			(77,4,'modifiedtime','Announcements',NULL,''),
			(77,5,'is_mandatory','Announcements',NULL,''),
			(78,0,'reservations_no','Reservations',NULL,''),
			(78,1,'title','Reservations',NULL,''),
			(78,2,'date_start','Reservations',NULL,''),
			(78,3,'time_start','Reservations',NULL,''),
			(78,4,'due_date','Reservations',NULL,''),
			(78,5,'time_end','Reservations',NULL,''),
			(78,6,'assigned_user_id','Reservations',NULL,''),
			(79,0,'subject','SQuoteEnquiries',NULL,''),
			(79,2,'squoteenquiries_status','SQuoteEnquiries',NULL,''),
			(79,3,'category','SQuoteEnquiries',NULL,''),
			(79,4,'assigned_user_id','SQuoteEnquiries',NULL,''),
			(79,5,'createdtime','SQuoteEnquiries',NULL,''),
			(80,0,'subject','SSalesProcesses',NULL,''),
			(80,1,'ssalesprocesses_type','SSalesProcesses',NULL,''),
			(80,2,'ssalesprocesses_source','SSalesProcesses',NULL,''),
			(80,3,'ssalesprocesses_status','SSalesProcesses',NULL,''),
			(80,4,'related_to','SSalesProcesses',NULL,''),
			(80,5,'category','SSalesProcesses',NULL,''),
			(80,6,'assigned_user_id','SSalesProcesses',NULL,''),
			(80,7,'createdtime','SSalesProcesses',NULL,''),
			(81,0,'subject','SRequirementsCards',NULL,''),
			(81,1,'salesprocessid','SRequirementsCards',NULL,''),
			(81,2,'srequirementscards_status','SRequirementsCards',NULL,''),
			(81,3,'category','SRequirementsCards',NULL,''),
			(81,4,'assigned_user_id','SRequirementsCards',NULL,''),
			(81,5,'createdtime','SRequirementsCards',NULL,''),
			(82,0,'subject','SCalculations',NULL,''),
			(82,1,'salesprocessid','SCalculations',NULL,''),
			(82,2,'scalculations_status','SCalculations',NULL,''),
			(82,3,'category','SCalculations',NULL,''),
			(82,4,'assigned_user_id','SCalculations',NULL,''),
			(82,5,'createdtime','SCalculations',NULL,''),
			(83,0,'subject','SQuotes',NULL,''),
			(83,1,'salesprocessid','SQuotes',NULL,''),
			(83,2,'squotes_status','SQuotes',NULL,''),
			(83,3,'category','SQuotes',NULL,''),
			(83,4,'assigned_user_id','SQuotes',NULL,''),
			(83,5,'createdtime','SQuotes',NULL,''),
			(84,0,'subject','SSingleOrders',NULL,''),
			(84,1,'salesprocessid','SSingleOrders',NULL,''),
			(84,2,'ssingleorders_status','SSingleOrders',NULL,''),
			(84,3,'category','SSingleOrders',NULL,''),
			(84,4,'assigned_user_id','SSingleOrders',NULL,''),
			(84,5,'createdtime','SSingleOrders',NULL,''),
			(85,0,'subject','SRecurringOrders',NULL,''),
			(85,1,'salesprocessid','SRecurringOrders',NULL,''),
			(85,2,'srecurringorders_status','SRecurringOrders',NULL,''),
			(85,3,'category','SRecurringOrders',NULL,''),
			(85,4,'assigned_user_id','SRecurringOrders',NULL,''),
			(85,5,'createdtime','SRecurringOrders',NULL,''),
			(86,0,'subject','Partners',NULL,''),
			(86,1,'email','Partners',NULL,''),
			(86,2,'category','Partners',NULL,''),
			(86,3,'vat_id','Partners',NULL,''),
			(86,4,'assigned_user_id','Partners',NULL,''),
			(86,5,'createdtime','Partners',NULL,''),
			(87,0,'subject','Competition',NULL,''),
			(87,1,'vat_id','Competition',NULL,''),
			(87,2,'assigned_user_id','Competition',NULL,''),
			(87,3,'createdtime','Competition',NULL,''),
			(88,0,'subject','FBookkeeping',NULL,''),
			(88,1,'related_to','FBookkeeping',NULL,''),
			(88,2,'createdtime','FBookkeeping',NULL,''),
			(88,3,'assigned_user_id','FBookkeeping',NULL,''),
			(88,4,'number','FBookkeeping',NULL,''),
			(89,0,'subject','FInvoice',NULL,''),
			(89,1,'number','FInvoice',NULL,''),
			(89,2,'finvoice_type','FInvoice',NULL,''),
			(89,3,'accountid','FInvoice',NULL,''),
			(89,4,'assigned_user_id','FInvoice',NULL,''),
			(89,5,'saledate','FInvoice',NULL,''),
			(90,0,'subject','KnowledgeBase',NULL,''),
			(90,1,'category','KnowledgeBase',NULL,''),
			(90,2,'knowledgebase_status','KnowledgeBase',NULL,''),
			(90,3,'featured','KnowledgeBase',NULL,''),
			(90,4,'assigned_user_id','KnowledgeBase',NULL,''),
			(90,5,'modifiedtime','KnowledgeBase',NULL,''),
			(91,0,'subject','IStorages',NULL,''),
			(91,1,'storage_status','IStorages',NULL,''),
			(91,2,'storage_type','IStorages',NULL,''),
			(91,3,'parentid','IStorages',NULL,''),
			(91,4,'assigned_user_id','IStorages',NULL,''),
			(91,5,'createdtime','IStorages',NULL,''),
			(92,0,'subject','IGRN',NULL,''),
			(92,1,'vendorid','IGRN',NULL,''),
			(92,2,'number','IGRN',NULL,''),
			(92,3,'assigned_user_id','IGRN',NULL,''),
			(92,4,'acceptance_date','IGRN',NULL,''),
			(92,5,'createdtime','IGRN',NULL,''),
			(93,0,'accountid','FInvoiceProforma',NULL,''),
			(93,1,'finvoiceproforma_status','FInvoiceProforma',NULL,''),
			(93,2,'subject','FInvoiceProforma',NULL,''),
			(93,3,'assigned_user_id','FInvoiceProforma',NULL,''),
			(93,4,'number','FInvoiceProforma',NULL,''),
			(93,5,'createdtime','FInvoiceProforma',NULL,''),
			(94,0,'subject','IGDN',NULL,''),
			(94,1,'number','IGDN',NULL,''),
			(94,2,'storageid','IGDN',NULL,''),
			(94,3,'assigned_user_id','IGDN',NULL,''),
			(94,4,'createdtime','IGDN',NULL,''),
			(95,0,'subject','IIDN',NULL,''),
			(95,1,'number','IIDN',NULL,''),
			(95,2,'storageid','IIDN',NULL,''),
			(95,3,'assigned_user_id','IIDN',NULL,''),
			(95,4,'createdtime','IIDN',NULL,''),
			(96,0,'subject','IGIN',NULL,''),
			(96,1,'number','IGIN',NULL,''),
			(96,2,'storageid','IGIN',NULL,''),
			(96,3,'assigned_user_id','IGIN',NULL,''),
			(96,4,'createdtime','IGIN',NULL,''),
			(97,0,'subject','IPreOrder',NULL,''),
			(97,1,'number','IPreOrder',NULL,''),
			(97,2,'storageid','IPreOrder',NULL,''),
			(97,3,'assigned_user_id','IPreOrder',NULL,''),
			(97,4,'createdtime','IPreOrder',NULL,''),
			(98,0,'subject','ISTDN',NULL,''),
			(98,1,'accountid','ISTDN',NULL,''),
			(98,2,'number','ISTDN',NULL,''),
			(98,3,'assigned_user_id','ISTDN',NULL,''),
			(98,4,'acceptance_date','ISTDN',NULL,''),
			(98,5,'createdtime','ISTDN',NULL,''),
			(99,0,'subject','ISTN',NULL,''),
			(99,2,'number','ISTN',NULL,''),
			(99,3,'assigned_user_id','ISTN',NULL,''),
			(99,4,'estimated_date','ISTN',NULL,''),
			(99,5,'createdtime','ISTN',NULL,''),
			(100,0,'subject','ISTRN',NULL,''),
			(100,1,'vendorid','ISTRN',NULL,''),
			(100,2,'number','ISTRN',NULL,''),
			(100,3,'assigned_user_id','ISTRN',NULL,''),
			(100,4,'acceptance_date','ISTRN',NULL,''),
			(100,5,'createdtime','ISTRN',NULL,''),
			(101,0,'subject','FCorectingInvoice',NULL,''),
			(101,1,'number','FCorectingInvoice',NULL,''),
			(101,2,'accountid','FCorectingInvoice',NULL,''),
			(101,3,'assigned_user_id','FCorectingInvoice',NULL,''),
			(101,4,'saledate','FCorectingInvoice',NULL,''),
			(102,0,'subject','IGRNC',NULL,''),
			(102,1,'vendorid','IGRNC',NULL,''),
			(102,2,'number','IGRNC',NULL,''),
			(102,3,'assigned_user_id','IGRNC',NULL,''),
			(102,4,'acceptance_date','IGRNC',NULL,''),
			(102,5,'createdtime','IGRNC',NULL,''),
			(103,0,'subject','IGDNC',NULL,''),
			(103,1,'igdnc_status','IGDNC',NULL,''),
			(103,2,'number','IGDNC',NULL,''),
			(103,3,'storageid','IGDNC',NULL,''),
			(103,4,'assigned_user_id','IGDNC',NULL,''),
			(103,5,'createdtime','IGDNC',NULL,''),
			(104,0,'title','Notification',NULL,''),
			(104,1,'number','Notification',NULL,''),
			(104,2,'createdtime','Notification',NULL,''),
			(104,3,'assigned_user_id','Notification',NULL,''),
			(105,0,'name','EmailTemplates',NULL,''),
			(105,1,'module_name','EmailTemplates',NULL,''),
			(105,2,'assigned_user_id','EmailTemplates',NULL,''),
			(105,3,'email_template_type','EmailTemplates',NULL,''),
			(106,0,'subject','CFixedAssets',NULL,''),
			(106,1,'fixed_assets_type','CFixedAssets',NULL,''),
			(106,2,'number','CFixedAssets',NULL,''),
			(106,3,'fixed_assets_status','CFixedAssets',NULL,''),
			(106,4,'createdtime','CFixedAssets',NULL,''),
			(106,5,'assigned_user_id','CFixedAssets',NULL,''),
			(107,0,'cinternaltickets_no','CInternalTickets',NULL,''),
			(107,1,'subject','CInternalTickets',NULL,''),
			(107,2,'internal_tickets_status','CInternalTickets',NULL,''),
			(107,3,'assigned_user_id','CInternalTickets',NULL,''),
			(107,4,'shownerid','CInternalTickets',NULL,''),
			(107,5,'modifiedtime','CInternalTickets',NULL,''),
			(107,6,'createdtime','CInternalTickets',NULL,''),
			(108,0,'subject','FInvoiceCost',NULL,''),
			(108,1,'finvoicecost_paymentstatus','FInvoiceCost',NULL,''),
			(108,2,'number','FInvoiceCost',NULL,''),
			(108,3,'assigned_user_id','FInvoiceCost',NULL,''),
			(108,4,'saledate','FInvoiceCost',NULL,''),
			(108,5,'payment_methods','FInvoiceCost',NULL,''),
			(109,0,'subject','CMileageLogbook',NULL,''),
			(109,1,'number_kilometers','CMileageLogbook',NULL,''),
			(109,2,'number','CMileageLogbook',NULL,''),
			(109,3,'cmileage_logbook_status','CMileageLogbook',NULL,''),
			(109,4,'createdtime','CMileageLogbook',NULL,''),
			(109,5,'assigned_user_id','CMileageLogbook',NULL,''),
			(110,0,'subject','SVendorEnquiries',NULL,''),
			(110,1,'salesprocessid','SVendorEnquiries',NULL,''),
			(110,2,'svendorenquiries_status','SVendorEnquiries',NULL,''),
			(110,3,'category','SVendorEnquiries',NULL,''),
			(110,4,'assigned_user_id','SVendorEnquiries',NULL,''),
			(110,5,'createdtime','SVendorEnquiries',NULL,''),
			(111,0,'company_name','MultiCompany',NULL,''),
			(111,1,'mulcomp_status','MultiCompany',NULL,''),
			(111,2,'email1','MultiCompany',NULL,''),
			(111,3,'phone','MultiCompany',NULL,''),
			(111,4,'vat','MultiCompany',NULL,''),
			(111,5,'addresslevel5a','MultiCompany',NULL,''),
			(111,6,'assigned_user_id','MultiCompany',NULL,''),
			(112,0,'subject','DataSetRegister',NULL,''),
			(112,1,'assigned_user_id','DataSetRegister',NULL,''),
			(112,2,'datasetregister_status','DataSetRegister',NULL,''),
			(112,3,'data_submitted','DataSetRegister',NULL,''),
			(112,4,'registered_dpo','DataSetRegister',NULL,''),
			(112,5,'added_to_register','DataSetRegister',NULL,''),
			(112,6,'removed_from_register','DataSetRegister',NULL,''),
			(113,0,'subject','ActivityRegister',NULL,''),
			(113,1,'assigned_user_id','ActivityRegister',NULL,''),
			(113,2,'activityregister_status','ActivityRegister',NULL,''),
			(113,3,'datasetregisterid','ActivityRegister',NULL,''),
			(113,4,'parent_id','ActivityRegister',NULL,''),
			(113,5,'start_date','ActivityRegister',NULL,''),
			(113,6,'end_date','ActivityRegister',NULL,''),
			(114,0,'name','LocationRegister',NULL,''),
			(114,1,'assigned_user_id','LocationRegister',NULL,''),
			(114,2,'locationregister_status','LocationRegister',NULL,''),
			(114,3,'parent_id','LocationRegister',NULL,''),
			(114,4,'city','LocationRegister',NULL,''),
			(115,0,'name','IncidentRegister',NULL,''),
			(115,1,'assigned_user_id','IncidentRegister',NULL,''),
			(115,2,'incidentregister_type','IncidentRegister',NULL,''),
			(115,3,'incidentregister_status','IncidentRegister',NULL,''),
			(115,4,'datasetregisterid','IncidentRegister',NULL,''),
			(115,5,'locationregisterid','IncidentRegister',NULL,''),
			(115,6,'peoplne_number','IncidentRegister',NULL,''),
			(116,0,'name','AuditRegister',NULL,''),
			(116,1,'assigned_user_id','AuditRegister',NULL,''),
			(116,2,'auditregister_status','AuditRegister',NULL,''),
			(116,3,'auditregister_type','AuditRegister',NULL,''),
			(116,4,'datasetregisterid','AuditRegister',NULL,''),
			(116,5,'locationregisterid','AuditRegister',NULL,''),
			(117,0,'cinternaltickets_no','CInternalTickets',NULL,''),
			(117,1,'subject','CInternalTickets',NULL,''),
			(117,2,'internal_tickets_status','CInternalTickets',NULL,''),
			(117,3,'assigned_user_id','CInternalTickets',NULL,''),
			(117,4,'shownerid','CInternalTickets',NULL,''),
			(117,5,'modifiedtime','CInternalTickets',NULL,''),
			(117,6,'createdtime','CInternalTickets',NULL,''),
			(118,0,'name','Approvals','',''),
			(118,1,'number','Approvals','',''),
			(118,2,'createdtime','Approvals','',''),
			(118,3,'assigned_user_id','Approvals','',''),
			(119,0,'subject','ApprovalsRegister',NULL,''),
			(119,1,'approvalsid','ApprovalsRegister',NULL,''),
			(119,2,'approvals_register_status','ApprovalsRegister',NULL,''),
			(119,3,'contactid','ApprovalsRegister',NULL,''),
			(119,4,'approvals_register_type','ApprovalsRegister',NULL,''),
			(119,5,'registration_date','ApprovalsRegister',NULL,''),
			(119,6,'assigned_user_id','ApprovalsRegister',NULL,''),
			(120,0,'addresslevel2a','Locations','',''),
			(120,1,'addresslevel5a','Locations','',''),
			(120,2,'subject','Locations','',''),
			(120,3,'addresslevel8a','Locations','',''),
			(120,4,'capacity','Locations','',''),
			(120,5,'phone','Locations','',''),
			(120,6,'email','Locations','',''),
			(120,7,'phone_extra','Locations','',''),
			(120,8,'assigned_user_id','Locations','',''),
			(121,0,'topic','Occurrences',NULL,''),
			(121,1,'occurrences_type','Occurrences',NULL,''),
			(121,2,'date_start','Occurrences',NULL,''),
			(121,3,'date_end','Occurrences',NULL,''),
			(121,4,'locationid','Occurrences',NULL,''),
			(121,5,'participants','Occurrences',NULL,''),
			(121,6,'assigned_user_id','Occurrences',NULL,''),
			(122,0,'category','ProductCategory',NULL,''),
			(122,1,'active','ProductCategory',NULL,''),
			(122,2,'parent_id','ProductCategory',NULL,''),
			(122,3,'number','ProductCategory',NULL,''),
			(122,4,'createdtime','ProductCategory',NULL,''),
			(122,5,'assigned_user_id','ProductCategory',NULL,''),
			(123,0,'number','BankAccounts',NULL,''),
			(123,1,'name','BankAccounts',NULL,''),
			(123,2,'bankaccount_status','BankAccounts',NULL,''),
			(123,3,'account_number','BankAccounts',NULL,''),
			(123,4,'currency_id','BankAccounts',NULL,''),
			(123,5,'bank_name','BankAccounts',NULL,''),
			(123,6,'multicompanyid','BankAccounts',NULL,''),
			(123,7,'assigned_user_id','BankAccounts',NULL,''),
			(124,0,'subject','Queue',NULL,''),
			(124,1,'queue_status','Queue',NULL,''),
			(124,2,'related_to','Queue',NULL,''),
			(124,3,'changes','Queue',NULL,''),
			(124,4,'createdtime','Queue',NULL,''),
			(124,5,'assigned_user_id','Queue',NULL,''),
			(125,0,'subject','Passwords',NULL,''),
			(125,1,'username','Passwords',NULL,''),
			(125,2,'password','Passwords',NULL,''),
			(125,3,'website','Passwords',NULL,''),
			(125,4,'link','Passwords',NULL,''),
			(125,5,'assigned_user_id','Passwords',NULL,''),
			(126,0,'subject','SMSTemplates',NULL,''),
			(126,1,'target','SMSTemplates',NULL,''),
			(126,2,'createdtime','SMSTemplates',NULL,''),
			(126,3,'assigned_user_id','SMSTemplates',NULL,''),
			(128,0,'number','ReportTemplate',NULL,''),
			(128,1,'name','ReportTemplate',NULL,''),
			(128,2,'createdtime','ReportTemplate',NULL,''),
			(128,3,'assigned_user_id','ReportTemplate',NULL,'');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_datasetregister_status`(`datasetregister_statusid`,`datasetregister_status`,`presence`,`sortorderid`) values
			(1,'PLL_DRAFT',1,1),
			(2,'PLL_WAITING_FOR_ACCEPTANCE',1,2),
			(3,'PLL_IN_REALIZATION',1,3),
			(4,'PLL_COMPLETED',1,4),
			(5,'PLL_CANCELLED',1,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_datashare_relatedmodules`(`datashare_relatedmodule_id`,`tabid`,`relatedto_tabid`) values
			(2,6,13);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_date_format`(`date_formatid`,`date_format`,`sortorderid`,`presence`) values
			(1,'dd-mm-yyyy',0,1),
			(2,'mm-dd-yyyy',1,1),
			(3,'yyyy-mm-dd',2,1),
			(4,'dd.mm.yyyy',3,1),
			(5,'mm.dd.yyyy',4,1),
			(6,'yyyy.mm.dd',5,1),
			(7,'dd/mm/yyyy',6,1),
			(8,'mm/dd/yyyy',7,1),
			(9,'yyyy/mm/dd',8,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_dayoftheweek`(`dayoftheweekid`,`dayoftheweek`,`sortorderid`,`presence`) values
			(1,'Sunday',1,1),
			(2,'Monday',2,1),
			(3,'Tuesday',3,1),
			(4,'Wednesday',4,1),
			(5,'Thursday',5,1),
			(6,'Friday',6,1),
			(7,'Saturday',7,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_def_org_share`(`ruleid`,`tabid`,`permission`,`editstatus`) values
			(2,4,2,2),
			(3,6,2,0),
			(4,7,2,0),
			(5,9,3,0),
			(6,13,2,0),
			(12,26,2,0),
			(13,8,2,0),
			(14,14,2,0),
			(16,34,2,0),
			(17,35,2,0),
			(18,37,2,0),
			(19,40,2,0),
			(20,41,2,0),
			(21,42,2,0),
			(22,43,2,0),
			(23,45,2,0),
			(24,18,2,0),
			(28,51,2,0),
			(29,54,3,0),
			(30,57,2,0),
			(31,58,2,0),
			(32,59,2,0),
			(34,61,2,0),
			(45,74,2,0),
			(46,75,2,0),
			(49,78,2,0),
			(50,79,2,0),
			(51,80,2,0),
			(52,81,2,0),
			(53,82,2,0),
			(54,83,2,0),
			(55,84,2,0),
			(56,15,2,0),
			(57,19,2,0),
			(58,85,2,0),
			(59,86,2,0),
			(60,87,2,0),
			(61,88,2,0),
			(62,89,2,0),
			(63,90,2,0),
			(64,91,2,0),
			(65,92,2,0),
			(66,93,2,0),
			(67,94,2,0),
			(68,95,2,0),
			(69,96,2,0),
			(70,97,2,0),
			(71,98,2,0),
			(72,99,2,0),
			(73,100,2,0),
			(74,101,2,0),
			(75,102,2,0),
			(76,103,2,0),
			(77,104,2,0),
			(78,105,2,0),
			(79,106,2,0),
			(80,107,2,0),
			(81,108,2,0),
			(82,109,2,0),
			(83,111,2,0),
			(84,112,2,0),
			(85,113,2,0),
			(86,114,2,0),
			(87,115,2,0),
			(88,116,2,0),
			(89,117,2,0),
			(90,119,2,0),
			(91,121,2,0),
			(92,122,2,0),
			(93,123,2,0),
			(94,124,2,0),
			(95,125,2,0),
			(96,127,2,0),
			(97,128,2,0),
			(98,130,2,0),
			(99,131,3,0),
			(100,132,2,0),
			(101,133,2,0),
			(102,134,2,0),
			(103,135,2,0),
			(104,136,2,0),
			(106,138,3,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_default_record_view`(`default_record_viewid`,`default_record_view`,`sortorderid`,`presence`) values
			(1,'Summary',1,1),
			(2,'Detail',2,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_default_search_operator`(`default_search_operatorid`,`default_search_operator`,`presence`,`sortorderid`) values
			(1,'PLL_FULLTEXT_BEGIN',1,1),
			(2,'PLL_FULLTEXT_WORD',1,2),
			(3,'PLL_CONTAINS',1,3),
			(4,'PLL_STARTS_WITH',1,4),
			(5,'PLL_ENDS_WITH',1,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_defaultactivitytype`(`defaultactivitytypeid`,`defaultactivitytype`,`presence`,`sortorderid`) values
			(1,'Call',1,1),
			(2,'Meeting',1,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_defaulteventstatus`(`defaulteventstatusid`,`defaulteventstatus`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Held',1,323,2),
			(2,'Not Held',1,324,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_duration_minutes`(`minutesid`,`duration_minutes`,`sortorderid`,`presence`) values
			(1,'00',0,1),
			(2,'15',1,1),
			(3,'30',2,1),
			(4,'45',3,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_email_template_priority`(`email_template_priorityid`,`email_template_priority`,`presence`,`sortorderid`) values
			(1,1,1,1),
			(2,2,1,2),
			(3,3,1,3),
			(4,4,1,4),
			(5,5,1,5),
			(6,6,1,6),
			(7,7,1,7),
			(8,8,1,8),
			(9,9,1,9);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_email_template_type`(`email_template_typeid`,`email_template_type`,`presence`,`sortorderid`) values
			(1,'PLL_MAIL',1,1),
			(2,'PLL_RECORD',1,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_employee_education`(`employee_educationid`,`employee_education`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Primary',1,425,1),
			(2,'Secondary',1,426,2),
			(3,'Higher',1,427,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_employee_status`(`employee_statusid`,`employee_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Recruiting',1,422,1),
			(2,'Employee',1,423,2),
			(3,'Inactive',1,424,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_end_hour`(`end_hourid`,`end_hour`,`sortorderid`,`presence`) values
			(1,'00:00',1,1),
			(2,'01:00',2,1),
			(3,'02:00',3,1),
			(4,'03:00',4,1),
			(5,'04:00',5,1),
			(6,'05:00',6,1),
			(7,'06:00',7,1),
			(8,'07:00',8,1),
			(9,'08:00',9,1),
			(10,'09:00',10,1),
			(11,'10:00',11,1),
			(12,'11:00',12,1),
			(13,'12:00',13,1),
			(14,'13:00',14,1),
			(15,'14:00',15,1),
			(16,'15:00',16,1),
			(17,'16:00',17,1),
			(18,'17:00',18,1),
			(19,'18:00',19,1),
			(20,'19:00',20,1),
			(21,'20:00',21,1),
			(22,'21:00',22,1),
			(23,'22:00',23,1),
			(24,'23:00',24,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_entity_stats`(`crmid`,`crmactivity`) values
			(2,NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_entityname`(`tabid`,`modulename`,`tablename`,`fieldname`,`entityidfield`,`entityidcolumn`,`searchcolumn`,`turn_off`,`sequence`,`separator`) values
			(4,'Contacts','vtiger_contactdetails','firstname,lastname','contactid','contact_id','firstname,lastname',1,0,NULL),
			(6,'Accounts','vtiger_account','accountname','accountid','account_id','accountname',1,0,NULL),
			(7,'Leads','vtiger_leaddetails','company','leadid','leadid','company',1,0,NULL),
			(8,'Documents','vtiger_notes','title','notesid','notesid','title',0,0,NULL),
			(9,'Calendar','vtiger_activity','subject','activityid','activityid','subject',1,0,NULL),
			(13,'HelpDesk','vtiger_troubletickets','title','ticketid','ticketid','title',1,0,NULL),
			(14,'Products','vtiger_products','productname','productid','product_id','productname,ean',1,0,NULL),
			(15,'Faq','vtiger_faq','subject','id','id','subject',1,0,NULL),
			(18,'Vendors','vtiger_vendor','vendorname','vendorid','vendor_id','vendorname',1,0,NULL),
			(19,'PriceBooks','vtiger_pricebook','bookname','pricebookid','pricebookid','bookname',1,0,NULL),
			(26,'Campaigns','vtiger_campaign','campaignname','campaignid','campaignid','campaignname',1,0,NULL),
			(29,'Users','vtiger_users','last_name,first_name','id','id','last_name,first_name',1,0,NULL),
			(34,'ServiceContracts','vtiger_servicecontracts','subject','servicecontractsid','servicecontractsid','subject',1,0,NULL),
			(35,'Services','vtiger_service','servicename','serviceid','serviceid','servicename',1,0,NULL),
			(37,'Assets','vtiger_assets','assetname','assetsid','assetsid','assetname',1,0,NULL),
			(40,'ModComments','vtiger_modcomments','commentcontent','modcommentsid','modcommentsid','commentcontent',0,0,NULL),
			(41,'ProjectMilestone','vtiger_projectmilestone','projectmilestonename','projectmilestoneid','projectmilestoneid','projectmilestonename',1,0,NULL),
			(42,'ProjectTask','vtiger_projecttask','projecttaskname','projecttaskid','projecttaskid','projecttaskname',1,0,NULL),
			(43,'Project','vtiger_project','projectname','projectid','projectid','projectname',1,0,NULL),
			(45,'SMSNotifier','vtiger_smsnotifier','message','smsnotifierid','smsnotifierid','message',0,0,NULL),
			(51,'OSSTimeControl','vtiger_osstimecontrol','name','osstimecontrolid','osstimecontrolid','name',1,0,NULL),
			(54,'OSSMailView','vtiger_ossmailview','subject','ossmailviewid','ossmailviewid','subject',0,0,NULL),
			(57,'OSSOutsourcedServices','vtiger_ossoutsourcedservices','productname','ossoutsourcedservicesid','ossoutsourcedservicesid','productname',1,0,NULL),
			(58,'OSSSoldServices','vtiger_osssoldservices','productname','osssoldservicesid','osssoldservicesid','productname',1,0,NULL),
			(59,'OutsourcedProducts','vtiger_outsourcedproducts','productname','outsourcedproductsid','outsourcedproductsid','productname',1,0,NULL),
			(61,'OSSEmployees','vtiger_ossemployees','last_name','ossemployeesid','ossemployeesid','last_name',1,0,NULL),
			(74,'CallHistory','vtiger_callhistory','to_number','callhistoryid','callhistoryid','to_number',0,0,NULL),
			(75,'Ideas','vtiger_ideas','subject','ideasid','ideasid','subject',1,0,NULL),
			(78,'HolidaysEntitlement','vtiger_holidaysentitlement','ossemployeesid,days','holidaysentitlementid','holidaysentitlementid','ossemployeesid',0,0,NULL),
			(79,'PaymentsIn','vtiger_paymentsin','paymentsname','paymentsinid','paymentsinid','paymentsno,paymentsname',1,0,NULL),
			(80,'PaymentsOut','vtiger_paymentsout','paymentsname','paymentsoutid','paymentsoutid','paymentsno,paymentsname',1,0,NULL),
			(81,'LettersIn','vtiger_lettersin','title','lettersinid','lettersinid','title',1,0,NULL),
			(82,'LettersOut','vtiger_lettersout','title','lettersoutid','lettersoutid','title',1,0,NULL),
			(83,'Announcements','u_yf_announcement','subject','announcementid','announcementid','subject',0,0,NULL),
			(84,'Reservations','vtiger_reservations','title','reservationsid','reservationsid','title',1,0,NULL),
			(85,'SQuoteEnquiries','u_yf_squoteenquiries','subject','squoteenquiriesid','squoteenquiriesid','subject',1,0,NULL),
			(86,'SSalesProcesses','u_yf_ssalesprocesses','subject','ssalesprocessesid','ssalesprocessesid','subject',1,0,NULL),
			(87,'SRequirementsCards','u_yf_srequirementscards','subject','srequirementscardsid','srequirementscardsid','subject',1,0,NULL),
			(88,'SCalculations','u_yf_scalculations','subject','scalculationsid','scalculationsid','subject',1,0,NULL),
			(89,'SQuotes','u_yf_squotes','subject','squotesid','squotesid','subject',1,0,NULL),
			(90,'SSingleOrders','u_yf_ssingleorders','subject','ssingleordersid','ssingleordersid','subject',1,0,NULL),
			(91,'SRecurringOrders','u_yf_srecurringorders','subject','srecurringordersid','srecurringordersid','subject',1,0,NULL),
			(92,'Partners','u_yf_partners','subject','partnersid','partnersid','subject',1,0,NULL),
			(93,'Competition','u_yf_competition','subject','competitionid','competitionid','subject',1,0,NULL),
			(94,'FBookkeeping','u_yf_fbookkeeping','subject','fbookkeepingid','fbookkeepingid','subject',1,0,NULL),
			(95,'FInvoice','u_yf_finvoice','subject','finvoiceid','finvoiceid','subject',1,0,NULL),
			(96,'KnowledgeBase','u_yf_knowledgebase','subject','knowledgebaseid','knowledgebaseid','subject',1,0,NULL),
			(97,'IStorages','u_yf_istorages','subject','istorageid','istorageid','subject',1,0,NULL),
			(98,'IGRN','u_yf_igrn','subject','igrnid','igrnid','subject',1,0,NULL),
			(99,'FInvoiceProforma','u_yf_finvoiceproforma','subject','finvoiceproformaid','finvoiceproformaid','subject',1,0,NULL),
			(100,'IGDN','u_yf_igdn','subject','igdnid','igdnid','subject',1,0,NULL),
			(101,'IIDN','u_yf_iidn','subject','iidnid','iidnid','subject',1,0,NULL),
			(102,'IGIN','u_yf_igin','subject','iginid','iginid','subject',1,0,NULL),
			(103,'IPreOrder','u_yf_ipreorder','subject','ipreorderid','ipreorderid','subject',1,0,NULL),
			(104,'ISTDN','u_yf_istdn','subject','istdnid','istdnid','subject',1,0,NULL),
			(105,'ISTN','u_yf_istn','subject','istnid','istnid','subject',1,0,NULL),
			(106,'ISTRN','u_yf_istrn','subject','istrnid','istrnid','subject',1,0,NULL),
			(107,'FCorectingInvoice','u_yf_fcorectinginvoice','subject','fcorectinginvoiceid','fcorectinginvoiceid','subject',1,0,NULL),
			(108,'IGRNC','u_yf_igrnc','subject','igrncid','igrncid','subject',1,0,NULL),
			(109,'IGDNC','u_yf_igdnc','subject','igdncid','igdncid','subject',1,0,NULL),
			(111,'Notification','u_yf_notification','title','notificationid','notificationid','title',0,0,NULL),
			(112,'EmailTemplates','u_yf_emailtemplates','name','emailtemplatesid','emailtemplatesid','name',1,0,NULL),
			(113,'CFixedAssets','u_yf_cfixedassets','subject','cfixedassetsid','cfixedassetsid','subject',1,0,NULL),
			(114,'CInternalTickets','u_yf_cinternaltickets','subject','cinternalticketsid','cinternalticketsid','subject',1,0,NULL),
			(115,'FInvoiceCost','u_yf_finvoicecost','subject','finvoicecostid','finvoicecostid','subject',1,0,NULL),
			(116,'CMileageLogbook','u_yf_cmileagelogbook','subject','cmileagelogbookid','cmileagelogbookid','subject',1,0,NULL),
			(117,'SVendorEnquiries','u_yf_svendorenquiries','subject','svendorenquiriesid','svendorenquiriesid','subject',1,0,NULL),
			(119,'MultiCompany','u_yf_multicompany','company_name','multicompanyid','multicompanyid','company_name',1,0,NULL),
			(121,'DataSetRegister','u_yf_datasetregister','subject','datasetregisterid','datasetregisterid','subject',1,0,NULL),
			(122,'ActivityRegister','u_yf_activityregister','subject','activityregisterid','activityregisterid','subject',1,0,NULL),
			(123,'LocationRegister','u_yf_locationregister','name','locationregisterid','locationregisterid','name',1,0,NULL),
			(124,'IncidentRegister','u_yf_incidentregister','name','incidentregisterid','incidentregisterid','name',1,0,NULL),
			(125,'AuditRegister','u_yf_auditregister','name','auditregisterid','auditregisterid','name',1,0,NULL),
			(127,'Approvals','u_yf_approvals','name','approvalsid','approvalsid','name',1,0,NULL),
			(128,'ApprovalsRegister','u_yf_approvalsregister','subject','approvalsregisterid','approvalsregisterid','subject',0,0,NULL),
			(130,'Locations','u_yf_locations','subject','locationsid','locationsid','subject',1,0,NULL),
			(131,'Occurrences','u_yf_occurrences','topic','occurrencesid','Occurrences','topic',1,0,NULL),
			(132,'ProductCategory','u_yf_productcategory','category','productcategoryid','productcategoryid','category',1,0,NULL),
			(133,'BankAccounts','u_yf_bankaccounts','name','bankaccountsid','bankaccountsid','name',1,0,NULL),
			(134,'Queue','u_yf_queue','subject','queueid','queueid','subject',0,0,NULL),
			(135,'Passwords','u_yf_passwords','subject','passwordsid','passwordsid','subject',0,0,NULL),
			(136,'SMSTemplates','u_yf_smstemplates','subject','smstemplatesid','smstemplatesid','subject',0,0,NULL),
			(138,'ReportTemplate','u_yf_report_template','name','id','id','name',0,0,NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_eventhandlers`(`eventhandler_id`,`event_name`,`handler_class`,`is_active`,`include_modules`,`exclude_modules`,`priority`,`owner_id`,`privileges`) values
			(1,'EntityAfterDelete','Vtiger_Workflow_Handler',1,'','',5,0,0),
			(3,'EntityAfterSave','Vtiger_Workflow_Handler',1,'','',5,0,0),
			(4,'EntityChangeState','Vtiger_Workflow_Handler',1,'','',5,0,0),
			(5,'UserAfterSave','Vtiger_Workflow_Handler',1,'Users','',4,0,0),
			(6,'EntityAfterLink','ModTracker_ModTrackerHandler_Handler',1,'','',8,32,0),
			(7,'EntityAfterUnLink','ModTracker_ModTrackerHandler_Handler',1,'','',8,32,0),
			(8,'EntityChangeState','ModTracker_ModTrackerHandler_Handler',1,'','',8,32,0),
			(9,'EntityAfterTransferLink','ModTracker_ModTrackerHandler_Handler',1,'','',8,32,0),
			(10,'EntityAfterTransferUnLink','ModTracker_ModTrackerHandler_Handler',1,'','',8,32,0),
			(11,'EntityAfterSave','ModTracker_ModTrackerHandler_Handler',1,'','',8,32,0),
			(12,'EntityAfterShowHiddenData','ModTracker_ModTrackerHandler_Handler',1,'','',5,32,0),
			(13,'EntityAfterDelete','ModTracker_ModTrackerHandler_Handler',1,'','',5,32,0),
			(14,'DetailViewBefore','ModTracker_ModTrackerHandler_Handler',1,'','',8,32,0),
			(15,'InventoryRecordDetails','Products_InventoryRecordDetails_Handler',1,'Products,Services','',5,0,0),
			(16,'EntityAfterSave','ServiceContracts_ServiceContractsHandler_Handler',1,'HelpDesk,ServiceContracts','',5,34,1),
			(22,'PicklistAfterRename','Settings_Picklist_PickListHandler_Handler',1,'','',5,0,0),
			(23,'PicklistAfterDelete','Settings_Picklist_PickListHandler_Handler',1,'','',5,0,0),
			(25,'EntityAfterSave','OSSTimeControl_TimeControl_Handler',1,'OSSTimeControl','',3,51,0),
			(32,'EntityAfterUnLink','OSSTimeControl_TimeControl_Handler',1,'OSSTimeControl','',5,51,0),
			(33,'EntityChangeState','OSSTimeControl_TimeControl_Handler',1,'OSSTimeControl','',3,51,0),
			(34,'EntityAfterSave','API_CardDAV_Handler',1,'Contacts,OSSEmployees','',3,0,0),
			(35,'EntityAfterSave','API_CalDAV_Handler',1,'Calendar','',3,0,0),
			(38,'EntityAfterSave','ProjectTask_ProjectTaskHandler_Handler',1,'ProjectTask','',3,42,0),
			(39,'EntityChangeState','ProjectTask_ProjectTaskHandler_Handler',1,'ProjectTask','',5,42,0),
			(40,'EntityAfterDelete','ProjectTask_ProjectTaskHandler_Handler',1,'ProjectTask','',5,42,0),
			(44,'EntityBeforeSave','Calendar_CalendarHandler_Handler',1,'Calendar,Events,Activity','',5,9,0),
			(45,'EntityAfterLink','Vtiger_MultiReferenceUpdater_Handler',1,'','',5,0,0),
			(46,'EntityAfterUnLink','Vtiger_MultiReferenceUpdater_Handler',1,'','',5,0,0),
			(48,'EntityAfterDelete','OSSTimeControl_TimeControl_Handler',1,'OSSTimeControl','',5,51,0),
			(49,'EntityAfterUnLink','Calendar_CalendarHandler_Handler',1,'Calendar,Events,Activity','',5,9,0),
			(50,'EntityAfterSave','Calendar_CalendarHandler_Handler',1,'Calendar,Events,Activity','',3,9,0),
			(51,'EntityChangeState','Calendar_CalendarHandler_Handler',1,'Calendar,Events,Activity','',5,9,0),
			(52,'EntityAfterSave','IStorages_RecalculateStockHandler_Handler',1,'IGRN,IIDN,IGDN,IGIN,IPreOrder,ISTDN,ISTRN,IGRNC,IGDNC','',3,97,0),
			(54,'EntityAfterSave','OpenStreetMap_OpenStreetMapHandler_Handler',1,'Accounts,Leads,Partners,Vendors,Competition,Contacts,Locations','',3,110,0),
			(55,'EntitySystemAfterCreate','Vtiger_AutomaticAssignment_Handler',0,'','',5,0,0),
			(57,'EntityAfterSave','Vtiger_MultiReferenceUpdater_Handler',1,'','',5,0,0),
			(61,'EntityAfterTransferLink','Vtiger_MultiReferenceUpdater_Handler',1,'','',5,0,0),
			(62,'EntityAfterTransferUnLink','Vtiger_MultiReferenceUpdater_Handler',1,'','',5,0,0),
			(63,'EntityBeforeSave','OSSTimeControl_TimeControl_Handler',1,'OSSTimeControl','',5,51,0),
			(66,'EntityAfterSave','Project_ProjectHandler_Handler',1,'Project,ProjectMilestone','',3,42,0),
			(67,'EntityChangeState','Project_ProjectHandler_Handler',1,'Project,ProjectMilestone','',3,42,0),
			(69,'EntityAfterDelete','API_CardDAV_Handler',1,'Contacts,OSSEmployees','',3,0,0),
			(70,'EntityChangeState','API_CardDAV_Handler',1,'Contacts,OSSEmployees','',3,0,0),
			(71,'EntityAfterDelete','API_CalDAV_Handler',1,'Calendar','',3,0,0),
			(72,'EntityChangeState','API_CalDAV_Handler',1,'Calendar','',3,0,0),
			(73,'EntityBeforeSave','Vtiger_RecordStatusHistory_Handler',1,'HelpDesk','',5,0,0),
			(74,'EntityAfterSave','Vtiger_RecordStatusHistory_Handler',1,'HelpDesk','',5,0,0),
			(75,'EntityBeforeSave','Products_Calculations_Handler',1,'Products,Services','',5,14,0),
			(76,'EntityAfterSave','PaymentsIn_PaymentsInHandler_Handler',1,'PaymentsIn','',5,0,1),
			(77,'EntityAfterSave','Vtiger_RecordFlowUpdater_Handler',1,'Project,ProjectMilestone,ProjectTask','',5,0,1),
			(78,'EntityAfterDelete','Vtiger_RecordFlowUpdater_Handler',1,'Project,ProjectMilestone,ProjectTask','',5,0,1),
			(79,'EntityChangeState','Vtiger_RecordFlowUpdater_Handler',1,'Project,ProjectMilestone,ProjectTask','',5,0,1),
			(80,'EntityAfterSave','ApprovalsRegister_Approvals_Handler',1,'ApprovalsRegister','',5,128,0),
			(81,'EditViewPreSave','Contacts_DuplicateEmail_Handler',1,'Contacts,Accounts','',5,4,1),
			(82,'EntityAfterSave','Vtiger_Files_Handler',1,'','',5,0,0),
			(83,'EditViewPreSave','Accounts_DuplicateVatId_Handler',1,'Accounts','',5,6,1),
			(84,'EditViewPreSave','Products_DuplicateEan_Handler',1,'Products','',5,14,1),
			(85,'EntityBeforeSave','SSalesProcesses_Finances_Handler',1,'SSalesProcesses','',5,86,0),
			(86,'IStoragesAfterUpdateStock','IStorages_RecalculateStockHandler_Handler',0,'','',5,0,0),
			(87,'EditViewPreSave','IGDNC_IgdnExist_Handler',1,'IGDNC','',5,109,1),
			(88,'EditViewPreSave','IGRNC_IgrnExist_Handler',1,'IGRNC','',5,108,1),
			(89,'EntityBeforeSave','Vtiger_Meetings_Handler',1,'Calendar,Occurrences','',5,0,0),
			(90,'EditViewPreSave','OSSTimeControl_TimeControl_Handler',1,'OSSTimeControl','',5,51,1),
			(92,'UsersAfterLogin','App\\Extension\\PwnedPassword',1,'Users','',4,0,1),
			(93,'UsersAfterPasswordChange','App\\Extension\\PwnedPassword',1,'Users','',4,0,1),
			(94,'EntityAfterSave','Queue_Queue_Handler',1,'Queue','',5,134,0),
			(95,'EntityBeforeSave','Vtiger_AutoFillIban_Handler',0,'','',5,0,1),
			(96,'EntityAfterSave','Approvals_Approvals_Handler',1,'Approvals','',5,127,1),
			(97,'EditViewPreSave','Calendar_VerifyIsHolidayDate_Handler',1,'Calendar','',5,9,1),
			(98,'EditViewPreSave','FInvoice_CheckingQuantityAvailableProduct_Handler',0,'FInvoice','',5,95,1),
			(99,'EntityBeforeSave','SMSNotifier_Parser_Handler',1,'SMSNotifier','',5,45,1),
			(101,'EntityAfterSave','Vtiger_UpdateMapCoordinates_Handler',1,'Locations','',5,0,0),
			(103,'EntityAfterSave','Products_UpdateModifiedTime_Handler',0,'Products','',9,14,0),
			(106,'EditViewPreSave','Reservations_DuplicateChecker_Handler',1,'Reservations','',5,84,1),
			(109,'EditViewPreSave','Calendar_RepeatEvents_Handler',1,'Calendar','',5,9,1),
			(110,'PreDelete','Calendar_RepeatEvents_Handler',1,'Calendar','',5,9,1),
			(111,'PreStateChange','Calendar_RepeatEvents_Handler',1,'Calendar','',5,9,1),
			(112,'EditViewPreSave','Accounts_DuplicateShortName_Handler',1,'Accounts','',5,6,1),
			(113,'PreDelete','Products_CheckLinks_Handler',1,'Products,Services','',5,14,0),
			(114,'PreStateChange','Products_CheckLinks_Handler',1,'Products,Services','',5,14,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_expectedresponse`(`expectedresponseid`,`expectedresponse`,`presence`,`picklist_valueid`,`sortorderid`) values
			(2,'Excellent',1,42,1),
			(3,'Good',1,43,2),
			(4,'Average',1,44,3),
			(5,'Poor',1,45,4);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_faqstatus`(`faqstatus_id`,`faqstatus`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Draft',0,47,0),
			(2,'Reviewed',0,48,1),
			(3,'Published',0,49,2),
			(4,'Obsolete',0,50,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_fcorectinginvoice_status`(`fcorectinginvoice_statusid`,`fcorectinginvoice_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'None',1,692,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_field`(`tabid`,`fieldid`,`columnname`,`tablename`,`generatedtype`,`uitype`,`fieldname`,`fieldlabel`,`readonly`,`presence`,`defaultvalue`,`maximumlength`,`sequence`,`block`,`displaytype`,`typeofdata`,`quickcreate`,`quickcreatesequence`,`info_type`,`masseditable`,`helpinfo`,`summaryfield`,`fieldparams`,`header_field`,`maxlengthtext`,`maxwidthcolumn`,`visible`,`tabindex`,`color`,`icon`) values
			(6,1,'accountname','vtiger_account',1,12,'accountname','Account Name',0,0,'','255',3,9,1,'V~M',0,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(6,2,'account_no','vtiger_account',1,4,'account_no','Account No',0,0,'','100',1,194,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,3,'phone','vtiger_account',1,11,'phone','Phone',0,2,'','30',2,195,1,'V~O',2,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(6,4,'website','vtiger_account',1,17,'website','Website',0,2,'','255',5,195,1,'V~O',2,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(6,5,'fax','vtiger_account',1,11,'fax','Fax',0,2,'','30',6,195,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,7,'otherphone','vtiger_account',1,11,'otherphone','Other Phone',0,2,'','30',4,195,1,'V~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,8,'parentid','vtiger_account',1,51,'account_id','Member Of',0,2,'','-2147483648,2147483647',5,9,1,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,9,'email1','vtiger_account',1,13,'email1','Email',0,2,'','100',1,195,1,'E~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(6,10,'employees','vtiger_account',1,7,'employees','Employees',0,2,'','0,4294967295',4,196,1,'I~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,11,'email2','vtiger_account',1,13,'email2','Other Email',0,2,'','100',3,195,1,'E~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,14,'industry','vtiger_account',1,15,'industry','industry',0,2,'','200',2,9,1,'V~O',1,NULL,'ADV',1,'',1,'','',0,0,0,0,'',NULL),
			(6,15,'siccode','vtiger_account',1,1,'siccode','SIC Code',0,2,'','255',7,194,1,'V~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,16,'account_type','vtiger_account',1,15,'accounttype','Type',0,2,'','200',7,9,1,'V~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,17,'annualrevenue','vtiger_account',1,71,'annual_revenue','Annual Revenue',0,2,'','1.0E+20',5,194,1,'N~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,18,'emailoptout','vtiger_account',1,56,'emailoptout','Approval for email',0,2,'','-32768,32767',7,195,1,'C~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,20,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',6,9,1,'V~M',0,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(6,21,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,7,196,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,22,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,8,196,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,23,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',11,9,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,36,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,12,1,'V~O',1,NULL,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(7,39,'lead_no','vtiger_leaddetails',1,4,'lead_no','Lead No',0,0,'','100',6,14,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,40,'phone','vtiger_leadaddress',1,11,'phone','Phone',0,2,'','50',1,150,1,'V~O',2,9,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(7,41,'lastname','vtiger_leaddetails',1,2,'lastname','Short name',0,1,'','80',2,13,1,'V~O',0,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(7,42,'mobile','vtiger_leadaddress',1,11,'mobile','Mobile',0,2,'','50',3,150,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,43,'company','vtiger_leaddetails',1,2,'company','Company',0,2,'','100',1,13,1,'V~M',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(7,44,'fax','vtiger_leadaddress',1,11,'fax','Fax',0,2,'','50',5,150,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,46,'email','vtiger_leaddetails',1,13,'email','Email',0,2,'','100',2,150,1,'E~O',2,8,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(7,47,'leadsource','vtiger_leaddetails',1,15,'leadsource','Lead Source',0,2,'','200',2,14,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(7,48,'website','vtiger_leadsubdetails',1,17,'website','Website',0,2,'','255',6,150,1,'V~O',1,NULL,'ADV',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(7,49,'industry','vtiger_leaddetails',1,15,'industry','Industry',0,2,'','200',6,13,1,'V~O',1,NULL,'ADV',1,'',1,'','',0,0,0,0,'',NULL),
			(7,50,'leadstatus','vtiger_leaddetails',1,15,'leadstatus','Lead Status',0,2,'','50',2,13,1,'V~M',2,3,'BAS',1,'',1,'','{\"type\":\"progress\"}',0,0,0,0,'',NULL),
			(7,51,'annualrevenue','vtiger_leaddetails',1,71,'annualrevenue','Annual Revenue',0,2,'','1.0E+20',5,191,1,'N~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,53,'noofemployees','vtiger_leaddetails',1,1,'noofemployees','No Of Employees',0,2,'','0,4294967295',8,13,1,'I~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,54,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',3,13,1,'V~M',0,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(7,55,'secondaryemail','vtiger_leaddetails',1,13,'secondaryemail','Secondary Email',0,2,'','100',4,150,1,'E~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,56,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,8,14,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,57,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,5,14,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,58,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',23,13,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,65,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,16,1,'V~O',1,NULL,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(4,66,'salutation','vtiger_contactdetails',1,15,'salutationtype','Salutation',0,2,'','200',1,4,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,67,'firstname','vtiger_contactdetails',1,1,'firstname','First Name',0,0,'','40',1,4,1,'V~O',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(4,68,'contact_no','vtiger_contactdetails',1,4,'contact_no','Contact Id',0,0,'','100',2,4,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,69,'phone','vtiger_contactdetails',1,11,'phone','Office Phone',0,2,'','50',1,197,1,'V~O',2,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(4,70,'lastname','vtiger_contactdetails',1,255,'lastname','Last Name',0,0,'','80',3,4,1,'V~M',0,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(4,71,'mobile','vtiger_contactdetails',1,11,'mobile','Mobile',0,2,'','50',3,197,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,72,'parentid','vtiger_contactdetails',1,10,'parent_id','Member Of',0,2,'','-2147483648,2147483647',4,4,1,'I~O',2,5,'BAS',1,'',1,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(4,74,'leadsource','vtiger_contactsubdetails',1,15,'leadsource','Lead Source',0,2,'','200',5,4,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,79,'birthday','vtiger_contactsubdetails',1,5,'birthday','Birthdate',0,2,'',NULL,1,5,1,'D~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,80,'email','vtiger_contactdetails',1,13,'email','Email',0,2,'','100',2,197,1,'E~O',2,3,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(4,81,'reportsto','vtiger_contactdetails',1,57,'contact_id','Reports To',0,2,'','-2147483648,2147483647',2,5,1,'V~O',1,NULL,'ADV',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,85,'donotcall','vtiger_contactdetails',1,56,'donotcall','Approval for phone calls',0,2,'','-32768,32767',5,197,1,'C~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,86,'emailoptout','vtiger_contactdetails',1,56,'emailoptout','Approval for email',0,2,'','-32768,32767',6,197,1,'C~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,87,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',6,4,1,'V~M',2,6,'BAS',1,'',1,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(4,90,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,7,5,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,91,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,6,5,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,92,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',28,4,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,93,'portal','vtiger_customerdetails',1,56,'portal','Portal User',0,2,'','-32768,32767',1,6,1,'C~O',1,NULL,'ADV',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,108,'imagename','vtiger_contactdetails',1,69,'imagename','Contact Image',0,2,'','65535',1,73,1,'V~O',3,NULL,'ADV',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,109,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,8,1,'V~O',1,NULL,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(26,126,'campaignname','vtiger_campaign',1,2,'campaignname','Campaign Name',0,0,'','255',1,74,1,'V~M',0,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(26,127,'campaign_no','vtiger_campaign',1,4,'campaign_no','Campaign No',0,0,'','100',2,74,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,128,'campaigntype','vtiger_campaign',1,15,'campaigntype','Campaign Type',0,2,'','200',5,74,1,'V~O',2,3,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(26,129,'product_id','vtiger_campaign',1,59,'product_id','Product',0,2,'','-2147483648,2147483647',8,74,1,'I~O',2,5,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,130,'campaignstatus','vtiger_campaign',1,15,'campaignstatus','FL_CAMPAIGN_STATUS',0,2,'','200',6,74,1,'V~O',2,6,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(26,131,'closingdate','vtiger_campaign',1,23,'closingdate','Expected Close Date',0,2,'',NULL,10,74,1,'D~M',2,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(26,132,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',3,74,1,'V~M',0,7,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(26,133,'numsent','vtiger_campaign',1,9,'numsent','Num Sent',0,2,'','0,99999999999',14,74,1,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,134,'sponsor','vtiger_campaign',1,1,'sponsor','Sponsor',0,2,'','255',9,74,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,135,'targetaudience','vtiger_campaign',1,1,'targetaudience','Target Audience',0,2,'','255',7,74,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,136,'targetsize','vtiger_campaign',1,1,'targetsize','TargetSize',0,2,'','0,4294967295',12,74,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,137,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,11,74,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,138,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,13,74,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,139,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',16,74,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,140,'expectedresponse','vtiger_campaign',1,15,'expectedresponse','Expected Response',0,2,'','200',3,76,1,'V~O',2,4,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,141,'expectedrevenue','vtiger_campaign',1,71,'expectedrevenue','Expected Revenue',0,2,'','0,1.0E+20',4,76,1,'N~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(26,142,'budgetcost','vtiger_campaign',1,71,'budgetcost','Budget Cost',0,2,'','0,1.0E+20',1,76,1,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,143,'actualcost','vtiger_campaign',1,71,'actualcost','Actual Cost',0,2,'','0,1.0E+20',2,76,1,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,144,'expectedresponsecount','vtiger_campaign',1,1,'expectedresponsecount','Expected Response Count',0,2,'','0,4294967295',7,76,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,145,'expectedsalescount','vtiger_campaign',1,1,'expectedsalescount','Expected Sales Count',0,2,'','0,4294967295',5,76,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,146,'expectedroi','vtiger_campaign',1,71,'expectedroi','Expected ROI',0,2,'','0,1.0E+20',9,76,1,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,147,'actualresponsecount','vtiger_campaign',1,1,'actualresponsecount','Actual Response Count',0,2,'','0,4294967295',8,76,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,148,'actualsalescount','vtiger_campaign',1,1,'actualsalescount','Actual Sales Count',0,2,'','0,4294967295',6,76,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,149,'actualroi','vtiger_campaign',1,71,'actualroi','Actual ROI',0,2,'','0,1.0E+20',10,76,1,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,150,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,81,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,155,'ticket_no','vtiger_troubletickets',1,4,'ticket_no','Ticket No',0,0,'','100',9,27,2,'V~O',3,NULL,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(13,156,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',4,25,1,'V~M',0,7,'BAS',1,'',1,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(13,157,'parent_id','vtiger_troubletickets',1,10,'parent_id','Related To',0,2,'','-2147483648,2147483647',3,25,1,'I~M',2,2,'BAS',1,'',1,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(13,158,'priority','vtiger_troubletickets',1,15,'ticketpriorities','Priority',0,2,'Low','200',3,27,1,'V~O',2,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(13,159,'product_id','vtiger_troubletickets',1,10,'product_id','Product Name',0,2,'','-2147483648,2147483647',7,27,10,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,160,'severity','vtiger_troubletickets',1,15,'ticketseverities','Severity',0,2,'','200',4,27,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(13,161,'status','vtiger_troubletickets',1,15,'ticketstatus','Status',0,2,'Open','200',2,25,1,'V~M',2,4,'BAS',1,'',1,'{\"isProcessStatusField\":true}','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(13,162,'category','vtiger_troubletickets',1,302,'ticketcategories','Category',0,2,'','200',2,27,1,'V~O',1,NULL,'BAS',1,'',1,'17','',0,0,0,0,'',NULL),
			(13,163,'update_log','vtiger_troubletickets',1,19,'update_log','Update History',0,0,'','65535',5,25,3,'V~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,166,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,10,27,2,'DT~O',3,NULL,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(13,167,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,12,27,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,168,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',14,27,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,169,'title','vtiger_troubletickets',1,22,'ticket_title','Title',0,0,'','255',1,25,1,'V~M',0,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(13,170,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,28,1,'V~O',2,6,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(13,171,'solution','vtiger_troubletickets',1,300,'solution','Solution',0,0,'','65535',1,29,1,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,173,'productname','vtiger_products',1,2,'productname','Product Name',0,0,'','100',1,31,1,'V~M',0,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(14,174,'product_no','vtiger_products',1,4,'product_no','Product No',0,0,'','100',2,31,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,175,'productcode','vtiger_products',1,1,'productcode','Part Number',0,2,'','40',4,31,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,176,'discontinued','vtiger_products',1,56,'discontinued','Product Active',0,2,'','-128,127',3,31,1,'V~O',2,2,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,177,'manufacturer','vtiger_products',1,15,'manufacturer','Manufacturer',0,2,'','200',6,31,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,178,'pscategory','vtiger_products',1,302,'pscategory','Product Category',0,2,'','200',6,31,1,'V~O',2,5,'BAS',1,'',1,'2',NULL,0,0,0,0,'',NULL),
			(14,179,'sales_start_date','vtiger_products',1,5,'sales_start_date','Sales Start Date',0,2,'',NULL,5,31,1,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,180,'sales_end_date','vtiger_products',1,5,'sales_end_date','Sales End Date',0,2,NULL,NULL,8,31,1,'D~O~OTH~GE~sales_start_date~Sales Start Date',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,181,'start_date','vtiger_products',1,5,'start_date','Support Start Date',0,2,'',NULL,7,31,1,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,182,'expiry_date','vtiger_products',1,5,'expiry_date','Support Expiry Date',0,2,'',NULL,10,31,1,'D~O~OTH~GE~start_date~Start Date',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,183,'website','vtiger_products',1,17,'website','Website',0,2,'','255',14,31,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,184,'vendor_id','vtiger_products',1,75,'vendor_id','Vendor Name',0,2,'','-2147483648,2147483647',13,31,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,185,'mfr_part_no','vtiger_products',1,1,'mfr_part_no','Mfr PartNo',0,2,'','200',16,31,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,186,'vendor_part_no','vtiger_products',1,1,'vendor_part_no','Vendor PartNo',0,2,'','200',15,31,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,187,'serialno','vtiger_products',1,1,'serial_no','Serial No',0,2,'','200',18,31,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,188,'productsheet','vtiger_products',1,1,'productsheet','Product Sheet',0,2,'','200',17,31,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,189,'glacct','vtiger_products',1,15,'glacct','GL Account',0,2,'','200',20,31,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,190,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,19,31,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,191,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,21,31,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,192,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',22,31,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,193,'unit_price','vtiger_products',1,360,'unit_price','Unit Price',0,0,'','0,99999999',1,32,1,'V~O',2,3,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(14,194,'commissionrate','vtiger_products',1,365,'commissionrate','Commission Rate',0,2,'','999999',2,32,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,196,'usageunit','vtiger_products',1,15,'usageunit','Usage Unit',0,2,'','200',1,33,1,'V~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,197,'qty_per_unit','vtiger_products',1,1,'qty_per_unit','Qty/Unit',0,2,'','999999999',2,33,1,'N~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,198,'qtyinstock','vtiger_products',1,1,'qtyinstock','Qty In Stock',0,2,'','1.0E+22',3,33,10,'NN~O',0,7,'ADV',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(14,199,'reorderlevel','vtiger_products',1,1,'reorderlevel','Reorder Level',0,2,'','-2147483648,2147483647',4,33,1,'I~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,200,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Handler',0,2,'','65535',5,33,1,'V~M',2,4,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,201,'qtyindemand','vtiger_products',1,1,'qtyindemand','Qty In Demand',0,2,'','-2147483648,2147483647',6,33,1,'I~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,202,'imagename','vtiger_products',1,311,'imagename','Product Image',0,2,'','65535',1,35,1,'V~O',3,NULL,'ADV',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,203,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,36,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(8,204,'title','vtiger_notes',1,2,'notes_title','Title',0,0,'','200',1,17,1,'V~M',0,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(8,205,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,5,17,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(8,206,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,8,17,2,'DT~O',3,NULL,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(8,207,'filename','vtiger_notes',1,28,'filename','File Name',0,2,'','400',3,18,1,'V~O',0,2,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(8,208,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',4,17,1,'V~M',0,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(8,209,'notecontent','vtiger_notes',1,300,'notecontent','Note',0,2,'','65535',1,84,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(8,210,'filetype','vtiger_notes',1,1,'filetype','File Type',0,2,'','100',5,18,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(8,211,'filesize','vtiger_notes',1,1,'filesize','File Size',0,2,'','-2147483648,2147483647',4,18,2,'I~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(8,212,'filelocationtype','vtiger_notes',1,27,'filelocationtype','Download Type',0,0,'','5',1,18,1,'V~O',0,4,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(8,213,'fileversion','vtiger_notes',1,1,'fileversion','Version',0,2,'','50',6,18,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(8,214,'filestatus','vtiger_notes',1,56,'filestatus','Active',0,2,'1','-32768,32767',2,18,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(8,215,'filedownloadcount','vtiger_notes',1,1,'filedownloadcount','Download Count',0,2,'','-2147483648,2147483647',7,18,2,'I~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(8,216,'folderid','vtiger_notes',1,302,'folderid','Folder Name',0,2,'T1','255',2,17,1,'V~O',2,3,'BAS',1,'',1,'1',NULL,0,0,0,0,'',NULL),
			(8,217,'note_no','vtiger_notes',1,4,'note_no','Document No',0,0,'','100',3,17,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(8,218,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',12,17,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,231,'subject','vtiger_activity',1,2,'subject','Subject',0,0,'','100',1,19,1,'V~M',0,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(9,232,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',2,19,1,'V~M',0,6,'BAS',1,'',1,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(9,233,'date_start','vtiger_activity',1,6,'date_start','Start Date & Time',0,0,'',NULL,3,19,1,'DT~M~time_start',0,3,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(9,234,'time_start','vtiger_activity',1,14,'time_start','Time Start',0,0,'',NULL,4,19,3,'T~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(9,235,'time_end','vtiger_activity',1,14,'time_end','End Time',0,0,'',NULL,4,19,3,'T~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(9,236,'due_date','vtiger_activity',1,23,'due_date','Due Date & Time',0,0,'',NULL,5,19,1,'D~M~OTH~GE~date_start~Start Date & Time',1,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(9,237,'process','vtiger_activity',1,66,'process','FL_PROCESS',0,0,'','-2147483648,2147483647',2,87,1,'I~O',2,9,'BAS',1,'',1,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(9,238,'link','vtiger_activity',1,67,'link','FL_RELATION',0,0,'','-2147483648,2147483647',1,87,1,'I~O',2,8,'BAS',1,'',1,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(9,239,'status','vtiger_activity',1,15,'activitystatus','Status',0,0,'PLL_PLANNED','200',9,19,10,'V~O',1,2,'BAS',2,'',1,'','',0,0,0,0,'',NULL),
			(9,241,'priority','vtiger_activity',1,15,'taskpriority','Priority',0,0,'Low','200',10,19,1,'V~O',1,NULL,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(9,242,'sendnotification','vtiger_activity',1,56,'sendnotification','Send Notification',0,0,'','-32768,32767',11,19,1,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,243,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,14,19,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,244,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,13,19,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,245,'activitytype','vtiger_activity',1,16,'activitytype','Activity Type',0,0,'','200',16,19,1,'V~M',0,1,'BAS',1,'',1,'{\"hideLabel\":[\"EventForm\",\"QuickCreateAjax\"]}',NULL,0,0,0,0,'',NULL),
			(9,246,'visibility','vtiger_activity',1,16,'visibility','Visibility',0,0,'Private','50',17,19,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,247,'description','vtiger_crmentity',1,19,'description','Description',0,0,'','65535',1,20,1,'V~O',1,NULL,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(9,248,'duration_hours','vtiger_activity',1,63,'duration_hours','Duration',0,0,'','-32768,32767',17,19,3,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,249,'duration_minutes','vtiger_activity',1,16,'duration_minutes','Duration Minutes',0,0,'','3',18,19,3,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,250,'location','vtiger_activity',1,1,'location','Location',0,0,'','150',19,19,1,'V~O',1,NULL,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(9,251,'reminder_time','vtiger_activity_reminder',1,30,'reminder_time','Send Reminder',0,0,'',NULL,1,40,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,253,'notime','vtiger_activity',1,56,'notime','No Time',0,0,'','-32768,32767',20,19,3,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,254,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',22,19,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(15,278,'product_id','vtiger_faq',1,10,'product_id','Product Name',0,2,'','-2147483648,2147483647',7,37,1,'I~O',3,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(15,279,'faq_no','vtiger_faq',1,4,'faq_no','Faq No',0,0,'','100',1,38,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(15,281,'status','vtiger_faq',1,15,'faqstatus','FL_STATUS',0,2,'','200',5,37,1,'V~M',3,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(15,285,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,2,38,2,'DT~O',3,NULL,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(15,286,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,4,38,2,'DT~O',3,NULL,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(15,287,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',6,38,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,288,'vendorname','vtiger_vendor',1,2,'vendorname','Vendor Name',0,0,'','255',1,42,1,'V~M',0,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(18,289,'vendor_no','vtiger_vendor',1,4,'vendor_no','Vendor No',0,0,'','100',2,42,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,290,'phone','vtiger_vendor',1,11,'phone','Phone',0,2,'','100',4,42,1,'V~O',2,3,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(18,291,'email','vtiger_vendor',1,13,'email','Email',0,2,'','100',3,42,1,'E~O',2,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(18,292,'website','vtiger_vendor',1,17,'website','Website',0,2,'','255',6,42,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,293,'glacct','vtiger_vendor',1,15,'glacct','GL Account',0,2,'','200',5,42,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,294,'category','vtiger_vendor',1,1,'category','Category',0,2,'','50',8,42,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(18,295,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,7,42,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,296,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,9,42,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,297,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',12,42,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,304,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,45,1,'V~O',1,NULL,'ADV',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(19,305,'bookname','vtiger_pricebook',1,2,'bookname','Price Book Name',0,0,'','100',1,46,1,'V~M',0,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(19,306,'pricebook_no','vtiger_pricebook',1,4,'pricebook_no','PriceBook No',0,0,'','100',3,46,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(19,307,'active','vtiger_pricebook',1,56,'active','Active',0,2,'1','-32768,32767',2,46,1,'C~O',2,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(19,308,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,4,46,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(19,309,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,5,46,2,'DT~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(19,310,'currency_id','vtiger_pricebook',1,117,'currency_id','Currency',0,0,'','-2147483648,2147483647',6,46,1,'V~M',0,3,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(19,311,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',7,46,2,'V~O',3,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(19,312,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,48,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,474,'user_name','vtiger_users',1,106,'user_name','User Name',0,0,'','3,64',1,77,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,475,'is_admin','vtiger_users',1,156,'is_admin','Admin',0,0,'','3',2,77,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,476,'user_password','vtiger_users',1,99,'user_password','Password',0,0,'','100',7,77,4,'P~M',1,NULL,'BAS',1,'Edit,Detail',0,'{\"validate\":[\"pwned\",\"config\"],\"auto-generate\":true,\"strengthMeter\":true}',NULL,0,0,0,0,'',NULL),
			(29,477,'confirm_password','vtiger_users',1,99,'confirm_password','Confirm Password',0,0,'','100',8,77,4,'P~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,478,'first_name','vtiger_users',1,1,'first_name','First Name',0,0,'','30',3,77,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,479,'last_name','vtiger_users',1,2,'last_name','Last Name',0,0,'','30',4,77,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,480,'roleid','vtiger_user2role',1,98,'roleid','Role',0,0,'','255',5,77,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,481,'email1','vtiger_users',1,104,'email1','Email',0,0,'','100',1,468,1,'E~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,482,'status','vtiger_users',1,115,'status','Status',0,0,'Active','25',6,77,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,483,'activity_view','vtiger_users',1,16,'activity_view','Default Activity View',0,0,'This Month','200',5,118,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,485,'hour_format','vtiger_users',1,16,'hour_format','Calendar Hour Format',0,0,'24','30',2,118,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,487,'start_hour','vtiger_users',1,16,'start_hour','Day starts at',0,0,'08:00','30',1,469,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,492,'reports_to_id','vtiger_users',1,101,'reports_to_id','Reports To',0,0,'','4294967295',3,79,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,498,'date_format','vtiger_users',1,16,'date_format','Date Format',0,0,'yyyy-mm-dd','200',1,118,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,500,'description','vtiger_users',1,21,'description','Description',0,0,'','65535',2,79,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,501,'user_pbx','vtiger_users',1,86,'user_pbx','FL_USER_PBX',0,2,'','-32768,32767',0,80,1,'I~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(29,506,'accesskey','vtiger_users',1,3,'accesskey','Webservice Access Key',0,0,'','36',4,453,2,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,507,'time_zone','vtiger_users',1,16,'time_zone','Time Zone',0,0,'','200',3,118,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,508,'currency_id','vtiger_users',1,117,'currency_id','Currency',0,0,'','-2147483648,2147483647',1,78,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,509,'currency_grouping_pattern','vtiger_users',1,16,'currency_grouping_pattern','Digit Grouping Pattern',0,0,'123,456,789','100',5,78,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,510,'currency_decimal_separator','vtiger_users',1,16,'currency_decimal_separator','Decimal Separator',0,0,'.','2',2,78,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,511,'currency_grouping_separator','vtiger_users',1,16,'currency_grouping_separator','Digit Grouping Separator',0,0,' ','2',6,78,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,512,'currency_symbol_placement','vtiger_users',1,16,'currency_symbol_placement','Symbol Placement',0,0,'1.0$','20',3,78,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,513,'imagename','vtiger_users',1,69,'imagename','User Image',0,0,'','65535',6,454,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,514,'internal_mailer','vtiger_users',1,87,'internal_mailer','FL_INTERNAL_MAIL_COMPOSER',0,0,'','255',3,452,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,515,'theme','vtiger_users',1,31,'theme','Theme',0,0,'twilight','100',5,454,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,516,'language','vtiger_users',1,32,'language','Language',0,0,'','36',1,454,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,517,'reminder_interval','vtiger_users',1,16,'reminder_interval','Reminder Interval',0,0,'15 Minutes','100',10,118,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,540,'phone_crm_extension','vtiger_users',1,11,'phone_crm_extension','CRM Phone Extension',0,2,'','100',4,468,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(34,541,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',16,89,1,'V~M',2,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(34,542,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,5,90,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(34,543,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,7,90,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(34,544,'start_date','vtiger_servicecontracts',1,5,'start_date','Start Date',0,2,'',NULL,7,89,1,'D~O',2,4,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(34,545,'end_date','vtiger_servicecontracts',1,5,'end_date','End Date',0,2,'',NULL,11,89,2,'D~O',3,0,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(34,546,'sc_related_to','vtiger_servicecontracts',1,10,'sc_related_to','Related to',0,2,'','-2147483648,2147483647',3,89,1,'V~O',2,6,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(34,547,'tracking_unit','vtiger_servicecontracts',1,15,'tracking_unit','Tracking Unit',0,2,'','100',4,89,1,'V~O',2,7,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(34,548,'total_units','vtiger_servicecontracts',1,7,'total_units','Total Units',0,2,'','0,999',6,89,1,'NN~O',2,8,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(34,549,'used_units','vtiger_servicecontracts',1,7,'used_units','Used Units',0,2,'','999',8,89,10,'NN~O',2,9,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(34,550,'subject','vtiger_servicecontracts',1,1,'subject','Subject',0,0,'','100',1,89,1,'V~M',0,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(34,551,'due_date','vtiger_servicecontracts',1,23,'due_date','Due date',0,2,'',NULL,9,89,1,'D~O',2,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(34,552,'planned_duration','vtiger_servicecontracts',1,1,'planned_duration','Planned Duration',0,2,'','256',13,89,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(34,553,'actual_duration','vtiger_servicecontracts',1,1,'actual_duration','Actual Duration',0,2,'','256',15,89,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(34,554,'contract_status','vtiger_servicecontracts',1,15,'contract_status','Status',0,2,'','200',10,89,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(34,555,'priority','vtiger_servicecontracts',1,15,'contract_priority','Priority',0,2,'Low','200',12,89,1,'V~O',1,NULL,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(34,556,'contract_type','vtiger_servicecontracts',1,15,'contract_type','Type',0,2,'','200',5,89,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(34,557,'progress','vtiger_servicecontracts',1,9,'progress','Progress',0,2,'','999',14,89,2,'N~O~2~2',1,3,'BAS',2,'',1,'','',0,0,0,0,'',NULL),
			(34,558,'contract_no','vtiger_servicecontracts',1,4,'contract_no','Contract No',0,0,'','100',2,89,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(34,559,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',17,89,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,560,'servicename','vtiger_service',1,2,'servicename','Service Name',0,0,'','255',1,91,1,'V~M',0,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(35,561,'service_no','vtiger_service',1,4,'service_no','Service No',0,2,'','100',2,91,2,'V~O',1,0,'BAS',2,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,562,'discontinued','vtiger_service',1,56,'discontinued','Service Active',0,2,'','-128,127',4,91,1,'V~O',2,4,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,563,'sales_start_date','vtiger_service',1,5,'sales_start_date','Sales Start Date',0,2,'',NULL,9,91,1,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,564,'sales_end_date','vtiger_service',1,5,'sales_end_date','Sales End Date',0,2,NULL,NULL,10,91,1,'D~O~OTH~GE~sales_start_date~Sales Start Date',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(35,565,'start_date','vtiger_service',1,5,'start_date','Support Start Date',0,2,'',NULL,11,91,1,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,566,'expiry_date','vtiger_service',1,5,'expiry_date','Support Expiry Date',0,2,'',NULL,12,91,1,'D~O~OTH~GE~start_date~Start Date',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,567,'website','vtiger_service',1,17,'website','Website',0,2,'','255',6,91,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,568,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,13,91,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,569,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,14,91,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,570,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',16,91,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,571,'service_usageunit','vtiger_service',1,15,'service_usageunit','Usage Unit',0,2,'','200',3,91,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,572,'qty_per_unit','vtiger_service',1,1,'qty_per_unit','No of Units',0,2,'','999999999',5,91,1,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,573,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Owner',0,2,'','65535',8,91,1,'I~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(35,574,'pscategory','vtiger_service',1,302,'pscategory','Service Category',0,2,'','200',7,91,1,'V~O',2,3,'BAS',1,'',1,'3',NULL,0,0,0,0,'',NULL),
			(35,575,'unit_price','vtiger_service',1,360,'unit_price','Price',0,0,'','0,99999999',1,92,1,'V~O',2,2,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(35,577,'commissionrate','vtiger_service',1,365,'commissionrate','Commission Rate',0,2,'','999999',2,92,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,578,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,94,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,579,'asset_no','vtiger_assets',1,4,'asset_no','Asset No',0,0,'','30',1,95,2,'V~O',1,0,'BAS',2,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,580,'product','vtiger_assets',1,10,'product','Product Name',0,2,'','-2147483648,2147483647',4,96,1,'V~M',2,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(37,581,'serialnumber','vtiger_assets',1,2,'serialnumber','Serial Number',0,2,'','200',2,95,1,'V~M',0,3,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,582,'datesold','vtiger_assets',1,5,'datesold','Date Sold',0,2,'',NULL,3,192,1,'D~M~OTH~GE~datesold~Date Sold',0,7,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,583,'dateinservice','vtiger_assets',1,5,'dateinservice','Date in Service',0,0,'',NULL,2,192,1,'D~M~OTH~GE~dateinservice~Date in Service',0,9,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,584,'assetstatus','vtiger_assets',1,15,'assetstatus','Status',0,0,'','200',3,95,1,'V~M',2,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(37,589,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',5,96,1,'V~M',2,11,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(37,590,'assetname','vtiger_assets',1,1,'assetname','Asset Name',0,0,'','100',4,95,1,'V~M',0,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(37,593,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,4,192,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,594,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,5,192,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,595,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',16,95,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(40,597,'commentcontent','vtiger_modcomments',1,300,'commentcontent','Comment',0,0,'','65535',4,98,1,'V~M',0,1,'BAS',2,'',1,'',NULL,0,0,0,0,'',NULL),
			(40,598,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',1,99,1,'V~M',0,2,'BAS',2,'',1,'',NULL,0,0,0,0,'',NULL),
			(40,599,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,5,99,2,'DT~O',0,2,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(40,600,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,6,99,2,'DT~O',0,3,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(40,601,'related_to','vtiger_modcomments',1,10,'related_to','Related To',0,2,'','-2147483648,2147483647',2,99,1,'V~M',2,3,'BAS',2,'',0,'',NULL,0,0,0,0,'',NULL),
			(40,602,'smcreatorid','vtiger_crmentity',1,52,'creator','Creator',0,2,'','65535',4,99,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(40,603,'parent_comments','vtiger_modcomments',1,10,'parent_comments','Related To Comments',0,2,'','-2147483648,2147483647',7,99,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(41,604,'projectmilestonename','vtiger_projectmilestone',1,2,'projectmilestonename','Project Milestone Name',0,2,'','255',1,101,1,'V~M',0,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(41,605,'projectmilestonedate','vtiger_projectmilestone',1,5,'projectmilestonedate','Milestone Date',0,2,'',NULL,4,101,1,'D~M',0,3,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(41,606,'projectid','vtiger_projectmilestone',1,10,'projectid','Related to',0,0,'','-2147483648,2147483647',3,101,1,'V~M',0,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(41,607,'projectmilestonetype','vtiger_projectmilestone',1,15,'projectmilestonetype','Type',0,2,'','100',10,101,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(41,608,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',5,101,1,'V~M',0,2,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(41,609,'projectmilestone_no','vtiger_projectmilestone',1,4,'projectmilestone_no','Project Milestone No',0,0,'','100',2,101,2,'V~O',3,4,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(41,610,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,1,102,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(41,611,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,2,102,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(41,612,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',3,102,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(41,613,'description','vtiger_crmentity',1,300,'description','description',0,2,'','65535',1,103,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,614,'projecttaskname','vtiger_projecttask',1,2,'projecttaskname','Project Task Name',0,2,'','255',1,104,1,'V~M',0,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(42,615,'projecttasktype','vtiger_projecttask',1,15,'projecttasktype','Type',0,2,'','100',4,104,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(42,616,'projecttaskpriority','vtiger_projecttask',1,15,'projecttaskpriority','Priority',0,2,'low','100',3,104,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,617,'projectid','vtiger_projecttask',1,10,'projectid','Related to',0,0,'','-2147483648,2147483647',6,104,1,'V~M',0,7,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,618,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',7,104,1,'V~M',0,8,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(42,619,'projecttasknumber','vtiger_projecttask',1,7,'projecttasknumber','Project Task Number',0,2,'','-2147483648,2147483647',5,104,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,620,'projecttask_no','vtiger_projecttask',1,4,'projecttask_no','Project Task No',0,0,'','100',2,104,2,'V~O',3,4,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,621,'projecttaskprogress','vtiger_projecttask',1,9,'projecttaskprogress','Progress',1,2,'','999',3,105,1,'N~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(42,623,'startdate','vtiger_projecttask',1,5,'startdate','Start Date',0,2,'',NULL,5,105,1,'D~M',2,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(42,624,'enddate','vtiger_projecttask',1,5,'enddate','End Date',0,2,'',NULL,7,105,1,'D~O~OTH~GE~startdate~Start Date',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(42,625,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,1,105,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,626,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,2,105,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,627,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',7,105,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,628,'description','vtiger_crmentity',1,300,'description','description',0,2,'','65535',1,106,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,629,'projectname','vtiger_project',1,2,'projectname','Project Name',0,2,'','255',1,107,1,'V~M',0,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(43,630,'startdate','vtiger_project',1,23,'startdate','Start Date',0,2,'',NULL,5,107,1,'D~O',0,3,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(43,631,'targetenddate','vtiger_project',1,23,'targetenddate','Target End Date',0,2,'',NULL,7,107,1,'D~O~OTH~GE~startdate~Start Date',0,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(43,632,'actualenddate','vtiger_project',1,23,'actualenddate','Actual End Date',0,2,'',NULL,6,107,1,'D~O~OTH~GE~startdate~Start Date',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,633,'projectstatus','vtiger_project',1,15,'projectstatus','Status',0,2,'PLL_PLANNED','100',9,107,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(43,634,'projecttype','vtiger_project',1,15,'projecttype','Type',0,2,'','100',8,107,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(43,635,'linktoaccountscontacts','vtiger_project',1,10,'linktoaccountscontacts','Related to',0,2,'','-2147483648,2147483647',11,107,1,'V~O',1,NULL,'BAS',1,'',0,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(43,636,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',4,107,1,'V~M',0,2,'BAS',1,'',1,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(43,637,'project_no','vtiger_project',1,4,'project_no','Project No',0,0,'','100',2,107,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,638,'targetbudget','vtiger_project',1,7,'targetbudget','Target Budget',0,2,'','0,4294967295',1,108,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,639,'projecturl','vtiger_project',1,17,'projecturl','Project Url',0,2,'','255',2,108,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,640,'projectpriority','vtiger_project',1,15,'projectpriority','Priority',0,2,'low','100',3,108,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,641,'progress','vtiger_project',1,9,'progress','Progress',1,2,'','999',4,108,10,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,642,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,7,108,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,643,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,6,108,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,644,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',7,108,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,645,'description','vtiger_crmentity',1,300,'description','description',0,2,'','65535',1,109,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(45,646,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',1,111,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(45,647,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,3,111,2,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(45,648,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,4,111,2,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(45,649,'message','vtiger_smsnotifier',1,21,'message','FL_MESSAGE',0,0,'','65535',1,481,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(45,650,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',6,111,2,'V~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,652,'no_of_currency_decimals','vtiger_users',1,16,'no_of_currency_decimals','Number Of Currency Decimals',0,2,'2','200',7,78,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,689,'truncate_trailing_zeros','vtiger_users',1,56,'truncate_trailing_zeros','Truncate Trailing Zeros',0,2,'0','255',4,78,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(42,690,'projecttaskstatus','vtiger_projecttask',1,15,'projecttaskstatus','Status',0,2,'PLL_PLANNED','100',8,104,1,'V~M',2,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(40,691,'customer','vtiger_modcomments',1,10,'customer','Customer',0,2,'','-2147483648,2147483647',5,98,3,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,692,'dayoftheweek','vtiger_users',1,16,'dayoftheweek','Starting Day of the week',0,2,'Monday','100',4,118,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,694,'othereventduration','vtiger_users',1,315,'othereventduration','Other Event Duration',0,2,'','65535',11,118,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(6,700,'isconvertedfromlead','vtiger_account',1,56,'isconvertedfromlead','Is Converted From Lead',0,2,'0','-32768,32767',1,196,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,701,'isconvertedfromlead','vtiger_contactdetails',1,56,'isconvertedfromlead','Is Converted From Lead',0,2,'0','-32768,32767',5,5,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,703,'default_record_view','vtiger_users',1,16,'default_record_view','Default Record View',0,2,'Summary','10',4,454,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(18,708,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',10,42,1,'V~M',1,2,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(40,710,'userid','vtiger_modcomments',1,10,'userid','UserId',0,2,'','-2147483648,2147483647',6,98,3,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(40,711,'reasontoedit','vtiger_modcomments',1,1,'reasontoedit','ReasonToEdit',0,2,'','100',7,98,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,716,'leftpanelhide','vtiger_users',1,56,'leftpanelhide','LBL_MENU_EXPANDED_BY_DEFAULT',0,2,'0','255',3,454,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,719,'rowheight','vtiger_users',1,16,'rowheight','Row Height',0,2,'medium','10',2,454,10,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(13,720,'from_portal','vtiger_troubletickets',1,56,'from_portal','From Portal',0,0,'','-32768,32767',11,27,3,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,721,'defaulteventstatus','vtiger_users',1,15,'defaulteventstatus','Default Event Status',0,2,'PLL_PLANNED','50',7,118,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,722,'defaultactivitytype','vtiger_users',1,16,'defaultactivitytype','Default Activity Type',0,2,'Meeting','50',6,118,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(4,725,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',4,5,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,726,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',3,196,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,727,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',7,14,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,729,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,0,'','65535',15,19,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,730,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',13,27,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,734,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',11,42,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(34,742,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',3,90,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,743,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',17,91,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,744,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',7,96,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(40,745,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',8,98,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(41,746,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',7,101,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,747,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',11,104,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,748,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',10,107,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(45,749,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',5,111,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(51,780,'name','vtiger_osstimecontrol',1,1,'name','name',0,2,'','128',1,128,1,'V~M',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(51,781,'osstimecontrol_no','vtiger_osstimecontrol',1,4,'osstimecontrol_no','No.',0,2,'','255',2,128,2,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(51,782,'osstimecontrol_status','vtiger_osstimecontrol',1,15,'osstimecontrol_status','LBL_STATUS',0,2,'To approval','128',2,128,1,'V~M',2,2,'BAS',2,'',1,'',NULL,0,0,0,0,'',NULL),
			(51,783,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',7,128,1,'V~M',1,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(51,784,'date_start','vtiger_osstimecontrol',1,6,'date_start','Start Date',0,0,'',NULL,3,128,1,'D~M',0,6,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(51,785,'time_start','vtiger_osstimecontrol',1,14,'time_start','Time Start',0,0,'',NULL,5,128,1,'T~M',1,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(51,786,'time_end','vtiger_osstimecontrol',1,14,'time_end','End Time',0,0,'',NULL,6,128,1,'T~M~OTH~GE~time_start~Time Start',1,7,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(51,787,'due_date','vtiger_osstimecontrol',1,23,'due_date','End Date',0,0,'',NULL,4,128,1,'D~M~OTH~GE~date_start~Start Date',1,8,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(51,788,'sum_time','vtiger_osstimecontrol',1,8,'sum_time','LBL_TOTAL_TIME',0,0,'','99999999',8,128,2,'NN~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(51,791,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,11,128,2,'DT~O',3,2,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(51,792,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,10,128,2,'DT~O',3,2,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,814,'sum_time','vtiger_troubletickets',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',18,27,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,816,'sum_time','vtiger_projecttask',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',10,104,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,818,'sum_time','vtiger_assets',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',1,192,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(34,820,'sum_time','vtiger_servicecontracts',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',1,90,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,826,'sum_time','vtiger_project',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',5,108,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,842,'ossmailview_no','vtiger_ossmailview',1,4,'ossmailview_no','number',0,0,'','50',1,134,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,843,'from_email','vtiger_ossmailview',1,1,'from_email','From',0,2,'','255',2,134,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,844,'to_email','vtiger_ossmailview',1,1,'to_email','To',0,2,'','65535',3,134,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,845,'subject','vtiger_ossmailview',1,1,'subject','Subject',0,2,'','65535',4,134,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,846,'cc_email','vtiger_ossmailview',1,1,'cc_email','CC',0,2,'','65535',5,134,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,847,'bcc_email','vtiger_ossmailview',1,1,'bcc_email','BCC',0,2,'','65535',6,134,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,848,'ossmailview_sendtype','vtiger_ossmailview',1,15,'ossmailview_sendtype','SendType',0,0,'','30',7,134,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,849,'msgid','vtiger_ossmailview',1,1,'msgid','messageid',0,2,'','255',12,134,3,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,850,'reply_to_email','vtiger_ossmailview',1,1,'reply_to_email','Reply_to_email',0,2,'','65535',8,134,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,851,'attachments_exist','vtiger_ossmailview',1,56,'attachments_exist','Attachments_Exist',0,2,'','255',9,134,1,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,852,'rc_user','vtiger_ossmailview',1,1,'rc_user','RC user',0,2,'','0,4294967295',15,134,3,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,853,'type','vtiger_ossmailview',1,7,'type','Type',0,2,'','0,255',16,134,3,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,854,'from_id','vtiger_ossmailview',1,1,'from_id','FromID',0,2,'','65535',17,134,3,'V~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,855,'to_id','vtiger_ossmailview',1,1,'to_id','ToID',0,2,'','65535',18,134,3,'V~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,856,'uid','vtiger_ossmailview',1,1,'uid','Id',0,2,'','0,4294967295',19,134,3,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,857,'mbox','vtiger_ossmailview',1,1,'mbox','mbox',0,2,'','100',20,134,3,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,858,'verify','vtiger_ossmailview',1,56,'verify','LBL_VERIFY',0,2,'0','255',10,134,2,'C~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,860,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',3,135,1,'V~M',0,6,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,861,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,1,135,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,862,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,2,135,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,863,'content','vtiger_ossmailview',1,300,'content','Content',0,2,'','16777215',1,136,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,864,'orginal_mail','vtiger_ossmailview',1,300,'orginal_mail','LBL_ORGINAL_MAIL_CONTENT',0,2,'','16777215',1,137,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(8,865,'ossdc_status','vtiger_notes',1,15,'ossdc_status','ossdc_status',0,2,'','255',7,17,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(57,866,'osservicesstatus','vtiger_ossoutsourcedservices',1,15,'osservicesstatus','LBL_osservicesstatus',0,2,'','50',3,138,1,'V~O',2,3,'BAS',2,'',1,'',NULL,0,0,0,0,'',NULL),
			(57,867,'productname','vtiger_ossoutsourcedservices',1,2,'productname','Product Name',0,2,'','100',1,138,1,'V~M',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(57,868,'pscategory','vtiger_ossoutsourcedservices',1,302,'pscategory','Category',0,2,'','255',2,138,1,'V~O',2,5,'BAS',1,'',1,'4',NULL,0,0,0,0,'',NULL),
			(57,870,'datesold','vtiger_ossoutsourcedservices',1,5,'datesold','Date Sold',0,2,'',NULL,5,138,1,'D~O',2,9,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(57,871,'dateinservice','vtiger_ossoutsourcedservices',1,5,'dateinservice','Date in Service',0,2,'',NULL,6,138,1,'D~O',2,10,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(57,872,'wherebought','vtiger_ossoutsourcedservices',1,1,'wherebought','Where bought',0,2,'','100',8,138,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(57,873,'ossoutsourcedservices_no','vtiger_ossoutsourcedservices',1,4,'ossoutsourcedservices_no','Number',0,2,'','255',2,139,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(57,874,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',1,139,1,'V~M',1,8,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(57,875,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,4,139,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(57,876,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,5,139,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(57,877,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',4,139,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(57,878,'description','vtiger_crmentity',1,300,'description','Notes',0,2,'','65535',1,140,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,879,'productname','vtiger_osssoldservices',1,2,'productname','Product Name',0,2,'','255',1,141,1,'V~M',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(58,880,'ssservicesstatus','vtiger_osssoldservices',1,15,'ssservicesstatus','LBL_ssservicesstatus',0,0,'','255',3,141,1,'V~M',2,7,'BAS',2,'',1,'',NULL,0,0,0,0,'',NULL),
			(58,881,'pscategory','vtiger_osssoldservices',1,302,'pscategory','Category',0,2,'','255',4,141,1,'V~O',2,9,'BAS',1,'',1,'5',NULL,0,0,0,0,'',NULL),
			(58,883,'datesold','vtiger_osssoldservices',1,5,'datesold','Date Sold',0,2,'',NULL,8,141,1,'D~M',2,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(58,884,'dateinservice','vtiger_osssoldservices',1,5,'dateinservice','Date in Service',0,2,'',NULL,5,141,1,'D~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(58,885,'invoice','vtiger_osssoldservices',1,1,'invoice','Invoice',0,2,'','255',7,141,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,886,'osssoldservices_no','vtiger_osssoldservices',1,4,'osssoldservices_no','Number',0,2,'','255',1,142,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,887,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',5,142,1,'V~M',1,2,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,888,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,8,142,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,889,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,9,142,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,890,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',4,142,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,891,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,143,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(59,892,'productname','vtiger_outsourcedproducts',1,1,'productname','Product Name',0,2,'','255',1,144,1,'V~M',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(59,893,'oproductstatus','vtiger_outsourcedproducts',1,15,'oproductstatus','Status',0,2,'','255',2,144,1,'V~O',2,3,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(59,894,'datesold','vtiger_outsourcedproducts',1,5,'datesold','Date Sold',0,2,'',NULL,3,144,1,'D~O',2,9,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(59,895,'dateinservice','vtiger_outsourcedproducts',1,5,'dateinservice','Date in Service',0,2,'',NULL,5,144,1,'D~O',2,10,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(59,896,'pscategory','vtiger_outsourcedproducts',1,302,'pscategory','Category',0,2,'','255',17,144,1,'V~O',2,5,'BAS',1,'',1,'6',NULL,0,0,0,0,'',NULL),
			(59,898,'wherebought','vtiger_outsourcedproducts',1,1,'wherebought','Where bought',0,2,'','255',22,144,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(59,899,'prodcount','vtiger_outsourcedproducts',1,7,'prodcount','Quantity',0,2,'','0,4294967295',23,144,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(59,900,'asset_no','vtiger_outsourcedproducts',1,4,'asset_no','Number',0,2,'','32',1,145,2,'V~O',0,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(59,901,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',2,145,1,'V~M',1,8,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(59,902,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,6,145,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(59,903,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,3,145,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(59,904,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',4,145,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(59,905,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,146,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,938,'noapprovalcalls','vtiger_leaddetails',1,56,'noapprovalcalls','Approval for phone calls',0,2,'','-32768,32767',7,150,1,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,940,'noapprovalemails','vtiger_leaddetails',1,56,'noapprovalemails','Approval for email',0,2,'','-32768,32767',8,150,1,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,941,'ossemployees_no','vtiger_ossemployees',1,4,'ossemployees_no','No.',0,2,'','255',1,151,2,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(61,942,'employee_status','vtiger_ossemployees',1,15,'employee_status','LBL_EMPLOYEESTATUS',0,2,'','200',1,151,1,'V~O',0,4,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(61,943,'parentid','vtiger_ossemployees',1,10,'parentid','LBL_Member_Of',0,2,'','-2147483648,2147483647',2,151,1,'I~O',1,NULL,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(61,944,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',9,151,1,'V~M',1,3,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,945,'name','vtiger_ossemployees',1,1,'name','LBL_NAME',0,2,'','200',3,151,1,'V~M',1,1,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(61,946,'last_name','vtiger_ossemployees',1,1,'last_name','LBL_LASTNAME',0,2,'','200',4,151,1,'V~M',1,2,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(61,947,'pesel','vtiger_ossemployees',1,1,'pesel','LBL_PESEL',0,2,'','20',5,151,1,'V~O',1,17,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(61,948,'id_card','vtiger_ossemployees',1,1,'id_card','LBL_IDCARD',0,2,'','200',6,151,1,'V~O',1,18,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(61,949,'employee_education','vtiger_ossemployees',1,15,'employee_education','LBL_EDUCATION',0,2,'','200',7,151,1,'V~O',1,5,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(61,950,'birth_date','vtiger_ossemployees',1,5,'birth_date','LBL_BIRTHDATE',0,2,'',NULL,8,151,1,'D~O',2,6,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,951,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,10,151,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,952,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,13,151,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,953,'business_phone','vtiger_ossemployees',1,11,'business_phone','LBL_BUSINESSPHONE',0,2,'','20',1,152,1,'V~O',1,19,'BAS',2,'',1,'','',0,0,0,0,'',NULL),
			(61,954,'private_phone','vtiger_ossemployees',1,11,'private_phone','LBL_PRIVATEPHONE',0,2,'','25',3,152,1,'V~O',1,16,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,955,'business_mail','vtiger_ossemployees',1,13,'business_mail','LBL_BUSINESSMAIL',0,2,'','100',2,152,1,'E~O',1,21,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(61,956,'private_mail','vtiger_ossemployees',1,13,'private_mail','LBL_PRIVATEMAIL',0,2,'','100',4,152,1,'E~O',1,20,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,957,'street','vtiger_ossemployees',1,1,'street','LBL_STREET',0,2,'','200',1,153,1,'V~O',1,22,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,958,'code','vtiger_ossemployees',1,1,'code','LBL_CODE',0,2,'','200',2,153,1,'V~O',1,13,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,959,'city','vtiger_ossemployees',1,1,'city','LBL_CITY',0,2,'','200',3,153,1,'V~O',1,9,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,960,'state','vtiger_ossemployees',1,1,'state','LBL_STATE',0,2,'','200',4,153,1,'V~O',1,8,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,961,'country','vtiger_ossemployees',1,1,'country','LBL_COUNTRY',0,2,'','200',5,153,1,'V~O',1,10,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,962,'ship_street','vtiger_ossemployees',1,1,'ship_street','LBL_SHIPSTREET',0,2,'','200',1,154,1,'V~O',1,11,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,963,'ship_code','vtiger_ossemployees',1,1,'ship_code','LBL_SHIPCODE',0,2,'','200',2,154,1,'V~O',1,15,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,964,'ship_city','vtiger_ossemployees',1,1,'ship_city','LBL_SHIPCITY',0,2,'','200',3,154,1,'V~O',1,12,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,965,'ship_state','vtiger_ossemployees',1,1,'ship_state','LBL_SHIPSTATE',0,2,'','200',4,154,1,'V~O',1,14,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,966,'ship_country','vtiger_ossemployees',1,1,'ship_country','LBL_SHIPCOUNTRY',0,2,'','200',5,154,1,'V~O',1,7,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,967,'vat_id','vtiger_leaddetails',1,1,'vat_id','Vat ID',0,2,'','50',1,191,1,'V~O',2,7,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,968,'registration_number_1','vtiger_leaddetails',1,1,'registration_number_1','Registration number 1',0,2,'','30',2,191,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,969,'registration_number_2','vtiger_leaddetails',1,1,'registration_number_2','Registration number 2',0,2,'','30',3,191,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,970,'vat_id','vtiger_account',1,1,'vat_id','Vat ID',0,2,'','50',2,194,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,971,'registration_number_1','vtiger_account',1,1,'registration_number_1','Registration number 1',0,2,'','30',6,194,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,972,'registration_number_2','vtiger_account',1,1,'registration_number_2','Registration number 2',0,2,'','30',4,194,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,973,'vat_id','vtiger_vendor',1,1,'vat_id','Vat ID',0,2,'','50',14,42,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,974,'registration_number_1','vtiger_vendor',1,1,'registration_number_1','Registration number 1',0,2,'','30',13,42,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,975,'registration_number_2','vtiger_vendor',1,1,'registration_number_2','Registration number 2',0,2,'','30',16,42,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,1044,'servicecontractsid','vtiger_project',1,10,'servicecontractsid','ServiceContracts',0,2,'','-2147483648,2147483647',13,107,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,1045,'is_owner','vtiger_users',1,1,'is_owner','Account Owner',0,2,'0','5',7,79,5,'V~O',0,1,'BAS',0,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(13,1049,'servicecontractsid','vtiger_troubletickets',1,10,'servicecontractsid','FL_SERVICE_CONTRACTS',0,2,'','-2147483648,2147483647',1,27,1,'V~O',1,NULL,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(7,1065,'addresslevel1a','vtiger_leadaddress',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,15,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1066,'addresslevel2a','vtiger_leadaddress',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,15,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1067,'addresslevel3a','vtiger_leadaddress',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,15,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1068,'addresslevel4a','vtiger_leadaddress',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,15,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1069,'addresslevel5a','vtiger_leadaddress',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,15,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1070,'addresslevel6a','vtiger_leadaddress',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,15,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1071,'addresslevel7a','vtiger_leadaddress',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,15,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1072,'addresslevel8a','vtiger_leadaddress',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,15,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1073,'addresslevel1a','vtiger_contactaddress',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,7,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1074,'addresslevel1b','vtiger_contactaddress',1,35,'addresslevel1b','AddressLevel1',0,2,'','255',9,178,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1075,'addresslevel2a','vtiger_contactaddress',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,7,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1076,'addresslevel2b','vtiger_contactaddress',1,1,'addresslevel2b','AddressLevel2',0,2,'','255',7,178,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1077,'addresslevel3a','vtiger_contactaddress',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,7,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1078,'addresslevel3b','vtiger_contactaddress',1,1,'addresslevel3b','AddressLevel3',0,2,'','255',10,178,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1079,'addresslevel4a','vtiger_contactaddress',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,7,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1080,'addresslevel4b','vtiger_contactaddress',1,1,'addresslevel4b','AddressLevel4',0,2,'','255',8,178,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1081,'addresslevel5a','vtiger_contactaddress',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,7,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1082,'addresslevel5b','vtiger_contactaddress',1,1,'addresslevel5b','AddressLevel5',0,2,'','255',3,178,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1083,'addresslevel6a','vtiger_contactaddress',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,7,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1084,'addresslevel6b','vtiger_contactaddress',1,1,'addresslevel6b','AddressLevel6',0,2,'','255',6,178,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1085,'addresslevel7a','vtiger_contactaddress',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,7,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1086,'addresslevel7b','vtiger_contactaddress',1,1,'addresslevel7b','AddressLevel7',0,2,'','255',5,178,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1087,'addresslevel8a','vtiger_contactaddress',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,7,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1088,'addresslevel8b','vtiger_contactaddress',1,1,'addresslevel8b','AddressLevel8',0,2,'','255',1,178,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1089,'addresslevel1a','vtiger_accountaddress',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,11,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1090,'addresslevel1b','vtiger_accountaddress',1,35,'addresslevel1b','AddressLevel1',0,2,'','255',9,10,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1091,'addresslevel2a','vtiger_accountaddress',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,11,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1092,'addresslevel2b','vtiger_accountaddress',1,1,'addresslevel2b','AddressLevel2',0,2,'','255',7,10,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1093,'addresslevel3a','vtiger_accountaddress',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,11,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1094,'addresslevel3b','vtiger_accountaddress',1,1,'addresslevel3b','AddressLevel3',0,2,'','255',10,10,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1095,'addresslevel4a','vtiger_accountaddress',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,11,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1096,'addresslevel4b','vtiger_accountaddress',1,1,'addresslevel4b','AddressLevel4',0,2,'','255',8,10,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1097,'addresslevel5a','vtiger_accountaddress',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,11,1,'V~O',1,NULL,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(6,1098,'addresslevel5b','vtiger_accountaddress',1,1,'addresslevel5b','AddressLevel5',0,2,'','255',3,10,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1099,'addresslevel6a','vtiger_accountaddress',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,11,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1100,'addresslevel6b','vtiger_accountaddress',1,1,'addresslevel6b','AddressLevel6',0,2,'','255',6,10,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1101,'addresslevel7a','vtiger_accountaddress',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,11,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1102,'addresslevel7b','vtiger_accountaddress',1,1,'addresslevel7b','AddressLevel7',0,2,'','255',5,10,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1103,'addresslevel8a','vtiger_accountaddress',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,11,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1104,'addresslevel8b','vtiger_accountaddress',1,1,'addresslevel8b','AddressLevel8',0,2,'','255',1,10,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1105,'addresslevel1a','vtiger_vendoraddress',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,44,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1106,'addresslevel1b','vtiger_vendoraddress',1,35,'addresslevel1b','AddressLevel1',0,2,'','255',9,43,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1107,'addresslevel1c','vtiger_vendoraddress',1,35,'addresslevel1c','AddressLevel1',0,2,'','255',9,179,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1108,'addresslevel2a','vtiger_vendoraddress',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,44,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1109,'addresslevel2b','vtiger_vendoraddress',1,1,'addresslevel2b','AddressLevel2',0,2,'','255',7,43,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1110,'addresslevel2c','vtiger_vendoraddress',1,1,'addresslevel2c','AddressLevel2',0,2,'','255',7,179,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1111,'addresslevel3a','vtiger_vendoraddress',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,44,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1112,'addresslevel3b','vtiger_vendoraddress',1,1,'addresslevel3b','AddressLevel3',0,2,'','255',10,43,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1113,'addresslevel3c','vtiger_vendoraddress',1,1,'addresslevel3c','AddressLevel3',0,2,'','255',10,179,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1114,'addresslevel4a','vtiger_vendoraddress',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,44,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1115,'addresslevel4b','vtiger_vendoraddress',1,1,'addresslevel4b','AddressLevel4',0,2,'','255',8,43,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1116,'addresslevel4c','vtiger_vendoraddress',1,1,'addresslevel4c','AddressLevel4',0,2,'','255',8,179,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1117,'addresslevel5a','vtiger_vendoraddress',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,44,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1118,'addresslevel5b','vtiger_vendoraddress',1,1,'addresslevel5b','AddressLevel5',0,2,'','255',3,43,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1119,'addresslevel5c','vtiger_vendoraddress',1,1,'addresslevel5c','AddressLevel5',0,2,'','255',3,179,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1120,'addresslevel6a','vtiger_vendoraddress',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,44,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1121,'addresslevel6b','vtiger_vendoraddress',1,1,'addresslevel6b','AddressLevel6',0,2,'','255',6,43,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1122,'addresslevel6c','vtiger_vendoraddress',1,1,'addresslevel6c','AddressLevel6',0,2,'','255',6,179,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1123,'addresslevel7a','vtiger_vendoraddress',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,44,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1124,'addresslevel7b','vtiger_vendoraddress',1,1,'addresslevel7b','AddressLevel7',0,2,'','255',5,43,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1125,'addresslevel7c','vtiger_vendoraddress',1,1,'addresslevel7c','AddressLevel7',0,2,'','255',5,179,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1126,'addresslevel8a','vtiger_vendoraddress',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,44,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1127,'addresslevel8b','vtiger_vendoraddress',1,1,'addresslevel8b','AddressLevel8',0,2,'','255',1,43,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1128,'addresslevel8c','vtiger_vendoraddress',1,1,'addresslevel8c','AddressLevel8',0,2,'','255',1,179,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1160,'addresslevel1c','vtiger_accountaddress',1,35,'addresslevel1c','AddressLevel1',0,2,'','255',9,181,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1161,'addresslevel2c','vtiger_accountaddress',1,1,'addresslevel2c','AddressLevel2',0,2,'','255',7,181,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1162,'addresslevel3c','vtiger_accountaddress',1,1,'addresslevel3c','AddressLevel3',0,2,'','255',10,181,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1163,'addresslevel4c','vtiger_accountaddress',1,1,'addresslevel4c','AddressLevel4',0,2,'','255',8,181,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1164,'addresslevel5c','vtiger_accountaddress',1,1,'addresslevel5c','AddressLevel5',0,2,'','255',3,181,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1165,'addresslevel6c','vtiger_accountaddress',1,1,'addresslevel6c','AddressLevel6',0,2,'','255',6,181,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1166,'addresslevel7c','vtiger_accountaddress',1,1,'addresslevel7c','AddressLevel7',0,2,'','255',5,181,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1167,'addresslevel8c','vtiger_accountaddress',1,1,'addresslevel8c','AddressLevel8',0,2,'','255',1,181,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1276,'verification','vtiger_leaddetails',1,33,'verification','Verification data',0,2,'','65535',4,14,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1277,'verification','vtiger_account',1,33,'verification','Verification data',0,2,'','65535',2,196,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1278,'verification','vtiger_contactdetails',1,33,'verification','Verification data',0,2,'','65535',3,5,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1279,'verification','vtiger_vendor',1,33,'verification','Verification data',0,2,'','65535',15,42,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1285,'buildingnumbera','vtiger_accountaddress',1,1,'buildingnumbera','Building number',0,2,'','255',4,11,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1286,'localnumbera','vtiger_accountaddress',1,1,'localnumbera','Local number',0,2,'','50',2,11,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1287,'buildingnumberb','vtiger_accountaddress',1,1,'buildingnumberb','Building number',0,2,'','255',4,10,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1288,'localnumberb','vtiger_accountaddress',1,1,'localnumberb','Local number',0,2,'','50',2,10,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1289,'buildingnumberc','vtiger_accountaddress',1,1,'buildingnumberc','Building number',0,2,'','255',4,181,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1290,'localnumberc','vtiger_accountaddress',1,1,'localnumberc','Local number',0,2,'','50',2,181,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1291,'buildingnumbera','vtiger_leadaddress',1,1,'buildingnumbera','Building number',0,2,'','255',4,15,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1292,'localnumbera','vtiger_leadaddress',1,1,'localnumbera','Local number',0,2,'','50',2,15,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1293,'buildingnumbera','vtiger_contactaddress',1,1,'buildingnumbera','Building number',0,2,'','255',4,7,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1294,'localnumbera','vtiger_contactaddress',1,1,'localnumbera','Local number',0,2,'','50',2,7,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1295,'buildingnumberb','vtiger_contactaddress',1,1,'buildingnumberb','Building number',0,2,'','255',4,178,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1296,'localnumberb','vtiger_contactaddress',1,1,'localnumberb','Local number',0,2,'','50',2,178,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,1314,'parent_id','vtiger_assets',1,10,'parent_id','Parent ID',0,2,'','-2147483648,2147483647',1,96,1,'V~M',2,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(59,1315,'parent_id','vtiger_outsourcedproducts',1,10,'parent_id','Parent ID',0,2,'','-2147483648,2147483647',29,144,1,'V~M',2,2,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(57,1316,'parent_id','vtiger_ossoutsourcedservices',1,10,'parent_id','Parent ID',0,2,'','-2147483648,2147483647',14,138,1,'V~M',2,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(58,1317,'parent_id','vtiger_osssoldservices',1,10,'parent_id','Parent ID',0,2,'','-2147483648,2147483647',1,142,1,'V~M',2,6,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(42,1318,'parentid','vtiger_projecttask',1,10,'parentid','Parent ID',0,2,'','-2147483648,2147483647',13,104,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,1319,'projectmilestoneid','vtiger_projecttask',1,10,'projectmilestoneid','ProjectMilestone',0,2,'','-2147483648,2147483647',12,104,1,'V~M',2,2,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,1320,'targetenddate','vtiger_projecttask',1,5,'targetenddate','Target End Date',0,2,'',NULL,6,105,1,'D~M',2,6,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1321,'subindustry','vtiger_leaddetails',1,16,'subindustry','Sub industry',0,2,'','255',7,13,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,1322,'end_hour','vtiger_users',1,16,'end_hour','Day ends at',0,2,'16:00','30',2,469,1,'V~M',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(37,1323,'description','vtiger_crmentity',1,300,'description','description',0,2,'','65535',1,97,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,1324,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,97,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(51,1326,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,130,1,'V~O',2,9,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(51,1327,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,130,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1329,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,16,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1330,'no_approval','vtiger_account',1,56,'no_approval','Approval for phone calls',0,2,'','-32768,32767',8,195,1,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1331,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,12,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1332,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,8,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1333,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,45,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,1340,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,109,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,1341,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,28,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,1344,'serviceid','vtiger_osssoldservices',1,10,'serviceid','Services',0,2,'','-2147483648,2147483647',4,142,1,'V~M',2,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(4,1368,'secondary_email','vtiger_contactdetails',1,13,'secondary_email','Secondary Email',0,2,'','100',4,197,1,'E~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1369,'balance','vtiger_account',1,71,'balance','Balance',0,2,'','1.0E+20',2,198,1,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1375,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',8,9,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,1378,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',4,74,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,1382,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',3,107,1,'V~O',1,NULL,'BAS',1,'',0,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(13,1384,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',6,25,1,'V~O',1,NULL,'BAS',1,'',0,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(4,1386,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',8,4,1,'V~O',1,NULL,'BAS',1,'',0,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(4,1391,'notifilanguage','vtiger_contactdetails',1,32,'notifilanguage','LBL_LANGUAGE_NOTIFICATIONS',0,2,'','100',12,5,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,1393,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',25,31,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,1395,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',20,91,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1397,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',4,13,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(8,1399,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',6,17,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,1401,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,0,'','65535',5,19,1,'V~O',2,7,'BAS',1,'',0,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(15,1403,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',7,38,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1407,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',12,42,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(19,1409,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',9,46,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(34,1419,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',17,89,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,1421,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',5,95,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(41,1423,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',8,101,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,1425,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',9,104,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(51,1431,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',9,128,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,1433,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',13,134,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(57,1435,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',3,139,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,1437,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',7,142,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(59,1439,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',4,145,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,1443,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',11,151,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,1482,'pssold_id','vtiger_troubletickets',1,10,'pssold_id','P&S Sold',0,2,'','-2147483648,2147483647',5,27,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,1484,'ordertime','vtiger_assets',1,7,'ordertime','LBL_ORDER_TIME',0,2,'','99999999',7,192,1,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,1485,'ordertime','vtiger_osssoldservices',1,7,'ordertime','LBL_ORDER_TIME',0,2,'','99999999',10,142,1,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1486,'poboxa','vtiger_leadaddress',1,1,'poboxa','Po Box',0,2,'','50',11,15,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1487,'poboxa','vtiger_contactaddress',1,1,'poboxa','Po Box',0,2,'','50',11,7,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1488,'poboxa','vtiger_accountaddress',1,1,'poboxa','Po Box',0,2,'','50',11,11,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1489,'poboxa','vtiger_vendoraddress',1,1,'poboxa','Po Box',0,2,'','50',11,44,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1494,'poboxb','vtiger_contactaddress',1,1,'poboxb','Po Box',0,2,'','50',11,178,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1495,'poboxb','vtiger_accountaddress',1,1,'poboxb','Po Box',0,2,'','50',11,10,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1496,'poboxb','vtiger_vendoraddress',1,1,'poboxb','Po Box',0,2,'','50',11,43,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1501,'poboxc','vtiger_vendoraddress',1,1,'poboxc','Po Box',0,2,'','50',11,179,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1502,'poboxc','vtiger_accountaddress',1,1,'poboxc','Po Box',0,2,'','50',11,181,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1503,'contactstatus','vtiger_contactdetails',1,15,'contactstatus','Status',0,2,'','255',7,4,1,'V~O',1,0,'BAS',1,'',1,'','{\"type\":\"progress\"}',0,0,0,0,'',NULL),
			(74,1504,'callhistorytype','vtiger_callhistory',1,16,'callhistorytype','LBL_TYPE',0,2,'','255',2,232,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1505,'from_number','vtiger_callhistory',1,11,'from_number','LBL_FROM_NUMBER',0,2,'','30',1,232,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1506,'to_number','vtiger_callhistory',1,11,'to_number','LBL_TO_NUMBER',0,2,'','30',3,232,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1507,'location','vtiger_callhistory',1,1,'location','LBL_LOCATION',0,2,'','200',9,232,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1508,'phonecallid','vtiger_callhistory',1,1,'phonecallid','LBL_PHONE_CALL_ID',0,2,'','100',8,232,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1509,'duration','vtiger_callhistory',1,7,'duration','LBL_DURATION',0,2,'','0,4294967295',7,232,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1511,'start_time','vtiger_callhistory',1,70,'start_time','LBL_START_TIME',0,2,'',NULL,5,232,1,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1512,'end_time','vtiger_callhistory',1,70,'end_time','LBL_END_TIME',0,2,'',NULL,6,232,1,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1513,'country','vtiger_callhistory',1,1,'country','LBL_COUNTRY_CODE',0,2,'','100',10,232,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1514,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',3,233,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1515,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,1,233,2,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1516,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,2,233,2,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1517,'imei','vtiger_callhistory',1,1,'imei','LBL_IMEI',0,2,'','100',1,234,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1518,'ipaddress','vtiger_callhistory',1,1,'ipAddress','LBL_IPADDRESS',0,2,'','100',4,234,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1519,'simserial','vtiger_callhistory',1,1,'simSerial','LBL_SIMSERIAL',0,2,'','100',3,234,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1520,'subscriberid','vtiger_callhistory',1,1,'subscriberId','LBL_SUBSCRIBERID',0,2,'','100',2,234,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1521,'destination','vtiger_callhistory',1,10,'destination','LBL_DESTINATION',0,2,'','-2147483648,2147483647',1,235,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1522,'source','vtiger_callhistory',1,10,'source','LBL_SOURCE',0,2,'','-2147483648,2147483647',2,235,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1524,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',10,4,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1525,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',9,9,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1526,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',10,13,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(8,1527,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',9,17,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,1528,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,0,'','-128,127',17,19,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,1529,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',15,27,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,1530,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',27,31,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(15,1531,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',3,38,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1532,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',17,42,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(19,1533,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',8,46,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,1538,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',15,74,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(34,1539,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',4,90,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,1540,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',22,91,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,1541,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',6,95,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(41,1542,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',12,101,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,1543,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',14,104,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,1544,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',12,107,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(51,1547,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',12,128,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,1548,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',12,134,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(57,1549,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',15,138,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,1550,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',9,141,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(59,1551,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',30,144,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,1553,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',14,151,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,1556,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',11,232,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(75,1557,'subject','vtiger_ideas',1,2,'subject','LBL_SUBJECT',0,2,'','255',1,236,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(75,1558,'ideas_no','vtiger_ideas',1,4,'ideas_no','LBL_NO',0,2,'','255',2,236,2,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(75,1559,'ideasstatus','vtiger_ideas',1,15,'ideasstatus','LBL_STATUS',0,2,'','255',2,236,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(75,1560,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',3,236,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(75,1561,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,4,236,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(75,1562,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,7,236,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(75,1564,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,8,'','-128,127',14,236,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(75,1566,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',5,236,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(75,1567,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',3,238,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(75,1568,'extent_description','vtiger_ideas',1,300,'extent_description','LBL_EXTENT_DESCRIPTION',0,2,'','65535',2,238,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(75,1569,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,238,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(51,1600,'timecontrol_type','vtiger_osstimecontrol',1,16,'timecontrol_type','Type',0,2,'PLL_WORKING_TIME','255',14,128,1,'V~M',2,3,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,1603,'allday','vtiger_activity',1,56,'allday','All day',0,0,'','-128,127',26,19,1,'C~O',2,5,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(78,1605,'holidaysentitlement_year','vtiger_holidaysentitlement',1,15,'holidaysentitlement_year','LBL_YEAR',0,2,'','50',1,247,1,'V~M',1,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(78,1606,'days','vtiger_holidaysentitlement',1,1,'days','LBL_DAYS',0,2,'','-2147483648,2147483647',2,247,1,'I~M',2,3,'BAS',2,'',1,'',NULL,0,0,0,0,'',NULL),
			(78,1607,'ossemployeesid','vtiger_holidaysentitlement',1,10,'ossemployeesid','LBL_EMPLOYEE',0,2,'','-2147483648,2147483647',3,247,1,'V~M',1,1,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(78,1608,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',1,248,1,'V~M',1,4,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(78,1609,'holidaysentitlement_no','vtiger_holidaysentitlement',1,4,'holidaysentitlement_no','LBL_NUMBER',0,2,'','255',2,248,2,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(78,1610,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,2,248,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(78,1611,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,5,248,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(78,1613,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,8,'','-128,127',6,248,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(78,1615,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',3,248,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,1616,'paymentsno','vtiger_paymentsin',1,4,'paymentsno','LBL_PAYMENTSNO',0,2,'','32',1,250,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,1617,'paymentsname','vtiger_paymentsin',1,1,'paymentsname','LBL_PAYMENTSNAME',0,2,'','128',2,250,1,'V~O',0,3,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,1618,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',3,250,1,'V~M',1,2,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,1619,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,4,250,2,'DT~O',0,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,1620,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,5,250,2,'DT~O',0,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,1621,'paymentsin_status','vtiger_paymentsin',1,15,'paymentsin_status','LBL_PAYMENTSSTATUS',0,2,'PLL_CREATED','128',6,250,1,'V~O',0,8,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,1622,'relatedid','vtiger_paymentsin',1,10,'relatedid','LBL_RELATEDID',0,2,'','-2147483648,2147483647',7,250,1,'V~O',0,7,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,1625,'paymentsvalue','vtiger_paymentsin',1,72,'paymentsvalue','LBL_PAYMENTSVALUE',0,2,'','1.0E+20',1,251,1,'N~M',1,1,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,1626,'currency_id','vtiger_paymentsin',1,117,'currency_id','LBL_PAYMENTSCURRENCY',0,2,'','-2147483648,2147483647',2,251,1,'N~M',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,1627,'paymentstitle','vtiger_paymentsin',1,22,'paymentstitle','LBL_PAYMENTSTITLE',0,2,'','65535',4,251,1,'V~O',0,5,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,1628,'bank_account','vtiger_paymentsin',1,1,'bank_account','LBL_BANK_ACCOUNT',0,2,'','128',3,251,1,'V~O',0,4,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1630,'payment_balance','vtiger_account',1,7,'payment_balance','Payment balance',0,2,'','99999999999999999',6,198,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(80,1632,'paymentsno','vtiger_paymentsout',1,4,'paymentsno','LBL_PAYMENTSNO',0,2,'','32',1,252,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(80,1633,'paymentsname','vtiger_paymentsout',1,1,'paymentsname','LBL_PAYMENTSNAME',0,2,'','128',2,252,1,'V~O',0,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(80,1634,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',3,252,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(80,1635,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,4,252,2,'DT~O',0,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(80,1636,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,5,252,2,'DT~O',0,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(80,1637,'paymentsout_status','vtiger_paymentsout',1,15,'paymentsout_status','LBL_PAYMENTSSTATUS',0,2,'Created','128',6,252,1,'V~O',0,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(80,1638,'relatedid','vtiger_paymentsout',1,10,'relatedid','LBL_RELATEDID',0,2,'','-2147483648,2147483647',7,252,1,'V~O',0,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(80,1640,'parentid','vtiger_paymentsout',1,10,'parentid','LBL_PARENTID',0,2,'','-2147483648,2147483647',8,252,1,'V~O',0,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(80,1641,'paymentsvalue','vtiger_paymentsout',1,72,'paymentsvalue','LBL_PAYMENTSVALUE',0,2,'','1.0E+20',1,253,1,'N~M',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(80,1642,'currency_id','vtiger_paymentsout',1,117,'currency_id','LBL_PAYMENTSCURRENCY',0,2,'','-2147483648,2147483647',2,253,1,'V~M',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(80,1643,'paymentstitle','vtiger_paymentsout',1,1,'paymentstitle','LBL_PAYMENTSTITLE',0,2,'','128',4,253,1,'V~O',0,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(80,1644,'bank_account','vtiger_paymentsout',1,1,'bank_account','LBL_BANK_ACCOUNT',0,2,'','128',3,253,1,'V~O',0,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,1645,'number','vtiger_lettersin',1,4,'number','Number',0,2,'','255',1,254,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,1646,'title','vtiger_lettersin',1,1,'title','Title',0,2,'','255',2,254,1,'V~M',2,1,'BAS',2,'',1,'',NULL,0,0,0,0,'',NULL),
			(81,1647,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',4,254,1,'V~M',1,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(81,1648,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,5,254,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,1649,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,6,254,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,1650,'date_adoption','vtiger_lettersin',1,5,'date_adoption','Date of adoption',0,2,'',NULL,7,254,1,'D~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(81,1651,'lin_type_ship','vtiger_lettersin',1,16,'lin_type_ship','Type of shipping',0,2,'','255',8,254,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(81,1652,'lin_type_doc','vtiger_lettersin',1,33,'lin_type_doc','Type of document',0,2,'','65535',9,254,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(81,1653,'lin_status','vtiger_lettersin',1,15,'lin_status','Status',0,2,'','255',10,254,1,'V~M',2,NULL,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(81,1655,'relatedid','vtiger_lettersin',1,10,'relatedid','Related',0,2,'','-2147483648,2147483647',12,254,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(81,1656,'person_receiving','vtiger_lettersin',1,53,'person_receiving','Person receiving',0,2,'','-2147483648,2147483647',13,254,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,1657,'deadline_reply','vtiger_lettersin',1,5,'deadline_reply','Deadline for reply',0,2,'',NULL,14,254,1,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,1658,'cocument_no','vtiger_lettersin',1,1,'cocument_no','Document no',0,2,'','100',15,254,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(81,1659,'no_internal','vtiger_lettersin',1,1,'no_internal','No internal',0,2,'','100',16,254,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,1660,'parentid','vtiger_lettersin',1,10,'parentid','Parent letters',0,2,'','-2147483648,2147483647',17,254,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,1661,'lin_dimensions','vtiger_lettersin',1,16,'lin_dimensions','Overall dimensions',0,2,'','255',18,254,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(82,1667,'number','vtiger_lettersout',1,4,'number','Number',0,2,'','255',1,256,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(82,1668,'title','vtiger_lettersout',1,1,'title','Title',0,2,'','255',2,256,1,'V~M',2,1,'BAS',2,'',1,'',NULL,0,0,0,0,'',NULL),
			(82,1669,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',4,256,1,'V~M',1,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(82,1670,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,5,256,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(82,1671,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,6,256,2,'DT~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(82,1672,'date_adoption','vtiger_lettersout',1,5,'date_adoption','Date of adoption',0,2,'',NULL,7,256,1,'D~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(82,1673,'lout_type_ship','vtiger_lettersout',1,16,'lout_type_ship','Type of shipping',0,2,'','255',8,256,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(82,1674,'lout_type_doc','vtiger_lettersout',1,33,'lout_type_doc','Type of document',0,2,'','65535',9,256,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(82,1675,'lout_status','vtiger_lettersout',1,15,'lout_status','Status',0,2,'','255',10,256,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(82,1677,'relatedid','vtiger_lettersout',1,10,'relatedid','Related',0,2,'','-2147483648,2147483647',12,256,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(82,1678,'person_receiving','vtiger_lettersout',1,53,'person_receiving','Person receiving',0,2,'','-2147483648,2147483647',13,256,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(82,1679,'deadline_reply','vtiger_lettersout',1,5,'deadline_reply','Deadline for reply',0,2,'',NULL,14,256,1,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(82,1680,'cocument_no','vtiger_lettersout',1,1,'cocument_no','Document no',0,2,'','100',15,256,1,'V~O~LE~100',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(82,1681,'no_internal','vtiger_lettersout',1,1,'no_internal','No internal',0,2,'','100',16,256,1,'V~O~LE~100',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(82,1682,'parentid','vtiger_lettersout',1,10,'parentid','Parent letters',0,2,'','-2147483648,2147483647',17,256,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(82,1683,'lout_dimensions','vtiger_lettersout',1,16,'lout_dimensions','Overall dimensions',0,2,'','255',18,256,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(82,1688,'description','vtiger_crmentity',1,19,'description','Notes',0,2,'','65535',1,257,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1689,'buildingnumbera','vtiger_vendoraddress',1,1,'buildingnumbera','LBL_BUILDING_NUMBER',0,2,'','255',4,44,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1690,'buildingnumberb','vtiger_vendoraddress',1,1,'buildingnumberb','LBL_BUILDING_NUMBER',0,2,'','255',4,43,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1691,'buildingnumberc','vtiger_vendoraddress',1,1,'buildingnumberc','LBL_BUILDING_NUMBER',0,2,'','255',4,179,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1692,'localnumbera','vtiger_vendoraddress',1,1,'localnumbera','LBL_LOCAL_NUMBER',0,2,'','50',2,44,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1693,'localnumberb','vtiger_vendoraddress',1,1,'localnumberb','LBL_LOCAL_NUMBER',0,2,'','50',2,43,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1694,'localnumberc','vtiger_vendoraddress',1,1,'localnumberc','LBL_LOCAL_NUMBER',0,2,'','50',2,179,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(83,1708,'subject','u_yf_announcement',1,2,'subject','LBL_SUBJECT',0,2,'','255',1,258,1,'V~M',1,1,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(83,1709,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',3,259,1,'V~M',1,2,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(83,1710,'announcement_no','u_yf_announcement',1,4,'announcement_no','LBL_NUMBER',0,2,'','255',1,259,2,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(83,1711,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,4,259,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(83,1712,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,2,259,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(83,1713,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,260,1,'V~O',2,3,'BAS',1,'',0,'','0',0,0,0,0,'',NULL),
			(9,1715,'state','vtiger_activity',1,16,'state','LBL_STATE',0,0,'PLL_OPAQUE','255',19,19,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(84,1716,'title','vtiger_reservations',1,2,'title','LBL_TITLE',0,2,'','128',1,261,1,'V~M',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(84,1717,'reservations_no','vtiger_reservations',1,4,'reservations_no','LBL_NUM',0,2,'','255',2,261,2,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(84,1718,'reservations_status','vtiger_reservations',1,15,'reservations_status','LBL_STATUS',0,2,'PLL_TO_APPROVAL','128',2,261,1,'V~M',2,3,'BAS',2,'',1,'',NULL,0,0,0,0,'',NULL),
			(84,1719,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',7,261,1,'V~M',1,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(84,1720,'date_start','vtiger_reservations',1,6,'date_start','LBL_START_DATE',0,0,'',NULL,3,261,1,'D~M',0,6,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(84,1721,'time_start','vtiger_reservations',1,14,'time_start','LBL_TIME_START',0,0,'',NULL,5,261,1,'T~M',1,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(84,1722,'time_end','vtiger_reservations',1,14,'time_end','LBL_END_TIME',0,0,'',NULL,6,261,1,'T~M~OTH~GE~time_start~LBL_TIME_START',1,7,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(84,1723,'due_date','vtiger_reservations',1,23,'due_date','LBL_END_DATE',0,0,'',NULL,4,261,1,'D~M~OTH~GE~date_start~LBL_START_DATE',1,8,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(84,1724,'sum_time','vtiger_reservations',1,8,'sum_time','LBL_TOTAL_TIME',0,2,'','99999999',8,261,2,'NN~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(84,1725,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'',NULL,11,261,2,'DT~O',3,2,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(84,1726,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'',NULL,10,261,2,'DT~O',3,2,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(84,1728,'was_read','vtiger_crmentity',1,56,'was_read','Was read',0,2,'','-128,127',12,261,2,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(84,1729,'type','vtiger_reservations',1,302,'type','LBL_TYPE',0,2,'','128',14,261,1,'V~M',2,2,'BAS',1,'',0,'7',NULL,0,0,0,0,'',NULL),
			(84,1730,'link','vtiger_reservations',1,67,'link','FL_RELATION',0,2,'','-2147483648,2147483647',1,262,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(84,1731,'process','vtiger_reservations',1,66,'process','FL_PROCESS',0,2,'','-2147483648,2147483647',3,262,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(84,1732,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,263,1,'V~O',2,9,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(84,1733,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,263,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(84,1735,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',9,261,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1736,'leads_relation','vtiger_leaddetails',1,16,'leads_relation','LBL_RELATION',0,2,'PLL_B2C','255',9,13,1,'V~M',1,5,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1737,'legal_form','vtiger_leaddetails',1,16,'legal_form','LBL_LEGAL_FORM',0,2,'','255',4,191,1,'V~O',1,6,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1738,'legal_form','vtiger_account',1,16,'legal_form','LBL_LEGAL_FORM',0,2,'','255',1,9,1,'V~M',1,3,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,1740,'emailoptout','vtiger_users',1,56,'emailoptout','Approval for email',0,0,'','255',7,468,1,'V~O',1,NULL,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(41,1741,'projectmilestone_priority','vtiger_projectmilestone',1,15,'projectmilestone_priority','LBL_PRIORITY',0,2,'','255',9,101,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,1742,'estimated_work_time','vtiger_projecttask',1,7,'estimated_work_time','LBL_ESTIMATED_WORK_TIME',0,2,'','0,999999',9,105,1,'NN~M',1,3,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(41,1743,'projectmilestone_progress','vtiger_projectmilestone',1,9,'projectmilestone_progress','LBL_PROGRESS',1,2,'','999',11,101,10,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1744,'jobtitle','vtiger_contactdetails',1,1,'jobtitle','Job title',0,2,'','100',9,4,1,'V~O',1,NULL,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(54,1745,'date','vtiger_ossmailview',1,70,'date','Date of receipt',0,2,'',NULL,14,134,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1746,'decision_maker','vtiger_contactdetails',1,56,'decision_maker','Decision maker',0,2,'','-128,127',8,5,1,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1747,'sum_time','vtiger_account',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',5,198,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1756,'inventorybalance','vtiger_account',1,7,'inventorybalance','LBL_INVENTORY_BALANCE',0,2,'','99999999999999999',7,198,10,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1757,'discount','vtiger_account',1,9,'discount','LBL_DISCOUNT',0,2,'','999',8,198,1,'N~O~2~2',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1758,'creditlimit','vtiger_account',1,304,'creditlimit','LBL_CREDIT_LIMIT',0,2,'','-2147483648,2147483647',9,198,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,1759,'taxes','vtiger_products',1,303,'taxes','LBL_TAXES',0,2,'','50',5,32,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,1762,'followup','vtiger_activity',1,10,'followup','LBL_FOLLOWUP',0,0,'','-2147483648,2147483647',4,87,1,'V~O',1,NULL,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(15,1763,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',2,37,1,'V~M',0,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(19,1764,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',10,46,1,'V~M',0,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(85,1765,'subject','u_yf_squoteenquiries',1,2,'subject','LBL_SUBJECT',0,2,'','255',1,265,1,'V~M',1,NULL,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(85,1766,'category','u_yf_squoteenquiries',1,302,'category','Category',0,2,'','255',2,265,1,'V~O',2,5,'BAS',1,'',1,'8',NULL,0,0,0,0,'',NULL),
			(85,1767,'salesprocessid','u_yf_squoteenquiries',1,10,'salesprocessid','SINGLE_SSalesProcesses',0,2,'','-2147483648,2147483647',3,265,1,'V~O',2,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(85,1768,'squoteenquiries_status','u_yf_squoteenquiries',1,15,'squoteenquiries_status','LBL_STATUS',0,0,'PLL_DRAFT','255',5,265,1,'V~O',2,3,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(85,1769,'accountid','u_yf_squoteenquiries',1,10,'accountid','Accounts',0,2,'','-2147483648,2147483647',4,265,10,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(85,1770,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',6,265,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(85,1771,'squoteenquiries_no','u_yf_squoteenquiries',1,4,'squoteenquiries_no','LBL_NUMBER',0,2,'','255',2,265,2,'V~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(85,1772,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',7,265,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(85,1773,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,266,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(85,1774,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,266,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(85,1776,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,1,268,2,'DT~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(85,1777,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,2,268,2,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,1779,'subject','u_yf_ssalesprocesses',1,2,'subject','LBL_SUBJECT',0,2,'','255',1,269,1,'V~M',1,1,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(86,1780,'category','u_yf_ssalesprocesses',1,302,'category','Category',0,2,'','255',6,269,1,'V~O',2,5,'BAS',1,'',1,'9',NULL,0,0,0,0,'',NULL),
			(86,1781,'related_to','u_yf_ssalesprocesses',1,10,'related_to','SINGLE_Accounts',0,2,'','-2147483648,2147483647',2,269,1,'V~M',2,2,'BAS',1,'',1,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(86,1782,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',3,269,1,'V~M',1,3,'BAS',1,'',1,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(86,1783,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',5,269,1,'V~O',1,NULL,'BAS',1,'',0,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(86,1784,'ssalesprocesses_no','u_yf_ssalesprocesses',1,4,'ssalesprocesses_no','LBL_NUMBER',0,2,'','255',2,270,2,'V~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,1785,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,1,270,2,'DT~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(86,1786,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,270,2,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,1788,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,271,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(87,1789,'subject','u_yf_srequirementscards',1,2,'subject','LBL_SUBJECT',0,2,'','255',1,272,1,'V~M',1,1,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(87,1790,'category','u_yf_srequirementscards',1,302,'category','Category',0,2,'','255',5,272,1,'V~O',2,5,'BAS',1,'',1,'10',NULL,0,0,0,0,'',NULL),
			(87,1791,'salesprocessid','u_yf_srequirementscards',1,10,'salesprocessid','SINGLE_SSalesProcesses',0,2,'','-2147483648,2147483647',2,272,1,'V~M',2,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(87,1792,'quoteenquiryid','u_yf_srequirementscards',1,10,'quoteenquiryid','SINGLE_SQuoteEnquiries',0,2,'','-2147483648,2147483647',3,272,1,'V~M',2,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(87,1793,'srequirementscards_status','u_yf_srequirementscards',1,15,'srequirementscards_status','LBL_STATUS',0,0,'PLL_DRAFT','255',6,272,1,'V~O',2,6,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(87,1794,'accountid','u_yf_srequirementscards',1,10,'accountid','SINGLE_Accounts',0,2,'','-2147483648,2147483647',4,272,10,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(87,1795,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',7,272,1,'V~M',1,3,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(87,1796,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',8,272,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(87,1797,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,273,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(87,1798,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,273,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(87,1800,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,1,275,2,'DT~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(87,1801,'srequirementscards_no','u_yf_srequirementscards',1,4,'srequirementscards_no','LBL_NUMBER',0,2,'','255',2,275,2,'V~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(87,1802,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,275,2,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(88,1804,'subject','u_yf_scalculations',1,2,'subject','LBL_SUBJECT',0,2,'','255',1,276,1,'V~M',1,NULL,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(88,1805,'category','u_yf_scalculations',1,302,'category','Category',0,2,'','255',5,276,1,'V~O',2,5,'BAS',1,'',1,'11',NULL,0,0,0,0,'',NULL),
			(88,1806,'salesprocessid','u_yf_scalculations',1,10,'salesprocessid','SINGLE_SSalesProcesses',0,2,'','-2147483648,2147483647',2,276,1,'V~M',2,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(88,1807,'srequirementscardsid','u_yf_scalculations',1,10,'srequirementscardsid','SINGLE_SRequirementsCards',0,2,'','-2147483648,2147483647',3,276,1,'V~M',2,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(88,1808,'scalculations_status','u_yf_scalculations',1,15,'scalculations_status','LBL_STATUS',0,0,'PLL_DRAFT','255',6,276,1,'V~O',2,6,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(88,1809,'accountid','u_yf_scalculations',1,10,'accountid','SINGLE_Accounts',0,2,'','-2147483648,2147483647',4,276,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(88,1810,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',7,276,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(88,1811,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',8,276,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(88,1812,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,277,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(88,1813,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,277,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(88,1815,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,1,279,2,'DT~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(88,1816,'scalculations_no','u_yf_scalculations',1,4,'scalculations_no','LBL_NUMBER',0,2,'','255',2,279,2,'V~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(88,1817,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,279,2,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1819,'subject','u_yf_squotes',1,2,'subject','LBL_SUBJECT',0,2,'','255',1,280,1,'V~M',1,NULL,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(89,1820,'category','u_yf_squotes',1,302,'category','Category',0,2,'','255',5,280,1,'V~O',2,5,'BAS',1,'',1,'12',NULL,0,0,0,0,'',NULL),
			(89,1821,'salesprocessid','u_yf_squotes',1,10,'salesprocessid','SINGLE_SSalesProcesses',0,2,'','-2147483648,2147483647',2,280,1,'V~M',2,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(89,1822,'scalculationsid','u_yf_squotes',1,10,'scalculationsid','SINGLE_SCalculations',0,2,'','-2147483648,2147483647',3,280,1,'V~M',2,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(89,1823,'squotes_status','u_yf_squotes',1,15,'squotes_status','LBL_STATUS',0,0,'PLL_DRAFT','255',6,280,1,'V~O',2,6,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(89,1824,'accountid','u_yf_squotes',1,10,'accountid','SINGLE_Accounts',0,2,'','-2147483648,2147483647',4,280,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1825,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',7,280,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(89,1826,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',8,280,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1827,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,281,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1828,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,281,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1830,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,1,283,2,'DT~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(89,1831,'squotes_no','u_yf_squotes',1,4,'squotes_no','LBL_NUMBER',0,2,'','255',2,283,2,'V~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1832,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,283,2,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1834,'subject','u_yf_ssingleorders',1,2,'subject','LBL_SUBJECT',0,2,'','255',1,284,1,'V~M',1,1,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(90,1835,'category','u_yf_ssingleorders',1,302,'category','Category',0,2,'','255',5,284,1,'V~O',2,4,'BAS',1,'',1,'13',NULL,0,0,0,0,'',NULL),
			(90,1836,'salesprocessid','u_yf_ssingleorders',1,10,'salesprocessid','SINGLE_SSalesProcesses',0,2,'','-2147483648,2147483647',2,284,1,'V~O',1,3,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(90,1837,'squotesid','u_yf_ssingleorders',1,10,'squotesid','SINGLE_SQuotes',0,2,'','-2147483648,2147483647',3,284,1,'V~O',1,2,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(90,1838,'ssingleorders_status','u_yf_ssingleorders',1,15,'ssingleorders_status','LBL_STATUS',0,0,NULL,'255',9,284,1,'V~O',2,8,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(90,1839,'accountid','u_yf_ssingleorders',1,10,'accountid','SINGLE_Accounts',0,2,'','-2147483648,2147483647',4,284,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1840,'date_start','u_yf_ssingleorders',1,5,'date_start','LBL_REALIZATION_START_DATE',0,2,'',NULL,8,284,1,'D~O',2,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(90,1841,'date_end','u_yf_ssingleorders',1,5,'date_end','LBL_REALIZATION_COMPLETION_DATE',0,2,'',NULL,7,284,1,'D~O',2,6,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(90,1842,'duedate','u_yf_ssingleorders',1,5,'duedate','LBL_ACTUAL_COMPLETION_DATE',0,2,'',NULL,10,284,1,'D~O',2,7,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(90,1843,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',12,284,1,'V~M',1,9,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(90,1844,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',11,284,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1845,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,285,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1846,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,285,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1848,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,1,287,2,'DT~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(90,1849,'ssingleorders_no','u_yf_ssingleorders',1,4,'ssingleorders_no','LBL_NUMBER',0,2,'','255',2,287,2,'V~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1850,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,287,2,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1852,'subject','u_yf_srecurringorders',1,2,'subject','LBL_SUBJECT',0,2,'','255',1,288,1,'V~M',1,NULL,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(91,1853,'category','u_yf_srecurringorders',1,302,'category','Category',0,2,'','255',5,288,1,'V~O',2,4,'BAS',1,'',1,'14',NULL,0,0,0,0,'',NULL),
			(91,1854,'salesprocessid','u_yf_srecurringorders',1,10,'salesprocessid','SINGLE_SSalesProcesses',0,2,'','-2147483648,2147483647',2,288,1,'V~M',2,3,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(91,1855,'squotesid','u_yf_srecurringorders',1,10,'squotesid','SINGLE_SQuotes',0,2,'','-2147483648,2147483647',3,288,1,'V~M',2,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(91,1856,'srecurringorders_status','u_yf_srecurringorders',1,15,'srecurringorders_status','LBL_STATUS',0,0,'PLL_DRAFT','255',9,288,10,'V~O',2,8,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(91,1857,'accountid','u_yf_srecurringorders',1,10,'accountid','SINGLE_Accounts',0,2,'','-2147483648,2147483647',4,288,10,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1858,'date_start','u_yf_srecurringorders',1,5,'date_start','LBL_REALIZATION_START_DATE',0,2,'',NULL,6,288,1,'D~O',2,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(91,1859,'date_end','u_yf_srecurringorders',1,5,'date_end','LBL_REALIZATION_COMPLETION_DATE',0,2,'',NULL,7,288,1,'D~O',2,6,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(91,1860,'duedate','u_yf_srecurringorders',1,5,'duedate','LBL_ACTUAL_COMPLETION_DATE',0,2,'',NULL,8,288,1,'D~O',2,7,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(91,1861,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',10,288,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(91,1862,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',11,288,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1863,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,289,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1864,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,289,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1866,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,1,291,2,'DT~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(91,1867,'srecurringorders_no','u_yf_srecurringorders',1,4,'srecurringorders_no','LBL_NUMBER',0,2,'','255',2,291,2,'V~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1868,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,291,2,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1870,'target_module','u_yf_recurring_info',1,301,'target_module','LBL_TARGET_MODULE',0,0,'','25',1,292,1,'V~M',2,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1871,'start_period','u_yf_recurring_info',1,5,'start_period','LBL_START_PERIOD',0,0,'',NULL,3,292,1,'D~M',2,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(91,1872,'end_period','u_yf_recurring_info',1,5,'end_period','LBL_END_PERIOD',0,0,'',NULL,4,292,1,'D~M~OTH~G~start_period~LBL_START_PERIOD',2,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(91,1873,'recurring_frequency','u_yf_recurring_info',1,16,'recurring_frequency','LBL_FREQUENCY',0,0,'','100',2,292,1,'V~M',2,8,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(91,1874,'date_start','u_yf_recurring_info',1,5,'date_start','LBL_REALIZATION_START_DATE',0,0,'',NULL,5,292,10,'D~0',2,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(91,1875,'date_end','u_yf_recurring_info',1,5,'date_end','LBL_REALIZATION_COMPLETION_DATE',0,0,'',NULL,6,292,10,'D~0',2,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(89,1876,'addresslevel1a','u_yf_squotes_address',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,293,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1877,'addresslevel2a','u_yf_squotes_address',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,293,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1878,'addresslevel3a','u_yf_squotes_address',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,293,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1879,'addresslevel4a','u_yf_squotes_address',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,293,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1880,'addresslevel5a','u_yf_squotes_address',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,293,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1881,'addresslevel6a','u_yf_squotes_address',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,293,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1882,'addresslevel7a','u_yf_squotes_address',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,293,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1883,'addresslevel8a','u_yf_squotes_address',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,293,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1892,'buildingnumbera','u_yf_squotes_address',1,1,'buildingnumbera','Building number',0,2,'','255',4,293,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1893,'localnumbera','u_yf_squotes_address',1,1,'localnumbera','Local number',0,2,'','50',2,293,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1896,'poboxa','u_yf_squotes_address',1,1,'poboxa','Po Box',0,2,'','50',11,293,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1898,'addresslevel1a','u_yf_ssingleorders_address',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,295,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1899,'addresslevel2a','u_yf_ssingleorders_address',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,295,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1900,'addresslevel3a','u_yf_ssingleorders_address',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,295,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1901,'addresslevel4a','u_yf_ssingleorders_address',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,295,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1902,'addresslevel5a','u_yf_ssingleorders_address',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,295,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1903,'addresslevel6a','u_yf_ssingleorders_address',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,295,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1904,'addresslevel7a','u_yf_ssingleorders_address',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,295,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1905,'addresslevel8a','u_yf_ssingleorders_address',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,295,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1914,'buildingnumbera','u_yf_ssingleorders_address',1,1,'buildingnumbera','Building number',0,2,'','255',4,295,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1915,'localnumbera','u_yf_ssingleorders_address',1,1,'localnumbera','Local number',0,2,'','50',2,295,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,1918,'poboxa','u_yf_ssingleorders_address',1,1,'poboxa','Po Box',0,2,'','50',11,295,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1920,'addresslevel1a','u_yf_srecurringorders_address',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,297,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1921,'addresslevel2a','u_yf_srecurringorders_address',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,297,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1922,'addresslevel3a','u_yf_srecurringorders_address',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,297,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1923,'addresslevel4a','u_yf_srecurringorders_address',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,297,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1924,'addresslevel5a','u_yf_srecurringorders_address',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,297,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1925,'addresslevel6a','u_yf_srecurringorders_address',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,297,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1926,'addresslevel7a','u_yf_srecurringorders_address',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,297,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1927,'addresslevel8a','u_yf_srecurringorders_address',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,297,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1936,'buildingnumbera','u_yf_srecurringorders_address',1,1,'buildingnumbera','Building number',0,2,'','255',4,297,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1937,'localnumbera','u_yf_srecurringorders_address',1,1,'localnumbera','Local number',0,2,'','50',2,297,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1940,'poboxa','u_yf_srecurringorders_address',1,1,'poboxa','Po Box',0,2,'','50',11,297,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,1942,'company','u_yf_squotes',1,1,'company','LBL_COMPANY_NAME',0,2,'','255',9,280,10,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,1944,'company','u_yf_srecurringorders',1,1,'company','LBL_COMPANY_NAME',0,2,'','255',12,288,10,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,1945,'products','vtiger_account',1,305,'products','Products',0,2,'','65535',10,196,5,'V~O',1,NULL,'BAS',1,'',0,'{\"module\":\"Products\",\"field\":\"173\",\"filterField\":\"-\",\"filterValue\":null}',NULL,0,0,0,0,'',NULL),
			(6,1946,'services','vtiger_account',1,305,'services','Services',0,2,'','65535',11,196,5,'V~O',1,NULL,'BAS',1,'',0,'{\"module\":\"Services\",\"field\":\"560\",\"filterField\":\"-\",\"filterValue\":null}',NULL,0,0,0,0,'',NULL),
			(37,1947,'pscategory','vtiger_assets',1,302,'pscategory','Category',0,2,'','255',17,95,1,'V~O',1,NULL,'BAS',1,'',0,'15',NULL,0,0,0,0,'',NULL),
			(92,1948,'subject','u_yf_partners',1,2,'subject','LBL_SUBJECT',0,2,'','255',1,299,1,'V~M',1,1,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(92,1949,'vat_id','u_yf_partners',1,1,'vat_id','LBL_VAT_ID',0,2,'','50',2,299,1,'V~O',1,NULL,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(92,1950,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',3,299,1,'V~M',1,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(92,1951,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',4,299,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,1952,'partners_no','u_yf_partners',1,4,'partners_no','LBL_NUMBER',0,2,'','255',2,300,2,'V~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,1953,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,1,300,2,'DT~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(92,1954,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,300,2,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,1956,'addresslevel1a','u_yf_partners_address',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,301,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,1957,'addresslevel2a','u_yf_partners_address',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,301,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,1958,'addresslevel3a','u_yf_partners_address',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,301,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,1959,'addresslevel4a','u_yf_partners_address',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,301,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,1960,'addresslevel5a','u_yf_partners_address',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,301,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,1961,'addresslevel6a','u_yf_partners_address',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,301,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,1962,'addresslevel7a','u_yf_partners_address',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,301,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,1963,'addresslevel8a','u_yf_partners_address',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,301,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,1964,'buildingnumbera','u_yf_partners_address',1,1,'buildingnumbera','Building number',0,2,'','255',4,301,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,1965,'localnumbera','u_yf_partners_address',1,1,'localnumbera','Local number',0,2,'','50',2,301,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,1966,'poboxa','u_yf_partners_address',1,1,'poboxa','Po Box',0,2,'','50',11,301,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,1967,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,302,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1968,'subject','u_yf_competition',1,2,'subject','LBL_SUBJECT',0,2,'','255',1,303,1,'V~M',1,1,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(93,1969,'vat_id','u_yf_competition',1,1,'vat_id','LBL_VAT_ID',0,2,'','50',2,303,1,'V~O',1,NULL,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(93,1970,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',3,303,1,'V~M',1,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(93,1971,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',4,303,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1972,'competition_no','u_yf_competition',1,4,'competition_no','LBL_NUMBER',0,2,'','255',2,304,2,'V~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1973,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,1,304,2,'DT~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(93,1974,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,304,2,'DT~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1976,'addresslevel1a','u_yf_competition_address',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,305,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1977,'addresslevel2a','u_yf_competition_address',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,305,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1978,'addresslevel3a','u_yf_competition_address',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,305,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1979,'addresslevel4a','u_yf_competition_address',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,305,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1980,'addresslevel5a','u_yf_competition_address',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,305,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1981,'addresslevel6a','u_yf_competition_address',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,305,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1982,'addresslevel7a','u_yf_competition_address',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,305,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1983,'addresslevel8a','u_yf_competition_address',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,305,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1984,'buildingnumbera','u_yf_competition_address',1,1,'buildingnumbera','Building number',0,2,'','255',4,305,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1985,'localnumbera','u_yf_competition_address',1,1,'localnumbera','Local number',0,2,'','50',2,305,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1986,'poboxa','u_yf_competition_address',1,1,'poboxa','Po Box',0,2,'','50',11,305,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,1987,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,306,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(59,1988,'ssalesprocessesid','vtiger_outsourcedproducts',1,10,'ssalesprocessesid','SINGLE_SSalesProcesses',0,2,'','-2147483648,2147483647',31,144,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,1989,'ssalesprocessesid','vtiger_assets',1,10,'ssalesprocessesid','SINGLE_SSalesProcesses',0,2,'','-2147483648,2147483647',18,95,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(57,1990,'ssalesprocessesid','vtiger_ossoutsourcedservices',1,10,'ssalesprocessesid','SINGLE_SSalesProcesses',0,2,'','-2147483648,2147483647',16,138,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,1991,'ssalesprocessesid','vtiger_osssoldservices',1,10,'ssalesprocessesid','SINGLE_SSalesProcesses',0,2,'','-2147483648,2147483647',10,141,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,1992,'subprocess','vtiger_activity',1,68,'subprocess','FL_SUB_PROCESS',0,0,'','-2147483648,2147483647',3,87,1,'I~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(51,1994,'process','vtiger_osstimecontrol',1,66,'process','FL_PROCESS',0,2,'','-2147483648,2147483647',11,129,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(51,1995,'link','vtiger_osstimecontrol',1,67,'link','FL_RELATION',0,2,'','-2147483648,2147483647',12,129,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(51,1996,'subprocess','vtiger_osstimecontrol',1,68,'subprocess','FL_SUB_PROCESS',0,2,'','-2147483648,2147483647',13,129,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,1997,'sum_time','vtiger_contactdetails',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',9,5,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,1998,'sum_time','vtiger_leaddetails',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',10,14,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,1999,'sum_time','vtiger_vendor',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',19,42,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,2000,'sum_time','u_yf_partners',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',5,300,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,2001,'sum_time','u_yf_competition',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',5,304,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,2002,'sum_time','vtiger_ossemployees',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',15,151,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2003,'sum_time','u_yf_ssalesprocesses',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',5,270,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,2004,'sum_time','vtiger_campaign',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',1,74,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(41,2005,'sum_time','vtiger_projectmilestone',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',5,102,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(85,2006,'sum_time','u_yf_squoteenquiries',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',2,267,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(87,2007,'sum_time','u_yf_srequirementscards',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',2,274,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(88,2008,'sum_time','u_yf_scalculations',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',2,278,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,2009,'sum_time','u_yf_squotes',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',2,282,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2010,'sum_time','u_yf_ssingleorders',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',2,286,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,2011,'sum_time','u_yf_srecurringorders',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',2,290,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,2012,'email','u_yf_partners',1,13,'email','Email',0,2,'','100',5,299,1,'E~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,2013,'email','u_yf_competition',1,13,'email','Email',0,2,'','100',5,303,1,'E~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,2014,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',10,5,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,2015,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',12,196,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,2016,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',11,14,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,2017,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',16,27,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,2018,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',20,42,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,2019,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',17,74,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(34,2020,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',2,90,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,2021,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',8,108,2,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,2022,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',16,151,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(85,2023,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',4,268,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2024,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',6,270,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(87,2025,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',5,275,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(88,2026,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',5,279,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,2027,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',5,283,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2028,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',5,287,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,2029,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',5,291,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,2030,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',6,300,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,2031,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',6,304,2,'I~O',1,NULL,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(94,2032,'subject','u_yf_fbookkeeping',1,2,'subject','FL_SUBJECT',0,2,'','255',1,307,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(94,2033,'number','u_yf_fbookkeeping',1,4,'number','FL_NUMBER',0,2,'','32',1,308,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(94,2034,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',3,307,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(94,2035,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,2,308,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(94,2036,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,308,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(94,2037,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,309,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(94,2038,'related_to','u_yf_fbookkeeping',1,10,'related_to','SINGLE_Accounts',0,2,'','-2147483648,2147483647',2,307,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(94,2039,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',4,307,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2040,'subject','u_yf_finvoice',1,2,'subject','FL_SUBJECT',0,2,'','255',1,310,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(95,2041,'paymentdate','u_yf_finvoice',1,5,'paymentdate','FL_PAYMENT_DATE',0,2,'',NULL,2,310,1,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2042,'saledate','u_yf_finvoice',1,5,'saledate','FL_SALE_DATE',0,2,'',NULL,3,310,1,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2043,'accountid','u_yf_finvoice',1,10,'accountid','FL_ACCOUNT',0,2,'','-2147483648,2147483647',6,310,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2044,'finvoice_formpayment','u_yf_finvoice',1,16,'payment_methods','FL_PAYMENTS_METHOD',0,2,'','255',5,310,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2046,'number','u_yf_finvoice',1,4,'number','FL_NUMBER',0,2,'','32',1,311,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2047,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',2,311,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2048,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,3,311,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2049,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,4,311,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2050,'poboxa','u_yf_finvoice_address',1,1,'poboxa','Po Box',0,2,'','50',11,312,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2051,'localnumbera','u_yf_finvoice_address',1,1,'localnumbera','Local number',0,2,'','50',2,312,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2052,'buildingnumbera','u_yf_finvoice_address',1,1,'buildingnumbera','Building number',0,2,'','255',4,312,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2053,'addresslevel8a','u_yf_finvoice_address',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,312,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2054,'addresslevel7a','u_yf_finvoice_address',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,312,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2055,'addresslevel6a','u_yf_finvoice_address',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,312,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2056,'addresslevel5a','u_yf_finvoice_address',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,312,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2057,'addresslevel4a','u_yf_finvoice_address',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,312,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2058,'addresslevel3a','u_yf_finvoice_address',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,312,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2059,'addresslevel2a','u_yf_finvoice_address',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,312,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2060,'addresslevel1a','u_yf_finvoice_address',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,312,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2072,'sum_total','u_yf_finvoice',1,317,'sum_total','FL_TOTAL',0,2,'','1.0E+20',5,311,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2073,'sum_gross','u_yf_finvoice',1,317,'sum_gross','FL_GROSS',0,2,'','1.0E+20',6,311,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2074,'finvoice_status','u_yf_finvoice',1,15,'finvoice_status','FL_STATUS',0,2,'','255',8,310,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(96,2075,'subject','u_yf_knowledgebase',1,2,'subject','FL_SUBJECT',0,2,'','255',1,314,1,'V~M',1,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(96,2076,'number','u_yf_knowledgebase',1,4,'number','FL_NUMBER',0,2,'','32',1,438,2,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(96,2077,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',2,314,1,'V~M',1,5,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(96,2078,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,3,438,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(96,2079,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,4,438,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(96,2080,'smcreatorid','vtiger_crmentity',1,52,'smcreatorid','Created By',0,2,'','65535',5,438,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(96,2081,'content','u_yf_knowledgebase',1,300,'content','FL_CONTENT',0,2,'','16777215',1,315,1,'V~O',2,6,'BAS',1,'',0,'','0',0,0,0,0,'',NULL),
			(96,2082,'category','u_yf_knowledgebase',1,302,'category','FL_CATEGORY',0,2,'','200',3,314,1,'V~M',2,3,'BAS',1,'',1,'16','0',0,0,0,0,'',NULL),
			(97,2083,'subject','u_yf_istorages',1,2,'subject','FL_SUBJECT',0,2,'','255',1,316,1,'V~M',1,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(97,2084,'parentid','u_yf_istorages',1,10,'parentid','FL_PARENT_STORAGE',0,2,'','-2147483648,2147483647',2,316,1,'V~O',2,2,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2085,'storage_status','u_yf_istorages',1,15,'storage_status','FL_STATUS',0,2,'','255',3,316,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(97,2086,'storage_type','u_yf_istorages',1,16,'storage_type','FL_TYPE',0,2,'PLL_INTERNAL','255',4,316,10,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(97,2087,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',5,316,1,'V~M',1,3,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2088,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',6,316,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2089,'number','u_yf_istorages',1,4,'number','FL_NUMBER',0,2,'','32',1,317,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2090,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,2,317,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2091,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,317,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2092,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,318,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2093,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',1,343,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2094,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',1,319,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2095,'estimated','u_yf_ssalesprocesses',1,71,'estimated','FL_ESTIMATED',0,2,'','1.0E+20',1,320,1,'N~M',1,7,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2096,'actual_sale','u_yf_ssalesprocesses',1,71,'actual_sale','FL_ACTUAL_SALE',0,2,'','1.0E+20',2,320,10,'N~O',2,9,'BAS',1,'',0,'','0',0,0,0,0,'',NULL),
			(86,2097,'estimated_date','u_yf_ssalesprocesses',1,5,'estimated_date','FL_ESTIMATED_DATE',0,2,'',NULL,12,269,1,'D~M',2,6,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2098,'actual_date','u_yf_ssalesprocesses',1,5,'actual_date','FL_ACTUAL_DATE',0,2,'',NULL,13,269,10,'D~O',2,8,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2099,'probability','u_yf_ssalesprocesses',1,9,'probability','FL_PROBABILITY',0,2,'','999',9,269,1,'N~O~2~2',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2100,'ssalesprocesses_source','u_yf_ssalesprocesses',1,16,'ssalesprocesses_source','FL_SOURCE',0,2,'','255',8,269,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2101,'ssalesprocesses_type','u_yf_ssalesprocesses',1,16,'ssalesprocesses_type','FL_TYPE',0,2,'PLL_NEW_SALES','255',7,269,1,'V~M',1,4,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2102,'ssalesprocesses_status','u_yf_ssalesprocesses',1,15,'ssalesprocesses_status','FL_STATUS',0,2,'','255',10,269,1,'V~O',1,NULL,'BAS',1,'',0,'{\"isProcessStatusField\":true}',NULL,0,0,0,0,'',NULL),
			(88,2103,'sum_total','u_yf_scalculations',1,317,'sum_total','FL_TOTAL_PRICE',0,2,'','1.0E+20',3,278,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(88,2104,'sum_marginp','u_yf_scalculations',1,7,'sum_marginp','FL_MARGINP',0,2,'','99999999',4,278,3,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(88,2105,'sum_margin','u_yf_scalculations',1,7,'sum_margin','FL_MARGIN',0,2,'','1.0E+20',5,278,3,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,2106,'sum_total','u_yf_squotes',1,317,'sum_total','FL_TOTAL_PRICE',0,2,'','1.0E+20',3,282,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,2107,'sum_marginp','u_yf_squotes',1,7,'sum_marginp','FL_MARGINP',0,2,'','99999999',4,282,3,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,2108,'sum_margin','u_yf_squotes',1,7,'sum_margin','FL_MARGIN',0,2,'','1.0E+20',5,282,3,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,2109,'sum_gross','u_yf_squotes',1,317,'sum_gross','FL_SUM_GROSS',0,2,'','1.0E+20',6,282,2,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,2110,'sum_discount','u_yf_squotes',1,7,'sum_discount','FL_SUM_DISCOUNT',0,2,'','1.0E+20',7,282,2,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2111,'sum_total','u_yf_ssingleorders',1,317,'sum_total','FL_TOTAL_PRICE',0,2,'','1.0E+20',3,286,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2112,'sum_marginp','u_yf_ssingleorders',1,7,'sum_marginp','FL_MARGINP',0,2,'','99999999',4,286,3,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2113,'sum_margin','u_yf_ssingleorders',1,7,'sum_margin','FL_MARGIN',0,2,'','1.0E+20',5,286,3,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2114,'sum_gross','u_yf_ssingleorders',1,317,'sum_gross','FL_SUM_GROSS',0,2,'','1.0E+20',6,286,2,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2115,'sum_discount','u_yf_ssingleorders',1,7,'sum_discount','FL_SUM_DISCOUNT',0,2,'','1.0E+20',7,286,2,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(98,2116,'subject','u_yf_igrn',1,2,'subject','FL_SUBJECT',0,2,'','255',1,321,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(98,2117,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',6,321,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(98,2118,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',7,321,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(98,2119,'number','u_yf_igrn',1,4,'number','FL_NUMBER',0,2,'','32',1,322,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(98,2120,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,2,322,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(98,2121,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,322,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2122,'subject','u_yf_finvoiceproforma',1,2,'subject','FL_SUBJECT',0,2,'','255',1,323,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(99,2123,'paymentdate','u_yf_finvoiceproforma',1,5,'paymentdate','FL_PAYMENT_DATE',0,2,'',NULL,2,323,1,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2124,'saledate','u_yf_finvoiceproforma',1,5,'saledate','FL_SALE_DATE',0,2,'',NULL,3,323,1,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2125,'accountid','u_yf_finvoiceproforma',1,10,'accountid','FL_ACCOUNT',0,2,'','-2147483648,2147483647',4,323,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(99,2126,'finvoiceproforma_formpayment','u_yf_finvoiceproforma',1,16,'payment_methods','FL_PAYMENTS_METHOD',0,2,'','255',5,323,1,'T~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2127,'finvoiceproforma_status','u_yf_finvoiceproforma',1,15,'finvoiceproforma_status','FL_STATUS',0,2,'','255',6,323,1,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2128,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',3,324,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2129,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,4,324,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2130,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,5,324,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2131,'number','u_yf_finvoiceproforma',1,4,'number','FL_NUMBER',0,2,'','32',1,324,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2132,'sum_total','u_yf_finvoiceproforma',1,317,'sum_total','FL_TOTAL',0,2,'','1.0E+20',6,324,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2133,'sum_gross','u_yf_finvoiceproforma',1,317,'sum_gross','FL_GROSS',0,2,'','1.0E+20',7,324,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2134,'addresslevel1a','u_yf_finvoiceproforma_address',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,325,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2135,'addresslevel2a','u_yf_finvoiceproforma_address',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,325,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2136,'addresslevel3a','u_yf_finvoiceproforma_address',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,325,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2137,'addresslevel4a','u_yf_finvoiceproforma_address',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,325,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2138,'addresslevel5a','u_yf_finvoiceproforma_address',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,325,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2139,'addresslevel6a','u_yf_finvoiceproforma_address',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,325,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2140,'addresslevel7a','u_yf_finvoiceproforma_address',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,325,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2141,'addresslevel8a','u_yf_finvoiceproforma_address',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,325,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2142,'poboxa','u_yf_finvoiceproforma_address',1,1,'poboxa','Po Box',0,2,'','50',11,325,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2143,'localnumbera','u_yf_finvoiceproforma_address',1,1,'localnumbera','Local number',0,2,'','50',2,325,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2144,'buildingnumbera','u_yf_finvoiceproforma_address',1,1,'buildingnumbera','Building number',0,2,'','255',4,325,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(100,2156,'subject','u_yf_igdn',1,2,'subject','FL_SUBJECT',0,2,'','255',1,327,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(100,2157,'storageid','u_yf_igdn',1,10,'storageid','FL_STORAGE',0,2,'','-2147483648,2147483647',2,327,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(100,2158,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',7,327,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(100,2159,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',6,327,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(100,2160,'number','u_yf_igdn',1,4,'number','FL_NUMBER',0,2,'','32',1,328,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(100,2161,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,2,328,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(100,2162,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,328,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(101,2163,'subject','u_yf_iidn',1,2,'subject','FL_SUBJECT',0,2,'','255',1,329,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(101,2164,'storageid','u_yf_iidn',1,10,'storageid','FL_STORAGE',0,2,'','-2147483648,2147483647',2,329,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(101,2165,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',5,329,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(101,2166,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',6,329,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(101,2167,'number','u_yf_iidn',1,4,'number','FL_NUMBER',0,2,'','32',1,330,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(101,2168,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,2,330,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(101,2169,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,330,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(98,2170,'storageid','u_yf_igrn',1,10,'storageid','FL_STORAGE',0,2,'','-2147483648,2147483647',2,321,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(102,2171,'subject','u_yf_igin',1,2,'subject','FL_SUBJECT',0,2,'','255',1,331,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(102,2172,'storageid','u_yf_igin',1,10,'storageid','FL_STORAGE',0,2,'','-2147483648,2147483647',2,331,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(102,2173,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',5,331,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(102,2174,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',6,331,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(102,2175,'number','u_yf_igin',1,4,'number','FL_NUMBER',0,2,'','32',1,332,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(102,2176,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,2,332,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(102,2177,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,332,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(98,2178,'igrn_status','u_yf_igrn',1,15,'igrn_status','FL_STATUS',0,2,'','255',4,321,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(100,2179,'igdn_status','u_yf_igdn',1,15,'igdn_status','FL_STATUS',0,2,'','255',4,327,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(101,2180,'iidn_status','u_yf_iidn',1,15,'iidn_status','FL_STATUS',0,2,'','255',3,329,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(102,2181,'igin_status','u_yf_igin',1,15,'igin_status','FL_STATUS',0,2,'','255',3,331,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(103,2182,'subject','u_yf_ipreorder',1,2,'subject','FL_SUBJECT',0,2,'','255',1,333,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(103,2183,'storageid','u_yf_ipreorder',1,10,'storageid','FL_STORAGE',0,2,'','-2147483648,2147483647',2,333,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(103,2184,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',7,333,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(103,2185,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',6,333,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(103,2186,'number','u_yf_ipreorder',1,4,'number','FL_NUMBER',0,2,'','32',1,334,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(103,2187,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,2,334,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(103,2188,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,334,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(98,2189,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,335,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(98,2190,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',1,336,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(98,2191,'vendorid','u_yf_igrn',1,10,'vendorid','FL_VENDOR',0,2,'','-2147483648,2147483647',3,321,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(98,2192,'acceptance_date','u_yf_igrn',1,5,'acceptance_date','FL_ACCEPTANCE_DATE',0,2,'',NULL,5,321,1,'D~O',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(100,2193,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,337,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(100,2194,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',1,338,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(100,2195,'accountid','u_yf_igdn',1,10,'accountid','FL_ACCOUNT',0,2,'','-2147483648,2147483647',3,327,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(100,2196,'acceptance_date','u_yf_igdn',1,5,'acceptance_date','FL_ACCEPTANCE_DATE',0,2,'',NULL,5,327,1,'D~O',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(101,2197,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,339,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(101,2198,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',1,340,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(101,2199,'acceptance_date','u_yf_iidn',1,5,'acceptance_date','FL_ACCEPTANCE_DATE',0,2,'',NULL,4,329,1,'D~O',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(102,2200,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,341,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(102,2201,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',1,342,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(102,2202,'acceptance_date','u_yf_igin',1,5,'acceptance_date','FL_ACCEPTANCE_DATE',0,2,'',NULL,4,331,1,'D~O',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(103,2203,'ipreorder_status','u_yf_ipreorder',1,15,'ipreorder_status','FL_STATUS',0,2,'','255',4,333,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(103,2204,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,344,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(103,2205,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',1,345,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(103,2206,'accountid','u_yf_ipreorder',1,10,'accountid','FL_ACCOUNT',0,2,'','-2147483648,2147483647',3,333,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(103,2207,'acceptance_date','u_yf_ipreorder',1,5,'acceptance_date','FL_ACCEPTANCE_DATE',0,2,'',NULL,5,333,1,'D~O',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(14,2208,'ean','vtiger_products',1,1,'ean','FL_EAN_SKU',0,2,'','64',28,31,1,'V~O',2,3,'BAS',1,'',1,'{\"mask\":\"9999999999999\"}',NULL,0,0,0,0,'',NULL),
			(98,2209,'sum_total','u_yf_igrn',1,317,'sum_total','LBL_TOTAL_PRICE',0,2,'','1.0E+20',4,322,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(96,2210,'knowledgebase_view','u_yf_knowledgebase',1,16,'knowledgebase_view','FL_VIEWS',0,2,'','255',4,314,1,'V~M',2,4,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(97,2211,'addresslevel1a','u_yf_istorages_address',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,346,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2212,'addresslevel2a','u_yf_istorages_address',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,346,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2213,'addresslevel3a','u_yf_istorages_address',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,346,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2214,'addresslevel4a','u_yf_istorages_address',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,346,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2215,'addresslevel5a','u_yf_istorages_address',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,346,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2216,'addresslevel6a','u_yf_istorages_address',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,346,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2217,'addresslevel7a','u_yf_istorages_address',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,346,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2218,'addresslevel8a','u_yf_istorages_address',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,346,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2219,'buildingnumbera','u_yf_istorages_address',1,1,'buildingnumbera','Building number',0,2,'','255',4,346,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2220,'localnumbera','u_yf_istorages_address',1,1,'localnumbera','Local number',0,2,'','50',2,346,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2221,'poboxa','u_yf_istorages_address',1,1,'poboxa','Po Box',0,2,'','50',11,346,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(104,2222,'subject','u_yf_istdn',1,2,'subject','FL_SUBJECT',0,2,'','255',1,347,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(104,2223,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',6,347,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(104,2224,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',7,347,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(104,2225,'storageid','u_yf_istdn',1,10,'storageid','FL_STORAGE',0,2,'','-2147483648,2147483647',2,347,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(104,2226,'istdn_status','u_yf_istdn',1,15,'istdn_status','FL_STATUS',0,2,'','255',4,347,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(104,2227,'accountid','u_yf_istdn',1,10,'accountid','FL_ACCOUNT',0,2,'','-2147483648,2147483647',3,347,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(104,2228,'acceptance_date','u_yf_istdn',1,5,'acceptance_date','FL_ACCEPTANCE_DATE',0,2,'',NULL,5,347,1,'D~O',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(104,2229,'number','u_yf_istdn',1,4,'number','FL_NUMBER',0,2,'','32',1,348,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(104,2230,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,2,348,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(104,2231,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,348,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(104,2232,'sum_total','u_yf_istdn',1,317,'sum_total','LBL_TOTAL_PRICE',0,2,'','1.0E+20',4,348,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(104,2233,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,349,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(104,2234,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',1,350,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(105,2235,'subject','u_yf_istn',1,2,'subject','FL_SUBJECT',0,2,'','255',1,351,1,'V~M',1,1,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(105,2236,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',6,351,1,'V~M',1,3,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(105,2237,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',5,351,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(105,2238,'istn_status','u_yf_istn',1,15,'istn_status','FL_STATUS',0,2,'','255',2,351,1,'V~M',1,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(105,2239,'estimated_date','u_yf_istn',1,5,'estimated_date','FL_ESTIMATED_DATE',0,2,'',NULL,4,351,1,'D~O',2,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(105,2240,'number','u_yf_istn',1,4,'number','FL_NUMBER',0,2,'','32',1,352,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(105,2241,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,2,352,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(105,2242,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,352,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(105,2243,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,353,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(105,2244,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',1,354,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(105,2245,'istn_type','u_yf_istn',1,16,'istn_type','FL_TYPE',0,2,'','255',3,351,1,'V~O',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(106,2246,'subject','u_yf_istrn',1,2,'subject','FL_SUBJECT',0,2,'','255',1,355,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(106,2247,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',6,355,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(106,2248,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',7,355,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(106,2249,'storageid','u_yf_istrn',1,10,'storageid','FL_STORAGE',0,2,'','-2147483648,2147483647',2,355,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(106,2250,'istrn_status','u_yf_istrn',1,15,'istrn_status','FL_STATUS',0,2,'','255',4,355,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(106,2251,'vendorid','u_yf_istrn',1,10,'vendorid','FL_VENDOR',0,2,'','-2147483648,2147483647',3,355,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(106,2252,'acceptance_date','u_yf_istrn',1,5,'acceptance_date','FL_ACCEPTANCE_DATE',0,2,'',NULL,5,355,1,'D~O',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(106,2253,'number','u_yf_istrn',1,4,'number','FL_NUMBER',0,2,'','32',1,356,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(106,2254,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,2,356,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(106,2255,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,356,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(106,2256,'sum_total','u_yf_istrn',1,317,'sum_total','LBL_TOTAL_PRICE',0,2,'','1.0E+20',4,356,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(106,2257,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,357,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(106,2258,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',1,358,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(104,2259,'process','u_yf_istdn',1,10,'process','FL_PROCESS',0,2,'','-2147483648,2147483647',8,347,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(106,2260,'process','u_yf_istrn',1,10,'process','FL_PROCESS',0,2,'','-2147483648,2147483647',8,355,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(104,2261,'subprocess','u_yf_istdn',1,10,'subprocess','FL_SUB_PROCESS',0,2,'','-2147483648,2147483647',9,347,10,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(106,2262,'subprocess','u_yf_istrn',1,10,'subprocess','FL_SUB_PROCESS',0,2,'','-2147483648,2147483647',9,355,1,'I~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(96,2263,'knowledgebase_status','u_yf_knowledgebase',1,15,'knowledgebase_status','FL_STATUS',0,2,'','255',5,314,1,'V~M',2,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(96,2266,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,NULL,'65535',2,438,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,2267,'osssoldservices_renew','vtiger_osssoldservices',1,15,'osssoldservices_renew','FL_RENEWAL',0,0,'','255',11,141,10,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,2268,'assets_renew','vtiger_assets',1,15,'assets_renew','FL_RENEWAL',0,0,'','255',19,95,10,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,2269,'subunit','vtiger_products',1,16,'subunit','FL_SUBUNIT',0,2,'','255',7,33,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2270,'subject','u_yf_fcorectinginvoice',1,2,'subject','FL_SUBJECT',0,2,'','255',1,361,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(107,2271,'paymentdate','u_yf_fcorectinginvoice',1,5,'paymentdate','FL_PAYMENT_DATE',0,2,'',NULL,6,361,1,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2272,'saledate','u_yf_fcorectinginvoice',1,5,'saledate','FL_SALE_DATE',0,2,'',NULL,7,361,1,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2273,'accountid','u_yf_fcorectinginvoice',1,10,'accountid','FL_ACCOUNT',0,2,'','-2147483648,2147483647',9,361,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2274,'fcorectinginvoice_formpayment','u_yf_fcorectinginvoice',1,16,'payment_methods','FL_PAYMENTS_METHOD',0,2,'','255',10,361,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2275,'fcorectinginvoice_status','u_yf_fcorectinginvoice',1,15,'fcorectinginvoice_status','FL_STATUS',0,2,'','255',12,361,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2276,'number','u_yf_fcorectinginvoice',1,4,'number','FL_NUMBER',0,2,'','32',1,362,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2277,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',2,362,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2278,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,3,362,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2279,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,4,362,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2280,'sum_total','u_yf_fcorectinginvoice',1,317,'sum_total','FL_TOTAL',0,2,'','1.0E+20',5,362,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2281,'sum_gross','u_yf_fcorectinginvoice',1,317,'sum_gross','FL_GROSS',0,2,'','1.0E+20',6,362,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2282,'poboxa','u_yf_fcorectinginvoice_address',1,1,'poboxa','Po Box',0,2,'','50',11,363,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2283,'localnumbera','u_yf_fcorectinginvoice_address',1,1,'localnumbera','Local number',0,2,'','50',2,363,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2284,'buildingnumbera','u_yf_fcorectinginvoice_address',1,1,'buildingnumbera','Building number',0,2,'','255',4,363,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2285,'addresslevel8a','u_yf_fcorectinginvoice_address',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,363,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2286,'addresslevel7a','u_yf_fcorectinginvoice_address',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,363,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2287,'addresslevel6a','u_yf_fcorectinginvoice_address',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,363,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2288,'addresslevel5a','u_yf_fcorectinginvoice_address',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,363,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2289,'addresslevel4a','u_yf_fcorectinginvoice_address',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,363,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2290,'addresslevel3a','u_yf_fcorectinginvoice_address',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,363,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2291,'addresslevel2a','u_yf_fcorectinginvoice_address',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,363,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2292,'addresslevel1a','u_yf_fcorectinginvoice_address',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,363,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2304,'finvoiceid','u_yf_fcorectinginvoice',1,10,'finvoiceid','FL_INVOICE',0,2,'','-2147483648,2147483647',13,361,1,'M~M',2,NULL,'BAS',1,'',0,'','0',0,0,0,0,'',NULL),
			(108,2305,'subject','u_yf_igrnc',1,2,'subject','FL_SUBJECT',0,2,'','255',1,365,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(108,2306,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',6,365,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(108,2307,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',7,365,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(108,2308,'storageid','u_yf_igrnc',1,10,'storageid','FL_STORAGE',0,2,'','-2147483648,2147483647',2,365,10,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(108,2309,'igrnc_status','u_yf_igrnc',1,15,'igrnc_status','FL_STATUS',0,2,'','255',4,365,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(108,2310,'vendorid','u_yf_igrnc',1,10,'vendorid','FL_VENDOR',0,2,'','-2147483648,2147483647',3,365,10,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(108,2311,'acceptance_date','u_yf_igrnc',1,5,'acceptance_date','FL_ACCEPTANCE_DATE',0,2,'',NULL,5,365,1,'D~O',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(108,2312,'number','u_yf_igrnc',1,4,'number','FL_NUMBER',0,2,'','32',1,366,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(108,2313,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,2,366,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(108,2314,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,366,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(108,2315,'sum_total','u_yf_igrnc',1,317,'sum_total','LBL_TOTAL_PRICE',0,2,'','1.0E+20',4,366,2,'NN~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(108,2316,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,367,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(108,2317,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',1,368,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(108,2318,'igrnid','u_yf_igrnc',1,10,'igrnid','FL_IGRN',0,2,'','-2147483648,2147483647',8,365,1,'I~M',1,NULL,'BAS',1,'',0,'','0',0,0,0,0,'',NULL),
			(109,2319,'subject','u_yf_igdnc',1,2,'subject','FL_SUBJECT',0,2,'','255',1,369,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(109,2320,'storageid','u_yf_igdnc',1,10,'storageid','FL_STORAGE',0,2,'','-2147483648,2147483647',2,369,10,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(109,2321,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',7,369,1,'V~M',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(109,2322,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',6,369,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(109,2323,'igdnc_status','u_yf_igdnc',1,15,'igdnc_status','FL_STATUS',0,2,'','255',4,369,1,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(109,2324,'accountid','u_yf_igdnc',1,10,'accountid','FL_ACCOUNT',0,2,'','-2147483648,2147483647',3,369,10,'V~M',1,NULL,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(109,2325,'acceptance_date','u_yf_igdnc',1,5,'acceptance_date','FL_ACCEPTANCE_DATE',0,2,'',NULL,5,369,1,'D~O',2,1,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(109,2326,'number','u_yf_igdnc',1,4,'number','FL_NUMBER',0,2,'','32',1,370,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(109,2327,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,2,370,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(109,2328,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,370,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(109,2329,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,371,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(109,2330,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',1,372,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(109,2331,'igdnid','u_yf_igdnc',1,10,'igdnid','FL_IGDN',0,2,'','-2147483648,2147483647',8,369,1,'I~M',1,NULL,'BAS',1,'',0,'','0',0,0,0,0,'',NULL),
			(14,2334,'renewable','vtiger_products',1,56,'renewable','FL_RENEWABLE',0,2,'','-128,127',29,31,1,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,2335,'renewable','vtiger_service',1,56,'renewable','FL_RENEWABLE',0,2,'','-128,127',23,91,1,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,2336,'renewalinvoice','vtiger_assets',1,10,'renewalinvoice','FL_RENEWAL_INVOICE',0,2,'','-2147483648,2147483647',20,95,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,2337,'renewalinvoice','vtiger_osssoldservices',1,10,'renewalinvoice','FL_RENEWAL_INVOICE',0,2,'','-2147483648,2147483647',12,141,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2344,'ssingleorders_source','u_yf_ssingleorders',1,16,'ssingleorders_source','FL_SOURCE',0,2,'','255',13,284,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(100,2345,'ssingleordersid','u_yf_igdn',1,10,'ssingleordersid','FL_SSIGNLEORDERS',0,2,'','-2147483648,2147483647',8,327,1,'M~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,2346,'last_invoice_date','vtiger_account',1,5,'last_invoice_date','FL_LAST_INVOICE_DATE',0,2,'',NULL,10,198,10,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,2351,'active','vtiger_leaddetails',1,56,'active','FL_ACTIVE',0,2,'','-128,127',24,13,1,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,2352,'active','u_yf_partners',1,56,'active','FL_ACTIVE',0,2,'','-128,127',6,299,1,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,2353,'active','vtiger_vendor',1,56,'active','FL_ACTIVE',0,2,'','-128,127',21,42,1,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,2354,'active','u_yf_competition',1,56,'active','FL_ACTIVE',0,2,'','-128,127',6,303,1,'C~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(83,2355,'announcementstatus','u_yf_announcement',1,15,'announcementstatus','FL_STATUS',0,2,'PLL_DRAFT','255',2,258,1,'V~M',2,4,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(83,2356,'interval','u_yf_announcement',1,7,'interval','FL_INTERVAL',0,2,'','-32768,32767',3,258,1,'I~O',1,NULL,'BAS',1,'Edit,Detail,QuickCreateAjax',0,'',NULL,0,0,0,0,'',NULL),
			(14,2357,'category_multipicklist','vtiger_products',1,309,'category_multipicklist','LBL_CATEGORY_MULTIPICKLIST',0,2,NULL,'65535',31,31,1,'V~O',1,NULL,'BAS',1,'',0,'31',NULL,0,0,0,0,'',NULL),
			(89,2358,'valid_until','u_yf_squotes',1,5,'valid_until','FL_VALID_UNTIL',0,2,'',NULL,10,280,1,'D~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,2381,'category','u_yf_partners',1,302,'category','FL_CATEGORY',0,2,'','255',7,299,1,'V~O',1,NULL,'BAS',1,'',0,'18',NULL,0,0,0,0,'',NULL),
			(61,2382,'secondary_phone','vtiger_ossemployees',1,11,'secondary_phone','FL_SECONDARY_PHONE',0,2,'','25',5,152,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,2383,'position','vtiger_ossemployees',1,1,'position','FL_POSITION',0,2,'','255',17,151,1,'V~O',1,NULL,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(61,2384,'rbh','vtiger_ossemployees',1,71,'rbh','FL_RBH',0,2,'','1.0E+20',18,151,1,'N~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2385,'campaignid','u_yf_ssalesprocesses',1,10,'campaignid','FL_CAMPAIGN',0,2,'','-2147483648,2147483647',15,269,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,2386,'ssalesprocessesid','vtiger_project',1,10,'ssalesprocessesid','SINGLE_SSalesProcesses',0,2,'','-2147483648,2147483647',14,107,1,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(111,2387,'title','u_yf_notification',1,2,'title','FL_TITLE',0,2,'','255',1,374,1,'V~M',1,1,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(111,2388,'number','u_yf_notification',1,4,'number','FL_NUMBER',0,2,'','50',1,443,2,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(111,2389,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',2,374,1,'V~M',1,2,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(111,2390,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,3,443,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(111,2391,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,5,443,2,'DT~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(111,2392,'description','vtiger_crmentity',1,300,'description','FL_MESSAGE',0,2,'','65535',1,375,1,'V~O',2,9,'BAS',1,'',0,'','0',0,0,0,0,'',NULL),
			(111,2393,'link','u_yf_notification',1,67,'link','FL_RELATION',0,2,'','-2147483648,2147483647',4,374,1,'I~O',2,6,'BAS',1,'',0,'','0',0,0,0,0,'',NULL),
			(111,2395,'notification_status','u_yf_notification',1,16,'notification_status','FL_STATUS',0,2,'PLL_UNREAD','255',5,374,10,'V~O',1,NULL,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(111,2396,'notification_type','u_yf_notification',1,15,'notification_type','FL_TYPE',0,2,'PLL_USERS','255',3,374,10,'V~O',2,5,'BAS',1,'',0,'','0',0,0,0,0,'',NULL),
			(111,2397,'process','u_yf_notification',1,66,'process','FL_PROCESS',0,2,'','-2147483648,2147483647',6,374,1,'I~O',2,7,'BAS',1,'',0,'','0',0,0,0,0,'',NULL),
			(111,2398,'subprocess','u_yf_notification',1,68,'subprocess','FL_SUB_PROCESS',0,2,'','-2147483648,2147483647',8,374,1,'I~O',2,8,'BAS',1,'',0,'','0',0,0,0,0,'',NULL),
			(111,2399,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',2,443,1,'V~O',2,4,'BAS',1,'',0,'','0',0,0,0,0,'',NULL),
			(111,2400,'smcreatorid','vtiger_crmentity',1,52,'smcreatorid','Created By',0,2,'','65535',6,443,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,2401,'accounts_status','vtiger_account',1,15,'accounts_status','FL_STATUS',0,2,'','255',4,9,1,'V~O',1,0,'BAS',1,'',0,'','{\"type\":\"progress\"}',0,0,0,0,'',NULL),
			(95,2403,'finvoice_type','u_yf_finvoice',1,15,'finvoice_type','FL_INVOICE_TYPE',0,2,'','255',10,310,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2404,'parentid','u_yf_ssalesprocesses',1,10,'parentid','FL_MEMBER_OF',0,2,'','-2147483648,2147483647',4,269,1,'I~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,2405,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',10,9,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,2406,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',30,4,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,2407,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',25,13,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,2408,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',22,42,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,2409,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',32,31,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2410,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',14,269,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2411,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',8,316,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,2412,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',18,74,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,2414,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',8,27,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(105,2415,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',7,351,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,2416,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',24,91,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(106,2417,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',10,355,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(98,2418,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',8,321,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,2419,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',21,134,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(108,2420,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',9,365,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(100,2421,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',9,327,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(109,2422,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',9,369,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,2423,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',27,19,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,2424,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',15,107,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(101,2425,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',7,329,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(102,2426,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',7,331,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(37,2427,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',21,95,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,2428,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',19,151,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(103,2429,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',8,333,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(15,2430,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',8,38,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,2431,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',12,232,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(104,2432,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',10,347,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(34,2433,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',18,89,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(59,2434,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',32,144,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(51,2435,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',15,128,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(19,2436,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',11,46,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(41,2437,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',14,101,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(8,2438,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',13,17,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,2439,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',13,141,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(84,2440,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',15,261,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(57,2442,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',17,138,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(83,2443,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',4,258,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(42,2444,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',15,104,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(75,2445,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',15,236,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(78,2446,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',4,247,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,2447,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',8,250,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(80,2448,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',9,252,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,2449,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',19,254,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2450,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',14,361,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(82,2451,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',19,256,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2452,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',7,323,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(94,2453,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',5,307,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2454,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',9,310,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(96,2455,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',6,438,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(111,2456,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',4,443,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(85,2458,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',8,265,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(87,2459,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',9,272,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,2460,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',11,280,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,2461,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',13,288,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,2462,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',7,303,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(88,2463,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',9,276,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2464,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',14,284,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,2465,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',8,299,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,2467,'taxes','vtiger_service',1,303,'taxes','FL_TAXES',0,2,'','50',3,92,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,2468,'available','vtiger_users',1,56,'available','FL_AVAILABLE',0,0,'','-128,127',1,455,1,'C~O',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,2469,'auto_assign','vtiger_users',1,56,'auto_assign','FL_AUTO_ASSIGN_RECORDS',0,0,'','-128,127',2,455,1,'C~O',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,2470,'records_limit','vtiger_users',1,7,'records_limit','FL_RECORD_LIMIT_IN_MODULE',0,0,'','0,4294967295',3,455,1,'I~O',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(112,2471,'name','u_yf_emailtemplates',1,2,'name','FL_NAME',0,2,'','255',0,376,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(112,2472,'number','u_yf_emailtemplates',1,4,'number','FL_NUMBER',0,2,'','32',3,378,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(112,2473,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',1,378,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(112,2474,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,5,378,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(112,2475,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,6,378,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(112,2476,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',4,378,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(112,2477,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',2,378,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(112,2478,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',7,378,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(112,2479,'email_template_type','u_yf_emailtemplates',1,16,'email_template_type','FL_TYPE',0,2,'','50',0,376,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(112,2480,'module','u_yf_emailtemplates',1,301,'module_name','FL_MODULE',0,2,'','50',0,376,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(112,2481,'subject','u_yf_emailtemplates',1,1,'subject','FL_SUBJECT',0,2,'','255',0,377,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(112,2482,'content','u_yf_emailtemplates',1,300,'content','FL_CONTENT',0,2,'','16777215',0,377,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(112,2483,'email_template_priority','u_yf_emailtemplates',1,16,'email_template_priority','FL_SMTP_PRIORITY',0,2,'','1',0,376,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2484,'startdate','u_yf_ssalesprocesses',1,5,'startdate','FL_START_DATE',0,2,'',NULL,11,269,1,'D~O',2,5,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(113,2485,'subject','u_yf_cfixedassets',1,2,'subject','FL_SUBJECT',0,2,'','255',1,379,1,'V~M',1,0,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(113,2486,'number','u_yf_cfixedassets',1,4,'number','FL_NUMBER',0,2,'','32',2,379,2,'V~O',1,0,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(113,2487,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',3,379,1,'V~M',1,0,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(113,2488,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,18,379,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2489,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,16,379,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2490,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',17,379,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2491,'fixed_assets_type','u_yf_cfixedassets',1,16,'fixed_assets_type','FL_TYPE',0,2,'','255',5,379,1,'V~O',1,0,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(113,2492,'fixed_assets_status','u_yf_cfixedassets',1,15,'fixed_assets_status','FL_STATUS',0,2,'','255',6,379,1,'V~O',1,0,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(113,2493,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',4,379,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2494,'producent_designation','u_yf_cfixedassets',1,1,'producent_designation','FL_PRODUCENT_DESIGNATION',0,2,'','255',8,379,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2495,'additional_designation','u_yf_cfixedassets',1,1,'additional_designation','FL_ADDITIONAL_DESIGNATION',0,2,'','255',9,379,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2496,'internal_designation','u_yf_cfixedassets',1,1,'internal_designation','FL_INTERNAL_DESIGNATION',0,2,'','255',10,379,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2497,'date_production','u_yf_cfixedassets',1,5,'date_production','FL_DATE_PRODUCTION',0,2,'',NULL,11,379,1,'D~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2498,'date_acquisition','u_yf_cfixedassets',1,5,'date_acquisition','FL_DATE_ACQUISITION',0,2,'',NULL,12,379,1,'D~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2499,'purchase_price','u_yf_cfixedassets',1,71,'purchase_price','FL_PURCHASE_PRICE',0,2,'','0,1.0E+20',14,379,1,'N~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2500,'actual_price','u_yf_cfixedassets',1,71,'actual_price','FL_ACTUAL_PRICE',0,2,'','0,1.0E+20',13,379,1,'N~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2501,'reservation','u_yf_cfixedassets',1,56,'reservation','FL_RESERVATION',0,2,'','-32768,32767',15,379,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2502,'pscategory','u_yf_cfixedassets',1,302,'pscategory','FL_CATEGORY',0,2,'','255',7,379,1,'V~O',1,0,'BAS',1,'',0,'19',NULL,0,0,0,0,'',NULL),
			(113,2503,'fixed_assets_fuel_type','u_yf_cfixedassets',1,16,'fixed_assets_fuel_type','FL_FUEL_TYPE',0,2,'','255',0,380,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2504,'timing_change','u_yf_cfixedassets',1,7,'timing_change','FL_TIMING_CHANGE',0,2,'','0,4294967295',0,380,1,'I~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2505,'oil_change','u_yf_cfixedassets',1,7,'oil_change','FL_OIL_TYPE',0,2,'','0,4294967295',0,380,1,'I~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2506,'fuel_consumption','u_yf_cfixedassets',1,7,'fuel_consumption','FL_AVARAGE_FUEL_CONSUPTION',0,2,'','0,4294967295',0,380,1,'I~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2507,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',0,381,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2508,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,382,1,'V~O',1,0,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(114,2509,'subject','u_yf_cinternaltickets',1,2,'subject','FL_SUBJECT',0,2,'','100',0,383,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(114,2510,'internal_tickets_status','u_yf_cinternaltickets',1,15,'internal_tickets_status','FL_STATUS',0,2,'','150',0,383,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(114,2511,'cinternaltickets_no','u_yf_cinternaltickets',1,4,'cinternaltickets_no','FL_NUMBER',0,2,'','32',4,384,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(114,2512,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',1,384,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(114,2513,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,6,384,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(114,2514,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,5,384,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(114,2515,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',3,384,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(114,2516,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',2,384,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(114,2517,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',0,385,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(114,2518,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',0,386,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(114,2519,'resolution','u_yf_cinternaltickets',1,300,'resolution','FL_RESOLUTION',0,2,'','65535',0,387,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2520,'subject','u_yf_finvoicecost',1,2,'subject','FL_SUBJECT',0,2,'','255',1,388,1,'V~M',1,0,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(115,2521,'paymentdate','u_yf_finvoicecost',1,5,'paymentdate','FL_PAYMENT_DATE',0,2,'',NULL,2,388,1,'D~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2522,'saledate','u_yf_finvoicecost',1,5,'saledate','FL_SALE_DATE',0,2,'',NULL,3,388,1,'D~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2523,'finvoicecost_formpayment','u_yf_finvoicecost',1,16,'payment_methods','FL_PAYMENTS_METHOD',0,2,'','255',4,388,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2524,'finvoicecost_status','u_yf_finvoicecost',1,15,'finvoicecost_status','FL_STATUS',0,2,'','255',5,388,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2525,'finvoicecost_paymentstatus','u_yf_finvoicecost',1,15,'finvoicecost_paymentstatus','FL_PAYMENT_STATUS',0,2,'','255',6,388,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2526,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',7,388,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2527,'pscategory','u_yf_finvoicecost',1,302,'pscategory','FL_CATEGORY',0,2,'','50',8,388,1,'V~O',1,0,'BAS',1,'',0,'20',NULL,0,0,0,0,'',NULL),
			(115,2528,'number','u_yf_finvoicecost',1,4,'number','FL_NUMBER',0,2,'','32',1,389,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2529,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',2,389,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2530,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,3,389,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2531,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,4,389,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2532,'sum_total','u_yf_finvoicecost',1,317,'sum_total','FL_TOTAL',0,2,'','1.0E+20',5,389,2,'NN~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2533,'sum_gross','u_yf_finvoicecost',1,317,'sum_gross','FL_GROSS',0,2,'','1.0E+20',6,389,2,'NN~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2534,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',7,389,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2535,'poboxa','u_yf_finvoicecost_address',1,1,'poboxa','Po Box',0,2,'','50',11,390,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2536,'localnumbera','u_yf_finvoicecost_address',1,1,'localnumbera','Local number',0,2,'','50',2,390,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2537,'buildingnumbera','u_yf_finvoicecost_address',1,1,'buildingnumbera','Building number',0,2,'','255',4,390,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2538,'addresslevel8a','u_yf_finvoicecost_address',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,390,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2539,'addresslevel7a','u_yf_finvoicecost_address',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,390,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2540,'addresslevel6a','u_yf_finvoicecost_address',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,390,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2541,'addresslevel5a','u_yf_finvoicecost_address',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,390,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2542,'addresslevel4a','u_yf_finvoicecost_address',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,390,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2543,'addresslevel3a','u_yf_finvoicecost_address',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,390,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2544,'addresslevel2a','u_yf_finvoicecost_address',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,390,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2545,'addresslevel1a','u_yf_finvoicecost_address',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,390,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2557,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',0,392,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2558,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',0,393,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(116,2559,'subject','u_yf_cmileagelogbook',1,2,'subject','FL_SUBJECT',0,2,'','255',1,394,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(116,2560,'cmileage_logbook_status','u_yf_cmileagelogbook',1,15,'cmileage_logbook_status','FL_STATUS',0,2,'','150',2,394,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(116,2561,'number_kilometers','u_yf_cmileagelogbook',1,7,'number_kilometers','FL_NUMBER_KILOMETERS',0,2,'','0,99999999999',3,394,1,'NN~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(116,2562,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',0,395,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(116,2563,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',0,396,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(116,2564,'number','u_yf_cmileagelogbook',1,4,'number','FL_NUMBER',0,2,'','32',3,397,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(116,2565,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',1,397,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(116,2566,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,5,397,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(116,2567,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,4,397,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(116,2568,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',6,397,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(116,2569,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',2,397,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2570,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',7,311,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2571,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',0,399,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2572,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',0,398,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2573,'pscategory','u_yf_finvoice',1,302,'pscategory','FL_CATEGORY',0,2,'','100',11,310,1,'V~O',1,0,'BAS',1,'',0,'21',NULL,0,0,0,0,'',NULL),
			(113,2574,'current_odometer_reading','u_yf_cfixedassets',1,7,'current_odometer_reading','FL_CURRENT_ODOMETER_READING',0,2,'','0,4294967295',0,380,1,'I~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2575,'number_repair','u_yf_cfixedassets',1,7,'number_repair','FL_NUMBER_REPAIR',0,2,'','0,65535',0,380,1,'I~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(113,2576,'date_last_repair','u_yf_cfixedassets',1,5,'date_last_repair','FL_DATE_OF_LAST_REPAIR',0,2,'',NULL,0,380,1,'D~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2577,'subject','u_yf_svendorenquiries',1,2,'subject','LBL_SUBJECT',0,2,'','255',1,400,1,'V~M',1,0,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(117,2578,'category','u_yf_svendorenquiries',1,302,'category','Category',0,2,'','30',2,400,1,'V~O',2,5,'BAS',1,'',1,'22',NULL,0,0,0,0,'',NULL),
			(117,2579,'salesprocessid','u_yf_svendorenquiries',1,10,'salesprocessid','SINGLE_SSalesProcesses',0,2,'','-2147483648,2147483647',3,400,1,'V~M',2,2,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(117,2580,'svendorenquiries_status','u_yf_svendorenquiries',1,15,'svendorenquiries_status','LBL_STATUS',0,0,'PLL_DRAFT','255',7,400,1,'V~O',2,6,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(117,2581,'accountid','u_yf_svendorenquiries',1,10,'accountid','SINGLE_Accounts',0,2,'','-2147483648,2147483647',4,400,10,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2582,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',8,400,1,'V~M',1,0,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(117,2583,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',9,400,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2584,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',10,400,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2585,'vendorid','u_yf_svendorenquiries',1,10,'vendorid','FL_VENDOR',0,2,'','-2147483648,2147483647',5,400,1,'M~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2586,'scalculationsid','u_yf_svendorenquiries',1,10,'scalculationsid','FL_SCALCULATIONS',0,2,'','-2147483648,2147483647',6,400,1,'M~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2587,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,401,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2588,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',2,401,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2590,'sum_time','u_yf_svendorenquiries',1,8,'sum_time','FL_TOTAL_TIME_H',0,2,'','99999999',2,402,2,'NN~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2591,'sum_total','u_yf_svendorenquiries',1,317,'sum_total','FL_TOTAL_PRICE',0,2,'','1.0E+20',3,402,2,'NN~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2592,'sum_marginp','u_yf_svendorenquiries',1,7,'sum_marginp','FL_MARGINP',0,2,'','99999999',4,402,3,'N~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2593,'sum_margin','u_yf_svendorenquiries',1,7,'sum_margin','FL_MARGIN',0,2,'','1.0E+20',5,402,3,'N~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2594,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,1,403,2,'DT~O',1,0,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(117,2595,'svendorenquiries_no','u_yf_svendorenquiries',1,4,'svendorenquiries_no','LBL_NUMBER',0,2,'','50',2,403,2,'V~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2596,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,3,403,2,'DT~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2598,'crmactivity','vtiger_entity_stats',1,1,'crmactivity','LBL_CRMACTIVITY',0,2,NULL,'-2147483648,2147483647',5,403,2,'I~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,2602,'reapeat','vtiger_activity',1,56,'reapeat','FL_REAPEAT',0,0,'','-32768,32767',0,117,1,'I~O',1,0,'BAS',0,'',0,'{\"editWidth\":\"col-sm-3\"}',NULL,0,0,0,0,'',NULL),
			(9,2603,'recurrence','vtiger_activity',1,342,'recurrence','FL_RECURRENCE',0,0,'','65535',0,117,1,'V~O',1,0,'BAS',0,'',0,'{\"editWidth\":\"col-sm-9\"}',NULL,0,0,0,0,'',NULL),
			(43,2604,'parentid','vtiger_project',1,10,'parentid','FL_MEMBER_OF',0,2,'','-2147483648,2147483647',10,108,1,'I~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(83,2605,'is_mandatory','u_yf_announcement',1,56,'is_mandatory','FL_IS_MANDATORY',0,2,'','-32768,32767',5,258,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(45,2606,'smsnotifier_status','vtiger_smsnotifier',1,15,'smsnotifier_status','FL_STATUS',0,0,'PLL_QUEUE','255',3,110,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(84,2607,'subprocess','vtiger_reservations',1,68,'subprocess','FL_SUB_PROCESS',0,2,'','-2147483648,2147483647',4,262,1,'I~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,2608,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,2,'','65535',7,300,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,2609,'phone_extra','vtiger_account',1,1,'phone_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',9,195,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,2610,'fax_extra','vtiger_account',1,1,'fax_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',10,195,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,2611,'otherphone_extra','vtiger_account',1,1,'otherphone_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',11,195,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,2612,'phone_extra','vtiger_leadaddress',1,1,'phone_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',9,150,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,2613,'mobile_extra','vtiger_leadaddress',1,1,'mobile_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',10,150,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(7,2614,'fax_extra','vtiger_leadaddress',1,1,'fax_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',11,150,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,2615,'phone_extra','vtiger_contactdetails',1,1,'phone_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',7,197,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(4,2616,'mobile_extra','vtiger_contactdetails',1,1,'mobile_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',8,197,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(18,2617,'phone_extra','vtiger_vendor',1,1,'phone_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',23,42,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,2619,'phone_crm_extension_extra','vtiger_users',1,1,'phone_crm_extension_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',6,468,3,'V~O',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(61,2620,'business_phone_extra','vtiger_ossemployees',1,1,'business_phone_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',6,152,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,2621,'private_phone_extra','vtiger_ossemployees',1,1,'private_phone_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',7,152,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,2622,'from_number_extra','vtiger_callhistory',1,1,'from_number_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',13,232,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,2623,'to_number_extra','vtiger_callhistory',1,1,'to_number_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',14,232,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,2624,'secondary_phone_extra','vtiger_ossemployees',1,1,'secondary_phone_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',8,152,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,2625,'date_password_change','vtiger_users',1,80,'date_password_change','FL_DATE_PASSWORD_CHANGE',0,2,'',NULL,8,79,2,'DT~O',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,2626,'force_password_change','vtiger_users',1,56,'force_password_change','FL_FORCE_PASSWORD_CHANGE',0,2,'','-128,127',2,83,1,'C~O',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(37,2627,'contactid','vtiger_assets',1,10,'contactid','FL_CONTACT',0,2,'','-2147483648,2147483647',8,96,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,2628,'contactid','vtiger_osssoldservices',1,10,'contactid','FL_CONTACT',0,2,'','-2147483648,2147483647',12,142,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,2630,'linkextend','vtiger_activity',1,65,'linkextend','FL_RELATION_EXTEND',0,0,'','-2147483648,2147483647',5,87,1,'I~O',2,10,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(111,2631,'linkextend','u_yf_notification',1,65,'linkextend','FL_RELATION_EXTEND',0,2,'','-2147483648,2147483647',9,374,1,'I~O',2,10,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(51,2632,'linkextend','vtiger_osstimecontrol',1,65,'linkextend','FL_RELATION_EXTEND',0,2,'','-2147483648,2147483647',14,129,1,'I~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(84,2633,'linkextend','vtiger_reservations',1,65,'linkextend','FL_RELATION_EXTEND',0,2,'','-2147483648,2147483647',5,262,1,'I~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,2635,'custom_sender','vtiger_lettersin',1,1,'custom_sender','FL_CUSTOM_SENDER',0,2,'','255',20,254,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,2636,'lin_type','vtiger_lettersin',1,16,'lin_type','FL_TYPE',0,2,'','255',21,254,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,2637,'cash_amount_on_delivery','vtiger_lettersin',1,71,'cash_amount_on_delivery','FL_CASH_AMOUNT_ON_DELIVERY',0,2,'','1.0E+20',22,254,1,'N~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,2638,'date_of_receipt','vtiger_lettersin',1,5,'date_of_receipt','FL_DATE_OF_RECEIPT',0,2,'',NULL,23,254,1,'D~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,2639,'outgoing_correspondence','vtiger_lettersin',1,10,'outgoing_correspondence','FL_OUTGOING_CORRESPONDENCE',0,2,'','-2147483648,2147483647',24,254,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,2640,'internal_notes','vtiger_lettersincf',1,300,'internal_notes','FL_INTERNAL_NOTES',0,2,'','65535',2,255,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,2641,'public_notes','vtiger_lettersincf',1,300,'public_notes','FL_PUBLIC_NOTES',0,2,'','65535',3,255,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(82,2642,'incoming_correspondence','vtiger_lettersout',1,10,'incoming_correspondence','FL_INCOMING_CORRESPONDENCE',0,2,'','-2147483648,2147483647',20,256,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2643,'company_name','u_yf_multicompany',1,2,'company_name','FL_COMPANY_NAME',0,2,'','255',1,404,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2644,'number','u_yf_multicompany',1,4,'number','FL_NUMBER',0,2,'','32',1,405,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2645,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',2,404,1,'V~M',1,0,'BAS',1,'',0,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(119,2646,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,3,405,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2647,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,4,405,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2648,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',2,405,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2649,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',3,404,1,'V~O',1,0,'BAS',1,'',0,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(119,2650,'mulcomp_status','u_yf_multicompany',1,16,'mulcomp_status','FL_STATUS',0,2,'PLL_ACTIVE','255',4,404,1,'V~O',1,0,'BAS',1,'',0,'','{\"type\":\"highlights\",\"class\":\"badge-info\"}',0,0,0,0,'',NULL),
			(119,2651,'email1','u_yf_multicompany',1,13,'email1','FL_EMAIL_1',0,2,'','100',1,407,1,'E~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2652,'email2','u_yf_multicompany',1,13,'email2','FL_EMAIL_2',0,2,'','100',2,407,1,'E~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2653,'phone','u_yf_multicompany',1,11,'phone','FL_PHONE',0,2,'','30',3,407,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2654,'phone_extra','u_yf_multicompany',1,1,'phone_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',4,407,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2655,'mobile','u_yf_multicompany',1,11,'mobile','FL_MOBILE',0,2,'','30',5,407,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2656,'mobile_extra','u_yf_multicompany',1,1,'mobile_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',6,407,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2657,'fax','u_yf_multicompany',1,11,'fax','FL_FAX',0,2,'','30',7,407,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2658,'fax_extra','u_yf_multicompany',1,1,'fax_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',8,407,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2659,'vat','u_yf_multicompany',1,1,'vat','FL_VATID',0,2,'','255',1,408,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2660,'companyid1','u_yf_multicompany',1,1,'companyid1','FL_COMPANY_ID1',0,2,'','255',2,408,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2661,'companyid2','u_yf_multicompany',1,1,'companyid2','FL_COMPANY_ID2',0,2,'','255',3,408,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2662,'buildingnumbera','u_yf_multicompany',1,1,'buildingnumbera','Building number',0,2,'','255',4,409,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2663,'localnumbera','u_yf_multicompany',1,1,'localnumbera','Local number',0,2,'','50',2,409,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2664,'addresslevel8a','u_yf_multicompany',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,409,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2665,'addresslevel7a','u_yf_multicompany',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,409,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2666,'addresslevel6a','u_yf_multicompany',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,409,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2667,'addresslevel5a','u_yf_multicompany',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,409,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2668,'addresslevel4a','u_yf_multicompany',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,409,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2669,'addresslevel3a','u_yf_multicompany',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,409,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2670,'addresslevel2a','u_yf_multicompany',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,409,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2671,'addresslevel1a','u_yf_multicompany',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,409,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2672,'poboxa','u_yf_multicompany',1,1,'poboxa','Po Box',0,2,'','50',11,409,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2673,'public_notes','u_yf_multicompanycf',1,300,'public_notes','FL_PUBLIC_NOTES',0,2,'','65535',0,406,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2674,'internal_notes','u_yf_multicompanycf',1,300,'internal_notes','FL_INTERNAL_NOTES',0,2,'','65535',0,406,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2675,'parent_id','u_yf_multicompany',1,10,'parent_id','FL_PARENT',0,2,'','-2147483648,2147483647',5,404,1,'V~O',1,0,'BAS',1,'',0,'','{\"type\":\"value\"}',0,0,0,0,'',NULL),
			(29,2676,'view_date_format','vtiger_users',1,16,'view_date_format','FL_VIEW_DATE_FORMAT',0,2,'PLL_ELAPSED','50',9,118,1,'V~M',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(41,2677,'parentid','vtiger_projectmilestone',1,10,'parentid','FL_PARENT_PROJECT_MILESTONE',0,2,'','-2147483648,2147483647',13,101,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(121,2678,'subject','u_yf_datasetregister',1,2,'subject','FL_SUBJECT',0,2,'','255',1,410,1,'V~M',2,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(121,2679,'number','u_yf_datasetregister',1,4,'number','FL_NUMBER',0,2,'','32',6,410,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(121,2680,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',3,410,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(121,2681,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,4,410,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(121,2682,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,5,410,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(121,2683,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',8,410,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(121,2684,'datasetregister_status','u_yf_datasetregister',1,16,'datasetregister_status','FL_STATUS',0,2,'','255',7,410,1,'V~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(121,2685,'legal_basis','u_yf_datasetregister',1,309,'legal_basis','FL_LEGAL_BASIS',0,2,'','65535',10,410,1,'V~O',1,0,'BAS',1,'',1,'25','0',0,0,0,0,'',NULL),
			(121,2686,'scope_data','u_yf_datasetregister',1,309,'scope_data','FL_SCOPE_DATA',0,2,'','65535',9,410,1,'V~O',1,0,'BAS',1,'',0,'26',NULL,0,0,0,0,'',NULL),
			(121,2687,'registered_dpo','u_yf_datasetregister',1,56,'registered_dpo','FL_REGISTERED_DPO',0,2,'','-128,127',12,410,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(121,2688,'data_submitted','u_yf_datasetregister',1,56,'data_submitted','FL_DATA_SUBMITTED',0,2,'','-128,127',11,410,1,'C~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(121,2689,'internal_register','u_yf_datasetregister',1,56,'internal_register','FL_INTERNAL_REGISTER',0,2,'','-128,127',14,410,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(121,2690,'data_set_shared','u_yf_datasetregister',1,56,'data_set_shared','FL_DATA_SET_SHARED',0,2,'','-128,127',13,410,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(121,2691,'added_to_register','u_yf_datasetregister',1,5,'added_to_register','FL_ADDED_TO_REGISTER',0,2,'',NULL,1,414,1,'D~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(121,2692,'removed_from_register','u_yf_datasetregister',1,5,'removed_from_register','FL_REMOVED_FROM_REGISTER',0,2,'',NULL,2,414,1,'D~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(121,2693,'parent_id','u_yf_datasetregister',1,10,'parent_id','FL_PARENT_DATA_SET',0,2,'','-2147483648,2147483647',2,410,1,'V~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(121,2694,'description','vtiger_crmentity',1,300,'description','FL_DESCRIPTION',0,2,'','65535',0,412,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(121,2695,'attention','vtiger_crmentity',1,300,'attention','FL_COMMENTS',0,2,'','65535',0,413,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(122,2696,'subject','u_yf_activityregister',1,2,'subject','FL_SUBJECT',0,2,'','255',0,415,1,'V~M',2,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(122,2697,'number','u_yf_activityregister',1,4,'number','FL_NUMBER',0,2,'','32',0,415,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(122,2698,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',0,415,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(122,2699,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,0,415,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(122,2700,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,0,415,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(122,2701,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',0,415,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(122,2702,'parent_id','u_yf_activityregister',1,10,'parent_id','FL_PARENT_ACTIVITY',0,2,'','-2147483648,2147483647',0,415,1,'V~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(122,2703,'activityregister_status','u_yf_activityregister',1,16,'activityregister_status','FL_STATUS',0,2,'','255',0,415,1,'V~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(122,2704,'datasetregisterid','u_yf_activityregister',1,10,'datasetregisterid','FL_DATA_SET',0,2,'','4294967295',0,415,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(122,2705,'start_date','u_yf_activityregister',1,5,'start_date','FL_START_DATE',0,2,'',NULL,1,417,1,'D~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(122,2706,'end_date','u_yf_activityregister',1,5,'end_date','FL_END_DATE',0,2,'',NULL,2,417,1,'D~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(122,2707,'description','vtiger_crmentity',1,300,'description','FL_DESCRIPTION',0,2,'','65535',0,418,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(122,2708,'attention','vtiger_crmentity',1,300,'attention','FL_COMMENTS',0,2,'','65535',0,419,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(122,2709,'activity_type','u_yf_activityregister',1,309,'activity_type','FL_ACTIVITY_TYPE',0,2,'','65535',0,415,1,'V~O',1,0,'BAS',1,'',1,'27','0',0,0,0,0,'',NULL),
			(123,2710,'name','u_yf_locationregister',1,2,'name','FL_NAME',0,2,'','255',0,420,1,'V~M',2,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(123,2711,'number','u_yf_locationregister',1,4,'number','FL_NUMBER',0,2,'','32',0,420,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2712,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',0,420,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2713,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,0,420,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2714,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,0,420,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2715,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',0,420,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2716,'parent_id','u_yf_locationregister',1,10,'parent_id','FL_PARENT_LOCATION',0,2,'','4294967295',0,420,1,'V~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(123,2717,'locationregister_status','u_yf_locationregister',1,16,'locationregister_status','FL_STATUS',0,2,'','255',0,420,1,'V~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(123,2718,'security_type','u_yf_locationregister',1,309,'security_type','FL_SECURITY_TYPE',0,2,'','65535',0,420,1,'V~O',1,0,'BAS',1,'',1,'28','0',0,0,0,0,'',NULL),
			(123,2719,'building_number','u_yf_locationregister',1,1,'building_number','FL_BUILDING_NUMBER',0,2,'','10',0,422,1,'V~O~LE~10',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2720,'street','u_yf_locationregister',1,1,'street','FL_STREET',0,2,'','255',0,422,1,'V~O~LE~255',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2721,'district','u_yf_locationregister',1,1,'district','FL_DISTRICT',0,2,'','255',0,422,1,'V~O~LE~255',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2722,'township','u_yf_locationregister',1,1,'township','FL_TOWNSHIP',0,2,'','255',0,422,1,'V~O~LE~255',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2723,'state','u_yf_locationregister',1,1,'state','FL_STATE',0,2,'','255',0,422,1,'V~O~LE~255',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2724,'pobox','u_yf_locationregister',1,1,'pobox','FL_POBOX',0,2,'','100',0,422,1,'V~O~LE~100',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2725,'local_number','u_yf_locationregister',1,1,'local_number','FL_LOCAL_NUMBER',0,2,'','20',0,422,1,'V~O~LE~20',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2726,'post_code','u_yf_locationregister',1,1,'post_code','FL_POST_CODE',0,2,'','20',0,422,1,'V~O~LE~20',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2727,'city','u_yf_locationregister',1,1,'city','FL_CITY',0,2,'','150',0,422,1,'V~O~LE~150',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2728,'county','u_yf_locationregister',1,1,'county','FL_COUNTY',0,2,'','150',0,422,1,'V~O~LE~150',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2729,'country','u_yf_locationregister',1,1,'country','FL_COUNTRY',0,2,'','150',0,422,1,'V~O~LE~150',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2730,'description','vtiger_crmentity',1,300,'description','FL_DESCRIPTION',0,2,'','65535',0,423,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(123,2731,'attention','vtiger_crmentity',1,300,'attention','FL_COMMENTS',0,2,'','65535',0,424,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(124,2732,'name','u_yf_incidentregister',1,2,'name','FL_NAME',0,2,'','255',1,425,1,'V~M',2,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(124,2733,'number','u_yf_incidentregister',1,4,'number','FL_NUMBER',0,2,'','32',2,425,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(124,2734,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',3,425,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(124,2735,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,4,425,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(124,2736,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,5,425,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(124,2737,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',6,425,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(124,2738,'locationregisterid','u_yf_incidentregister',1,10,'locationregisterid','FL_LOCATION_REGISTER',0,2,'','4294967295',7,425,1,'V~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(124,2739,'datasetregisterid','u_yf_incidentregister',1,10,'datasetregisterid','FL_DATASETREGISTER',0,2,'','4294967295',10,425,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(124,2740,'incidentregister_status','u_yf_incidentregister',1,16,'incidentregister_status','FL_STATUS',0,2,'','255',9,425,1,'V~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(124,2741,'incidentregister_type','u_yf_incidentregister',1,16,'incidentregister_type','FL_TYPE',0,2,'PLL_INTERNAL','255',8,425,1,'V~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(124,2742,'incident_date','u_yf_incidentregister',1,5,'incident_date','FL_INCIDENT_DATE',0,2,'',NULL,1,431,1,'D~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(124,2743,'discovery_date','u_yf_incidentregister',1,5,'discovery_date','FL_INCIDENT_DISCOVERY',0,2,'',NULL,3,431,1,'D~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(124,2744,'incident_report_date','u_yf_incidentregister',1,5,'incident_report_date','FL_INCIDENT_REPORT_DATE',0,2,'',NULL,2,431,1,'D~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(124,2745,'incident_publication_date','u_yf_incidentregister',1,5,'incident_publication_date','FL_INCIDENT_PUBLICATION_DATE',0,2,'',NULL,4,431,1,'D~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(124,2746,'peoplne_number','u_yf_incidentregister',1,7,'peoplne_number','FL_PEOPLE_NUMBER',0,2,'','0,4294967295',11,425,1,'I~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(124,2747,'breach_circumstances','u_yf_incidentregister',1,300,'breach_circumstances','FL_BREACH_CIRCUMSTANCES',0,2,'','65535',0,427,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(124,2748,'breach_nature','u_yf_incidentregister',1,300,'breach_nature','FL_NATURE_OF_BREACH',0,2,'','65535',0,428,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(124,2749,'possible_consequences','u_yf_incidentregister',1,300,'possible_consequences','LBL_POSSIBLE_CONSEQUENCES',0,2,'','65535',0,429,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(124,2750,'security_measures','u_yf_incidentregister',1,300,'security_measures','FL_SECURITY_MEASURES',0,2,'','65535',0,430,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(125,2751,'name','u_yf_auditregister',1,2,'name','FL_NAME',0,2,'','255',0,432,1,'V~M',2,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(125,2752,'number','u_yf_auditregister',1,4,'number','FL_NUMBER',0,2,'','32',0,432,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(125,2753,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',0,432,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(125,2754,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,0,432,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(125,2755,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,0,432,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(125,2756,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',0,432,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(125,2757,'locationregisterid','u_yf_auditregister',1,10,'locationregisterid','FL_LOCATION_REGISTER',0,2,'','4294967295',0,432,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(125,2758,'datasetregisterid','u_yf_auditregister',1,10,'datasetregisterid','FL_DATASETREGISTER',0,2,'','4294967295',0,432,1,'V~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(125,2759,'auditregister_status','u_yf_auditregister',1,16,'auditregister_status','FL_STATUS',0,2,'','255',0,432,1,'V~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(125,2760,'auditregister_type','u_yf_auditregister',1,16,'auditregister_type','FL_TYPE',0,2,'PLL_INTERNAL','255',0,432,1,'V~O',1,0,'BAS',1,'',1,'','0',0,0,0,0,'',NULL),
			(125,2761,'description','vtiger_crmentity',1,300,'description','FL_DESCRIPTION',0,2,'','65535',0,434,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(125,2762,'attention','vtiger_crmentity',1,300,'attention','FL_COMMENTS',0,2,'','65535',0,435,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(41,2763,'projectmilestone_status','vtiger_projectmilestone',1,15,'projectmilestone_status','FL_STATUS',0,2,'PLL_PLANNED','255',6,101,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,2764,'authy_methods','vtiger_users',1,16,'authy_methods','FL_AUTHY_METHODS',0,2,'','255',4,83,2,'V~O',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,2765,'authy_secret_totp','vtiger_users',1,312,'authy_secret_totp','FL_AUTHY_SECRET_TOTP',0,2,'','255',3,83,2,'V~O',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,2766,'login_method','vtiger_users',1,16,'login_method','FL_LOGIN_METHOD',0,2,'PLL_PASSWORD','255',1,83,1,'V~M',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(107,2767,'externalcomment','u_yf_fcorectinginvoice',1,21,'externalcomment','FL_EXTERNAL_COMMENT',0,2,'','65535',0,436,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2768,'internalcomment','u_yf_fcorectinginvoice',1,21,'internalcomment','FL_INTERNAL_COMMENT',0,2,'','65535',0,436,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,2769,'parent_id','u_yf_competition',1,10,'parent_id','LBL_PARENT_ID',0,2,'','4294967295',8,303,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(40,2770,'parents','vtiger_modcomments',1,1,'parents','FL_PARENTS',0,2,'','65535',9,98,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2771,'issue_time','u_yf_finvoice',1,5,'issue_time','FL_ISSUE_TIME',0,2,'',NULL,4,310,1,'D~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,2772,'multicompanyid','vtiger_ossemployees',1,10,'multicompanyid','FL_ORGANIZATION_STRUCTURE',0,0,'','-2147483648,2147483647',20,151,1,'I~M',2,0,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(119,2773,'website','u_yf_multicompany',1,17,'website','FL_WEBSITE',0,2,'','255',9,407,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(119,2774,'logo','u_yf_multicompany',1,69,'logo','FL_LOGO',0,2,'','65535',0,406,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(85,2775,'campaign_id','u_yf_squoteenquiries',1,10,'campaign_id','FL_CAMPAIGN_ID',0,2,'','-2147483648,2147483647',9,265,1,'I~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,2776,'sync_carddav','vtiger_users',1,16,'sync_carddav','LBL_CARDDAV_SYNCHRONIZATION_CONTACT',0,2,'PLL_OWNER','100',1,453,1,'V~M',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,2777,'sync_caldav','vtiger_users',1,16,'sync_caldav','LBL_CALDAV_SYNCHRONIZATION_CALENDAR',0,2,'PLL_OWNER','100',2,453,1,'V~M',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(112,2778,'smtp_id','u_yf_emailtemplates',1,316,'smtp_id','SMTP',0,2,'','4294967295',0,376,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(41,2779,'estimated_work_time','vtiger_projectmilestone',1,7,'estimated_work_time','LBL_ESTIMATED_WORK_TIME',1,2,'','0,9999999999999',15,101,10,'NN~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(43,2780,'estimated_work_time','vtiger_project',1,7,'estimated_work_time','LBL_ESTIMATED_WORK_TIME',1,2,'','0,9999999999999',16,107,10,'NN~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,2781,'subprocess_sl','vtiger_activity',1,64,'subprocess_sl','FL_SUBPROCESS_SECOND_LEVEL',0,0,'','4294967295',6,87,1,'I~O',1,0,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(51,2782,'subprocess_sl','vtiger_osstimecontrol',1,64,'subprocess_sl','FL_SUBPROCESS_SECOND_LEVEL',0,0,'','4294967295',15,129,1,'I~O',1,0,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(29,2783,'sync_carddav_default_country','vtiger_users',1,35,'sync_carddav_default_country','LBL_CARDDAV_DEFAULT_COUNTRY',0,2,'','255',3,453,1,'V~O',1,0,'BAS',1,'Edit,Detail,PreferenceDetail',0,'',NULL,0,0,0,0,'',NULL),
			(29,2784,'default_search_module','vtiger_users',1,301,'default_search_module','FL_DEFAULT_SEARCH_MODULE',0,2,'','25',0,437,1,'V~O',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,2785,'default_search_override','vtiger_users',1,56,'default_search_override','FL_OVERRIDE_SEARCH_MODULE',0,2,'','-128,127',0,437,1,'V~O',1,0,'BAS',1,'Edit,Detail,PreferenceDetail',0,'',NULL,0,0,0,0,'',NULL),
			(95,2786,'ssalesprocessesid','u_yf_finvoice',1,10,'ssalesprocessesid','FL_OPPORTUNITY',0,2,'','-2147483648,2147483647',12,310,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2787,'projectid','u_yf_finvoice',1,10,'projectid','FL_PROJECT',0,2,'','-2147483648,2147483647',13,310,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,2788,'pricebook_id','vtiger_account',1,10,'pricebook_id','FL_PRICEBOOK',0,2,'','-2147483648,2147483647',1,439,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(96,2789,'featured','u_yf_knowledgebase',1,56,'featured','FL_FEATURED',0,2,'','-128,127',6,314,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(96,2790,'introduction','u_yf_knowledgebase',1,300,'introduction','FL_INTRODUCTION',0,2,'','65535',2,315,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,2791,'parentid','vtiger_troubletickets',1,10,'parentid','FL_HELP_DESK_PARENT',0,0,'','-2147483648,2147483647',6,27,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2792,'istorageaddressid','u_yf_ssingleorders',1,10,'istorageaddressid','FL_STORAGE',0,2,'','-2147483648,2147483647',17,284,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,2793,'check_stock_levels','vtiger_account',1,56,'check_stock_levels','FL_CHECK_STOCK_LEVELS',0,2,'','-128,127',0,439,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(15,2794,'subject','vtiger_faq',1,1,'subject','FL_SUBJECT',0,2,'','255',1,37,1,'V~O~LE~255',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(15,2795,'content','vtiger_faq',1,300,'content','FL_CONTENT',0,2,'','16777215',1,442,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(15,2796,'category','vtiger_faq',1,302,'category','FL_CATEGORY',0,2,'','30',3,37,1,'V~O',1,0,'BAS',1,'',0,'29',NULL,0,0,0,0,'',NULL),
			(15,2797,'featured','vtiger_faq',1,56,'featured','FL_FEATURED',0,2,'','-128,127',6,37,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(15,2798,'introduction','vtiger_faq',1,300,'introduction','FL_INTRODUCTION',0,2,'','65535',2,442,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(15,2799,'knowledgebase_view','vtiger_faq',1,16,'knowledgebase_view','FL_VIEWS',0,2,'','255',4,37,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,2800,'sum_open_orders','vtiger_account',1,71,'sum_open_orders','FL_SUM_ORDERS',0,2,'','1.0E+20',2,439,2,'N~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(111,2801,'category','u_yf_notification',1,302,'category','FL_CATEGORY',0,2,'','30',7,374,1,'V~O',2,3,'BAS',1,'',0,'30','',0,0,0,0,'',NULL),
			(79,2802,'payment_system','vtiger_paymentsin',1,16,'payment_system','FL_PAYMENT_SYSTEM',1,2,'','64',5,251,10,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,2803,'transaction_id','vtiger_paymentsin',1,1,'transaction_id','FL_TRANSACTION',1,2,'','255',6,251,10,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,2804,'ssingleordersid','vtiger_paymentsin',1,10,'ssingleordersid','FL_ORDER',1,2,'','-2147483648,2147483647',7,251,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,2805,'finvoiceid','vtiger_paymentsin',1,10,'finvoiceid','FL_INVOICE',1,2,'','-2147483648,2147483647',8,251,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,2806,'response_range_time','vtiger_troubletickets',1,308,'response_range_time','FL_RESPONSE_RANGE_TIME',0,2,'','-2147483648,2147483647',0,444,2,'I~O',1,0,'BAS',1,'Detail',0,'',NULL,0,0,0,0,'',NULL),
			(13,2807,'solution_range_time','vtiger_troubletickets',1,308,'solution_range_time','FL_SOLUTION_RANGE_TIME',0,2,'','-2147483648,2147483647',0,444,2,'I~O',1,0,'BAS',1,'Detail',0,'',NULL,0,0,0,0,'',NULL),
			(13,2808,'idle_range_time','vtiger_troubletickets',1,308,'idle_range_time','FL_IDLE_RANGE_TIME',0,2,'','-2147483648,2147483647',0,444,2,'I~O',1,0,'BAS',1,'Detail',0,'',NULL,0,0,0,0,'',NULL),
			(13,2809,'closing_range_time','vtiger_troubletickets',1,308,'closing_range_time','FL_CLOSING_RANGE_TIME',0,2,'','-2147483648,2147483647',0,444,2,'I~O',1,0,'BAS',1,'Detail',0,'',NULL,0,0,0,0,'',NULL),
			(13,2810,'response_datatime','vtiger_troubletickets',1,79,'response_datatime','FL_RESPONSE_DATE_TIME',0,2,'',NULL,0,444,2,'DT~O',1,0,'BAS',1,'Detail',0,'',NULL,0,0,0,0,'',NULL),
			(13,2811,'solution_datatime','vtiger_troubletickets',1,79,'solution_datatime','FL_SOLUTION_DATE_TIME',0,2,'',NULL,0,444,2,'DT~O',1,0,'BAS',1,'Detail',0,'',NULL,0,0,0,0,'',NULL),
			(13,2812,'idle_datatime','vtiger_troubletickets',1,79,'idle_datatime','FL_IDLE_DATE_TIME',0,2,'',NULL,0,444,2,'DT~O',1,0,'BAS',1,'Detail',0,'',NULL,0,0,0,0,'',NULL),
			(13,2813,'closing_datatime','vtiger_troubletickets',1,79,'closing_datatime','FL_CLOSING_DATE_TIME',0,2,'',NULL,0,444,2,'DT~O',1,0,'BAS',1,'Detail',0,'',NULL,0,0,0,0,'',NULL),
			(13,2814,'response_expected','vtiger_troubletickets',1,79,'response_expected','FL_RESPONSE_EXPECTED',0,2,'',NULL,0,444,2,'DT~O',1,0,'BAS',1,'Detail',1,'','',0,0,0,0,'',NULL),
			(13,2815,'solution_expected','vtiger_troubletickets',1,79,'solution_expected','FL_SOLUTION_EXPECTED',0,2,'',NULL,0,444,2,'DT~O',1,0,'BAS',1,'Detail',1,'','',0,0,0,0,'',NULL),
			(13,2816,'idle_expected','vtiger_troubletickets',1,79,'idle_expected','FL_IDLE_DATE_EXPECTED',0,2,'',NULL,0,444,2,'DT~O',1,0,'BAS',1,'Detail',0,'',NULL,0,0,0,0,'',NULL),
			(14,2817,'purchase','vtiger_products',1,360,'purchase','FL_PURCHASE',0,2,'','0,99999999',6,32,1,'V~O',2,3,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(90,2818,'ssingleorders_method_payments','u_yf_ssingleorders',1,16,'payment_methods','FL_PAYMENTS_METHOD',0,2,'','255',16,284,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(35,2819,'purchase','vtiger_service',1,360,'purchase','FL_COST',0,2,'','0,99999999',4,92,1,'V~O',2,3,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(15,2821,'accountid','vtiger_faq',1,10,'accountid','FL_ACCOUNT',0,2,'','4294967295',8,37,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,2822,'taxes','vtiger_account',1,303,'taxes','FL_TAXES',0,2,'','65535',11,198,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(6,2823,'accounts_available_taxes','vtiger_account',1,33,'accounts_available_taxes','FL_AVAILABLE_TAXES',0,2,'','65535',3,439,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(14,2824,'weight','vtiger_products',1,7,'weight','FL_WEIGHT',0,2,'','0,99999999',8,33,1,'NN~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2825,'payment_status','u_yf_finvoice',1,15,'payment_status','FL_PAYMENT_STATUS',1,2,'PLL_NOT_PAID','255',14,310,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2826,'payment_status','u_yf_ssingleorders',1,15,'payment_status','FL_PAYMENT_STATUS',1,2,'PLL_NOT_PAID','255',15,284,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(34,2827,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',0,445,1,'V~O',1,0,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(34,2828,'attention','vtiger_crmentity',1,300,'attention','Attention',0,2,'','65535',0,445,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(13,2829,'sum_time_subordinate','vtiger_troubletickets',1,8,'sum_time_subordinate','FL_SUM_TIME_SUBORDINATE',1,2,'','99999999',17,27,2,'NN~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,2830,'primary_phone_extra','vtiger_users',1,1,'primary_phone_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',5,468,3,'V~O',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,2831,'primary_phone','vtiger_users',1,11,'primary_phone','FL_PRIMARY_PHONE',0,2,'','50',3,468,1,'V~O',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(14,2832,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',33,31,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(15,2833,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',9,37,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(19,2834,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',12,46,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(26,2835,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',19,74,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(51,2836,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',16,128,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(54,2837,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',22,134,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(57,2838,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',18,138,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(58,2839,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',14,141,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(59,2840,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',33,144,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(61,2842,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',21,151,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(74,2843,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',15,232,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(75,2844,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',16,236,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(79,2845,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',9,250,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(80,2846,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',10,252,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(81,2847,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',25,254,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(82,2848,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',21,256,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(83,2849,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',6,258,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(84,2850,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',16,261,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(85,2851,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',10,265,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2852,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',16,269,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(87,2853,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',10,272,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(88,2854,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',10,276,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,2855,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',12,280,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2856,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',18,284,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(91,2857,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',14,288,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,2858,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',9,299,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(93,2859,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',9,303,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(94,2860,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',6,307,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2861,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',15,310,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(97,2862,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',9,316,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(98,2863,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',9,321,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,2864,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',8,323,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(100,2865,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',10,327,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(101,2866,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',8,329,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(102,2867,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',8,331,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(103,2868,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',9,333,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(104,2869,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',11,347,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(105,2870,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',8,351,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(106,2871,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',11,355,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(107,2872,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',15,361,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(108,2873,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',10,365,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(109,2874,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',10,369,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(115,2875,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',9,388,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(117,2876,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',11,400,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(127,2877,'name','u_yf_approvals',1,2,'name','FL_NAME',0,2,'','255',0,446,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(127,2878,'approvals_status','u_yf_approvals',1,16,'approvals_status','FL_APPROVALS_STATUS',0,0,'','255',0,446,1,'V~M',2,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(127,2879,'number','u_yf_approvals',1,4,'number','FL_NUMBER',0,2,'','32',0,447,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(127,2880,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',0,447,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(127,2881,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,0,447,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(127,2882,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,0,447,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(127,2883,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',0,447,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(127,2884,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',0,447,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(127,2885,'description','vtiger_crmentity',1,300,'description','FL_DESCRIPTION',0,2,'','65535',0,448,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(128,2886,'subject','u_yf_approvalsregister',1,2,'subject','FL_SUBJECT',0,2,'','255',0,449,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(128,2887,'approvalsid','u_yf_approvalsregister',1,10,'approvalsid','FL_APPROVAL',0,0,'','4294967295',0,449,1,'V~M',2,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(128,2888,'contactid','u_yf_approvalsregister',1,10,'contactid','FL_CONTACT',0,0,'','4294967295',0,449,1,'V~M',2,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(128,2889,'approvals_register_status','u_yf_approvalsregister',1,15,'approvals_register_status','FL_STATUS',0,0,'','255',0,449,1,'V~M',2,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(128,2890,'approvals_register_type','u_yf_approvalsregister',1,16,'approvals_register_type','FL_TYPE',0,0,'','255',0,449,1,'V~M',2,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(128,2891,'number','u_yf_approvalsregister',1,4,'number','FL_NUMBER',0,2,'','32',0,450,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(128,2892,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',0,450,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(128,2893,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,0,450,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(128,2894,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,0,450,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(128,2895,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',0,450,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(128,2896,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',0,450,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(128,2897,'description','vtiger_crmentity',1,300,'description','FL_DESCRIPTION',0,2,'','65535',0,451,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(128,2898,'registration_date','u_yf_approvalsregister',1,79,'registration_date','FL_REGISTRATION_DATE',0,0,'',NULL,0,449,1,'DT~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,2899,'mail_scanner_actions','vtiger_users',1,322,'mail_scanner_actions','FL_MAIL_SCANNER_ACTIONS',0,2,'','65535',1,452,1,'V~O',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,2900,'mail_scanner_fields','vtiger_users',1,323,'mail_scanner_fields','FL_MAIL_SCANNER_FIELDS',0,2,'','65535',2,452,1,'V~O',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(4,2901,'approvals','vtiger_contactdetails',1,321,'approvals','FL_APPROVALS',0,2,'','65535',11,5,2,'V~O',1,0,'BAS',1,'',0,'{\"module\":\"Approvals\"}',NULL,0,0,0,0,'',NULL),
			(8,2902,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',8,18,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(78,2903,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',7,248,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2904,'subject','u_yf_locations',1,2,'subject','LBL_SUBJECT',0,2,'','255',1,456,1,'V~M',1,0,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(130,2905,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',5,456,1,'V~M',1,0,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(130,2906,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',6,456,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2907,'email','u_yf_locations',1,13,'email','Email',0,2,'','100',3,456,1,'E~O',2,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2908,'active','u_yf_locations',1,56,'active','FL_ACTIVE',0,2,'','-128,127',7,456,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2909,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',8,456,1,'C~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2910,'phone_extra','u_yf_locations',1,1,'phone_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',9,456,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2914,'coordinates','u_yf_locations',1,331,'coordinates','FL_COORDINATES',0,2,'','100',10,456,1,'V~O',1,0,'BAS',1,'',0,'{\"showType\":\"1\",\"type\":\"decimal\",\"showMap\":\"1\",\"showLocation\":\"1\"}',NULL,0,0,0,0,'',''),
			(130,2915,'phone','u_yf_locations',1,11,'phone','FL_PHONE',0,2,'','30',4,456,1,'V~O',2,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2916,'capacity','u_yf_locations',1,7,'capacity','FL_CAPACITY',0,2,'','0,4294967295',2,456,1,'I~O',2,0,'BAS',1,'',0,'','',0,0,0,0,'',NULL),
			(130,2917,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',2,457,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2918,'locations_no','u_yf_locations',1,4,'locations_no','LBL_NUMBER',0,2,'','255',1,457,2,'V~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2919,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'','',3,457,2,'DT~O',1,0,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(130,2920,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'','',5,457,2,'DT~O',1,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2921,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,2,'','65535',4,457,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2922,'addresslevel1a','u_yf_locations_address',1,35,'addresslevel1a','AddressLevel1',0,2,'','255',9,458,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2923,'addresslevel2a','u_yf_locations_address',1,1,'addresslevel2a','AddressLevel2',0,2,'','255',7,458,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2924,'addresslevel3a','u_yf_locations_address',1,1,'addresslevel3a','AddressLevel3',0,2,'','255',10,458,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2925,'addresslevel4a','u_yf_locations_address',1,1,'addresslevel4a','AddressLevel4',0,2,'','255',8,458,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2926,'addresslevel5a','u_yf_locations_address',1,1,'addresslevel5a','AddressLevel5',0,2,'','255',3,458,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2927,'addresslevel6a','u_yf_locations_address',1,1,'addresslevel6a','AddressLevel6',0,2,'','255',6,458,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2928,'addresslevel7a','u_yf_locations_address',1,1,'addresslevel7a','AddressLevel7',0,2,'','255',5,458,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2929,'addresslevel8a','u_yf_locations_address',1,1,'addresslevel8a','AddressLevel8',0,2,'','255',1,458,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2930,'buildingnumbera','u_yf_locations_address',1,1,'buildingnumbera','Building number',0,2,'','255',4,458,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2931,'localnumbera','u_yf_locations_address',1,1,'localnumbera','Local number',0,2,'','50',2,458,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2932,'poboxa','u_yf_locations_address',1,1,'poboxa','Po Box',0,2,'','50',11,458,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(130,2933,'description','vtiger_crmentity',1,300,'description','Description',0,2,'','65535',1,459,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(131,2934,'topic','u_yf_occurrences',1,2,'topic','FL_TOPIC',0,2,'','255',1,460,1,'V~M',2,1,'BAS',2,'',0,'',NULL,0,0,0,0,'',NULL),
			(131,2935,'occurrences_status','u_yf_occurrences',1,15,'occurrences_status','FL_STATUS',0,2,'','255',4,460,1,'V~M',2,6,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(131,2936,'occurrences_type','u_yf_occurrences',1,15,'occurrences_type','FL_TYPE',0,2,'','255',6,460,1,'V~M',2,4,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(131,2937,'date_start','u_yf_occurrences',1,5,'date_start','FL_DATE_START',0,2,'','',3,460,1,'DT~M',2,3,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(131,2938,'date_end','u_yf_occurrences',1,5,'date_end','FL_DATE_END',0,2,'','',5,460,1,'DT~O',2,5,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(131,2939,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',9,460,1,'V~M',2,7,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(131,2940,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',10,460,1,'V~O',1,6,'BAS',1,'',0,'','',0,0,0,0,'',NULL),
			(131,2941,'occurrences_rating','u_yf_occurrences',1,16,'occurrences_rating','FL_RATING',0,2,'','255',7,460,1,'V~O',1,8,'BAS',1,'',0,'','',0,0,0,0,'',NULL),
			(131,2942,'locationid','u_yf_occurrences',1,10,'locationid','FL_LOCATION',0,2,'','4294967295',2,460,1,'V~M',2,2,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(131,2943,'participants','u_yf_occurrences',1,7,'participants','FL_NUMBER_OF_PARTICIPANTS',0,2,'','0,4294967295',8,460,1,'I~O',1,0,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(131,2944,'description','u_yf_occurrences',1,300,'description','FL_DESCRIPTION',0,2,'','65535',1,461,1,'V~O',1,10,'BAS',2,'',0,'','',0,0,0,0,'',NULL),
			(131,2945,'attention','u_yf_occurrences',1,300,'attention','FL_ATTENTION',0,2,'','65535',2,461,1,'V~O',1,9,'BAS',2,'',0,'','',0,0,0,0,'',NULL),
			(131,2946,'number','u_yf_occurrences',1,4,'number','FL_NUMBER',0,2,'','32',1,462,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(131,2947,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'','',3,462,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(131,2948,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'','',2,462,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(131,2949,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',4,462,2,'V~O',3,13,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2950,'estimated_margin','u_yf_ssalesprocesses',1,71,'estimated_margin','FL_ESTIMATED_MARGIN',0,2,'','1.0E+20',3,320,1,'N~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2951,'expected_margin','u_yf_ssalesprocesses',1,71,'expected_margin','FL_EXPECTED_MARGIN',0,2,'','1.0E+20',4,320,2,'N~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(86,2952,'expected_sale','u_yf_ssalesprocesses',1,71,'expected_sale','FL_EXPECTED_SALE',0,2,'','1.0E+20',5,320,2,'N~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2953,'contactid','u_yf_ssingleorders',1,10,'contactid','FL_CONTACT',0,2,'','4294967295',6,284,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2954,'first_name_a','u_yf_ssingleorders_address',1,1,'first_name_a','First Name',0,2,'','255',12,295,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2955,'last_name_a','u_yf_ssingleorders_address',1,1,'last_name_a','Last Name',0,2,'','255',13,295,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2956,'company_name_a','u_yf_ssingleorders_address',1,1,'company_name_a','FL_COMPANY_NAME',0,2,'','255',14,295,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2957,'vat_id_a','u_yf_ssingleorders_address',1,1,'vat_id_a','Vat ID',0,2,'','50',15,295,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2959,'email_a','u_yf_ssingleorders_address',1,13,'email_a','FL_EMAIL',0,2,'','100',16,295,1,'E~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2960,'phone_a','u_yf_ssingleorders_address',1,11,'phone_a','FL_PHONE',0,2,'','100',17,295,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2961,'buildingnumberb','u_yf_ssingleorders_address',1,1,'buildingnumberb','Building number',0,2,'','255',4,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2962,'localnumberb','u_yf_ssingleorders_address',1,1,'localnumberb','Local number',0,2,'','50',2,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2963,'addresslevel8b','u_yf_ssingleorders_address',1,1,'addresslevel8b','AddressLevel8',0,2,'','255',1,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2964,'addresslevel7b','u_yf_ssingleorders_address',1,1,'addresslevel7b','AddressLevel7',0,2,'','255',5,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2965,'addresslevel6b','u_yf_ssingleorders_address',1,1,'addresslevel6b','AddressLevel6',0,2,'','255',6,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2966,'addresslevel5b','u_yf_ssingleorders_address',1,1,'addresslevel5b','AddressLevel5',0,2,'','255',3,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2967,'addresslevel4b','u_yf_ssingleorders_address',1,1,'addresslevel4b','AddressLevel4',0,2,'','255',8,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2968,'addresslevel3b','u_yf_ssingleorders_address',1,1,'addresslevel3b','AddressLevel3',0,2,'','255',10,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2969,'addresslevel2b','u_yf_ssingleorders_address',1,1,'addresslevel2b','AddressLevel2',0,2,'','255',7,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2970,'addresslevel1b','u_yf_ssingleorders_address',1,35,'addresslevel1b','AddressLevel1',0,2,'','255',9,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2971,'poboxb','u_yf_ssingleorders_address',1,1,'poboxb','Po Box',0,2,'','50',11,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2972,'first_name_b','u_yf_ssingleorders_address',1,1,'first_name_b','First Name',0,2,'','255',12,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2973,'last_name_b','u_yf_ssingleorders_address',1,1,'last_name_b','Last Name',0,2,'','255',13,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2974,'company_name_b','u_yf_ssingleorders_address',1,1,'company_name_b','FL_COMPANY_NAME',0,2,'','255',14,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2975,'vat_id_b','u_yf_ssingleorders_address',1,1,'vat_id_b','Vat ID',0,2,'','50',15,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2976,'email_b','u_yf_ssingleorders_address',1,13,'email_b','FL_EMAIL',0,2,'','100',16,463,1,'E~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2977,'phone_b','u_yf_ssingleorders_address',1,11,'phone_b','FL_PHONE',0,2,'','100',17,463,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,2978,'parent_id','u_yf_ssingleorders',1,10,'parent_id','FL_PARENT_SSINGLEORDERS',0,2,'','4294967295',19,284,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(89,2979,'parent_id','u_yf_squotes',1,10,'parent_id','FL_PARENT_SQUOTES',0,2,'','4294967295',13,280,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(88,2980,'parent_id','u_yf_scalculations',1,10,'parent_id','FL_PARENT_SCALCULATIONS',0,2,'','4294967295',11,276,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(132,2981,'category','u_yf_productcategory',1,2,'category','FL_CATEGORY_NAME',0,2,'','255',1,464,1,'V~M',2,0,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(132,2982,'number','u_yf_productcategory',1,4,'number','FL_NUMBER',0,2,'','32',0,465,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(132,2983,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',0,465,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(132,2984,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'',NULL,0,465,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(132,2985,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'',NULL,0,465,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(132,2986,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',0,465,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(132,2987,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',0,465,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(132,2988,'parent_id','u_yf_productcategory',1,10,'parent_id','FL_PARENT_CATEGORY',0,2,'','4294967295',3,464,1,'V~O',2,0,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(132,2989,'active','u_yf_productcategory',1,56,'active','FL_ACTIVE',0,2,'','-128,127',2,464,1,'C~O',2,0,'BAS',1,'',1,'','',0,0,0,0,'',NULL),
			(95,2990,'first_name_a','u_yf_finvoice_address',1,1,'first_name_a','First Name',0,2,'','255',12,312,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2991,'last_name_a','u_yf_finvoice_address',1,1,'last_name_a','Last Name',0,2,'','255',13,312,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2992,'company_name_a','u_yf_finvoice_address',1,1,'company_name_a','FL_COMPANY_NAME',0,2,'','255',14,312,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2993,'vat_id_a','u_yf_finvoice_address',1,1,'vat_id_a','Vat ID',0,2,'','50',15,312,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2994,'email_a','u_yf_finvoice_address',1,13,'email_a','FL_EMAIL',0,2,'','100',16,312,1,'E~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2995,'phone_a','u_yf_finvoice_address',1,11,'phone_a','FL_PHONE',0,2,'','100',17,312,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2996,'addresslevel8b','u_yf_finvoice_address',1,1,'addresslevel8b','AddressLevel8',0,2,'','255',1,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2997,'localnumberb','u_yf_finvoice_address',1,1,'localnumberb','Local number',0,2,'','50',2,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2998,'addresslevel5b','u_yf_finvoice_address',1,1,'addresslevel5b','AddressLevel5',0,2,'','255',3,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,2999,'buildingnumberb','u_yf_finvoice_address',1,1,'buildingnumberb','Building number',0,2,'','255',4,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3000,'addresslevel7b','u_yf_finvoice_address',1,1,'addresslevel7b','AddressLevel7',0,2,'','255',5,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3001,'addresslevel6b','u_yf_finvoice_address',1,1,'addresslevel6b','AddressLevel6',0,2,'','255',6,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3002,'addresslevel2b','u_yf_finvoice_address',1,1,'addresslevel2b','AddressLevel2',0,2,'','255',7,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3003,'addresslevel4b','u_yf_finvoice_address',1,1,'addresslevel4b','AddressLevel4',0,2,'','255',8,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3004,'addresslevel1b','u_yf_finvoice_address',1,35,'addresslevel1b','AddressLevel1',0,2,'','255',9,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3005,'addresslevel3b','u_yf_finvoice_address',1,1,'addresslevel3b','AddressLevel3',0,2,'','255',10,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3006,'poboxb','u_yf_finvoice_address',1,1,'poboxb','Po Box',0,2,'','50',11,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3007,'first_name_b','u_yf_finvoice_address',1,1,'first_name_b','First Name',0,2,'','255',12,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3008,'last_name_b','u_yf_finvoice_address',1,1,'last_name_b','Last Name',0,2,'','255',13,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3009,'company_name_b','u_yf_finvoice_address',1,1,'company_name_b','FL_COMPANY_NAME',0,2,'','255',14,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3010,'vat_id_b','u_yf_finvoice_address',1,1,'vat_id_b','Vat ID',0,2,'','50',15,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3011,'email_b','u_yf_finvoice_address',1,13,'email_b','FL_EMAIL',0,2,'','100',16,466,1,'E~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3012,'phone_b','u_yf_finvoice_address',1,11,'phone_b','FL_PHONE',0,2,'','100',17,466,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3013,'addresslevel8b','u_yf_finvoiceproforma_address',1,1,'addresslevel8b','AddressLevel8',0,2,'','255',1,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3014,'localnumberb','u_yf_finvoiceproforma_address',1,1,'localnumberb','Local number',0,2,'','50',2,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3015,'addresslevel5b','u_yf_finvoiceproforma_address',1,1,'addresslevel5b','AddressLevel5',0,2,'','255',3,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3016,'buildingnumberb','u_yf_finvoiceproforma_address',1,1,'buildingnumberb','Building number',0,2,'','255',4,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3017,'addresslevel7b','u_yf_finvoiceproforma_address',1,1,'addresslevel7b','AddressLevel7',0,2,'','255',5,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3018,'addresslevel6b','u_yf_finvoiceproforma_address',1,1,'addresslevel6b','AddressLevel6',0,2,'','255',6,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3019,'addresslevel2b','u_yf_finvoiceproforma_address',1,1,'addresslevel2b','AddressLevel2',0,2,'','255',7,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3020,'addresslevel4b','u_yf_finvoiceproforma_address',1,1,'addresslevel4b','AddressLevel4',0,2,'','255',8,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3021,'addresslevel1b','u_yf_finvoiceproforma_address',1,35,'addresslevel1b','AddressLevel1',0,2,'','255',9,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3022,'addresslevel3b','u_yf_finvoiceproforma_address',1,1,'addresslevel3b','AddressLevel3',0,2,'','255',10,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3023,'poboxb','u_yf_finvoiceproforma_address',1,1,'poboxb','Po Box',0,2,'','50',11,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3024,'first_name_a','u_yf_finvoiceproforma_address',1,1,'first_name_a','First Name',0,2,'','255',12,325,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3025,'first_name_b','u_yf_finvoiceproforma_address',1,1,'first_name_b','First Name',0,2,'','255',12,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3026,'last_name_a','u_yf_finvoiceproforma_address',1,1,'last_name_a','Last Name',0,2,'','255',13,325,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3027,'last_name_b','u_yf_finvoiceproforma_address',1,1,'last_name_b','Last Name',0,2,'','255',13,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3028,'company_name_a','u_yf_finvoiceproforma_address',1,1,'company_name_a','FL_COMPANY_NAME',0,2,'','255',14,325,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3029,'company_name_b','u_yf_finvoiceproforma_address',1,1,'company_name_b','FL_COMPANY_NAME',0,2,'','255',14,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3030,'vat_id_a','u_yf_finvoiceproforma_address',1,1,'vat_id_a','Vat ID',0,2,'','50',15,325,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3031,'vat_id_b','u_yf_finvoiceproforma_address',1,1,'vat_id_b','Vat ID',0,2,'','50',15,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3032,'email_a','u_yf_finvoiceproforma_address',1,13,'email_a','FL_EMAIL',0,2,'','100',16,325,1,'E~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3033,'email_b','u_yf_finvoiceproforma_address',1,13,'email_b','FL_EMAIL',0,2,'','100',16,467,1,'E~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3034,'phone_a','u_yf_finvoiceproforma_address',1,11,'phone_a','FL_PHONE',0,2,'','100',17,325,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3035,'phone_b','u_yf_finvoiceproforma_address',1,11,'phone_b','FL_PHONE',0,2,'','100',17,467,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(9,3036,'meeting_url','vtiger_activity',1,326,'meeting_url','FL_MEETING_URL',0,2,'','2048',28,19,1,'V~O',2,11,'BAS',1,'',1,'{\"exp\":\"due_date\",\"roomName\":\"subject\"}',NULL,0,0,0,0,'',NULL),
			(131,3037,'meeting_url','u_yf_occurrences',1,326,'meeting_url','FL_MEETING_URL',0,2,'','2048',11,460,1,'V~O',1,0,'BAS',1,'',1,'{\"exp\":\"date_end\"}',NULL,0,0,0,0,'',NULL),
			(4,3038,'gender','vtiger_contactdetails',1,16,'gender','FL_GENDER',0,2,'','255',31,4,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,3039,'secondary_email','vtiger_users',2,13,'secondary_email','FL_SECONDARY_EMAIL',0,2,'','100',2,468,1,'E~O',1,0,'BAS',1,'Edit,Detail',0,'',NULL,0,0,0,0,'',NULL),
			(29,3040,'default_search_operator','vtiger_users',1,16,'default_search_operator','FL_DEFAULT_SEARCH_OPERATOR',0,0,'PLL_CONTAINS','255',0,437,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(29,3041,'super_user','vtiger_users',1,56,'super_user','FL_SUPER_USER',0,0,'','-128,127',9,77,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(133,3042,'name','u_yf_bankaccounts',1,2,'name','FL_NAME',0,2,'','255',1,470,1,'V~M',2,0,'BAS',1,'',0,'','',0,0,0,0,'',NULL),
			(133,3043,'currency_id','u_yf_bankaccounts',1,117,'currency_id','FL_CURRENCY',0,2,'','-2147483648,2147483647',3,470,1,'N~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(133,3044,'swift','u_yf_bankaccounts',1,1,'swift','FL_SWIFT',0,2,'','255',6,470,1,'V~O~LE~255',2,0,'BAS',1,'',0,'','',0,0,0,0,'',NULL),
			(133,3045,'bank_name','u_yf_bankaccounts',1,1,'bank_name','FL_BANK_NAME',0,2,'','255',5,470,1,'V~O~LE~255',2,0,'BAS',1,'',0,'','',0,0,0,0,'',NULL),
			(133,3046,'bankaccount_status','u_yf_bankaccounts',1,16,'bankaccount_status','FL_STATUS',0,2,'','255',4,470,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(133,3047,'account_number','u_yf_bankaccounts',1,1,'account_number','FL_BANK_ACCOUNT_NUMBER',0,2,'','255',2,470,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(133,3048,'multicompanyid','u_yf_bankaccounts',1,10,'multicompanyid','FL_MULTICOMPANY',0,2,'','4294967295',7,470,1,'V~O',2,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(133,3049,'number','u_yf_bankaccounts',1,4,'number','FL_NUMBER',0,2,'','32',0,471,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(133,3050,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',0,471,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(133,3051,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'','',0,471,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(133,3052,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'','',0,471,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(133,3053,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',0,471,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(133,3054,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',0,471,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3055,'payment_sum','u_yf_finvoiceproforma',1,7,'payment_sum','FL_PAYMENT_SUM',0,2,'','1.0E+20',9,323,2,'NN~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3056,'payment_status','u_yf_finvoiceproforma',1,16,'payment_status','FL_PAYMENT_STATUS',0,2,'','255',10,323,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3057,'payment_sum','u_yf_finvoice',1,7,'payment_sum','FL_PAYMENT_SUM',0,2,'','1.0E+20',16,310,2,'NN~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3059,'phone_a_extra','u_yf_finvoiceproforma_address',1,1,'phone_a_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',18,325,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(99,3060,'phone_b_extra','u_yf_finvoiceproforma_address',1,1,'phone_b_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',18,467,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3061,'phone_b_extra','u_yf_finvoice_address',1,1,'phone_b_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',18,466,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(95,3062,'phone_a_extra','u_yf_finvoice_address',1,1,'phone_a_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',18,312,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,3063,'phone_a_extra','u_yf_ssingleorders_address',1,1,'phone_a_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',18,295,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(90,3064,'phone_b_extra','u_yf_ssingleorders_address',1,1,'phone_b_extra','FL_PHONE_CUSTOM_INFORMATION',0,2,'','100',18,463,3,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(112,3065,'sys_name','u_yf_emailtemplates',1,1,'sys_name','FL_SYS_NAME',0,0,'','50',8,378,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(134,3066,'subject','u_yf_queue',1,2,'subject','FL_SUBJECT',0,2,'','255',0,472,1,'V~M',2,0,'BAS',1,'',1,'',NULL,0,0,0,0,'',NULL),
			(134,3067,'related_to','u_yf_queue',1,10,'related_to','FL_RELATED_TO',0,0,'','4294967295',0,472,1,'V~M',2,0,'BAS',0,'',1,'',NULL,0,0,0,0,'',NULL),
			(134,3068,'changes','u_yf_queue',1,328,'changes','FL_CHANGES',0,0,'','65535',0,472,1,'V~M',2,0,'BAS',0,'',1,'{\"field\":\"related_to\"}',NULL,0,0,0,0,'',NULL),
			(134,3069,'queue_status','u_yf_queue',1,15,'queue_status','FL_STATUS',0,0,'','255',0,472,1,'V~M',2,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(134,3070,'reason_for_change','u_yf_queue',2,21,'reason_for_change','FL_REASON_FOR_CHANGE',0,2,'','65535',1,473,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(134,3071,'reason_for_rejection','u_yf_queue',2,21,'reason_for_rejection','FL_REASON_FOR_REJECTION',0,2,'','65535',2,473,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(134,3072,'number','u_yf_queue',1,4,'number','FL_NUMBER',0,2,'','32',0,474,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(134,3073,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,2,'','65535',0,474,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(134,3074,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,2,'','',0,474,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(134,3075,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,2,'','',0,474,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(134,3076,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,2,'','65535',0,474,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(134,3077,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,2,'','65535',0,474,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',NULL),
			(134,3078,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,2,'','65535',0,474,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',NULL),
			(92,3080,'parentid','u_yf_partners',1,10,'parentid','FL_MEMBER_OF',0,2,'','4294967295',10,299,1,'V~O',2,3,'BAS',1,'',1,'',NULL,0,0,0,0,'',''),
			(135,3081,'subject','u_yf_passwords',1,2,'subject','FL_SUBJECT',0,2,'','255',1,475,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(135,3082,'multicompanyid','u_yf_passwords',1,10,'multicompanyid','FL_MULTICOMPANY',0,2,'','4294967295',6,475,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(135,3083,'link','u_yf_passwords',1,67,'link','FL_RELATED_TO',0,2,'','4294967295',5,475,1,'I~O',2,9,'BAS',1,'',1,'',NULL,0,0,0,0,'',''),
			(135,3084,'linkextend','u_yf_passwords',1,65,'linkextend','FL_RELATION_EXTEND',0,2,'','4294967295',7,475,1,'I~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(135,3085,'website','u_yf_passwords',1,17,'website','FL_WEBSITE',0,2,'','255',2,475,1,'V~O',2,8,'BAS',1,'',1,'',NULL,0,0,0,0,'',''),
			(135,3086,'username','u_yf_passwords',1,1,'username','FL_USER_NAME',0,2,'','255',3,475,1,'V~O',2,7,'BAS',1,'',1,'',NULL,0,0,0,0,'',''),
			(135,3087,'password','u_yf_passwords',1,99,'password','FL_PASSWORD',0,2,'','100',4,475,1,'V~O',2,6,'BAS',1,'',1,'{\"validate\":[\"pwned\",\"config\"],\"auto-generate\":true,\"strengthMeter\":true,\"copy\":true}',NULL,0,0,0,0,'',''),
			(135,3088,'description','vtiger_crmentity',1,300,'description','FL_DESCRIPTION',0,2,'','65535',0,476,1,'V~O',1,0,'BAS',2,'',0,'',NULL,0,0,0,0,'',''),
			(135,3089,'number','u_yf_passwords',1,4,'number','FL_NUMBER',0,2,'','32',0,477,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(135,3090,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',0,477,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(135,3091,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'','65535',0,477,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(135,3092,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'','65535',0,477,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(135,3093,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,0,'','65535',0,477,2,'V~O',3,10,'BAS',0,'',0,'',NULL,0,0,0,0,'',''),
			(135,3094,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',0,477,2,'V~O',3,11,'BAS',0,'',0,'',NULL,0,0,0,0,'',''),
			(135,3095,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,0,'','65535',0,477,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(135,3096,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,0,'','-128,127',0,477,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(13,3097,'contact_id','vtiger_troubletickets',1,10,'contact_id','FL_CONTACT',0,2,'','4294967295',7,25,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(111,3098,'subprocess_sl','u_yf_notification',2,64,'subprocess_sl','FL_SUBPROCESS_SECOND_LEVEL',0,0,'','4294967295',10,374,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(79,3099,'finvoiceproformaid','vtiger_paymentsin',1,10,'finvoiceproformaid','FL_FINVOICE_PROFORMA',0,2,'','4294967295',9,251,1,'I~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(29,3100,'calendar_all_users_by_default','vtiger_users',1,56,'calendar_all_users_by_default','FL_CALENDAR_ALL_USERS_BY_DEFAULT',0,2,'','-128,127',12,118,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(136,3101,'subject','u_yf_smstemplates',1,2,'subject','FL_SUBJECT',0,0,'','255',0,478,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(136,3102,'target','u_yf_smstemplates',1,301,'target','FL_TARGET_MODULE',0,0,'','25',0,478,1,'V~M~LE~25',2,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(136,3103,'message','u_yf_smstemplates',1,21,'message','FL_MESSAGE',0,0,'','65535',1,479,1,'V~M',2,0,'BAS',1,'',0,'{\"editWidth\":\"col-sm-12\",\"detailsWidth\":\"col-lg-6\"}',NULL,0,0,0,0,'',''),
			(136,3104,'number','u_yf_smstemplates',1,4,'number','FL_NUMBER',0,0,'','32',4,480,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(136,3105,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',1,480,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(136,3106,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'','65535',5,480,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(136,3107,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'','65535',6,480,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(136,3108,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,0,'','65535',7,480,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',''),
			(136,3109,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',8,480,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',''),
			(136,3110,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,0,'','65535',2,480,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(136,3111,'private','vtiger_crmentity',2,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',3,480,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(45,3112,'phone','vtiger_smsnotifier',1,11,'phone','FL_PHONE',0,0,'','30',2,110,10,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(45,3113,'related_to','vtiger_smsnotifier',1,10,'related_to','FL_RELATED_TO',0,0,'','4294967295',1,110,10,'I~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(45,3114,'msgid','vtiger_smsnotifier',1,1,'msgid','FL_MESSAGE_ID',0,0,'','50',2,111,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(45,3115,'parentid','vtiger_smsnotifier',1,10,'parentid','FL_PARENT',0,0,'','4294967295',4,110,2,'I~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(45,3116,'image','vtiger_smsnotifier',1,69,'image','FL_IMAGE',0,2,'','65535',2,481,1,'V~O',2,0,'BAS',1,'',0,'{\"maxFileSize\":512000}',NULL,0,0,0,0,'',''),
			(29,3139,'mail_popup','vtiger_users',1,56,'mail_popup','FL_MAIL_POPUP',0,2,'','-128,127',4,452,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(45,3143,'sms_provider_id','vtiger_smsnotifier',1,90,'sms_provider_id','FL_SMS_PROVIDER',0,2,'',NULL,5,110,1,'I~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(6,3145,'account_short_name','vtiger_account',1,1,'account_short_name','FL_ACCOUNT_SHORT_NAME',0,2,'','255',12,9,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(133,3146,'related_to','u_yf_bankaccounts',1,10,'related_to','FL_RELATED_TO',0,0,'','4294967295',8,470,1,'I~O',2,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(107,3147,'company_name_a','u_yf_fcorectinginvoice_address',1,1,'company_name_a','FL_COMPANY_NAME',0,0,'','255',12,363,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(107,3148,'first_name_a','u_yf_fcorectinginvoice_address',1,1,'first_name_a','First Name',0,0,'','255',13,363,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(107,3149,'last_name_a','u_yf_fcorectinginvoice_address',1,1,'last_name_a','Last Name',0,0,'','255',14,363,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(107,3150,'vat_id_a','u_yf_fcorectinginvoice_address',1,1,'vat_id_a','Vat ID',0,0,'','50',15,363,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(107,3151,'issue_time','u_yf_fcorectinginvoice',1,5,'issue_time','FL_ISSUE_TIME',0,0,'',NULL,16,361,1,'D~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(138,3152,'name','u_yf_report_template',1,2,'name','LBL_NAME',0,2,'','255',0,485,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(138,3153,'description','u_yf_report_template',2,1,'description','LBL_DESCRIPTION',0,2,'','65535',0,485,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(138,3154,'number','u_yf_report_template',1,4,'number','FL_NUMBER',0,2,'','32',0,486,2,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(138,3155,'smownerid','vtiger_crmentity',1,53,'assigned_user_id','Assigned To',0,0,'','65535',0,486,1,'V~M',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(138,3156,'createdtime','vtiger_crmentity',1,70,'createdtime','Created Time',0,0,'','65535',0,486,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(138,3157,'modifiedtime','vtiger_crmentity',1,70,'modifiedtime','Modified Time',0,0,'','65535',0,486,2,'DT~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(138,3158,'smcreatorid','vtiger_crmentity',1,52,'created_user_id','Created By',0,0,'','65535',0,486,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',''),
			(138,3159,'modifiedby','vtiger_crmentity',1,52,'modifiedby','Last Modified By',0,0,'','65535',0,486,2,'V~O',3,0,'BAS',0,'',0,'',NULL,0,0,0,0,'',''),
			(138,3160,'shownerid','vtiger_crmentity',1,120,'shownerid','Share with users',0,0,'','65535',0,486,1,'V~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'',''),
			(138,3161,'private','vtiger_crmentity',1,56,'private','FL_IS_PRIVATE',0,2,'','-128,127',0,486,1,'C~O',1,0,'BAS',1,'',0,'',NULL,0,0,0,0,'','');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_fieldmodulerel`(`fieldid`,`module`,`relmodule`,`status`,`sequence`) values
			(546,'ServiceContracts','Accounts',NULL,NULL),
			(580,'Assets','Products',NULL,NULL),
			(601,'ModComments','Leads',NULL,NULL),
			(601,'ModComments','Contacts',NULL,NULL),
			(601,'ModComments','Accounts',NULL,NULL),
			(603,'ModComments','ModComments',NULL,NULL),
			(606,'ProjectMilestone','Project',NULL,NULL),
			(617,'ProjectTask','Project',NULL,NULL),
			(601,'ModComments','ProjectTask',NULL,NULL),
			(635,'Project','Accounts',NULL,NULL),
			(601,'ModComments','Project',NULL,NULL),
			(601,'ModComments','HelpDesk',NULL,NULL),
			(601,'ModComments','Faq',NULL,NULL),
			(691,'ModComments','Contacts',NULL,NULL),
			(157,'HelpDesk','Accounts',NULL,1),
			(601,'ModComments','OSSTimeControl',NULL,NULL),
			(943,'OSSEmployees','OSSEmployees',NULL,NULL),
			(601,'ModComments','OSSEmployees',NULL,NULL),
			(72,'Contacts','Accounts',NULL,NULL),
			(72,'Contacts','Leads',NULL,NULL),
			(1044,'Project','ServiceContracts',NULL,NULL),
			(1049,'HelpDesk','ServiceContracts',NULL,NULL),
			(1314,'Assets','Accounts',NULL,NULL),
			(1314,'Assets','Leads',NULL,NULL),
			(1315,'OutsourcedProducts','Accounts',NULL,1),
			(1315,'OutsourcedProducts','Leads',NULL,2),
			(1316,'OSSOutsourcedServices','Accounts',NULL,NULL),
			(1316,'OSSOutsourcedServices','Leads',NULL,NULL),
			(1317,'OSSSoldServices','Accounts',NULL,NULL),
			(1317,'OSSSoldServices','Leads',NULL,NULL),
			(1318,'ProjectTask','ProjectTask',NULL,NULL),
			(1319,'ProjectTask','ProjectMilestone',NULL,NULL),
			(1344,'OSSSoldServices','Services',NULL,NULL),
			(159,'HelpDesk','Products',NULL,1),
			(159,'HelpDesk','Services',NULL,2),
			(1482,'HelpDesk','Assets',NULL,NULL),
			(1482,'HelpDesk','OutsourcedProducts',NULL,NULL),
			(1482,'HelpDesk','OSSSoldServices',NULL,NULL),
			(1482,'HelpDesk','OSSOutsourcedServices',NULL,NULL),
			(1521,'CallHistory','Contacts',NULL,NULL),
			(1521,'CallHistory','Accounts',NULL,NULL),
			(1521,'CallHistory','Leads',NULL,NULL),
			(1521,'CallHistory','Vendors',NULL,NULL),
			(1521,'CallHistory','OSSEmployees',NULL,NULL),
			(1522,'CallHistory','HelpDesk',NULL,NULL),
			(601,'ModComments','Ideas',NULL,NULL),
			(72,'Contacts','Vendors',NULL,NULL),
			(1607,'HolidaysEntitlement','OSSEmployees',NULL,NULL),
			(1622,'PaymentsIn','Accounts',NULL,NULL),
			(1638,'PaymentsOut','Accounts',NULL,NULL),
			(1640,'PaymentsOut','PaymentsOut',NULL,NULL),
			(1655,'LettersIn','Accounts',NULL,NULL),
			(1655,'LettersIn','Leads',NULL,NULL),
			(1660,'LettersIn','LettersIn',NULL,NULL),
			(601,'ModComments','LettersIn',NULL,NULL),
			(1677,'LettersOut','Accounts',NULL,NULL),
			(1677,'LettersOut','Leads',NULL,NULL),
			(1682,'LettersOut','LettersOut',NULL,NULL),
			(601,'ModComments','LettersOut',NULL,NULL),
			(601,'ModComments','Reservations',NULL,NULL),
			(1677,'LettersOut','Vendors',NULL,NULL),
			(1655,'LettersIn','Vendors',NULL,NULL),
			(1677,'LettersOut','OSSEmployees',NULL,NULL),
			(1655,'LettersIn','OSSEmployees',NULL,NULL),
			(157,'HelpDesk','Vendors',NULL,2),
			(635,'Project','Vendors',NULL,NULL),
			(1762,'Calendar','Calendar',NULL,NULL),
			(1767,'SQuoteEnquiries','SSalesProcesses',NULL,NULL),
			(1769,'SQuoteEnquiries','Accounts',NULL,NULL),
			(601,'ModComments','SQuoteEnquiries',NULL,NULL),
			(1781,'SSalesProcesses','Accounts',NULL,NULL),
			(601,'ModComments','SSalesProcesses',NULL,NULL),
			(1791,'SRequirementsCards','SSalesProcesses',NULL,NULL),
			(1792,'SRequirementsCards','SQuoteEnquiries',NULL,NULL),
			(1794,'SRequirementsCards','Accounts',NULL,NULL),
			(601,'ModComments','SRequirementsCards',NULL,NULL),
			(1806,'SCalculations','SSalesProcesses',NULL,NULL),
			(1807,'SCalculations','SRequirementsCards',NULL,NULL),
			(1809,'SCalculations','Accounts',NULL,NULL),
			(601,'ModComments','SCalculations',NULL,NULL),
			(1821,'SQuotes','SSalesProcesses',NULL,NULL),
			(1822,'SQuotes','SCalculations',NULL,NULL),
			(1824,'SQuotes','Accounts',NULL,NULL),
			(601,'ModComments','SQuotes',NULL,NULL),
			(1836,'SSingleOrders','SSalesProcesses',NULL,NULL),
			(1837,'SSingleOrders','SQuotes',NULL,NULL),
			(1839,'SSingleOrders','Accounts',NULL,NULL),
			(601,'ModComments','SSingleOrders',NULL,NULL),
			(1854,'SRecurringOrders','SSalesProcesses',NULL,NULL),
			(1855,'SRecurringOrders','SQuotes',NULL,NULL),
			(1857,'SRecurringOrders','Accounts',NULL,NULL),
			(601,'ModComments','SRecurringOrders',NULL,NULL),
			(1638,'PaymentsOut','Vendors',NULL,NULL),
			(1622,'PaymentsIn','Vendors',NULL,NULL),
			(601,'ModComments','Partners',NULL,NULL),
			(601,'ModComments','Competition',NULL,NULL),
			(1988,'OutsourcedProducts','SSalesProcesses',NULL,NULL),
			(1989,'Assets','SSalesProcesses',NULL,NULL),
			(1990,'OSSOutsourcedServices','SSalesProcesses',NULL,NULL),
			(1991,'OSSSoldServices','SSalesProcesses',NULL,NULL),
			(601,'ModComments','Vendors',NULL,NULL),
			(72,'Contacts','Partners',NULL,NULL),
			(72,'Contacts','Competition',NULL,NULL),
			(2038,'FBookkeeping','Accounts',NULL,NULL),
			(2043,'FInvoice','Accounts',NULL,NULL),
			(601,'ModComments','FInvoice',NULL,NULL),
			(2084,'IStorages','IStorages',NULL,NULL),
			(2125,'FInvoiceProforma','Accounts',NULL,NULL),
			(601,'ModComments','FInvoiceProforma',NULL,NULL),
			(2157,'IGDN','IStorages',NULL,NULL),
			(601,'ModComments','IGDN',NULL,NULL),
			(2164,'IIDN','IStorages',NULL,NULL),
			(2170,'IGRN','IStorages',NULL,NULL),
			(601,'ModComments','IGRN',NULL,NULL),
			(601,'ModComments','IIDN',NULL,NULL),
			(2172,'IGIN','IStorages',NULL,NULL),
			(601,'ModComments','IGIN',NULL,NULL),
			(2183,'IPreOrder','IStorages',NULL,NULL),
			(601,'ModComments','IPreOrder',NULL,NULL),
			(2191,'IGRN','Vendors',NULL,NULL),
			(2195,'IGDN','Accounts',NULL,NULL),
			(601,'ModComments','IStorages',NULL,NULL),
			(2206,'IPreOrder','Accounts',NULL,NULL),
			(601,'ModComments','FBookkeeping',NULL,NULL),
			(2225,'ISTDN','IStorages',NULL,NULL),
			(2227,'ISTDN','Accounts',NULL,NULL),
			(601,'ModComments','ISTDN',NULL,NULL),
			(601,'ModComments','ISTN',NULL,NULL),
			(2249,'ISTRN','IStorages',NULL,NULL),
			(2251,'ISTRN','Vendors',NULL,NULL),
			(601,'ModComments','ISTRN',NULL,NULL),
			(2259,'ISTDN','ISTN',NULL,NULL),
			(2260,'ISTRN','ISTN',NULL,NULL),
			(2261,'ISTDN','ISTRN',NULL,NULL),
			(2262,'ISTRN','ISTDN',NULL,NULL),
			(601,'ModComments','KnowledgeBase',NULL,NULL),
			(2273,'FCorectingInvoice','Accounts',NULL,NULL),
			(2304,'FCorectingInvoice','FInvoice',NULL,NULL),
			(601,'ModComments','FCorectingInvoice',NULL,NULL),
			(2308,'IGRNC','IStorages',NULL,NULL),
			(2310,'IGRNC','Vendors',NULL,NULL),
			(2318,'IGRNC','IGRN',NULL,NULL),
			(2320,'IGDNC','IStorages',NULL,NULL),
			(2324,'IGDNC','Accounts',NULL,NULL),
			(2331,'IGDNC','IGDN',NULL,NULL),
			(601,'ModComments','IGDNC',NULL,NULL),
			(601,'ModComments','IGRNC',NULL,NULL),
			(278,'Faq','Products',NULL,NULL),
			(2336,'Assets','FInvoice',NULL,NULL),
			(2337,'OSSSoldServices','FInvoice',NULL,NULL),
			(2345,'IGDN','SSingleOrders',NULL,NULL),
			(601,'ModComments','Campaigns',NULL,NULL),
			(2385,'SSalesProcesses','Campaigns',NULL,0),
			(2386,'Project','SSalesProcesses',NULL,0),
			(2404,'SSalesProcesses','SSalesProcesses',NULL,0),
			(601,'ModComments','CFixedAssets',NULL,0),
			(601,'ModComments','CInternalTickets',NULL,0),
			(601,'ModComments','FInvoiceCost',NULL,0),
			(2579,'SVendorEnquiries','SSalesProcesses',NULL,0),
			(2581,'SVendorEnquiries','Accounts',NULL,0),
			(2585,'SVendorEnquiries','Vendors',NULL,0),
			(2586,'SVendorEnquiries','SCalculations',NULL,0),
			(601,'ModComments','SVendorEnquiries',NULL,0),
			(2604,'Project','Project',NULL,0),
			(2627,'Assets','Contacts',NULL,0),
			(2628,'OSSSoldServices','Contacts',NULL,0),
			(2639,'LettersIn','LettersOut',NULL,0),
			(2642,'LettersOut','LettersIn',NULL,0),
			(2675,'MultiCompany','MultiCompany',NULL,0),
			(2677,'ProjectMilestone','ProjectMilestone',NULL,0),
			(601,'ModComments','DataSetRegister',NULL,0),
			(2693,'DataSetRegister','DataSetRegister',NULL,0),
			(2702,'ActivityRegister','ActivityRegister',NULL,0),
			(2704,'ActivityRegister','DataSetRegister',NULL,0),
			(601,'ModComments','ActivityRegister',NULL,0),
			(2716,'LocationRegister','LocationRegister',NULL,0),
			(601,'ModComments','LocationRegister',NULL,0),
			(2738,'IncidentRegister','LocationRegister',NULL,0),
			(2739,'IncidentRegister','DataSetRegister',NULL,0),
			(601,'ModComments','IncidentRegister',NULL,0),
			(2757,'AuditRegister','LocationRegister',NULL,0),
			(2758,'AuditRegister','DataSetRegister',NULL,0),
			(601,'ModComments','AuditRegister',NULL,0),
			(2769,'Competition','Competition',NULL,0),
			(2772,'OSSEmployees','MultiCompany',NULL,0),
			(2775,'SQuoteEnquiries','Campaigns',NULL,0),
			(1769,'SQuoteEnquiries','Leads',NULL,0),
			(2786,'FInvoice','SSalesProcesses',NULL,0),
			(2787,'FInvoice','Project',NULL,0),
			(2788,'Accounts','PriceBooks',NULL,0),
			(2791,'HelpDesk','HelpDesk',NULL,0),
			(2792,'SSingleOrders','IStorages',NULL,0),
			(2804,'PaymentsIn','SSingleOrders',NULL,0),
			(2805,'PaymentsIn','FInvoice',NULL,0),
			(2821,'Faq','Accounts',NULL,0),
			(601,'ModComments','ServiceContracts',NULL,0),
			(2887,'ApprovalsRegister','Approvals',NULL,0),
			(2888,'ApprovalsRegister','Contacts',NULL,0),
			(601,'ModComments','Locations',NULL,0),
			(2942,'Occurrences','Locations',NULL,0),
			(601,'ModComments','Occurrences',NULL,0),
			(2953,'SSingleOrders','Contacts',NULL,0),
			(2978,'SSingleOrders','SSingleOrders',NULL,0),
			(2979,'SQuotes','SQuotes',NULL,0),
			(2980,'SCalculations','SCalculations',NULL,0),
			(2988,'ProductCategory','ProductCategory',NULL,0),
			(3048,'BankAccounts','MultiCompany',NULL,0),
			(3067,'Queue','Contacts',NULL,0),
			(3067,'Queue','Accounts',NULL,0),
			(601,'ModComments','Queue',NULL,0),
			(3080,'Partners','Partners',NULL,0),
			(3082,'Passwords','MultiCompany',NULL,0),
			(3097,'HelpDesk','Contacts',NULL,0),
			(3099,'PaymentsIn','FInvoiceProforma',NULL,0),
			(3113,'SMSNotifier','Accounts',NULL,0),
			(3113,'SMSNotifier','Leads',NULL,0),
			(3113,'SMSNotifier','Vendors',NULL,0),
			(3113,'SMSNotifier','Partners',NULL,0),
			(3113,'SMSNotifier','Competition',NULL,0),
			(3113,'SMSNotifier','OSSEmployees',NULL,0),
			(3113,'SMSNotifier','Contacts',NULL,0),
			(3115,'SMSNotifier','SMSNotifier',NULL,0),
			(3146,'BankAccounts','Accounts',NULL,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_finvoice_status`(`finvoice_statusid`,`finvoice_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_AWAITING_REALIZATION',0,668,1),
			(2,'PLL_CANCELLED',0,771,2),
			(3,'PLL_ACCEPTED',0,772,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_finvoice_type`(`finvoice_typeid`,`finvoice_type`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_DOMESTIC_INVOICE',0,717,1),
			(2,'PLL_FOREIGN_INVOICE',0,718,2),
			(3,'PLL_IC_INVOICE',0,719,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_finvoicecost_paymentstatus`(`finvoicecost_paymentstatusid`,`finvoicecost_paymentstatus`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_AWAITING_PAYMENT',1,757,1),
			(2,'PLL_PARTIALLY_PAID',1,758,2),
			(3,'PLL_FULLY_PAID',1,759,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_finvoicecost_status`(`finvoicecost_statusid`,`finvoicecost_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_UNASSIGNED',1,749,1),
			(2,'PLL_AWAITING_REALIZATION',1,750,2),
			(3,'PLL_FOR_PROCESSING',1,751,3),
			(4,'PLL_IN_PROGRESSING',1,752,4),
			(5,'PLL_SUBMITTED_COMMENTS',1,753,5),
			(6,'PLL_FOR_APPROVAL',1,754,6),
			(7,'PLL_CANCELLED',1,755,7),
			(8,'PLL_ACCEPTED',1,756,8);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_finvoiceproforma_status`(`finvoiceproforma_statusid`,`finvoiceproforma_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'None',1,670,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_fixed_assets_fuel_type`(`fixed_assets_fuel_typeid`,`fixed_assets_fuel_type`,`presence`,`sortorderid`) values
			(1,'PLL_DIESEL',1,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_fixed_assets_status`(`fixed_assets_statusid`,`fixed_assets_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_UNAVAILABLE',1,728,1),
			(2,'PLL_AVAILABLE',1,729,2),
			(3,'PLL_DEMAGED',1,730,3),
			(4,'PLL_IN_USE',1,731,4),
			(5,'PLL_UNDER_REPAIR',1,732,5),
			(6,'PLL_PENDING_FOR_REPROCESSING',1,733,6),
			(7,'PLL_PENDING_FOR_SALE',1,734,7),
			(8,'PLL_REPROCESSED',1,735,8),
			(9,'PLL_SOLD',1,736,9);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_fixed_assets_type`(`fixed_assets_typeid`,`fixed_assets_type`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_DEVICE',1,723,1),
			(2,'PLL_MACHINE',1,724,2),
			(3,'PLL_VEHICLE',1,725,3),
			(4,'PLL_PROPERTY',1,726,4),
			(5,'PLL_INVENTORY',1,727,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_gender`(`genderid`,`gender`,`presence`,`sortorderid`) values
			(1,'PLL_WOMAN',1,1),
			(2,'PLL_MAN',1,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_glacct`(`glacctid`,`glacct`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'300-Sales-Software',1,51,0),
			(2,'301-Sales-Hardware',1,52,1),
			(3,'302-Rental-Income',1,53,2),
			(4,'303-Interest-Income',1,54,3),
			(5,'304-Sales-Software-Support',1,55,4),
			(6,'305-Sales Other',1,56,5),
			(7,'306-Internet Sales',1,57,6),
			(8,'307-Service-Hardware Labor',1,58,7),
			(9,'308-Sales-Books',1,59,8);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_group2role`(`groupid`,`roleid`) values
			(3,'H2'),
			(4,'H3');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_group2rs`(`groupid`,`roleandsubid`) values
			(3,'H3'),
			(4,'H3');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_groups`(`groupid`,`groupname`,`description`,`color`,`parentid`) values
			(2,'Team Selling','Group Related to Sales','#E6FAD8',0),
			(3,'Marketing Group','Group Related to Marketing Activities','#E6FAD8',0),
			(4,'Support Group','Group Related to providing Support to Customers','#E6FAD8',0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_holidaysentitlement_year`(`holidaysentitlement_yearid`,`holidaysentitlement_year`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'2020',1,576,1),
			(2,'2019',1,577,2),
			(3,'2018',1,578,3),
			(4,'2017',1,579,4),
			(5,'2016',1,580,5),
			(6,'2015',1,581,6),
			(7,'2014',1,582,7),
			(8,'2013',1,583,8),
			(9,'2012',1,584,9),
			(10,'2011',1,585,10),
			(11,'2010',1,586,11);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_hour_format`(`hour_formatid`,`hour_format`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'12',1,295,1),
			(2,'24',1,296,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ideasstatus`(`ideasstatusid`,`ideasstatus`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Draft',1,564,1),
			(2,'Proposition',1,565,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_igdn_status`(`igdn_statusid`,`igdn_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,784),
			(2,'PLL_IN_REALIZATION',2,1,785),
			(3,'PLL_OBJECTIONS',3,1,786),
			(4,'PLL_FOR_APPROVAL',4,1,787),
			(5,'PLL_CANCELLED',5,1,788),
			(6,'PLL_ACCEPTED',6,0,789);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_igdnc_status`(`igdnc_statusid`,`igdnc_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,778),
			(2,'PLL_IN_REALIZATION',2,1,779),
			(3,'PLL_OBJECTIONS',3,1,780),
			(4,'PLL_FOR_APPROVAL',4,1,781),
			(5,'PLL_CANCELLED',5,1,782),
			(6,'PLL_ACCEPTED',6,1,783);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_igin_status`(`igin_statusid`,`igin_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,790),
			(2,'PLL_IN_REALIZATION',2,1,791),
			(3,'PLL_OBJECTIONS',3,1,792),
			(4,'PLL_FOR_APPROVAL',4,1,793),
			(5,'PLL_CANCELLED',5,1,794),
			(6,'PLL_ACCEPTED',6,0,795);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_igrn_status`(`igrn_statusid`,`igrn_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,802),
			(2,'PLL_IN_REALIZATION',2,1,803),
			(3,'PLL_OBJECTIONS',3,1,804),
			(4,'PLL_FOR_APPROVAL',4,1,805),
			(5,'PLL_CANCELLED',5,1,806),
			(6,'PLL_ACCEPTED',6,0,807);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_igrnc_status`(`igrnc_statusid`,`igrnc_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,796),
			(2,'PLL_IN_REALIZATION',2,1,797),
			(3,'PLL_OBJECTIONS',3,1,798),
			(4,'PLL_FOR_APPROVAL',4,1,799),
			(5,'PLL_CANCELLED',5,1,800),
			(6,'PLL_ACCEPTED',6,1,801);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_iidn_status`(`iidn_statusid`,`iidn_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,808),
			(2,'PLL_IN_REALIZATION',2,1,809),
			(3,'PLL_OBJECTIONS',3,1,810),
			(4,'PLL_FOR_APPROVAL',4,1,811),
			(5,'PLL_CANCELLED',5,1,812),
			(6,'PLL_ACCEPTED',6,0,813);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_incidentregister_status`(`incidentregister_statusid`,`incidentregister_status`,`presence`,`sortorderid`) values
			(1,'PLL_DRAFT',1,1),
			(2,'PLL_WAITING_FOR_ACCEPTANCE',1,2),
			(3,'PLL_IN_REALIZATION',1,3),
			(4,'PLL_COMPLETED',1,4),
			(5,'PLL_CANCELLED',1,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_incidentregister_type`(`incidentregister_typeid`,`incidentregister_type`,`presence`,`sortorderid`) values
			(1,'PLL_INTERNAL',1,1),
			(2,'PLL_EXTERNAL',1,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_industry`(`industryid`,`industry`,`presence`,`picklist_valueid`,`sortorderid`) values
			(2,'Administration',1,61,1),
			(33,'Construction Industry',1,455,2),
			(34,'Education',1,456,3),
			(35,'Power Industry',1,457,4),
			(36,'Finance',1,458,5),
			(37,'Trade',1,459,6),
			(38,'Hotels and Restaurants',1,460,7),
			(39,'Health Care',1,461,8),
			(40,'Industry / Manufacturing',1,462,9),
			(41,'Uniformed Services',1,463,10),
			(42,'Transport & Logistics',1,464,11),
			(43,'Technologies',1,465,12);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_internal_tickets_status`(`internal_tickets_statusid`,`internal_tickets_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_UNASSIGNED',1,738,1),
			(2,'PLL_AWAITING_REALIZATION',1,739,2),
			(3,'PLL_FOR_PROCESSING',1,740,3),
			(4,'PLL_IN_PROGRESSING',1,741,4),
			(5,'PLL_SUBMITTED_COMMENTS',1,742,5),
			(6,'PLL_FOR_APPROVAL',1,743,6),
			(7,'PLL_CANCELLED',1,744,7),
			(8,'PLL_ACCEPTED',1,745,8);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_inventory_tandc`(`id`,`type`,`tandc`) values
			(1,'Inventory','');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ipreorder_status`(`ipreorder_statusid`,`ipreorder_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,814),
			(2,'PLL_IN_REALIZATION',2,1,815),
			(3,'PLL_OBJECTIONS',3,1,816),
			(4,'PLL_FOR_APPROVAL',4,1,817),
			(5,'PLL_CANCELLED',5,1,818),
			(6,'PLL_ACCEPTED',6,0,819);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_istdn_status`(`istdn_statusid`,`istdn_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,820),
			(2,'PLL_IN_REALIZATION',2,1,821),
			(3,'PLL_OBJECTIONS',3,1,822),
			(4,'PLL_FOR_APPROVAL',4,1,823),
			(5,'PLL_CANCELLED',5,1,824),
			(6,'PLL_ACCEPTED',6,0,825);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_istn_status`(`istn_statusid`,`istn_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,826),
			(2,'PLL_IN_REALIZATION',2,1,827),
			(3,'PLL_OBJECTIONS',3,1,828),
			(4,'PLL_FOR_APPROVAL',4,1,829),
			(5,'PLL_CANCELLED',5,1,830),
			(6,'PLL_ACCEPTED',6,0,831);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_istn_type`(`istn_typeid`,`istn_type`,`sortorderid`,`presence`) values
			(1,'PLL_RECEIVED',1,0),
			(2,'PLL_TRANSFER',2,0),
			(3,'PLL_DISPATCHED',3,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_istrn_status`(`istrn_statusid`,`istrn_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,832),
			(2,'PLL_IN_REALIZATION',2,1,833),
			(3,'PLL_OBJECTIONS',3,1,834),
			(4,'PLL_FOR_APPROVAL',4,1,835),
			(5,'PLL_CANCELLED',5,1,836),
			(6,'PLL_ACCEPTED',6,0,837);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_knowledgebase_status`(`knowledgebase_statusid`,`knowledgebase_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,838),
			(2,'PLL_IN_REALIZATION',2,1,839),
			(3,'PLL_OBJECTIONS',3,1,840),
			(4,'PLL_FOR_APPROVAL',4,1,841),
			(5,'PLL_CANCELLED',5,0,842),
			(6,'PLL_ACCEPTED',6,0,843),
			(7,'PLL_ARCHIVES',7,0,844);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_knowledgebase_view`(`knowledgebase_viewid`,`knowledgebase_view`,`sortorderid`,`presence`) values
			(1,'PLL_PAGE',1,0),
			(2,'PLL_PRESENTATION',2,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_language`(`id`,`name`,`prefix`,`lastupdated`,`sequence`,`isdefault`,`active`,`progress`) values
			(1,'English (United States)','en-US','2019-01-15 10:11:10',1,1,1,100);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_leads_relation`(`leads_relationid`,`leads_relation`,`sortorderid`,`presence`) values
			(1,'PLL_B2C',1,1),
			(2,'PLL_B2B',2,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_leadsource`(`leadsourceid`,`leadsource`,`presence`,`picklist_valueid`,`sortorderid`) values
			(2,'Cold Call',1,99,1),
			(4,'Self Generated',1,101,2),
			(9,'Conference',1,106,3),
			(10,'Trade Show',1,107,4),
			(11,'Web Site',1,108,5),
			(12,'Word of mouth',1,109,6),
			(13,'Other',1,110,8),
			(14,'Magento',1,948,7);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_leadstatus`(`leadstatusid`,`leadstatus`,`presence`,`picklist_valueid`,`sortorderid`,`color`) values
			(13,'PLL_TO_REALIZE',1,446,2,'E6FAD8'),
			(18,'PLL_CONTACTS_IN_THE_FUTURE',1,451,4,'E6FAD8'),
			(19,'PLL_LEAD_UNTAPPED',1,452,6,'E6FAD8'),
			(20,'PLL_LEAD_ACQUIRED',1,453,7,'E6FAD8'),
			(21,'PLL_PENDING',0,720,1,'E6FAD8'),
			(22,'PLL_IN_REALIZATION',1,721,3,'E6FAD8'),
			(23,'PLL_INCORRECT',1,722,5,'E6FAD8');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_legal_form`(`legal_formid`,`legal_form`,`sortorderid`,`presence`) values
			(1,'PLL_NATURAL_PERSON',1,0),
			(2,'PLL_COMPANY',2,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_lin_dimensions`(`lin_dimensionsid`,`lin_dimensions`,`sortorderid`,`presence`) values
			(1,'PLL_A',1,1),
			(2,'PLL_B',2,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_lin_status`(`lin_statusid`,`lin_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_IN_DEPARTMENT',1,1,845),
			(2,'PLL_REDIRECTED_TO_ANOTHER_DEPARTMENT',2,1,846),
			(3,'PLL_REDIRECTED_TO_ANOTHER_ADDRESSEE',3,1,910),
			(4,'PLL_DESTOYED_UPON_ADDRESSEES_REQUEST',4,1,911),
			(5,'PLL_DESTROYED_IN_ACCORDANCE_WITH_INTERNAL_PROCEDURES',5,1,912),
			(6,'PLL_RETURN_TO_SENDER',6,1,913);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_lin_type`(`lin_typeid`,`lin_type`,`presence`,`sortorderid`) values
			(1,'PLL_REGULAR_LETTER',1,1),
			(2,'PLL_REGISTERED_LETTER',1,2),
			(3,'PLL_REGULAR_PARCEL',1,3),
			(4,'PLL_LARGESIZE_PARCEL',1,4),
			(5,'PLL_DOCUMENT',1,5),
			(6,'PLL_RETURN',1,6),
			(7,'PLL_POSTAL_ADVICE',1,7);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_lin_type_doc`(`lin_type_docid`,`lin_type_doc`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_DEMAND_PAYMENT',1,593,1),
			(2,'PLL_BANK_STATEMENTS',1,594,2),
			(3,'PLL_ORDER',1,595,3),
			(4,'PLL_ENQUIRY',1,596,4),
			(5,'PLL_CONTRACT',1,597,5),
			(6,'PLL_RECLAMATION',1,598,6),
			(7,'PLL_ADVERTISEMENT',1,599,7),
			(8,'PLL_MESSAGE',1,600,8),
			(9,'PLL_RECEIPT',1,601,9),
			(10,'PLL_APPLICATION',1,602,10),
			(11,'PLL_OFFER',1,603,11),
			(12,'PLL_PERSONAL_LETTER',1,604,12),
			(13,'PLL_PROFORMA',1,605,13),
			(14,'PLL_CORRECTION',1,606,14),
			(15,'PLL_INVOICE',1,607,15);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_lin_type_ship`(`lin_type_shipid`,`lin_type_ship`,`sortorderid`,`presence`) values
			(1,'PLL_LOCAL_PICKUP',1,1),
			(2,'PLL_POST_OFFICE_PL',2,1),
			(3,'PLL_POST_OFFICE',3,1),
			(4,'PLL_COURIER',4,1),
			(5,'PLL_TELEX',5,1),
			(6,'PLL_EMAIL',6,1),
			(7,'PLL_POCZTEX',7,1),
			(8,'PLL_TNT',8,1),
			(9,'PLL_COURIER_POCZTEX',9,1),
			(10,'PLL_COURIER_7',10,1),
			(11,'PLL_COURIER_DPD',11,1),
			(12,'PLL_COURIER_DHL',12,1),
			(13,'PLL_COURIER_UPS',13,1),
			(14,'PLL_COURIER_GLS',14,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_links`(`linkid`,`tabid`,`linktype`,`linklabel`,`linkurl`,`linkicon`,`sequence`,`handler_path`,`handler_class`,`handler`,`params`) values
			(1,3,'DASHBOARDWIDGET','DW_SUMMATION_BY_MONTHS','index.php?module=FInvoice&view=ShowWidget&name=SummationByMonths',NULL,0,NULL,'FInvoice_SummationByMonthsModel_Dashboard',NULL,NULL),
			(2,3,'DASHBOARDWIDGET','DW_SUMMATION_BY_USER','index.php?module=FInvoice&view=ShowWidget&name=SummationByUser',NULL,NULL,NULL,'FInvoice_SummationByUserModel_Dashboard',NULL,NULL),
			(3,3,'DASHBOARDWIDGET','Notifications','index.php?module=Notification&view=ShowWidget&name=Notifications',NULL,3,NULL,NULL,NULL,NULL),
			(11,7,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(12,4,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(13,6,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(45,6,'DASHBOARDWIDGET','History','index.php?module=Accounts&view=ShowWidget&name=History','',1,NULL,NULL,NULL,NULL),
			(46,6,'DASHBOARDWIDGET','Upcoming Activities','index.php?module=Accounts&view=ShowWidget&name=CalendarActivities','',2,NULL,NULL,NULL,NULL),
			(47,6,'DASHBOARDWIDGET','Overdue Activities','index.php?module=Accounts&view=ShowWidget&name=OverdueActivities','',3,NULL,NULL,NULL,NULL),
			(48,4,'DASHBOARDWIDGET','History','index.php?module=Contacts&view=ShowWidget&name=History','',1,NULL,NULL,NULL,NULL),
			(49,4,'DASHBOARDWIDGET','Upcoming Activities','index.php?module=Contacts&view=ShowWidget&name=CalendarActivities','',2,NULL,NULL,NULL,NULL),
			(50,4,'DASHBOARDWIDGET','Overdue Activities','index.php?module=Contacts&view=ShowWidget&name=OverdueActivities','',3,NULL,NULL,NULL,NULL),
			(51,7,'DASHBOARDWIDGET','History','index.php?module=Leads&view=ShowWidget&name=History','',1,NULL,NULL,NULL,NULL),
			(52,7,'DASHBOARDWIDGET','Upcoming Activities','index.php?module=Leads&view=ShowWidget&name=CalendarActivities','',2,NULL,NULL,NULL,NULL),
			(53,7,'DASHBOARDWIDGET','Leads by Status','index.php?module=Leads&view=ShowWidget&name=LeadsByStatus','',4,NULL,NULL,NULL,NULL),
			(54,7,'DASHBOARDWIDGET','Leads by Source','index.php?module=Leads&view=ShowWidget&name=LeadsBySource','',5,NULL,NULL,NULL,NULL),
			(55,7,'DASHBOARDWIDGET','Leads by Industry','index.php?module=Leads&view=ShowWidget&name=LeadsByIndustry','',6,NULL,NULL,NULL,NULL),
			(56,7,'DASHBOARDWIDGET','Overdue Activities','index.php?module=Leads&view=ShowWidget&name=OverdueActivities','',7,NULL,NULL,NULL,NULL),
			(57,13,'DASHBOARDWIDGET','Tickets by Status','index.php?module=HelpDesk&view=ShowWidget&name=TicketsByStatus','',1,NULL,NULL,NULL,NULL),
			(58,13,'DASHBOARDWIDGET','Open Tickets','index.php?module=HelpDesk&view=ShowWidget&name=OpenTickets','',2,NULL,NULL,NULL,NULL),
			(59,3,'DASHBOARDWIDGET','History','index.php?module=Home&view=ShowWidget&name=History','',1,NULL,NULL,NULL,NULL),
			(60,3,'DASHBOARDWIDGET','Upcoming Activities','index.php?module=Home&view=ShowWidget&name=CalendarActivities','',2,NULL,'Vtiger_CalendarActivitiesModel_Dashboard',NULL,NULL),
			(66,3,'DASHBOARDWIDGET','Leads by Status','index.php?module=Leads&view=ShowWidget&name=LeadsByStatus','',10,NULL,NULL,NULL,NULL),
			(67,3,'DASHBOARDWIDGET','Leads by Source','index.php?module=Leads&view=ShowWidget&name=LeadsBySource','',11,NULL,NULL,NULL,NULL),
			(68,3,'DASHBOARDWIDGET','Leads by Industry','index.php?module=Leads&view=ShowWidget&name=LeadsByIndustry','',12,NULL,NULL,NULL,NULL),
			(69,3,'DASHBOARDWIDGET','Overdue Activities','index.php?module=Home&view=ShowWidget&name=OverdueActivities','',13,NULL,'Vtiger_OverdueActivitiesModel_Dashboard',NULL,NULL),
			(70,3,'DASHBOARDWIDGET','Tickets by Status','index.php?module=HelpDesk&view=ShowWidget&name=TicketsByStatus','',13,NULL,NULL,NULL,NULL),
			(71,3,'DASHBOARDWIDGET','Open Tickets','index.php?module=HelpDesk&view=ShowWidget&name=OpenTickets','',14,NULL,NULL,NULL,NULL),
			(72,13,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(73,15,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(102,3,'DASHBOARDWIDGET','Key Metrics','index.php?module=Home&view=ShowWidget&name=KeyMetrics','',15,NULL,NULL,NULL,NULL),
			(103,3,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',16,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(107,3,'DASHBOARDWIDGET','Notebook','index.php?module=Home&view=ShowWidget&name=Notebook','',18,NULL,NULL,NULL,NULL),
			(111,42,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(114,43,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(186,51,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(195,61,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(199,3,'DASHBOARDWIDGET','Mails List','index.php?module=Home&view=ShowWidget&name=MailsList','',NULL,NULL,NULL,NULL,NULL),
			(203,3,'DASHBOARDWIDGET','Delegated project tasks','index.php?module=Home&view=ShowWidget&name=AssignedUpcomingProjectsTasks',NULL,NULL,NULL,NULL,NULL,NULL),
			(204,3,'DASHBOARDWIDGET','Delegated (overdue) project tasks','index.php?module=Home&view=ShowWidget&name=AssignedOverdueProjectsTasks',NULL,NULL,NULL,NULL,NULL,NULL),
			(208,3,'DASHBOARDWIDGET','Employees Time Control','index.php?module=OSSTimeControl&view=ShowWidget&name=TimeControl','',12,NULL,NULL,NULL,NULL),
			(209,61,'DASHBOARDWIDGET','Employees Time Control','index.php?module=OSSTimeControl&view=ShowWidget&name=TimeControl','',1,NULL,NULL,NULL,NULL),
			(211,75,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',1,NULL,NULL,NULL,NULL),
			(213,3,'DASHBOARDWIDGET','LIST_OF_LAST_UPDATED_RECORD','index.php?module=Home&view=ShowWidget&name=ListUpdatedRecord','',1,NULL,NULL,NULL,NULL),
			(220,81,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(222,82,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(228,84,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(229,3,'DASHBOARDWIDGET','Calendar','index.php?module=Home&view=ShowWidget&name=Calendar','',0,NULL,'Vtiger_CalendarModel_Dashboard',NULL,NULL),
			(232,3,'DASHBOARDWIDGET','LBL_CREATED_BY_ME_BUT_NOT_MINE_ACTIVITIES','index.php?module=Home&view=ShowWidget&name=CreatedNotMineActivities','',0,NULL,'Vtiger_CreatedNotMineActivitiesModel_Dashboard',NULL,NULL),
			(235,85,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(237,86,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(239,87,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(241,88,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(243,89,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(245,90,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(247,91,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(249,92,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(251,93,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(252,18,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(254,95,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(255,99,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(256,100,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(257,101,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(258,98,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(259,102,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(260,103,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(261,97,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(262,94,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(263,104,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(264,105,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(265,106,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(266,96,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(267,3,'DASHBOARDWIDGET','LBL_PRODUCTS_SOLD_TO_RENEW','index.php?module=Home&view=ShowWidget&name=ProductsSoldToRenew','',0,NULL,NULL,NULL,NULL),
			(268,3,'DASHBOARDWIDGET','LBL_SOLD_SERVICES_TO_RENEW','index.php?module=Home&view=ShowWidget&name=ServicesSoldToRenew','',0,NULL,NULL,NULL,NULL),
			(269,107,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(270,108,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(271,109,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(272,4,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(273,6,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(274,7,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(275,13,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(276,54,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(277,61,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(278,3,'DASHBOARDWIDGET','LBL_ALL_TIME_CONTROL','index.php?module=OSSTimeControl&view=ShowWidget&name=AllTimeControl',NULL,0,NULL,NULL,NULL,NULL),
			(279,3,'DASHBOARDWIDGET','LBL_NEW_ACCOUNTS','index.php?module=Accounts&view=ShowWidget&name=NewAccounts','',0,NULL,NULL,NULL,NULL),
			(280,3,'DASHBOARDWIDGET','LBL_NEGLECTED_ACCOUNTS','index.php?module=Accounts&view=ShowWidget&name=NeglectedAccounts','',0,NULL,NULL,NULL,NULL),
			(282,26,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(283,3,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(284,6,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(285,4,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(286,7,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(287,13,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(288,54,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(289,61,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(290,3,'DASHBOARDWIDGET','Rss','index.php?module=Home&view=ShowWidget&name=Rss','',0,NULL,'Vtiger_RssModel_Dashboard',NULL,NULL),
			(291,6,'DASHBOARDWIDGET','Rss','index.php?module=Home&view=ShowWidget&name=Rss','',0,NULL,'Vtiger_RssModel_Dashboard',NULL,NULL),
			(292,4,'DASHBOARDWIDGET','Rss','index.php?module=Home&view=ShowWidget&name=Rss','',0,NULL,'Vtiger_RssModel_Dashboard',NULL,NULL),
			(293,7,'DASHBOARDWIDGET','Rss','index.php?module=Home&view=ShowWidget&name=Rss','',0,NULL,'Vtiger_RssModel_Dashboard',NULL,NULL),
			(294,13,'DASHBOARDWIDGET','Rss','index.php?module=Home&view=ShowWidget&name=Rss','',0,NULL,'Vtiger_RssModel_Dashboard',NULL,NULL),
			(295,54,'DASHBOARDWIDGET','Rss','index.php?module=Home&view=ShowWidget&name=Rss','',0,NULL,'Vtiger_RssModel_Dashboard',NULL,NULL),
			(296,61,'DASHBOARDWIDGET','Rss','index.php?module=Home&view=ShowWidget&name=Rss','',0,NULL,'Vtiger_RssModel_Dashboard',NULL,NULL),
			(297,3,'DASHBOARDWIDGET','LBL_CLOSED_TICKETS_BY_PRIORITY','index.php?module=HelpDesk&view=ShowWidget&name=ClosedTicketsByPriority','',0,NULL,NULL,NULL,NULL),
			(298,3,'DASHBOARDWIDGET','LBL_CLOSED_TICKETS_BY_USER','index.php?module=HelpDesk&view=ShowWidget&name=ClosedTicketsByUser','',0,NULL,NULL,NULL,NULL),
			(299,3,'DASHBOARDWIDGET','LBL_ACCOUNTS_BY_INDUSTRY','index.php?module=Accounts&view=ShowWidget&name=AccountsByIndustry','',0,NULL,NULL,NULL,NULL),
			(300,6,'DASHBOARDWIDGET','LBL_ACCOUNTS_BY_INDUSTRY','index.php?module=Accounts&view=ShowWidget&name=AccountsByIndustry','',0,NULL,NULL,NULL,NULL),
			(301,3,'DASHBOARDWIDGET','LBL_TOTAL_ESTIMATED_VALUE_BY_STATUS','index.php?module=SSalesProcesses&view=ShowWidget&name=EstimatedValueByStatus','',0,NULL,NULL,NULL,NULL),
			(302,86,'DASHBOARDWIDGET','LBL_TOTAL_ESTIMATED_VALUE_BY_STATUS','index.php?module=SSalesProcesses&view=ShowWidget&name=EstimatedValueByStatus','',0,NULL,NULL,NULL,NULL),
			(303,111,'DASHBOARDWIDGET','Notifications','index.php?module=Notification&view=ShowWidget&name=Notifications','',0,NULL,NULL,NULL,NULL),
			(304,3,'DASHBOARDWIDGET','LBL_NOTIFICATION_BY_SENDER','index.php?module=Notification&view=ShowWidget&name=NotificationsBySender','',0,NULL,NULL,NULL,NULL),
			(305,111,'DASHBOARDWIDGET','LBL_NOTIFICATION_BY_SENDER','index.php?module=Notification&view=ShowWidget&name=NotificationsBySender','',0,NULL,NULL,NULL,NULL),
			(306,3,'DASHBOARDWIDGET','LBL_NOTIFICATION_BY_RECIPIENT','index.php?module=Notification&view=ShowWidget&name=NotificationsByRecipient','',0,NULL,NULL,NULL,NULL),
			(307,111,'DASHBOARDWIDGET','LBL_NOTIFICATION_BY_RECIPIENT','index.php?module=Notification&view=ShowWidget&name=NotificationsByRecipient','',0,NULL,NULL,NULL,NULL),
			(308,3,'DASHBOARDWIDGET','LBL_EXPIRING_SOLD_PRODUCTS','index.php?module=Assets&view=ShowWidget&name=ExpiringSoldProducts','',0,NULL,NULL,NULL,NULL),
			(309,113,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(310,114,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(311,115,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(312,117,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(313,86,'DASHBOARDWIDGET','DW_TEAMS_ESTIMATED_SALES','index.php?module=SSalesProcesses&view=ShowWidget&name=TeamsEstimatedSales','',0,NULL,NULL,NULL,NULL),
			(314,86,'DASHBOARDWIDGET','DW_ACTUAL_SALES_OF_TEAM','index.php?module=SSalesProcesses&view=ShowWidget&name=ActualSalesOfTeam','',0,NULL,NULL,NULL,NULL),
			(315,121,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(316,122,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(317,123,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(318,124,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(319,125,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(320,3,'DASHBOARDWIDGET','Multifilter','index.php?module=Home&view=ShowWidget&name=Multifilter','',25,NULL,'Vtiger_MultifilterModel_Dashboard',NULL,NULL),
			(321,51,'DASHBOARDWIDGET','Employees Time Control','index.php?module=OSSTimeControl&view=ShowWidget&name=TimeControl','',0,NULL,NULL,NULL,NULL),
			(322,51,'DASHBOARDWIDGET','LBL_ALL_TIME_CONTROL','index.php?module=OSSTimeControl&view=ShowWidget&name=AllTimeControl','',0,NULL,NULL,NULL,NULL),
			(323,51,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(324,51,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(325,18,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(326,18,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(327,92,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(328,92,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(329,93,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(330,93,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(331,86,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(332,86,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(333,43,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(334,43,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(335,34,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(336,34,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(337,26,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(338,26,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(339,94,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(340,94,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(341,42,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(342,42,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(343,41,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(344,41,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(345,85,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(346,85,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(347,87,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(348,87,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(349,88,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(350,88,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(351,89,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(352,89,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(353,90,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(354,90,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(355,91,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(356,91,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(357,95,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(358,95,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(359,117,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,NULL,'Vtiger_ChartFilterModel_Dashboard',NULL,NULL),
			(360,117,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,NULL,'Vtiger_MiniListModel_Dashboard',NULL,NULL),
			(361,3,'DASHBOARDWIDGET','LBL_UPCOMING_PROJECT_TASKS','index.php?module=ProjectTask&view=ShowWidget&name=UpcomingProjectTasks',NULL,26,NULL,NULL,NULL,NULL),
			(362,3,'DASHBOARDWIDGET','LBL_COMPLETED_PROJECT_TASKS','index.php?module=ProjectTask&view=ShowWidget&name=CompletedProjectTasks',NULL,NULL,NULL,NULL,NULL,NULL),
			(363,3,'DASHBOARDWIDGET','LBL_CREATED_BY_ME_BUT_NOT_MINE_OVERDUE_ACTIVITIES','index.php?module=Home&view=ShowWidget&name=CreatedNotMineOverdueActivities','',0,NULL,'Vtiger_CreatedNotMineActivitiesModel_Dashboard',NULL,NULL),
			(364,34,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(366,3,'DASHBOARDWIDGET','LBL_UPDATES','index.php?module=ModTracker&view=ShowWidget&name=Updates',NULL,NULL,NULL,NULL,NULL,NULL),
			(367,130,'DASHBOARDWIDGET','ChartFilter','index.php?module=Home&view=ShowWidget&name=ChartFilter','',0,'','Vtiger_ChartFilterModel_Dashboard','',NULL),
			(368,130,'DASHBOARDWIDGET','Mini List','index.php?module=Home&view=ShowWidget&name=MiniList','',0,'','Vtiger_MiniListModel_Dashboard','',NULL),
			(369,130,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(371,131,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL),
			(373,134,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,'','','',NULL),
			(374,3,'DASHBOARDWIDGET','Upcoming events','index.php?module=Home&view=ShowWidget&name=UpcomingEvents',NULL,NULL,NULL,'Vtiger_UpcomingEventsModel_Dashboard',NULL,NULL),
			(375,3,'DASHBOARDWIDGET','LBL_WORKING_TIME_COUNTER','index.php?module=OSSTimeControl&view=ShowWidget&name=TimeCounter',NULL,NULL,NULL,'OSSTimeControl_TimeCounterModel_Dashboard',NULL,NULL),
			(376,138,'DETAILVIEWWIDGET','DetailViewBlockCommentWidget','block://ModComments:modules/ModComments/ModComments.php','',0,NULL,NULL,NULL,NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_locationregister_status`(`locationregister_statusid`,`locationregister_status`,`presence`,`sortorderid`) values
			(1,'PLL_DRAFT',1,1),
			(2,'PLL_WAITING_FOR_ACCEPTANCE',1,2),
			(3,'PLL_IN_REALIZATION',1,3),
			(4,'PLL_COMPLETED',1,4),
			(5,'PLL_CANCELLED',1,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_login_method`(`login_methodid`,`login_method`,`presence`,`sortorderid`) values
			(1,'PLL_PASSWORD',1,1),
			(2,'PLL_LDAP',1,2),
			(3,'PLL_PASSWORD_2FA',1,3),
			(4,'PLL_LDAP_2FA',1,4);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_lout_dimensions`(`lout_dimensionsid`,`lout_dimensions`,`sortorderid`,`presence`) values
			(1,'A',1,1),
			(2,'B',2,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_lout_status`(`lout_statusid`,`lout_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_NEW',1,1,847),
			(2,'PLL_SETTLED',2,1,848);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_lout_type_doc`(`lout_type_docid`,`lout_type_doc`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_DEMAND_PAYMENT',1,608,1),
			(2,'PLL_BANK_STATEMENTS',1,609,2),
			(3,'PLL_ORDER',1,610,3),
			(4,'PLL_ENQUIRY',1,611,4),
			(5,'PLL_CONTRACT',1,612,5),
			(6,'PLL_RECLAMATION',1,613,6),
			(7,'PLL_ADVERTISEMENT',1,614,7),
			(8,'PLL_MESSAGE',1,615,8),
			(9,'PLL_RECEIPT',1,616,9),
			(10,'PLL_APPLICATION',1,617,10),
			(11,'PLL_OFFER',1,618,11),
			(12,'PLL_PERSONAL_LETTER',1,619,12),
			(13,'PLL_PROFORMA',1,620,13),
			(14,'PLL_CORRECTION',1,621,14),
			(15,'PLL_INVOICE',1,622,15);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_lout_type_ship`(`lout_type_shipid`,`lout_type_ship`,`sortorderid`,`presence`) values
			(1,'PLL_LOCAL_PICKUP',1,1),
			(2,'PLL_POST_OFFICE_PL',2,1),
			(3,'PLL_POST_OFFICE',3,1),
			(4,'PLL_COURIER',4,1),
			(5,'PLL_TELEX',5,1),
			(6,'PLL_EMAIL',6,1),
			(7,'PLL_POCZTEX',7,1),
			(8,'PLL_TNT',8,1),
			(9,'PLL_COURIER_POCZTEX',9,1),
			(10,'PLL_COURIER_7',10,1),
			(11,'PLL_COURIER_DPD',11,1),
			(12,'PLL_COURIER_DHL',12,1),
			(13,'PLL_COURIER_UPS',13,1),
			(14,'PLL_COURIER_GLS',14,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_manufacturer`(`manufacturerid`,`manufacturer`,`presence`,`picklist_valueid`,`sortorderid`) values
			(2,'AltvetPet Inc.',1,124,1),
			(3,'LexPon Inc.',1,125,2),
			(4,'MetBeat Corp',1,126,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_modentity_num`(`id`,`tabid`,`prefix`,`leading_zeros`,`postfix`,`start_id`,`cur_id`,`reset_sequence`,`cur_sequence`) values
			(1,7,'L',0,'',1,1,NULL,''),
			(2,6,'O',0,'',1,1,NULL,''),
			(3,26,'CAM',0,'',1,1,NULL,''),
			(4,4,'C',0,'',1,1,NULL,''),
			(5,13,'H',0,'',1,1,NULL,''),
			(6,14,'PRO',0,'',1,1,NULL,''),
			(7,18,'V',0,'',1,1,NULL,''),
			(8,19,'PB',0,'',1,1,NULL,''),
			(9,15,'FAQ',0,'',1,1,NULL,''),
			(10,8,'DOC',0,'',1,1,NULL,''),
			(11,34,'U',0,'',1,1,NULL,''),
			(12,35,'SER',0,'',1,1,NULL,''),
			(13,37,'A',0,'',1,1,NULL,''),
			(14,41,'PM',0,'',1,1,NULL,''),
			(15,42,'PT',0,'',1,1,NULL,''),
			(16,43,'PROJ',0,'',1,1,NULL,''),
			(17,51,'TC',0,'',1,1,NULL,''),
			(18,54,'M_',0,'',1,1,NULL,''),
			(19,57,'UO',0,'',1,1,NULL,''),
			(20,58,'US',0,'',1,1,NULL,''),
			(21,59,'UP',0,'',1,1,NULL,''),
			(23,61,'P',0,'',1,2,NULL,''),
			(24,75,'ID',0,'',1,1,NULL,''),
			(25,78,'HE',0,'',1,1,NULL,''),
			(26,79,'',0,'',1,1,NULL,''),
			(27,80,'',0,'',1,1,NULL,''),
			(28,81,'LI',0,'',1,1,NULL,''),
			(29,82,'LI',0,'',1,1,NULL,''),
			(30,83,'NO',0,'',1,1,NULL,''),
			(31,84,'RES',0,'',1,1,NULL,''),
			(32,85,'S-QE',0,'',1,1,NULL,''),
			(33,86,'S-SP',0,'',1,1,NULL,''),
			(34,87,'S-RC',0,'',1,1,NULL,''),
			(35,88,'S-C',0,'',1,1,NULL,''),
			(36,89,'S-Q',0,'',1,1,NULL,''),
			(37,90,'S-SO',0,'',1,1,NULL,''),
			(38,91,'S-RO',0,'',1,1,NULL,''),
			(39,92,'PR',0,'',1,1,NULL,''),
			(40,93,'CMP',0,'',1,1,NULL,''),
			(41,94,'F-B',0,'',1,1,NULL,''),
			(42,98,'I-GRN',0,'',1,1,NULL,''),
			(43,99,'F-IP',0,'',1,1,NULL,''),
			(44,100,'I-GDN',0,'',1,1,NULL,''),
			(45,97,'I-S',0,'',1,1,NULL,''),
			(46,101,'I-IDN',0,'',1,1,NULL,''),
			(47,102,'I-GIN',0,'',1,1,NULL,''),
			(48,103,'I-PO',0,'',1,1,NULL,''),
			(49,95,'F-I',0,'',1,1,NULL,''),
			(50,96,'KB',0,'',1,1,NULL,''),
			(51,104,'I-TD',0,'',1,1,NULL,''),
			(52,105,'I-SN',0,'',1,1,NULL,''),
			(53,106,'I-TR',0,'',1,1,NULL,''),
			(54,107,'F-CI',0,'',1,1,NULL,''),
			(55,108,'I-IGRNC',0,'',1,1,NULL,''),
			(56,109,'I-IGDNC',0,'',1,1,NULL,''),
			(57,111,'NT',0,'',1,1,NULL,''),
			(58,112,'N',0,'',1,29,NULL,''),
			(59,113,'FA',0,'',1,1,NULL,''),
			(60,114,'IT',0,'',1,1,NULL,''),
			(61,115,'FC',0,'',1,1,NULL,''),
			(62,116,'ML',0,'',1,1,NULL,''),
			(63,117,'S-VE',0,'',1,1,NULL,''),
			(65,119,'MC',0,'',1,2,NULL,''),
			(66,121,'DSR',0,'',1,1,NULL,''),
			(67,122,'AR',0,'',1,1,NULL,''),
			(68,123,'LR',0,'',1,1,NULL,''),
			(69,124,'IR',0,'',1,1,NULL,''),
			(70,125,'N',0,'',1,1,NULL,''),
			(71,127,'N',0,'',2,2,'',''),
			(72,128,'N',0,'',2,2,'',''),
			(73,130,'LOC',0,'',1,1,'',''),
			(74,131,'N',0,'',1,1,'',''),
			(75,132,'PC',0,'',1,1,NULL,NULL),
			(76,133,'BA',0,'',1,1,'',''),
			(77,134,'Q',0,'',1,1,'',''),
			(78,135,'P',0,'',1,1,'',''),
			(79,136,'ST',0,'',1,1,'',''),
			(81,138,'N',0,'',1,1,NULL,'');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_modtracker_tabs`(`tabid`,`visible`) values
			(2,1),
			(4,1),
			(6,1),
			(7,1),
			(8,1),
			(9,1),
			(10,1),
			(13,1),
			(14,1),
			(15,1),
			(16,1),
			(18,1),
			(19,1),
			(20,1),
			(21,1),
			(22,1),
			(23,1),
			(26,1),
			(28,1),
			(33,1),
			(34,1),
			(35,1),
			(37,1),
			(40,1),
			(41,1),
			(42,1),
			(43,1),
			(45,1),
			(51,1),
			(54,0),
			(60,1),
			(70,1),
			(75,1),
			(76,1),
			(77,1),
			(79,1),
			(80,1),
			(81,1),
			(82,1),
			(83,1),
			(85,1),
			(86,1),
			(87,1),
			(88,1),
			(89,1),
			(90,1),
			(91,1),
			(92,1),
			(93,1),
			(94,1),
			(95,1),
			(96,1),
			(97,1),
			(98,1),
			(99,1),
			(100,1),
			(101,1),
			(102,1),
			(103,1),
			(104,1),
			(105,1),
			(106,1),
			(107,1),
			(108,1),
			(109,1),
			(113,1),
			(114,1),
			(115,1),
			(116,1),
			(117,1),
			(121,1),
			(122,1),
			(123,1),
			(124,1),
			(125,1),
			(130,1),
			(134,1),
			(135,1),
			(136,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_mulcomp_status`(`mulcomp_statusid`,`mulcomp_status`,`presence`,`sortorderid`) values
			(1,'PLL_ACTIVE',1,1),
			(2,'PLL_INACTIVE',1,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_no_of_currency_decimals`(`no_of_currency_decimalsid`,`no_of_currency_decimals`,`sortorderid`,`presence`) values
			(1,'0',0,1),
			(2,'1',1,1),
			(3,'2',2,1),
			(4,'3',3,1),
			(5,'4',4,1),
			(6,'5',5,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_notification_status`(`notification_statusid`,`notification_status`,`sortorderid`,`presence`) values
			(1,'PLL_UNREAD',1,0),
			(2,'PLL_READ',2,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_notification_type`(`notification_typeid`,`notification_type`,`presence`,`picklist_valueid`,`sortorderid`,`color`) values
			(1,'PLL_USERS',0,703,1,'1baee2'),
			(2,'PLL_SYSTEM',0,704,2,'FF9800');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_occurrences_rating`(`occurrences_ratingid`,`occurrences_rating`,`presence`,`sortorderid`) values
			(1,'1',1,1),
			(2,'2',1,2),
			(3,'3',1,3),
			(4,'4',1,4),
			(5,'5',1,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_occurrences_status`(`occurrences_statusid`,`occurrences_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_ACTIVE',1,940,1),
			(2,'PLL_CANCELLED',0,941,2),
			(3,'PLL_ARCHIVED',0,942,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_occurrences_type`(`occurrences_typeid`,`occurrences_type`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_TRAINING_OPEN',1,943,1),
			(2,'PLL_TRAINING_CLOSED',1,944,2),
			(3,'PLL_CONFERENCE',1,945,3),
			(4,'PLL_WORKSHOPS',1,946,4),
			(5,'PLL_WEBINARS',1,947,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_oproductstatus`(`oproductstatusid`,`oproductstatus`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Active',1,419,1),
			(2,'Inactive',1,420,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_org_share_action2tab`(`share_action_id`,`tabid`) values
			(0,4),
			(0,6),
			(0,7),
			(0,8),
			(0,9),
			(0,13),
			(0,14),
			(0,15),
			(0,18),
			(0,19),
			(0,26),
			(0,34),
			(0,35),
			(0,37),
			(0,40),
			(0,41),
			(0,42),
			(0,43),
			(0,45),
			(0,51),
			(0,54),
			(0,57),
			(0,58),
			(0,59),
			(0,61),
			(0,74),
			(0,75),
			(0,78),
			(0,79),
			(0,80),
			(0,81),
			(0,82),
			(0,83),
			(0,84),
			(0,85),
			(0,86),
			(0,87),
			(0,88),
			(0,89),
			(0,90),
			(0,91),
			(0,92),
			(0,93),
			(0,94),
			(0,95),
			(0,96),
			(0,97),
			(0,98),
			(0,99),
			(0,100),
			(0,101),
			(0,102),
			(0,103),
			(0,104),
			(0,105),
			(0,106),
			(0,107),
			(0,108),
			(0,109),
			(0,111),
			(0,112),
			(0,113),
			(0,114),
			(0,115),
			(0,116),
			(0,117),
			(0,119),
			(0,121),
			(0,122),
			(0,123),
			(0,124),
			(0,125),
			(0,127),
			(0,128),
			(0,130),
			(0,131),
			(0,132),
			(0,133),
			(0,134),
			(0,135),
			(0,136),
			(0,138),
			(1,4),
			(1,6),
			(1,7),
			(1,8),
			(1,9),
			(1,13),
			(1,14),
			(1,15),
			(1,18),
			(1,19),
			(1,26),
			(1,34),
			(1,35),
			(1,37),
			(1,40),
			(1,41),
			(1,42),
			(1,43),
			(1,45),
			(1,51),
			(1,54),
			(1,57),
			(1,58),
			(1,59),
			(1,61),
			(1,74),
			(1,75),
			(1,78),
			(1,79),
			(1,80),
			(1,81),
			(1,82),
			(1,83),
			(1,84),
			(1,85),
			(1,86),
			(1,87),
			(1,88),
			(1,89),
			(1,90),
			(1,91),
			(1,92),
			(1,93),
			(1,94),
			(1,95),
			(1,96),
			(1,97),
			(1,98),
			(1,99),
			(1,100),
			(1,101),
			(1,102),
			(1,103),
			(1,104),
			(1,105),
			(1,106),
			(1,107),
			(1,108),
			(1,109),
			(1,111),
			(1,112),
			(1,113),
			(1,114),
			(1,115),
			(1,116),
			(1,117),
			(1,119),
			(1,121),
			(1,122),
			(1,123),
			(1,124),
			(1,125),
			(1,127),
			(1,128),
			(1,130),
			(1,131),
			(1,132),
			(1,133),
			(1,134),
			(1,135),
			(1,136),
			(1,138),
			(2,4),
			(2,6),
			(2,7),
			(2,8),
			(2,9),
			(2,13),
			(2,14),
			(2,15),
			(2,18),
			(2,19),
			(2,26),
			(2,34),
			(2,35),
			(2,37),
			(2,40),
			(2,41),
			(2,42),
			(2,43),
			(2,45),
			(2,51),
			(2,54),
			(2,57),
			(2,58),
			(2,59),
			(2,61),
			(2,74),
			(2,75),
			(2,78),
			(2,79),
			(2,80),
			(2,81),
			(2,82),
			(2,83),
			(2,84),
			(2,85),
			(2,86),
			(2,87),
			(2,88),
			(2,89),
			(2,90),
			(2,91),
			(2,92),
			(2,93),
			(2,94),
			(2,95),
			(2,96),
			(2,97),
			(2,98),
			(2,99),
			(2,100),
			(2,101),
			(2,102),
			(2,103),
			(2,104),
			(2,105),
			(2,106),
			(2,107),
			(2,108),
			(2,109),
			(2,111),
			(2,112),
			(2,113),
			(2,114),
			(2,115),
			(2,116),
			(2,117),
			(2,119),
			(2,121),
			(2,122),
			(2,123),
			(2,124),
			(2,125),
			(2,127),
			(2,128),
			(2,130),
			(2,131),
			(2,132),
			(2,133),
			(2,134),
			(2,135),
			(2,136),
			(2,138),
			(3,4),
			(3,6),
			(3,7),
			(3,8),
			(3,9),
			(3,13),
			(3,14),
			(3,15),
			(3,18),
			(3,19),
			(3,26),
			(3,34),
			(3,35),
			(3,37),
			(3,40),
			(3,41),
			(3,42),
			(3,43),
			(3,45),
			(3,51),
			(3,54),
			(3,57),
			(3,58),
			(3,59),
			(3,61),
			(3,74),
			(3,75),
			(3,78),
			(3,79),
			(3,80),
			(3,81),
			(3,82),
			(3,83),
			(3,84),
			(3,85),
			(3,86),
			(3,87),
			(3,88),
			(3,89),
			(3,90),
			(3,91),
			(3,92),
			(3,93),
			(3,94),
			(3,95),
			(3,96),
			(3,97),
			(3,98),
			(3,99),
			(3,100),
			(3,101),
			(3,102),
			(3,103),
			(3,104),
			(3,105),
			(3,106),
			(3,107),
			(3,108),
			(3,109),
			(3,111),
			(3,112),
			(3,113),
			(3,114),
			(3,115),
			(3,116),
			(3,117),
			(3,119),
			(3,121),
			(3,122),
			(3,123),
			(3,124),
			(3,125),
			(3,127),
			(3,128),
			(3,130),
			(3,131),
			(3,132),
			(3,133),
			(3,134),
			(3,135),
			(3,136),
			(3,138);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_org_share_action_mapping`(`share_action_id`,`share_action_name`) values
			(0,'Public: Read Only'),
			(1,'Public: Read, Create/Edit'),
			(2,'Public: Read, Create/Edit, Delete'),
			(3,'Private'),
			(4,'Hide Details'),
			(5,'Hide Details and Add Events'),
			(6,'Show Details'),
			(7,'Show Details and Add Events');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ossdc_status`(`ossdc_statusid`,`ossdc_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'None',1,401,1),
			(2,'Checked',1,402,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ossemployees`(`ossemployeesid`,`ossemployees_no`,`parentid`,`employee_status`,`name`,`last_name`,`pesel`,`id_card`,`employee_education`,`birth_date`,`business_phone`,`private_phone`,`business_mail`,`private_mail`,`street`,`code`,`city`,`state`,`country`,`ship_street`,`ship_code`,`ship_city`,`ship_state`,`ship_country`,`dav_status`,`sum_time`,`secondary_phone`,`position`,`rbh`,`business_phone_extra`,`private_phone_extra`,`secondary_phone_extra`,`multicompanyid`) values
			(2,'P1',0,'Employee','Administrator','Administrator','','','',NULL,'','','help@yetiforce.com','','','','','','','','','','','',1,0.00,'','',0.00000000,'','','',1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ossemployeescf`(`ossemployeesid`) values
			(2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_osservicesstatus`(`osservicesstatusid`,`osservicesstatus`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Active',1,403,1),
			(2,'Inactive',1,404,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ossmailview_sendtype`(`ossmailview_sendtypeid`,`ossmailview_sendtype`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Sent',1,388,1),
			(2,'Received',1,389,2),
			(3,'Internal',1,700,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_osssoldservices_renew`(`osssoldservices_renewid`,`osssoldservices_renew`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_PLANNED',0,675,1),
			(2,'PLL_WAITING_FOR_RENEWAL',0,676,2),
			(3,'PLL_RENEWED_VERIFICATION',0,677,3),
			(4,'PLL_NOT_RENEWED_VERIFICATION',0,678,4),
			(5,'PLL_RENEWED',0,679,6),
			(6,'PLL_NOT_RENEWED',0,680,7),
			(7,'PLL_NOT_APPLICABLE',0,681,8),
			(8,'PLL_NOT_APPLICABLE_VERIFICATION',0,701,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_osstimecontrol_status`(`osstimecontrol_statusid`,`osstimecontrol_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(8,'Accepted',1,0,849),
			(13,'To approval',2,1,850);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_password`(`type`,`val`) values
			('min_length','8'),
			('max_length','32'),
			('big_letters','true'),
			('small_letters','true'),
			('numbers','true'),
			('special','false'),
			('change_time','0'),
			('lock_time','5'),
			('pwned','false'),
			('pwned_time','7');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_payment_methods`(`payment_methodsid`,`payment_methods`,`presence`,`sortorderid`) values
			(1,'PLL_TRANSFER',1,1),
			(2,'PLL_CASH',1,2),
			(3,'PLL_CASH_ON_DELIVERY',1,3),
			(4,'PLL_WIRE_TRANSFER',1,4),
			(5,'PLL_REDSYS',1,5),
			(6,'PLL_DOTPAY',1,6),
			(7,'PLL_PAYPAL',1,7),
			(8,'PLL_PAYPAL_EXPRESS',1,8),
			(9,'PLL_CHECK',1,9);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_payment_status`(`payment_statusid`,`payment_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_NOT_PAID',0,933,1),
			(2,'PLL_UNDERPAID',0,934,2),
			(3,'PLL_PAID',0,935,3),
			(4,'PLL_OVERPAID',0,936,4);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_payment_system`(`payment_systemid`,`payment_system`,`presence`,`sortorderid`) values
			(1,'PLL_REDSYS',1,1),
			(2,'PLL_DOTPAY',1,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_paymentsin_status`(`paymentsin_statusid`,`paymentsin_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_CREATED',1,587,1),
			(2,'PLL_DENIED',1,588,2),
			(3,'PLL_PAID',1,589,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_paymentsout_status`(`paymentsout_statusid`,`paymentsout_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Created',1,590,1),
			(2,'Denied',1,591,2),
			(3,'Paid',1,592,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_picklist`(`picklistid`,`name`) values
			(133,'accounts_available_taxes'),
			(96,'accounts_status'),
			(1,'accounttype'),
			(25,'activitystatus'),
			(94,'announcementstatus'),
			(135,'approvals_register_status'),
			(37,'assetstatus'),
			(91,'assets_renew'),
			(3,'campaignstatus'),
			(4,'campaigntype'),
			(106,'cmileage_logbook_status'),
			(70,'contactstatus'),
			(33,'contract_priority'),
			(32,'contract_status'),
			(34,'contract_type'),
			(49,'defaulteventstatus'),
			(66,'employee_education'),
			(65,'employee_status'),
			(7,'expectedresponse'),
			(9,'faqstatus'),
			(93,'fcorectinginvoice_status'),
			(105,'finvoicecost_paymentstatus'),
			(104,'finvoicecost_status'),
			(89,'finvoiceproforma_status'),
			(87,'finvoice_status'),
			(98,'finvoice_type'),
			(100,'fixed_assets_status'),
			(10,'glacct'),
			(74,'holidaysentitlement_year'),
			(71,'ideasstatus'),
			(108,'igdnc_status'),
			(109,'igdn_status'),
			(110,'igin_status'),
			(111,'igrnc_status'),
			(112,'igrn_status'),
			(113,'iidn_status'),
			(11,'industry'),
			(102,'internal_tickets_status'),
			(114,'ipreorder_status'),
			(115,'istdn_status'),
			(116,'istn_status'),
			(117,'istrn_status'),
			(118,'knowledgebase_status'),
			(13,'leadsource'),
			(14,'leadstatus'),
			(119,'lin_status'),
			(77,'lin_type_doc'),
			(120,'lout_status'),
			(78,'lout_type_doc'),
			(15,'manufacturer'),
			(95,'notification_type'),
			(136,'occurrences_status'),
			(137,'occurrences_type'),
			(64,'oproductstatus'),
			(59,'ossdc_status'),
			(60,'osservicesstatus'),
			(57,'ossmailview_sendtype'),
			(90,'osssoldservices_renew'),
			(121,'osstimecontrol_status'),
			(75,'paymentsin_status'),
			(76,'paymentsout_status'),
			(134,'payment_status'),
			(38,'projectmilestonetype'),
			(85,'projectmilestone_priority'),
			(131,'projectmilestone_status'),
			(44,'projectpriority'),
			(42,'projectstatus'),
			(40,'projecttaskpriority'),
			(46,'projecttaskstatus'),
			(39,'projecttasktype'),
			(43,'projecttype'),
			(138,'queue_status'),
			(122,'reservations_status'),
			(22,'salutationtype'),
			(123,'scalculations_status'),
			(35,'service_usageunit'),
			(139,'smsnotifier_status'),
			(124,'squoteenquiries_status'),
			(125,'squotes_status'),
			(126,'srecurringorders_status'),
			(127,'srequirementscards_status'),
			(128,'ssalesprocesses_status'),
			(129,'ssingleorders_status'),
			(63,'ssservicesstatus'),
			(130,'storage_status'),
			(141,'svendorenquiries_status'),
			(24,'taskpriority'),
			(27,'ticketpriorities'),
			(28,'ticketseverities'),
			(29,'ticketstatus'),
			(31,'tracking_unit'),
			(30,'usageunit'),
			(68,'verification');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_picklistvalues_seq`(`id`) values
			(970);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_profile`(`profileid`,`profilename`,`description`,`directly_related_to_role`) values
			(1,'Administrator','Admin Profile',0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_profile2field`(`profileid`,`tabid`,`fieldid`,`visible`,`readonly`) values
			(1,6,1,0,0),
			(1,6,2,0,0),
			(1,6,3,0,0),
			(1,6,4,0,0),
			(1,6,5,0,0),
			(1,6,7,0,0),
			(1,6,8,0,0),
			(1,6,9,0,0),
			(1,6,10,0,0),
			(1,6,11,0,0),
			(1,6,14,0,0),
			(1,6,15,0,0),
			(1,6,16,0,0),
			(1,6,17,0,0),
			(1,6,18,0,0),
			(1,6,20,0,0),
			(1,6,21,0,1),
			(1,6,22,0,1),
			(1,6,23,0,0),
			(1,6,36,0,0),
			(1,7,39,0,0),
			(1,7,40,0,0),
			(1,7,41,0,0),
			(1,7,42,0,0),
			(1,7,43,0,0),
			(1,7,44,0,0),
			(1,7,46,0,0),
			(1,7,47,0,0),
			(1,7,48,0,0),
			(1,7,49,0,0),
			(1,7,50,0,0),
			(1,7,51,0,0),
			(1,7,53,0,0),
			(1,7,54,0,0),
			(1,7,55,0,0),
			(1,7,56,0,1),
			(1,7,57,0,1),
			(1,7,58,0,0),
			(1,7,65,0,0),
			(1,4,66,0,0),
			(1,4,67,0,0),
			(1,4,68,0,0),
			(1,4,69,0,0),
			(1,4,70,0,0),
			(1,4,71,0,0),
			(1,4,72,0,0),
			(1,4,74,0,0),
			(1,4,79,0,0),
			(1,4,80,0,0),
			(1,4,81,0,0),
			(1,4,85,0,0),
			(1,4,86,0,0),
			(1,4,87,0,0),
			(1,4,90,0,1),
			(1,4,91,0,1),
			(1,4,92,0,0),
			(1,4,93,0,0),
			(1,4,108,0,0),
			(1,4,109,0,0),
			(1,26,126,0,0),
			(1,26,127,0,0),
			(1,26,128,0,0),
			(1,26,129,0,0),
			(1,26,130,0,0),
			(1,26,131,0,0),
			(1,26,132,0,0),
			(1,26,133,0,0),
			(1,26,134,0,0),
			(1,26,135,0,0),
			(1,26,136,0,0),
			(1,26,137,0,1),
			(1,26,138,0,1),
			(1,26,139,0,0),
			(1,26,140,0,0),
			(1,26,141,0,0),
			(1,26,142,0,0),
			(1,26,143,0,0),
			(1,26,144,0,0),
			(1,26,145,0,0),
			(1,26,146,0,0),
			(1,26,147,0,0),
			(1,26,148,0,0),
			(1,26,149,0,0),
			(1,26,150,0,0),
			(1,13,155,0,0),
			(1,13,156,0,0),
			(1,13,157,0,0),
			(1,13,158,0,0),
			(1,13,159,0,0),
			(1,13,160,0,0),
			(1,13,161,0,0),
			(1,13,162,0,0),
			(1,13,163,0,0),
			(1,13,166,0,1),
			(1,13,167,0,1),
			(1,13,168,0,0),
			(1,13,169,0,0),
			(1,13,170,0,0),
			(1,13,171,0,0),
			(1,14,173,0,0),
			(1,14,174,0,0),
			(1,14,175,0,0),
			(1,14,176,0,0),
			(1,14,177,0,0),
			(1,14,178,0,0),
			(1,14,179,0,0),
			(1,14,180,0,0),
			(1,14,181,0,0),
			(1,14,182,0,0),
			(1,14,183,0,0),
			(1,14,184,0,0),
			(1,14,185,0,0),
			(1,14,186,0,0),
			(1,14,187,0,0),
			(1,14,188,0,0),
			(1,14,189,0,0),
			(1,14,190,0,1),
			(1,14,191,0,1),
			(1,14,192,0,0),
			(1,14,193,0,0),
			(1,14,194,0,0),
			(1,14,196,0,0),
			(1,14,197,0,0),
			(1,14,198,0,0),
			(1,14,199,0,0),
			(1,14,200,0,0),
			(1,14,201,0,0),
			(1,14,202,0,0),
			(1,14,203,0,0),
			(1,8,204,0,0),
			(1,8,205,0,1),
			(1,8,206,0,1),
			(1,8,207,0,0),
			(1,8,208,0,0),
			(1,8,209,0,0),
			(1,8,210,0,1),
			(1,8,211,0,1),
			(1,8,212,0,0),
			(1,8,213,0,0),
			(1,8,214,0,0),
			(1,8,215,0,1),
			(1,8,216,0,0),
			(1,8,217,0,0),
			(1,8,218,0,0),
			(1,9,231,0,0),
			(1,9,232,0,0),
			(1,9,233,0,0),
			(1,9,234,0,0),
			(1,9,235,0,0),
			(1,9,236,0,0),
			(1,9,237,0,0),
			(1,9,238,0,0),
			(1,9,239,0,0),
			(1,9,241,0,0),
			(1,9,242,0,0),
			(1,9,243,0,1),
			(1,9,244,0,1),
			(1,9,245,0,0),
			(1,9,246,0,0),
			(1,9,247,0,0),
			(1,9,248,0,0),
			(1,9,249,0,0),
			(1,9,250,0,0),
			(1,9,251,0,0),
			(1,9,253,0,0),
			(1,9,254,0,0),
			(1,15,278,0,0),
			(1,15,279,0,0),
			(1,15,281,0,0),
			(1,15,285,0,1),
			(1,15,286,0,1),
			(1,15,287,0,0),
			(1,18,288,0,0),
			(1,18,289,0,0),
			(1,18,290,0,0),
			(1,18,291,0,0),
			(1,18,292,0,0),
			(1,18,293,0,0),
			(1,18,294,0,0),
			(1,18,295,0,1),
			(1,18,296,0,1),
			(1,18,297,0,0),
			(1,18,304,0,0),
			(1,19,305,0,0),
			(1,19,306,0,0),
			(1,19,307,0,0),
			(1,19,308,0,1),
			(1,19,309,0,1),
			(1,19,310,0,0),
			(1,19,311,0,0),
			(1,19,312,0,0),
			(1,29,474,0,0),
			(1,29,475,0,0),
			(1,29,476,1,0),
			(1,29,477,1,0),
			(1,29,478,0,0),
			(1,29,479,0,0),
			(1,29,480,0,0),
			(1,29,481,0,0),
			(1,29,482,0,0),
			(1,29,483,0,0),
			(1,29,485,0,0),
			(1,29,487,0,0),
			(1,29,492,0,0),
			(1,29,498,0,0),
			(1,29,500,0,0),
			(1,29,501,0,0),
			(1,29,506,0,1),
			(1,29,507,0,0),
			(1,29,508,0,0),
			(1,29,509,0,0),
			(1,29,510,0,0),
			(1,29,511,0,0),
			(1,29,512,0,0),
			(1,29,513,0,0),
			(1,29,514,0,0),
			(1,29,515,0,0),
			(1,29,516,0,0),
			(1,29,517,0,0),
			(1,29,540,0,0),
			(1,34,541,0,0),
			(1,34,542,0,1),
			(1,34,543,0,1),
			(1,34,544,0,0),
			(1,34,545,0,1),
			(1,34,546,0,0),
			(1,34,547,0,0),
			(1,34,548,0,0),
			(1,34,549,0,0),
			(1,34,550,0,0),
			(1,34,551,0,0),
			(1,34,552,0,1),
			(1,34,553,0,1),
			(1,34,554,0,0),
			(1,34,555,0,0),
			(1,34,556,0,0),
			(1,34,557,0,1),
			(1,34,558,0,0),
			(1,34,559,0,0),
			(1,35,560,0,0),
			(1,35,561,0,0),
			(1,35,562,0,0),
			(1,35,563,0,0),
			(1,35,564,0,0),
			(1,35,565,0,0),
			(1,35,566,0,0),
			(1,35,567,0,0),
			(1,35,568,0,1),
			(1,35,569,0,1),
			(1,35,570,0,0),
			(1,35,571,0,0),
			(1,35,572,0,0),
			(1,35,573,0,0),
			(1,35,574,0,0),
			(1,35,575,0,0),
			(1,35,577,0,0),
			(1,35,578,0,0),
			(1,37,579,0,0),
			(1,37,580,0,0),
			(1,37,581,0,0),
			(1,37,582,0,0),
			(1,37,583,0,0),
			(1,37,584,0,0),
			(1,37,589,0,0),
			(1,37,590,0,0),
			(1,37,593,0,1),
			(1,37,594,0,1),
			(1,37,595,0,0),
			(1,40,597,0,0),
			(1,40,598,0,0),
			(1,40,599,0,1),
			(1,40,600,0,1),
			(1,40,601,0,0),
			(1,40,602,0,1),
			(1,40,603,0,0),
			(1,41,604,0,0),
			(1,41,605,0,0),
			(1,41,606,0,0),
			(1,41,607,0,0),
			(1,41,608,0,0),
			(1,41,609,0,0),
			(1,41,610,0,1),
			(1,41,611,0,1),
			(1,41,612,0,0),
			(1,41,613,0,0),
			(1,42,614,0,0),
			(1,42,615,0,0),
			(1,42,616,0,0),
			(1,42,617,0,0),
			(1,42,618,0,0),
			(1,42,619,0,0),
			(1,42,620,0,0),
			(1,42,621,0,0),
			(1,42,623,0,0),
			(1,42,624,0,0),
			(1,42,625,0,1),
			(1,42,626,0,1),
			(1,42,627,0,0),
			(1,42,628,0,0),
			(1,43,629,0,0),
			(1,43,630,0,0),
			(1,43,631,0,0),
			(1,43,632,0,0),
			(1,43,633,0,0),
			(1,43,634,0,0),
			(1,43,635,0,0),
			(1,43,636,0,0),
			(1,43,637,0,0),
			(1,43,638,0,0),
			(1,43,639,0,0),
			(1,43,640,0,0),
			(1,43,641,0,0),
			(1,43,642,0,1),
			(1,43,643,0,1),
			(1,43,644,0,0),
			(1,43,645,0,0),
			(1,45,646,0,0),
			(1,45,647,0,1),
			(1,45,648,0,1),
			(1,45,649,0,0),
			(1,45,650,0,0),
			(1,29,652,0,0),
			(1,29,689,0,0),
			(1,42,690,0,0),
			(1,40,691,0,0),
			(1,29,692,0,0),
			(1,29,694,0,0),
			(1,6,700,0,1),
			(1,4,701,0,1),
			(1,29,703,0,0),
			(1,18,708,0,0),
			(1,40,710,0,0),
			(1,40,711,0,0),
			(1,29,716,0,0),
			(1,29,719,0,0),
			(1,13,720,0,0),
			(1,29,721,0,0),
			(1,29,722,0,0),
			(1,4,725,0,1),
			(1,6,726,0,1),
			(1,7,727,0,1),
			(1,9,729,0,1),
			(1,13,730,0,1),
			(1,18,734,0,1),
			(1,34,742,0,1),
			(1,35,743,0,1),
			(1,37,744,0,1),
			(1,40,745,0,1),
			(1,41,746,0,1),
			(1,42,747,0,1),
			(1,43,748,0,1),
			(1,45,749,0,1),
			(1,51,780,0,0),
			(1,51,781,0,0),
			(1,51,782,0,0),
			(1,51,783,0,0),
			(1,51,784,0,0),
			(1,51,785,0,0),
			(1,51,786,0,0),
			(1,51,787,0,0),
			(1,51,788,0,0),
			(1,51,791,0,1),
			(1,51,792,0,1),
			(1,13,814,0,0),
			(1,42,816,0,0),
			(1,37,818,0,0),
			(1,34,820,0,0),
			(1,43,826,0,0),
			(1,54,842,0,0),
			(1,54,843,0,0),
			(1,54,844,0,0),
			(1,54,845,0,0),
			(1,54,846,0,0),
			(1,54,847,0,0),
			(1,54,848,0,0),
			(1,54,849,0,0),
			(1,54,850,0,0),
			(1,54,851,0,0),
			(1,54,852,0,0),
			(1,54,853,0,0),
			(1,54,854,0,0),
			(1,54,855,0,0),
			(1,54,856,0,0),
			(1,54,857,0,0),
			(1,54,858,0,1),
			(1,54,860,0,0),
			(1,54,861,0,1),
			(1,54,862,0,1),
			(1,54,863,0,0),
			(1,54,864,0,0),
			(1,8,865,0,0),
			(1,57,866,0,0),
			(1,57,867,0,0),
			(1,57,868,0,0),
			(1,57,870,0,0),
			(1,57,871,0,0),
			(1,57,872,0,0),
			(1,57,873,0,0),
			(1,57,874,0,0),
			(1,57,875,0,1),
			(1,57,876,0,1),
			(1,57,877,0,0),
			(1,57,878,0,0),
			(1,58,879,0,0),
			(1,58,880,0,0),
			(1,58,881,0,0),
			(1,58,883,0,0),
			(1,58,884,0,0),
			(1,58,885,0,0),
			(1,58,886,0,0),
			(1,58,887,0,0),
			(1,58,888,0,1),
			(1,58,889,0,1),
			(1,58,890,0,0),
			(1,58,891,0,0),
			(1,59,892,0,0),
			(1,59,893,0,0),
			(1,59,894,0,0),
			(1,59,895,0,0),
			(1,59,896,0,0),
			(1,59,898,0,0),
			(1,59,899,0,0),
			(1,59,900,0,0),
			(1,59,901,0,0),
			(1,59,902,0,1),
			(1,59,903,0,1),
			(1,59,904,0,0),
			(1,59,905,0,0),
			(1,7,938,0,0),
			(1,7,940,0,0),
			(1,61,941,0,0),
			(1,61,942,0,0),
			(1,61,943,0,0),
			(1,61,944,0,0),
			(1,61,945,0,0),
			(1,61,946,0,0),
			(1,61,947,0,0),
			(1,61,948,0,0),
			(1,61,949,0,0),
			(1,61,950,0,0),
			(1,61,951,0,1),
			(1,61,952,0,1),
			(1,61,953,0,0),
			(1,61,954,0,0),
			(1,61,955,0,0),
			(1,61,956,0,0),
			(1,61,957,0,0),
			(1,61,958,0,0),
			(1,61,959,0,0),
			(1,61,960,0,0),
			(1,61,961,0,0),
			(1,61,962,0,0),
			(1,61,963,0,0),
			(1,61,964,0,0),
			(1,61,965,0,0),
			(1,61,966,0,0),
			(1,7,967,0,0),
			(1,7,968,0,0),
			(1,7,969,0,0),
			(1,6,970,0,0),
			(1,6,971,0,0),
			(1,6,972,0,0),
			(1,18,973,0,0),
			(1,18,974,0,0),
			(1,18,975,0,0),
			(1,43,1044,0,0),
			(1,29,1045,0,1),
			(1,13,1049,0,0),
			(1,7,1065,0,0),
			(1,7,1066,0,0),
			(1,7,1067,0,0),
			(1,7,1068,0,0),
			(1,7,1069,0,0),
			(1,7,1070,0,0),
			(1,7,1071,0,0),
			(1,7,1072,0,0),
			(1,4,1073,0,0),
			(1,4,1074,0,0),
			(1,4,1075,0,0),
			(1,4,1076,0,0),
			(1,4,1077,0,0),
			(1,4,1078,0,0),
			(1,4,1079,0,0),
			(1,4,1080,0,0),
			(1,4,1081,0,0),
			(1,4,1082,0,0),
			(1,4,1083,0,0),
			(1,4,1084,0,0),
			(1,4,1085,0,0),
			(1,4,1086,0,0),
			(1,4,1087,0,0),
			(1,4,1088,0,0),
			(1,6,1089,0,0),
			(1,6,1090,0,0),
			(1,6,1091,0,0),
			(1,6,1092,0,0),
			(1,6,1093,0,0),
			(1,6,1094,0,0),
			(1,6,1095,0,0),
			(1,6,1096,0,0),
			(1,6,1097,0,0),
			(1,6,1098,0,0),
			(1,6,1099,0,0),
			(1,6,1100,0,0),
			(1,6,1101,0,0),
			(1,6,1102,0,0),
			(1,6,1103,0,0),
			(1,6,1104,0,0),
			(1,18,1105,0,0),
			(1,18,1106,0,0),
			(1,18,1107,0,0),
			(1,18,1108,0,0),
			(1,18,1109,0,0),
			(1,18,1110,0,0),
			(1,18,1111,0,0),
			(1,18,1112,0,0),
			(1,18,1113,0,0),
			(1,18,1114,0,0),
			(1,18,1115,0,0),
			(1,18,1116,0,0),
			(1,18,1117,0,0),
			(1,18,1118,0,0),
			(1,18,1119,0,0),
			(1,18,1120,0,0),
			(1,18,1121,0,0),
			(1,18,1122,0,0),
			(1,18,1123,0,0),
			(1,18,1124,0,0),
			(1,18,1125,0,0),
			(1,18,1126,0,0),
			(1,18,1127,0,0),
			(1,18,1128,0,0),
			(1,6,1160,0,0),
			(1,6,1161,0,0),
			(1,6,1162,0,0),
			(1,6,1163,0,0),
			(1,6,1164,0,0),
			(1,6,1165,0,0),
			(1,6,1166,0,0),
			(1,6,1167,0,0),
			(1,7,1276,0,0),
			(1,6,1277,0,0),
			(1,4,1278,0,0),
			(1,18,1279,0,0),
			(1,6,1285,0,0),
			(1,6,1286,0,0),
			(1,6,1287,0,0),
			(1,6,1288,0,0),
			(1,6,1289,0,0),
			(1,6,1290,0,0),
			(1,7,1291,0,0),
			(1,7,1292,0,0),
			(1,4,1293,0,0),
			(1,4,1294,0,0),
			(1,4,1295,0,0),
			(1,4,1296,0,0),
			(1,37,1314,0,0),
			(1,59,1315,0,0),
			(1,57,1316,0,0),
			(1,58,1317,0,0),
			(1,42,1318,0,0),
			(1,42,1319,0,0),
			(1,42,1320,0,0),
			(1,7,1321,0,0),
			(1,29,1322,0,0),
			(1,37,1323,0,0),
			(1,37,1324,0,0),
			(1,51,1326,0,0),
			(1,51,1327,0,0),
			(1,7,1329,0,0),
			(1,6,1330,0,0),
			(1,6,1331,0,0),
			(1,4,1332,0,0),
			(1,18,1333,0,0),
			(1,43,1340,0,0),
			(1,13,1341,0,0),
			(1,58,1344,0,0),
			(1,4,1368,0,0),
			(1,6,1369,0,0),
			(1,6,1375,0,0),
			(1,26,1378,0,0),
			(1,43,1382,0,0),
			(1,13,1384,0,0),
			(1,4,1386,0,0),
			(1,4,1391,0,0),
			(1,14,1393,0,0),
			(1,35,1395,0,0),
			(1,7,1397,0,0),
			(1,8,1399,0,0),
			(1,9,1401,0,0),
			(1,15,1403,0,0),
			(1,18,1407,0,0),
			(1,19,1409,0,0),
			(1,34,1419,0,0),
			(1,37,1421,0,0),
			(1,41,1423,0,0),
			(1,42,1425,0,0),
			(1,51,1431,0,0),
			(1,54,1433,0,0),
			(1,57,1435,0,0),
			(1,58,1437,0,0),
			(1,59,1439,0,0),
			(1,61,1443,0,0),
			(1,13,1482,0,0),
			(1,37,1484,0,0),
			(1,58,1485,0,0),
			(1,7,1486,0,0),
			(1,4,1487,0,0),
			(1,6,1488,0,0),
			(1,18,1489,0,0),
			(1,4,1494,0,0),
			(1,6,1495,0,0),
			(1,18,1496,0,0),
			(1,18,1501,0,0),
			(1,6,1502,0,0),
			(1,4,1503,0,0),
			(1,74,1504,0,0),
			(1,74,1505,0,0),
			(1,74,1506,0,0),
			(1,74,1507,0,0),
			(1,74,1508,0,0),
			(1,74,1509,0,0),
			(1,74,1511,0,0),
			(1,74,1512,0,0),
			(1,74,1513,0,0),
			(1,74,1514,0,0),
			(1,74,1515,0,0),
			(1,74,1516,0,0),
			(1,74,1517,0,0),
			(1,74,1518,0,0),
			(1,74,1519,0,0),
			(1,74,1520,0,0),
			(1,74,1521,0,0),
			(1,74,1522,0,0),
			(1,4,1524,0,0),
			(1,6,1525,0,0),
			(1,7,1526,0,0),
			(1,8,1527,0,0),
			(1,9,1528,0,0),
			(1,13,1529,0,0),
			(1,14,1530,0,0),
			(1,15,1531,0,0),
			(1,18,1532,0,0),
			(1,19,1533,0,0),
			(1,26,1538,0,0),
			(1,34,1539,0,0),
			(1,35,1540,0,0),
			(1,37,1541,0,0),
			(1,41,1542,0,0),
			(1,42,1543,0,0),
			(1,43,1544,0,0),
			(1,51,1547,0,0),
			(1,54,1548,0,0),
			(1,57,1549,0,0),
			(1,58,1550,0,0),
			(1,59,1551,0,0),
			(1,61,1553,0,0),
			(1,74,1556,0,0),
			(1,75,1557,0,0),
			(1,75,1558,0,0),
			(1,75,1559,0,0),
			(1,75,1560,0,0),
			(1,75,1561,0,0),
			(1,75,1562,0,0),
			(1,75,1564,0,0),
			(1,75,1566,0,0),
			(1,75,1567,0,0),
			(1,75,1568,0,0),
			(1,75,1569,0,0),
			(1,51,1600,0,0),
			(1,9,1603,0,0),
			(1,78,1605,0,0),
			(1,78,1606,0,0),
			(1,78,1607,0,0),
			(1,78,1608,0,0),
			(1,78,1609,0,0),
			(1,78,1610,0,0),
			(1,78,1611,0,0),
			(1,78,1613,0,0),
			(1,78,1615,0,0),
			(1,79,1616,0,0),
			(1,79,1617,0,0),
			(1,79,1618,0,0),
			(1,79,1619,0,0),
			(1,79,1620,0,0),
			(1,79,1621,0,0),
			(1,79,1622,0,0),
			(1,79,1625,0,0),
			(1,79,1626,0,0),
			(1,79,1627,0,0),
			(1,79,1628,0,0),
			(1,6,1630,0,0),
			(1,80,1632,0,0),
			(1,80,1633,0,0),
			(1,80,1634,0,0),
			(1,80,1635,0,0),
			(1,80,1636,0,0),
			(1,80,1637,0,0),
			(1,80,1638,0,0),
			(1,80,1640,0,0),
			(1,80,1641,0,0),
			(1,80,1642,0,0),
			(1,80,1643,0,0),
			(1,80,1644,0,0),
			(1,81,1645,0,0),
			(1,81,1646,0,0),
			(1,81,1647,0,0),
			(1,81,1648,0,0),
			(1,81,1649,0,0),
			(1,81,1650,0,0),
			(1,81,1651,0,0),
			(1,81,1652,0,0),
			(1,81,1653,0,0),
			(1,81,1655,0,0),
			(1,81,1656,0,0),
			(1,81,1657,0,0),
			(1,81,1658,0,0),
			(1,81,1659,0,0),
			(1,81,1660,0,0),
			(1,81,1661,0,0),
			(1,82,1667,0,0),
			(1,82,1668,0,0),
			(1,82,1669,0,0),
			(1,82,1670,0,0),
			(1,82,1671,0,0),
			(1,82,1672,0,0),
			(1,82,1673,0,0),
			(1,82,1674,0,0),
			(1,82,1675,0,0),
			(1,82,1677,0,0),
			(1,82,1678,0,0),
			(1,82,1679,0,0),
			(1,82,1680,0,0),
			(1,82,1681,0,0),
			(1,82,1682,0,0),
			(1,82,1683,0,0),
			(1,82,1688,0,0),
			(1,18,1689,0,0),
			(1,18,1690,0,0),
			(1,18,1691,0,0),
			(1,18,1692,0,0),
			(1,18,1693,0,0),
			(1,18,1694,0,0),
			(1,83,1708,0,0),
			(1,83,1709,0,0),
			(1,83,1710,0,0),
			(1,83,1711,0,0),
			(1,83,1712,0,0),
			(1,83,1713,0,0),
			(1,9,1715,0,0),
			(1,84,1716,0,0),
			(1,84,1717,0,0),
			(1,84,1718,0,0),
			(1,84,1719,0,0),
			(1,84,1720,0,0),
			(1,84,1721,0,0),
			(1,84,1722,0,0),
			(1,84,1723,0,0),
			(1,84,1724,0,0),
			(1,84,1725,0,0),
			(1,84,1726,0,0),
			(1,84,1728,0,0),
			(1,84,1729,0,0),
			(1,84,1730,0,0),
			(1,84,1731,0,0),
			(1,84,1732,0,0),
			(1,84,1733,0,0),
			(1,84,1735,0,0),
			(1,7,1736,0,0),
			(1,7,1737,0,0),
			(1,6,1738,0,0),
			(1,29,1740,0,0),
			(1,41,1741,0,0),
			(1,42,1742,0,0),
			(1,41,1743,0,0),
			(1,4,1744,0,0),
			(1,54,1745,0,0),
			(1,4,1746,0,0),
			(1,6,1747,0,0),
			(1,6,1756,0,0),
			(1,6,1757,0,0),
			(1,6,1758,0,0),
			(1,14,1759,0,0),
			(1,9,1762,0,0),
			(1,15,1763,0,0),
			(1,19,1764,0,0),
			(1,85,1765,0,0),
			(1,85,1766,0,0),
			(1,85,1767,0,0),
			(1,85,1768,0,0),
			(1,85,1769,0,0),
			(1,85,1770,0,0),
			(1,85,1771,0,0),
			(1,85,1772,0,0),
			(1,85,1773,0,0),
			(1,85,1774,0,0),
			(1,85,1776,0,0),
			(1,85,1777,0,0),
			(1,86,1779,0,0),
			(1,86,1780,0,0),
			(1,86,1781,0,0),
			(1,86,1782,0,0),
			(1,86,1783,0,0),
			(1,86,1784,0,0),
			(1,86,1785,0,0),
			(1,86,1786,0,0),
			(1,86,1788,0,0),
			(1,87,1789,0,0),
			(1,87,1790,0,0),
			(1,87,1791,0,0),
			(1,87,1792,0,0),
			(1,87,1793,0,0),
			(1,87,1794,0,0),
			(1,87,1795,0,0),
			(1,87,1796,0,0),
			(1,87,1797,0,0),
			(1,87,1798,0,0),
			(1,87,1800,0,0),
			(1,87,1801,0,0),
			(1,87,1802,0,0),
			(1,88,1804,0,0),
			(1,88,1805,0,0),
			(1,88,1806,0,0),
			(1,88,1807,0,0),
			(1,88,1808,0,0),
			(1,88,1809,0,0),
			(1,88,1810,0,0),
			(1,88,1811,0,0),
			(1,88,1812,0,0),
			(1,88,1813,0,0),
			(1,88,1815,0,0),
			(1,88,1816,0,0),
			(1,88,1817,0,0),
			(1,89,1819,0,0),
			(1,89,1820,0,0),
			(1,89,1821,0,0),
			(1,89,1822,0,0),
			(1,89,1823,0,0),
			(1,89,1824,0,0),
			(1,89,1825,0,0),
			(1,89,1826,0,0),
			(1,89,1827,0,0),
			(1,89,1828,0,0),
			(1,89,1830,0,0),
			(1,89,1831,0,0),
			(1,89,1832,0,0),
			(1,90,1834,0,0),
			(1,90,1835,0,0),
			(1,90,1836,0,0),
			(1,90,1837,0,0),
			(1,90,1838,0,0),
			(1,90,1839,0,0),
			(1,90,1840,0,0),
			(1,90,1841,0,0),
			(1,90,1842,0,0),
			(1,90,1843,0,0),
			(1,90,1844,0,0),
			(1,90,1845,0,0),
			(1,90,1846,0,0),
			(1,90,1848,0,0),
			(1,90,1849,0,0),
			(1,90,1850,0,0),
			(1,91,1852,0,0),
			(1,91,1853,0,0),
			(1,91,1854,0,0),
			(1,91,1855,0,0),
			(1,91,1856,0,0),
			(1,91,1857,0,0),
			(1,91,1858,0,0),
			(1,91,1859,0,0),
			(1,91,1860,0,0),
			(1,91,1861,0,0),
			(1,91,1862,0,0),
			(1,91,1863,0,0),
			(1,91,1864,0,0),
			(1,91,1866,0,0),
			(1,91,1867,0,0),
			(1,91,1868,0,0),
			(1,91,1870,0,0),
			(1,91,1871,0,0),
			(1,91,1872,0,0),
			(1,91,1873,0,0),
			(1,91,1874,0,0),
			(1,91,1875,0,0),
			(1,89,1876,0,0),
			(1,89,1877,0,0),
			(1,89,1878,0,0),
			(1,89,1879,0,0),
			(1,89,1880,0,0),
			(1,89,1881,0,0),
			(1,89,1882,0,0),
			(1,89,1883,0,0),
			(1,89,1892,0,0),
			(1,89,1893,0,0),
			(1,89,1896,0,0),
			(1,90,1898,0,0),
			(1,90,1899,0,0),
			(1,90,1900,0,0),
			(1,90,1901,0,0),
			(1,90,1902,0,0),
			(1,90,1903,0,0),
			(1,90,1904,0,0),
			(1,90,1905,0,0),
			(1,90,1914,0,0),
			(1,90,1915,0,0),
			(1,90,1918,0,0),
			(1,91,1920,0,0),
			(1,91,1921,0,0),
			(1,91,1922,0,0),
			(1,91,1923,0,0),
			(1,91,1924,0,0),
			(1,91,1925,0,0),
			(1,91,1926,0,0),
			(1,91,1927,0,0),
			(1,91,1936,0,0),
			(1,91,1937,0,0),
			(1,91,1940,0,0),
			(1,89,1942,0,0),
			(1,91,1944,0,0),
			(1,6,1945,0,1),
			(1,6,1946,0,1),
			(1,37,1947,0,0),
			(1,92,1948,0,0),
			(1,92,1949,0,0),
			(1,92,1950,0,0),
			(1,92,1951,0,0),
			(1,92,1952,0,0),
			(1,92,1953,0,0),
			(1,92,1954,0,0),
			(1,92,1956,0,0),
			(1,92,1957,0,0),
			(1,92,1958,0,0),
			(1,92,1959,0,0),
			(1,92,1960,0,0),
			(1,92,1961,0,0),
			(1,92,1962,0,0),
			(1,92,1963,0,0),
			(1,92,1964,0,0),
			(1,92,1965,0,0),
			(1,92,1966,0,0),
			(1,92,1967,0,0),
			(1,93,1968,0,0),
			(1,93,1969,0,0),
			(1,93,1970,0,0),
			(1,93,1971,0,0),
			(1,93,1972,0,0),
			(1,93,1973,0,0),
			(1,93,1974,0,0),
			(1,93,1976,0,0),
			(1,93,1977,0,0),
			(1,93,1978,0,0),
			(1,93,1979,0,0),
			(1,93,1980,0,0),
			(1,93,1981,0,0),
			(1,93,1982,0,0),
			(1,93,1983,0,0),
			(1,93,1984,0,0),
			(1,93,1985,0,0),
			(1,93,1986,0,0),
			(1,93,1987,0,0),
			(1,59,1988,0,0),
			(1,37,1989,0,0),
			(1,57,1990,0,0),
			(1,58,1991,0,0),
			(1,9,1992,0,0),
			(1,51,1994,0,0),
			(1,51,1995,0,0),
			(1,51,1996,0,0),
			(1,4,1997,0,0),
			(1,7,1998,0,0),
			(1,18,1999,0,0),
			(1,92,2000,0,0),
			(1,93,2001,0,0),
			(1,61,2002,0,0),
			(1,86,2003,0,0),
			(1,26,2004,0,0),
			(1,41,2005,0,0),
			(1,85,2006,0,0),
			(1,87,2007,0,0),
			(1,88,2008,0,0),
			(1,89,2009,0,0),
			(1,90,2010,0,0),
			(1,91,2011,0,0),
			(1,92,2012,0,0),
			(1,93,2013,0,0),
			(1,4,2014,0,0),
			(1,6,2015,0,0),
			(1,7,2016,0,0),
			(1,13,2017,0,0),
			(1,18,2018,0,0),
			(1,26,2019,0,0),
			(1,34,2020,0,0),
			(1,43,2021,0,0),
			(1,61,2022,0,0),
			(1,85,2023,0,0),
			(1,86,2024,0,0),
			(1,87,2025,0,0),
			(1,88,2026,0,0),
			(1,89,2027,0,0),
			(1,90,2028,0,0),
			(1,91,2029,0,0),
			(1,92,2030,0,0),
			(1,93,2031,0,0),
			(1,94,2032,0,0),
			(1,94,2033,0,0),
			(1,94,2034,0,0),
			(1,94,2035,0,0),
			(1,94,2036,0,0),
			(1,94,2037,0,0),
			(1,94,2038,0,0),
			(1,94,2039,0,0),
			(1,95,2040,0,0),
			(1,95,2041,0,0),
			(1,95,2042,0,0),
			(1,95,2043,0,0),
			(1,95,2044,0,0),
			(1,95,2046,0,0),
			(1,95,2047,0,0),
			(1,95,2048,0,0),
			(1,95,2049,0,0),
			(1,95,2050,0,0),
			(1,95,2051,0,0),
			(1,95,2052,0,0),
			(1,95,2053,0,0),
			(1,95,2054,0,0),
			(1,95,2055,0,0),
			(1,95,2056,0,0),
			(1,95,2057,0,0),
			(1,95,2058,0,0),
			(1,95,2059,0,0),
			(1,95,2060,0,0),
			(1,95,2072,0,0),
			(1,95,2073,0,0),
			(1,95,2074,0,0),
			(1,96,2075,0,0),
			(1,96,2076,0,0),
			(1,96,2077,0,0),
			(1,96,2078,0,0),
			(1,96,2079,0,0),
			(1,96,2080,0,0),
			(1,96,2081,0,0),
			(1,96,2082,0,0),
			(1,97,2083,0,0),
			(1,97,2084,0,0),
			(1,97,2085,0,0),
			(1,97,2086,0,0),
			(1,97,2087,0,0),
			(1,97,2088,0,0),
			(1,97,2089,0,0),
			(1,97,2090,0,0),
			(1,97,2091,0,0),
			(1,97,2092,0,0),
			(1,97,2093,0,0),
			(1,86,2094,0,0),
			(1,86,2095,0,0),
			(1,86,2096,0,0),
			(1,86,2097,0,0),
			(1,86,2098,0,0),
			(1,86,2099,0,0),
			(1,86,2100,0,0),
			(1,86,2101,0,0),
			(1,86,2102,0,0),
			(1,88,2103,0,0),
			(1,88,2104,0,0),
			(1,88,2105,0,0),
			(1,89,2106,0,0),
			(1,89,2107,0,0),
			(1,89,2108,0,0),
			(1,89,2109,0,0),
			(1,89,2110,0,0),
			(1,90,2111,0,0),
			(1,90,2112,0,0),
			(1,90,2113,0,0),
			(1,90,2114,0,0),
			(1,90,2115,0,0),
			(1,98,2116,0,0),
			(1,98,2117,0,0),
			(1,98,2118,0,0),
			(1,98,2119,0,0),
			(1,98,2120,0,0),
			(1,98,2121,0,0),
			(1,99,2122,0,0),
			(1,99,2123,0,0),
			(1,99,2124,0,0),
			(1,99,2125,0,0),
			(1,99,2126,0,0),
			(1,99,2127,0,0),
			(1,99,2128,0,0),
			(1,99,2129,0,0),
			(1,99,2130,0,0),
			(1,99,2131,0,0),
			(1,99,2132,0,0),
			(1,99,2133,0,0),
			(1,99,2134,0,0),
			(1,99,2135,0,0),
			(1,99,2136,0,0),
			(1,99,2137,0,0),
			(1,99,2138,0,0),
			(1,99,2139,0,0),
			(1,99,2140,0,0),
			(1,99,2141,0,0),
			(1,99,2142,0,0),
			(1,99,2143,0,0),
			(1,99,2144,0,0),
			(1,100,2156,0,0),
			(1,100,2157,0,0),
			(1,100,2158,0,0),
			(1,100,2159,0,0),
			(1,100,2160,0,0),
			(1,100,2161,0,0),
			(1,100,2162,0,0),
			(1,101,2163,0,0),
			(1,101,2164,0,0),
			(1,101,2165,0,0),
			(1,101,2166,0,0),
			(1,101,2167,0,0),
			(1,101,2168,0,0),
			(1,101,2169,0,0),
			(1,98,2170,0,0),
			(1,102,2171,0,0),
			(1,102,2172,0,0),
			(1,102,2173,0,0),
			(1,102,2174,0,0),
			(1,102,2175,0,0),
			(1,102,2176,0,0),
			(1,102,2177,0,0),
			(1,98,2178,0,0),
			(1,100,2179,0,0),
			(1,101,2180,0,0),
			(1,102,2181,0,0),
			(1,103,2182,0,0),
			(1,103,2183,0,0),
			(1,103,2184,0,0),
			(1,103,2185,0,0),
			(1,103,2186,0,0),
			(1,103,2187,0,0),
			(1,103,2188,0,0),
			(1,98,2189,0,0),
			(1,98,2190,0,0),
			(1,98,2191,0,0),
			(1,98,2192,0,0),
			(1,100,2193,0,0),
			(1,100,2194,0,0),
			(1,100,2195,0,0),
			(1,100,2196,0,0),
			(1,101,2197,0,0),
			(1,101,2198,0,0),
			(1,101,2199,0,0),
			(1,102,2200,0,0),
			(1,102,2201,0,0),
			(1,102,2202,0,0),
			(1,103,2203,0,0),
			(1,103,2204,0,0),
			(1,103,2205,0,0),
			(1,103,2206,0,0),
			(1,103,2207,0,0),
			(1,14,2208,0,0),
			(1,98,2209,0,0),
			(1,96,2210,0,0),
			(1,97,2211,0,0),
			(1,97,2212,0,0),
			(1,97,2213,0,0),
			(1,97,2214,0,0),
			(1,97,2215,0,0),
			(1,97,2216,0,0),
			(1,97,2217,0,0),
			(1,97,2218,0,0),
			(1,97,2219,0,0),
			(1,97,2220,0,0),
			(1,97,2221,0,0),
			(1,104,2222,0,0),
			(1,104,2223,0,0),
			(1,104,2224,0,0),
			(1,104,2225,0,0),
			(1,104,2226,0,0),
			(1,104,2227,0,0),
			(1,104,2228,0,0),
			(1,104,2229,0,0),
			(1,104,2230,0,0),
			(1,104,2231,0,0),
			(1,104,2232,0,0),
			(1,104,2233,0,0),
			(1,104,2234,0,0),
			(1,105,2235,0,0),
			(1,105,2236,0,0),
			(1,105,2237,0,0),
			(1,105,2238,0,0),
			(1,105,2239,0,0),
			(1,105,2240,0,0),
			(1,105,2241,0,0),
			(1,105,2242,0,0),
			(1,105,2243,0,0),
			(1,105,2244,0,0),
			(1,105,2245,0,0),
			(1,106,2246,0,0),
			(1,106,2247,0,0),
			(1,106,2248,0,0),
			(1,106,2249,0,0),
			(1,106,2250,0,0),
			(1,106,2251,0,0),
			(1,106,2252,0,0),
			(1,106,2253,0,0),
			(1,106,2254,0,0),
			(1,106,2255,0,0),
			(1,106,2256,0,0),
			(1,106,2257,0,0),
			(1,106,2258,0,0),
			(1,104,2259,0,0),
			(1,106,2260,0,0),
			(1,104,2261,0,0),
			(1,106,2262,0,0),
			(1,96,2263,0,0),
			(1,96,2266,0,0),
			(1,58,2267,0,0),
			(1,37,2268,0,0),
			(1,14,2269,0,0),
			(1,107,2270,0,0),
			(1,107,2271,0,0),
			(1,107,2272,0,0),
			(1,107,2273,0,0),
			(1,107,2274,0,0),
			(1,107,2275,0,0),
			(1,107,2276,0,0),
			(1,107,2277,0,0),
			(1,107,2278,0,0),
			(1,107,2279,0,0),
			(1,107,2280,0,0),
			(1,107,2281,0,0),
			(1,107,2282,0,0),
			(1,107,2283,0,0),
			(1,107,2284,0,0),
			(1,107,2285,0,0),
			(1,107,2286,0,0),
			(1,107,2287,0,0),
			(1,107,2288,0,0),
			(1,107,2289,0,0),
			(1,107,2290,0,0),
			(1,107,2291,0,0),
			(1,107,2292,0,0),
			(1,107,2304,0,0),
			(1,108,2305,0,0),
			(1,108,2306,0,0),
			(1,108,2307,0,0),
			(1,108,2308,0,0),
			(1,108,2309,0,0),
			(1,108,2310,0,0),
			(1,108,2311,0,0),
			(1,108,2312,0,0),
			(1,108,2313,0,0),
			(1,108,2314,0,0),
			(1,108,2315,0,0),
			(1,108,2316,0,0),
			(1,108,2317,0,0),
			(1,108,2318,0,0),
			(1,109,2319,0,0),
			(1,109,2320,0,0),
			(1,109,2321,0,0),
			(1,109,2322,0,0),
			(1,109,2323,0,0),
			(1,109,2324,0,0),
			(1,109,2325,0,0),
			(1,109,2326,0,0),
			(1,109,2327,0,0),
			(1,109,2328,0,0),
			(1,109,2329,0,0),
			(1,109,2330,0,0),
			(1,109,2331,0,0),
			(1,14,2334,0,0),
			(1,35,2335,0,0),
			(1,37,2336,0,0),
			(1,58,2337,0,0),
			(1,90,2344,0,0),
			(1,100,2345,0,0),
			(1,6,2346,0,0),
			(1,7,2351,0,0),
			(1,92,2352,0,0),
			(1,18,2353,0,0),
			(1,93,2354,0,0),
			(1,83,2355,0,0),
			(1,83,2356,0,0),
			(1,14,2357,0,0),
			(1,89,2358,0,0),
			(1,92,2381,0,0),
			(1,61,2382,0,0),
			(1,61,2383,0,0),
			(1,61,2384,0,0),
			(1,86,2385,0,0),
			(1,43,2386,0,0),
			(1,111,2387,0,0),
			(1,111,2388,0,0),
			(1,111,2389,0,0),
			(1,111,2390,0,0),
			(1,111,2391,0,0),
			(1,111,2392,0,0),
			(1,111,2393,0,0),
			(1,111,2395,0,0),
			(1,111,2396,0,0),
			(1,111,2397,0,0),
			(1,111,2398,0,0),
			(1,111,2399,0,0),
			(1,111,2400,0,0),
			(1,6,2401,0,0),
			(1,95,2403,0,0),
			(1,86,2404,0,0),
			(1,6,2405,0,0),
			(1,4,2406,0,0),
			(1,7,2407,0,0),
			(1,18,2408,0,0),
			(1,14,2409,0,0),
			(1,86,2410,0,0),
			(1,97,2411,0,0),
			(1,26,2412,0,0),
			(1,13,2414,0,0),
			(1,105,2415,0,0),
			(1,35,2416,0,0),
			(1,106,2417,0,0),
			(1,98,2418,0,0),
			(1,54,2419,0,0),
			(1,108,2420,0,0),
			(1,100,2421,0,0),
			(1,109,2422,0,0),
			(1,9,2423,0,0),
			(1,43,2424,0,0),
			(1,101,2425,0,0),
			(1,102,2426,0,0),
			(1,37,2427,0,0),
			(1,61,2428,0,0),
			(1,103,2429,0,0),
			(1,15,2430,0,0),
			(1,74,2431,0,0),
			(1,104,2432,0,0),
			(1,34,2433,0,0),
			(1,59,2434,0,0),
			(1,51,2435,0,0),
			(1,19,2436,0,0),
			(1,41,2437,0,0),
			(1,8,2438,0,0),
			(1,58,2439,0,0),
			(1,84,2440,0,0),
			(1,57,2442,0,0),
			(1,83,2443,0,0),
			(1,42,2444,0,0),
			(1,75,2445,0,0),
			(1,78,2446,0,0),
			(1,79,2447,0,0),
			(1,80,2448,0,0),
			(1,81,2449,0,0),
			(1,107,2450,0,0),
			(1,82,2451,0,0),
			(1,99,2452,0,0),
			(1,94,2453,0,0),
			(1,95,2454,0,0),
			(1,96,2455,0,0),
			(1,111,2456,0,0),
			(1,85,2458,0,0),
			(1,87,2459,0,0),
			(1,89,2460,0,0),
			(1,91,2461,0,0),
			(1,93,2462,0,0),
			(1,88,2463,0,0),
			(1,90,2464,0,0),
			(1,92,2465,0,0),
			(1,35,2467,0,0),
			(1,29,2468,0,0),
			(1,29,2469,0,0),
			(1,29,2470,0,0),
			(1,112,2471,0,0),
			(1,112,2472,0,0),
			(1,112,2473,0,0),
			(1,112,2474,0,0),
			(1,112,2475,0,0),
			(1,112,2476,0,0),
			(1,112,2477,0,0),
			(1,112,2478,0,0),
			(1,112,2479,0,0),
			(1,112,2480,0,0),
			(1,112,2481,0,0),
			(1,112,2482,0,0),
			(1,112,2483,0,0),
			(1,86,2484,0,0),
			(1,113,2485,0,0),
			(1,113,2486,0,0),
			(1,113,2487,0,0),
			(1,113,2488,0,0),
			(1,113,2489,0,0),
			(1,113,2490,0,0),
			(1,113,2491,0,0),
			(1,113,2492,0,0),
			(1,113,2493,0,0),
			(1,113,2494,0,0),
			(1,113,2495,0,0),
			(1,113,2496,0,0),
			(1,113,2497,0,0),
			(1,113,2498,0,0),
			(1,113,2499,0,0),
			(1,113,2500,0,0),
			(1,113,2501,0,0),
			(1,113,2502,0,0),
			(1,113,2503,0,0),
			(1,113,2504,0,0),
			(1,113,2505,0,0),
			(1,113,2506,0,0),
			(1,113,2507,0,0),
			(1,113,2508,0,0),
			(1,114,2509,0,0),
			(1,114,2510,0,0),
			(1,114,2511,0,0),
			(1,114,2512,0,0),
			(1,114,2513,0,0),
			(1,114,2514,0,0),
			(1,114,2515,0,0),
			(1,114,2516,0,0),
			(1,114,2517,0,0),
			(1,114,2518,0,0),
			(1,114,2519,0,0),
			(1,115,2520,0,0),
			(1,115,2521,0,0),
			(1,115,2522,0,0),
			(1,115,2523,0,0),
			(1,115,2524,0,0),
			(1,115,2525,0,0),
			(1,115,2526,0,0),
			(1,115,2527,0,0),
			(1,115,2528,0,0),
			(1,115,2529,0,0),
			(1,115,2530,0,0),
			(1,115,2531,0,0),
			(1,115,2532,0,0),
			(1,115,2533,0,0),
			(1,115,2534,0,0),
			(1,115,2535,0,0),
			(1,115,2536,0,0),
			(1,115,2537,0,0),
			(1,115,2538,0,0),
			(1,115,2539,0,0),
			(1,115,2540,0,0),
			(1,115,2541,0,0),
			(1,115,2542,0,0),
			(1,115,2543,0,0),
			(1,115,2544,0,0),
			(1,115,2545,0,0),
			(1,115,2557,0,0),
			(1,115,2558,0,0),
			(1,116,2559,0,0),
			(1,116,2560,0,0),
			(1,116,2561,0,0),
			(1,116,2562,0,0),
			(1,116,2563,0,0),
			(1,116,2564,0,0),
			(1,116,2565,0,0),
			(1,116,2566,0,0),
			(1,116,2567,0,0),
			(1,116,2568,0,0),
			(1,116,2569,0,0),
			(1,95,2570,0,0),
			(1,95,2571,0,0),
			(1,95,2572,0,0),
			(1,95,2573,0,0),
			(1,113,2574,0,0),
			(1,113,2575,0,0),
			(1,113,2576,0,0),
			(1,117,2577,0,0),
			(1,117,2578,0,0),
			(1,117,2579,0,0),
			(1,117,2580,0,0),
			(1,117,2581,0,0),
			(1,117,2582,0,0),
			(1,117,2583,0,0),
			(1,117,2584,0,0),
			(1,117,2585,0,0),
			(1,117,2586,0,0),
			(1,117,2587,0,0),
			(1,117,2588,0,0),
			(1,117,2590,0,0),
			(1,117,2591,0,0),
			(1,117,2592,0,0),
			(1,117,2593,0,0),
			(1,117,2594,0,0),
			(1,117,2595,0,0),
			(1,117,2596,0,0),
			(1,117,2598,0,0),
			(1,9,2602,0,0),
			(1,9,2603,0,0),
			(1,43,2604,0,0),
			(1,83,2605,0,0),
			(1,45,2606,0,0),
			(1,84,2607,0,0),
			(1,92,2608,0,0),
			(1,6,2609,0,0),
			(1,6,2610,0,0),
			(1,6,2611,0,0),
			(1,7,2612,0,0),
			(1,7,2613,0,0),
			(1,7,2614,0,0),
			(1,4,2615,0,0),
			(1,4,2616,0,0),
			(1,18,2617,0,0),
			(1,29,2619,0,0),
			(1,61,2620,0,0),
			(1,61,2621,0,0),
			(1,74,2622,0,0),
			(1,74,2623,0,0),
			(1,61,2624,0,0),
			(1,29,2625,0,0),
			(1,29,2626,0,0),
			(1,37,2627,0,0),
			(1,58,2628,0,0),
			(1,9,2630,0,0),
			(1,111,2631,0,0),
			(1,51,2632,0,0),
			(1,84,2633,0,0),
			(1,81,2635,0,0),
			(1,81,2636,0,0),
			(1,81,2637,0,0),
			(1,81,2638,0,0),
			(1,81,2639,0,0),
			(1,81,2640,0,0),
			(1,81,2641,0,0),
			(1,82,2642,0,0),
			(1,119,2643,0,0),
			(1,119,2644,0,0),
			(1,119,2645,0,0),
			(1,119,2646,0,0),
			(1,119,2647,0,0),
			(1,119,2648,0,0),
			(1,119,2649,0,0),
			(1,119,2650,0,0),
			(1,119,2651,0,0),
			(1,119,2652,0,0),
			(1,119,2653,0,0),
			(1,119,2654,0,0),
			(1,119,2655,0,0),
			(1,119,2656,0,0),
			(1,119,2657,0,0),
			(1,119,2658,0,0),
			(1,119,2659,0,0),
			(1,119,2660,0,0),
			(1,119,2661,0,0),
			(1,119,2662,0,0),
			(1,119,2663,0,0),
			(1,119,2664,0,0),
			(1,119,2665,0,0),
			(1,119,2666,0,0),
			(1,119,2667,0,0),
			(1,119,2668,0,0),
			(1,119,2669,0,0),
			(1,119,2670,0,0),
			(1,119,2671,0,0),
			(1,119,2672,0,0),
			(1,119,2673,0,0),
			(1,119,2674,0,0),
			(1,119,2675,0,0),
			(1,29,2676,0,0),
			(1,41,2677,0,0),
			(1,121,2678,0,0),
			(1,121,2679,0,0),
			(1,121,2680,0,0),
			(1,121,2681,0,0),
			(1,121,2682,0,0),
			(1,121,2683,0,0),
			(1,121,2684,0,0),
			(1,121,2685,0,0),
			(1,121,2686,0,0),
			(1,121,2687,0,0),
			(1,121,2688,0,0),
			(1,121,2689,0,0),
			(1,121,2690,0,0),
			(1,121,2691,0,0),
			(1,121,2692,0,0),
			(1,121,2693,0,0),
			(1,121,2694,0,0),
			(1,121,2695,0,0),
			(1,122,2696,0,0),
			(1,122,2697,0,0),
			(1,122,2698,0,0),
			(1,122,2699,0,0),
			(1,122,2700,0,0),
			(1,122,2701,0,0),
			(1,122,2702,0,0),
			(1,122,2703,0,0),
			(1,122,2704,0,0),
			(1,122,2705,0,0),
			(1,122,2706,0,0),
			(1,122,2707,0,0),
			(1,122,2708,0,0),
			(1,122,2709,0,0),
			(1,123,2710,0,0),
			(1,123,2711,0,0),
			(1,123,2712,0,0),
			(1,123,2713,0,0),
			(1,123,2714,0,0),
			(1,123,2715,0,0),
			(1,123,2716,0,0),
			(1,123,2717,0,0),
			(1,123,2718,0,0),
			(1,123,2719,0,0),
			(1,123,2720,0,0),
			(1,123,2721,0,0),
			(1,123,2722,0,0),
			(1,123,2723,0,0),
			(1,123,2724,0,0),
			(1,123,2725,0,0),
			(1,123,2726,0,0),
			(1,123,2727,0,0),
			(1,123,2728,0,0),
			(1,123,2729,0,0),
			(1,123,2730,0,0),
			(1,123,2731,0,0),
			(1,124,2732,0,0),
			(1,124,2733,0,0),
			(1,124,2734,0,0),
			(1,124,2735,0,0),
			(1,124,2736,0,0),
			(1,124,2737,0,0),
			(1,124,2738,0,0),
			(1,124,2739,0,0),
			(1,124,2740,0,0),
			(1,124,2741,0,0),
			(1,124,2742,0,0),
			(1,124,2743,0,0),
			(1,124,2744,0,0),
			(1,124,2745,0,0),
			(1,124,2746,0,0),
			(1,124,2747,0,0),
			(1,124,2748,0,0),
			(1,124,2749,0,0),
			(1,124,2750,0,0),
			(1,125,2751,0,0),
			(1,125,2752,0,0),
			(1,125,2753,0,0),
			(1,125,2754,0,0),
			(1,125,2755,0,0),
			(1,125,2756,0,0),
			(1,125,2757,0,0),
			(1,125,2758,0,0),
			(1,125,2759,0,0),
			(1,125,2760,0,0),
			(1,125,2761,0,0),
			(1,125,2762,0,0),
			(1,41,2763,0,0),
			(1,29,2764,0,0),
			(1,29,2765,0,0),
			(1,29,2766,0,0),
			(1,107,2767,0,0),
			(1,107,2768,0,0),
			(1,93,2769,0,0),
			(1,40,2770,0,0),
			(1,95,2771,0,0),
			(1,61,2772,0,0),
			(1,119,2773,0,0),
			(1,119,2774,0,0),
			(1,85,2775,0,0),
			(1,29,2776,0,0),
			(1,29,2777,0,0),
			(1,112,2778,0,0),
			(1,41,2779,0,0),
			(1,43,2780,0,0),
			(1,9,2781,0,0),
			(1,51,2782,0,0),
			(1,29,2783,0,0),
			(1,29,2784,0,0),
			(1,29,2785,0,0),
			(1,95,2786,0,0),
			(1,95,2787,0,0),
			(1,6,2788,0,0),
			(1,96,2789,0,0),
			(1,96,2790,0,0),
			(1,13,2791,0,0),
			(1,90,2792,0,0),
			(1,6,2793,0,0),
			(1,15,2794,0,0),
			(1,15,2795,0,0),
			(1,15,2796,0,0),
			(1,15,2797,0,0),
			(1,15,2798,0,0),
			(1,15,2799,0,0),
			(1,6,2800,0,0),
			(1,111,2801,0,0),
			(1,79,2802,0,0),
			(1,79,2803,0,0),
			(1,79,2804,0,0),
			(1,79,2805,0,0),
			(1,13,2806,0,0),
			(1,13,2807,0,0),
			(1,13,2808,0,0),
			(1,13,2809,0,0),
			(1,13,2810,0,0),
			(1,13,2811,0,0),
			(1,13,2812,0,0),
			(1,13,2813,0,0),
			(1,13,2814,0,0),
			(1,13,2815,0,0),
			(1,13,2816,0,0),
			(1,14,2817,0,0),
			(1,90,2818,0,0),
			(1,35,2819,0,0),
			(1,15,2821,0,0),
			(1,6,2822,0,0),
			(1,6,2823,0,0),
			(1,14,2824,0,0),
			(1,95,2825,0,0),
			(1,90,2826,0,0),
			(1,34,2827,0,0),
			(1,34,2828,0,0),
			(1,13,2829,0,0),
			(1,29,2830,0,0),
			(1,29,2831,0,0),
			(1,14,2832,0,0),
			(1,15,2833,0,0),
			(1,19,2834,0,0),
			(1,26,2835,0,0),
			(1,51,2836,0,0),
			(1,54,2837,0,0),
			(1,57,2838,0,0),
			(1,58,2839,0,0),
			(1,59,2840,0,0),
			(1,61,2842,0,0),
			(1,74,2843,0,0),
			(1,75,2844,0,0),
			(1,79,2845,0,0),
			(1,80,2846,0,0),
			(1,81,2847,0,0),
			(1,82,2848,0,0),
			(1,83,2849,0,0),
			(1,84,2850,0,0),
			(1,85,2851,0,0),
			(1,86,2852,0,0),
			(1,87,2853,0,0),
			(1,88,2854,0,0),
			(1,89,2855,0,0),
			(1,90,2856,0,0),
			(1,91,2857,0,0),
			(1,92,2858,0,0),
			(1,93,2859,0,0),
			(1,94,2860,0,0),
			(1,95,2861,0,0),
			(1,97,2862,0,0),
			(1,98,2863,0,0),
			(1,99,2864,0,0),
			(1,100,2865,0,0),
			(1,101,2866,0,0),
			(1,102,2867,0,0),
			(1,103,2868,0,0),
			(1,104,2869,0,0),
			(1,105,2870,0,0),
			(1,106,2871,0,0),
			(1,107,2872,0,0),
			(1,108,2873,0,0),
			(1,109,2874,0,0),
			(1,115,2875,0,0),
			(1,117,2876,0,0),
			(1,127,2877,0,0),
			(1,127,2878,0,0),
			(1,127,2879,0,0),
			(1,127,2880,0,0),
			(1,127,2881,0,0),
			(1,127,2882,0,0),
			(1,127,2883,0,0),
			(1,127,2884,0,0),
			(1,127,2885,0,0),
			(1,128,2886,0,0),
			(1,128,2887,0,0),
			(1,128,2888,0,0),
			(1,128,2889,0,0),
			(1,128,2890,0,0),
			(1,128,2891,0,0),
			(1,128,2892,0,0),
			(1,128,2893,0,0),
			(1,128,2894,0,0),
			(1,128,2895,0,0),
			(1,128,2896,0,0),
			(1,128,2897,0,0),
			(1,128,2898,0,0),
			(1,29,2899,0,0),
			(1,29,2900,0,0),
			(1,4,2901,0,0),
			(1,8,2902,0,0),
			(1,78,2903,0,0),
			(1,130,2904,0,0),
			(1,130,2905,0,0),
			(1,130,2906,0,0),
			(1,130,2907,0,0),
			(1,130,2908,0,0),
			(1,130,2909,0,0),
			(1,130,2910,0,0),
			(1,130,2914,0,0),
			(1,130,2915,0,0),
			(1,130,2916,0,0),
			(1,130,2917,0,0),
			(1,130,2918,0,0),
			(1,130,2919,0,0),
			(1,130,2920,0,0),
			(1,130,2921,0,0),
			(1,130,2922,0,0),
			(1,130,2923,0,0),
			(1,130,2924,0,0),
			(1,130,2925,0,0),
			(1,130,2926,0,0),
			(1,130,2927,0,0),
			(1,130,2928,0,0),
			(1,130,2929,0,0),
			(1,130,2930,0,0),
			(1,130,2931,0,0),
			(1,130,2932,0,0),
			(1,130,2933,0,0),
			(1,131,2934,0,0),
			(1,131,2935,0,0),
			(1,131,2936,0,0),
			(1,131,2937,0,0),
			(1,131,2938,0,0),
			(1,131,2939,0,0),
			(1,131,2940,0,0),
			(1,131,2941,0,0),
			(1,131,2942,0,0),
			(1,131,2943,0,0),
			(1,131,2944,0,0),
			(1,131,2945,0,0),
			(1,131,2946,0,0),
			(1,131,2947,0,0),
			(1,131,2948,0,0),
			(1,131,2949,0,0),
			(1,86,2950,0,0),
			(1,86,2951,0,0),
			(1,86,2952,0,0),
			(1,90,2953,0,0),
			(1,90,2954,0,0),
			(1,90,2955,0,0),
			(1,90,2956,0,0),
			(1,90,2957,0,0),
			(1,90,2959,0,0),
			(1,90,2960,0,0),
			(1,90,2961,0,0),
			(1,90,2962,0,0),
			(1,90,2963,0,0),
			(1,90,2964,0,0),
			(1,90,2965,0,0),
			(1,90,2966,0,0),
			(1,90,2967,0,0),
			(1,90,2968,0,0),
			(1,90,2969,0,0),
			(1,90,2970,0,0),
			(1,90,2971,0,0),
			(1,90,2972,0,0),
			(1,90,2973,0,0),
			(1,90,2974,0,0),
			(1,90,2975,0,0),
			(1,90,2976,0,0),
			(1,90,2977,0,0),
			(1,90,2978,0,0),
			(1,89,2979,0,0),
			(1,88,2980,0,0),
			(1,132,2981,0,0),
			(1,132,2982,0,0),
			(1,132,2983,0,0),
			(1,132,2984,0,0),
			(1,132,2985,0,0),
			(1,132,2986,0,0),
			(1,132,2987,0,0),
			(1,132,2988,0,0),
			(1,132,2989,0,0),
			(1,95,2990,0,0),
			(1,95,2991,0,0),
			(1,95,2992,0,0),
			(1,95,2993,0,0),
			(1,95,2994,0,0),
			(1,95,2995,0,0),
			(1,95,2996,0,0),
			(1,95,2997,0,0),
			(1,95,2998,0,0),
			(1,95,2999,0,0),
			(1,95,3000,0,0),
			(1,95,3001,0,0),
			(1,95,3002,0,0),
			(1,95,3003,0,0),
			(1,95,3004,0,0),
			(1,95,3005,0,0),
			(1,95,3006,0,0),
			(1,95,3007,0,0),
			(1,95,3008,0,0),
			(1,95,3009,0,0),
			(1,95,3010,0,0),
			(1,95,3011,0,0),
			(1,95,3012,0,0),
			(1,99,3013,0,0),
			(1,99,3014,0,0),
			(1,99,3015,0,0),
			(1,99,3016,0,0),
			(1,99,3017,0,0),
			(1,99,3018,0,0),
			(1,99,3019,0,0),
			(1,99,3020,0,0),
			(1,99,3021,0,0),
			(1,99,3022,0,0),
			(1,99,3023,0,0),
			(1,99,3024,0,0),
			(1,99,3025,0,0),
			(1,99,3026,0,0),
			(1,99,3027,0,0),
			(1,99,3028,0,0),
			(1,99,3029,0,0),
			(1,99,3030,0,0),
			(1,99,3031,0,0),
			(1,99,3032,0,0),
			(1,99,3033,0,0),
			(1,99,3034,0,0),
			(1,99,3035,0,0),
			(1,9,3036,0,0),
			(1,131,3037,0,0),
			(1,4,3038,0,0),
			(1,29,3039,0,0),
			(1,29,3040,0,0),
			(1,29,3041,0,0),
			(1,133,3042,0,0),
			(1,133,3043,0,0),
			(1,133,3044,0,0),
			(1,133,3045,0,0),
			(1,133,3046,0,0),
			(1,133,3047,0,0),
			(1,133,3048,0,0),
			(1,133,3049,0,0),
			(1,133,3050,0,0),
			(1,133,3051,0,0),
			(1,133,3052,0,0),
			(1,133,3053,0,0),
			(1,133,3054,0,0),
			(1,99,3055,0,0),
			(1,99,3056,0,0),
			(1,95,3057,0,0),
			(1,99,3059,0,0),
			(1,99,3060,0,0),
			(1,95,3061,0,0),
			(1,95,3062,0,0),
			(1,90,3063,0,0),
			(1,90,3064,0,0),
			(1,112,3065,0,0),
			(1,134,3066,0,0),
			(1,134,3067,0,0),
			(1,134,3068,0,0),
			(1,134,3069,0,0),
			(1,134,3070,0,0),
			(1,134,3071,0,0),
			(1,134,3072,0,0),
			(1,134,3073,0,0),
			(1,134,3074,0,0),
			(1,134,3075,0,0),
			(1,134,3076,0,0),
			(1,134,3077,0,0),
			(1,134,3078,0,0),
			(1,92,3080,0,0),
			(1,135,3081,0,0),
			(1,135,3082,0,0),
			(1,135,3083,0,0),
			(1,135,3084,0,0),
			(1,135,3085,0,0),
			(1,135,3086,0,0),
			(1,135,3087,0,0),
			(1,135,3088,0,0),
			(1,135,3089,0,0),
			(1,135,3090,0,0),
			(1,135,3091,0,0),
			(1,135,3092,0,0),
			(1,135,3093,0,0),
			(1,135,3094,0,0),
			(1,135,3095,0,0),
			(1,135,3096,0,0),
			(1,13,3097,0,0),
			(1,111,3098,0,0),
			(1,79,3099,0,0),
			(1,29,3100,0,0),
			(1,136,3101,0,0),
			(1,136,3102,0,0),
			(1,136,3103,0,0),
			(1,136,3104,0,0),
			(1,136,3105,0,0),
			(1,136,3106,0,0),
			(1,136,3107,0,0),
			(1,136,3108,0,0),
			(1,136,3109,0,0),
			(1,136,3110,0,0),
			(1,136,3111,0,0),
			(1,45,3112,0,0),
			(1,45,3113,0,0),
			(1,45,3114,0,0),
			(1,45,3115,0,0),
			(1,45,3116,0,0),
			(1,29,3139,0,0),
			(1,45,3143,0,0),
			(1,6,3145,0,0),
			(1,133,3146,0,0),
			(1,107,3147,0,0),
			(1,107,3148,0,0),
			(1,107,3149,0,0),
			(1,107,3150,0,0),
			(1,107,3151,0,0),
			(1,138,3152,0,0),
			(1,138,3153,0,0),
			(1,138,3154,0,0),
			(1,138,3155,0,0),
			(1,138,3156,0,0),
			(1,138,3157,0,0),
			(1,138,3158,0,0),
			(1,138,3159,0,0),
			(1,138,3160,0,0),
			(1,138,3161,0,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_profile2globalpermissions`(`profileid`,`globalactionid`,`globalactionpermission`) values
			(1,1,1),
			(1,2,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_profile2standardpermissions`(`profileid`,`tabid`,`operation`,`permissions`) values
			(1,4,0,0),
			(1,4,1,0),
			(1,4,2,0),
			(1,4,3,0),
			(1,4,4,0),
			(1,4,7,0),
			(1,6,0,0),
			(1,6,1,0),
			(1,6,2,0),
			(1,6,3,0),
			(1,6,4,0),
			(1,6,7,0),
			(1,7,0,0),
			(1,7,1,0),
			(1,7,2,0),
			(1,7,3,0),
			(1,7,4,0),
			(1,7,7,0),
			(1,8,0,0),
			(1,8,1,0),
			(1,8,2,0),
			(1,8,3,0),
			(1,8,4,0),
			(1,8,7,0),
			(1,9,0,0),
			(1,9,1,0),
			(1,9,2,0),
			(1,9,3,0),
			(1,9,4,0),
			(1,9,7,0),
			(1,13,0,0),
			(1,13,1,0),
			(1,13,2,0),
			(1,13,3,0),
			(1,13,4,0),
			(1,13,7,0),
			(1,14,0,0),
			(1,14,1,0),
			(1,14,2,0),
			(1,14,3,0),
			(1,14,4,0),
			(1,14,7,0),
			(1,15,0,0),
			(1,15,1,0),
			(1,15,2,0),
			(1,15,3,0),
			(1,15,4,0),
			(1,15,7,0),
			(1,18,0,0),
			(1,18,1,0),
			(1,18,2,0),
			(1,18,3,0),
			(1,18,4,0),
			(1,18,7,0),
			(1,19,0,0),
			(1,19,1,0),
			(1,19,2,0),
			(1,19,3,0),
			(1,19,4,0),
			(1,19,7,0),
			(1,26,0,0),
			(1,26,1,0),
			(1,26,2,0),
			(1,26,3,0),
			(1,26,4,0),
			(1,26,7,0),
			(1,34,0,0),
			(1,34,1,0),
			(1,34,2,0),
			(1,34,3,0),
			(1,34,4,0),
			(1,34,7,0),
			(1,35,0,0),
			(1,35,1,0),
			(1,35,2,0),
			(1,35,3,0),
			(1,35,4,0),
			(1,35,7,0),
			(1,37,0,0),
			(1,37,1,0),
			(1,37,2,0),
			(1,37,3,0),
			(1,37,4,0),
			(1,37,7,0),
			(1,40,0,0),
			(1,40,1,0),
			(1,40,2,0),
			(1,40,3,0),
			(1,40,4,0),
			(1,40,7,0),
			(1,41,0,0),
			(1,41,1,0),
			(1,41,2,0),
			(1,41,3,0),
			(1,41,4,0),
			(1,41,7,0),
			(1,42,0,0),
			(1,42,1,0),
			(1,42,2,0),
			(1,42,3,0),
			(1,42,4,0),
			(1,42,7,0),
			(1,43,0,0),
			(1,43,1,0),
			(1,43,2,0),
			(1,43,3,0),
			(1,43,4,0),
			(1,43,7,0),
			(1,45,0,0),
			(1,45,1,0),
			(1,45,2,0),
			(1,45,3,0),
			(1,45,4,0),
			(1,45,7,0),
			(1,51,0,0),
			(1,51,1,0),
			(1,51,2,0),
			(1,51,3,0),
			(1,51,4,0),
			(1,51,7,0),
			(1,54,0,0),
			(1,54,1,0),
			(1,54,2,0),
			(1,54,3,0),
			(1,54,4,0),
			(1,54,7,0),
			(1,57,0,0),
			(1,57,1,0),
			(1,57,2,0),
			(1,57,3,0),
			(1,57,4,0),
			(1,57,7,0),
			(1,58,0,0),
			(1,58,1,0),
			(1,58,2,0),
			(1,58,3,0),
			(1,58,4,0),
			(1,58,7,0),
			(1,59,0,0),
			(1,59,1,0),
			(1,59,2,0),
			(1,59,3,0),
			(1,59,4,0),
			(1,59,7,0),
			(1,61,0,0),
			(1,61,1,0),
			(1,61,2,0),
			(1,61,3,0),
			(1,61,4,0),
			(1,61,7,0),
			(1,74,0,0),
			(1,74,1,0),
			(1,74,2,0),
			(1,74,3,0),
			(1,74,4,0),
			(1,74,7,0),
			(1,75,0,0),
			(1,75,1,0),
			(1,75,2,0),
			(1,75,3,0),
			(1,75,4,0),
			(1,75,7,0),
			(1,78,0,0),
			(1,78,1,0),
			(1,78,2,0),
			(1,78,3,0),
			(1,78,4,0),
			(1,78,7,0),
			(1,79,0,0),
			(1,79,1,0),
			(1,79,2,0),
			(1,79,3,0),
			(1,79,4,0),
			(1,79,7,0),
			(1,80,0,0),
			(1,80,1,0),
			(1,80,2,0),
			(1,80,3,0),
			(1,80,4,0),
			(1,80,7,0),
			(1,81,0,0),
			(1,81,1,0),
			(1,81,2,0),
			(1,81,3,0),
			(1,81,4,0),
			(1,81,7,0),
			(1,82,0,0),
			(1,82,1,0),
			(1,82,2,0),
			(1,82,3,0),
			(1,82,4,0),
			(1,82,7,0),
			(1,83,0,0),
			(1,83,1,0),
			(1,83,2,0),
			(1,83,3,0),
			(1,83,4,0),
			(1,83,7,0),
			(1,84,0,0),
			(1,84,1,0),
			(1,84,2,0),
			(1,84,3,0),
			(1,84,4,0),
			(1,84,7,0),
			(1,85,0,0),
			(1,85,1,0),
			(1,85,2,0),
			(1,85,3,0),
			(1,85,4,0),
			(1,85,7,0),
			(1,86,0,0),
			(1,86,1,0),
			(1,86,2,0),
			(1,86,3,0),
			(1,86,4,0),
			(1,86,7,0),
			(1,87,0,0),
			(1,87,1,0),
			(1,87,2,0),
			(1,87,3,0),
			(1,87,4,0),
			(1,87,7,0),
			(1,88,0,0),
			(1,88,1,0),
			(1,88,2,0),
			(1,88,3,0),
			(1,88,4,0),
			(1,88,7,0),
			(1,89,0,0),
			(1,89,1,0),
			(1,89,2,0),
			(1,89,3,0),
			(1,89,4,0),
			(1,89,7,0),
			(1,90,0,0),
			(1,90,1,0),
			(1,90,2,0),
			(1,90,3,0),
			(1,90,4,0),
			(1,90,7,0),
			(1,91,0,0),
			(1,91,1,0),
			(1,91,2,0),
			(1,91,3,0),
			(1,91,4,0),
			(1,91,7,0),
			(1,92,0,0),
			(1,92,1,0),
			(1,92,2,0),
			(1,92,3,0),
			(1,92,4,0),
			(1,92,7,0),
			(1,93,0,0),
			(1,93,1,0),
			(1,93,2,0),
			(1,93,3,0),
			(1,93,4,0),
			(1,93,7,0),
			(1,94,0,0),
			(1,94,1,0),
			(1,94,2,0),
			(1,94,3,0),
			(1,94,4,0),
			(1,94,7,0),
			(1,95,0,0),
			(1,95,1,0),
			(1,95,2,0),
			(1,95,3,0),
			(1,95,4,0),
			(1,95,7,0),
			(1,96,0,0),
			(1,96,1,0),
			(1,96,2,0),
			(1,96,3,0),
			(1,96,4,0),
			(1,96,7,0),
			(1,97,0,0),
			(1,97,1,0),
			(1,97,2,0),
			(1,97,3,0),
			(1,97,4,0),
			(1,97,7,0),
			(1,98,0,0),
			(1,98,1,0),
			(1,98,2,0),
			(1,98,3,0),
			(1,98,4,0),
			(1,98,7,0),
			(1,99,0,0),
			(1,99,1,0),
			(1,99,2,0),
			(1,99,3,0),
			(1,99,4,0),
			(1,99,7,0),
			(1,100,0,0),
			(1,100,1,0),
			(1,100,2,0),
			(1,100,3,0),
			(1,100,4,0),
			(1,100,7,0),
			(1,101,0,0),
			(1,101,1,0),
			(1,101,2,0),
			(1,101,3,0),
			(1,101,4,0),
			(1,101,7,0),
			(1,102,0,0),
			(1,102,1,0),
			(1,102,2,0),
			(1,102,3,0),
			(1,102,4,0),
			(1,102,7,0),
			(1,103,0,0),
			(1,103,1,0),
			(1,103,2,0),
			(1,103,3,0),
			(1,103,4,0),
			(1,103,7,0),
			(1,104,0,0),
			(1,104,1,0),
			(1,104,2,0),
			(1,104,3,0),
			(1,104,4,0),
			(1,104,7,0),
			(1,105,0,0),
			(1,105,1,0),
			(1,105,2,0),
			(1,105,3,0),
			(1,105,4,0),
			(1,105,7,0),
			(1,106,0,0),
			(1,106,1,0),
			(1,106,2,0),
			(1,106,3,0),
			(1,106,4,0),
			(1,106,7,0),
			(1,107,0,0),
			(1,107,1,0),
			(1,107,2,0),
			(1,107,3,0),
			(1,107,4,0),
			(1,107,7,0),
			(1,108,0,0),
			(1,108,1,0),
			(1,108,2,0),
			(1,108,3,0),
			(1,108,4,0),
			(1,108,7,0),
			(1,109,0,0),
			(1,109,1,0),
			(1,109,2,0),
			(1,109,3,0),
			(1,109,4,0),
			(1,109,7,0),
			(1,111,0,0),
			(1,111,1,0),
			(1,111,2,0),
			(1,111,3,0),
			(1,111,4,0),
			(1,111,7,0),
			(1,112,0,0),
			(1,112,1,0),
			(1,112,2,0),
			(1,112,3,0),
			(1,112,4,0),
			(1,112,7,0),
			(1,113,0,0),
			(1,113,1,0),
			(1,113,2,0),
			(1,113,3,0),
			(1,113,4,0),
			(1,113,7,0),
			(1,114,0,0),
			(1,114,1,0),
			(1,114,2,0),
			(1,114,3,0),
			(1,114,4,0),
			(1,114,7,0),
			(1,115,0,0),
			(1,115,1,0),
			(1,115,2,0),
			(1,115,3,0),
			(1,115,4,0),
			(1,115,7,0),
			(1,116,0,0),
			(1,116,1,0),
			(1,116,2,0),
			(1,116,3,0),
			(1,116,4,0),
			(1,116,7,0),
			(1,117,0,0),
			(1,117,1,0),
			(1,117,2,0),
			(1,117,3,0),
			(1,117,4,0),
			(1,117,7,0),
			(1,119,0,0),
			(1,119,1,0),
			(1,119,2,0),
			(1,119,3,0),
			(1,119,4,0),
			(1,119,7,0),
			(1,121,0,0),
			(1,121,1,0),
			(1,121,2,0),
			(1,121,3,0),
			(1,121,4,0),
			(1,121,7,0),
			(1,122,0,0),
			(1,122,1,0),
			(1,122,2,0),
			(1,122,3,0),
			(1,122,4,0),
			(1,122,7,0),
			(1,123,0,0),
			(1,123,1,0),
			(1,123,2,0),
			(1,123,3,0),
			(1,123,4,0),
			(1,123,7,0),
			(1,124,0,0),
			(1,124,1,0),
			(1,124,2,0),
			(1,124,3,0),
			(1,124,4,0),
			(1,124,7,0),
			(1,125,0,0),
			(1,125,1,0),
			(1,125,2,0),
			(1,125,3,0),
			(1,125,4,0),
			(1,125,7,0),
			(1,127,0,0),
			(1,127,1,0),
			(1,127,2,0),
			(1,127,3,0),
			(1,127,4,0),
			(1,127,7,0),
			(1,128,0,0),
			(1,128,1,0),
			(1,128,2,0),
			(1,128,3,0),
			(1,128,4,0),
			(1,128,7,0),
			(1,130,0,0),
			(1,130,1,0),
			(1,130,2,0),
			(1,130,3,0),
			(1,130,4,0),
			(1,130,7,0),
			(1,131,0,0),
			(1,131,1,0),
			(1,131,2,0),
			(1,131,3,0),
			(1,131,4,0),
			(1,131,7,0),
			(1,132,0,0),
			(1,132,1,0),
			(1,132,2,0),
			(1,132,3,0),
			(1,132,4,0),
			(1,132,7,0),
			(1,133,0,0),
			(1,133,1,0),
			(1,133,2,0),
			(1,133,3,0),
			(1,133,4,0),
			(1,133,7,0),
			(1,134,0,0),
			(1,134,1,0),
			(1,134,2,0),
			(1,134,3,0),
			(1,134,4,0),
			(1,134,7,0),
			(1,135,0,0),
			(1,135,1,0),
			(1,135,2,0),
			(1,135,3,0),
			(1,135,4,0),
			(1,135,7,0),
			(1,136,0,0),
			(1,136,1,0),
			(1,136,2,0),
			(1,136,3,0),
			(1,136,4,0),
			(1,136,7,0),
			(1,138,0,0),
			(1,138,1,0),
			(1,138,2,0),
			(1,138,3,0),
			(1,138,4,0),
			(1,138,7,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_profile2tab`(`profileid`,`tabid`,`permissions`) values
			(1,1,0),
			(1,4,0),
			(1,6,0),
			(1,7,0),
			(1,8,0),
			(1,9,0),
			(1,13,0),
			(1,14,0),
			(1,15,0),
			(1,18,0),
			(1,19,0),
			(1,24,0),
			(1,26,0),
			(1,29,0),
			(1,34,0),
			(1,35,0),
			(1,37,0),
			(1,40,0),
			(1,41,0),
			(1,42,0),
			(1,43,0),
			(1,45,0),
			(1,48,0),
			(1,51,0),
			(1,54,0),
			(1,57,0),
			(1,58,0),
			(1,59,0),
			(1,61,0),
			(1,73,0),
			(1,74,0),
			(1,75,0),
			(1,78,0),
			(1,79,0),
			(1,80,0),
			(1,81,0),
			(1,82,0),
			(1,83,0),
			(1,84,0),
			(1,85,0),
			(1,86,0),
			(1,87,0),
			(1,88,0),
			(1,89,0),
			(1,90,0),
			(1,91,0),
			(1,92,0),
			(1,93,0),
			(1,94,0),
			(1,95,0),
			(1,96,0),
			(1,97,0),
			(1,98,0),
			(1,99,0),
			(1,100,0),
			(1,101,0),
			(1,102,0),
			(1,103,0),
			(1,104,0),
			(1,105,0),
			(1,106,0),
			(1,107,0),
			(1,108,0),
			(1,109,0),
			(1,110,0),
			(1,111,0),
			(1,112,0),
			(1,113,0),
			(1,114,0),
			(1,115,0),
			(1,116,0),
			(1,117,0),
			(1,118,0),
			(1,119,0),
			(1,120,0),
			(1,121,0),
			(1,122,0),
			(1,123,0),
			(1,124,0),
			(1,125,0),
			(1,126,0),
			(1,127,0),
			(1,128,0),
			(1,129,0),
			(1,130,0),
			(1,131,0),
			(1,132,0),
			(1,133,0),
			(1,134,0),
			(1,135,0),
			(1,136,0),
			(1,138,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_profile2utility`(`profileid`,`tabid`,`activityid`,`permission`) values
			(1,1,27,0),
			(1,1,49,0),
			(1,4,0,1),
			(1,4,5,0),
			(1,4,6,0),
			(1,4,8,0),
			(1,4,13,0),
			(1,4,14,0),
			(1,4,15,0),
			(1,4,17,0),
			(1,4,18,0),
			(1,4,19,0),
			(1,4,20,0),
			(1,4,21,0),
			(1,4,22,0),
			(1,4,24,0),
			(1,4,25,0),
			(1,4,26,0),
			(1,4,27,0),
			(1,4,28,0),
			(1,4,30,0),
			(1,4,34,0),
			(1,4,36,0),
			(1,4,37,0),
			(1,4,38,0),
			(1,4,39,0),
			(1,4,40,0),
			(1,4,41,0),
			(1,4,42,0),
			(1,4,46,0),
			(1,4,47,0),
			(1,4,48,0),
			(1,4,49,0),
			(1,4,51,0),
			(1,4,52,0),
			(1,4,53,0),
			(1,4,54,0),
			(1,4,55,0),
			(1,4,56,0),
			(1,4,57,0),
			(1,4,58,0),
			(1,4,59,0),
			(1,4,60,0),
			(1,4,63,0),
			(1,4,65,0),
			(1,4,66,0),
			(1,4,67,1),
			(1,4,68,1),
			(1,4,69,0),
			(1,4,71,0),
			(1,6,0,1),
			(1,6,5,0),
			(1,6,6,0),
			(1,6,8,0),
			(1,6,13,0),
			(1,6,14,0),
			(1,6,15,0),
			(1,6,17,0),
			(1,6,18,0),
			(1,6,19,0),
			(1,6,20,0),
			(1,6,21,0),
			(1,6,22,0),
			(1,6,24,0),
			(1,6,25,0),
			(1,6,26,0),
			(1,6,27,0),
			(1,6,28,0),
			(1,6,30,0),
			(1,6,34,0),
			(1,6,36,0),
			(1,6,37,0),
			(1,6,38,0),
			(1,6,39,0),
			(1,6,40,0),
			(1,6,41,0),
			(1,6,42,0),
			(1,6,46,0),
			(1,6,47,0),
			(1,6,48,0),
			(1,6,49,0),
			(1,6,51,0),
			(1,6,52,0),
			(1,6,53,0),
			(1,6,54,0),
			(1,6,55,0),
			(1,6,56,0),
			(1,6,57,0),
			(1,6,58,0),
			(1,6,59,0),
			(1,6,60,0),
			(1,6,63,0),
			(1,6,65,0),
			(1,6,66,0),
			(1,6,67,1),
			(1,6,68,1),
			(1,6,69,0),
			(1,6,71,0),
			(1,7,0,1),
			(1,7,5,0),
			(1,7,6,0),
			(1,7,8,0),
			(1,7,9,0),
			(1,7,13,0),
			(1,7,14,0),
			(1,7,15,0),
			(1,7,17,0),
			(1,7,18,0),
			(1,7,19,0),
			(1,7,20,0),
			(1,7,21,0),
			(1,7,22,0),
			(1,7,24,0),
			(1,7,25,0),
			(1,7,26,0),
			(1,7,27,0),
			(1,7,28,0),
			(1,7,30,0),
			(1,7,34,0),
			(1,7,36,0),
			(1,7,37,0),
			(1,7,38,0),
			(1,7,39,0),
			(1,7,40,0),
			(1,7,41,0),
			(1,7,42,0),
			(1,7,46,0),
			(1,7,47,0),
			(1,7,48,0),
			(1,7,49,0),
			(1,7,51,0),
			(1,7,52,0),
			(1,7,53,0),
			(1,7,54,0),
			(1,7,55,0),
			(1,7,56,0),
			(1,7,57,0),
			(1,7,58,0),
			(1,7,59,0),
			(1,7,60,0),
			(1,7,63,0),
			(1,7,65,0),
			(1,7,66,0),
			(1,7,67,1),
			(1,7,68,1),
			(1,7,69,0),
			(1,7,71,0),
			(1,8,0,1),
			(1,8,6,0),
			(1,8,8,0),
			(1,8,13,0),
			(1,8,14,0),
			(1,8,15,0),
			(1,8,17,0),
			(1,8,18,0),
			(1,8,19,0),
			(1,8,22,0),
			(1,8,23,0),
			(1,8,24,0),
			(1,8,25,0),
			(1,8,26,0),
			(1,8,27,0),
			(1,8,28,0),
			(1,8,30,0),
			(1,8,34,0),
			(1,8,36,0),
			(1,8,37,0),
			(1,8,38,0),
			(1,8,39,0),
			(1,8,40,0),
			(1,8,41,0),
			(1,8,42,0),
			(1,8,46,0),
			(1,8,47,0),
			(1,8,48,0),
			(1,8,49,0),
			(1,8,51,0),
			(1,8,52,0),
			(1,8,53,0),
			(1,8,54,0),
			(1,8,55,0),
			(1,8,56,0),
			(1,8,57,0),
			(1,8,58,0),
			(1,8,59,0),
			(1,8,60,0),
			(1,8,63,0),
			(1,8,65,0),
			(1,8,66,0),
			(1,8,67,1),
			(1,8,68,1),
			(1,8,69,0),
			(1,8,71,0),
			(1,9,0,1),
			(1,9,5,0),
			(1,9,6,0),
			(1,9,8,0),
			(1,9,13,0),
			(1,9,14,0),
			(1,9,15,0),
			(1,9,17,0),
			(1,9,18,0),
			(1,9,19,0),
			(1,9,22,0),
			(1,9,24,0),
			(1,9,25,0),
			(1,9,26,0),
			(1,9,27,0),
			(1,9,28,0),
			(1,9,30,0),
			(1,9,31,0),
			(1,9,32,0),
			(1,9,33,0),
			(1,9,34,0),
			(1,9,36,0),
			(1,9,37,0),
			(1,9,38,0),
			(1,9,39,0),
			(1,9,40,0),
			(1,9,41,0),
			(1,9,42,0),
			(1,9,46,0),
			(1,9,47,0),
			(1,9,48,0),
			(1,9,49,0),
			(1,9,51,0),
			(1,9,52,0),
			(1,9,53,0),
			(1,9,54,0),
			(1,9,55,0),
			(1,9,56,0),
			(1,9,57,0),
			(1,9,58,0),
			(1,9,59,0),
			(1,9,60,0),
			(1,9,63,0),
			(1,9,65,0),
			(1,9,66,0),
			(1,9,67,1),
			(1,9,68,1),
			(1,9,69,0),
			(1,9,71,0),
			(1,9,73,0),
			(1,9,74,0),
			(1,13,0,1),
			(1,13,5,0),
			(1,13,6,0),
			(1,13,8,0),
			(1,13,13,0),
			(1,13,14,0),
			(1,13,15,0),
			(1,13,17,0),
			(1,13,18,0),
			(1,13,19,0),
			(1,13,22,0),
			(1,13,24,0),
			(1,13,25,0),
			(1,13,26,0),
			(1,13,27,0),
			(1,13,28,0),
			(1,13,30,0),
			(1,13,34,0),
			(1,13,36,0),
			(1,13,37,0),
			(1,13,38,0),
			(1,13,39,0),
			(1,13,40,0),
			(1,13,41,0),
			(1,13,42,0),
			(1,13,46,0),
			(1,13,47,0),
			(1,13,48,0),
			(1,13,49,0),
			(1,13,51,0),
			(1,13,52,0),
			(1,13,53,0),
			(1,13,54,0),
			(1,13,55,0),
			(1,13,56,0),
			(1,13,57,0),
			(1,13,58,0),
			(1,13,59,0),
			(1,13,60,0),
			(1,13,63,0),
			(1,13,65,0),
			(1,13,66,0),
			(1,13,67,1),
			(1,13,68,1),
			(1,13,69,0),
			(1,13,71,0),
			(1,14,0,1),
			(1,14,5,0),
			(1,14,6,0),
			(1,14,8,0),
			(1,14,13,0),
			(1,14,14,0),
			(1,14,15,0),
			(1,14,17,0),
			(1,14,18,0),
			(1,14,19,0),
			(1,14,22,0),
			(1,14,24,0),
			(1,14,25,0),
			(1,14,26,0),
			(1,14,27,0),
			(1,14,28,0),
			(1,14,30,0),
			(1,14,34,0),
			(1,14,36,0),
			(1,14,37,0),
			(1,14,38,0),
			(1,14,39,0),
			(1,14,40,0),
			(1,14,41,0),
			(1,14,42,0),
			(1,14,46,0),
			(1,14,47,0),
			(1,14,48,0),
			(1,14,49,0),
			(1,14,51,0),
			(1,14,52,0),
			(1,14,53,0),
			(1,14,54,0),
			(1,14,55,0),
			(1,14,56,0),
			(1,14,57,0),
			(1,14,58,0),
			(1,14,59,0),
			(1,14,60,0),
			(1,14,62,0),
			(1,14,63,0),
			(1,14,65,0),
			(1,14,66,0),
			(1,14,67,1),
			(1,14,68,1),
			(1,14,69,0),
			(1,14,71,0),
			(1,15,0,1),
			(1,15,8,0),
			(1,15,13,0),
			(1,15,14,0),
			(1,15,15,0),
			(1,15,17,0),
			(1,15,18,0),
			(1,15,19,0),
			(1,15,22,0),
			(1,15,24,0),
			(1,15,25,0),
			(1,15,26,0),
			(1,15,27,0),
			(1,15,28,0),
			(1,15,30,0),
			(1,15,34,0),
			(1,15,36,0),
			(1,15,37,0),
			(1,15,38,0),
			(1,15,39,0),
			(1,15,40,0),
			(1,15,41,0),
			(1,15,42,0),
			(1,15,46,0),
			(1,15,47,0),
			(1,15,48,0),
			(1,15,49,0),
			(1,15,51,0),
			(1,15,52,0),
			(1,15,53,0),
			(1,15,54,0),
			(1,15,55,0),
			(1,15,56,0),
			(1,15,57,0),
			(1,15,58,0),
			(1,15,59,0),
			(1,15,60,0),
			(1,15,63,0),
			(1,15,65,0),
			(1,15,66,0),
			(1,15,67,1),
			(1,15,68,1),
			(1,15,69,0),
			(1,15,71,0),
			(1,18,0,0),
			(1,18,5,0),
			(1,18,6,0),
			(1,18,8,0),
			(1,18,13,0),
			(1,18,14,0),
			(1,18,15,0),
			(1,18,17,0),
			(1,18,18,0),
			(1,18,19,0),
			(1,18,20,0),
			(1,18,21,0),
			(1,18,22,0),
			(1,18,24,0),
			(1,18,25,0),
			(1,18,26,0),
			(1,18,27,0),
			(1,18,28,0),
			(1,18,30,0),
			(1,18,34,0),
			(1,18,36,0),
			(1,18,37,0),
			(1,18,38,0),
			(1,18,39,0),
			(1,18,40,0),
			(1,18,41,0),
			(1,18,42,0),
			(1,18,46,0),
			(1,18,47,0),
			(1,18,48,0),
			(1,18,49,0),
			(1,18,51,0),
			(1,18,52,0),
			(1,18,53,0),
			(1,18,54,0),
			(1,18,55,0),
			(1,18,56,0),
			(1,18,57,0),
			(1,18,58,0),
			(1,18,59,0),
			(1,18,60,0),
			(1,18,63,0),
			(1,18,65,0),
			(1,18,66,0),
			(1,18,67,1),
			(1,18,68,1),
			(1,18,69,0),
			(1,18,71,0),
			(1,19,0,1),
			(1,19,5,0),
			(1,19,6,0),
			(1,19,8,0),
			(1,19,13,0),
			(1,19,14,0),
			(1,19,15,0),
			(1,19,17,0),
			(1,19,18,0),
			(1,19,19,0),
			(1,19,22,0),
			(1,19,24,0),
			(1,19,25,0),
			(1,19,26,0),
			(1,19,27,0),
			(1,19,28,0),
			(1,19,30,0),
			(1,19,34,0),
			(1,19,36,0),
			(1,19,37,0),
			(1,19,38,0),
			(1,19,39,0),
			(1,19,40,0),
			(1,19,41,0),
			(1,19,42,0),
			(1,19,46,0),
			(1,19,47,0),
			(1,19,48,0),
			(1,19,49,0),
			(1,19,51,0),
			(1,19,52,0),
			(1,19,53,0),
			(1,19,54,0),
			(1,19,55,0),
			(1,19,56,0),
			(1,19,57,0),
			(1,19,58,0),
			(1,19,59,0),
			(1,19,60,0),
			(1,19,63,0),
			(1,19,65,0),
			(1,19,66,0),
			(1,19,67,1),
			(1,19,68,1),
			(1,19,69,0),
			(1,19,71,0),
			(1,26,0,1),
			(1,26,5,0),
			(1,26,6,0),
			(1,26,8,0),
			(1,26,13,0),
			(1,26,14,0),
			(1,26,15,0),
			(1,26,17,0),
			(1,26,18,0),
			(1,26,19,0),
			(1,26,22,0),
			(1,26,24,0),
			(1,26,25,0),
			(1,26,26,0),
			(1,26,27,0),
			(1,26,28,0),
			(1,26,30,0),
			(1,26,34,0),
			(1,26,36,0),
			(1,26,37,0),
			(1,26,38,0),
			(1,26,39,0),
			(1,26,40,0),
			(1,26,41,0),
			(1,26,42,0),
			(1,26,46,0),
			(1,26,47,0),
			(1,26,48,0),
			(1,26,49,0),
			(1,26,51,0),
			(1,26,52,0),
			(1,26,53,0),
			(1,26,54,0),
			(1,26,55,0),
			(1,26,56,0),
			(1,26,57,0),
			(1,26,58,0),
			(1,26,59,0),
			(1,26,60,0),
			(1,26,63,0),
			(1,26,65,0),
			(1,26,66,0),
			(1,26,67,1),
			(1,26,68,1),
			(1,26,69,0),
			(1,26,71,0),
			(1,29,64,0),
			(1,29,72,1),
			(1,34,0,1),
			(1,34,5,0),
			(1,34,6,0),
			(1,34,8,0),
			(1,34,13,0),
			(1,34,14,0),
			(1,34,15,0),
			(1,34,17,0),
			(1,34,18,0),
			(1,34,19,0),
			(1,34,22,0),
			(1,34,24,0),
			(1,34,25,0),
			(1,34,26,0),
			(1,34,27,0),
			(1,34,28,0),
			(1,34,30,0),
			(1,34,34,0),
			(1,34,36,0),
			(1,34,37,0),
			(1,34,38,0),
			(1,34,39,0),
			(1,34,40,0),
			(1,34,41,0),
			(1,34,42,0),
			(1,34,46,0),
			(1,34,47,0),
			(1,34,48,0),
			(1,34,49,0),
			(1,34,51,0),
			(1,34,52,0),
			(1,34,53,0),
			(1,34,54,0),
			(1,34,55,0),
			(1,34,56,0),
			(1,34,57,0),
			(1,34,58,0),
			(1,34,59,0),
			(1,34,60,0),
			(1,34,63,0),
			(1,34,65,0),
			(1,34,66,0),
			(1,34,67,1),
			(1,34,68,1),
			(1,34,69,0),
			(1,34,70,0),
			(1,34,71,0),
			(1,35,0,1),
			(1,35,5,0),
			(1,35,6,0),
			(1,35,8,0),
			(1,35,13,0),
			(1,35,14,0),
			(1,35,15,0),
			(1,35,17,0),
			(1,35,18,0),
			(1,35,19,0),
			(1,35,22,0),
			(1,35,24,0),
			(1,35,25,0),
			(1,35,26,0),
			(1,35,27,0),
			(1,35,28,0),
			(1,35,30,0),
			(1,35,34,0),
			(1,35,36,0),
			(1,35,37,0),
			(1,35,38,0),
			(1,35,39,0),
			(1,35,40,0),
			(1,35,41,0),
			(1,35,42,0),
			(1,35,46,0),
			(1,35,47,0),
			(1,35,48,0),
			(1,35,49,0),
			(1,35,51,0),
			(1,35,52,0),
			(1,35,53,0),
			(1,35,54,0),
			(1,35,55,0),
			(1,35,56,0),
			(1,35,57,0),
			(1,35,58,0),
			(1,35,59,0),
			(1,35,60,0),
			(1,35,63,0),
			(1,35,65,0),
			(1,35,66,0),
			(1,35,67,1),
			(1,35,68,1),
			(1,35,69,0),
			(1,35,71,0),
			(1,37,0,0),
			(1,37,5,0),
			(1,37,6,0),
			(1,37,8,0),
			(1,37,13,0),
			(1,37,14,0),
			(1,37,15,0),
			(1,37,17,0),
			(1,37,18,0),
			(1,37,19,0),
			(1,37,22,0),
			(1,37,24,0),
			(1,37,25,0),
			(1,37,26,0),
			(1,37,27,0),
			(1,37,28,0),
			(1,37,30,0),
			(1,37,34,0),
			(1,37,36,0),
			(1,37,37,0),
			(1,37,38,0),
			(1,37,39,0),
			(1,37,40,0),
			(1,37,41,0),
			(1,37,42,0),
			(1,37,46,0),
			(1,37,47,0),
			(1,37,48,0),
			(1,37,49,0),
			(1,37,51,0),
			(1,37,52,0),
			(1,37,53,0),
			(1,37,54,0),
			(1,37,55,0),
			(1,37,56,0),
			(1,37,57,0),
			(1,37,58,0),
			(1,37,59,0),
			(1,37,60,0),
			(1,37,63,0),
			(1,37,65,0),
			(1,37,66,0),
			(1,37,67,1),
			(1,37,68,1),
			(1,37,69,0),
			(1,37,71,0),
			(1,40,5,0),
			(1,40,6,0),
			(1,40,8,0),
			(1,40,14,0),
			(1,40,15,0),
			(1,40,16,0),
			(1,40,17,0),
			(1,40,18,0),
			(1,40,19,0),
			(1,40,22,0),
			(1,40,24,0),
			(1,40,25,0),
			(1,40,26,0),
			(1,40,27,0),
			(1,40,28,0),
			(1,40,34,0),
			(1,40,36,0),
			(1,40,37,0),
			(1,40,38,0),
			(1,40,39,0),
			(1,40,40,0),
			(1,40,41,0),
			(1,40,42,0),
			(1,40,46,0),
			(1,40,47,0),
			(1,40,48,0),
			(1,40,49,0),
			(1,40,51,0),
			(1,40,52,0),
			(1,40,53,0),
			(1,40,54,0),
			(1,40,55,0),
			(1,40,56,0),
			(1,40,57,0),
			(1,40,58,0),
			(1,40,59,0),
			(1,40,60,0),
			(1,40,63,0),
			(1,40,65,0),
			(1,40,66,0),
			(1,40,67,1),
			(1,40,68,1),
			(1,40,69,1),
			(1,40,71,1),
			(1,41,0,1),
			(1,41,5,0),
			(1,41,6,0),
			(1,41,8,0),
			(1,41,13,0),
			(1,41,14,0),
			(1,41,15,0),
			(1,41,17,0),
			(1,41,18,0),
			(1,41,19,0),
			(1,41,22,0),
			(1,41,24,0),
			(1,41,25,0),
			(1,41,26,0),
			(1,41,27,0),
			(1,41,28,0),
			(1,41,30,0),
			(1,41,34,0),
			(1,41,36,0),
			(1,41,37,0),
			(1,41,38,0),
			(1,41,39,0),
			(1,41,40,0),
			(1,41,41,0),
			(1,41,42,0),
			(1,41,46,0),
			(1,41,47,0),
			(1,41,48,0),
			(1,41,49,0),
			(1,41,51,0),
			(1,41,52,0),
			(1,41,53,0),
			(1,41,54,0),
			(1,41,55,0),
			(1,41,56,0),
			(1,41,57,0),
			(1,41,58,0),
			(1,41,59,0),
			(1,41,60,0),
			(1,41,63,0),
			(1,41,65,0),
			(1,41,66,0),
			(1,41,67,1),
			(1,41,68,1),
			(1,41,69,0),
			(1,41,71,0),
			(1,42,0,1),
			(1,42,5,0),
			(1,42,6,0),
			(1,42,8,0),
			(1,42,13,0),
			(1,42,14,0),
			(1,42,15,0),
			(1,42,17,0),
			(1,42,18,0),
			(1,42,19,0),
			(1,42,22,0),
			(1,42,24,0),
			(1,42,25,0),
			(1,42,26,0),
			(1,42,27,0),
			(1,42,28,0),
			(1,42,30,0),
			(1,42,34,0),
			(1,42,36,0),
			(1,42,37,0),
			(1,42,38,0),
			(1,42,39,0),
			(1,42,40,0),
			(1,42,41,0),
			(1,42,42,0),
			(1,42,46,0),
			(1,42,47,0),
			(1,42,48,0),
			(1,42,49,0),
			(1,42,51,0),
			(1,42,52,0),
			(1,42,53,0),
			(1,42,54,0),
			(1,42,55,0),
			(1,42,56,0),
			(1,42,57,0),
			(1,42,58,0),
			(1,42,59,0),
			(1,42,60,0),
			(1,42,63,0),
			(1,42,65,0),
			(1,42,66,0),
			(1,42,67,1),
			(1,42,68,1),
			(1,42,69,0),
			(1,42,71,0),
			(1,43,0,1),
			(1,43,5,0),
			(1,43,6,0),
			(1,43,8,0),
			(1,43,13,0),
			(1,43,14,0),
			(1,43,15,0),
			(1,43,17,0),
			(1,43,18,0),
			(1,43,19,0),
			(1,43,22,0),
			(1,43,24,0),
			(1,43,25,0),
			(1,43,26,0),
			(1,43,27,0),
			(1,43,28,0),
			(1,43,30,0),
			(1,43,34,0),
			(1,43,36,0),
			(1,43,37,0),
			(1,43,38,0),
			(1,43,39,0),
			(1,43,40,0),
			(1,43,41,0),
			(1,43,42,0),
			(1,43,46,0),
			(1,43,47,0),
			(1,43,48,0),
			(1,43,49,0),
			(1,43,51,0),
			(1,43,52,0),
			(1,43,53,0),
			(1,43,54,0),
			(1,43,55,0),
			(1,43,56,0),
			(1,43,57,0),
			(1,43,58,0),
			(1,43,59,0),
			(1,43,60,0),
			(1,43,63,0),
			(1,43,65,0),
			(1,43,66,0),
			(1,43,67,1),
			(1,43,68,1),
			(1,43,69,0),
			(1,43,71,0),
			(1,45,5,0),
			(1,45,6,0),
			(1,45,8,0),
			(1,45,14,0),
			(1,45,15,0),
			(1,45,17,0),
			(1,45,18,0),
			(1,45,19,0),
			(1,45,22,0),
			(1,45,24,0),
			(1,45,25,0),
			(1,45,26,0),
			(1,45,27,0),
			(1,45,28,0),
			(1,45,34,0),
			(1,45,36,0),
			(1,45,37,0),
			(1,45,38,0),
			(1,45,39,0),
			(1,45,40,0),
			(1,45,41,0),
			(1,45,42,0),
			(1,45,46,0),
			(1,45,47,0),
			(1,45,48,0),
			(1,45,49,0),
			(1,45,51,0),
			(1,45,52,0),
			(1,45,53,0),
			(1,45,54,0),
			(1,45,55,0),
			(1,45,56,0),
			(1,45,57,0),
			(1,45,58,0),
			(1,45,59,0),
			(1,45,60,0),
			(1,45,63,0),
			(1,45,65,0),
			(1,45,66,0),
			(1,45,67,1),
			(1,45,68,1),
			(1,45,69,1),
			(1,45,71,1),
			(1,51,0,1),
			(1,51,5,0),
			(1,51,6,0),
			(1,51,8,0),
			(1,51,13,0),
			(1,51,14,0),
			(1,51,15,0),
			(1,51,17,0),
			(1,51,18,0),
			(1,51,19,0),
			(1,51,22,0),
			(1,51,24,0),
			(1,51,25,0),
			(1,51,26,0),
			(1,51,27,0),
			(1,51,28,0),
			(1,51,30,0),
			(1,51,34,0),
			(1,51,36,0),
			(1,51,37,0),
			(1,51,38,0),
			(1,51,39,0),
			(1,51,40,0),
			(1,51,41,0),
			(1,51,42,0),
			(1,51,46,0),
			(1,51,47,0),
			(1,51,48,0),
			(1,51,49,0),
			(1,51,51,0),
			(1,51,52,0),
			(1,51,53,0),
			(1,51,54,0),
			(1,51,55,0),
			(1,51,56,0),
			(1,51,57,0),
			(1,51,58,0),
			(1,51,59,0),
			(1,51,60,0),
			(1,51,63,0),
			(1,51,65,0),
			(1,51,66,0),
			(1,51,67,1),
			(1,51,68,1),
			(1,51,69,0),
			(1,51,71,0),
			(1,51,73,0),
			(1,51,74,0),
			(1,54,0,1),
			(1,54,5,0),
			(1,54,6,0),
			(1,54,13,0),
			(1,54,14,0),
			(1,54,15,0),
			(1,54,17,0),
			(1,54,18,0),
			(1,54,19,0),
			(1,54,22,0),
			(1,54,26,0),
			(1,54,27,0),
			(1,54,34,0),
			(1,54,35,0),
			(1,54,38,0),
			(1,54,41,0),
			(1,54,42,0),
			(1,54,46,0),
			(1,54,48,0),
			(1,54,49,0),
			(1,54,52,0),
			(1,54,53,0),
			(1,54,54,0),
			(1,54,55,0),
			(1,54,56,0),
			(1,54,57,0),
			(1,54,58,0),
			(1,54,59,0),
			(1,54,60,0),
			(1,54,69,0),
			(1,54,71,0),
			(1,57,0,0),
			(1,57,5,0),
			(1,57,6,0),
			(1,57,8,0),
			(1,57,13,0),
			(1,57,14,0),
			(1,57,15,0),
			(1,57,17,0),
			(1,57,18,0),
			(1,57,19,0),
			(1,57,22,0),
			(1,57,24,0),
			(1,57,25,0),
			(1,57,26,0),
			(1,57,27,0),
			(1,57,28,0),
			(1,57,30,0),
			(1,57,34,0),
			(1,57,36,0),
			(1,57,37,0),
			(1,57,38,0),
			(1,57,39,0),
			(1,57,40,0),
			(1,57,41,0),
			(1,57,42,0),
			(1,57,46,0),
			(1,57,47,0),
			(1,57,48,0),
			(1,57,49,0),
			(1,57,51,0),
			(1,57,52,0),
			(1,57,53,0),
			(1,57,54,0),
			(1,57,55,0),
			(1,57,56,0),
			(1,57,57,0),
			(1,57,58,0),
			(1,57,59,0),
			(1,57,60,0),
			(1,57,63,0),
			(1,57,65,0),
			(1,57,66,0),
			(1,57,67,1),
			(1,57,68,1),
			(1,57,69,0),
			(1,57,71,0),
			(1,58,0,0),
			(1,58,5,0),
			(1,58,6,0),
			(1,58,8,0),
			(1,58,13,0),
			(1,58,14,0),
			(1,58,15,0),
			(1,58,17,0),
			(1,58,18,0),
			(1,58,19,0),
			(1,58,22,0),
			(1,58,24,0),
			(1,58,25,0),
			(1,58,26,0),
			(1,58,27,0),
			(1,58,28,0),
			(1,58,30,0),
			(1,58,34,0),
			(1,58,36,0),
			(1,58,37,0),
			(1,58,38,0),
			(1,58,39,0),
			(1,58,40,0),
			(1,58,41,0),
			(1,58,42,0),
			(1,58,46,0),
			(1,58,47,0),
			(1,58,48,0),
			(1,58,49,0),
			(1,58,51,0),
			(1,58,52,0),
			(1,58,53,0),
			(1,58,54,0),
			(1,58,55,0),
			(1,58,56,0),
			(1,58,57,0),
			(1,58,58,0),
			(1,58,59,0),
			(1,58,60,0),
			(1,58,63,0),
			(1,58,65,0),
			(1,58,66,0),
			(1,58,67,1),
			(1,58,68,1),
			(1,58,69,0),
			(1,58,71,0),
			(1,59,0,0),
			(1,59,5,0),
			(1,59,6,0),
			(1,59,8,0),
			(1,59,13,0),
			(1,59,14,0),
			(1,59,15,0),
			(1,59,17,0),
			(1,59,18,0),
			(1,59,19,0),
			(1,59,22,0),
			(1,59,24,0),
			(1,59,25,0),
			(1,59,26,0),
			(1,59,27,0),
			(1,59,28,0),
			(1,59,30,0),
			(1,59,34,0),
			(1,59,36,0),
			(1,59,37,0),
			(1,59,38,0),
			(1,59,39,0),
			(1,59,40,0),
			(1,59,41,0),
			(1,59,42,0),
			(1,59,46,0),
			(1,59,47,0),
			(1,59,48,0),
			(1,59,49,0),
			(1,59,51,0),
			(1,59,52,0),
			(1,59,53,0),
			(1,59,54,0),
			(1,59,55,0),
			(1,59,56,0),
			(1,59,57,0),
			(1,59,58,0),
			(1,59,59,0),
			(1,59,60,0),
			(1,59,63,0),
			(1,59,65,0),
			(1,59,66,0),
			(1,59,67,1),
			(1,59,68,1),
			(1,59,69,0),
			(1,59,71,0),
			(1,61,0,1),
			(1,61,5,0),
			(1,61,6,0),
			(1,61,8,0),
			(1,61,13,0),
			(1,61,14,0),
			(1,61,15,0),
			(1,61,17,0),
			(1,61,18,0),
			(1,61,19,0),
			(1,61,21,0),
			(1,61,22,0),
			(1,61,24,0),
			(1,61,25,0),
			(1,61,26,0),
			(1,61,27,0),
			(1,61,28,0),
			(1,61,30,0),
			(1,61,34,0),
			(1,61,36,0),
			(1,61,37,0),
			(1,61,38,0),
			(1,61,39,0),
			(1,61,40,0),
			(1,61,41,0),
			(1,61,42,0),
			(1,61,46,0),
			(1,61,47,0),
			(1,61,48,0),
			(1,61,49,0),
			(1,61,51,0),
			(1,61,52,0),
			(1,61,53,0),
			(1,61,54,0),
			(1,61,55,0),
			(1,61,56,0),
			(1,61,57,0),
			(1,61,58,0),
			(1,61,59,0),
			(1,61,60,0),
			(1,61,63,0),
			(1,61,65,0),
			(1,61,66,0),
			(1,61,67,1),
			(1,61,68,1),
			(1,61,69,0),
			(1,61,71,0),
			(1,74,0,1),
			(1,74,5,0),
			(1,74,6,0),
			(1,74,8,0),
			(1,74,13,0),
			(1,74,14,0),
			(1,74,17,0),
			(1,74,18,0),
			(1,74,19,0),
			(1,74,22,0),
			(1,74,26,0),
			(1,74,27,0),
			(1,74,28,0),
			(1,74,34,0),
			(1,74,38,0),
			(1,74,41,0),
			(1,74,42,0),
			(1,74,46,0),
			(1,74,48,0),
			(1,74,49,0),
			(1,74,52,0),
			(1,74,53,0),
			(1,74,54,0),
			(1,74,55,0),
			(1,74,56,0),
			(1,74,57,0),
			(1,74,58,0),
			(1,74,59,0),
			(1,74,60,0),
			(1,74,69,0),
			(1,74,71,0),
			(1,75,0,0),
			(1,75,5,0),
			(1,75,6,0),
			(1,75,8,0),
			(1,75,13,0),
			(1,75,14,0),
			(1,75,15,0),
			(1,75,17,0),
			(1,75,18,0),
			(1,75,19,0),
			(1,75,22,0),
			(1,75,24,0),
			(1,75,25,0),
			(1,75,26,0),
			(1,75,27,0),
			(1,75,28,0),
			(1,75,30,0),
			(1,75,34,0),
			(1,75,36,0),
			(1,75,37,0),
			(1,75,38,0),
			(1,75,39,0),
			(1,75,40,0),
			(1,75,41,0),
			(1,75,42,0),
			(1,75,46,0),
			(1,75,47,0),
			(1,75,48,0),
			(1,75,49,0),
			(1,75,51,0),
			(1,75,52,0),
			(1,75,53,0),
			(1,75,54,0),
			(1,75,55,0),
			(1,75,56,0),
			(1,75,57,0),
			(1,75,58,0),
			(1,75,59,0),
			(1,75,60,0),
			(1,75,63,0),
			(1,75,65,0),
			(1,75,66,0),
			(1,75,67,1),
			(1,75,68,1),
			(1,75,69,0),
			(1,75,71,0),
			(1,78,0,0),
			(1,78,5,0),
			(1,78,6,0),
			(1,78,8,0),
			(1,78,13,0),
			(1,78,14,0),
			(1,78,15,0),
			(1,78,17,0),
			(1,78,18,0),
			(1,78,19,0),
			(1,78,22,0),
			(1,78,24,0),
			(1,78,25,0),
			(1,78,26,0),
			(1,78,27,0),
			(1,78,28,0),
			(1,78,30,0),
			(1,78,34,0),
			(1,78,36,0),
			(1,78,37,0),
			(1,78,38,0),
			(1,78,39,0),
			(1,78,40,0),
			(1,78,41,0),
			(1,78,42,0),
			(1,78,46,0),
			(1,78,47,0),
			(1,78,48,0),
			(1,78,49,0),
			(1,78,51,0),
			(1,78,52,0),
			(1,78,53,0),
			(1,78,54,0),
			(1,78,55,0),
			(1,78,56,0),
			(1,78,57,0),
			(1,78,58,0),
			(1,78,59,0),
			(1,78,60,0),
			(1,78,63,0),
			(1,78,65,0),
			(1,78,66,0),
			(1,78,67,1),
			(1,78,68,1),
			(1,78,69,0),
			(1,78,71,0),
			(1,79,0,1),
			(1,79,5,0),
			(1,79,6,0),
			(1,79,8,0),
			(1,79,13,0),
			(1,79,14,0),
			(1,79,15,0),
			(1,79,17,0),
			(1,79,18,0),
			(1,79,19,0),
			(1,79,22,0),
			(1,79,24,0),
			(1,79,25,0),
			(1,79,26,0),
			(1,79,27,0),
			(1,79,28,0),
			(1,79,30,0),
			(1,79,34,0),
			(1,79,36,0),
			(1,79,37,0),
			(1,79,38,0),
			(1,79,39,0),
			(1,79,40,0),
			(1,79,41,0),
			(1,79,42,0),
			(1,79,46,0),
			(1,79,47,0),
			(1,79,48,0),
			(1,79,49,0),
			(1,79,51,0),
			(1,79,52,0),
			(1,79,53,0),
			(1,79,54,0),
			(1,79,55,0),
			(1,79,56,0),
			(1,79,57,0),
			(1,79,58,0),
			(1,79,59,0),
			(1,79,60,0),
			(1,79,63,0),
			(1,79,65,0),
			(1,79,66,0),
			(1,79,67,1),
			(1,79,68,1),
			(1,79,69,0),
			(1,79,71,0),
			(1,80,0,1),
			(1,80,5,0),
			(1,80,6,0),
			(1,80,8,0),
			(1,80,13,0),
			(1,80,14,0),
			(1,80,15,0),
			(1,80,17,0),
			(1,80,18,0),
			(1,80,19,0),
			(1,80,22,0),
			(1,80,24,0),
			(1,80,25,0),
			(1,80,26,0),
			(1,80,27,0),
			(1,80,28,0),
			(1,80,30,0),
			(1,80,34,0),
			(1,80,36,0),
			(1,80,37,0),
			(1,80,38,0),
			(1,80,39,0),
			(1,80,40,0),
			(1,80,41,0),
			(1,80,42,0),
			(1,80,46,0),
			(1,80,47,0),
			(1,80,48,0),
			(1,80,49,0),
			(1,80,51,0),
			(1,80,52,0),
			(1,80,53,0),
			(1,80,54,0),
			(1,80,55,0),
			(1,80,56,0),
			(1,80,57,0),
			(1,80,58,0),
			(1,80,59,0),
			(1,80,60,0),
			(1,80,63,0),
			(1,80,65,0),
			(1,80,66,0),
			(1,80,67,1),
			(1,80,68,1),
			(1,80,69,0),
			(1,80,71,0),
			(1,81,0,1),
			(1,81,5,0),
			(1,81,6,0),
			(1,81,8,0),
			(1,81,13,0),
			(1,81,14,0),
			(1,81,15,0),
			(1,81,17,0),
			(1,81,18,0),
			(1,81,19,0),
			(1,81,22,0),
			(1,81,24,0),
			(1,81,25,0),
			(1,81,26,0),
			(1,81,27,0),
			(1,81,28,0),
			(1,81,30,0),
			(1,81,34,0),
			(1,81,36,0),
			(1,81,37,0),
			(1,81,38,0),
			(1,81,39,0),
			(1,81,40,0),
			(1,81,41,0),
			(1,81,42,0),
			(1,81,46,0),
			(1,81,47,0),
			(1,81,48,0),
			(1,81,49,0),
			(1,81,51,0),
			(1,81,52,0),
			(1,81,53,0),
			(1,81,54,0),
			(1,81,55,0),
			(1,81,56,0),
			(1,81,57,0),
			(1,81,58,0),
			(1,81,59,0),
			(1,81,60,0),
			(1,81,63,0),
			(1,81,65,0),
			(1,81,66,0),
			(1,81,67,1),
			(1,81,68,1),
			(1,81,69,0),
			(1,81,71,0),
			(1,82,0,1),
			(1,82,5,0),
			(1,82,6,0),
			(1,82,8,0),
			(1,82,13,0),
			(1,82,14,0),
			(1,82,15,0),
			(1,82,17,0),
			(1,82,18,0),
			(1,82,19,0),
			(1,82,22,0),
			(1,82,24,0),
			(1,82,25,0),
			(1,82,26,0),
			(1,82,27,0),
			(1,82,28,0),
			(1,82,30,0),
			(1,82,34,0),
			(1,82,36,0),
			(1,82,37,0),
			(1,82,38,0),
			(1,82,39,0),
			(1,82,40,0),
			(1,82,41,0),
			(1,82,42,0),
			(1,82,46,0),
			(1,82,47,0),
			(1,82,48,0),
			(1,82,49,0),
			(1,82,51,0),
			(1,82,52,0),
			(1,82,53,0),
			(1,82,54,0),
			(1,82,55,0),
			(1,82,56,0),
			(1,82,57,0),
			(1,82,58,0),
			(1,82,59,0),
			(1,82,60,0),
			(1,82,63,0),
			(1,82,65,0),
			(1,82,66,0),
			(1,82,67,1),
			(1,82,68,1),
			(1,82,69,0),
			(1,82,71,0),
			(1,83,0,1),
			(1,83,5,0),
			(1,83,6,0),
			(1,83,8,0),
			(1,83,13,0),
			(1,83,14,0),
			(1,83,15,0),
			(1,83,17,0),
			(1,83,18,0),
			(1,83,19,0),
			(1,83,22,0),
			(1,83,24,0),
			(1,83,25,0),
			(1,83,26,0),
			(1,83,27,0),
			(1,83,28,0),
			(1,83,30,0),
			(1,83,34,0),
			(1,83,36,0),
			(1,83,37,0),
			(1,83,38,0),
			(1,83,39,0),
			(1,83,40,0),
			(1,83,41,0),
			(1,83,42,0),
			(1,83,46,0),
			(1,83,47,0),
			(1,83,48,0),
			(1,83,49,0),
			(1,83,51,0),
			(1,83,52,0),
			(1,83,53,0),
			(1,83,54,0),
			(1,83,55,0),
			(1,83,56,0),
			(1,83,57,0),
			(1,83,58,0),
			(1,83,59,0),
			(1,83,60,0),
			(1,83,63,0),
			(1,83,65,0),
			(1,83,66,0),
			(1,83,67,1),
			(1,83,68,1),
			(1,83,69,0),
			(1,83,71,0),
			(1,84,0,0),
			(1,84,5,0),
			(1,84,6,0),
			(1,84,8,0),
			(1,84,13,0),
			(1,84,14,0),
			(1,84,15,0),
			(1,84,17,0),
			(1,84,18,0),
			(1,84,19,0),
			(1,84,22,0),
			(1,84,24,0),
			(1,84,25,0),
			(1,84,26,0),
			(1,84,27,0),
			(1,84,28,0),
			(1,84,30,0),
			(1,84,34,0),
			(1,84,36,0),
			(1,84,37,0),
			(1,84,38,0),
			(1,84,39,0),
			(1,84,40,0),
			(1,84,41,0),
			(1,84,42,0),
			(1,84,46,0),
			(1,84,47,0),
			(1,84,48,0),
			(1,84,49,0),
			(1,84,51,0),
			(1,84,52,0),
			(1,84,53,0),
			(1,84,54,0),
			(1,84,55,0),
			(1,84,56,0),
			(1,84,57,0),
			(1,84,58,0),
			(1,84,59,0),
			(1,84,60,0),
			(1,84,63,0),
			(1,84,65,0),
			(1,84,66,0),
			(1,84,67,1),
			(1,84,68,1),
			(1,84,69,0),
			(1,84,71,0),
			(1,84,73,0),
			(1,84,74,0),
			(1,85,0,1),
			(1,85,5,0),
			(1,85,6,0),
			(1,85,8,0),
			(1,85,13,0),
			(1,85,14,0),
			(1,85,15,0),
			(1,85,17,0),
			(1,85,18,0),
			(1,85,19,0),
			(1,85,22,0),
			(1,85,24,0),
			(1,85,25,0),
			(1,85,26,0),
			(1,85,27,0),
			(1,85,28,0),
			(1,85,30,0),
			(1,85,34,0),
			(1,85,36,0),
			(1,85,37,0),
			(1,85,38,0),
			(1,85,39,0),
			(1,85,40,0),
			(1,85,41,0),
			(1,85,42,0),
			(1,85,46,0),
			(1,85,47,0),
			(1,85,48,0),
			(1,85,49,0),
			(1,85,51,0),
			(1,85,52,0),
			(1,85,53,0),
			(1,85,54,0),
			(1,85,55,0),
			(1,85,56,0),
			(1,85,57,0),
			(1,85,58,0),
			(1,85,59,0),
			(1,85,60,0),
			(1,85,63,0),
			(1,85,65,0),
			(1,85,66,0),
			(1,85,67,1),
			(1,85,68,1),
			(1,85,69,0),
			(1,85,71,0),
			(1,86,0,1),
			(1,86,5,0),
			(1,86,6,0),
			(1,86,8,0),
			(1,86,13,0),
			(1,86,14,0),
			(1,86,15,0),
			(1,86,17,0),
			(1,86,18,0),
			(1,86,19,0),
			(1,86,22,0),
			(1,86,24,0),
			(1,86,25,0),
			(1,86,26,0),
			(1,86,27,0),
			(1,86,28,0),
			(1,86,30,0),
			(1,86,34,0),
			(1,86,36,0),
			(1,86,37,0),
			(1,86,38,0),
			(1,86,39,0),
			(1,86,40,0),
			(1,86,41,0),
			(1,86,42,0),
			(1,86,46,0),
			(1,86,47,0),
			(1,86,48,0),
			(1,86,49,0),
			(1,86,51,0),
			(1,86,52,0),
			(1,86,53,0),
			(1,86,54,0),
			(1,86,55,0),
			(1,86,56,0),
			(1,86,57,0),
			(1,86,58,0),
			(1,86,59,0),
			(1,86,60,0),
			(1,86,63,0),
			(1,86,65,0),
			(1,86,66,0),
			(1,86,67,1),
			(1,86,68,1),
			(1,86,69,0),
			(1,86,71,0),
			(1,87,0,1),
			(1,87,5,0),
			(1,87,6,0),
			(1,87,8,0),
			(1,87,13,0),
			(1,87,14,0),
			(1,87,15,0),
			(1,87,17,0),
			(1,87,18,0),
			(1,87,19,0),
			(1,87,22,0),
			(1,87,24,0),
			(1,87,25,0),
			(1,87,26,0),
			(1,87,27,0),
			(1,87,28,0),
			(1,87,30,0),
			(1,87,34,0),
			(1,87,36,0),
			(1,87,37,0),
			(1,87,38,0),
			(1,87,39,0),
			(1,87,40,0),
			(1,87,41,0),
			(1,87,42,0),
			(1,87,46,0),
			(1,87,47,0),
			(1,87,48,0),
			(1,87,49,0),
			(1,87,51,0),
			(1,87,52,0),
			(1,87,53,0),
			(1,87,54,0),
			(1,87,55,0),
			(1,87,56,0),
			(1,87,57,0),
			(1,87,58,0),
			(1,87,59,0),
			(1,87,60,0),
			(1,87,61,0),
			(1,87,63,0),
			(1,87,65,0),
			(1,87,66,0),
			(1,87,67,1),
			(1,87,68,1),
			(1,87,69,0),
			(1,87,71,0),
			(1,88,0,1),
			(1,88,5,0),
			(1,88,6,0),
			(1,88,8,0),
			(1,88,13,0),
			(1,88,14,0),
			(1,88,15,0),
			(1,88,17,0),
			(1,88,18,0),
			(1,88,19,0),
			(1,88,22,0),
			(1,88,24,0),
			(1,88,25,0),
			(1,88,26,0),
			(1,88,27,0),
			(1,88,28,0),
			(1,88,30,0),
			(1,88,34,0),
			(1,88,36,0),
			(1,88,37,0),
			(1,88,38,0),
			(1,88,39,0),
			(1,88,40,0),
			(1,88,41,0),
			(1,88,42,0),
			(1,88,46,0),
			(1,88,47,0),
			(1,88,48,0),
			(1,88,49,0),
			(1,88,51,0),
			(1,88,52,0),
			(1,88,53,0),
			(1,88,54,0),
			(1,88,55,0),
			(1,88,56,0),
			(1,88,57,0),
			(1,88,58,0),
			(1,88,59,0),
			(1,88,60,0),
			(1,88,61,0),
			(1,88,63,0),
			(1,88,65,0),
			(1,88,66,0),
			(1,88,67,1),
			(1,88,68,1),
			(1,88,69,0),
			(1,88,71,0),
			(1,89,0,1),
			(1,89,5,0),
			(1,89,6,0),
			(1,89,8,0),
			(1,89,13,0),
			(1,89,14,0),
			(1,89,15,0),
			(1,89,17,0),
			(1,89,18,0),
			(1,89,19,0),
			(1,89,22,0),
			(1,89,24,0),
			(1,89,25,0),
			(1,89,26,0),
			(1,89,27,0),
			(1,89,28,0),
			(1,89,30,0),
			(1,89,34,0),
			(1,89,36,0),
			(1,89,37,0),
			(1,89,38,0),
			(1,89,39,0),
			(1,89,40,0),
			(1,89,41,0),
			(1,89,42,0),
			(1,89,46,0),
			(1,89,47,0),
			(1,89,48,0),
			(1,89,49,0),
			(1,89,51,0),
			(1,89,52,0),
			(1,89,53,0),
			(1,89,54,0),
			(1,89,55,0),
			(1,89,56,0),
			(1,89,57,0),
			(1,89,58,0),
			(1,89,59,0),
			(1,89,60,0),
			(1,89,61,0),
			(1,89,63,0),
			(1,89,65,0),
			(1,89,66,0),
			(1,89,67,1),
			(1,89,68,1),
			(1,89,69,0),
			(1,89,71,0),
			(1,90,0,1),
			(1,90,5,0),
			(1,90,6,0),
			(1,90,8,0),
			(1,90,13,0),
			(1,90,14,0),
			(1,90,15,0),
			(1,90,17,0),
			(1,90,18,0),
			(1,90,19,0),
			(1,90,22,0),
			(1,90,24,0),
			(1,90,25,0),
			(1,90,26,0),
			(1,90,27,0),
			(1,90,28,0),
			(1,90,30,0),
			(1,90,34,0),
			(1,90,36,0),
			(1,90,37,0),
			(1,90,38,0),
			(1,90,39,0),
			(1,90,40,0),
			(1,90,41,0),
			(1,90,42,0),
			(1,90,46,0),
			(1,90,47,0),
			(1,90,48,0),
			(1,90,49,0),
			(1,90,51,0),
			(1,90,52,0),
			(1,90,53,0),
			(1,90,54,0),
			(1,90,55,0),
			(1,90,56,0),
			(1,90,57,0),
			(1,90,58,0),
			(1,90,59,0),
			(1,90,60,0),
			(1,90,61,0),
			(1,90,63,0),
			(1,90,65,0),
			(1,90,66,0),
			(1,90,67,1),
			(1,90,68,1),
			(1,90,69,0),
			(1,90,71,0),
			(1,91,0,1),
			(1,91,5,0),
			(1,91,6,0),
			(1,91,8,0),
			(1,91,13,0),
			(1,91,14,0),
			(1,91,15,0),
			(1,91,17,0),
			(1,91,18,0),
			(1,91,19,0),
			(1,91,22,0),
			(1,91,24,0),
			(1,91,25,0),
			(1,91,26,0),
			(1,91,27,0),
			(1,91,28,0),
			(1,91,30,0),
			(1,91,34,0),
			(1,91,36,0),
			(1,91,37,0),
			(1,91,38,0),
			(1,91,39,0),
			(1,91,40,0),
			(1,91,41,0),
			(1,91,42,0),
			(1,91,46,0),
			(1,91,47,0),
			(1,91,48,0),
			(1,91,49,0),
			(1,91,51,0),
			(1,91,52,0),
			(1,91,53,0),
			(1,91,54,0),
			(1,91,55,0),
			(1,91,56,0),
			(1,91,57,0),
			(1,91,58,0),
			(1,91,59,0),
			(1,91,60,0),
			(1,91,61,0),
			(1,91,63,0),
			(1,91,65,0),
			(1,91,66,0),
			(1,91,67,1),
			(1,91,68,1),
			(1,91,69,0),
			(1,91,71,0),
			(1,92,0,0),
			(1,92,5,0),
			(1,92,6,0),
			(1,92,8,0),
			(1,92,13,0),
			(1,92,14,0),
			(1,92,15,0),
			(1,92,17,0),
			(1,92,18,0),
			(1,92,19,0),
			(1,92,20,0),
			(1,92,21,0),
			(1,92,22,0),
			(1,92,24,0),
			(1,92,25,0),
			(1,92,26,0),
			(1,92,27,0),
			(1,92,28,0),
			(1,92,30,0),
			(1,92,34,0),
			(1,92,36,0),
			(1,92,37,0),
			(1,92,38,0),
			(1,92,39,0),
			(1,92,40,0),
			(1,92,41,0),
			(1,92,42,0),
			(1,92,46,0),
			(1,92,47,0),
			(1,92,48,0),
			(1,92,49,0),
			(1,92,51,0),
			(1,92,52,0),
			(1,92,53,0),
			(1,92,54,0),
			(1,92,55,0),
			(1,92,56,0),
			(1,92,57,0),
			(1,92,58,0),
			(1,92,59,0),
			(1,92,60,0),
			(1,92,63,0),
			(1,92,65,0),
			(1,92,66,0),
			(1,92,67,1),
			(1,92,68,1),
			(1,92,69,0),
			(1,92,71,0),
			(1,93,0,0),
			(1,93,5,0),
			(1,93,6,0),
			(1,93,8,0),
			(1,93,13,0),
			(1,93,14,0),
			(1,93,15,0),
			(1,93,17,0),
			(1,93,18,0),
			(1,93,19,0),
			(1,93,20,0),
			(1,93,21,0),
			(1,93,22,0),
			(1,93,24,0),
			(1,93,25,0),
			(1,93,26,0),
			(1,93,27,0),
			(1,93,28,0),
			(1,93,30,0),
			(1,93,34,0),
			(1,93,36,0),
			(1,93,37,0),
			(1,93,38,0),
			(1,93,39,0),
			(1,93,40,0),
			(1,93,41,0),
			(1,93,42,0),
			(1,93,46,0),
			(1,93,47,0),
			(1,93,48,0),
			(1,93,49,0),
			(1,93,51,0),
			(1,93,52,0),
			(1,93,53,0),
			(1,93,54,0),
			(1,93,55,0),
			(1,93,56,0),
			(1,93,57,0),
			(1,93,58,0),
			(1,93,59,0),
			(1,93,60,0),
			(1,93,63,0),
			(1,93,65,0),
			(1,93,66,0),
			(1,93,67,1),
			(1,93,68,1),
			(1,93,69,0),
			(1,93,71,0),
			(1,94,0,1),
			(1,94,5,0),
			(1,94,6,0),
			(1,94,8,0),
			(1,94,13,0),
			(1,94,14,0),
			(1,94,15,0),
			(1,94,17,0),
			(1,94,18,0),
			(1,94,19,0),
			(1,94,22,0),
			(1,94,24,0),
			(1,94,25,0),
			(1,94,26,0),
			(1,94,27,0),
			(1,94,28,0),
			(1,94,34,0),
			(1,94,36,0),
			(1,94,37,0),
			(1,94,38,0),
			(1,94,39,0),
			(1,94,40,0),
			(1,94,41,0),
			(1,94,42,0),
			(1,94,46,0),
			(1,94,47,0),
			(1,94,48,0),
			(1,94,49,0),
			(1,94,51,0),
			(1,94,52,0),
			(1,94,53,0),
			(1,94,54,0),
			(1,94,55,0),
			(1,94,56,0),
			(1,94,57,0),
			(1,94,58,0),
			(1,94,59,0),
			(1,94,60,0),
			(1,94,63,0),
			(1,94,65,0),
			(1,94,66,0),
			(1,94,67,1),
			(1,94,68,1),
			(1,94,69,0),
			(1,94,71,0),
			(1,95,0,1),
			(1,95,5,0),
			(1,95,6,0),
			(1,95,8,0),
			(1,95,13,0),
			(1,95,14,0),
			(1,95,15,0),
			(1,95,17,0),
			(1,95,18,0),
			(1,95,19,0),
			(1,95,22,0),
			(1,95,24,0),
			(1,95,25,0),
			(1,95,26,0),
			(1,95,27,0),
			(1,95,28,0),
			(1,95,34,0),
			(1,95,36,0),
			(1,95,37,0),
			(1,95,38,0),
			(1,95,39,0),
			(1,95,40,0),
			(1,95,41,0),
			(1,95,42,0),
			(1,95,46,0),
			(1,95,47,0),
			(1,95,48,0),
			(1,95,49,0),
			(1,95,51,0),
			(1,95,52,0),
			(1,95,53,0),
			(1,95,54,0),
			(1,95,55,0),
			(1,95,56,0),
			(1,95,57,0),
			(1,95,58,0),
			(1,95,59,0),
			(1,95,60,0),
			(1,95,61,0),
			(1,95,63,0),
			(1,95,65,0),
			(1,95,66,0),
			(1,95,67,1),
			(1,95,68,1),
			(1,95,69,0),
			(1,95,71,0),
			(1,96,0,1),
			(1,96,5,0),
			(1,96,6,0),
			(1,96,8,0),
			(1,96,13,0),
			(1,96,14,0),
			(1,96,15,0),
			(1,96,17,0),
			(1,96,18,0),
			(1,96,19,0),
			(1,96,22,0),
			(1,96,24,0),
			(1,96,25,0),
			(1,96,26,0),
			(1,96,27,0),
			(1,96,28,0),
			(1,96,34,0),
			(1,96,36,0),
			(1,96,37,0),
			(1,96,38,0),
			(1,96,39,0),
			(1,96,40,0),
			(1,96,41,0),
			(1,96,42,0),
			(1,96,46,0),
			(1,96,47,0),
			(1,96,48,0),
			(1,96,49,0),
			(1,96,51,0),
			(1,96,52,0),
			(1,96,53,0),
			(1,96,54,0),
			(1,96,55,0),
			(1,96,56,0),
			(1,96,57,0),
			(1,96,58,0),
			(1,96,59,0),
			(1,96,60,0),
			(1,96,63,0),
			(1,96,65,0),
			(1,96,66,0),
			(1,96,67,1),
			(1,96,68,1),
			(1,96,69,0),
			(1,96,71,0),
			(1,97,0,0),
			(1,97,5,0),
			(1,97,6,0),
			(1,97,8,0),
			(1,97,13,0),
			(1,97,14,0),
			(1,97,15,0),
			(1,97,17,0),
			(1,97,18,0),
			(1,97,19,0),
			(1,97,22,0),
			(1,97,24,0),
			(1,97,25,0),
			(1,97,26,0),
			(1,97,27,0),
			(1,97,28,0),
			(1,97,34,0),
			(1,97,36,0),
			(1,97,37,0),
			(1,97,38,0),
			(1,97,39,0),
			(1,97,40,0),
			(1,97,41,0),
			(1,97,42,0),
			(1,97,46,0),
			(1,97,47,0),
			(1,97,48,0),
			(1,97,49,0),
			(1,97,51,0),
			(1,97,52,0),
			(1,97,53,0),
			(1,97,54,0),
			(1,97,55,0),
			(1,97,56,0),
			(1,97,57,0),
			(1,97,58,0),
			(1,97,59,0),
			(1,97,60,0),
			(1,97,62,0),
			(1,97,63,0),
			(1,97,65,0),
			(1,97,66,0),
			(1,97,67,1),
			(1,97,68,1),
			(1,97,69,0),
			(1,97,71,0),
			(1,98,0,0),
			(1,98,5,0),
			(1,98,6,0),
			(1,98,8,0),
			(1,98,13,0),
			(1,98,14,0),
			(1,98,15,0),
			(1,98,17,0),
			(1,98,18,0),
			(1,98,19,0),
			(1,98,22,0),
			(1,98,24,0),
			(1,98,25,0),
			(1,98,26,0),
			(1,98,27,0),
			(1,98,28,0),
			(1,98,34,0),
			(1,98,36,0),
			(1,98,37,0),
			(1,98,38,0),
			(1,98,39,0),
			(1,98,40,0),
			(1,98,41,0),
			(1,98,42,0),
			(1,98,46,0),
			(1,98,47,0),
			(1,98,48,0),
			(1,98,49,0),
			(1,98,51,0),
			(1,98,52,0),
			(1,98,53,0),
			(1,98,54,0),
			(1,98,55,0),
			(1,98,56,0),
			(1,98,57,0),
			(1,98,58,0),
			(1,98,59,0),
			(1,98,60,0),
			(1,98,61,0),
			(1,98,63,0),
			(1,98,65,0),
			(1,98,66,0),
			(1,98,67,1),
			(1,98,68,1),
			(1,98,69,0),
			(1,98,71,0),
			(1,99,0,1),
			(1,99,5,0),
			(1,99,6,0),
			(1,99,8,0),
			(1,99,13,0),
			(1,99,14,0),
			(1,99,15,0),
			(1,99,17,0),
			(1,99,18,0),
			(1,99,19,0),
			(1,99,22,0),
			(1,99,24,0),
			(1,99,25,0),
			(1,99,26,0),
			(1,99,27,0),
			(1,99,28,0),
			(1,99,34,0),
			(1,99,36,0),
			(1,99,37,0),
			(1,99,38,0),
			(1,99,39,0),
			(1,99,40,0),
			(1,99,41,0),
			(1,99,42,0),
			(1,99,46,0),
			(1,99,47,0),
			(1,99,48,0),
			(1,99,49,0),
			(1,99,51,0),
			(1,99,52,0),
			(1,99,53,0),
			(1,99,54,0),
			(1,99,55,0),
			(1,99,56,0),
			(1,99,57,0),
			(1,99,58,0),
			(1,99,59,0),
			(1,99,60,0),
			(1,99,61,0),
			(1,99,63,0),
			(1,99,65,0),
			(1,99,66,0),
			(1,99,67,1),
			(1,99,68,1),
			(1,99,69,0),
			(1,99,71,0),
			(1,100,0,0),
			(1,100,5,0),
			(1,100,6,0),
			(1,100,8,0),
			(1,100,13,0),
			(1,100,14,0),
			(1,100,15,0),
			(1,100,17,0),
			(1,100,18,0),
			(1,100,19,0),
			(1,100,22,0),
			(1,100,24,0),
			(1,100,25,0),
			(1,100,26,0),
			(1,100,27,0),
			(1,100,28,0),
			(1,100,34,0),
			(1,100,36,0),
			(1,100,37,0),
			(1,100,38,0),
			(1,100,39,0),
			(1,100,40,0),
			(1,100,41,0),
			(1,100,42,0),
			(1,100,46,0),
			(1,100,47,0),
			(1,100,48,0),
			(1,100,49,0),
			(1,100,51,0),
			(1,100,52,0),
			(1,100,53,0),
			(1,100,54,0),
			(1,100,55,0),
			(1,100,56,0),
			(1,100,57,0),
			(1,100,58,0),
			(1,100,59,0),
			(1,100,60,0),
			(1,100,61,0),
			(1,100,63,0),
			(1,100,65,0),
			(1,100,66,0),
			(1,100,67,1),
			(1,100,68,1),
			(1,100,69,0),
			(1,100,71,0),
			(1,101,0,0),
			(1,101,5,0),
			(1,101,6,0),
			(1,101,8,0),
			(1,101,13,0),
			(1,101,14,0),
			(1,101,15,0),
			(1,101,17,0),
			(1,101,18,0),
			(1,101,19,0),
			(1,101,22,0),
			(1,101,24,0),
			(1,101,25,0),
			(1,101,26,0),
			(1,101,27,0),
			(1,101,28,0),
			(1,101,34,0),
			(1,101,36,0),
			(1,101,37,0),
			(1,101,38,0),
			(1,101,39,0),
			(1,101,40,0),
			(1,101,41,0),
			(1,101,42,0),
			(1,101,46,0),
			(1,101,47,0),
			(1,101,48,0),
			(1,101,49,0),
			(1,101,51,0),
			(1,101,52,0),
			(1,101,53,0),
			(1,101,54,0),
			(1,101,55,0),
			(1,101,56,0),
			(1,101,57,0),
			(1,101,58,0),
			(1,101,59,0),
			(1,101,60,0),
			(1,101,61,0),
			(1,101,63,0),
			(1,101,65,0),
			(1,101,66,0),
			(1,101,67,1),
			(1,101,68,1),
			(1,101,69,0),
			(1,101,71,0),
			(1,102,0,0),
			(1,102,5,0),
			(1,102,6,0),
			(1,102,8,0),
			(1,102,13,0),
			(1,102,14,0),
			(1,102,15,0),
			(1,102,17,0),
			(1,102,18,0),
			(1,102,19,0),
			(1,102,22,0),
			(1,102,24,0),
			(1,102,25,0),
			(1,102,26,0),
			(1,102,27,0),
			(1,102,28,0),
			(1,102,34,0),
			(1,102,36,0),
			(1,102,37,0),
			(1,102,38,0),
			(1,102,39,0),
			(1,102,40,0),
			(1,102,41,0),
			(1,102,42,0),
			(1,102,46,0),
			(1,102,47,0),
			(1,102,48,0),
			(1,102,49,0),
			(1,102,51,0),
			(1,102,52,0),
			(1,102,53,0),
			(1,102,54,0),
			(1,102,55,0),
			(1,102,56,0),
			(1,102,57,0),
			(1,102,58,0),
			(1,102,59,0),
			(1,102,60,0),
			(1,102,61,0),
			(1,102,63,0),
			(1,102,65,0),
			(1,102,66,0),
			(1,102,67,1),
			(1,102,68,1),
			(1,102,69,0),
			(1,102,71,0),
			(1,103,0,0),
			(1,103,5,0),
			(1,103,6,0),
			(1,103,8,0),
			(1,103,13,0),
			(1,103,14,0),
			(1,103,15,0),
			(1,103,17,0),
			(1,103,18,0),
			(1,103,19,0),
			(1,103,22,0),
			(1,103,24,0),
			(1,103,25,0),
			(1,103,26,0),
			(1,103,27,0),
			(1,103,28,0),
			(1,103,34,0),
			(1,103,36,0),
			(1,103,37,0),
			(1,103,38,0),
			(1,103,39,0),
			(1,103,40,0),
			(1,103,41,0),
			(1,103,42,0),
			(1,103,46,0),
			(1,103,47,0),
			(1,103,48,0),
			(1,103,49,0),
			(1,103,51,0),
			(1,103,52,0),
			(1,103,53,0),
			(1,103,54,0),
			(1,103,55,0),
			(1,103,56,0),
			(1,103,57,0),
			(1,103,58,0),
			(1,103,59,0),
			(1,103,60,0),
			(1,103,61,0),
			(1,103,63,0),
			(1,103,65,0),
			(1,103,66,0),
			(1,103,67,1),
			(1,103,68,1),
			(1,103,69,0),
			(1,103,71,0),
			(1,104,0,0),
			(1,104,5,0),
			(1,104,6,0),
			(1,104,8,0),
			(1,104,13,0),
			(1,104,14,0),
			(1,104,15,0),
			(1,104,17,0),
			(1,104,18,0),
			(1,104,19,0),
			(1,104,22,0),
			(1,104,24,0),
			(1,104,25,0),
			(1,104,26,0),
			(1,104,27,0),
			(1,104,28,0),
			(1,104,34,0),
			(1,104,36,0),
			(1,104,37,0),
			(1,104,38,0),
			(1,104,39,0),
			(1,104,40,0),
			(1,104,41,0),
			(1,104,42,0),
			(1,104,46,0),
			(1,104,47,0),
			(1,104,48,0),
			(1,104,49,0),
			(1,104,51,0),
			(1,104,52,0),
			(1,104,53,0),
			(1,104,54,0),
			(1,104,55,0),
			(1,104,56,0),
			(1,104,57,0),
			(1,104,58,0),
			(1,104,59,0),
			(1,104,60,0),
			(1,104,61,0),
			(1,104,63,0),
			(1,104,65,0),
			(1,104,66,0),
			(1,104,67,1),
			(1,104,68,1),
			(1,104,69,0),
			(1,104,71,0),
			(1,105,0,0),
			(1,105,5,0),
			(1,105,6,0),
			(1,105,8,0),
			(1,105,13,0),
			(1,105,14,0),
			(1,105,15,0),
			(1,105,17,0),
			(1,105,18,0),
			(1,105,19,0),
			(1,105,22,0),
			(1,105,24,0),
			(1,105,25,0),
			(1,105,26,0),
			(1,105,27,0),
			(1,105,28,0),
			(1,105,34,0),
			(1,105,36,0),
			(1,105,37,0),
			(1,105,38,0),
			(1,105,39,0),
			(1,105,40,0),
			(1,105,41,0),
			(1,105,42,0),
			(1,105,46,0),
			(1,105,47,0),
			(1,105,48,0),
			(1,105,49,0),
			(1,105,51,0),
			(1,105,52,0),
			(1,105,53,0),
			(1,105,54,0),
			(1,105,55,0),
			(1,105,56,0),
			(1,105,57,0),
			(1,105,58,0),
			(1,105,59,0),
			(1,105,60,0),
			(1,105,63,0),
			(1,105,65,0),
			(1,105,66,0),
			(1,105,67,1),
			(1,105,68,1),
			(1,105,69,0),
			(1,105,71,0),
			(1,106,0,0),
			(1,106,5,0),
			(1,106,6,0),
			(1,106,8,0),
			(1,106,13,0),
			(1,106,14,0),
			(1,106,15,0),
			(1,106,17,0),
			(1,106,18,0),
			(1,106,19,0),
			(1,106,22,0),
			(1,106,24,0),
			(1,106,25,0),
			(1,106,26,0),
			(1,106,27,0),
			(1,106,28,0),
			(1,106,34,0),
			(1,106,36,0),
			(1,106,37,0),
			(1,106,38,0),
			(1,106,39,0),
			(1,106,40,0),
			(1,106,41,0),
			(1,106,42,0),
			(1,106,46,0),
			(1,106,47,0),
			(1,106,48,0),
			(1,106,49,0),
			(1,106,51,0),
			(1,106,52,0),
			(1,106,53,0),
			(1,106,54,0),
			(1,106,55,0),
			(1,106,56,0),
			(1,106,57,0),
			(1,106,58,0),
			(1,106,59,0),
			(1,106,60,0),
			(1,106,61,0),
			(1,106,63,0),
			(1,106,65,0),
			(1,106,66,0),
			(1,106,67,1),
			(1,106,68,1),
			(1,106,69,0),
			(1,106,71,0),
			(1,107,0,1),
			(1,107,5,0),
			(1,107,6,0),
			(1,107,8,0),
			(1,107,13,0),
			(1,107,14,0),
			(1,107,15,0),
			(1,107,17,0),
			(1,107,18,0),
			(1,107,19,0),
			(1,107,22,0),
			(1,107,24,0),
			(1,107,25,0),
			(1,107,26,0),
			(1,107,27,0),
			(1,107,28,0),
			(1,107,34,0),
			(1,107,36,0),
			(1,107,37,0),
			(1,107,38,0),
			(1,107,39,0),
			(1,107,40,0),
			(1,107,41,0),
			(1,107,42,0),
			(1,107,46,0),
			(1,107,47,0),
			(1,107,48,0),
			(1,107,49,0),
			(1,107,51,0),
			(1,107,52,0),
			(1,107,53,0),
			(1,107,54,0),
			(1,107,55,0),
			(1,107,56,0),
			(1,107,57,0),
			(1,107,58,0),
			(1,107,59,0),
			(1,107,60,0),
			(1,107,61,0),
			(1,107,63,0),
			(1,107,65,0),
			(1,107,66,0),
			(1,107,67,1),
			(1,107,68,1),
			(1,107,69,0),
			(1,107,71,0),
			(1,108,0,0),
			(1,108,5,0),
			(1,108,6,0),
			(1,108,8,0),
			(1,108,13,0),
			(1,108,14,0),
			(1,108,15,0),
			(1,108,17,0),
			(1,108,18,0),
			(1,108,19,0),
			(1,108,22,0),
			(1,108,24,0),
			(1,108,25,0),
			(1,108,26,0),
			(1,108,27,0),
			(1,108,28,0),
			(1,108,34,0),
			(1,108,36,0),
			(1,108,37,0),
			(1,108,38,0),
			(1,108,39,0),
			(1,108,40,0),
			(1,108,41,0),
			(1,108,42,0),
			(1,108,46,0),
			(1,108,47,0),
			(1,108,48,0),
			(1,108,49,0),
			(1,108,51,0),
			(1,108,52,0),
			(1,108,53,0),
			(1,108,54,0),
			(1,108,55,0),
			(1,108,56,0),
			(1,108,57,0),
			(1,108,58,0),
			(1,108,59,0),
			(1,108,60,0),
			(1,108,61,0),
			(1,108,63,0),
			(1,108,65,0),
			(1,108,66,0),
			(1,108,67,1),
			(1,108,68,1),
			(1,108,69,0),
			(1,108,71,0),
			(1,109,0,0),
			(1,109,5,0),
			(1,109,6,0),
			(1,109,8,0),
			(1,109,13,0),
			(1,109,14,0),
			(1,109,15,0),
			(1,109,17,0),
			(1,109,18,0),
			(1,109,19,0),
			(1,109,22,0),
			(1,109,24,0),
			(1,109,25,0),
			(1,109,26,0),
			(1,109,27,0),
			(1,109,28,0),
			(1,109,34,0),
			(1,109,36,0),
			(1,109,37,0),
			(1,109,38,0),
			(1,109,39,0),
			(1,109,40,0),
			(1,109,41,0),
			(1,109,42,0),
			(1,109,46,0),
			(1,109,47,0),
			(1,109,48,0),
			(1,109,49,0),
			(1,109,51,0),
			(1,109,52,0),
			(1,109,53,0),
			(1,109,54,0),
			(1,109,55,0),
			(1,109,56,0),
			(1,109,57,0),
			(1,109,58,0),
			(1,109,59,0),
			(1,109,60,0),
			(1,109,61,0),
			(1,109,63,0),
			(1,109,65,0),
			(1,109,66,0),
			(1,109,67,1),
			(1,109,68,1),
			(1,109,69,0),
			(1,109,71,0),
			(1,111,0,1),
			(1,111,5,0),
			(1,111,6,0),
			(1,111,8,0),
			(1,111,13,0),
			(1,111,14,0),
			(1,111,15,0),
			(1,111,17,0),
			(1,111,18,0),
			(1,111,19,0),
			(1,111,22,0),
			(1,111,24,0),
			(1,111,25,0),
			(1,111,26,0),
			(1,111,27,0),
			(1,111,28,0),
			(1,111,30,0),
			(1,111,34,0),
			(1,111,36,0),
			(1,111,37,0),
			(1,111,38,0),
			(1,111,39,0),
			(1,111,40,0),
			(1,111,41,0),
			(1,111,42,0),
			(1,111,46,0),
			(1,111,47,0),
			(1,111,48,0),
			(1,111,49,0),
			(1,111,51,0),
			(1,111,52,0),
			(1,111,53,0),
			(1,111,54,0),
			(1,111,55,0),
			(1,111,56,0),
			(1,111,57,0),
			(1,111,58,0),
			(1,111,59,0),
			(1,111,60,0),
			(1,111,63,0),
			(1,111,65,0),
			(1,111,66,0),
			(1,111,67,1),
			(1,111,68,1),
			(1,111,69,0),
			(1,111,71,0),
			(1,112,0,1),
			(1,112,5,0),
			(1,112,6,0),
			(1,112,8,0),
			(1,112,13,0),
			(1,112,14,0),
			(1,112,15,0),
			(1,112,17,0),
			(1,112,18,0),
			(1,112,19,0),
			(1,112,20,0),
			(1,112,22,0),
			(1,112,24,0),
			(1,112,25,0),
			(1,112,26,0),
			(1,112,27,0),
			(1,112,28,0),
			(1,112,34,0),
			(1,112,36,0),
			(1,112,37,0),
			(1,112,38,0),
			(1,112,39,0),
			(1,112,40,0),
			(1,112,41,0),
			(1,112,42,0),
			(1,112,46,0),
			(1,112,47,0),
			(1,112,48,0),
			(1,112,49,0),
			(1,112,51,0),
			(1,112,52,0),
			(1,112,53,0),
			(1,112,54,0),
			(1,112,55,0),
			(1,112,56,0),
			(1,112,57,0),
			(1,112,58,0),
			(1,112,59,0),
			(1,112,60,0),
			(1,112,63,0),
			(1,112,65,0),
			(1,112,66,0),
			(1,112,67,1),
			(1,112,68,1),
			(1,112,69,0),
			(1,112,71,0),
			(1,113,0,0),
			(1,113,5,0),
			(1,113,6,0),
			(1,113,8,0),
			(1,113,13,0),
			(1,113,14,0),
			(1,113,15,0),
			(1,113,17,0),
			(1,113,18,0),
			(1,113,19,0),
			(1,113,20,0),
			(1,113,22,0),
			(1,113,24,0),
			(1,113,25,0),
			(1,113,26,0),
			(1,113,27,0),
			(1,113,28,0),
			(1,113,34,0),
			(1,113,36,0),
			(1,113,37,0),
			(1,113,38,0),
			(1,113,39,0),
			(1,113,40,0),
			(1,113,41,0),
			(1,113,42,0),
			(1,113,46,0),
			(1,113,47,0),
			(1,113,48,0),
			(1,113,49,0),
			(1,113,51,0),
			(1,113,52,0),
			(1,113,53,0),
			(1,113,54,0),
			(1,113,55,0),
			(1,113,56,0),
			(1,113,57,0),
			(1,113,58,0),
			(1,113,59,0),
			(1,113,60,0),
			(1,113,63,0),
			(1,113,65,0),
			(1,113,66,0),
			(1,113,67,1),
			(1,113,68,1),
			(1,113,69,0),
			(1,113,71,0),
			(1,114,0,1),
			(1,114,5,0),
			(1,114,6,0),
			(1,114,8,0),
			(1,114,13,0),
			(1,114,14,0),
			(1,114,15,0),
			(1,114,17,0),
			(1,114,18,0),
			(1,114,19,0),
			(1,114,20,0),
			(1,114,22,0),
			(1,114,24,0),
			(1,114,25,0),
			(1,114,26,0),
			(1,114,27,0),
			(1,114,28,0),
			(1,114,34,0),
			(1,114,36,0),
			(1,114,37,0),
			(1,114,38,0),
			(1,114,39,0),
			(1,114,40,0),
			(1,114,41,0),
			(1,114,42,0),
			(1,114,46,0),
			(1,114,47,0),
			(1,114,48,0),
			(1,114,49,0),
			(1,114,51,0),
			(1,114,52,0),
			(1,114,53,0),
			(1,114,54,0),
			(1,114,55,0),
			(1,114,56,0),
			(1,114,57,0),
			(1,114,58,0),
			(1,114,59,0),
			(1,114,60,0),
			(1,114,63,0),
			(1,114,65,0),
			(1,114,66,0),
			(1,114,67,1),
			(1,114,68,1),
			(1,114,69,0),
			(1,114,71,0),
			(1,115,0,1),
			(1,115,5,0),
			(1,115,6,0),
			(1,115,8,0),
			(1,115,13,0),
			(1,115,14,0),
			(1,115,15,0),
			(1,115,17,0),
			(1,115,18,0),
			(1,115,19,0),
			(1,115,20,0),
			(1,115,22,0),
			(1,115,24,0),
			(1,115,25,0),
			(1,115,26,0),
			(1,115,27,0),
			(1,115,28,0),
			(1,115,34,0),
			(1,115,36,0),
			(1,115,37,0),
			(1,115,38,0),
			(1,115,39,0),
			(1,115,40,0),
			(1,115,41,0),
			(1,115,42,0),
			(1,115,46,0),
			(1,115,47,0),
			(1,115,48,0),
			(1,115,49,0),
			(1,115,51,0),
			(1,115,52,0),
			(1,115,53,0),
			(1,115,54,0),
			(1,115,55,0),
			(1,115,56,0),
			(1,115,57,0),
			(1,115,58,0),
			(1,115,59,0),
			(1,115,60,0),
			(1,115,61,0),
			(1,115,63,0),
			(1,115,65,0),
			(1,115,66,0),
			(1,115,67,1),
			(1,115,68,1),
			(1,115,69,0),
			(1,115,71,0),
			(1,116,0,0),
			(1,116,5,0),
			(1,116,6,0),
			(1,116,8,0),
			(1,116,13,0),
			(1,116,14,0),
			(1,116,15,0),
			(1,116,17,0),
			(1,116,18,0),
			(1,116,19,0),
			(1,116,20,0),
			(1,116,22,0),
			(1,116,24,0),
			(1,116,25,0),
			(1,116,26,0),
			(1,116,27,0),
			(1,116,28,0),
			(1,116,34,0),
			(1,116,36,0),
			(1,116,37,0),
			(1,116,38,0),
			(1,116,39,0),
			(1,116,40,0),
			(1,116,41,0),
			(1,116,42,0),
			(1,116,46,0),
			(1,116,47,0),
			(1,116,48,0),
			(1,116,49,0),
			(1,116,51,0),
			(1,116,52,0),
			(1,116,53,0),
			(1,116,54,0),
			(1,116,55,0),
			(1,116,56,0),
			(1,116,57,0),
			(1,116,58,0),
			(1,116,59,0),
			(1,116,60,0),
			(1,116,63,0),
			(1,116,65,0),
			(1,116,66,0),
			(1,116,67,1),
			(1,116,68,1),
			(1,116,69,0),
			(1,116,71,0),
			(1,117,0,0),
			(1,117,5,0),
			(1,117,6,0),
			(1,117,8,0),
			(1,117,13,0),
			(1,117,14,0),
			(1,117,15,0),
			(1,117,17,0),
			(1,117,18,0),
			(1,117,19,0),
			(1,117,20,0),
			(1,117,22,0),
			(1,117,24,0),
			(1,117,25,0),
			(1,117,26,0),
			(1,117,27,0),
			(1,117,28,0),
			(1,117,34,0),
			(1,117,36,0),
			(1,117,37,0),
			(1,117,38,0),
			(1,117,39,0),
			(1,117,40,0),
			(1,117,41,0),
			(1,117,42,0),
			(1,117,46,0),
			(1,117,47,0),
			(1,117,48,0),
			(1,117,49,0),
			(1,117,51,0),
			(1,117,52,0),
			(1,117,53,0),
			(1,117,54,0),
			(1,117,55,0),
			(1,117,56,0),
			(1,117,57,0),
			(1,117,58,0),
			(1,117,59,0),
			(1,117,60,0),
			(1,117,61,0),
			(1,117,63,0),
			(1,117,65,0),
			(1,117,66,0),
			(1,117,67,1),
			(1,117,68,1),
			(1,117,69,0),
			(1,117,71,0),
			(1,119,0,1),
			(1,119,5,0),
			(1,119,6,0),
			(1,119,8,0),
			(1,119,13,0),
			(1,119,14,0),
			(1,119,15,0),
			(1,119,17,0),
			(1,119,18,0),
			(1,119,19,0),
			(1,119,22,0),
			(1,119,24,0),
			(1,119,25,0),
			(1,119,26,0),
			(1,119,27,0),
			(1,119,28,0),
			(1,119,34,0),
			(1,119,36,0),
			(1,119,37,0),
			(1,119,38,0),
			(1,119,39,0),
			(1,119,40,0),
			(1,119,41,0),
			(1,119,42,0),
			(1,119,46,0),
			(1,119,47,0),
			(1,119,48,0),
			(1,119,49,0),
			(1,119,51,0),
			(1,119,52,0),
			(1,119,53,0),
			(1,119,54,0),
			(1,119,55,0),
			(1,119,56,0),
			(1,119,57,0),
			(1,119,58,0),
			(1,119,59,0),
			(1,119,60,0),
			(1,119,63,0),
			(1,119,65,0),
			(1,119,66,0),
			(1,119,67,1),
			(1,119,68,1),
			(1,119,69,0),
			(1,119,71,0),
			(1,121,0,0),
			(1,121,5,0),
			(1,121,6,0),
			(1,121,8,0),
			(1,121,13,0),
			(1,121,14,0),
			(1,121,15,0),
			(1,121,17,0),
			(1,121,18,0),
			(1,121,19,0),
			(1,121,22,0),
			(1,121,24,0),
			(1,121,25,0),
			(1,121,26,0),
			(1,121,27,0),
			(1,121,28,0),
			(1,121,34,0),
			(1,121,36,0),
			(1,121,37,0),
			(1,121,38,0),
			(1,121,39,0),
			(1,121,40,0),
			(1,121,41,0),
			(1,121,42,0),
			(1,121,46,0),
			(1,121,47,0),
			(1,121,48,0),
			(1,121,49,0),
			(1,121,51,0),
			(1,121,52,0),
			(1,121,53,0),
			(1,121,54,0),
			(1,121,55,0),
			(1,121,56,0),
			(1,121,57,0),
			(1,121,58,0),
			(1,121,59,0),
			(1,121,60,0),
			(1,121,63,0),
			(1,121,65,0),
			(1,121,66,0),
			(1,121,67,1),
			(1,121,68,1),
			(1,121,69,0),
			(1,121,71,0),
			(1,122,0,0),
			(1,122,5,0),
			(1,122,6,0),
			(1,122,8,0),
			(1,122,13,0),
			(1,122,14,0),
			(1,122,15,0),
			(1,122,17,0),
			(1,122,18,0),
			(1,122,19,0),
			(1,122,22,0),
			(1,122,24,0),
			(1,122,25,0),
			(1,122,26,0),
			(1,122,27,0),
			(1,122,28,0),
			(1,122,34,0),
			(1,122,36,0),
			(1,122,37,0),
			(1,122,38,0),
			(1,122,39,0),
			(1,122,40,0),
			(1,122,41,0),
			(1,122,42,0),
			(1,122,46,0),
			(1,122,47,0),
			(1,122,48,0),
			(1,122,49,0),
			(1,122,51,0),
			(1,122,52,0),
			(1,122,53,0),
			(1,122,54,0),
			(1,122,55,0),
			(1,122,56,0),
			(1,122,57,0),
			(1,122,58,0),
			(1,122,59,0),
			(1,122,60,0),
			(1,122,63,0),
			(1,122,65,0),
			(1,122,66,0),
			(1,122,67,1),
			(1,122,68,1),
			(1,122,69,0),
			(1,122,71,0),
			(1,123,0,0),
			(1,123,5,0),
			(1,123,6,0),
			(1,123,8,0),
			(1,123,13,0),
			(1,123,14,0),
			(1,123,15,0),
			(1,123,17,0),
			(1,123,18,0),
			(1,123,19,0),
			(1,123,22,0),
			(1,123,24,0),
			(1,123,25,0),
			(1,123,26,0),
			(1,123,27,0),
			(1,123,28,0),
			(1,123,34,0),
			(1,123,36,0),
			(1,123,37,0),
			(1,123,38,0),
			(1,123,39,0),
			(1,123,40,0),
			(1,123,41,0),
			(1,123,42,0),
			(1,123,46,0),
			(1,123,47,0),
			(1,123,48,0),
			(1,123,49,0),
			(1,123,51,0),
			(1,123,52,0),
			(1,123,53,0),
			(1,123,54,0),
			(1,123,55,0),
			(1,123,56,0),
			(1,123,57,0),
			(1,123,58,0),
			(1,123,59,0),
			(1,123,60,0),
			(1,123,63,0),
			(1,123,65,0),
			(1,123,66,0),
			(1,123,67,1),
			(1,123,68,1),
			(1,123,69,0),
			(1,123,71,0),
			(1,124,0,0),
			(1,124,5,0),
			(1,124,6,0),
			(1,124,8,0),
			(1,124,13,0),
			(1,124,14,0),
			(1,124,15,0),
			(1,124,17,0),
			(1,124,18,0),
			(1,124,19,0),
			(1,124,22,0),
			(1,124,24,0),
			(1,124,25,0),
			(1,124,26,0),
			(1,124,27,0),
			(1,124,28,0),
			(1,124,34,0),
			(1,124,36,0),
			(1,124,37,0),
			(1,124,38,0),
			(1,124,39,0),
			(1,124,40,0),
			(1,124,41,0),
			(1,124,42,0),
			(1,124,46,0),
			(1,124,47,0),
			(1,124,48,0),
			(1,124,49,0),
			(1,124,51,0),
			(1,124,52,0),
			(1,124,53,0),
			(1,124,54,0),
			(1,124,55,0),
			(1,124,56,0),
			(1,124,57,0),
			(1,124,58,0),
			(1,124,59,0),
			(1,124,60,0),
			(1,124,63,0),
			(1,124,65,0),
			(1,124,66,0),
			(1,124,67,1),
			(1,124,68,1),
			(1,124,69,0),
			(1,124,71,0),
			(1,125,0,0),
			(1,125,5,0),
			(1,125,6,0),
			(1,125,8,0),
			(1,125,13,0),
			(1,125,14,0),
			(1,125,15,0),
			(1,125,17,0),
			(1,125,18,0),
			(1,125,19,0),
			(1,125,22,0),
			(1,125,24,0),
			(1,125,25,0),
			(1,125,26,0),
			(1,125,27,0),
			(1,125,28,0),
			(1,125,34,0),
			(1,125,36,0),
			(1,125,37,0),
			(1,125,38,0),
			(1,125,39,0),
			(1,125,40,0),
			(1,125,41,0),
			(1,125,42,0),
			(1,125,46,0),
			(1,125,47,0),
			(1,125,48,0),
			(1,125,49,0),
			(1,125,51,0),
			(1,125,52,0),
			(1,125,53,0),
			(1,125,54,0),
			(1,125,55,0),
			(1,125,56,0),
			(1,125,57,0),
			(1,125,58,0),
			(1,125,59,0),
			(1,125,60,0),
			(1,125,63,0),
			(1,125,65,0),
			(1,125,66,0),
			(1,125,67,1),
			(1,125,68,1),
			(1,125,69,0),
			(1,125,71,0),
			(1,127,0,0),
			(1,127,5,0),
			(1,127,6,0),
			(1,127,8,0),
			(1,127,13,0),
			(1,127,14,0),
			(1,127,15,0),
			(1,127,17,0),
			(1,127,18,0),
			(1,127,19,0),
			(1,127,22,0),
			(1,127,24,0),
			(1,127,25,0),
			(1,127,26,0),
			(1,127,27,0),
			(1,127,28,0),
			(1,127,34,0),
			(1,127,36,0),
			(1,127,37,0),
			(1,127,38,0),
			(1,127,39,0),
			(1,127,40,0),
			(1,127,41,0),
			(1,127,42,0),
			(1,127,46,0),
			(1,127,47,0),
			(1,127,48,0),
			(1,127,49,0),
			(1,127,51,0),
			(1,127,52,0),
			(1,127,53,0),
			(1,127,54,0),
			(1,127,55,0),
			(1,127,56,0),
			(1,127,57,0),
			(1,127,58,0),
			(1,127,59,0),
			(1,127,60,0),
			(1,127,63,0),
			(1,127,65,0),
			(1,127,66,0),
			(1,127,67,1),
			(1,127,68,1),
			(1,127,69,0),
			(1,127,71,0),
			(1,128,0,0),
			(1,128,5,0),
			(1,128,6,0),
			(1,128,8,0),
			(1,128,13,0),
			(1,128,14,0),
			(1,128,15,0),
			(1,128,17,0),
			(1,128,18,0),
			(1,128,19,0),
			(1,128,22,0),
			(1,128,24,0),
			(1,128,25,0),
			(1,128,26,0),
			(1,128,27,0),
			(1,128,28,0),
			(1,128,34,0),
			(1,128,36,0),
			(1,128,37,0),
			(1,128,38,0),
			(1,128,39,0),
			(1,128,40,0),
			(1,128,41,0),
			(1,128,42,0),
			(1,128,46,0),
			(1,128,47,0),
			(1,128,48,0),
			(1,128,49,0),
			(1,128,51,0),
			(1,128,52,0),
			(1,128,53,0),
			(1,128,54,0),
			(1,128,55,0),
			(1,128,56,0),
			(1,128,57,0),
			(1,128,58,0),
			(1,128,59,0),
			(1,128,60,0),
			(1,128,63,0),
			(1,128,65,0),
			(1,128,66,0),
			(1,128,67,1),
			(1,128,68,1),
			(1,128,69,0),
			(1,128,71,0),
			(1,130,0,1),
			(1,130,5,0),
			(1,130,6,0),
			(1,130,8,0),
			(1,130,13,0),
			(1,130,14,0),
			(1,130,15,0),
			(1,130,17,0),
			(1,130,18,0),
			(1,130,19,0),
			(1,130,20,0),
			(1,130,22,0),
			(1,130,24,0),
			(1,130,25,0),
			(1,130,26,0),
			(1,130,27,0),
			(1,130,28,0),
			(1,130,30,0),
			(1,130,34,0),
			(1,130,36,0),
			(1,130,37,0),
			(1,130,38,0),
			(1,130,39,0),
			(1,130,40,0),
			(1,130,41,0),
			(1,130,42,0),
			(1,130,46,0),
			(1,130,47,0),
			(1,130,48,0),
			(1,130,49,0),
			(1,130,51,0),
			(1,130,52,0),
			(1,130,53,0),
			(1,130,54,0),
			(1,130,55,0),
			(1,130,56,0),
			(1,130,57,0),
			(1,130,58,0),
			(1,130,59,0),
			(1,130,60,0),
			(1,130,63,0),
			(1,130,65,0),
			(1,130,66,0),
			(1,130,67,1),
			(1,130,68,1),
			(1,130,69,0),
			(1,130,71,0),
			(1,131,0,1),
			(1,131,5,0),
			(1,131,6,0),
			(1,131,8,0),
			(1,131,13,0),
			(1,131,14,0),
			(1,131,15,0),
			(1,131,17,0),
			(1,131,18,0),
			(1,131,19,0),
			(1,131,22,0),
			(1,131,24,0),
			(1,131,25,0),
			(1,131,26,0),
			(1,131,27,0),
			(1,131,28,0),
			(1,131,34,0),
			(1,131,36,0),
			(1,131,37,0),
			(1,131,38,0),
			(1,131,39,0),
			(1,131,40,0),
			(1,131,41,0),
			(1,131,42,0),
			(1,131,46,0),
			(1,131,47,0),
			(1,131,48,0),
			(1,131,49,0),
			(1,131,51,0),
			(1,131,52,0),
			(1,131,53,0),
			(1,131,54,0),
			(1,131,55,0),
			(1,131,56,0),
			(1,131,57,0),
			(1,131,58,0),
			(1,131,59,0),
			(1,131,60,0),
			(1,131,63,0),
			(1,131,65,0),
			(1,131,66,0),
			(1,131,67,1),
			(1,131,68,1),
			(1,131,69,0),
			(1,131,71,0),
			(1,131,73,0),
			(1,131,74,0),
			(1,132,5,0),
			(1,132,6,0),
			(1,132,8,0),
			(1,132,14,0),
			(1,132,15,0),
			(1,132,17,0),
			(1,132,18,0),
			(1,132,19,0),
			(1,132,22,0),
			(1,132,24,0),
			(1,132,25,0),
			(1,132,26,0),
			(1,132,27,0),
			(1,132,28,0),
			(1,132,34,0),
			(1,132,36,0),
			(1,132,37,0),
			(1,132,38,0),
			(1,132,39,0),
			(1,132,40,0),
			(1,132,41,0),
			(1,132,42,0),
			(1,132,46,0),
			(1,132,47,0),
			(1,132,48,0),
			(1,132,49,0),
			(1,132,51,0),
			(1,132,52,0),
			(1,132,53,0),
			(1,132,54,0),
			(1,132,55,0),
			(1,132,56,0),
			(1,132,57,0),
			(1,132,58,0),
			(1,132,59,0),
			(1,132,60,0),
			(1,132,63,0),
			(1,132,65,0),
			(1,132,66,0),
			(1,132,67,1),
			(1,132,68,1),
			(1,132,69,0),
			(1,132,71,0),
			(1,133,5,0),
			(1,133,6,0),
			(1,133,8,0),
			(1,133,14,0),
			(1,133,15,0),
			(1,133,17,0),
			(1,133,18,0),
			(1,133,19,0),
			(1,133,22,0),
			(1,133,24,0),
			(1,133,25,0),
			(1,133,26,0),
			(1,133,27,0),
			(1,133,28,0),
			(1,133,34,0),
			(1,133,36,0),
			(1,133,37,0),
			(1,133,38,0),
			(1,133,39,0),
			(1,133,40,0),
			(1,133,41,0),
			(1,133,42,0),
			(1,133,46,0),
			(1,133,47,0),
			(1,133,48,0),
			(1,133,49,0),
			(1,133,51,0),
			(1,133,52,0),
			(1,133,53,0),
			(1,133,54,0),
			(1,133,55,0),
			(1,133,56,0),
			(1,133,57,0),
			(1,133,58,0),
			(1,133,59,0),
			(1,133,60,0),
			(1,133,63,0),
			(1,133,65,0),
			(1,133,66,0),
			(1,133,67,1),
			(1,133,68,1),
			(1,133,69,0),
			(1,133,71,0),
			(1,134,5,0),
			(1,134,6,0),
			(1,134,8,0),
			(1,134,13,0),
			(1,134,14,0),
			(1,134,15,0),
			(1,134,17,0),
			(1,134,18,0),
			(1,134,19,0),
			(1,134,22,0),
			(1,134,24,0),
			(1,134,25,0),
			(1,134,26,0),
			(1,134,27,0),
			(1,134,28,0),
			(1,134,34,0),
			(1,134,36,0),
			(1,134,37,0),
			(1,134,38,0),
			(1,134,39,0),
			(1,134,40,0),
			(1,134,41,0),
			(1,134,42,0),
			(1,134,46,0),
			(1,134,47,0),
			(1,134,48,0),
			(1,134,49,0),
			(1,134,51,0),
			(1,134,52,0),
			(1,134,53,0),
			(1,134,54,0),
			(1,134,55,0),
			(1,134,56,0),
			(1,134,57,0),
			(1,134,58,0),
			(1,134,59,0),
			(1,134,60,0),
			(1,134,63,0),
			(1,134,65,0),
			(1,134,66,0),
			(1,134,67,1),
			(1,134,68,1),
			(1,134,69,0),
			(1,134,71,0),
			(1,135,5,0),
			(1,135,6,0),
			(1,135,8,0),
			(1,135,13,0),
			(1,135,14,0),
			(1,135,15,0),
			(1,135,17,0),
			(1,135,18,0),
			(1,135,19,0),
			(1,135,22,0),
			(1,135,24,0),
			(1,135,25,0),
			(1,135,26,0),
			(1,135,27,0),
			(1,135,28,0),
			(1,135,34,0),
			(1,135,36,0),
			(1,135,37,0),
			(1,135,38,0),
			(1,135,39,0),
			(1,135,40,0),
			(1,135,41,0),
			(1,135,42,0),
			(1,135,46,0),
			(1,135,47,0),
			(1,135,48,0),
			(1,135,49,0),
			(1,135,51,0),
			(1,135,52,0),
			(1,135,53,0),
			(1,135,54,0),
			(1,135,55,0),
			(1,135,56,0),
			(1,135,57,0),
			(1,135,58,0),
			(1,135,59,0),
			(1,135,60,0),
			(1,135,63,0),
			(1,135,65,0),
			(1,135,66,0),
			(1,135,67,1),
			(1,135,68,1),
			(1,135,69,0),
			(1,135,71,0),
			(1,136,5,0),
			(1,136,6,0),
			(1,136,8,0),
			(1,136,13,0),
			(1,136,14,0),
			(1,136,15,0),
			(1,136,17,0),
			(1,136,18,0),
			(1,136,19,0),
			(1,136,22,0),
			(1,136,24,0),
			(1,136,25,0),
			(1,136,26,0),
			(1,136,27,0),
			(1,136,28,0),
			(1,136,34,0),
			(1,136,36,0),
			(1,136,37,0),
			(1,136,38,0),
			(1,136,39,0),
			(1,136,40,0),
			(1,136,41,0),
			(1,136,42,0),
			(1,136,46,0),
			(1,136,47,0),
			(1,136,48,0),
			(1,136,49,0),
			(1,136,51,0),
			(1,136,52,0),
			(1,136,53,0),
			(1,136,54,0),
			(1,136,55,0),
			(1,136,56,0),
			(1,136,57,0),
			(1,136,58,0),
			(1,136,59,0),
			(1,136,60,0),
			(1,136,63,0),
			(1,136,65,0),
			(1,136,66,0),
			(1,136,67,1),
			(1,136,68,0),
			(1,136,69,1),
			(1,136,71,0),
			(1,138,5,0),
			(1,138,6,0),
			(1,138,8,0),
			(1,138,14,0),
			(1,138,15,0),
			(1,138,17,0),
			(1,138,18,0),
			(1,138,19,0),
			(1,138,22,0),
			(1,138,24,0),
			(1,138,25,0),
			(1,138,26,0),
			(1,138,27,0),
			(1,138,28,0),
			(1,138,34,0),
			(1,138,36,0),
			(1,138,37,0),
			(1,138,38,0),
			(1,138,39,0),
			(1,138,40,0),
			(1,138,41,0),
			(1,138,42,0),
			(1,138,46,0),
			(1,138,47,0),
			(1,138,48,0),
			(1,138,49,0),
			(1,138,51,0),
			(1,138,52,0),
			(1,138,53,0),
			(1,138,54,0),
			(1,138,55,0),
			(1,138,56,0),
			(1,138,57,0),
			(1,138,58,0),
			(1,138,59,0),
			(1,138,60,0),
			(1,138,63,0),
			(1,138,65,0),
			(1,138,66,0),
			(1,138,67,0),
			(1,138,68,0),
			(1,138,69,0),
			(1,138,71,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_projectmilestone_priority`(`projectmilestone_priorityid`,`projectmilestone_priority`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_LOW',1,659,1),
			(2,'PLL_NORMAL',1,660,2),
			(3,'PLL_HIGH',1,661,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_projectmilestone_status`(`projectmilestone_statusid`,`projectmilestone_status`,`presence`,`picklist_valueid`,`sortorderid`,`automation`) values
			(1,'PLL_PLANNED',0,914,1,1),
			(2,'PLL_ON_HOLD',0,915,2,1),
			(3,'PLL_IN_PROGRESSING',0,916,3,1),
			(4,'PLL_IN_APPROVAL',0,917,4,1),
			(5,'PLL_COMPLETED',0,918,5,2),
			(6,'PLL_CANCELLED',0,924,6,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_projectmilestonetype`(`projectmilestonetypeid`,`projectmilestonetype`,`presence`,`picklist_valueid`,`sortorderid`) values
			(2,'PLL_INTERNAL',1,238,2),
			(3,'PLL_EXTERNAL',1,239,3),
			(4,'PLL_SHARED',1,240,4);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_projectpriority`(`projectpriorityid`,`projectpriority`,`presence`,`picklist_valueid`,`sortorderid`) values
			(2,'low',1,274,2),
			(3,'normal',1,275,3),
			(4,'high',1,276,4);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_projectstatus`(`projectstatusid`,`projectstatus`,`presence`,`picklist_valueid`,`sortorderid`,`color`,`automation`) values
			(2,'PLL_PLANNED',0,261,2,'E6FAD8',1),
			(3,'PLL_ON_HOLD',0,262,3,'E6FAD8',1),
			(4,'PLL_IN_PROGRESSING',0,263,4,'E6FAD8',1),
			(5,'PLL_IN_APPROVAL',0,264,5,'E6FAD8',1),
			(6,'PLL_COMPLETED',0,265,6,'E6FAD8',2),
			(7,'PLL_CANCELLED',0,266,7,'E6FAD8',2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_projecttaskpriority`(`projecttaskpriorityid`,`projecttaskpriority`,`presence`,`picklist_valueid`,`sortorderid`) values
			(2,'low',1,246,2),
			(3,'normal',1,247,3),
			(4,'high',1,248,4);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_projecttaskstatus`(`projecttaskstatusid`,`projecttaskstatus`,`presence`,`picklist_valueid`,`sortorderid`,`automation`) values
			(2,'PLL_PLANNED',0,290,2,1),
			(3,'PLL_ON_HOLD',0,291,3,1),
			(4,'PLL_SUBMITTED_COMMENTS',0,292,4,1),
			(5,'PLL_IN_PROGRESSING',0,293,5,1),
			(6,'PLL_IN_APPROVAL',0,294,6,1),
			(7,'PLL_COMPLETED',0,922,7,2),
			(8,'PLL_CANCELLED',0,923,8,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_projecttasktype`(`projecttasktypeid`,`projecttasktype`,`presence`,`picklist_valueid`,`sortorderid`) values
			(2,'administrative',1,242,2),
			(3,'operative',1,243,3),
			(4,'other',1,244,4);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_projecttype`(`projecttypeid`,`projecttype`,`presence`,`picklist_valueid`,`sortorderid`) values
			(2,'PLL_INTERNAL',1,270,2),
			(3,'PLL_EXTERNAL',1,271,3),
			(4,'PLL_COMMON',1,272,4);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_queue_status`(`queue_statusid`,`queue_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_PLANNED',1,950,1),
			(2,'PLL_ON_HOLD',1,951,2),
			(3,'PLL_FOR_VERIFICATION',1,952,3),
			(4,'PLL_IN_APPROVAL',1,953,4),
			(5,'PLL_ACCEPTED',0,954,5),
			(6,'PLL_COMPLETED',0,955,6),
			(7,'PLL_CANCELLED',0,956,7);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_realization_process`(`module_id`,`status_indicate_closing`) values
			(43,''),
			(41,''),
			(42,'');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_recurring_frequency`(`recurring_frequency_id`,`recurring_frequency`,`sortorderid`,`presence`) values
			(2,'+1 day',1,1),
			(3,'+7 days',2,1),
			(4,'+14 days',3,1),
			(5,'+21 days',4,1),
			(6,'+30 days',5,1),
			(7,'+60 days',6,1),
			(8,'+90 days',7,1),
			(9,'+180 days',8,1),
			(10,'+360 days',9,1),
			(11,'+1 month',10,1),
			(12,'+3 months',11,1),
			(13,'+6 months',12,1),
			(14,'+1 year',13,1),
			(15,'monday next week',14,1),
			(16,'friday next week',15,1),
			(17,'first day of next month',16,1),
			(18,'last day of next month',17,1),
			(19,'first day of +3 months',18,1),
			(20,'last day of +3 months',19,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_relatedlists`(`relation_id`,`tabid`,`related_tabid`,`name`,`sequence`,`label`,`presence`,`actions`,`favorites`,`creator_detail`,`relation_comment`,`view_type`,`field_name`,`custom_view`,`custom_view_orderby`) values
			(1,6,4,'getDependentsList',1,'Contacts',0,'add',0,0,0,'RelatedTab','parent_id',NULL,0),
			(6,6,9,'getActivities',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(7,6,54,'getEmails',3,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(8,86,51,'getDependentsList',18,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','process',NULL,0),
			(9,6,8,'getAttachments',4,'Documents',0,'add,select',0,0,0,'RelatedTab',NULL,NULL,0),
			(10,6,13,'getDependentsList',5,'HelpDesk',0,'add',0,0,0,'RelatedTab','parent_id',NULL,0),
			(11,6,14,'getProducts',12,'Products',1,'select',0,1,1,'RelatedTab',NULL,NULL,0),
			(12,7,9,'getActivities',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(13,7,54,'getEmails',5,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(15,7,8,'getAttachments',4,'Documents',0,'add,select',0,0,0,'RelatedTab',NULL,NULL,0),
			(16,7,14,'getProducts',9,'Products',1,'select',0,1,1,'RelatedTab',NULL,NULL,0),
			(17,7,26,'getCampaigns',7,'Campaigns',0,'select',0,0,0,'RelatedTab',NULL,NULL,0),
			(19,4,9,'getActivities',1,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(20,4,54,'getEmails',3,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(27,4,8,'getAttachments',2,'Documents',0,'add,select',0,0,0,'RelatedTab',NULL,NULL,0),
			(38,14,13,'getDependentsList',2,'HelpDesk',0,'',0,0,0,'RelatedTab','product_id',NULL,0),
			(39,14,8,'getAttachments',3,'Documents',0,'add,select',0,0,0,'RelatedTab',NULL,NULL,0),
			(44,14,19,'getProductPricebooks',4,'PriceBooks',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(45,14,7,'getLeads',5,'Leads',0,'select',0,0,0,'RelatedTab',NULL,NULL,0),
			(46,14,6,'getAccounts',6,'Accounts',0,'select',0,0,0,'RelatedTab',NULL,NULL,0),
			(49,14,14,'getProducts',7,'Product Bundles',0,'add,select',0,0,0,'RelatedTab',NULL,NULL,0),
			(54,13,9,'getActivities',1,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(55,13,8,'getAttachments',4,'Documents',0,'add,select',0,0,0,'RelatedTab',NULL,NULL,0),
			(58,19,14,'getPricebookProducts',2,'Products',0,'select',0,0,0,'RelatedTab',NULL,NULL,0),
			(59,18,14,'getDependentsList',2,'Products',0,'add',0,0,0,'RelatedTab','vendor_id',NULL,0),
			(61,18,4,'getDependentsList',3,'Contacts',0,'ADD',0,0,0,'RelatedTab','parent_id',NULL,0),
			(62,18,54,'getEmails',4,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(84,26,7,'getCampaignsRecords',4,'Leads',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(86,26,9,'getActivities',1,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(87,6,26,'getCampaigns',6,'Campaigns',0,'select',0,0,0,'RelatedTab',NULL,NULL,0),
			(88,26,6,'getCampaignsRecords',5,'Accounts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(89,15,8,'getAttachments',1,'Documents',0,'add,select',0,0,0,'RelatedTab,DetailBottom',NULL,NULL,0),
			(95,6,34,'getDependentsList',8,'Service Contracts',0,'ADD',0,0,0,'RelatedTab','sc_related_to',NULL,0),
			(109,13,35,'getRelatedList',6,'Services',1,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(110,7,35,'getRelatedList',17,'Services',1,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(111,6,35,'getRelatedList',15,'Services',1,'SELECT',0,1,1,'RelatedTab',NULL,NULL,0),
			(114,19,35,'getPricebookServices',3,'Services',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(117,6,37,'getDependentsList',13,'Assets',1,'ADD',0,0,1,'RelatedTab','parent_id',NULL,0),
			(118,14,37,'getDependentsList',8,'Assets',0,'ADD',0,0,0,'RelatedTab','product',NULL,0),
			(126,6,43,'getDependentsList',9,'Projects',0,'add',0,0,0,'RelatedTab','linktoaccountscontacts',NULL,0),
			(157,34,13,'getDependentsList',4,'HelpDesk',0,'ADD',0,0,0,'RelatedTab','servicecontractsid',NULL,0),
			(158,34,8,'getAttachments',3,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(159,35,13,'getDependentsList',1,'HelpDesk',0,'',0,0,0,'RelatedTab','product_id',NULL,0),
			(164,35,19,'getServicePricebooks',6,'PriceBooks',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(165,35,7,'getRelatedList',7,'Leads',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(166,35,6,'getRelatedList',8,'Accounts',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(169,35,8,'getAttachments',11,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(170,37,13,'getDependentsList',1,'HelpDesk',0,'ADD',0,0,0,'RelatedTab','pssold_id',NULL,0),
			(171,37,8,'getAttachments',2,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(172,42,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(173,43,42,'getDependentsList',2,'Project Tasks',0,'ADD',0,0,0,'RelatedTab','projectid',NULL,0),
			(174,43,41,'getDependentsList',3,'Project Milestones',0,'ADD',0,0,0,'RelatedTab','projectid',NULL,0),
			(175,43,8,'getAttachments',4,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(182,51,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(183,6,51,'getDependentsList',10,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(185,13,51,'getDependentsList',8,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','subprocess',NULL,0),
			(186,43,51,'getDependentsList',6,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','process',NULL,0),
			(187,42,51,'getDependentsList',2,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','subprocess_sl',NULL,0),
			(188,34,51,'getDependentsList',5,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','process',NULL,0),
			(193,54,8,'getAttachments',1,'Documents',0,'',0,0,0,'RelatedTab',NULL,NULL,0),
			(194,54,6,'getRecordToMails',2,'Accounts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(195,54,4,'getRecordToMails',3,'Contacts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(196,54,7,'getRecordToMails',4,'Leads',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(198,54,13,'getRecordToMails',6,'HelpDesk',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(199,54,43,'getRecordToMails',7,'Project',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(200,54,34,'getRecordToMails',8,'ServiceContracts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(201,54,26,'getRecordToMails',9,'Campaigns',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(207,34,54,'getEmails',6,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(208,13,54,'getEmails',10,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(210,43,54,'getEmails',7,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(211,26,54,'getEmails',2,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(213,13,37,'getRelatedList',11,'Assets',1,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(214,6,57,'getDependentsList',16,'OSSOutsourcedServices',1,'ADD',0,0,1,'RelatedTab','parent_id',NULL,0),
			(216,7,57,'getDependentsList',18,'OSSOutsourcedServices',1,'ADD',0,0,1,'RelatedTab','parent_id',NULL,0),
			(218,6,58,'getDependentsList',17,'OSSSoldServices',1,'ADD',0,0,1,'RelatedTab','parent_id',NULL,0),
			(221,6,59,'getDependentsList',14,'OutsourcedProducts',1,'ADD',0,0,1,'RelatedTab','parent_id',NULL,0),
			(222,7,59,'getDependentsList',16,'OutsourcedProducts',1,'ADD',0,0,1,'RelatedTab','parent_id',NULL,0),
			(237,61,8,'getAttachments',2,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(238,61,51,'getOsstimecontrol',3,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(239,7,4,'getDependentsList',1,'Contacts',0,'ADD',0,0,0,'RelatedTab','parent_id',NULL,0),
			(268,34,43,'getDependentsList',7,'Project',0,'ADD',0,0,0,'RelatedTab','servicecontractsid',NULL,0),
			(283,7,51,'getDependentsList',6,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(284,43,9,'getActivities',1,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(285,34,9,'getActivities',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(287,4,74,'getDependentsList',6,'CallHistory',0,'',0,0,0,'RelatedTab','destination',NULL,0),
			(288,6,74,'getDependentsList',18,'CallHistory',0,'',0,0,0,'RelatedTab','destination',NULL,0),
			(289,7,74,'getDependentsList',19,'CallHistory',0,'',0,0,0,'RelatedTab','destination',NULL,0),
			(290,18,74,'getDependentsList',7,'CallHistory',0,'',0,0,0,'RelatedTab','destination',NULL,0),
			(291,61,74,'getDependentsList',4,'CallHistory',0,'',0,0,0,'RelatedTab','destination',NULL,0),
			(293,13,74,'getDependentsList',14,'CallHistory',0,'',0,0,0,'RelatedTab','source',NULL,0),
			(294,75,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(303,79,8,'getAttachments',1,'Documents',0,'SELECT,ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(304,6,79,'getDependentsList',19,'PaymentsIn',0,'ADD',0,0,0,'RelatedTab','relatedid',NULL,0),
			(307,80,8,'getAttachments',1,'Documents',0,'SELECT,ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(308,6,80,'getDependentsList',20,'PaymentsOut',0,'ADD',0,0,0,'RelatedTab','relatedid',NULL,0),
			(311,81,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(313,6,81,'getDependentsList',21,'LettersIn',0,'ADD',0,0,0,'RelatedTab','relatedid',NULL,0),
			(315,7,81,'getDependentsList',20,'LettersIn',0,'ADD',0,0,0,'RelatedTab','relatedid',NULL,0),
			(321,82,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(323,6,82,'getDependentsList',22,'LettersOut',0,'ADD',0,0,0,'RelatedTab','relatedid',NULL,0),
			(325,7,82,'getDependentsList',21,'LettersOut',0,'ADD',0,0,0,'RelatedTab','relatedid',NULL,0),
			(326,18,82,'getDependentsList',9,'LettersOut',0,'ADD',0,0,0,'RelatedTab','relatedid',NULL,0),
			(327,18,81,'getDependentsList',10,'LettersIn',0,'ADD',0,0,0,'RelatedTab','relatedid',NULL,0),
			(328,61,82,'getDependentsList',6,'LettersOut',0,'ADD',0,0,0,'RelatedTab','relatedid',NULL,0),
			(329,61,81,'getDependentsList',7,'LettersIn',0,'ADD',0,0,0,'RelatedTab','relatedid',NULL,0),
			(331,61,78,'getDependentsList',5,'HolidaysEntitlement',0,'ADD',0,0,0,'RelatedTab','ossemployeesid',NULL,0),
			(335,83,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(336,84,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(337,6,84,'getDependentsList',23,'Reservations',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(338,7,84,'getDependentsList',22,'Reservations',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(339,18,84,'getDependentsList',8,'Reservations',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(341,43,84,'getDependentsList',8,'Reservations',0,'ADD',0,0,0,'RelatedTab','process',NULL,0),
			(342,13,84,'getDependentsList',17,'Reservations',0,'ADD',0,0,0,'RelatedTab','subprocess',NULL,0),
			(347,13,4,'getRelatedList',18,'Contacts',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(349,59,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(350,57,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(351,58,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(352,41,42,'getDependentsList',1,'ProjectTask',0,'ADD',0,0,0,'RelatedTab','projectmilestoneid',NULL,0),
			(353,54,18,'getRecordToMails',10,'Vendors',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(354,43,4,'getRelatedList',9,'Contacts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(355,4,43,'getRelatedList',7,'Project',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(368,81,4,'getRelatedList',2,'Contacts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(369,82,4,'getRelatedList',2,'Contacts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(370,18,13,'getDependentsList',11,'HelpDesk',0,'ADD',0,0,0,'RelatedTab','parent_id',NULL,0),
			(371,18,43,'getDependentsList',12,'Project',0,'ADD',0,0,0,'RelatedTab','linktoaccountscontacts',NULL,0),
			(373,85,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(374,85,54,'getEmails',2,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(375,86,8,'getAttachments',2,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(376,86,54,'getEmails',3,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(377,87,8,'getAttachments',2,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(378,87,54,'getEmails',3,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(379,86,87,'getDependentsList',5,'SRequirementsCards',0,'ADD',0,0,0,'RelatedTab','salesprocessid',NULL,0),
			(380,86,85,'getDependentsList',4,'SQuoteEnquiries',0,'ADD',0,0,0,'RelatedTab','salesprocessid',NULL,0),
			(381,88,8,'getAttachments',2,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(382,88,54,'getEmails',3,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(383,86,88,'getDependentsList',6,'SCalculations',0,'ADD',0,0,0,'RelatedTab','salesprocessid',NULL,0),
			(384,87,88,'getDependentsList',4,'SCalculations',0,'ADD',0,0,0,'RelatedTab','srequirementscardsid',NULL,0),
			(385,89,8,'getAttachments',2,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(386,89,54,'getEmails',3,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(387,86,89,'getDependentsList',7,'SQuotes',0,'ADD',0,0,0,'RelatedTab','salesprocessid',NULL,0),
			(388,88,89,'getDependentsList',4,'SQuotes',0,'ADD',0,0,0,'RelatedTab','scalculationsid',NULL,0),
			(389,90,8,'getAttachments',2,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(390,90,54,'getEmails',3,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(391,86,90,'getDependentsList',8,'SSingleOrders',0,'ADD',0,0,0,'RelatedTab','salesprocessid',NULL,0),
			(392,89,90,'getDependentsList',4,'SSingleOrders',0,'ADD',0,0,0,'RelatedTab','squotesid',NULL,0),
			(393,91,8,'getAttachments',2,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(394,91,54,'getEmails',3,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(395,86,91,'getDependentsList',9,'SRecurringOrders',0,'ADD',0,0,0,'RelatedTab','salesprocessid',NULL,0),
			(396,89,91,'getDependentsList',5,'SRecurringOrders',0,'ADD',0,0,0,'RelatedTab','squotesid',NULL,0),
			(397,18,79,'getDependentsList',13,'PaymentsIn',0,'ADD',0,0,0,'RelatedTab','relatedid',NULL,0),
			(398,18,80,'getDependentsList',14,'PaymentsOut',0,'ADD',0,0,0,'RelatedTab','relatedid',NULL,0),
			(399,18,8,'getAttachments',5,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(400,92,8,'getAttachments',2,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(401,92,54,'getEmails',3,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(402,93,8,'getAttachments',2,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(403,93,54,'getEmails',3,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(404,86,14,'getRelatedList',10,'Products',1,'SELECT',0,1,1,'RelatedTab',NULL,NULL,0),
			(405,86,59,'getDependentsList',11,'OutsourcedProducts',1,'ADD',0,0,1,'RelatedTab','ssalesprocessesid',NULL,0),
			(406,86,37,'getDependentsList',12,'Assets',1,'ADD',0,0,1,'RelatedTab','ssalesprocessesid',NULL,0),
			(407,86,35,'getRelatedList',13,'Services',1,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(408,86,57,'getDependentsList',14,'OSSOutsourcedServices',1,'ADD',0,0,1,'RelatedTab','ssalesprocessesid',NULL,0),
			(409,86,58,'getDependentsList',15,'OSSSoldServices',1,'ADD',0,0,1,'RelatedTab','ssalesprocessesid',NULL,0),
			(410,18,9,'getActivities',1,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(411,92,9,'getActivities',1,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(412,93,9,'getActivities',1,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(413,61,9,'getActivities',1,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(414,86,9,'getActivities',1,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(415,85,9,'getActivities',3,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(416,87,9,'getActivities',1,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(417,88,9,'getActivities',1,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(418,89,9,'getActivities',1,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(419,90,9,'getActivities',1,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(420,91,9,'getActivities',1,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(421,18,51,'getDependentsList',15,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(422,92,51,'getDependentsList',4,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(423,93,51,'getDependentsList',4,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(424,86,4,'getRelatedList',16,'Contacts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(425,92,4,'getDependentsList',5,'Contacts',0,'ADD',0,0,0,'RelatedTab','parent_id',NULL,0),
			(426,93,4,'getDependentsList',5,'Contacts',0,'ADD',0,0,0,'RelatedTab','parent_id',NULL,0),
			(427,54,92,'getRecordToMails',11,'Partners',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(428,54,93,'getRecordToMails',12,'Competition',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(429,54,61,'getRecordToMails',13,'OSSEmployees',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(430,61,54,'getEmails',8,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(431,54,86,'getRecordToMails',14,'SSalesProcesses',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(432,54,42,'getRecordToMails',15,'ProjectTask',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(433,42,54,'getEmails',3,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(434,54,41,'getRecordToMails',16,'ProjectMilestone',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(435,41,54,'getEmails',2,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(436,54,85,'getRecordToMails',17,'SQuoteEnquiries',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(437,54,87,'getRecordToMails',18,'SRequirementsCards',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(438,54,88,'getRecordToMails',19,'SCalculations',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(439,54,89,'getRecordToMails',20,'SQuotes',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(440,54,90,'getRecordToMails',21,'SSingleOrders',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(441,54,91,'getRecordToMails',22,'SRecurringOrders',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(442,26,18,'getCampaignsRecords',7,'Vendors',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(443,18,26,'getCampaigns',16,'Campaigns',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(444,26,4,'getCampaignsRecords',6,'Contacts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(445,4,26,'getCampaigns',8,'Campaigns',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(446,26,92,'getCampaignsRecords',8,'Partners',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(447,92,26,'getCampaigns',6,'Campaigns',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(448,26,93,'getCampaignsRecords',9,'Competition',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(449,93,26,'getCampaigns',6,'Campaigns',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(450,6,94,'getDependentsList',24,'FBookkeeping',0,'ADD',0,0,0,'RelatedTab','related_to',NULL,0),
			(451,6,95,'getDependentsList',25,'FInvoice',0,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(452,6,86,'getDependentsList',26,'SSalesProcesses',0,'ADD',0,0,0,'RelatedTab','related_to',NULL,0),
			(453,6,99,'getDependentsList',27,'FInvoiceProforma',0,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(454,97,100,'getDependentsList',4,'IGDN',0,'ADD',0,0,0,'RelatedTab','storageid',NULL,0),
			(455,100,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(456,101,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(457,97,101,'getDependentsList',5,'IIDN',0,'ADD',0,0,0,'RelatedTab','storageid',NULL,0),
			(458,98,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(459,97,98,'getDependentsList',3,'IGRN',0,'ADD',0,0,0,'RelatedTab','storageid',NULL,0),
			(460,102,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(461,97,102,'getDependentsList',6,'IGIN',0,'ADD',0,0,0,'RelatedTab','storageid',NULL,0),
			(462,97,14,'getManyToMany',1,'Products',0,'',0,0,0,'RelatedTab',NULL,NULL,0),
			(463,14,97,'getManyToMany',9,'IStorages',0,'',0,0,0,'RelatedTab',NULL,NULL,0),
			(464,103,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(465,97,103,'getDependentsList',7,'IPreOrder',0,'ADD',0,0,0,'RelatedTab','storageid',NULL,0),
			(466,97,8,'getAttachments',2,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(467,94,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(468,104,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(469,97,104,'getDependentsList',8,'ISTDN',0,'ADD',0,0,0,'RelatedTab','storageid',NULL,0),
			(470,105,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(471,105,9,'getRelatedList',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(472,104,9,'getRelatedList',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(473,98,9,'getRelatedList',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(474,100,9,'getRelatedList',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(475,101,9,'getRelatedList',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(476,102,9,'getRelatedList',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(477,103,9,'getRelatedList',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(478,106,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(479,106,9,'getRelatedList',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(480,97,106,'getDependentsList',9,'ISTRN',0,'ADD',0,0,0,'RelatedTab','storageid',NULL,0),
			(481,105,104,'getDependentsList',3,'ISTDN',0,'ADD',0,0,0,'RelatedTab','process',NULL,0),
			(482,105,106,'getDependentsList',4,'ISTRN',0,'ADD',0,0,0,'RelatedTab','process',NULL,0),
			(483,106,104,'getDependentsList',3,'ISTDN',0,'ADD',0,0,0,'RelatedTab','subprocess',NULL,0),
			(484,104,106,'getDependentsList',3,'ISTRN',0,'ADD',0,0,0,'RelatedTab','subprocess',NULL,0),
			(485,96,8,'getAttachments',2,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab,DetailBottom',NULL,NULL,0),
			(486,105,98,'getRelatedList',5,'IGRN',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(487,105,100,'getRelatedList',6,'IGDN',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(488,105,102,'getRelatedList',7,'IGIN',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(489,105,101,'getRelatedList',8,'IIDN',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(490,6,107,'getDependentsList',28,'FCorectingInvoice',0,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(491,95,107,'getDependentsList',1,'FCorectingInvoice',0,'ADD',0,0,0,'RelatedTab','finvoiceid',NULL,0),
			(492,108,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(493,108,9,'getRelatedList',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(494,97,108,'getDependentsList',10,'IGRNC',0,'ADD',0,0,0,'RelatedTab','storageid',NULL,0),
			(495,105,108,'getRelatedList',9,'IGRNC',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(496,98,108,'getDependentsList',3,'IGRNC',0,'ADD',0,0,0,'RelatedTab','igrnid',NULL,0),
			(497,109,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(498,109,9,'getRelatedList',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(499,97,109,'getDependentsList',11,'IGDNC',0,'ADD',0,0,0,'RelatedTab','storageid',NULL,0),
			(500,105,109,'getRelatedList',10,'IGDNC',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(501,100,109,'getDependentsList',3,'IGDNC',0,'ADD',0,0,0,'RelatedTab','igdnid',NULL,0),
			(502,14,15,'getDependentsList',10,'Faq',0,'ADD',0,0,0,'RelatedTab','product_id',NULL,0),
			(504,90,100,'getDependentsList',4,'IGDN',0,'ADD',0,0,0,'RelatedTab','ssingleordersid',NULL,0),
			(509,26,8,'getAttachments',3,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(510,13,14,'getRelatedList',20,'Products',1,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(511,13,58,'getRelatedList',21,'OSSSoldServices',1,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(512,58,13,'getDependentsList',2,'HelpDesk',0,'ADD',0,0,0,'RelatedTab','pssold_id',NULL,0),
			(513,26,86,'getDependentsList',10,'SSalesProcesses',0,'ADD',0,0,0,'RelatedTab','campaignid',NULL,0),
			(514,86,43,'getDependentsList',19,'Project',0,'ADD',0,0,0,'RelatedTab','ssalesprocessesid',NULL,0),
			(515,92,86,'getRelatedList',13,'SSalesProcesses',0,'SELECT,ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(516,18,86,'getRelatedList',17,'SSalesProcesses',0,'SELECT,ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(517,93,86,'getRelatedList',13,'SSalesProcesses',0,'SELECT,ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(518,86,92,'getRelatedList',20,'Partners',0,'SELECT,ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(519,86,18,'getRelatedList',21,'Vendors',0,'SELECT,ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(520,86,93,'getRelatedList',22,'Competition',0,'SELECT,ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(521,92,43,'getRelatedList',14,'Project',0,'SELECT,ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(523,43,18,'getRelatedList',11,'Vendors',0,'SELECT,ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(524,43,92,'getRelatedList',12,'Partners',0,'SELECT,ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(525,112,8,'getManyToMany',1,'Documents',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(526,113,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(527,114,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(528,115,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(529,117,8,'getAttachments',1,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(530,117,9,'getActivities',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(531,117,54,'getEmails',3,'OSSMailView',0,'SEND',0,0,0,'RelatedTab',NULL,NULL,0),
			(532,86,117,'getDependentsList',23,'SVendorEnquiries',0,'ADD',0,0,0,'RelatedTab','salesprocessid',NULL,0),
			(533,18,117,'getDependentsList',18,'SVendorEnquiries',0,'ADD',0,0,0,'RelatedTab','vendorid',NULL,0),
			(534,88,117,'getDependentsList',5,'SVendorEnquiries',0,'ADD',0,0,0,'RelatedTab','scalculationsid',NULL,0),
			(535,54,117,'getRecordToMails',23,'SVendorEnquiries',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(536,6,111,'getDependentsList',29,'Notification',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(537,13,111,'getDependentsList',22,'Notification',0,'ADD',0,0,0,'RelatedTab','subprocess',NULL,0),
			(538,4,37,'getDependentsList',9,'Assets',0,'ADD',0,0,0,'RelatedTab','contactid',NULL,0),
			(539,4,58,'getDependentsList',10,'OSSSoldServices',0,'ADD',0,0,0,'RelatedTab','contactid',NULL,0),
			(542,121,8,'getAttachments',3,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(543,121,92,'getRelatedList',4,'Partners',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(544,121,4,'getRelatedList',5,'Contacts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(545,121,61,'getRelatedList',6,'OSSEmployees',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(547,121,122,'getDependentsList',7,'ActivityRegister',0,'ADD',0,0,0,'RelatedTab','datasetregisterid',NULL,0),
			(549,122,8,'getAttachments',3,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(550,122,92,'getRelatedList',4,'Partners',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(551,122,4,'getRelatedList',5,'Contacts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(552,122,61,'getRelatedList',6,'OSSEmployees',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(555,123,8,'getAttachments',3,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(556,123,92,'getRelatedList',4,'Partners',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(557,123,4,'getRelatedList',5,'Contacts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(558,123,61,'getRelatedList',6,'OSSEmployees',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(559,123,124,'getDependentsList',7,'IncidentRegister',0,'ADD',0,0,0,'RelatedTab','locationregisterid',NULL,0),
			(560,121,124,'getDependentsList',8,'IncidentRegister',0,'ADD',0,0,0,'RelatedTab','datasetregisterid',NULL,0),
			(562,124,8,'getAttachments',2,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(563,124,92,'getRelatedList',3,'Partners',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(564,124,4,'getRelatedList',4,'Contacts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(565,124,61,'getRelatedList',5,'OSSEmployees',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(566,123,125,'getDependentsList',8,'AuditRegister',0,'ADD',0,0,0,'RelatedTab','locationregisterid',NULL,0),
			(567,121,125,'getDependentsList',9,'AuditRegister',0,'ADD',0,0,0,'RelatedTab','datasetregisterid',NULL,0),
			(569,125,8,'getAttachments',2,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(570,125,92,'getRelatedList',3,'Partners',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(571,125,4,'getRelatedList',4,'Contacts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(572,125,61,'getRelatedList',5,'OSSEmployees',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(573,121,123,'getRelatedList',10,'LocationRegister',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(574,123,121,'getRelatedList',9,'DataSetRegister',1,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(575,123,122,'getRelatedList',10,'ActivityRegister',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(576,93,93,'getDependentsList',14,'Competition',0,'ADD',0,0,0,'RelatedTab','parent_id',NULL,0),
			(577,91,4,'getRelatedList',4,'Contacts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(578,119,61,'getDependentsList',1,'OSSEmployees',0,'ADD,SELECT',0,0,0,'RelatedTab','multicompanyid',NULL,0),
			(579,6,85,'getDependentsList',30,'SQuoteEnquiries',1,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(580,6,89,'getDependentsList',31,'SQuotes',1,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(581,6,87,'getDependentsList',32,'SRequirementsCards',1,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(582,6,90,'getDependentsList',33,'SSingleOrders',1,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(583,6,91,'getDependentsList',34,'SRecurringOrders',1,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(584,6,117,'getDependentsList',35,'SVendorEnquiries',1,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(585,6,88,'getDependentsList',36,'SCalculations',1,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(586,7,85,'getDependentsList',23,'SQuoteEnquiries',0,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(587,41,9,'getActivities',3,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(588,95,9,'getActivities',2,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(589,42,9,'getActivities',4,'Activities',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(590,41,51,'getDependentsList',4,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','subprocess',NULL,0),
			(591,85,51,'getDependentsList',5,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','subprocess',NULL,0),
			(592,87,51,'getDependentsList',5,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','subprocess',NULL,0),
			(593,88,51,'getDependentsList',6,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','subprocess',NULL,0),
			(594,89,51,'getDependentsList',6,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','subprocess',NULL,0),
			(595,90,51,'getDependentsList',5,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','subprocess',NULL,0),
			(596,91,51,'getDependentsList',5,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','subprocess',NULL,0),
			(597,95,51,'getDependentsList',3,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','subprocess',NULL,0),
			(598,117,51,'getDependentsList',4,'OSSTimeControl',0,'ADD',0,0,0,'RelatedTab','subprocess',NULL,0),
			(599,86,95,'getDependentsList',24,'FInvoice',0,'ADD',0,0,0,'RelatedTab','ssalesprocessesid',NULL,0),
			(600,43,95,'getDependentsList',13,'FInvoice',0,'ADD',0,0,0,'RelatedTab','projectid',NULL,0),
			(601,34,37,'getRelatedList',8,'Assets',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(602,34,58,'getRelatedList',9,'OSSSoldServices',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(603,37,34,'getRelatedList',3,'ServiceContracts',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(604,58,34,'getRelatedList',3,'ServiceContracts',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(605,96,96,'getManyToMany',1,'LBL_RELATED_KNOWLEDGE_BASES',0,'SELECT',0,0,0,'RelatedTab,DetailBottom',NULL,NULL,0),
			(606,59,13,'getDependentsList',2,'HelpDesk',0,'ADD',0,0,0,'RelatedTab','pssold_id',NULL,0),
			(607,57,13,'getDependentsList',2,'HelpDesk',0,'ADD',0,0,0,'RelatedTab','pssold_id',NULL,0),
			(608,15,15,'getManyToMany',2,'LBL_RELATED_FAQ',0,'SELECT',0,0,0,'RelatedTab,DetailBottom',NULL,NULL,0),
			(609,15,13,'getRelatedList',3,'HelpDesk',0,'SELECT',0,0,0,'RelatedTab,DetailBottom',NULL,NULL,0),
			(610,15,43,'getRelatedList',4,'Project',0,'SELECT',0,0,0,'RelatedTab,DetailBottom',NULL,NULL,0),
			(611,96,13,'getRelatedList',3,'HelpDesk',0,'SELECT',0,0,0,'RelatedTab,DetailBottom',NULL,NULL,0),
			(612,96,43,'getRelatedList',4,'Project',0,'SELECT',0,0,0,'RelatedTab,DetailBottom',NULL,NULL,0),
			(613,13,15,'getRelatedList',23,'Faq',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(614,13,96,'getRelatedList',24,'KnowledgeBase',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(615,43,15,'getRelatedList',14,'Faq',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(616,43,96,'getRelatedList',15,'KnowledgeBase',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(617,90,79,'getDependentsList',6,'PaymentsIn',0,'ADD',0,0,0,'RelatedTab','ssingleordersid',NULL,0),
			(618,95,79,'getDependentsList',4,'PaymentsIn',0,'ADD',0,0,0,'RelatedTab','finvoiceid',NULL,0),
			(619,6,15,'getDependentsList',37,'Faq',0,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(620,4,13,'getRelatedList',5,'LBL_HELPDESK_RELATED',0,'',0,0,0,'RelatedTab',NULL,NULL,0),
			(621,127,128,'getDependentsList',1,'ApprovalsRegister',0,'ADD',0,0,0,'RelatedTab','approvalsid',NULL,0),
			(622,4,128,'getDependentsList',11,'ApprovalsRegister',0,'ADD',0,0,0,'RelatedTab','contactid',NULL,0),
			(624,131,4,'getRelatedMembers',2,'LBL_PARTICIPANTS',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(626,4,131,'getRelatedMembers',12,'Occurrences',0,'ADD',0,0,0,'RelatedTab',NULL,NULL,0),
			(627,130,131,'getDependentsList',1,'Occurrences',0,'ADD',0,0,0,'RelatedTab','locationid',NULL,0),
			(628,4,90,'getDependentsList',13,'SSingleOrders',0,'',0,0,0,'RelatedTab','contactid',NULL,0),
			(629,90,90,'getDependentsList',7,'SSingleOrders',0,'',0,0,0,'RelatedTab','parent_id',NULL,0),
			(630,89,89,'getDependentsList',7,'SQuotes',0,'',0,0,0,'RelatedTab','parent_id',NULL,0),
			(631,88,88,'getDependentsList',7,'SCalculations',0,'',0,0,0,'RelatedTab','parent_id',NULL,0),
			(632,132,132,'getDependentsList',1,'LBL_CHILD_PRODUCTCATEGORY',0,'ADD',0,0,0,'RelatedTab','parent_id',NULL,0),
			(633,14,132,'getRelatedList',1,'ProductCategory',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(634,132,14,'getRelatedList',2,'Products',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(635,85,4,'getRelatedList',4,'Contacts',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(636,131,8,'getAttachments',3,'Documents',0,'ADD,SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(637,119,133,'getDependentsList',2,'BankAccounts',0,'ADD',0,0,0,'RelatedTab','multicompanyid',NULL,0),
			(638,7,37,'getDependentsList',24,'Assets',1,'ADD',0,0,0,'RelatedTab','parent_id',NULL,0),
			(639,7,58,'getDependentsList',25,'OSSSoldServices',1,'ADD',0,0,0,'RelatedTab','parent_id',NULL,0),
			(640,35,58,'getDependentsList',12,'OSSSoldServices',1,'ADD',0,0,0,'RelatedTab','serviceid',NULL,0),
			(641,85,87,'getDependentsList',6,'SRequirementsCards',1,'ADD',0,0,0,'RelatedTab','quoteenquiryid',NULL,0),
			(642,18,98,'getDependentsList',19,'IGRN',1,'ADD',0,0,0,'RelatedTab','vendorid',NULL,0),
			(643,6,100,'getDependentsList',38,'IGDN',1,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(644,6,103,'getDependentsList',39,'IPreOrder',1,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(645,6,104,'getDependentsList',40,'ISTDN',1,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(646,18,106,'getDependentsList',20,'ISTRN',1,'ADD',0,0,0,'RelatedTab','vendorid',NULL,0),
			(647,18,108,'getDependentsList',21,'IGRNC',1,'ADD',0,0,0,'RelatedTab','vendorid',NULL,0),
			(648,6,109,'getDependentsList',41,'IGDNC',1,'ADD',0,0,0,'RelatedTab','accountid',NULL,0),
			(649,95,37,'getDependentsList',5,'Assets',1,'ADD',0,0,0,'RelatedTab','renewalinvoice',NULL,0),
			(650,95,58,'getDependentsList',6,'OSSSoldServices',1,'ADD',0,0,0,'RelatedTab','renewalinvoice',NULL,0),
			(651,82,81,'getDependentsList',3,'LettersIn',1,'ADD',0,0,0,'RelatedTab','outgoing_correspondence',NULL,0),
			(652,81,82,'getDependentsList',3,'LettersOut',1,'ADD',0,0,0,'RelatedTab','incoming_correspondence',NULL,0),
			(653,26,85,'getDependentsList',11,'SQuoteEnquiries',1,'ADD',0,0,0,'RelatedTab','campaign_id',NULL,0),
			(654,19,6,'getDependentsList',4,'Accounts',1,'ADD',0,0,0,'RelatedTab','pricebook_id',NULL,0),
			(655,97,90,'getDependentsList',12,'SSingleOrders',1,'ADD',0,0,0,'RelatedTab','istorageaddressid',NULL,0),
			(656,4,134,'getDependentsList',15,'Queue',1,'ADD',0,0,0,'RelatedTab','related_to',NULL,0),
			(657,6,134,'getDependentsList',42,'Queue',1,'ADD',0,0,0,'RelatedTab','related_to',NULL,0),
			(659,34,4,'getRelatedList',1,'Contacts',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(660,4,34,'getRelatedList',14,'ServiceContracts',0,'SELECT',0,0,0,'RelatedTab',NULL,NULL,0),
			(661,86,86,'getDependentsList',25,'SSalesProcesses',1,'',0,0,0,'RelatedTab','parentid',NULL,0),
			(662,119,135,'getDependentsList',4,'Passwords',0,'ADD',0,0,0,'RelatedTab','multicompanyid',NULL,0),
			(663,6,135,'getDependentsList',43,'Passwords',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(664,7,135,'getDependentsList',26,'Passwords',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(665,92,135,'getDependentsList',15,'Passwords',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(666,93,135,'getDependentsList',15,'Passwords',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(667,61,135,'getDependentsList',10,'Passwords',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(668,4,135,'getDependentsList',16,'Passwords',0,'ADD',0,0,0,'RelatedTab','linkextend',NULL,0),
			(669,4,13,'getDependentsList',4,'LBL_HELPDESK_DEPENDENTS',0,'ADD',0,0,0,'RelatedTab','contact_id',NULL,0),
			(670,42,111,'getDependentsList',5,'Notification',0,'ADD',0,0,0,'RelatedTab','subprocess_sl',NULL,0),
			(671,18,135,'getDependentsList',22,'Passwords',0,'ADD',0,0,0,'RelatedTab','link',NULL,0),
			(672,99,79,'getDependentsList',1,'PaymentsIn',0,'ADD',0,0,0,'RelatedTab','finvoiceproformaid',NULL,0),
			(673,6,45,'getDependentsList',44,'SMSNotifier',0,'ADD',0,0,0,'RelatedTab','related_to',NULL,0),
			(674,7,45,'getDependentsList',27,'SMSNotifier',0,'ADD',0,0,0,'RelatedTab','related_to',NULL,0),
			(675,18,45,'getDependentsList',23,'SMSNotifier',0,'ADD',0,0,0,'RelatedTab','related_to',NULL,0),
			(676,92,45,'getDependentsList',16,'SMSNotifier',0,'ADD',0,0,0,'RelatedTab','related_to',NULL,0),
			(677,93,45,'getDependentsList',16,'SMSNotifier',0,'ADD',0,0,0,'RelatedTab','related_to',NULL,0),
			(678,61,45,'getDependentsList',11,'SMSNotifier',0,'ADD',0,0,0,'RelatedTab','related_to',NULL,0),
			(679,4,45,'getDependentsList',17,'SMSNotifier',0,'ADD',0,0,0,'RelatedTab','related_to',NULL,0),
			(680,45,45,'getDependentsList',4,'SMSNotifier',0,'ADD',0,0,0,'RelatedTab','parentid',NULL,0),
			(684,6,133,'getDependentsList',45,'BankAccounts',0,'ADD',0,0,0,'RelatedTab','related_to',NULL,0),
			(686,138,8,'getAttachments',1,'Documents',0,'',0,0,0,'RelatedTab',NULL,NULL,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_reminder_interval`(`reminder_intervalid`,`reminder_interval`,`sortorderid`,`presence`) values
			(2,'1 Minute',1,1),
			(3,'5 Minutes',2,1),
			(4,'15 Minutes',3,1),
			(5,'30 Minutes',4,1),
			(6,'45 Minutes',5,1),
			(7,'1 Hour',6,1),
			(8,'1 Day',7,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_reservations_status`(`reservations_statusid`,`reservations_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_ACCEPTED',2,1,851),
			(2,'PLL_TO_APPROVAL',3,1,852),
			(3,'PLL_DRAFT',1,1,853),
			(4,'PLL_CANCELLED',4,1,854);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_role`(`roleid`,`rolename`,`parentrole`,`depth`,`company`,`allowassignedrecordsto`,`changeowner`,`searchunpriv`,`clendarallorecords`,`listrelatedrecord`,`previewrelatedrecord`,`editrelatedrecord`,`permissionsrelatedfield`,`globalsearchadv`,`assignedmultiowner`,`auto_assign`) values
			('H1','Organization','H1',0,1,1,1,NULL,1,0,0,0,'0',1,0,0),
			('H10','Sales Department','H1::H2::H10',2,1,1,1,NULL,3,0,0,0,'0',1,1,0),
			('H14','Logistics Department','H1::H2::H14',2,1,1,1,NULL,3,0,0,0,'0',1,1,0),
			('H18','Project Management Department','H1::H2::H18',2,1,1,1,NULL,3,0,0,0,'0',1,1,0),
			('H2','Board of Management','H1::H2',1,1,1,1,NULL,3,0,0,0,'0',1,1,0),
			('H22','Help Desk Department','H1::H2::H22',2,1,1,1,NULL,3,0,0,0,'0',1,1,0),
			('H26','Human Resources Department','H1::H2::H26',2,1,1,1,NULL,3,0,0,0,'0',1,1,0),
			('H3','Secretary\'s Office','H1::H2::H3',2,1,1,1,NULL,3,0,0,0,'0',1,1,0),
			('H30','Financial Department','H1::H2::H30',2,1,1,1,NULL,3,0,0,0,'0',1,1,0),
			('H34','Production Department','H1::H2::H34',2,1,1,1,NULL,3,0,0,0,'0',1,1,0),
			('H6','Marketing Department','H1::H2::H6',2,1,1,1,NULL,3,0,0,0,'0',1,1,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_role2picklist`(`roleid`,`picklistvalueid`,`picklistid`,`sortid`) values
			('H1',659,85,1),
			('H1',660,85,2),
			('H1',661,85,3),
			('H1',668,87,1),
			('H1',670,89,1),
			('H1',675,90,1),
			('H1',676,90,2),
			('H1',677,90,3),
			('H1',678,90,4),
			('H1',679,90,5),
			('H1',680,90,6),
			('H1',681,90,7),
			('H1',682,91,1),
			('H1',683,91,2),
			('H1',684,91,3),
			('H1',685,91,4),
			('H1',686,91,5),
			('H1',687,91,6),
			('H1',688,91,7),
			('H1',692,93,1),
			('H1',697,94,1),
			('H1',698,94,2),
			('H1',699,94,3),
			('H1',703,95,1),
			('H1',704,95,2),
			('H1',705,96,1),
			('H1',706,96,2),
			('H1',707,96,3),
			('H1',708,96,4),
			('H1',709,96,5),
			('H1',710,96,6),
			('H1',711,96,7),
			('H1',712,96,8),
			('H1',717,98,1),
			('H1',718,98,2),
			('H1',719,98,3),
			('H1',728,100,1),
			('H1',729,100,2),
			('H1',730,100,3),
			('H1',731,100,4),
			('H1',732,100,5),
			('H1',733,100,6),
			('H1',734,100,7),
			('H1',735,100,8),
			('H1',736,100,9),
			('H1',738,102,1),
			('H1',739,102,2),
			('H1',740,102,3),
			('H1',741,102,4),
			('H1',742,102,5),
			('H1',743,102,6),
			('H1',744,102,7),
			('H1',745,102,8),
			('H1',749,104,1),
			('H1',750,104,2),
			('H1',751,104,3),
			('H1',752,104,4),
			('H1',753,104,5),
			('H1',754,104,6),
			('H1',755,104,7),
			('H1',756,104,8),
			('H1',757,105,1),
			('H1',758,105,2),
			('H1',759,105,3),
			('H1',760,106,1),
			('H1',761,106,2),
			('H1',762,106,3),
			('H1',763,106,4),
			('H1',773,141,1),
			('H1',774,141,2),
			('H1',775,141,3),
			('H1',776,141,4),
			('H1',777,141,5),
			('H1',778,108,1),
			('H1',779,108,2),
			('H1',780,108,3),
			('H1',781,108,4),
			('H1',782,108,5),
			('H1',783,108,6),
			('H1',784,109,1),
			('H1',785,109,2),
			('H1',786,109,3),
			('H1',787,109,4),
			('H1',788,109,5),
			('H1',789,109,6),
			('H1',790,110,1),
			('H1',791,110,2),
			('H1',792,110,3),
			('H1',793,110,4),
			('H1',794,110,5),
			('H1',795,110,6),
			('H1',796,111,1),
			('H1',797,111,2),
			('H1',798,111,3),
			('H1',799,111,4),
			('H1',800,111,5),
			('H1',801,111,6),
			('H1',802,112,1),
			('H1',803,112,2),
			('H1',804,112,3),
			('H1',805,112,4),
			('H1',806,112,5),
			('H1',807,112,6),
			('H1',808,113,1),
			('H1',809,113,2),
			('H1',810,113,3),
			('H1',811,113,4),
			('H1',812,113,5),
			('H1',813,113,6),
			('H1',814,114,1),
			('H1',815,114,2),
			('H1',816,114,3),
			('H1',817,114,4),
			('H1',818,114,5),
			('H1',819,114,6),
			('H1',820,115,1),
			('H1',821,115,2),
			('H1',822,115,3),
			('H1',823,115,4),
			('H1',824,115,5),
			('H1',825,115,6),
			('H1',826,116,1),
			('H1',827,116,2),
			('H1',828,116,3),
			('H1',829,116,4),
			('H1',830,116,5),
			('H1',831,116,6),
			('H1',832,117,1),
			('H1',833,117,2),
			('H1',834,117,3),
			('H1',835,117,4),
			('H1',836,117,5),
			('H1',837,117,6),
			('H1',838,118,1),
			('H1',839,118,2),
			('H1',840,118,3),
			('H1',841,118,4),
			('H1',842,118,5),
			('H1',843,118,6),
			('H1',844,118,7),
			('H1',845,119,1),
			('H1',846,119,2),
			('H1',847,120,1),
			('H1',848,120,2),
			('H1',849,121,1),
			('H1',850,121,2),
			('H1',851,122,2),
			('H1',852,122,3),
			('H1',853,122,1),
			('H1',854,122,4),
			('H1',855,123,1),
			('H1',856,123,2),
			('H1',857,123,3),
			('H1',858,123,4),
			('H1',859,123,5),
			('H1',860,124,1),
			('H1',861,124,2),
			('H1',862,124,3),
			('H1',863,124,4),
			('H1',864,124,5),
			('H1',865,125,1),
			('H1',866,125,2),
			('H1',867,125,3),
			('H1',868,125,4),
			('H1',869,125,5),
			('H1',870,125,6),
			('H1',871,125,7),
			('H1',872,126,1),
			('H1',873,126,2),
			('H1',874,126,3),
			('H1',875,126,4),
			('H1',876,126,5),
			('H1',877,126,6),
			('H1',878,126,7),
			('H1',879,126,8),
			('H1',880,126,9),
			('H1',881,127,1),
			('H1',882,127,2),
			('H1',883,127,3),
			('H1',884,127,4),
			('H1',885,127,5),
			('H1',886,128,1),
			('H1',887,128,2),
			('H1',888,128,3),
			('H1',889,128,4),
			('H1',890,128,5),
			('H1',891,128,6),
			('H1',892,128,7),
			('H1',893,128,8),
			('H1',894,128,9),
			('H1',895,128,10),
			('H1',896,128,11),
			('H1',897,128,12),
			('H1',898,128,13),
			('H1',899,128,14),
			('H1',900,128,15),
			('H1',901,128,16),
			('H1',902,129,1),
			('H1',903,129,2),
			('H1',904,129,3),
			('H1',905,129,4),
			('H1',906,129,5),
			('H1',907,129,6),
			('H1',908,130,1),
			('H1',909,130,2),
			('H1',914,131,1),
			('H1',915,131,2),
			('H1',916,131,3),
			('H1',917,131,4),
			('H1',918,131,5),
			('H1',931,133,1),
			('H1',932,133,2),
			('H1',933,134,1),
			('H1',934,134,2),
			('H1',935,134,3),
			('H1',936,134,4),
			('H1',937,135,1),
			('H1',938,135,2),
			('H1',939,135,3),
			('H1',940,136,1),
			('H1',941,136,2),
			('H1',942,136,3),
			('H1',943,137,1),
			('H1',944,137,2),
			('H1',945,137,3),
			('H1',946,137,4),
			('H1',947,137,5),
			('H1',950,138,1),
			('H1',951,138,2),
			('H1',952,138,3),
			('H1',953,138,4),
			('H1',954,138,5),
			('H1',955,138,6),
			('H1',956,138,7),
			('H1',957,139,1),
			('H1',958,139,2),
			('H1',959,139,3),
			('H1',960,139,4),
			('H1',961,139,5),
			('H1',962,139,6),
			('H1',966,141,1),
			('H1',967,141,2),
			('H1',968,141,3),
			('H1',969,141,4),
			('H1',970,141,5),
			('H10',1,1,0),
			('H10',2,1,1),
			('H10',3,1,2),
			('H10',4,1,3),
			('H10',5,1,4),
			('H10',6,1,5),
			('H10',7,1,6),
			('H10',8,1,7),
			('H10',9,1,8),
			('H10',10,1,9),
			('H10',11,1,10),
			('H10',14,3,0),
			('H10',15,3,1),
			('H10',16,3,2),
			('H10',17,3,3),
			('H10',18,3,4),
			('H10',19,3,5),
			('H10',20,4,0),
			('H10',21,4,1),
			('H10',22,4,2),
			('H10',23,4,3),
			('H10',24,4,4),
			('H10',25,4,5),
			('H10',26,4,6),
			('H10',27,4,7),
			('H10',28,4,8),
			('H10',29,4,9),
			('H10',30,4,10),
			('H10',31,4,11),
			('H10',32,4,12),
			('H10',41,7,0),
			('H10',42,7,1),
			('H10',43,7,2),
			('H10',44,7,3),
			('H10',45,7,4),
			('H10',47,9,0),
			('H10',48,9,1),
			('H10',49,9,2),
			('H10',50,9,3),
			('H10',51,10,0),
			('H10',52,10,1),
			('H10',53,10,2),
			('H10',54,10,3),
			('H10',55,10,4),
			('H10',56,10,5),
			('H10',57,10,6),
			('H10',58,10,7),
			('H10',59,10,8),
			('H10',60,11,0),
			('H10',61,11,1),
			('H10',98,13,0),
			('H10',99,13,1),
			('H10',101,13,3),
			('H10',106,13,8),
			('H10',107,13,9),
			('H10',108,13,10),
			('H10',109,13,11),
			('H10',110,13,12),
			('H10',111,14,0),
			('H10',123,15,0),
			('H10',124,15,1),
			('H10',125,15,2),
			('H10',126,15,3),
			('H10',160,22,0),
			('H10',161,22,1),
			('H10',162,22,2),
			('H10',163,22,3),
			('H10',164,22,4),
			('H10',165,22,5),
			('H10',170,24,0),
			('H10',171,24,1),
			('H10',172,24,2),
			('H10',173,25,0),
			('H10',174,25,1),
			('H10',175,25,2),
			('H10',176,25,3),
			('H10',177,25,4),
			('H10',178,25,5),
			('H10',182,27,0),
			('H10',183,27,1),
			('H10',184,27,2),
			('H10',185,27,3),
			('H10',186,28,0),
			('H10',187,28,1),
			('H10',188,28,2),
			('H10',189,28,3),
			('H10',190,29,0),
			('H10',191,29,1),
			('H10',192,29,2),
			('H10',193,29,3),
			('H10',194,30,0),
			('H10',195,30,1),
			('H10',196,30,2),
			('H10',197,30,3),
			('H10',198,30,4),
			('H10',210,31,1),
			('H10',211,31,2),
			('H10',212,31,3),
			('H10',213,31,4),
			('H10',214,32,1),
			('H10',215,32,2),
			('H10',216,32,3),
			('H10',217,32,4),
			('H10',218,32,5),
			('H10',219,32,6),
			('H10',220,33,1),
			('H10',221,33,2),
			('H10',222,33,3),
			('H10',223,34,1),
			('H10',224,34,2),
			('H10',225,34,3),
			('H10',226,35,1),
			('H10',227,35,2),
			('H10',228,35,3),
			('H10',237,38,1),
			('H10',238,38,2),
			('H10',239,38,3),
			('H10',240,38,4),
			('H10',241,39,1),
			('H10',242,39,2),
			('H10',243,39,3),
			('H10',244,39,4),
			('H10',245,40,1),
			('H10',246,40,2),
			('H10',247,40,3),
			('H10',248,40,4),
			('H10',260,42,1),
			('H10',261,42,2),
			('H10',262,42,3),
			('H10',263,42,4),
			('H10',264,42,5),
			('H10',265,42,6),
			('H10',266,42,7),
			('H10',269,43,1),
			('H10',270,43,2),
			('H10',271,43,3),
			('H10',272,43,4),
			('H10',273,44,1),
			('H10',274,44,2),
			('H10',275,44,3),
			('H10',276,44,4),
			('H10',289,46,1),
			('H10',290,46,2),
			('H10',291,46,3),
			('H10',292,46,4),
			('H10',293,46,5),
			('H10',294,46,6),
			('H10',323,49,2),
			('H10',324,49,3),
			('H10',387,29,NULL),
			('H10',388,57,1),
			('H10',389,57,2),
			('H10',401,59,1),
			('H10',402,59,2),
			('H10',403,60,1),
			('H10',404,60,2),
			('H10',416,63,1),
			('H10',417,63,2),
			('H10',418,63,3),
			('H10',419,64,1),
			('H10',420,64,2),
			('H10',422,65,1),
			('H10',423,65,2),
			('H10',424,65,3),
			('H10',425,66,1),
			('H10',426,66,2),
			('H10',427,66,3),
			('H10',440,68,1),
			('H10',444,68,2),
			('H10',445,68,3),
			('H10',446,14,12),
			('H10',451,14,17),
			('H10',452,14,18),
			('H10',453,14,19),
			('H10',455,11,2),
			('H10',456,11,3),
			('H10',457,11,4),
			('H10',458,11,5),
			('H10',459,11,6),
			('H10',460,11,7),
			('H10',461,11,8),
			('H10',462,11,9),
			('H10',463,11,10),
			('H10',464,11,11),
			('H10',465,11,12),
			('H10',508,37,3),
			('H10',509,37,4),
			('H10',510,37,5),
			('H10',511,37,6),
			('H10',557,29,4),
			('H10',559,70,1),
			('H10',560,70,2),
			('H10',564,71,1),
			('H10',565,71,2),
			('H10',576,74,1),
			('H10',577,74,2),
			('H10',578,74,3),
			('H10',579,74,4),
			('H10',580,74,5),
			('H10',581,74,6),
			('H10',582,74,7),
			('H10',583,74,8),
			('H10',584,74,9),
			('H10',585,74,10),
			('H10',586,74,11),
			('H10',587,75,1),
			('H10',588,75,2),
			('H10',589,75,3),
			('H10',590,76,1),
			('H10',591,76,2),
			('H10',592,76,3),
			('H10',593,77,1),
			('H10',594,77,2),
			('H10',595,77,3),
			('H10',596,77,4),
			('H10',597,77,5),
			('H10',598,77,6),
			('H10',599,77,7),
			('H10',600,77,8),
			('H10',601,77,9),
			('H10',602,77,10),
			('H10',603,77,11),
			('H10',604,77,12),
			('H10',605,77,13),
			('H10',606,77,14),
			('H10',607,77,15),
			('H10',608,78,1),
			('H10',609,78,2),
			('H10',610,78,3),
			('H10',611,78,4),
			('H10',612,78,5),
			('H10',613,78,6),
			('H10',614,78,7),
			('H10',615,78,8),
			('H10',616,78,9),
			('H10',617,78,10),
			('H10',618,78,11),
			('H10',619,78,12),
			('H10',620,78,13),
			('H10',621,78,14),
			('H10',622,78,15),
			('H10',659,85,1),
			('H10',660,85,2),
			('H10',661,85,3),
			('H10',668,87,1),
			('H10',670,89,1),
			('H10',672,37,7),
			('H10',675,90,1),
			('H10',676,90,2),
			('H10',677,90,3),
			('H10',678,90,4),
			('H10',679,90,5),
			('H10',680,90,6),
			('H10',681,90,7),
			('H10',682,91,1),
			('H10',683,91,2),
			('H10',684,91,3),
			('H10',685,91,4),
			('H10',686,91,5),
			('H10',687,91,6),
			('H10',688,91,7),
			('H10',689,63,4),
			('H10',690,63,5),
			('H10',692,93,1),
			('H10',694,29,5),
			('H10',695,29,6),
			('H10',696,29,7),
			('H10',697,94,1),
			('H10',698,94,2),
			('H10',699,94,3),
			('H10',700,57,3),
			('H10',701,90,8),
			('H10',702,91,8),
			('H10',703,95,1),
			('H10',704,95,2),
			('H10',705,96,1),
			('H10',706,96,2),
			('H10',707,96,3),
			('H10',708,96,4),
			('H10',709,96,5),
			('H10',710,96,6),
			('H10',711,96,7),
			('H10',712,96,8),
			('H10',717,98,1),
			('H10',718,98,2),
			('H10',719,98,3),
			('H10',720,14,20),
			('H10',721,14,21),
			('H10',722,14,22),
			('H10',728,100,1),
			('H10',729,100,2),
			('H10',730,100,3),
			('H10',731,100,4),
			('H10',732,100,5),
			('H10',733,100,6),
			('H10',734,100,7),
			('H10',735,100,8),
			('H10',736,100,9),
			('H10',738,102,1),
			('H10',739,102,2),
			('H10',740,102,3),
			('H10',741,102,4),
			('H10',742,102,5),
			('H10',743,102,6),
			('H10',744,102,7),
			('H10',745,102,8),
			('H10',749,104,1),
			('H10',750,104,2),
			('H10',751,104,3),
			('H10',752,104,4),
			('H10',753,104,5),
			('H10',754,104,6),
			('H10',755,104,7),
			('H10',756,104,8),
			('H10',757,105,1),
			('H10',758,105,2),
			('H10',759,105,3),
			('H10',760,106,1),
			('H10',761,106,2),
			('H10',762,106,3),
			('H10',763,106,4),
			('H10',771,87,7),
			('H10',772,87,8),
			('H10',773,141,1),
			('H10',774,141,2),
			('H10',775,141,3),
			('H10',776,141,4),
			('H10',777,141,5),
			('H10',778,108,1),
			('H10',779,108,2),
			('H10',780,108,3),
			('H10',781,108,4),
			('H10',782,108,5),
			('H10',783,108,6),
			('H10',784,109,1),
			('H10',785,109,2),
			('H10',786,109,3),
			('H10',787,109,4),
			('H10',788,109,5),
			('H10',789,109,6),
			('H10',790,110,1),
			('H10',791,110,2),
			('H10',792,110,3),
			('H10',793,110,4),
			('H10',794,110,5),
			('H10',795,110,6),
			('H10',796,111,1),
			('H10',797,111,2),
			('H10',798,111,3),
			('H10',799,111,4),
			('H10',800,111,5),
			('H10',801,111,6),
			('H10',802,112,1),
			('H10',803,112,2),
			('H10',804,112,3),
			('H10',805,112,4),
			('H10',806,112,5),
			('H10',807,112,6),
			('H10',808,113,1),
			('H10',809,113,2),
			('H10',810,113,3),
			('H10',811,113,4),
			('H10',812,113,5),
			('H10',813,113,6),
			('H10',814,114,1),
			('H10',815,114,2),
			('H10',816,114,3),
			('H10',817,114,4),
			('H10',818,114,5),
			('H10',819,114,6),
			('H10',820,115,1),
			('H10',821,115,2),
			('H10',822,115,3),
			('H10',823,115,4),
			('H10',824,115,5),
			('H10',825,115,6),
			('H10',826,116,1),
			('H10',827,116,2),
			('H10',828,116,3),
			('H10',829,116,4),
			('H10',830,116,5),
			('H10',831,116,6),
			('H10',832,117,1),
			('H10',833,117,2),
			('H10',834,117,3),
			('H10',835,117,4),
			('H10',836,117,5),
			('H10',837,117,6),
			('H10',838,118,1),
			('H10',839,118,2),
			('H10',840,118,3),
			('H10',841,118,4),
			('H10',842,118,5),
			('H10',843,118,6),
			('H10',844,118,7),
			('H10',845,119,1),
			('H10',846,119,2),
			('H10',847,120,1),
			('H10',848,120,2),
			('H10',849,121,1),
			('H10',850,121,2),
			('H10',851,122,2),
			('H10',852,122,3),
			('H10',853,122,1),
			('H10',854,122,4),
			('H10',855,123,1),
			('H10',856,123,2),
			('H10',857,123,3),
			('H10',858,123,4),
			('H10',859,123,5),
			('H10',860,124,1),
			('H10',861,124,2),
			('H10',862,124,3),
			('H10',863,124,4),
			('H10',864,124,5),
			('H10',865,125,1),
			('H10',866,125,2),
			('H10',867,125,3),
			('H10',868,125,4),
			('H10',869,125,5),
			('H10',870,125,6),
			('H10',871,125,7),
			('H10',872,126,1),
			('H10',873,126,2),
			('H10',874,126,3),
			('H10',875,126,4),
			('H10',876,126,5),
			('H10',877,126,6),
			('H10',878,126,7),
			('H10',879,126,8),
			('H10',880,126,9),
			('H10',881,127,1),
			('H10',882,127,2),
			('H10',883,127,3),
			('H10',884,127,4),
			('H10',885,127,5),
			('H10',886,128,1),
			('H10',887,128,2),
			('H10',888,128,3),
			('H10',889,128,4),
			('H10',890,128,5),
			('H10',891,128,6),
			('H10',892,128,7),
			('H10',893,128,8),
			('H10',894,128,9),
			('H10',895,128,10),
			('H10',896,128,11),
			('H10',897,128,12),
			('H10',898,128,13),
			('H10',899,128,14),
			('H10',900,128,15),
			('H10',901,128,16),
			('H10',902,129,1),
			('H10',903,129,2),
			('H10',904,129,3),
			('H10',905,129,4),
			('H10',906,129,5),
			('H10',907,129,6),
			('H10',908,130,1),
			('H10',909,130,2),
			('H10',910,119,3),
			('H10',911,119,4),
			('H10',912,119,5),
			('H10',913,119,6),
			('H10',914,131,1),
			('H10',915,131,2),
			('H10',916,131,3),
			('H10',917,131,4),
			('H10',918,131,5),
			('H10',922,46,7),
			('H10',923,46,8),
			('H10',924,131,6),
			('H10',931,133,1),
			('H10',932,133,2),
			('H10',933,134,1),
			('H10',934,134,2),
			('H10',935,134,3),
			('H10',936,134,4),
			('H10',937,135,1),
			('H10',938,135,2),
			('H10',939,135,3),
			('H10',940,136,1),
			('H10',941,136,2),
			('H10',942,136,3),
			('H10',943,137,1),
			('H10',944,137,2),
			('H10',945,137,3),
			('H10',946,137,4),
			('H10',947,137,5),
			('H10',948,13,13),
			('H10',949,129,7),
			('H10',950,138,1),
			('H10',951,138,2),
			('H10',952,138,3),
			('H10',953,138,4),
			('H10',954,138,5),
			('H10',955,138,6),
			('H10',956,138,7),
			('H10',957,139,1),
			('H10',958,139,2),
			('H10',959,139,3),
			('H10',960,139,4),
			('H10',961,139,5),
			('H10',962,139,6),
			('H10',966,141,1),
			('H10',967,141,2),
			('H10',968,141,3),
			('H10',969,141,4),
			('H10',970,141,5),
			('H14',1,1,0),
			('H14',2,1,1),
			('H14',3,1,2),
			('H14',4,1,3),
			('H14',5,1,4),
			('H14',6,1,5),
			('H14',7,1,6),
			('H14',8,1,7),
			('H14',9,1,8),
			('H14',10,1,9),
			('H14',11,1,10),
			('H14',14,3,0),
			('H14',15,3,1),
			('H14',16,3,2),
			('H14',17,3,3),
			('H14',18,3,4),
			('H14',19,3,5),
			('H14',20,4,0),
			('H14',21,4,1),
			('H14',22,4,2),
			('H14',23,4,3),
			('H14',24,4,4),
			('H14',25,4,5),
			('H14',26,4,6),
			('H14',27,4,7),
			('H14',28,4,8),
			('H14',29,4,9),
			('H14',30,4,10),
			('H14',31,4,11),
			('H14',32,4,12),
			('H14',41,7,0),
			('H14',42,7,1),
			('H14',43,7,2),
			('H14',44,7,3),
			('H14',45,7,4),
			('H14',47,9,0),
			('H14',48,9,1),
			('H14',49,9,2),
			('H14',50,9,3),
			('H14',51,10,0),
			('H14',52,10,1),
			('H14',53,10,2),
			('H14',54,10,3),
			('H14',55,10,4),
			('H14',56,10,5),
			('H14',57,10,6),
			('H14',58,10,7),
			('H14',59,10,8),
			('H14',60,11,0),
			('H14',61,11,1),
			('H14',98,13,0),
			('H14',99,13,1),
			('H14',101,13,3),
			('H14',106,13,8),
			('H14',107,13,9),
			('H14',108,13,10),
			('H14',109,13,11),
			('H14',110,13,12),
			('H14',111,14,0),
			('H14',123,15,0),
			('H14',124,15,1),
			('H14',125,15,2),
			('H14',126,15,3),
			('H14',160,22,0),
			('H14',161,22,1),
			('H14',162,22,2),
			('H14',163,22,3),
			('H14',164,22,4),
			('H14',165,22,5),
			('H14',170,24,0),
			('H14',171,24,1),
			('H14',172,24,2),
			('H14',173,25,0),
			('H14',174,25,1),
			('H14',175,25,2),
			('H14',176,25,3),
			('H14',177,25,4),
			('H14',178,25,5),
			('H14',182,27,0),
			('H14',183,27,1),
			('H14',184,27,2),
			('H14',185,27,3),
			('H14',186,28,0),
			('H14',187,28,1),
			('H14',188,28,2),
			('H14',189,28,3),
			('H14',190,29,0),
			('H14',191,29,1),
			('H14',192,29,2),
			('H14',193,29,3),
			('H14',194,30,0),
			('H14',195,30,1),
			('H14',196,30,2),
			('H14',197,30,3),
			('H14',198,30,4),
			('H14',210,31,1),
			('H14',211,31,2),
			('H14',212,31,3),
			('H14',213,31,4),
			('H14',214,32,1),
			('H14',215,32,2),
			('H14',216,32,3),
			('H14',217,32,4),
			('H14',218,32,5),
			('H14',219,32,6),
			('H14',220,33,1),
			('H14',221,33,2),
			('H14',222,33,3),
			('H14',223,34,1),
			('H14',224,34,2),
			('H14',225,34,3),
			('H14',226,35,1),
			('H14',227,35,2),
			('H14',228,35,3),
			('H14',237,38,1),
			('H14',238,38,2),
			('H14',239,38,3),
			('H14',240,38,4),
			('H14',241,39,1),
			('H14',242,39,2),
			('H14',243,39,3),
			('H14',244,39,4),
			('H14',245,40,1),
			('H14',246,40,2),
			('H14',247,40,3),
			('H14',248,40,4),
			('H14',260,42,1),
			('H14',261,42,2),
			('H14',262,42,3),
			('H14',263,42,4),
			('H14',264,42,5),
			('H14',265,42,6),
			('H14',266,42,7),
			('H14',269,43,1),
			('H14',270,43,2),
			('H14',271,43,3),
			('H14',272,43,4),
			('H14',273,44,1),
			('H14',274,44,2),
			('H14',275,44,3),
			('H14',276,44,4),
			('H14',289,46,1),
			('H14',290,46,2),
			('H14',291,46,3),
			('H14',292,46,4),
			('H14',293,46,5),
			('H14',294,46,6),
			('H14',323,49,2),
			('H14',324,49,3),
			('H14',387,29,NULL),
			('H14',388,57,1),
			('H14',389,57,2),
			('H14',401,59,1),
			('H14',402,59,2),
			('H14',403,60,1),
			('H14',404,60,2),
			('H14',416,63,1),
			('H14',417,63,2),
			('H14',418,63,3),
			('H14',419,64,1),
			('H14',420,64,2),
			('H14',422,65,1),
			('H14',423,65,2),
			('H14',424,65,3),
			('H14',425,66,1),
			('H14',426,66,2),
			('H14',427,66,3),
			('H14',440,68,1),
			('H14',444,68,2),
			('H14',445,68,3),
			('H14',446,14,12),
			('H14',451,14,17),
			('H14',452,14,18),
			('H14',453,14,19),
			('H14',455,11,2),
			('H14',456,11,3),
			('H14',457,11,4),
			('H14',458,11,5),
			('H14',459,11,6),
			('H14',460,11,7),
			('H14',461,11,8),
			('H14',462,11,9),
			('H14',463,11,10),
			('H14',464,11,11),
			('H14',465,11,12),
			('H14',508,37,3),
			('H14',509,37,4),
			('H14',510,37,5),
			('H14',511,37,6),
			('H14',557,29,4),
			('H14',559,70,1),
			('H14',560,70,2),
			('H14',564,71,1),
			('H14',565,71,2),
			('H14',576,74,1),
			('H14',577,74,2),
			('H14',578,74,3),
			('H14',579,74,4),
			('H14',580,74,5),
			('H14',581,74,6),
			('H14',582,74,7),
			('H14',583,74,8),
			('H14',584,74,9),
			('H14',585,74,10),
			('H14',586,74,11),
			('H14',587,75,1),
			('H14',588,75,2),
			('H14',589,75,3),
			('H14',590,76,1),
			('H14',591,76,2),
			('H14',592,76,3),
			('H14',593,77,1),
			('H14',594,77,2),
			('H14',595,77,3),
			('H14',596,77,4),
			('H14',597,77,5),
			('H14',598,77,6),
			('H14',599,77,7),
			('H14',600,77,8),
			('H14',601,77,9),
			('H14',602,77,10),
			('H14',603,77,11),
			('H14',604,77,12),
			('H14',605,77,13),
			('H14',606,77,14),
			('H14',607,77,15),
			('H14',608,78,1),
			('H14',609,78,2),
			('H14',610,78,3),
			('H14',611,78,4),
			('H14',612,78,5),
			('H14',613,78,6),
			('H14',614,78,7),
			('H14',615,78,8),
			('H14',616,78,9),
			('H14',617,78,10),
			('H14',618,78,11),
			('H14',619,78,12),
			('H14',620,78,13),
			('H14',621,78,14),
			('H14',622,78,15),
			('H14',659,85,1),
			('H14',660,85,2),
			('H14',661,85,3),
			('H14',668,87,1),
			('H14',670,89,1),
			('H14',672,37,7),
			('H14',675,90,1),
			('H14',676,90,2),
			('H14',677,90,3),
			('H14',678,90,4),
			('H14',679,90,5),
			('H14',680,90,6),
			('H14',681,90,7),
			('H14',682,91,1),
			('H14',683,91,2),
			('H14',684,91,3),
			('H14',685,91,4),
			('H14',686,91,5),
			('H14',687,91,6),
			('H14',688,91,7),
			('H14',689,63,4),
			('H14',690,63,5),
			('H14',692,93,1),
			('H14',694,29,5),
			('H14',695,29,6),
			('H14',696,29,7),
			('H14',697,94,1),
			('H14',698,94,2),
			('H14',699,94,3),
			('H14',700,57,3),
			('H14',701,90,8),
			('H14',702,91,8),
			('H14',703,95,1),
			('H14',704,95,2),
			('H14',705,96,1),
			('H14',706,96,2),
			('H14',707,96,3),
			('H14',708,96,4),
			('H14',709,96,5),
			('H14',710,96,6),
			('H14',711,96,7),
			('H14',712,96,8),
			('H14',717,98,1),
			('H14',718,98,2),
			('H14',719,98,3),
			('H14',720,14,20),
			('H14',721,14,21),
			('H14',722,14,22),
			('H14',728,100,1),
			('H14',729,100,2),
			('H14',730,100,3),
			('H14',731,100,4),
			('H14',732,100,5),
			('H14',733,100,6),
			('H14',734,100,7),
			('H14',735,100,8),
			('H14',736,100,9),
			('H14',738,102,1),
			('H14',739,102,2),
			('H14',740,102,3),
			('H14',741,102,4),
			('H14',742,102,5),
			('H14',743,102,6),
			('H14',744,102,7),
			('H14',745,102,8),
			('H14',749,104,1),
			('H14',750,104,2),
			('H14',751,104,3),
			('H14',752,104,4),
			('H14',753,104,5),
			('H14',754,104,6),
			('H14',755,104,7),
			('H14',756,104,8),
			('H14',757,105,1),
			('H14',758,105,2),
			('H14',759,105,3),
			('H14',760,106,1),
			('H14',761,106,2),
			('H14',762,106,3),
			('H14',763,106,4),
			('H14',771,87,7),
			('H14',772,87,8),
			('H14',773,141,1),
			('H14',774,141,2),
			('H14',775,141,3),
			('H14',776,141,4),
			('H14',777,141,5),
			('H14',778,108,1),
			('H14',779,108,2),
			('H14',780,108,3),
			('H14',781,108,4),
			('H14',782,108,5),
			('H14',783,108,6),
			('H14',784,109,1),
			('H14',785,109,2),
			('H14',786,109,3),
			('H14',787,109,4),
			('H14',788,109,5),
			('H14',789,109,6),
			('H14',790,110,1),
			('H14',791,110,2),
			('H14',792,110,3),
			('H14',793,110,4),
			('H14',794,110,5),
			('H14',795,110,6),
			('H14',796,111,1),
			('H14',797,111,2),
			('H14',798,111,3),
			('H14',799,111,4),
			('H14',800,111,5),
			('H14',801,111,6),
			('H14',802,112,1),
			('H14',803,112,2),
			('H14',804,112,3),
			('H14',805,112,4),
			('H14',806,112,5),
			('H14',807,112,6),
			('H14',808,113,1),
			('H14',809,113,2),
			('H14',810,113,3),
			('H14',811,113,4),
			('H14',812,113,5),
			('H14',813,113,6),
			('H14',814,114,1),
			('H14',815,114,2),
			('H14',816,114,3),
			('H14',817,114,4),
			('H14',818,114,5),
			('H14',819,114,6),
			('H14',820,115,1),
			('H14',821,115,2),
			('H14',822,115,3),
			('H14',823,115,4),
			('H14',824,115,5),
			('H14',825,115,6),
			('H14',826,116,1),
			('H14',827,116,2),
			('H14',828,116,3),
			('H14',829,116,4),
			('H14',830,116,5),
			('H14',831,116,6),
			('H14',832,117,1),
			('H14',833,117,2),
			('H14',834,117,3),
			('H14',835,117,4),
			('H14',836,117,5),
			('H14',837,117,6),
			('H14',838,118,1),
			('H14',839,118,2),
			('H14',840,118,3),
			('H14',841,118,4),
			('H14',842,118,5),
			('H14',843,118,6),
			('H14',844,118,7),
			('H14',845,119,1),
			('H14',846,119,2),
			('H14',847,120,1),
			('H14',848,120,2),
			('H14',849,121,1),
			('H14',850,121,2),
			('H14',851,122,2),
			('H14',852,122,3),
			('H14',853,122,1),
			('H14',854,122,4),
			('H14',855,123,1),
			('H14',856,123,2),
			('H14',857,123,3),
			('H14',858,123,4),
			('H14',859,123,5),
			('H14',860,124,1),
			('H14',861,124,2),
			('H14',862,124,3),
			('H14',863,124,4),
			('H14',864,124,5),
			('H14',865,125,1),
			('H14',866,125,2),
			('H14',867,125,3),
			('H14',868,125,4),
			('H14',869,125,5),
			('H14',870,125,6),
			('H14',871,125,7),
			('H14',872,126,1),
			('H14',873,126,2),
			('H14',874,126,3),
			('H14',875,126,4),
			('H14',876,126,5),
			('H14',877,126,6),
			('H14',878,126,7),
			('H14',879,126,8),
			('H14',880,126,9),
			('H14',881,127,1),
			('H14',882,127,2),
			('H14',883,127,3),
			('H14',884,127,4),
			('H14',885,127,5),
			('H14',886,128,1),
			('H14',887,128,2),
			('H14',888,128,3),
			('H14',889,128,4),
			('H14',890,128,5),
			('H14',891,128,6),
			('H14',892,128,7),
			('H14',893,128,8),
			('H14',894,128,9),
			('H14',895,128,10),
			('H14',896,128,11),
			('H14',897,128,12),
			('H14',898,128,13),
			('H14',899,128,14),
			('H14',900,128,15),
			('H14',901,128,16),
			('H14',902,129,1),
			('H14',903,129,2),
			('H14',904,129,3),
			('H14',905,129,4),
			('H14',906,129,5),
			('H14',907,129,6),
			('H14',908,130,1),
			('H14',909,130,2),
			('H14',910,119,3),
			('H14',911,119,4),
			('H14',912,119,5),
			('H14',913,119,6),
			('H14',914,131,1),
			('H14',915,131,2),
			('H14',916,131,3),
			('H14',917,131,4),
			('H14',918,131,5),
			('H14',922,46,7),
			('H14',923,46,8),
			('H14',924,131,6),
			('H14',931,133,1),
			('H14',932,133,2),
			('H14',933,134,1),
			('H14',934,134,2),
			('H14',935,134,3),
			('H14',936,134,4),
			('H14',937,135,1),
			('H14',938,135,2),
			('H14',939,135,3),
			('H14',940,136,1),
			('H14',941,136,2),
			('H14',942,136,3),
			('H14',943,137,1),
			('H14',944,137,2),
			('H14',945,137,3),
			('H14',946,137,4),
			('H14',947,137,5),
			('H14',948,13,13),
			('H14',949,129,7),
			('H14',950,138,1),
			('H14',951,138,2),
			('H14',952,138,3),
			('H14',953,138,4),
			('H14',954,138,5),
			('H14',955,138,6),
			('H14',956,138,7),
			('H14',957,139,1),
			('H14',958,139,2),
			('H14',959,139,3),
			('H14',960,139,4),
			('H14',961,139,5),
			('H14',962,139,6),
			('H14',966,141,1),
			('H14',967,141,2),
			('H14',968,141,3),
			('H14',969,141,4),
			('H14',970,141,5),
			('H18',1,1,0),
			('H18',2,1,1),
			('H18',3,1,2),
			('H18',4,1,3),
			('H18',5,1,4),
			('H18',6,1,5),
			('H18',7,1,6),
			('H18',8,1,7),
			('H18',9,1,8),
			('H18',10,1,9),
			('H18',11,1,10),
			('H18',14,3,0),
			('H18',15,3,1),
			('H18',16,3,2),
			('H18',17,3,3),
			('H18',18,3,4),
			('H18',19,3,5),
			('H18',20,4,0),
			('H18',21,4,1),
			('H18',22,4,2),
			('H18',23,4,3),
			('H18',24,4,4),
			('H18',25,4,5),
			('H18',26,4,6),
			('H18',27,4,7),
			('H18',28,4,8),
			('H18',29,4,9),
			('H18',30,4,10),
			('H18',31,4,11),
			('H18',32,4,12),
			('H18',41,7,0),
			('H18',42,7,1),
			('H18',43,7,2),
			('H18',44,7,3),
			('H18',45,7,4),
			('H18',47,9,0),
			('H18',48,9,1),
			('H18',49,9,2),
			('H18',50,9,3),
			('H18',51,10,0),
			('H18',52,10,1),
			('H18',53,10,2),
			('H18',54,10,3),
			('H18',55,10,4),
			('H18',56,10,5),
			('H18',57,10,6),
			('H18',58,10,7),
			('H18',59,10,8),
			('H18',60,11,0),
			('H18',61,11,1),
			('H18',98,13,0),
			('H18',99,13,1),
			('H18',101,13,3),
			('H18',106,13,8),
			('H18',107,13,9),
			('H18',108,13,10),
			('H18',109,13,11),
			('H18',110,13,12),
			('H18',111,14,0),
			('H18',123,15,0),
			('H18',124,15,1),
			('H18',125,15,2),
			('H18',126,15,3),
			('H18',160,22,0),
			('H18',161,22,1),
			('H18',162,22,2),
			('H18',163,22,3),
			('H18',164,22,4),
			('H18',165,22,5),
			('H18',170,24,0),
			('H18',171,24,1),
			('H18',172,24,2),
			('H18',173,25,0),
			('H18',174,25,1),
			('H18',175,25,2),
			('H18',176,25,3),
			('H18',177,25,4),
			('H18',178,25,5),
			('H18',182,27,0),
			('H18',183,27,1),
			('H18',184,27,2),
			('H18',185,27,3),
			('H18',186,28,0),
			('H18',187,28,1),
			('H18',188,28,2),
			('H18',189,28,3),
			('H18',190,29,0),
			('H18',191,29,1),
			('H18',192,29,2),
			('H18',193,29,3),
			('H18',194,30,0),
			('H18',195,30,1),
			('H18',196,30,2),
			('H18',197,30,3),
			('H18',198,30,4),
			('H18',210,31,1),
			('H18',211,31,2),
			('H18',212,31,3),
			('H18',213,31,4),
			('H18',214,32,1),
			('H18',215,32,2),
			('H18',216,32,3),
			('H18',217,32,4),
			('H18',218,32,5),
			('H18',219,32,6),
			('H18',220,33,1),
			('H18',221,33,2),
			('H18',222,33,3),
			('H18',223,34,1),
			('H18',224,34,2),
			('H18',225,34,3),
			('H18',226,35,1),
			('H18',227,35,2),
			('H18',228,35,3),
			('H18',237,38,1),
			('H18',238,38,2),
			('H18',239,38,3),
			('H18',240,38,4),
			('H18',241,39,1),
			('H18',242,39,2),
			('H18',243,39,3),
			('H18',244,39,4),
			('H18',245,40,1),
			('H18',246,40,2),
			('H18',247,40,3),
			('H18',248,40,4),
			('H18',260,42,1),
			('H18',261,42,2),
			('H18',262,42,3),
			('H18',263,42,4),
			('H18',264,42,5),
			('H18',265,42,6),
			('H18',266,42,7),
			('H18',269,43,1),
			('H18',270,43,2),
			('H18',271,43,3),
			('H18',272,43,4),
			('H18',273,44,1),
			('H18',274,44,2),
			('H18',275,44,3),
			('H18',276,44,4),
			('H18',289,46,1),
			('H18',290,46,2),
			('H18',291,46,3),
			('H18',292,46,4),
			('H18',293,46,5),
			('H18',294,46,6),
			('H18',323,49,2),
			('H18',324,49,3),
			('H18',387,29,NULL),
			('H18',388,57,1),
			('H18',389,57,2),
			('H18',401,59,1),
			('H18',402,59,2),
			('H18',403,60,1),
			('H18',404,60,2),
			('H18',416,63,1),
			('H18',417,63,2),
			('H18',418,63,3),
			('H18',419,64,1),
			('H18',420,64,2),
			('H18',422,65,1),
			('H18',423,65,2),
			('H18',424,65,3),
			('H18',425,66,1),
			('H18',426,66,2),
			('H18',427,66,3),
			('H18',440,68,1),
			('H18',444,68,2),
			('H18',445,68,3),
			('H18',446,14,12),
			('H18',451,14,17),
			('H18',452,14,18),
			('H18',453,14,19),
			('H18',455,11,2),
			('H18',456,11,3),
			('H18',457,11,4),
			('H18',458,11,5),
			('H18',459,11,6),
			('H18',460,11,7),
			('H18',461,11,8),
			('H18',462,11,9),
			('H18',463,11,10),
			('H18',464,11,11),
			('H18',465,11,12),
			('H18',508,37,3),
			('H18',509,37,4),
			('H18',510,37,5),
			('H18',511,37,6),
			('H18',557,29,4),
			('H18',559,70,1),
			('H18',560,70,2),
			('H18',564,71,1),
			('H18',565,71,2),
			('H18',576,74,1),
			('H18',577,74,2),
			('H18',578,74,3),
			('H18',579,74,4),
			('H18',580,74,5),
			('H18',581,74,6),
			('H18',582,74,7),
			('H18',583,74,8),
			('H18',584,74,9),
			('H18',585,74,10),
			('H18',586,74,11),
			('H18',587,75,1),
			('H18',588,75,2),
			('H18',589,75,3),
			('H18',590,76,1),
			('H18',591,76,2),
			('H18',592,76,3),
			('H18',593,77,1),
			('H18',594,77,2),
			('H18',595,77,3),
			('H18',596,77,4),
			('H18',597,77,5),
			('H18',598,77,6),
			('H18',599,77,7),
			('H18',600,77,8),
			('H18',601,77,9),
			('H18',602,77,10),
			('H18',603,77,11),
			('H18',604,77,12),
			('H18',605,77,13),
			('H18',606,77,14),
			('H18',607,77,15),
			('H18',608,78,1),
			('H18',609,78,2),
			('H18',610,78,3),
			('H18',611,78,4),
			('H18',612,78,5),
			('H18',613,78,6),
			('H18',614,78,7),
			('H18',615,78,8),
			('H18',616,78,9),
			('H18',617,78,10),
			('H18',618,78,11),
			('H18',619,78,12),
			('H18',620,78,13),
			('H18',621,78,14),
			('H18',622,78,15),
			('H18',659,85,1),
			('H18',660,85,2),
			('H18',661,85,3),
			('H18',668,87,1),
			('H18',670,89,1),
			('H18',672,37,7),
			('H18',675,90,1),
			('H18',676,90,2),
			('H18',677,90,3),
			('H18',678,90,4),
			('H18',679,90,5),
			('H18',680,90,6),
			('H18',681,90,7),
			('H18',682,91,1),
			('H18',683,91,2),
			('H18',684,91,3),
			('H18',685,91,4),
			('H18',686,91,5),
			('H18',687,91,6),
			('H18',688,91,7),
			('H18',689,63,4),
			('H18',690,63,5),
			('H18',692,93,1),
			('H18',694,29,5),
			('H18',695,29,6),
			('H18',696,29,7),
			('H18',697,94,1),
			('H18',698,94,2),
			('H18',699,94,3),
			('H18',700,57,3),
			('H18',701,90,8),
			('H18',702,91,8),
			('H18',703,95,1),
			('H18',704,95,2),
			('H18',705,96,1),
			('H18',706,96,2),
			('H18',707,96,3),
			('H18',708,96,4),
			('H18',709,96,5),
			('H18',710,96,6),
			('H18',711,96,7),
			('H18',712,96,8),
			('H18',717,98,1),
			('H18',718,98,2),
			('H18',719,98,3),
			('H18',720,14,20),
			('H18',721,14,21),
			('H18',722,14,22),
			('H18',728,100,1),
			('H18',729,100,2),
			('H18',730,100,3),
			('H18',731,100,4),
			('H18',732,100,5),
			('H18',733,100,6),
			('H18',734,100,7),
			('H18',735,100,8),
			('H18',736,100,9),
			('H18',738,102,1),
			('H18',739,102,2),
			('H18',740,102,3),
			('H18',741,102,4),
			('H18',742,102,5),
			('H18',743,102,6),
			('H18',744,102,7),
			('H18',745,102,8),
			('H18',749,104,1),
			('H18',750,104,2),
			('H18',751,104,3),
			('H18',752,104,4),
			('H18',753,104,5),
			('H18',754,104,6),
			('H18',755,104,7),
			('H18',756,104,8),
			('H18',757,105,1),
			('H18',758,105,2),
			('H18',759,105,3),
			('H18',760,106,1),
			('H18',761,106,2),
			('H18',762,106,3),
			('H18',763,106,4),
			('H18',771,87,7),
			('H18',772,87,8),
			('H18',773,141,1),
			('H18',774,141,2),
			('H18',775,141,3),
			('H18',776,141,4),
			('H18',777,141,5),
			('H18',778,108,1),
			('H18',779,108,2),
			('H18',780,108,3),
			('H18',781,108,4),
			('H18',782,108,5),
			('H18',783,108,6),
			('H18',784,109,1),
			('H18',785,109,2),
			('H18',786,109,3),
			('H18',787,109,4),
			('H18',788,109,5),
			('H18',789,109,6),
			('H18',790,110,1),
			('H18',791,110,2),
			('H18',792,110,3),
			('H18',793,110,4),
			('H18',794,110,5),
			('H18',795,110,6),
			('H18',796,111,1),
			('H18',797,111,2),
			('H18',798,111,3),
			('H18',799,111,4),
			('H18',800,111,5),
			('H18',801,111,6),
			('H18',802,112,1),
			('H18',803,112,2),
			('H18',804,112,3),
			('H18',805,112,4),
			('H18',806,112,5),
			('H18',807,112,6),
			('H18',808,113,1),
			('H18',809,113,2),
			('H18',810,113,3),
			('H18',811,113,4),
			('H18',812,113,5),
			('H18',813,113,6),
			('H18',814,114,1),
			('H18',815,114,2),
			('H18',816,114,3),
			('H18',817,114,4),
			('H18',818,114,5),
			('H18',819,114,6),
			('H18',820,115,1),
			('H18',821,115,2),
			('H18',822,115,3),
			('H18',823,115,4),
			('H18',824,115,5),
			('H18',825,115,6),
			('H18',826,116,1),
			('H18',827,116,2),
			('H18',828,116,3),
			('H18',829,116,4),
			('H18',830,116,5),
			('H18',831,116,6),
			('H18',832,117,1),
			('H18',833,117,2),
			('H18',834,117,3),
			('H18',835,117,4),
			('H18',836,117,5),
			('H18',837,117,6),
			('H18',838,118,1),
			('H18',839,118,2),
			('H18',840,118,3),
			('H18',841,118,4),
			('H18',842,118,5),
			('H18',843,118,6),
			('H18',844,118,7),
			('H18',845,119,1),
			('H18',846,119,2),
			('H18',847,120,1),
			('H18',848,120,2),
			('H18',849,121,1),
			('H18',850,121,2),
			('H18',851,122,2),
			('H18',852,122,3),
			('H18',853,122,1),
			('H18',854,122,4),
			('H18',855,123,1),
			('H18',856,123,2),
			('H18',857,123,3),
			('H18',858,123,4),
			('H18',859,123,5),
			('H18',860,124,1),
			('H18',861,124,2),
			('H18',862,124,3),
			('H18',863,124,4),
			('H18',864,124,5),
			('H18',865,125,1),
			('H18',866,125,2),
			('H18',867,125,3),
			('H18',868,125,4),
			('H18',869,125,5),
			('H18',870,125,6),
			('H18',871,125,7),
			('H18',872,126,1),
			('H18',873,126,2),
			('H18',874,126,3),
			('H18',875,126,4),
			('H18',876,126,5),
			('H18',877,126,6),
			('H18',878,126,7),
			('H18',879,126,8),
			('H18',880,126,9),
			('H18',881,127,1),
			('H18',882,127,2),
			('H18',883,127,3),
			('H18',884,127,4),
			('H18',885,127,5),
			('H18',886,128,1),
			('H18',887,128,2),
			('H18',888,128,3),
			('H18',889,128,4),
			('H18',890,128,5),
			('H18',891,128,6),
			('H18',892,128,7),
			('H18',893,128,8),
			('H18',894,128,9),
			('H18',895,128,10),
			('H18',896,128,11),
			('H18',897,128,12),
			('H18',898,128,13),
			('H18',899,128,14),
			('H18',900,128,15),
			('H18',901,128,16),
			('H18',902,129,1),
			('H18',903,129,2),
			('H18',904,129,3),
			('H18',905,129,4),
			('H18',906,129,5),
			('H18',907,129,6),
			('H18',908,130,1),
			('H18',909,130,2),
			('H18',910,119,3),
			('H18',911,119,4),
			('H18',912,119,5),
			('H18',913,119,6),
			('H18',914,131,1),
			('H18',915,131,2),
			('H18',916,131,3),
			('H18',917,131,4),
			('H18',918,131,5),
			('H18',922,46,7),
			('H18',923,46,8),
			('H18',924,131,6),
			('H18',931,133,1),
			('H18',932,133,2),
			('H18',933,134,1),
			('H18',934,134,2),
			('H18',935,134,3),
			('H18',936,134,4),
			('H18',937,135,1),
			('H18',938,135,2),
			('H18',939,135,3),
			('H18',940,136,1),
			('H18',941,136,2),
			('H18',942,136,3),
			('H18',943,137,1),
			('H18',944,137,2),
			('H18',945,137,3),
			('H18',946,137,4),
			('H18',947,137,5),
			('H18',948,13,13),
			('H18',949,129,7),
			('H18',950,138,1),
			('H18',951,138,2),
			('H18',952,138,3),
			('H18',953,138,4),
			('H18',954,138,5),
			('H18',955,138,6),
			('H18',956,138,7),
			('H18',957,139,1),
			('H18',958,139,2),
			('H18',959,139,3),
			('H18',960,139,4),
			('H18',961,139,5),
			('H18',962,139,6),
			('H18',966,141,1),
			('H18',967,141,2),
			('H18',968,141,3),
			('H18',969,141,4),
			('H18',970,141,5),
			('H2',1,1,0),
			('H2',2,1,1),
			('H2',3,1,2),
			('H2',4,1,3),
			('H2',5,1,4),
			('H2',6,1,5),
			('H2',7,1,6),
			('H2',8,1,7),
			('H2',9,1,8),
			('H2',10,1,9),
			('H2',11,1,10),
			('H2',14,3,0),
			('H2',15,3,1),
			('H2',16,3,2),
			('H2',17,3,3),
			('H2',18,3,4),
			('H2',19,3,5),
			('H2',20,4,0),
			('H2',21,4,1),
			('H2',22,4,2),
			('H2',23,4,3),
			('H2',24,4,4),
			('H2',25,4,5),
			('H2',26,4,6),
			('H2',27,4,7),
			('H2',28,4,8),
			('H2',29,4,9),
			('H2',30,4,10),
			('H2',31,4,11),
			('H2',32,4,12),
			('H2',41,7,0),
			('H2',42,7,1),
			('H2',43,7,2),
			('H2',44,7,3),
			('H2',45,7,4),
			('H2',47,9,0),
			('H2',48,9,1),
			('H2',49,9,2),
			('H2',50,9,3),
			('H2',51,10,0),
			('H2',52,10,1),
			('H2',53,10,2),
			('H2',54,10,3),
			('H2',55,10,4),
			('H2',56,10,5),
			('H2',57,10,6),
			('H2',58,10,7),
			('H2',59,10,8),
			('H2',60,11,0),
			('H2',61,11,1),
			('H2',98,13,0),
			('H2',99,13,1),
			('H2',101,13,3),
			('H2',106,13,8),
			('H2',107,13,9),
			('H2',108,13,10),
			('H2',109,13,11),
			('H2',110,13,12),
			('H2',111,14,0),
			('H2',123,15,0),
			('H2',124,15,1),
			('H2',125,15,2),
			('H2',126,15,3),
			('H2',160,22,0),
			('H2',161,22,1),
			('H2',162,22,2),
			('H2',163,22,3),
			('H2',164,22,4),
			('H2',165,22,5),
			('H2',170,24,0),
			('H2',171,24,1),
			('H2',172,24,2),
			('H2',173,25,0),
			('H2',174,25,1),
			('H2',175,25,2),
			('H2',176,25,3),
			('H2',177,25,4),
			('H2',178,25,5),
			('H2',182,27,0),
			('H2',183,27,1),
			('H2',184,27,2),
			('H2',185,27,3),
			('H2',186,28,0),
			('H2',187,28,1),
			('H2',188,28,2),
			('H2',189,28,3),
			('H2',190,29,0),
			('H2',191,29,1),
			('H2',192,29,2),
			('H2',193,29,3),
			('H2',194,30,0),
			('H2',195,30,1),
			('H2',196,30,2),
			('H2',197,30,3),
			('H2',198,30,4),
			('H2',210,31,1),
			('H2',211,31,2),
			('H2',212,31,3),
			('H2',213,31,4),
			('H2',214,32,1),
			('H2',215,32,2),
			('H2',216,32,3),
			('H2',217,32,4),
			('H2',218,32,5),
			('H2',219,32,6),
			('H2',220,33,1),
			('H2',221,33,2),
			('H2',222,33,3),
			('H2',223,34,1),
			('H2',224,34,2),
			('H2',225,34,3),
			('H2',226,35,1),
			('H2',227,35,2),
			('H2',228,35,3),
			('H2',237,38,1),
			('H2',238,38,2),
			('H2',239,38,3),
			('H2',240,38,4),
			('H2',241,39,1),
			('H2',242,39,2),
			('H2',243,39,3),
			('H2',244,39,4),
			('H2',245,40,1),
			('H2',246,40,2),
			('H2',247,40,3),
			('H2',248,40,4),
			('H2',260,42,1),
			('H2',261,42,2),
			('H2',262,42,3),
			('H2',263,42,4),
			('H2',264,42,5),
			('H2',265,42,6),
			('H2',266,42,7),
			('H2',269,43,1),
			('H2',270,43,2),
			('H2',271,43,3),
			('H2',272,43,4),
			('H2',273,44,1),
			('H2',274,44,2),
			('H2',275,44,3),
			('H2',276,44,4),
			('H2',289,46,1),
			('H2',290,46,2),
			('H2',291,46,3),
			('H2',292,46,4),
			('H2',293,46,5),
			('H2',294,46,6),
			('H2',323,49,2),
			('H2',324,49,3),
			('H2',387,29,NULL),
			('H2',388,57,1),
			('H2',389,57,2),
			('H2',401,59,1),
			('H2',402,59,2),
			('H2',403,60,1),
			('H2',404,60,2),
			('H2',416,63,1),
			('H2',417,63,2),
			('H2',418,63,3),
			('H2',419,64,1),
			('H2',420,64,2),
			('H2',422,65,1),
			('H2',423,65,2),
			('H2',424,65,3),
			('H2',425,66,1),
			('H2',426,66,2),
			('H2',427,66,3),
			('H2',440,68,1),
			('H2',444,68,2),
			('H2',445,68,3),
			('H2',446,14,12),
			('H2',451,14,17),
			('H2',452,14,18),
			('H2',453,14,19),
			('H2',455,11,2),
			('H2',456,11,3),
			('H2',457,11,4),
			('H2',458,11,5),
			('H2',459,11,6),
			('H2',460,11,7),
			('H2',461,11,8),
			('H2',462,11,9),
			('H2',463,11,10),
			('H2',464,11,11),
			('H2',465,11,12),
			('H2',508,37,3),
			('H2',509,37,4),
			('H2',510,37,5),
			('H2',511,37,6),
			('H2',557,29,4),
			('H2',559,70,1),
			('H2',560,70,2),
			('H2',564,71,1),
			('H2',565,71,2),
			('H2',576,74,1),
			('H2',577,74,2),
			('H2',578,74,3),
			('H2',579,74,4),
			('H2',580,74,5),
			('H2',581,74,6),
			('H2',582,74,7),
			('H2',583,74,8),
			('H2',584,74,9),
			('H2',585,74,10),
			('H2',586,74,11),
			('H2',587,75,1),
			('H2',588,75,2),
			('H2',589,75,3),
			('H2',590,76,1),
			('H2',591,76,2),
			('H2',592,76,3),
			('H2',593,77,1),
			('H2',594,77,2),
			('H2',595,77,3),
			('H2',596,77,4),
			('H2',597,77,5),
			('H2',598,77,6),
			('H2',599,77,7),
			('H2',600,77,8),
			('H2',601,77,9),
			('H2',602,77,10),
			('H2',603,77,11),
			('H2',604,77,12),
			('H2',605,77,13),
			('H2',606,77,14),
			('H2',607,77,15),
			('H2',608,78,1),
			('H2',609,78,2),
			('H2',610,78,3),
			('H2',611,78,4),
			('H2',612,78,5),
			('H2',613,78,6),
			('H2',614,78,7),
			('H2',615,78,8),
			('H2',616,78,9),
			('H2',617,78,10),
			('H2',618,78,11),
			('H2',619,78,12),
			('H2',620,78,13),
			('H2',621,78,14),
			('H2',622,78,15),
			('H2',659,85,1),
			('H2',660,85,2),
			('H2',661,85,3),
			('H2',668,87,1),
			('H2',670,89,1),
			('H2',672,37,7),
			('H2',675,90,1),
			('H2',676,90,2),
			('H2',677,90,3),
			('H2',678,90,4),
			('H2',679,90,5),
			('H2',680,90,6),
			('H2',681,90,7),
			('H2',682,91,1),
			('H2',683,91,2),
			('H2',684,91,3),
			('H2',685,91,4),
			('H2',686,91,5),
			('H2',687,91,6),
			('H2',688,91,7),
			('H2',689,63,4),
			('H2',690,63,5),
			('H2',692,93,1),
			('H2',694,29,5),
			('H2',695,29,6),
			('H2',696,29,7),
			('H2',697,94,1),
			('H2',698,94,2),
			('H2',699,94,3),
			('H2',700,57,3),
			('H2',701,90,8),
			('H2',702,91,8),
			('H2',703,95,1),
			('H2',704,95,2),
			('H2',705,96,1),
			('H2',706,96,2),
			('H2',707,96,3),
			('H2',708,96,4),
			('H2',709,96,5),
			('H2',710,96,6),
			('H2',711,96,7),
			('H2',712,96,8),
			('H2',717,98,1),
			('H2',718,98,2),
			('H2',719,98,3),
			('H2',720,14,20),
			('H2',721,14,21),
			('H2',722,14,22),
			('H2',728,100,1),
			('H2',729,100,2),
			('H2',730,100,3),
			('H2',731,100,4),
			('H2',732,100,5),
			('H2',733,100,6),
			('H2',734,100,7),
			('H2',735,100,8),
			('H2',736,100,9),
			('H2',738,102,1),
			('H2',739,102,2),
			('H2',740,102,3),
			('H2',741,102,4),
			('H2',742,102,5),
			('H2',743,102,6),
			('H2',744,102,7),
			('H2',745,102,8),
			('H2',749,104,1),
			('H2',750,104,2),
			('H2',751,104,3),
			('H2',752,104,4),
			('H2',753,104,5),
			('H2',754,104,6),
			('H2',755,104,7),
			('H2',756,104,8),
			('H2',757,105,1),
			('H2',758,105,2),
			('H2',759,105,3),
			('H2',760,106,1),
			('H2',761,106,2),
			('H2',762,106,3),
			('H2',763,106,4),
			('H2',771,87,7),
			('H2',772,87,8),
			('H2',773,141,1),
			('H2',774,141,2),
			('H2',775,141,3),
			('H2',776,141,4),
			('H2',777,141,5),
			('H2',778,108,1),
			('H2',779,108,2),
			('H2',780,108,3),
			('H2',781,108,4),
			('H2',782,108,5),
			('H2',783,108,6),
			('H2',784,109,1),
			('H2',785,109,2),
			('H2',786,109,3),
			('H2',787,109,4),
			('H2',788,109,5),
			('H2',789,109,6),
			('H2',790,110,1),
			('H2',791,110,2),
			('H2',792,110,3),
			('H2',793,110,4),
			('H2',794,110,5),
			('H2',795,110,6),
			('H2',796,111,1),
			('H2',797,111,2),
			('H2',798,111,3),
			('H2',799,111,4),
			('H2',800,111,5),
			('H2',801,111,6),
			('H2',802,112,1),
			('H2',803,112,2),
			('H2',804,112,3),
			('H2',805,112,4),
			('H2',806,112,5),
			('H2',807,112,6),
			('H2',808,113,1),
			('H2',809,113,2),
			('H2',810,113,3),
			('H2',811,113,4),
			('H2',812,113,5),
			('H2',813,113,6),
			('H2',814,114,1),
			('H2',815,114,2),
			('H2',816,114,3),
			('H2',817,114,4),
			('H2',818,114,5),
			('H2',819,114,6),
			('H2',820,115,1),
			('H2',821,115,2),
			('H2',822,115,3),
			('H2',823,115,4),
			('H2',824,115,5),
			('H2',825,115,6),
			('H2',826,116,1),
			('H2',827,116,2),
			('H2',828,116,3),
			('H2',829,116,4),
			('H2',830,116,5),
			('H2',831,116,6),
			('H2',832,117,1),
			('H2',833,117,2),
			('H2',834,117,3),
			('H2',835,117,4),
			('H2',836,117,5),
			('H2',837,117,6),
			('H2',838,118,1),
			('H2',839,118,2),
			('H2',840,118,3),
			('H2',841,118,4),
			('H2',842,118,5),
			('H2',843,118,6),
			('H2',844,118,7),
			('H2',845,119,1),
			('H2',846,119,2),
			('H2',847,120,1),
			('H2',848,120,2),
			('H2',849,121,1),
			('H2',850,121,2),
			('H2',851,122,2),
			('H2',852,122,3),
			('H2',853,122,1),
			('H2',854,122,4),
			('H2',855,123,1),
			('H2',856,123,2),
			('H2',857,123,3),
			('H2',858,123,4),
			('H2',859,123,5),
			('H2',860,124,1),
			('H2',861,124,2),
			('H2',862,124,3),
			('H2',863,124,4),
			('H2',864,124,5),
			('H2',865,125,1),
			('H2',866,125,2),
			('H2',867,125,3),
			('H2',868,125,4),
			('H2',869,125,5),
			('H2',870,125,6),
			('H2',871,125,7),
			('H2',872,126,1),
			('H2',873,126,2),
			('H2',874,126,3),
			('H2',875,126,4),
			('H2',876,126,5),
			('H2',877,126,6),
			('H2',878,126,7),
			('H2',879,126,8),
			('H2',880,126,9),
			('H2',881,127,1),
			('H2',882,127,2),
			('H2',883,127,3),
			('H2',884,127,4),
			('H2',885,127,5),
			('H2',886,128,1),
			('H2',887,128,2),
			('H2',888,128,3),
			('H2',889,128,4),
			('H2',890,128,5),
			('H2',891,128,6),
			('H2',892,128,7),
			('H2',893,128,8),
			('H2',894,128,9),
			('H2',895,128,10),
			('H2',896,128,11),
			('H2',897,128,12),
			('H2',898,128,13),
			('H2',899,128,14),
			('H2',900,128,15),
			('H2',901,128,16),
			('H2',902,129,1),
			('H2',903,129,2),
			('H2',904,129,3),
			('H2',905,129,4),
			('H2',906,129,5),
			('H2',907,129,6),
			('H2',908,130,1),
			('H2',909,130,2),
			('H2',910,119,3),
			('H2',911,119,4),
			('H2',912,119,5),
			('H2',913,119,6),
			('H2',914,131,1),
			('H2',915,131,2),
			('H2',916,131,3),
			('H2',917,131,4),
			('H2',918,131,5),
			('H2',922,46,7),
			('H2',923,46,8),
			('H2',924,131,6),
			('H2',931,133,1),
			('H2',932,133,2),
			('H2',933,134,1),
			('H2',934,134,2),
			('H2',935,134,3),
			('H2',936,134,4),
			('H2',937,135,1),
			('H2',938,135,2),
			('H2',939,135,3),
			('H2',940,136,1),
			('H2',941,136,2),
			('H2',942,136,3),
			('H2',943,137,1),
			('H2',944,137,2),
			('H2',945,137,3),
			('H2',946,137,4),
			('H2',947,137,5),
			('H2',948,13,13),
			('H2',949,129,7),
			('H2',950,138,1),
			('H2',951,138,2),
			('H2',952,138,3),
			('H2',953,138,4),
			('H2',954,138,5),
			('H2',955,138,6),
			('H2',956,138,7),
			('H2',957,139,1),
			('H2',958,139,2),
			('H2',959,139,3),
			('H2',960,139,4),
			('H2',961,139,5),
			('H2',962,139,6),
			('H2',966,141,1),
			('H2',967,141,2),
			('H2',968,141,3),
			('H2',969,141,4),
			('H2',970,141,5),
			('H22',1,1,0),
			('H22',2,1,1),
			('H22',3,1,2),
			('H22',4,1,3),
			('H22',5,1,4),
			('H22',6,1,5),
			('H22',7,1,6),
			('H22',8,1,7),
			('H22',9,1,8),
			('H22',10,1,9),
			('H22',11,1,10),
			('H22',14,3,0),
			('H22',15,3,1),
			('H22',16,3,2),
			('H22',17,3,3),
			('H22',18,3,4),
			('H22',19,3,5),
			('H22',20,4,0),
			('H22',21,4,1),
			('H22',22,4,2),
			('H22',23,4,3),
			('H22',24,4,4),
			('H22',25,4,5),
			('H22',26,4,6),
			('H22',27,4,7),
			('H22',28,4,8),
			('H22',29,4,9),
			('H22',30,4,10),
			('H22',31,4,11),
			('H22',32,4,12),
			('H22',41,7,0),
			('H22',42,7,1),
			('H22',43,7,2),
			('H22',44,7,3),
			('H22',45,7,4),
			('H22',47,9,0),
			('H22',48,9,1),
			('H22',49,9,2),
			('H22',50,9,3),
			('H22',51,10,0),
			('H22',52,10,1),
			('H22',53,10,2),
			('H22',54,10,3),
			('H22',55,10,4),
			('H22',56,10,5),
			('H22',57,10,6),
			('H22',58,10,7),
			('H22',59,10,8),
			('H22',60,11,0),
			('H22',61,11,1),
			('H22',98,13,0),
			('H22',99,13,1),
			('H22',101,13,3),
			('H22',106,13,8),
			('H22',107,13,9),
			('H22',108,13,10),
			('H22',109,13,11),
			('H22',110,13,12),
			('H22',111,14,0),
			('H22',123,15,0),
			('H22',124,15,1),
			('H22',125,15,2),
			('H22',126,15,3),
			('H22',160,22,0),
			('H22',161,22,1),
			('H22',162,22,2),
			('H22',163,22,3),
			('H22',164,22,4),
			('H22',165,22,5),
			('H22',170,24,0),
			('H22',171,24,1),
			('H22',172,24,2),
			('H22',173,25,0),
			('H22',174,25,1),
			('H22',175,25,2),
			('H22',176,25,3),
			('H22',177,25,4),
			('H22',178,25,5),
			('H22',182,27,0),
			('H22',183,27,1),
			('H22',184,27,2),
			('H22',185,27,3),
			('H22',186,28,0),
			('H22',187,28,1),
			('H22',188,28,2),
			('H22',189,28,3),
			('H22',190,29,0),
			('H22',191,29,1),
			('H22',192,29,2),
			('H22',193,29,3),
			('H22',194,30,0),
			('H22',195,30,1),
			('H22',196,30,2),
			('H22',197,30,3),
			('H22',198,30,4),
			('H22',210,31,1),
			('H22',211,31,2),
			('H22',212,31,3),
			('H22',213,31,4),
			('H22',214,32,1),
			('H22',215,32,2),
			('H22',216,32,3),
			('H22',217,32,4),
			('H22',218,32,5),
			('H22',219,32,6),
			('H22',220,33,1),
			('H22',221,33,2),
			('H22',222,33,3),
			('H22',223,34,1),
			('H22',224,34,2),
			('H22',225,34,3),
			('H22',226,35,1),
			('H22',227,35,2),
			('H22',228,35,3),
			('H22',237,38,1),
			('H22',238,38,2),
			('H22',239,38,3),
			('H22',240,38,4),
			('H22',241,39,1),
			('H22',242,39,2),
			('H22',243,39,3),
			('H22',244,39,4),
			('H22',245,40,1),
			('H22',246,40,2),
			('H22',247,40,3),
			('H22',248,40,4),
			('H22',260,42,1),
			('H22',261,42,2),
			('H22',262,42,3),
			('H22',263,42,4),
			('H22',264,42,5),
			('H22',265,42,6),
			('H22',266,42,7),
			('H22',269,43,1),
			('H22',270,43,2),
			('H22',271,43,3),
			('H22',272,43,4),
			('H22',273,44,1),
			('H22',274,44,2),
			('H22',275,44,3),
			('H22',276,44,4),
			('H22',289,46,1),
			('H22',290,46,2),
			('H22',291,46,3),
			('H22',292,46,4),
			('H22',293,46,5),
			('H22',294,46,6),
			('H22',323,49,2),
			('H22',324,49,3),
			('H22',387,29,NULL),
			('H22',388,57,1),
			('H22',389,57,2),
			('H22',401,59,1),
			('H22',402,59,2),
			('H22',403,60,1),
			('H22',404,60,2),
			('H22',416,63,1),
			('H22',417,63,2),
			('H22',418,63,3),
			('H22',419,64,1),
			('H22',420,64,2),
			('H22',422,65,1),
			('H22',423,65,2),
			('H22',424,65,3),
			('H22',425,66,1),
			('H22',426,66,2),
			('H22',427,66,3),
			('H22',440,68,1),
			('H22',444,68,2),
			('H22',445,68,3),
			('H22',446,14,12),
			('H22',451,14,17),
			('H22',452,14,18),
			('H22',453,14,19),
			('H22',455,11,2),
			('H22',456,11,3),
			('H22',457,11,4),
			('H22',458,11,5),
			('H22',459,11,6),
			('H22',460,11,7),
			('H22',461,11,8),
			('H22',462,11,9),
			('H22',463,11,10),
			('H22',464,11,11),
			('H22',465,11,12),
			('H22',508,37,3),
			('H22',509,37,4),
			('H22',510,37,5),
			('H22',511,37,6),
			('H22',557,29,4),
			('H22',559,70,1),
			('H22',560,70,2),
			('H22',564,71,1),
			('H22',565,71,2),
			('H22',576,74,1),
			('H22',577,74,2),
			('H22',578,74,3),
			('H22',579,74,4),
			('H22',580,74,5),
			('H22',581,74,6),
			('H22',582,74,7),
			('H22',583,74,8),
			('H22',584,74,9),
			('H22',585,74,10),
			('H22',586,74,11),
			('H22',587,75,1),
			('H22',588,75,2),
			('H22',589,75,3),
			('H22',590,76,1),
			('H22',591,76,2),
			('H22',592,76,3),
			('H22',593,77,1),
			('H22',594,77,2),
			('H22',595,77,3),
			('H22',596,77,4),
			('H22',597,77,5),
			('H22',598,77,6),
			('H22',599,77,7),
			('H22',600,77,8),
			('H22',601,77,9),
			('H22',602,77,10),
			('H22',603,77,11),
			('H22',604,77,12),
			('H22',605,77,13),
			('H22',606,77,14),
			('H22',607,77,15),
			('H22',608,78,1),
			('H22',609,78,2),
			('H22',610,78,3),
			('H22',611,78,4),
			('H22',612,78,5),
			('H22',613,78,6),
			('H22',614,78,7),
			('H22',615,78,8),
			('H22',616,78,9),
			('H22',617,78,10),
			('H22',618,78,11),
			('H22',619,78,12),
			('H22',620,78,13),
			('H22',621,78,14),
			('H22',622,78,15),
			('H22',659,85,1),
			('H22',660,85,2),
			('H22',661,85,3),
			('H22',668,87,1),
			('H22',670,89,1),
			('H22',672,37,7),
			('H22',675,90,1),
			('H22',676,90,2),
			('H22',677,90,3),
			('H22',678,90,4),
			('H22',679,90,5),
			('H22',680,90,6),
			('H22',681,90,7),
			('H22',682,91,1),
			('H22',683,91,2),
			('H22',684,91,3),
			('H22',685,91,4),
			('H22',686,91,5),
			('H22',687,91,6),
			('H22',688,91,7),
			('H22',689,63,4),
			('H22',690,63,5),
			('H22',692,93,1),
			('H22',694,29,5),
			('H22',695,29,6),
			('H22',696,29,7),
			('H22',697,94,1),
			('H22',698,94,2),
			('H22',699,94,3),
			('H22',700,57,3),
			('H22',701,90,8),
			('H22',702,91,8),
			('H22',703,95,1),
			('H22',704,95,2),
			('H22',705,96,1),
			('H22',706,96,2),
			('H22',707,96,3),
			('H22',708,96,4),
			('H22',709,96,5),
			('H22',710,96,6),
			('H22',711,96,7),
			('H22',712,96,8),
			('H22',717,98,1),
			('H22',718,98,2),
			('H22',719,98,3),
			('H22',720,14,20),
			('H22',721,14,21),
			('H22',722,14,22),
			('H22',728,100,1),
			('H22',729,100,2),
			('H22',730,100,3),
			('H22',731,100,4),
			('H22',732,100,5),
			('H22',733,100,6),
			('H22',734,100,7),
			('H22',735,100,8),
			('H22',736,100,9),
			('H22',738,102,1),
			('H22',739,102,2),
			('H22',740,102,3),
			('H22',741,102,4),
			('H22',742,102,5),
			('H22',743,102,6),
			('H22',744,102,7),
			('H22',745,102,8),
			('H22',749,104,1),
			('H22',750,104,2),
			('H22',751,104,3),
			('H22',752,104,4),
			('H22',753,104,5),
			('H22',754,104,6),
			('H22',755,104,7),
			('H22',756,104,8),
			('H22',757,105,1),
			('H22',758,105,2),
			('H22',759,105,3),
			('H22',760,106,1),
			('H22',761,106,2),
			('H22',762,106,3),
			('H22',763,106,4),
			('H22',771,87,7),
			('H22',772,87,8),
			('H22',773,141,1),
			('H22',774,141,2),
			('H22',775,141,3),
			('H22',776,141,4),
			('H22',777,141,5),
			('H22',778,108,1),
			('H22',779,108,2),
			('H22',780,108,3),
			('H22',781,108,4),
			('H22',782,108,5),
			('H22',783,108,6),
			('H22',784,109,1),
			('H22',785,109,2),
			('H22',786,109,3),
			('H22',787,109,4),
			('H22',788,109,5),
			('H22',789,109,6),
			('H22',790,110,1),
			('H22',791,110,2),
			('H22',792,110,3),
			('H22',793,110,4),
			('H22',794,110,5),
			('H22',795,110,6),
			('H22',796,111,1),
			('H22',797,111,2),
			('H22',798,111,3),
			('H22',799,111,4),
			('H22',800,111,5),
			('H22',801,111,6),
			('H22',802,112,1),
			('H22',803,112,2),
			('H22',804,112,3),
			('H22',805,112,4),
			('H22',806,112,5),
			('H22',807,112,6),
			('H22',808,113,1),
			('H22',809,113,2),
			('H22',810,113,3),
			('H22',811,113,4),
			('H22',812,113,5),
			('H22',813,113,6),
			('H22',814,114,1),
			('H22',815,114,2),
			('H22',816,114,3),
			('H22',817,114,4),
			('H22',818,114,5),
			('H22',819,114,6),
			('H22',820,115,1),
			('H22',821,115,2),
			('H22',822,115,3),
			('H22',823,115,4),
			('H22',824,115,5),
			('H22',825,115,6),
			('H22',826,116,1),
			('H22',827,116,2),
			('H22',828,116,3),
			('H22',829,116,4),
			('H22',830,116,5),
			('H22',831,116,6),
			('H22',832,117,1),
			('H22',833,117,2),
			('H22',834,117,3),
			('H22',835,117,4),
			('H22',836,117,5),
			('H22',837,117,6),
			('H22',838,118,1),
			('H22',839,118,2),
			('H22',840,118,3),
			('H22',841,118,4),
			('H22',842,118,5),
			('H22',843,118,6),
			('H22',844,118,7),
			('H22',845,119,1),
			('H22',846,119,2),
			('H22',847,120,1),
			('H22',848,120,2),
			('H22',849,121,1),
			('H22',850,121,2),
			('H22',851,122,2),
			('H22',852,122,3),
			('H22',853,122,1),
			('H22',854,122,4),
			('H22',855,123,1),
			('H22',856,123,2),
			('H22',857,123,3),
			('H22',858,123,4),
			('H22',859,123,5),
			('H22',860,124,1),
			('H22',861,124,2),
			('H22',862,124,3),
			('H22',863,124,4),
			('H22',864,124,5),
			('H22',865,125,1),
			('H22',866,125,2),
			('H22',867,125,3),
			('H22',868,125,4),
			('H22',869,125,5),
			('H22',870,125,6),
			('H22',871,125,7),
			('H22',872,126,1),
			('H22',873,126,2),
			('H22',874,126,3),
			('H22',875,126,4),
			('H22',876,126,5),
			('H22',877,126,6),
			('H22',878,126,7),
			('H22',879,126,8),
			('H22',880,126,9),
			('H22',881,127,1),
			('H22',882,127,2),
			('H22',883,127,3),
			('H22',884,127,4),
			('H22',885,127,5),
			('H22',886,128,1),
			('H22',887,128,2),
			('H22',888,128,3),
			('H22',889,128,4),
			('H22',890,128,5),
			('H22',891,128,6),
			('H22',892,128,7),
			('H22',893,128,8),
			('H22',894,128,9),
			('H22',895,128,10),
			('H22',896,128,11),
			('H22',897,128,12),
			('H22',898,128,13),
			('H22',899,128,14),
			('H22',900,128,15),
			('H22',901,128,16),
			('H22',902,129,1),
			('H22',903,129,2),
			('H22',904,129,3),
			('H22',905,129,4),
			('H22',906,129,5),
			('H22',907,129,6),
			('H22',908,130,1),
			('H22',909,130,2),
			('H22',910,119,3),
			('H22',911,119,4),
			('H22',912,119,5),
			('H22',913,119,6),
			('H22',914,131,1),
			('H22',915,131,2),
			('H22',916,131,3),
			('H22',917,131,4),
			('H22',918,131,5),
			('H22',922,46,7),
			('H22',923,46,8),
			('H22',924,131,6),
			('H22',931,133,1),
			('H22',932,133,2),
			('H22',933,134,1),
			('H22',934,134,2),
			('H22',935,134,3),
			('H22',936,134,4),
			('H22',937,135,1),
			('H22',938,135,2),
			('H22',939,135,3),
			('H22',940,136,1),
			('H22',941,136,2),
			('H22',942,136,3),
			('H22',943,137,1),
			('H22',944,137,2),
			('H22',945,137,3),
			('H22',946,137,4),
			('H22',947,137,5),
			('H22',948,13,13),
			('H22',949,129,7),
			('H22',950,138,1),
			('H22',951,138,2),
			('H22',952,138,3),
			('H22',953,138,4),
			('H22',954,138,5),
			('H22',955,138,6),
			('H22',956,138,7),
			('H22',957,139,1),
			('H22',958,139,2),
			('H22',959,139,3),
			('H22',960,139,4),
			('H22',961,139,5),
			('H22',962,139,6),
			('H22',966,141,1),
			('H22',967,141,2),
			('H22',968,141,3),
			('H22',969,141,4),
			('H22',970,141,5),
			('H26',1,1,0),
			('H26',2,1,1),
			('H26',3,1,2),
			('H26',4,1,3),
			('H26',5,1,4),
			('H26',6,1,5),
			('H26',7,1,6),
			('H26',8,1,7),
			('H26',9,1,8),
			('H26',10,1,9),
			('H26',11,1,10),
			('H26',14,3,0),
			('H26',15,3,1),
			('H26',16,3,2),
			('H26',17,3,3),
			('H26',18,3,4),
			('H26',19,3,5),
			('H26',20,4,0),
			('H26',21,4,1),
			('H26',22,4,2),
			('H26',23,4,3),
			('H26',24,4,4),
			('H26',25,4,5),
			('H26',26,4,6),
			('H26',27,4,7),
			('H26',28,4,8),
			('H26',29,4,9),
			('H26',30,4,10),
			('H26',31,4,11),
			('H26',32,4,12),
			('H26',41,7,0),
			('H26',42,7,1),
			('H26',43,7,2),
			('H26',44,7,3),
			('H26',45,7,4),
			('H26',47,9,0),
			('H26',48,9,1),
			('H26',49,9,2),
			('H26',50,9,3),
			('H26',51,10,0),
			('H26',52,10,1),
			('H26',53,10,2),
			('H26',54,10,3),
			('H26',55,10,4),
			('H26',56,10,5),
			('H26',57,10,6),
			('H26',58,10,7),
			('H26',59,10,8),
			('H26',60,11,0),
			('H26',61,11,1),
			('H26',98,13,0),
			('H26',99,13,1),
			('H26',101,13,3),
			('H26',106,13,8),
			('H26',107,13,9),
			('H26',108,13,10),
			('H26',109,13,11),
			('H26',110,13,12),
			('H26',111,14,0),
			('H26',123,15,0),
			('H26',124,15,1),
			('H26',125,15,2),
			('H26',126,15,3),
			('H26',160,22,0),
			('H26',161,22,1),
			('H26',162,22,2),
			('H26',163,22,3),
			('H26',164,22,4),
			('H26',165,22,5),
			('H26',170,24,0),
			('H26',171,24,1),
			('H26',172,24,2),
			('H26',173,25,0),
			('H26',174,25,1),
			('H26',175,25,2),
			('H26',176,25,3),
			('H26',177,25,4),
			('H26',178,25,5),
			('H26',182,27,0),
			('H26',183,27,1),
			('H26',184,27,2),
			('H26',185,27,3),
			('H26',186,28,0),
			('H26',187,28,1),
			('H26',188,28,2),
			('H26',189,28,3),
			('H26',190,29,0),
			('H26',191,29,1),
			('H26',192,29,2),
			('H26',193,29,3),
			('H26',194,30,0),
			('H26',195,30,1),
			('H26',196,30,2),
			('H26',197,30,3),
			('H26',198,30,4),
			('H26',210,31,1),
			('H26',211,31,2),
			('H26',212,31,3),
			('H26',213,31,4),
			('H26',214,32,1),
			('H26',215,32,2),
			('H26',216,32,3),
			('H26',217,32,4),
			('H26',218,32,5),
			('H26',219,32,6),
			('H26',220,33,1),
			('H26',221,33,2),
			('H26',222,33,3),
			('H26',223,34,1),
			('H26',224,34,2),
			('H26',225,34,3),
			('H26',226,35,1),
			('H26',227,35,2),
			('H26',228,35,3),
			('H26',237,38,1),
			('H26',238,38,2),
			('H26',239,38,3),
			('H26',240,38,4),
			('H26',241,39,1),
			('H26',242,39,2),
			('H26',243,39,3),
			('H26',244,39,4),
			('H26',245,40,1),
			('H26',246,40,2),
			('H26',247,40,3),
			('H26',248,40,4),
			('H26',260,42,1),
			('H26',261,42,2),
			('H26',262,42,3),
			('H26',263,42,4),
			('H26',264,42,5),
			('H26',265,42,6),
			('H26',266,42,7),
			('H26',269,43,1),
			('H26',270,43,2),
			('H26',271,43,3),
			('H26',272,43,4),
			('H26',273,44,1),
			('H26',274,44,2),
			('H26',275,44,3),
			('H26',276,44,4),
			('H26',289,46,1),
			('H26',290,46,2),
			('H26',291,46,3),
			('H26',292,46,4),
			('H26',293,46,5),
			('H26',294,46,6),
			('H26',323,49,2),
			('H26',324,49,3),
			('H26',387,29,NULL),
			('H26',388,57,1),
			('H26',389,57,2),
			('H26',401,59,1),
			('H26',402,59,2),
			('H26',403,60,1),
			('H26',404,60,2),
			('H26',416,63,1),
			('H26',417,63,2),
			('H26',418,63,3),
			('H26',419,64,1),
			('H26',420,64,2),
			('H26',422,65,1),
			('H26',423,65,2),
			('H26',424,65,3),
			('H26',425,66,1),
			('H26',426,66,2),
			('H26',427,66,3),
			('H26',440,68,1),
			('H26',444,68,2),
			('H26',445,68,3),
			('H26',446,14,12),
			('H26',451,14,17),
			('H26',452,14,18),
			('H26',453,14,19),
			('H26',455,11,2),
			('H26',456,11,3),
			('H26',457,11,4),
			('H26',458,11,5),
			('H26',459,11,6),
			('H26',460,11,7),
			('H26',461,11,8),
			('H26',462,11,9),
			('H26',463,11,10),
			('H26',464,11,11),
			('H26',465,11,12),
			('H26',508,37,3),
			('H26',509,37,4),
			('H26',510,37,5),
			('H26',511,37,6),
			('H26',557,29,4),
			('H26',559,70,1),
			('H26',560,70,2),
			('H26',564,71,1),
			('H26',565,71,2),
			('H26',576,74,1),
			('H26',577,74,2),
			('H26',578,74,3),
			('H26',579,74,4),
			('H26',580,74,5),
			('H26',581,74,6),
			('H26',582,74,7),
			('H26',583,74,8),
			('H26',584,74,9),
			('H26',585,74,10),
			('H26',586,74,11),
			('H26',587,75,1),
			('H26',588,75,2),
			('H26',589,75,3),
			('H26',590,76,1),
			('H26',591,76,2),
			('H26',592,76,3),
			('H26',593,77,1),
			('H26',594,77,2),
			('H26',595,77,3),
			('H26',596,77,4),
			('H26',597,77,5),
			('H26',598,77,6),
			('H26',599,77,7),
			('H26',600,77,8),
			('H26',601,77,9),
			('H26',602,77,10),
			('H26',603,77,11),
			('H26',604,77,12),
			('H26',605,77,13),
			('H26',606,77,14),
			('H26',607,77,15),
			('H26',608,78,1),
			('H26',609,78,2),
			('H26',610,78,3),
			('H26',611,78,4),
			('H26',612,78,5),
			('H26',613,78,6),
			('H26',614,78,7),
			('H26',615,78,8),
			('H26',616,78,9),
			('H26',617,78,10),
			('H26',618,78,11),
			('H26',619,78,12),
			('H26',620,78,13),
			('H26',621,78,14),
			('H26',622,78,15),
			('H26',659,85,1),
			('H26',660,85,2),
			('H26',661,85,3),
			('H26',668,87,1),
			('H26',670,89,1),
			('H26',672,37,7),
			('H26',675,90,1),
			('H26',676,90,2),
			('H26',677,90,3),
			('H26',678,90,4),
			('H26',679,90,5),
			('H26',680,90,6),
			('H26',681,90,7),
			('H26',682,91,1),
			('H26',683,91,2),
			('H26',684,91,3),
			('H26',685,91,4),
			('H26',686,91,5),
			('H26',687,91,6),
			('H26',688,91,7),
			('H26',689,63,4),
			('H26',690,63,5),
			('H26',692,93,1),
			('H26',694,29,5),
			('H26',695,29,6),
			('H26',696,29,7),
			('H26',697,94,1),
			('H26',698,94,2),
			('H26',699,94,3),
			('H26',700,57,3),
			('H26',701,90,8),
			('H26',702,91,8),
			('H26',703,95,1),
			('H26',704,95,2),
			('H26',705,96,1),
			('H26',706,96,2),
			('H26',707,96,3),
			('H26',708,96,4),
			('H26',709,96,5),
			('H26',710,96,6),
			('H26',711,96,7),
			('H26',712,96,8),
			('H26',717,98,1),
			('H26',718,98,2),
			('H26',719,98,3),
			('H26',720,14,20),
			('H26',721,14,21),
			('H26',722,14,22),
			('H26',728,100,1),
			('H26',729,100,2),
			('H26',730,100,3),
			('H26',731,100,4),
			('H26',732,100,5),
			('H26',733,100,6),
			('H26',734,100,7),
			('H26',735,100,8),
			('H26',736,100,9),
			('H26',738,102,1),
			('H26',739,102,2),
			('H26',740,102,3),
			('H26',741,102,4),
			('H26',742,102,5),
			('H26',743,102,6),
			('H26',744,102,7),
			('H26',745,102,8),
			('H26',749,104,1),
			('H26',750,104,2),
			('H26',751,104,3),
			('H26',752,104,4),
			('H26',753,104,5),
			('H26',754,104,6),
			('H26',755,104,7),
			('H26',756,104,8),
			('H26',757,105,1),
			('H26',758,105,2),
			('H26',759,105,3),
			('H26',760,106,1),
			('H26',761,106,2),
			('H26',762,106,3),
			('H26',763,106,4),
			('H26',771,87,7),
			('H26',772,87,8),
			('H26',773,141,1),
			('H26',774,141,2),
			('H26',775,141,3),
			('H26',776,141,4),
			('H26',777,141,5),
			('H26',778,108,1),
			('H26',779,108,2),
			('H26',780,108,3),
			('H26',781,108,4),
			('H26',782,108,5),
			('H26',783,108,6),
			('H26',784,109,1),
			('H26',785,109,2),
			('H26',786,109,3),
			('H26',787,109,4),
			('H26',788,109,5),
			('H26',789,109,6),
			('H26',790,110,1),
			('H26',791,110,2),
			('H26',792,110,3),
			('H26',793,110,4),
			('H26',794,110,5),
			('H26',795,110,6),
			('H26',796,111,1),
			('H26',797,111,2),
			('H26',798,111,3),
			('H26',799,111,4),
			('H26',800,111,5),
			('H26',801,111,6),
			('H26',802,112,1),
			('H26',803,112,2),
			('H26',804,112,3),
			('H26',805,112,4),
			('H26',806,112,5),
			('H26',807,112,6),
			('H26',808,113,1),
			('H26',809,113,2),
			('H26',810,113,3),
			('H26',811,113,4),
			('H26',812,113,5),
			('H26',813,113,6),
			('H26',814,114,1),
			('H26',815,114,2),
			('H26',816,114,3),
			('H26',817,114,4),
			('H26',818,114,5),
			('H26',819,114,6),
			('H26',820,115,1),
			('H26',821,115,2),
			('H26',822,115,3),
			('H26',823,115,4),
			('H26',824,115,5),
			('H26',825,115,6),
			('H26',826,116,1),
			('H26',827,116,2),
			('H26',828,116,3),
			('H26',829,116,4),
			('H26',830,116,5),
			('H26',831,116,6),
			('H26',832,117,1),
			('H26',833,117,2),
			('H26',834,117,3),
			('H26',835,117,4),
			('H26',836,117,5),
			('H26',837,117,6),
			('H26',838,118,1),
			('H26',839,118,2),
			('H26',840,118,3),
			('H26',841,118,4),
			('H26',842,118,5),
			('H26',843,118,6),
			('H26',844,118,7),
			('H26',845,119,1),
			('H26',846,119,2),
			('H26',847,120,1),
			('H26',848,120,2),
			('H26',849,121,1),
			('H26',850,121,2),
			('H26',851,122,2),
			('H26',852,122,3),
			('H26',853,122,1),
			('H26',854,122,4),
			('H26',855,123,1),
			('H26',856,123,2),
			('H26',857,123,3),
			('H26',858,123,4),
			('H26',859,123,5),
			('H26',860,124,1),
			('H26',861,124,2),
			('H26',862,124,3),
			('H26',863,124,4),
			('H26',864,124,5),
			('H26',865,125,1),
			('H26',866,125,2),
			('H26',867,125,3),
			('H26',868,125,4),
			('H26',869,125,5),
			('H26',870,125,6),
			('H26',871,125,7),
			('H26',872,126,1),
			('H26',873,126,2),
			('H26',874,126,3),
			('H26',875,126,4),
			('H26',876,126,5),
			('H26',877,126,6),
			('H26',878,126,7),
			('H26',879,126,8),
			('H26',880,126,9),
			('H26',881,127,1),
			('H26',882,127,2),
			('H26',883,127,3),
			('H26',884,127,4),
			('H26',885,127,5),
			('H26',886,128,1),
			('H26',887,128,2),
			('H26',888,128,3),
			('H26',889,128,4),
			('H26',890,128,5),
			('H26',891,128,6),
			('H26',892,128,7),
			('H26',893,128,8),
			('H26',894,128,9),
			('H26',895,128,10),
			('H26',896,128,11),
			('H26',897,128,12),
			('H26',898,128,13),
			('H26',899,128,14),
			('H26',900,128,15),
			('H26',901,128,16),
			('H26',902,129,1),
			('H26',903,129,2),
			('H26',904,129,3),
			('H26',905,129,4),
			('H26',906,129,5),
			('H26',907,129,6),
			('H26',908,130,1),
			('H26',909,130,2),
			('H26',910,119,3),
			('H26',911,119,4),
			('H26',912,119,5),
			('H26',913,119,6),
			('H26',914,131,1),
			('H26',915,131,2),
			('H26',916,131,3),
			('H26',917,131,4),
			('H26',918,131,5),
			('H26',922,46,7),
			('H26',923,46,8),
			('H26',924,131,6),
			('H26',931,133,1),
			('H26',932,133,2),
			('H26',933,134,1),
			('H26',934,134,2),
			('H26',935,134,3),
			('H26',936,134,4),
			('H26',937,135,1),
			('H26',938,135,2),
			('H26',939,135,3),
			('H26',940,136,1),
			('H26',941,136,2),
			('H26',942,136,3),
			('H26',943,137,1),
			('H26',944,137,2),
			('H26',945,137,3),
			('H26',946,137,4),
			('H26',947,137,5),
			('H26',948,13,13),
			('H26',949,129,7),
			('H26',950,138,1),
			('H26',951,138,2),
			('H26',952,138,3),
			('H26',953,138,4),
			('H26',954,138,5),
			('H26',955,138,6),
			('H26',956,138,7),
			('H26',957,139,1),
			('H26',958,139,2),
			('H26',959,139,3),
			('H26',960,139,4),
			('H26',961,139,5),
			('H26',962,139,6),
			('H26',966,141,1),
			('H26',967,141,2),
			('H26',968,141,3),
			('H26',969,141,4),
			('H26',970,141,5),
			('H3',1,1,0),
			('H3',2,1,1),
			('H3',3,1,2),
			('H3',4,1,3),
			('H3',5,1,4),
			('H3',6,1,5),
			('H3',7,1,6),
			('H3',8,1,7),
			('H3',9,1,8),
			('H3',10,1,9),
			('H3',11,1,10),
			('H3',14,3,0),
			('H3',15,3,1),
			('H3',16,3,2),
			('H3',17,3,3),
			('H3',18,3,4),
			('H3',19,3,5),
			('H3',20,4,0),
			('H3',21,4,1),
			('H3',22,4,2),
			('H3',23,4,3),
			('H3',24,4,4),
			('H3',25,4,5),
			('H3',26,4,6),
			('H3',27,4,7),
			('H3',28,4,8),
			('H3',29,4,9),
			('H3',30,4,10),
			('H3',31,4,11),
			('H3',32,4,12),
			('H3',41,7,0),
			('H3',42,7,1),
			('H3',43,7,2),
			('H3',44,7,3),
			('H3',45,7,4),
			('H3',47,9,0),
			('H3',48,9,1),
			('H3',49,9,2),
			('H3',50,9,3),
			('H3',51,10,0),
			('H3',52,10,1),
			('H3',53,10,2),
			('H3',54,10,3),
			('H3',55,10,4),
			('H3',56,10,5),
			('H3',57,10,6),
			('H3',58,10,7),
			('H3',59,10,8),
			('H3',60,11,0),
			('H3',61,11,1),
			('H3',98,13,0),
			('H3',99,13,1),
			('H3',101,13,3),
			('H3',106,13,8),
			('H3',107,13,9),
			('H3',108,13,10),
			('H3',109,13,11),
			('H3',110,13,12),
			('H3',111,14,0),
			('H3',123,15,0),
			('H3',124,15,1),
			('H3',125,15,2),
			('H3',126,15,3),
			('H3',160,22,0),
			('H3',161,22,1),
			('H3',162,22,2),
			('H3',163,22,3),
			('H3',164,22,4),
			('H3',165,22,5),
			('H3',170,24,0),
			('H3',171,24,1),
			('H3',172,24,2),
			('H3',173,25,0),
			('H3',174,25,1),
			('H3',175,25,2),
			('H3',176,25,3),
			('H3',177,25,4),
			('H3',178,25,5),
			('H3',182,27,0),
			('H3',183,27,1),
			('H3',184,27,2),
			('H3',185,27,3),
			('H3',186,28,0),
			('H3',187,28,1),
			('H3',188,28,2),
			('H3',189,28,3),
			('H3',190,29,0),
			('H3',191,29,1),
			('H3',192,29,2),
			('H3',193,29,3),
			('H3',194,30,0),
			('H3',195,30,1),
			('H3',196,30,2),
			('H3',197,30,3),
			('H3',198,30,4),
			('H3',210,31,1),
			('H3',211,31,2),
			('H3',212,31,3),
			('H3',213,31,4),
			('H3',214,32,1),
			('H3',215,32,2),
			('H3',216,32,3),
			('H3',217,32,4),
			('H3',218,32,5),
			('H3',219,32,6),
			('H3',220,33,1),
			('H3',221,33,2),
			('H3',222,33,3),
			('H3',223,34,1),
			('H3',224,34,2),
			('H3',225,34,3),
			('H3',226,35,1),
			('H3',227,35,2),
			('H3',228,35,3),
			('H3',237,38,1),
			('H3',238,38,2),
			('H3',239,38,3),
			('H3',240,38,4),
			('H3',241,39,1),
			('H3',242,39,2),
			('H3',243,39,3),
			('H3',244,39,4),
			('H3',245,40,1),
			('H3',246,40,2),
			('H3',247,40,3),
			('H3',248,40,4),
			('H3',260,42,1),
			('H3',261,42,2),
			('H3',262,42,3),
			('H3',263,42,4),
			('H3',264,42,5),
			('H3',265,42,6),
			('H3',266,42,7),
			('H3',269,43,1),
			('H3',270,43,2),
			('H3',271,43,3),
			('H3',272,43,4),
			('H3',273,44,1),
			('H3',274,44,2),
			('H3',275,44,3),
			('H3',276,44,4),
			('H3',289,46,1),
			('H3',290,46,2),
			('H3',291,46,3),
			('H3',292,46,4),
			('H3',293,46,5),
			('H3',294,46,6),
			('H3',323,49,2),
			('H3',324,49,3),
			('H3',387,29,NULL),
			('H3',388,57,1),
			('H3',389,57,2),
			('H3',401,59,1),
			('H3',402,59,2),
			('H3',403,60,1),
			('H3',404,60,2),
			('H3',416,63,1),
			('H3',417,63,2),
			('H3',418,63,3),
			('H3',419,64,1),
			('H3',420,64,2),
			('H3',422,65,1),
			('H3',423,65,2),
			('H3',424,65,3),
			('H3',425,66,1),
			('H3',426,66,2),
			('H3',427,66,3),
			('H3',440,68,1),
			('H3',444,68,2),
			('H3',445,68,3),
			('H3',446,14,12),
			('H3',451,14,17),
			('H3',452,14,18),
			('H3',453,14,19),
			('H3',455,11,2),
			('H3',456,11,3),
			('H3',457,11,4),
			('H3',458,11,5),
			('H3',459,11,6),
			('H3',460,11,7),
			('H3',461,11,8),
			('H3',462,11,9),
			('H3',463,11,10),
			('H3',464,11,11),
			('H3',465,11,12),
			('H3',508,37,3),
			('H3',509,37,4),
			('H3',510,37,5),
			('H3',511,37,6),
			('H3',557,29,4),
			('H3',559,70,1),
			('H3',560,70,2),
			('H3',564,71,1),
			('H3',565,71,2),
			('H3',576,74,1),
			('H3',577,74,2),
			('H3',578,74,3),
			('H3',579,74,4),
			('H3',580,74,5),
			('H3',581,74,6),
			('H3',582,74,7),
			('H3',583,74,8),
			('H3',584,74,9),
			('H3',585,74,10),
			('H3',586,74,11),
			('H3',587,75,1),
			('H3',588,75,2),
			('H3',589,75,3),
			('H3',590,76,1),
			('H3',591,76,2),
			('H3',592,76,3),
			('H3',593,77,1),
			('H3',594,77,2),
			('H3',595,77,3),
			('H3',596,77,4),
			('H3',597,77,5),
			('H3',598,77,6),
			('H3',599,77,7),
			('H3',600,77,8),
			('H3',601,77,9),
			('H3',602,77,10),
			('H3',603,77,11),
			('H3',604,77,12),
			('H3',605,77,13),
			('H3',606,77,14),
			('H3',607,77,15),
			('H3',608,78,1),
			('H3',609,78,2),
			('H3',610,78,3),
			('H3',611,78,4),
			('H3',612,78,5),
			('H3',613,78,6),
			('H3',614,78,7),
			('H3',615,78,8),
			('H3',616,78,9),
			('H3',617,78,10),
			('H3',618,78,11),
			('H3',619,78,12),
			('H3',620,78,13),
			('H3',621,78,14),
			('H3',622,78,15),
			('H3',659,85,1),
			('H3',660,85,2),
			('H3',661,85,3),
			('H3',668,87,1),
			('H3',670,89,1),
			('H3',672,37,7),
			('H3',675,90,1),
			('H3',676,90,2),
			('H3',677,90,3),
			('H3',678,90,4),
			('H3',679,90,5),
			('H3',680,90,6),
			('H3',681,90,7),
			('H3',682,91,1),
			('H3',683,91,2),
			('H3',684,91,3),
			('H3',685,91,4),
			('H3',686,91,5),
			('H3',687,91,6),
			('H3',688,91,7),
			('H3',689,63,4),
			('H3',690,63,5),
			('H3',692,93,1),
			('H3',694,29,5),
			('H3',695,29,6),
			('H3',696,29,7),
			('H3',697,94,1),
			('H3',698,94,2),
			('H3',699,94,3),
			('H3',700,57,3),
			('H3',701,90,8),
			('H3',702,91,8),
			('H3',703,95,1),
			('H3',704,95,2),
			('H3',705,96,1),
			('H3',706,96,2),
			('H3',707,96,3),
			('H3',708,96,4),
			('H3',709,96,5),
			('H3',710,96,6),
			('H3',711,96,7),
			('H3',712,96,8),
			('H3',717,98,1),
			('H3',718,98,2),
			('H3',719,98,3),
			('H3',720,14,20),
			('H3',721,14,21),
			('H3',722,14,22),
			('H3',728,100,1),
			('H3',729,100,2),
			('H3',730,100,3),
			('H3',731,100,4),
			('H3',732,100,5),
			('H3',733,100,6),
			('H3',734,100,7),
			('H3',735,100,8),
			('H3',736,100,9),
			('H3',738,102,1),
			('H3',739,102,2),
			('H3',740,102,3),
			('H3',741,102,4),
			('H3',742,102,5),
			('H3',743,102,6),
			('H3',744,102,7),
			('H3',745,102,8),
			('H3',749,104,1),
			('H3',750,104,2),
			('H3',751,104,3),
			('H3',752,104,4),
			('H3',753,104,5),
			('H3',754,104,6),
			('H3',755,104,7),
			('H3',756,104,8),
			('H3',757,105,1),
			('H3',758,105,2),
			('H3',759,105,3),
			('H3',760,106,1),
			('H3',761,106,2),
			('H3',762,106,3),
			('H3',763,106,4),
			('H3',771,87,7),
			('H3',772,87,8),
			('H3',773,141,1),
			('H3',774,141,2),
			('H3',775,141,3),
			('H3',776,141,4),
			('H3',777,141,5),
			('H3',778,108,1),
			('H3',779,108,2),
			('H3',780,108,3),
			('H3',781,108,4),
			('H3',782,108,5),
			('H3',783,108,6),
			('H3',784,109,1),
			('H3',785,109,2),
			('H3',786,109,3),
			('H3',787,109,4),
			('H3',788,109,5),
			('H3',789,109,6),
			('H3',790,110,1),
			('H3',791,110,2),
			('H3',792,110,3),
			('H3',793,110,4),
			('H3',794,110,5),
			('H3',795,110,6),
			('H3',796,111,1),
			('H3',797,111,2),
			('H3',798,111,3),
			('H3',799,111,4),
			('H3',800,111,5),
			('H3',801,111,6),
			('H3',802,112,1),
			('H3',803,112,2),
			('H3',804,112,3),
			('H3',805,112,4),
			('H3',806,112,5),
			('H3',807,112,6),
			('H3',808,113,1),
			('H3',809,113,2),
			('H3',810,113,3),
			('H3',811,113,4),
			('H3',812,113,5),
			('H3',813,113,6),
			('H3',814,114,1),
			('H3',815,114,2),
			('H3',816,114,3),
			('H3',817,114,4),
			('H3',818,114,5),
			('H3',819,114,6),
			('H3',820,115,1),
			('H3',821,115,2),
			('H3',822,115,3),
			('H3',823,115,4),
			('H3',824,115,5),
			('H3',825,115,6),
			('H3',826,116,1),
			('H3',827,116,2),
			('H3',828,116,3),
			('H3',829,116,4),
			('H3',830,116,5),
			('H3',831,116,6),
			('H3',832,117,1),
			('H3',833,117,2),
			('H3',834,117,3),
			('H3',835,117,4),
			('H3',836,117,5),
			('H3',837,117,6),
			('H3',838,118,1),
			('H3',839,118,2),
			('H3',840,118,3),
			('H3',841,118,4),
			('H3',842,118,5),
			('H3',843,118,6),
			('H3',844,118,7),
			('H3',845,119,1),
			('H3',846,119,2),
			('H3',847,120,1),
			('H3',848,120,2),
			('H3',849,121,1),
			('H3',850,121,2),
			('H3',851,122,2),
			('H3',852,122,3),
			('H3',853,122,1),
			('H3',854,122,4),
			('H3',855,123,1),
			('H3',856,123,2),
			('H3',857,123,3),
			('H3',858,123,4),
			('H3',859,123,5),
			('H3',860,124,1),
			('H3',861,124,2),
			('H3',862,124,3),
			('H3',863,124,4),
			('H3',864,124,5),
			('H3',865,125,1),
			('H3',866,125,2),
			('H3',867,125,3),
			('H3',868,125,4),
			('H3',869,125,5),
			('H3',870,125,6),
			('H3',871,125,7),
			('H3',872,126,1),
			('H3',873,126,2),
			('H3',874,126,3),
			('H3',875,126,4),
			('H3',876,126,5),
			('H3',877,126,6),
			('H3',878,126,7),
			('H3',879,126,8),
			('H3',880,126,9),
			('H3',881,127,1),
			('H3',882,127,2),
			('H3',883,127,3),
			('H3',884,127,4),
			('H3',885,127,5),
			('H3',886,128,1),
			('H3',887,128,2),
			('H3',888,128,3),
			('H3',889,128,4),
			('H3',890,128,5),
			('H3',891,128,6),
			('H3',892,128,7),
			('H3',893,128,8),
			('H3',894,128,9),
			('H3',895,128,10),
			('H3',896,128,11),
			('H3',897,128,12),
			('H3',898,128,13),
			('H3',899,128,14),
			('H3',900,128,15),
			('H3',901,128,16),
			('H3',902,129,1),
			('H3',903,129,2),
			('H3',904,129,3),
			('H3',905,129,4),
			('H3',906,129,5),
			('H3',907,129,6),
			('H3',908,130,1),
			('H3',909,130,2),
			('H3',910,119,3),
			('H3',911,119,4),
			('H3',912,119,5),
			('H3',913,119,6),
			('H3',914,131,1),
			('H3',915,131,2),
			('H3',916,131,3),
			('H3',917,131,4),
			('H3',918,131,5),
			('H3',922,46,7),
			('H3',923,46,8),
			('H3',924,131,6),
			('H3',931,133,1),
			('H3',932,133,2),
			('H3',933,134,1),
			('H3',934,134,2),
			('H3',935,134,3),
			('H3',936,134,4),
			('H3',937,135,1),
			('H3',938,135,2),
			('H3',939,135,3),
			('H3',940,136,1),
			('H3',941,136,2),
			('H3',942,136,3),
			('H3',943,137,1),
			('H3',944,137,2),
			('H3',945,137,3),
			('H3',946,137,4),
			('H3',947,137,5),
			('H3',948,13,13),
			('H3',949,129,7),
			('H3',950,138,1),
			('H3',951,138,2),
			('H3',952,138,3),
			('H3',953,138,4),
			('H3',954,138,5),
			('H3',955,138,6),
			('H3',956,138,7),
			('H3',957,139,1),
			('H3',958,139,2),
			('H3',959,139,3),
			('H3',960,139,4),
			('H3',961,139,5),
			('H3',962,139,6),
			('H3',966,141,1),
			('H3',967,141,2),
			('H3',968,141,3),
			('H3',969,141,4),
			('H3',970,141,5),
			('H30',1,1,0),
			('H30',2,1,1),
			('H30',3,1,2),
			('H30',4,1,3),
			('H30',5,1,4),
			('H30',6,1,5),
			('H30',7,1,6),
			('H30',8,1,7),
			('H30',9,1,8),
			('H30',10,1,9),
			('H30',11,1,10),
			('H30',14,3,0),
			('H30',15,3,1),
			('H30',16,3,2),
			('H30',17,3,3),
			('H30',18,3,4),
			('H30',19,3,5),
			('H30',20,4,0),
			('H30',21,4,1),
			('H30',22,4,2),
			('H30',23,4,3),
			('H30',24,4,4),
			('H30',25,4,5),
			('H30',26,4,6),
			('H30',27,4,7),
			('H30',28,4,8),
			('H30',29,4,9),
			('H30',30,4,10),
			('H30',31,4,11),
			('H30',32,4,12),
			('H30',41,7,0),
			('H30',42,7,1),
			('H30',43,7,2),
			('H30',44,7,3),
			('H30',45,7,4),
			('H30',47,9,0),
			('H30',48,9,1),
			('H30',49,9,2),
			('H30',50,9,3),
			('H30',51,10,0),
			('H30',52,10,1),
			('H30',53,10,2),
			('H30',54,10,3),
			('H30',55,10,4),
			('H30',56,10,5),
			('H30',57,10,6),
			('H30',58,10,7),
			('H30',59,10,8),
			('H30',60,11,0),
			('H30',61,11,1),
			('H30',98,13,0),
			('H30',99,13,1),
			('H30',101,13,3),
			('H30',106,13,8),
			('H30',107,13,9),
			('H30',108,13,10),
			('H30',109,13,11),
			('H30',110,13,12),
			('H30',111,14,0),
			('H30',123,15,0),
			('H30',124,15,1),
			('H30',125,15,2),
			('H30',126,15,3),
			('H30',160,22,0),
			('H30',161,22,1),
			('H30',162,22,2),
			('H30',163,22,3),
			('H30',164,22,4),
			('H30',165,22,5),
			('H30',170,24,0),
			('H30',171,24,1),
			('H30',172,24,2),
			('H30',173,25,0),
			('H30',174,25,1),
			('H30',175,25,2),
			('H30',176,25,3),
			('H30',177,25,4),
			('H30',178,25,5),
			('H30',182,27,0),
			('H30',183,27,1),
			('H30',184,27,2),
			('H30',185,27,3),
			('H30',186,28,0),
			('H30',187,28,1),
			('H30',188,28,2),
			('H30',189,28,3),
			('H30',190,29,0),
			('H30',191,29,1),
			('H30',192,29,2),
			('H30',193,29,3),
			('H30',194,30,0),
			('H30',195,30,1),
			('H30',196,30,2),
			('H30',197,30,3),
			('H30',198,30,4),
			('H30',210,31,1),
			('H30',211,31,2),
			('H30',212,31,3),
			('H30',213,31,4),
			('H30',214,32,1),
			('H30',215,32,2),
			('H30',216,32,3),
			('H30',217,32,4),
			('H30',218,32,5),
			('H30',219,32,6),
			('H30',220,33,1),
			('H30',221,33,2),
			('H30',222,33,3),
			('H30',223,34,1),
			('H30',224,34,2),
			('H30',225,34,3),
			('H30',226,35,1),
			('H30',227,35,2),
			('H30',228,35,3),
			('H30',237,38,1),
			('H30',238,38,2),
			('H30',239,38,3),
			('H30',240,38,4),
			('H30',241,39,1),
			('H30',242,39,2),
			('H30',243,39,3),
			('H30',244,39,4),
			('H30',245,40,1),
			('H30',246,40,2),
			('H30',247,40,3),
			('H30',248,40,4),
			('H30',260,42,1),
			('H30',261,42,2),
			('H30',262,42,3),
			('H30',263,42,4),
			('H30',264,42,5),
			('H30',265,42,6),
			('H30',266,42,7),
			('H30',269,43,1),
			('H30',270,43,2),
			('H30',271,43,3),
			('H30',272,43,4),
			('H30',273,44,1),
			('H30',274,44,2),
			('H30',275,44,3),
			('H30',276,44,4),
			('H30',289,46,1),
			('H30',290,46,2),
			('H30',291,46,3),
			('H30',292,46,4),
			('H30',293,46,5),
			('H30',294,46,6),
			('H30',323,49,2),
			('H30',324,49,3),
			('H30',387,29,NULL),
			('H30',388,57,1),
			('H30',389,57,2),
			('H30',401,59,1),
			('H30',402,59,2),
			('H30',403,60,1),
			('H30',404,60,2),
			('H30',416,63,1),
			('H30',417,63,2),
			('H30',418,63,3),
			('H30',419,64,1),
			('H30',420,64,2),
			('H30',422,65,1),
			('H30',423,65,2),
			('H30',424,65,3),
			('H30',425,66,1),
			('H30',426,66,2),
			('H30',427,66,3),
			('H30',440,68,1),
			('H30',444,68,2),
			('H30',445,68,3),
			('H30',446,14,12),
			('H30',451,14,17),
			('H30',452,14,18),
			('H30',453,14,19),
			('H30',455,11,2),
			('H30',456,11,3),
			('H30',457,11,4),
			('H30',458,11,5),
			('H30',459,11,6),
			('H30',460,11,7),
			('H30',461,11,8),
			('H30',462,11,9),
			('H30',463,11,10),
			('H30',464,11,11),
			('H30',465,11,12),
			('H30',508,37,3),
			('H30',509,37,4),
			('H30',510,37,5),
			('H30',511,37,6),
			('H30',557,29,4),
			('H30',559,70,1),
			('H30',560,70,2),
			('H30',564,71,1),
			('H30',565,71,2),
			('H30',576,74,1),
			('H30',577,74,2),
			('H30',578,74,3),
			('H30',579,74,4),
			('H30',580,74,5),
			('H30',581,74,6),
			('H30',582,74,7),
			('H30',583,74,8),
			('H30',584,74,9),
			('H30',585,74,10),
			('H30',586,74,11),
			('H30',587,75,1),
			('H30',588,75,2),
			('H30',589,75,3),
			('H30',590,76,1),
			('H30',591,76,2),
			('H30',592,76,3),
			('H30',593,77,1),
			('H30',594,77,2),
			('H30',595,77,3),
			('H30',596,77,4),
			('H30',597,77,5),
			('H30',598,77,6),
			('H30',599,77,7),
			('H30',600,77,8),
			('H30',601,77,9),
			('H30',602,77,10),
			('H30',603,77,11),
			('H30',604,77,12),
			('H30',605,77,13),
			('H30',606,77,14),
			('H30',607,77,15),
			('H30',608,78,1),
			('H30',609,78,2),
			('H30',610,78,3),
			('H30',611,78,4),
			('H30',612,78,5),
			('H30',613,78,6),
			('H30',614,78,7),
			('H30',615,78,8),
			('H30',616,78,9),
			('H30',617,78,10),
			('H30',618,78,11),
			('H30',619,78,12),
			('H30',620,78,13),
			('H30',621,78,14),
			('H30',622,78,15),
			('H30',659,85,1),
			('H30',660,85,2),
			('H30',661,85,3),
			('H30',668,87,1),
			('H30',670,89,1),
			('H30',672,37,7),
			('H30',675,90,1),
			('H30',676,90,2),
			('H30',677,90,3),
			('H30',678,90,4),
			('H30',679,90,5),
			('H30',680,90,6),
			('H30',681,90,7),
			('H30',682,91,1),
			('H30',683,91,2),
			('H30',684,91,3),
			('H30',685,91,4),
			('H30',686,91,5),
			('H30',687,91,6),
			('H30',688,91,7),
			('H30',689,63,4),
			('H30',690,63,5),
			('H30',692,93,1),
			('H30',694,29,5),
			('H30',695,29,6),
			('H30',696,29,7),
			('H30',697,94,1),
			('H30',698,94,2),
			('H30',699,94,3),
			('H30',700,57,3),
			('H30',701,90,8),
			('H30',702,91,8),
			('H30',703,95,1),
			('H30',704,95,2),
			('H30',705,96,1),
			('H30',706,96,2),
			('H30',707,96,3),
			('H30',708,96,4),
			('H30',709,96,5),
			('H30',710,96,6),
			('H30',711,96,7),
			('H30',712,96,8),
			('H30',717,98,1),
			('H30',718,98,2),
			('H30',719,98,3),
			('H30',720,14,20),
			('H30',721,14,21),
			('H30',722,14,22),
			('H30',728,100,1),
			('H30',729,100,2),
			('H30',730,100,3),
			('H30',731,100,4),
			('H30',732,100,5),
			('H30',733,100,6),
			('H30',734,100,7),
			('H30',735,100,8),
			('H30',736,100,9),
			('H30',738,102,1),
			('H30',739,102,2),
			('H30',740,102,3),
			('H30',741,102,4),
			('H30',742,102,5),
			('H30',743,102,6),
			('H30',744,102,7),
			('H30',745,102,8),
			('H30',749,104,1),
			('H30',750,104,2),
			('H30',751,104,3),
			('H30',752,104,4),
			('H30',753,104,5),
			('H30',754,104,6),
			('H30',755,104,7),
			('H30',756,104,8),
			('H30',757,105,1),
			('H30',758,105,2),
			('H30',759,105,3),
			('H30',760,106,1),
			('H30',761,106,2),
			('H30',762,106,3),
			('H30',763,106,4),
			('H30',771,87,7),
			('H30',772,87,8),
			('H30',773,141,1),
			('H30',774,141,2),
			('H30',775,141,3),
			('H30',776,141,4),
			('H30',777,141,5),
			('H30',778,108,1),
			('H30',779,108,2),
			('H30',780,108,3),
			('H30',781,108,4),
			('H30',782,108,5),
			('H30',783,108,6),
			('H30',784,109,1),
			('H30',785,109,2),
			('H30',786,109,3),
			('H30',787,109,4),
			('H30',788,109,5),
			('H30',789,109,6),
			('H30',790,110,1),
			('H30',791,110,2),
			('H30',792,110,3),
			('H30',793,110,4),
			('H30',794,110,5),
			('H30',795,110,6),
			('H30',796,111,1),
			('H30',797,111,2),
			('H30',798,111,3),
			('H30',799,111,4),
			('H30',800,111,5),
			('H30',801,111,6),
			('H30',802,112,1),
			('H30',803,112,2),
			('H30',804,112,3),
			('H30',805,112,4),
			('H30',806,112,5),
			('H30',807,112,6),
			('H30',808,113,1),
			('H30',809,113,2),
			('H30',810,113,3),
			('H30',811,113,4),
			('H30',812,113,5),
			('H30',813,113,6),
			('H30',814,114,1),
			('H30',815,114,2),
			('H30',816,114,3),
			('H30',817,114,4),
			('H30',818,114,5),
			('H30',819,114,6),
			('H30',820,115,1),
			('H30',821,115,2),
			('H30',822,115,3),
			('H30',823,115,4),
			('H30',824,115,5),
			('H30',825,115,6),
			('H30',826,116,1),
			('H30',827,116,2),
			('H30',828,116,3),
			('H30',829,116,4),
			('H30',830,116,5),
			('H30',831,116,6),
			('H30',832,117,1),
			('H30',833,117,2),
			('H30',834,117,3),
			('H30',835,117,4),
			('H30',836,117,5),
			('H30',837,117,6),
			('H30',838,118,1),
			('H30',839,118,2),
			('H30',840,118,3),
			('H30',841,118,4),
			('H30',842,118,5),
			('H30',843,118,6),
			('H30',844,118,7),
			('H30',845,119,1),
			('H30',846,119,2),
			('H30',847,120,1),
			('H30',848,120,2),
			('H30',849,121,1),
			('H30',850,121,2),
			('H30',851,122,2),
			('H30',852,122,3),
			('H30',853,122,1),
			('H30',854,122,4),
			('H30',855,123,1),
			('H30',856,123,2),
			('H30',857,123,3),
			('H30',858,123,4),
			('H30',859,123,5),
			('H30',860,124,1),
			('H30',861,124,2),
			('H30',862,124,3),
			('H30',863,124,4),
			('H30',864,124,5),
			('H30',865,125,1),
			('H30',866,125,2),
			('H30',867,125,3),
			('H30',868,125,4),
			('H30',869,125,5),
			('H30',870,125,6),
			('H30',871,125,7),
			('H30',872,126,1),
			('H30',873,126,2),
			('H30',874,126,3),
			('H30',875,126,4),
			('H30',876,126,5),
			('H30',877,126,6),
			('H30',878,126,7),
			('H30',879,126,8),
			('H30',880,126,9),
			('H30',881,127,1),
			('H30',882,127,2),
			('H30',883,127,3),
			('H30',884,127,4),
			('H30',885,127,5),
			('H30',886,128,1),
			('H30',887,128,2),
			('H30',888,128,3),
			('H30',889,128,4),
			('H30',890,128,5),
			('H30',891,128,6),
			('H30',892,128,7),
			('H30',893,128,8),
			('H30',894,128,9),
			('H30',895,128,10),
			('H30',896,128,11),
			('H30',897,128,12),
			('H30',898,128,13),
			('H30',899,128,14),
			('H30',900,128,15),
			('H30',901,128,16),
			('H30',902,129,1),
			('H30',903,129,2),
			('H30',904,129,3),
			('H30',905,129,4),
			('H30',906,129,5),
			('H30',907,129,6),
			('H30',908,130,1),
			('H30',909,130,2),
			('H30',910,119,3),
			('H30',911,119,4),
			('H30',912,119,5),
			('H30',913,119,6),
			('H30',914,131,1),
			('H30',915,131,2),
			('H30',916,131,3),
			('H30',917,131,4),
			('H30',918,131,5),
			('H30',922,46,7),
			('H30',923,46,8),
			('H30',924,131,6),
			('H30',931,133,1),
			('H30',932,133,2),
			('H30',933,134,1),
			('H30',934,134,2),
			('H30',935,134,3),
			('H30',936,134,4),
			('H30',937,135,1),
			('H30',938,135,2),
			('H30',939,135,3),
			('H30',940,136,1),
			('H30',941,136,2),
			('H30',942,136,3),
			('H30',943,137,1),
			('H30',944,137,2),
			('H30',945,137,3),
			('H30',946,137,4),
			('H30',947,137,5),
			('H30',948,13,13),
			('H30',949,129,7),
			('H30',950,138,1),
			('H30',951,138,2),
			('H30',952,138,3),
			('H30',953,138,4),
			('H30',954,138,5),
			('H30',955,138,6),
			('H30',956,138,7),
			('H30',957,139,1),
			('H30',958,139,2),
			('H30',959,139,3),
			('H30',960,139,4),
			('H30',961,139,5),
			('H30',962,139,6),
			('H30',966,141,1),
			('H30',967,141,2),
			('H30',968,141,3),
			('H30',969,141,4),
			('H30',970,141,5),
			('H34',1,1,0),
			('H34',2,1,1),
			('H34',3,1,2),
			('H34',4,1,3),
			('H34',5,1,4),
			('H34',6,1,5),
			('H34',7,1,6),
			('H34',8,1,7),
			('H34',9,1,8),
			('H34',10,1,9),
			('H34',11,1,10),
			('H34',14,3,0),
			('H34',15,3,1),
			('H34',16,3,2),
			('H34',17,3,3),
			('H34',18,3,4),
			('H34',19,3,5),
			('H34',20,4,0),
			('H34',21,4,1),
			('H34',22,4,2),
			('H34',23,4,3),
			('H34',24,4,4),
			('H34',25,4,5),
			('H34',26,4,6),
			('H34',27,4,7),
			('H34',28,4,8),
			('H34',29,4,9),
			('H34',30,4,10),
			('H34',31,4,11),
			('H34',32,4,12),
			('H34',41,7,0),
			('H34',42,7,1),
			('H34',43,7,2),
			('H34',44,7,3),
			('H34',45,7,4),
			('H34',47,9,0),
			('H34',48,9,1),
			('H34',49,9,2),
			('H34',50,9,3),
			('H34',51,10,0),
			('H34',52,10,1),
			('H34',53,10,2),
			('H34',54,10,3),
			('H34',55,10,4),
			('H34',56,10,5),
			('H34',57,10,6),
			('H34',58,10,7),
			('H34',59,10,8),
			('H34',60,11,0),
			('H34',61,11,1),
			('H34',98,13,0),
			('H34',99,13,1),
			('H34',101,13,3),
			('H34',106,13,8),
			('H34',107,13,9),
			('H34',108,13,10),
			('H34',109,13,11),
			('H34',110,13,12),
			('H34',111,14,0),
			('H34',123,15,0),
			('H34',124,15,1),
			('H34',125,15,2),
			('H34',126,15,3),
			('H34',160,22,0),
			('H34',161,22,1),
			('H34',162,22,2),
			('H34',163,22,3),
			('H34',164,22,4),
			('H34',165,22,5),
			('H34',170,24,0),
			('H34',171,24,1),
			('H34',172,24,2),
			('H34',173,25,0),
			('H34',174,25,1),
			('H34',175,25,2),
			('H34',176,25,3),
			('H34',177,25,4),
			('H34',178,25,5),
			('H34',182,27,0),
			('H34',183,27,1),
			('H34',184,27,2),
			('H34',185,27,3),
			('H34',186,28,0),
			('H34',187,28,1),
			('H34',188,28,2),
			('H34',189,28,3),
			('H34',190,29,0),
			('H34',191,29,1),
			('H34',192,29,2),
			('H34',193,29,3),
			('H34',194,30,0),
			('H34',195,30,1),
			('H34',196,30,2),
			('H34',197,30,3),
			('H34',198,30,4),
			('H34',210,31,1),
			('H34',211,31,2),
			('H34',212,31,3),
			('H34',213,31,4),
			('H34',214,32,1),
			('H34',215,32,2),
			('H34',216,32,3),
			('H34',217,32,4),
			('H34',218,32,5),
			('H34',219,32,6),
			('H34',220,33,1),
			('H34',221,33,2),
			('H34',222,33,3),
			('H34',223,34,1),
			('H34',224,34,2),
			('H34',225,34,3),
			('H34',226,35,1),
			('H34',227,35,2),
			('H34',228,35,3),
			('H34',237,38,1),
			('H34',238,38,2),
			('H34',239,38,3),
			('H34',240,38,4),
			('H34',241,39,1),
			('H34',242,39,2),
			('H34',243,39,3),
			('H34',244,39,4),
			('H34',245,40,1),
			('H34',246,40,2),
			('H34',247,40,3),
			('H34',248,40,4),
			('H34',260,42,1),
			('H34',261,42,2),
			('H34',262,42,3),
			('H34',263,42,4),
			('H34',264,42,5),
			('H34',265,42,6),
			('H34',266,42,7),
			('H34',269,43,1),
			('H34',270,43,2),
			('H34',271,43,3),
			('H34',272,43,4),
			('H34',273,44,1),
			('H34',274,44,2),
			('H34',275,44,3),
			('H34',276,44,4),
			('H34',289,46,1),
			('H34',290,46,2),
			('H34',291,46,3),
			('H34',292,46,4),
			('H34',293,46,5),
			('H34',294,46,6),
			('H34',323,49,2),
			('H34',324,49,3),
			('H34',387,29,NULL),
			('H34',388,57,1),
			('H34',389,57,2),
			('H34',401,59,1),
			('H34',402,59,2),
			('H34',403,60,1),
			('H34',404,60,2),
			('H34',416,63,1),
			('H34',417,63,2),
			('H34',418,63,3),
			('H34',419,64,1),
			('H34',420,64,2),
			('H34',422,65,1),
			('H34',423,65,2),
			('H34',424,65,3),
			('H34',425,66,1),
			('H34',426,66,2),
			('H34',427,66,3),
			('H34',440,68,1),
			('H34',444,68,2),
			('H34',445,68,3),
			('H34',446,14,12),
			('H34',451,14,17),
			('H34',452,14,18),
			('H34',453,14,19),
			('H34',455,11,2),
			('H34',456,11,3),
			('H34',457,11,4),
			('H34',458,11,5),
			('H34',459,11,6),
			('H34',460,11,7),
			('H34',461,11,8),
			('H34',462,11,9),
			('H34',463,11,10),
			('H34',464,11,11),
			('H34',465,11,12),
			('H34',508,37,3),
			('H34',509,37,4),
			('H34',510,37,5),
			('H34',511,37,6),
			('H34',557,29,4),
			('H34',559,70,1),
			('H34',560,70,2),
			('H34',564,71,1),
			('H34',565,71,2),
			('H34',576,74,1),
			('H34',577,74,2),
			('H34',578,74,3),
			('H34',579,74,4),
			('H34',580,74,5),
			('H34',581,74,6),
			('H34',582,74,7),
			('H34',583,74,8),
			('H34',584,74,9),
			('H34',585,74,10),
			('H34',586,74,11),
			('H34',587,75,1),
			('H34',588,75,2),
			('H34',589,75,3),
			('H34',590,76,1),
			('H34',591,76,2),
			('H34',592,76,3),
			('H34',593,77,1),
			('H34',594,77,2),
			('H34',595,77,3),
			('H34',596,77,4),
			('H34',597,77,5),
			('H34',598,77,6),
			('H34',599,77,7),
			('H34',600,77,8),
			('H34',601,77,9),
			('H34',602,77,10),
			('H34',603,77,11),
			('H34',604,77,12),
			('H34',605,77,13),
			('H34',606,77,14),
			('H34',607,77,15),
			('H34',608,78,1),
			('H34',609,78,2),
			('H34',610,78,3),
			('H34',611,78,4),
			('H34',612,78,5),
			('H34',613,78,6),
			('H34',614,78,7),
			('H34',615,78,8),
			('H34',616,78,9),
			('H34',617,78,10),
			('H34',618,78,11),
			('H34',619,78,12),
			('H34',620,78,13),
			('H34',621,78,14),
			('H34',622,78,15),
			('H34',659,85,1),
			('H34',660,85,2),
			('H34',661,85,3),
			('H34',668,87,1),
			('H34',670,89,1),
			('H34',672,37,7),
			('H34',675,90,1),
			('H34',676,90,2),
			('H34',677,90,3),
			('H34',678,90,4),
			('H34',679,90,5),
			('H34',680,90,6),
			('H34',681,90,7),
			('H34',682,91,1),
			('H34',683,91,2),
			('H34',684,91,3),
			('H34',685,91,4),
			('H34',686,91,5),
			('H34',687,91,6),
			('H34',688,91,7),
			('H34',689,63,4),
			('H34',690,63,5),
			('H34',692,93,1),
			('H34',694,29,5),
			('H34',695,29,6),
			('H34',696,29,7),
			('H34',697,94,1),
			('H34',698,94,2),
			('H34',699,94,3),
			('H34',700,57,3),
			('H34',701,90,8),
			('H34',702,91,8),
			('H34',703,95,1),
			('H34',704,95,2),
			('H34',705,96,1),
			('H34',706,96,2),
			('H34',707,96,3),
			('H34',708,96,4),
			('H34',709,96,5),
			('H34',710,96,6),
			('H34',711,96,7),
			('H34',712,96,8),
			('H34',717,98,1),
			('H34',718,98,2),
			('H34',719,98,3),
			('H34',720,14,20),
			('H34',721,14,21),
			('H34',722,14,22),
			('H34',728,100,1),
			('H34',729,100,2),
			('H34',730,100,3),
			('H34',731,100,4),
			('H34',732,100,5),
			('H34',733,100,6),
			('H34',734,100,7),
			('H34',735,100,8),
			('H34',736,100,9),
			('H34',738,102,1),
			('H34',739,102,2),
			('H34',740,102,3),
			('H34',741,102,4),
			('H34',742,102,5),
			('H34',743,102,6),
			('H34',744,102,7),
			('H34',745,102,8),
			('H34',749,104,1),
			('H34',750,104,2),
			('H34',751,104,3),
			('H34',752,104,4),
			('H34',753,104,5),
			('H34',754,104,6),
			('H34',755,104,7),
			('H34',756,104,8),
			('H34',757,105,1),
			('H34',758,105,2),
			('H34',759,105,3),
			('H34',760,106,1),
			('H34',761,106,2),
			('H34',762,106,3),
			('H34',763,106,4),
			('H34',771,87,7),
			('H34',772,87,8),
			('H34',773,141,1),
			('H34',774,141,2),
			('H34',775,141,3),
			('H34',776,141,4),
			('H34',777,141,5),
			('H34',778,108,1),
			('H34',779,108,2),
			('H34',780,108,3),
			('H34',781,108,4),
			('H34',782,108,5),
			('H34',783,108,6),
			('H34',784,109,1),
			('H34',785,109,2),
			('H34',786,109,3),
			('H34',787,109,4),
			('H34',788,109,5),
			('H34',789,109,6),
			('H34',790,110,1),
			('H34',791,110,2),
			('H34',792,110,3),
			('H34',793,110,4),
			('H34',794,110,5),
			('H34',795,110,6),
			('H34',796,111,1),
			('H34',797,111,2),
			('H34',798,111,3),
			('H34',799,111,4),
			('H34',800,111,5),
			('H34',801,111,6),
			('H34',802,112,1),
			('H34',803,112,2),
			('H34',804,112,3),
			('H34',805,112,4),
			('H34',806,112,5),
			('H34',807,112,6),
			('H34',808,113,1),
			('H34',809,113,2),
			('H34',810,113,3),
			('H34',811,113,4),
			('H34',812,113,5),
			('H34',813,113,6),
			('H34',814,114,1),
			('H34',815,114,2),
			('H34',816,114,3),
			('H34',817,114,4),
			('H34',818,114,5),
			('H34',819,114,6),
			('H34',820,115,1),
			('H34',821,115,2),
			('H34',822,115,3),
			('H34',823,115,4),
			('H34',824,115,5),
			('H34',825,115,6),
			('H34',826,116,1),
			('H34',827,116,2),
			('H34',828,116,3),
			('H34',829,116,4),
			('H34',830,116,5),
			('H34',831,116,6),
			('H34',832,117,1),
			('H34',833,117,2),
			('H34',834,117,3),
			('H34',835,117,4),
			('H34',836,117,5),
			('H34',837,117,6),
			('H34',838,118,1),
			('H34',839,118,2),
			('H34',840,118,3),
			('H34',841,118,4),
			('H34',842,118,5),
			('H34',843,118,6),
			('H34',844,118,7),
			('H34',845,119,1),
			('H34',846,119,2),
			('H34',847,120,1),
			('H34',848,120,2),
			('H34',849,121,1),
			('H34',850,121,2),
			('H34',851,122,2),
			('H34',852,122,3),
			('H34',853,122,1),
			('H34',854,122,4),
			('H34',855,123,1),
			('H34',856,123,2),
			('H34',857,123,3),
			('H34',858,123,4),
			('H34',859,123,5),
			('H34',860,124,1),
			('H34',861,124,2),
			('H34',862,124,3),
			('H34',863,124,4),
			('H34',864,124,5),
			('H34',865,125,1),
			('H34',866,125,2),
			('H34',867,125,3),
			('H34',868,125,4),
			('H34',869,125,5),
			('H34',870,125,6),
			('H34',871,125,7),
			('H34',872,126,1),
			('H34',873,126,2),
			('H34',874,126,3),
			('H34',875,126,4),
			('H34',876,126,5),
			('H34',877,126,6),
			('H34',878,126,7),
			('H34',879,126,8),
			('H34',880,126,9),
			('H34',881,127,1),
			('H34',882,127,2),
			('H34',883,127,3),
			('H34',884,127,4),
			('H34',885,127,5),
			('H34',886,128,1),
			('H34',887,128,2),
			('H34',888,128,3),
			('H34',889,128,4),
			('H34',890,128,5),
			('H34',891,128,6),
			('H34',892,128,7),
			('H34',893,128,8),
			('H34',894,128,9),
			('H34',895,128,10),
			('H34',896,128,11),
			('H34',897,128,12),
			('H34',898,128,13),
			('H34',899,128,14),
			('H34',900,128,15),
			('H34',901,128,16),
			('H34',902,129,1),
			('H34',903,129,2),
			('H34',904,129,3),
			('H34',905,129,4),
			('H34',906,129,5),
			('H34',907,129,6),
			('H34',908,130,1),
			('H34',909,130,2),
			('H34',910,119,3),
			('H34',911,119,4),
			('H34',912,119,5),
			('H34',913,119,6),
			('H34',914,131,1),
			('H34',915,131,2),
			('H34',916,131,3),
			('H34',917,131,4),
			('H34',918,131,5),
			('H34',922,46,7),
			('H34',923,46,8),
			('H34',924,131,6),
			('H34',931,133,1),
			('H34',932,133,2),
			('H34',933,134,1),
			('H34',934,134,2),
			('H34',935,134,3),
			('H34',936,134,4),
			('H34',937,135,1),
			('H34',938,135,2),
			('H34',939,135,3),
			('H34',940,136,1),
			('H34',941,136,2),
			('H34',942,136,3),
			('H34',943,137,1),
			('H34',944,137,2),
			('H34',945,137,3),
			('H34',946,137,4),
			('H34',947,137,5),
			('H34',948,13,13),
			('H34',949,129,7),
			('H34',950,138,1),
			('H34',951,138,2),
			('H34',952,138,3),
			('H34',953,138,4),
			('H34',954,138,5),
			('H34',955,138,6),
			('H34',956,138,7),
			('H34',957,139,1),
			('H34',958,139,2),
			('H34',959,139,3),
			('H34',960,139,4),
			('H34',961,139,5),
			('H34',962,139,6),
			('H34',966,141,1),
			('H34',967,141,2),
			('H34',968,141,3),
			('H34',969,141,4),
			('H34',970,141,5),
			('H6',1,1,0),
			('H6',2,1,1),
			('H6',3,1,2),
			('H6',4,1,3),
			('H6',5,1,4),
			('H6',6,1,5),
			('H6',7,1,6),
			('H6',8,1,7),
			('H6',9,1,8),
			('H6',10,1,9),
			('H6',11,1,10),
			('H6',14,3,0),
			('H6',15,3,1),
			('H6',16,3,2),
			('H6',17,3,3),
			('H6',18,3,4),
			('H6',19,3,5),
			('H6',20,4,0),
			('H6',21,4,1),
			('H6',22,4,2),
			('H6',23,4,3),
			('H6',24,4,4),
			('H6',25,4,5),
			('H6',26,4,6),
			('H6',27,4,7),
			('H6',28,4,8),
			('H6',29,4,9),
			('H6',30,4,10),
			('H6',31,4,11),
			('H6',32,4,12),
			('H6',41,7,0),
			('H6',42,7,1),
			('H6',43,7,2),
			('H6',44,7,3),
			('H6',45,7,4),
			('H6',47,9,0),
			('H6',48,9,1),
			('H6',49,9,2),
			('H6',50,9,3),
			('H6',51,10,0),
			('H6',52,10,1),
			('H6',53,10,2),
			('H6',54,10,3),
			('H6',55,10,4),
			('H6',56,10,5),
			('H6',57,10,6),
			('H6',58,10,7),
			('H6',59,10,8),
			('H6',60,11,0),
			('H6',61,11,1),
			('H6',98,13,0),
			('H6',99,13,1),
			('H6',101,13,3),
			('H6',106,13,8),
			('H6',107,13,9),
			('H6',108,13,10),
			('H6',109,13,11),
			('H6',110,13,12),
			('H6',111,14,0),
			('H6',123,15,0),
			('H6',124,15,1),
			('H6',125,15,2),
			('H6',126,15,3),
			('H6',160,22,0),
			('H6',161,22,1),
			('H6',162,22,2),
			('H6',163,22,3),
			('H6',164,22,4),
			('H6',165,22,5),
			('H6',170,24,0),
			('H6',171,24,1),
			('H6',172,24,2),
			('H6',173,25,0),
			('H6',174,25,1),
			('H6',175,25,2),
			('H6',176,25,3),
			('H6',177,25,4),
			('H6',178,25,5),
			('H6',182,27,0),
			('H6',183,27,1),
			('H6',184,27,2),
			('H6',185,27,3),
			('H6',186,28,0),
			('H6',187,28,1),
			('H6',188,28,2),
			('H6',189,28,3),
			('H6',190,29,0),
			('H6',191,29,1),
			('H6',192,29,2),
			('H6',193,29,3),
			('H6',194,30,0),
			('H6',195,30,1),
			('H6',196,30,2),
			('H6',197,30,3),
			('H6',198,30,4),
			('H6',210,31,1),
			('H6',211,31,2),
			('H6',212,31,3),
			('H6',213,31,4),
			('H6',214,32,1),
			('H6',215,32,2),
			('H6',216,32,3),
			('H6',217,32,4),
			('H6',218,32,5),
			('H6',219,32,6),
			('H6',220,33,1),
			('H6',221,33,2),
			('H6',222,33,3),
			('H6',223,34,1),
			('H6',224,34,2),
			('H6',225,34,3),
			('H6',226,35,1),
			('H6',227,35,2),
			('H6',228,35,3),
			('H6',237,38,1),
			('H6',238,38,2),
			('H6',239,38,3),
			('H6',240,38,4),
			('H6',241,39,1),
			('H6',242,39,2),
			('H6',243,39,3),
			('H6',244,39,4),
			('H6',245,40,1),
			('H6',246,40,2),
			('H6',247,40,3),
			('H6',248,40,4),
			('H6',260,42,1),
			('H6',261,42,2),
			('H6',262,42,3),
			('H6',263,42,4),
			('H6',264,42,5),
			('H6',265,42,6),
			('H6',266,42,7),
			('H6',269,43,1),
			('H6',270,43,2),
			('H6',271,43,3),
			('H6',272,43,4),
			('H6',273,44,1),
			('H6',274,44,2),
			('H6',275,44,3),
			('H6',276,44,4),
			('H6',289,46,1),
			('H6',290,46,2),
			('H6',291,46,3),
			('H6',292,46,4),
			('H6',293,46,5),
			('H6',294,46,6),
			('H6',323,49,2),
			('H6',324,49,3),
			('H6',387,29,NULL),
			('H6',388,57,1),
			('H6',389,57,2),
			('H6',401,59,1),
			('H6',402,59,2),
			('H6',403,60,1),
			('H6',404,60,2),
			('H6',416,63,1),
			('H6',417,63,2),
			('H6',418,63,3),
			('H6',419,64,1),
			('H6',420,64,2),
			('H6',422,65,1),
			('H6',423,65,2),
			('H6',424,65,3),
			('H6',425,66,1),
			('H6',426,66,2),
			('H6',427,66,3),
			('H6',440,68,1),
			('H6',444,68,2),
			('H6',445,68,3),
			('H6',446,14,12),
			('H6',451,14,17),
			('H6',452,14,18),
			('H6',453,14,19),
			('H6',455,11,2),
			('H6',456,11,3),
			('H6',457,11,4),
			('H6',458,11,5),
			('H6',459,11,6),
			('H6',460,11,7),
			('H6',461,11,8),
			('H6',462,11,9),
			('H6',463,11,10),
			('H6',464,11,11),
			('H6',465,11,12),
			('H6',508,37,3),
			('H6',509,37,4),
			('H6',510,37,5),
			('H6',511,37,6),
			('H6',557,29,4),
			('H6',559,70,1),
			('H6',560,70,2),
			('H6',564,71,1),
			('H6',565,71,2),
			('H6',576,74,1),
			('H6',577,74,2),
			('H6',578,74,3),
			('H6',579,74,4),
			('H6',580,74,5),
			('H6',581,74,6),
			('H6',582,74,7),
			('H6',583,74,8),
			('H6',584,74,9),
			('H6',585,74,10),
			('H6',586,74,11),
			('H6',587,75,1),
			('H6',588,75,2),
			('H6',589,75,3),
			('H6',590,76,1),
			('H6',591,76,2),
			('H6',592,76,3),
			('H6',593,77,1),
			('H6',594,77,2),
			('H6',595,77,3),
			('H6',596,77,4),
			('H6',597,77,5),
			('H6',598,77,6),
			('H6',599,77,7),
			('H6',600,77,8),
			('H6',601,77,9),
			('H6',602,77,10),
			('H6',603,77,11),
			('H6',604,77,12),
			('H6',605,77,13),
			('H6',606,77,14),
			('H6',607,77,15),
			('H6',608,78,1),
			('H6',609,78,2),
			('H6',610,78,3),
			('H6',611,78,4),
			('H6',612,78,5),
			('H6',613,78,6),
			('H6',614,78,7),
			('H6',615,78,8),
			('H6',616,78,9),
			('H6',617,78,10),
			('H6',618,78,11),
			('H6',619,78,12),
			('H6',620,78,13),
			('H6',621,78,14),
			('H6',622,78,15),
			('H6',659,85,1),
			('H6',660,85,2),
			('H6',661,85,3),
			('H6',668,87,1),
			('H6',670,89,1),
			('H6',672,37,7),
			('H6',675,90,1),
			('H6',676,90,2),
			('H6',677,90,3),
			('H6',678,90,4),
			('H6',679,90,5),
			('H6',680,90,6),
			('H6',681,90,7),
			('H6',682,91,1),
			('H6',683,91,2),
			('H6',684,91,3),
			('H6',685,91,4),
			('H6',686,91,5),
			('H6',687,91,6),
			('H6',688,91,7),
			('H6',689,63,4),
			('H6',690,63,5),
			('H6',692,93,1),
			('H6',694,29,5),
			('H6',695,29,6),
			('H6',696,29,7),
			('H6',697,94,1),
			('H6',698,94,2),
			('H6',699,94,3),
			('H6',700,57,3),
			('H6',701,90,8),
			('H6',702,91,8),
			('H6',703,95,1),
			('H6',704,95,2),
			('H6',705,96,1),
			('H6',706,96,2),
			('H6',707,96,3),
			('H6',708,96,4),
			('H6',709,96,5),
			('H6',710,96,6),
			('H6',711,96,7),
			('H6',712,96,8),
			('H6',717,98,1),
			('H6',718,98,2),
			('H6',719,98,3),
			('H6',720,14,20),
			('H6',721,14,21),
			('H6',722,14,22),
			('H6',728,100,1),
			('H6',729,100,2),
			('H6',730,100,3),
			('H6',731,100,4),
			('H6',732,100,5),
			('H6',733,100,6),
			('H6',734,100,7),
			('H6',735,100,8),
			('H6',736,100,9),
			('H6',738,102,1),
			('H6',739,102,2),
			('H6',740,102,3),
			('H6',741,102,4),
			('H6',742,102,5),
			('H6',743,102,6),
			('H6',744,102,7),
			('H6',745,102,8),
			('H6',749,104,1),
			('H6',750,104,2),
			('H6',751,104,3),
			('H6',752,104,4),
			('H6',753,104,5),
			('H6',754,104,6),
			('H6',755,104,7),
			('H6',756,104,8),
			('H6',757,105,1),
			('H6',758,105,2),
			('H6',759,105,3),
			('H6',760,106,1),
			('H6',761,106,2),
			('H6',762,106,3),
			('H6',763,106,4),
			('H6',771,87,7),
			('H6',772,87,8),
			('H6',773,141,1),
			('H6',774,141,2),
			('H6',775,141,3),
			('H6',776,141,4),
			('H6',777,141,5),
			('H6',778,108,1),
			('H6',779,108,2),
			('H6',780,108,3),
			('H6',781,108,4),
			('H6',782,108,5),
			('H6',783,108,6),
			('H6',784,109,1),
			('H6',785,109,2),
			('H6',786,109,3),
			('H6',787,109,4),
			('H6',788,109,5),
			('H6',789,109,6),
			('H6',790,110,1),
			('H6',791,110,2),
			('H6',792,110,3),
			('H6',793,110,4),
			('H6',794,110,5),
			('H6',795,110,6),
			('H6',796,111,1),
			('H6',797,111,2),
			('H6',798,111,3),
			('H6',799,111,4),
			('H6',800,111,5),
			('H6',801,111,6),
			('H6',802,112,1),
			('H6',803,112,2),
			('H6',804,112,3),
			('H6',805,112,4),
			('H6',806,112,5),
			('H6',807,112,6),
			('H6',808,113,1),
			('H6',809,113,2),
			('H6',810,113,3),
			('H6',811,113,4),
			('H6',812,113,5),
			('H6',813,113,6),
			('H6',814,114,1),
			('H6',815,114,2),
			('H6',816,114,3),
			('H6',817,114,4),
			('H6',818,114,5),
			('H6',819,114,6),
			('H6',820,115,1),
			('H6',821,115,2),
			('H6',822,115,3),
			('H6',823,115,4),
			('H6',824,115,5),
			('H6',825,115,6),
			('H6',826,116,1),
			('H6',827,116,2),
			('H6',828,116,3),
			('H6',829,116,4),
			('H6',830,116,5),
			('H6',831,116,6),
			('H6',832,117,1),
			('H6',833,117,2),
			('H6',834,117,3),
			('H6',835,117,4),
			('H6',836,117,5),
			('H6',837,117,6),
			('H6',838,118,1),
			('H6',839,118,2),
			('H6',840,118,3),
			('H6',841,118,4),
			('H6',842,118,5),
			('H6',843,118,6),
			('H6',844,118,7),
			('H6',845,119,1),
			('H6',846,119,2),
			('H6',847,120,1),
			('H6',848,120,2),
			('H6',849,121,1),
			('H6',850,121,2),
			('H6',851,122,2),
			('H6',852,122,3),
			('H6',853,122,1),
			('H6',854,122,4),
			('H6',855,123,1),
			('H6',856,123,2),
			('H6',857,123,3),
			('H6',858,123,4),
			('H6',859,123,5),
			('H6',860,124,1),
			('H6',861,124,2),
			('H6',862,124,3),
			('H6',863,124,4),
			('H6',864,124,5),
			('H6',865,125,1),
			('H6',866,125,2),
			('H6',867,125,3),
			('H6',868,125,4),
			('H6',869,125,5),
			('H6',870,125,6),
			('H6',871,125,7),
			('H6',872,126,1),
			('H6',873,126,2),
			('H6',874,126,3),
			('H6',875,126,4),
			('H6',876,126,5),
			('H6',877,126,6),
			('H6',878,126,7),
			('H6',879,126,8),
			('H6',880,126,9),
			('H6',881,127,1),
			('H6',882,127,2),
			('H6',883,127,3),
			('H6',884,127,4),
			('H6',885,127,5),
			('H6',886,128,1),
			('H6',887,128,2),
			('H6',888,128,3),
			('H6',889,128,4),
			('H6',890,128,5),
			('H6',891,128,6),
			('H6',892,128,7),
			('H6',893,128,8),
			('H6',894,128,9),
			('H6',895,128,10),
			('H6',896,128,11),
			('H6',897,128,12),
			('H6',898,128,13),
			('H6',899,128,14),
			('H6',900,128,15),
			('H6',901,128,16),
			('H6',902,129,1),
			('H6',903,129,2),
			('H6',904,129,3),
			('H6',905,129,4),
			('H6',906,129,5),
			('H6',907,129,6),
			('H6',908,130,1),
			('H6',909,130,2),
			('H6',910,119,3),
			('H6',911,119,4),
			('H6',912,119,5),
			('H6',913,119,6),
			('H6',914,131,1),
			('H6',915,131,2),
			('H6',916,131,3),
			('H6',917,131,4),
			('H6',918,131,5),
			('H6',922,46,7),
			('H6',923,46,8),
			('H6',924,131,6),
			('H6',931,133,1),
			('H6',932,133,2),
			('H6',933,134,1),
			('H6',934,134,2),
			('H6',935,134,3),
			('H6',936,134,4),
			('H6',937,135,1),
			('H6',938,135,2),
			('H6',939,135,3),
			('H6',940,136,1),
			('H6',941,136,2),
			('H6',942,136,3),
			('H6',943,137,1),
			('H6',944,137,2),
			('H6',945,137,3),
			('H6',946,137,4),
			('H6',947,137,5),
			('H6',948,13,13),
			('H6',949,129,7),
			('H6',950,138,1),
			('H6',951,138,2),
			('H6',952,138,3),
			('H6',953,138,4),
			('H6',954,138,5),
			('H6',955,138,6),
			('H6',956,138,7),
			('H6',957,139,1),
			('H6',958,139,2),
			('H6',959,139,3),
			('H6',960,139,4),
			('H6',961,139,5),
			('H6',962,139,6),
			('H6',966,141,1),
			('H6',967,141,2),
			('H6',968,141,3),
			('H6',969,141,4),
			('H6',970,141,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_role2profile`(`roleid`,`profileid`) values
			('H10',1),
			('H14',1),
			('H18',1),
			('H2',1),
			('H22',1),
			('H26',1),
			('H3',1),
			('H30',1),
			('H34',1),
			('H6',1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_role_seq`(`id`) values
			(37);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_rowheight`(`rowheightid`,`rowheight`,`sortorderid`,`presence`) values
			(2,'medium',2,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_salutationtype`(`salutationtypeid`,`salutationtype`,`presence`,`picklist_valueid`,`sortorderid`) values
			(2,'Mr.',1,161,1),
			(3,'Ms.',1,162,2),
			(4,'Mrs.',1,163,3),
			(5,'Dr.',1,164,4),
			(6,'Prof.',1,165,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_scalculations_status`(`scalculations_statusid`,`scalculations_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,855),
			(2,'PLL_IN_REALIZATION',2,1,856),
			(3,'PLL_FOR_VERIFICATION',3,1,857),
			(4,'PLL_CANCELLED',4,0,858),
			(5,'PLL_COMPLETED',5,0,859);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_service_usageunit`(`service_usageunitid`,`service_usageunit`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Hours',1,226,1),
			(2,'Days',1,227,2),
			(3,'Incidents',1,228,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_settings_blocks`(`blockid`,`label`,`sequence`,`icon`,`type`,`linkto`,`admin_access`) values
			(1,'LBL_USER_MANAGEMENT',2,'adminIcon-permissions',0,NULL,NULL),
			(2,'LBL_STUDIO',3,'adminIcon-standard-modules',0,NULL,NULL),
			(3,'LBL_COMPANY',14,'adminIcon-company-information',0,NULL,NULL),
			(4,'LBL_SYSTEM_TOOLS',12,'adminIcon-system-tools',0,NULL,NULL),
			(5,'LBL_INTEGRATION',9,'adminIcon-integration',0,NULL,NULL),
			(6,'LBL_PROCESSES',13,'adminIcon-processes',0,NULL,NULL),
			(7,'LBL_SECURITY_MANAGEMENT',7,'adminIcon-security',0,NULL,NULL),
			(8,'LBL_MAIL_TOOLS',11,'adminIcon-mail-tools',0,NULL,NULL),
			(9,'LBL_About_YetiForce',16,'adminIcon-about-yetiforce',0,NULL,NULL),
			(11,'LBL_ADVANCED_MODULES',4,'adminIcon-advenced-modules',0,NULL,NULL),
			(12,'LBL_CALENDAR_LABELS_COLORS',5,'adminIcon-calendar-labels-colors',0,NULL,NULL),
			(13,'LBL_SEARCH_AND_FILTERS',6,'adminIcon-search-and-filtres',0,NULL,NULL),
			(14,'LBL_LOGS',8,'adminIcon-logs',0,NULL,NULL),
			(15,'LBL_AUTOMATION',10,'adminIcon-automation',0,NULL,NULL),
			(16,'LBL_MENU_DASHBOARD',1,'yfi yfi-adminIcon-menu-summary',1,'index.php?module=Vtiger&parent=Settings&view=Index',NULL),
			(18,'LBL_HELP',15,'fas fa-life-ring',0,NULL,NULL),
			(19,'LBL_MARKETPLACE_YETIFORCE',0,'yfi yfi-shop',1,'index.php?module=YetiForce&parent=Settings&view=Shop',NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_settings_field`(`fieldid`,`blockid`,`name`,`iconpath`,`description`,`linkto`,`sequence`,`active`,`pinned`,`premium`,`admin_access`) values
			(1,1,'LBL_USERS','yfi yfi-users-2','LBL_USER_DESCRIPTION','index.php?module=Users&parent=Settings&view=List',1,0,0,0,NULL),
			(2,1,'LBL_ROLES','adminIcon-roles','LBL_ROLE_DESCRIPTION','index.php?module=Roles&parent=Settings&view=Index',2,0,1,0,NULL),
			(3,1,'LBL_PROFILES','adminIcon-profiles','LBL_PROFILE_DESCRIPTION','index.php?module=Profiles&parent=Settings&view=List',3,0,0,0,NULL),
			(4,1,'USERGROUPLIST','adminIcon-groups','LBL_GROUP_DESCRIPTION','index.php?module=Groups&parent=Settings&view=ListTable',4,0,1,0,NULL),
			(5,1,'LBL_SHARING_ACCESS','adminIcon-module-access','LBL_SHARING_ACCESS_DESCRIPTION','index.php?module=SharingAccess&parent=Settings&view=Index',5,0,0,0,NULL),
			(7,14,'LBL_LOGIN_HISTORY_DETAILS','adminIcon-users-login','LBL_LOGIN_HISTORY_DESCRIPTION','index.php?module=LoginHistory&parent=Settings&view=List',3,0,0,0,NULL),
			(8,2,'VTLIB_LBL_MODULE_MANAGER','yfi yfi-modules-2','VTLIB_LBL_MODULE_MANAGER_DESCRIPTION','index.php?module=ModuleManager&parent=Settings&view=List',1,0,0,0,NULL),
			(9,2,'LBL_PICKLIST_EDITOR','adminIcon-fields-picklists','LBL_PICKLIST_DESCRIPTION','index.php?parent=Settings&module=Picklist&view=Index',9,0,1,0,NULL),
			(10,2,'LBL_PICKLIST_DEPENDENCY_SETUP','adminIcon-fields-picklists-relations','LBL_PICKLIST_DEPENDENCY_DESCRIPTION','index.php?parent=Settings&module=PickListDependency&view=List',10,0,0,0,NULL),
			(11,1,'LBL_ADVANCED_PERMISSION','yfi yfi-adminIcon-advanced-permission',NULL,'index.php?module=AdvancedPermission&parent=Settings&view=List',10,0,0,0,NULL),
			(14,3,'LBL_COMPANY_DETAILS','adminIcon-company-detlis','LBL_COMPANY_DESCRIPTION','index.php?parent=Settings&module=Companies&view=Edit',2,0,0,0,NULL),
			(15,5,'LBL_PBX','yfi yfi-pbx','LBL_PBX_DESCRIPTION','index.php?module=PBX&parent=Settings&view=List',3,0,0,0,NULL),
			(16,4,'LBL_CURRENCY_SETTINGS','adminIcon-currencies','LBL_CURRENCY_DESCRIPTION','index.php?parent=Settings&module=Currency&view=List',5,0,1,0,NULL),
			(17,4,'LBL_SWITCH_USERS','adminIcon-users','LBL_SWITCH_USERS_DESCRIPTION','index.php?module=Users&view=SwitchUsers&parent=Settings',10,0,0,0,NULL),
			(22,2,'LBL_CUSTOMIZE_RECORD_NUMBERING','adminIcon-recording-control','LBL_CUSTOMIZE_MODENT_NUMBER_DESCRIPTION','index.php?module=RecordNumbering&parent=Settings&view=CustomRecordNumbering',6,0,0,0,NULL),
			(24,15,'LBL_LIST_WORKFLOWS','yfi-workflows-2','LBL_LIST_WORKFLOWS_DESCRIPTION','index.php?module=Workflows&parent=Settings&view=List',1,0,0,0,NULL),
			(25,4,'LBL_CONFIG_EDITOR','adminIcon-system-tools','LBL_CONFIG_EDITOR_DESCRIPTION','index.php?module=ConfigEditor&parent=Settings&view=Detail',7,0,0,0,NULL),
			(26,15,'Scheduler','adminIcon-cron','LBL_SCHEDULER_DESCRIPTION','index.php?module=CronTasks&parent=Settings&view=List',3,0,1,0,NULL),
			(33,2,'LBL_EDIT_FIELDS','adminIcon-modules-fields','LBL_LAYOUT_EDITOR_DESCRIPTION','index.php?module=LayoutEditor&parent=Settings&view=Index',2,0,1,0,NULL),
			(35,4,'LBL_PDF','adminIcon-modules-pdf-templates','LBL_PDF_DESCRIPTION','index.php?module=PDF&parent=Settings&view=List',9,0,1,0,NULL),
			(38,7,'LBL_PASSWORD_CONF','adminIcon-passwords-configuration','LBL_PASSWORD_DESCRIPTION','index.php?module=Password&parent=Settings&view=Index',1,0,0,0,NULL),
			(40,2,'LBL_MENU_BUILDER','adminIcon-menu-configuration','LBL_MENU_BUILDER_DESCRIPTION','index.php?module=Menu&view=Index&parent=Settings',14,0,1,0,NULL),
			(41,2,'LBL_ARRANGE_RELATED_TABS','adminIcon-modules-relations','LBL_ARRANGE_RELATED_TABS','index.php?module=LayoutEditor&parent=Settings&view=Index&mode=showRelatedListLayout',3,0,1,0,NULL),
			(45,14,'Mail Logs','adminIcon-mail-download-history','LBL_MAIL_LOGS_DESCRIPTION','index.php?module=OSSMailScanner&parent=Settings&view=Logs',4,0,0,0,NULL),
			(49,9,'License','adminIcon-license','LBL_LICENSE_DESCRIPTION','index.php?module=Dependencies&view=Credits&parent=Settings',5,0,0,0,NULL),
			(53,4,'LangManagement','adminIcon-languages-and-translations','LBL_LANGMANAGEMENT_DESCRIPTION','index.php?module=LangManagement&parent=Settings&view=Index',2,0,1,0,NULL),
			(54,1,'GlobalPermission','adminIcon-special-access','LBL_GLOBALPERMISSION_DESCRIPTION','index.php?module=GlobalPermission&parent=Settings&view=Index',7,0,0,0,NULL),
			(56,13,'Search Setup','adminIcon-search-configuration','LBL_SEARCH_SETUP_DESCRIPTION','index.php?module=Search&parent=Settings&view=Index',1,0,1,0,NULL),
			(57,13,'CustomView','adminIcon-filters-configuration','LBL_CUSTOMVIEW_DESCRIPTION','index.php?module=CustomView&parent=Settings&view=Index',2,0,0,0,NULL),
			(58,2,'Widgets','adminIcon-modules-widgets','LBL_WIDGETS_DESCRIPTION','index.php?module=Widgets&parent=Settings&view=Index',4,0,1,0,NULL),
			(60,2,'LBL_QUICK_CREATE_EDITOR','adminIcon-fields-quick-create','LBL_QUICK_CREATE_EDITOR_DESCRIPTION','index.php?module=QuickCreateEditor&parent=Settings&view=Index',8,0,0,0,NULL),
			(61,5,'LBL_API_ADDRESS','yfi yfi-address-serch','LBL_API_ADDRESS_DESCRIPTION','index.php?module=ApiAddress&parent=Settings&view=Configuration',5,0,0,0,NULL),
			(62,7,'LBL_BRUTEFORCE','adminIcon-brute-force','LBL_BRUTEFORCE_DESCRIPTION','index.php?module=BruteForce&parent=Settings&view=Index',2,0,0,0,NULL),
			(63,14,'LBL_UPDATES_HISTORY','adminIcon-server-updates','LBL_UPDATES_HISTORY_DESCRIPTION','index.php?parent=Settings&module=Updates&view=Index',2,0,0,0,NULL),
			(65,14,'LBL_CONFREPORT','adminIcon-server-configuration','LBL_CONFREPORT_DESCRIPTION','index.php?parent=Settings&module=ConfReport&view=Index',1,0,0,0,NULL),
			(67,2,'LBL_WIDGETS_MANAGEMENT','adminIcon-widgets-configuration','LBL_WIDGETS_MANAGEMENT_DESCRIPTION','index.php?module=WidgetsManagement&parent=Settings&view=Configuration',15,0,0,0,NULL),
			(70,2,'LBL_TREES_MANAGER','adminIcon-field-folders','LBL_TREES_MANAGER_DESCRIPTION','index.php?module=TreesManager&parent=Settings&view=List',11,0,0,0,NULL),
			(71,2,'LBL_MODTRACKER_SETTINGS','adminIcon-modules-track-chanegs','LBL_MODTRACKER_SETTINGS_DESCRIPTION','index.php?module=ModTracker&parent=Settings&view=List',5,0,0,0,NULL),
			(73,12,'LBL_PUBLIC_HOLIDAY','adminIcon-calendar-holidys','LBL_PUBLIC_HOLIDAY_DESCRIPTION','index.php?module=PublicHoliday&view=Configuration&parent=Settings',3,0,0,0,NULL),
			(74,12,'LBL_CALENDAR_CONFIG','adminIcon-calendar-configuration','LBL_CALENDAR_CONFIG_DESCRIPTION','index.php?parent=Settings&module=Calendar&view=UserColors',2,0,0,0,NULL),
			(75,6,'LBL_SALES_PROCESSES','adminIcon-sales','LBL_SALES_PROCESSES_DESCRIPTION','index.php?module=SalesProcesses&view=Index&parent=Settings',2,0,0,0,NULL),
			(77,5,'LBL_DAV_KEYS','yfi yfi-dav','LBL_DAV_KEYS_DESCRIPTION','index.php?parent=Settings&module=Dav&view=Keys',7,0,0,1,NULL),
			(79,8,'LBL_MAIL_GENERAL_CONFIGURATION','adminIcon-mail-smtp-server','LBL_MAIL_GENERAL_CONFIGURATION_DESCRIPTION','index.php?parent=Settings&module=Mail&view=Config',5,0,0,0,NULL),
			(80,6,'LBL_SUPPORT_PROCESSES','adminIcon-support ','LBL_SUPPORT_PROCESSES_DESCRIPTION','index.php?module=SupportProcesses&view=Index&parent=Settings',6,0,0,0,NULL),
			(81,12,'LBL_COLORS','adminIcon-colors','LBL_COLORS_DESCRIPTION','index.php?module=Colors&parent=Settings&view=Index',5,0,0,0,NULL),
			(82,6,'LBL_REALIZATION_PROCESSES','adminIcon-realization','LBL_REALIZATION_PROCESSES_DESCRIPTION','index.php?module=RealizationProcesses&view=Index&parent=Settings',3,0,0,0,NULL),
			(83,6,'LBL_MARKETING_PROCESSES','adminIcon-marketing','LBL_MARKETING_PROCESSES_DESCRIPTION','index.php?module=MarketingProcesses&view=Index&parent=Settings',1,0,0,0,NULL),
			(84,6,'LBL_FINANCIAL_PROCESSES','adminIcon-finances','LBL_FINANCIAL_PROCESSES_DESCRIPTION','index.php?module=FinancialProcesses&view=Index&parent=Settings',5,0,0,0,NULL),
			(85,5,'LBL_AUTHENTICATION','yfi-ldap','LBL_AUTHORIZATION_DESCRIPTION','index.php?module=UserAuth&parent=Settings&view=List',1,0,0,0,NULL),
			(86,6,'LBL_TIMECONTROL_PROCESSES','yfi yfi-adminIcon-time-control-processes','LBL_TIMECONTROL_PROCESSES_DESCRIPTION','index.php?module=TimeControlProcesses&parent=Settings&view=Index',8,0,0,0,NULL),
			(87,2,'LBL_CUSTOM_FIELD_MAPPING','adminIcon-filed-mapping','LBL_CUSTOM_FIELD_MAPPING_DESCRIPTION','index.php?parent=Settings&module=Leads&view=MappingDetail',13,0,0,0,NULL),
			(88,5,'LBL_CURRENCY_UPDATE','adminIcon-currencies','LBL_CURRENCY_UPDATE_DESCRIPTION','index.php?module=CurrencyUpdate&view=Index&parent=Settings',2,0,0,0,NULL),
			(89,11,'LBL_CREDITLIMITS','adminIcon-credit-limit-base_2','LBL_CREDITLIMITS_DESCRIPTION','index.php?module=Inventory&parent=Settings&view=CreditLimits',5,0,0,0,NULL),
			(90,11,'LBL_TAXES','adminIcon-taxes-rates','LBL_TAXES_DESCRIPTION','index.php?module=Inventory&parent=Settings&view=Taxes',1,0,0,0,NULL),
			(91,11,'LBL_DISCOUNTS','adminIcon-discount-base','LBL_DISCOUNTS_DESCRIPTION','index.php?module=Inventory&parent=Settings&view=Discounts',3,0,0,0,NULL),
			(92,11,'LBL_TAXCONFIGURATION','adminIcon-taxes-caonfiguration','LBL_TAXCONFIGURATION_DESCRIPTION','index.php?module=Inventory&parent=Settings&view=TaxConfiguration',4,0,0,0,NULL),
			(93,11,'LBL_DISCOUNTCONFIGURATION','adminIcon-discount-configuration','LBL_DISCOUNTCONFIGURATION_DESCRIPTION','index.php?module=Inventory&parent=Settings&view=DiscountConfiguration',2,0,0,0,NULL),
			(95,2,'LBL_MAPPEDFIELDS','adminIcon-mapped-fields','LBL_MAPPEDFIELDS_DESCRIPTION','index.php?module=MappedFields&parent=Settings&view=List',16,0,0,0,NULL),
			(96,1,'LBL_LOCKS','adminIcon-locks','LBL_LOCKS_DESCRIPTION','index.php?module=Users&view=Locks&parent=Settings',8,0,0,0,NULL),
			(98,4,'LBL_NOTIFICATIONS_CONFIGURATION','adminIcon-NotificationConfiguration','LBL_TYPE_NOTIFICATIONS_DESCRIPTION','index.php?module=Notifications&view=Configuration&parent=Settings',11,0,0,0,NULL),
			(100,5,'LBL_WEBSERVICE_APPS','adminIcon-webservice-apps',NULL,'index.php?module=WebserviceApps&view=Index&parent=Settings',8,0,0,0,NULL),
			(101,1,'LBL_OWNER_ALLOCATION','adminIcon-owner','LBL_OWNER_ALLOCATION_DESCRIPTION','index.php?module=RecordAllocation&view=Index&parent=Settings&mode=owner',9,0,0,0,NULL),
			(102,1,'LBL_MULTIOWNER_ALLOCATION','adminIcon-shared-owner','LBL_MULTIOWNER_ALLOCATION_DESCRIPTION','index.php?module=RecordAllocation&view=Index&parent=Settings&mode=sharedOwner',10,0,0,0,NULL),
			(103,1,'LBL_AUTOMATIC_ASSIGNMENT','adminIcon-automatic-assignment','LBL_AUTOMATICASSIGNMENT_DESCRIPTION','index.php?module=AutomaticAssignment&view=List&parent=Settings',11,0,0,1,NULL),
			(104,8,'LBL_EMAILS_TO_SEND','adminIcon-mail-queue','LBL_EMAILS_TO_SEND_DESCRIPTION','index.php?module=Mail&parent=Settings&view=List',7,0,0,0,NULL),
			(105,8,'LBL_MAIL_SMTP','adminIcon-mail-configuration','LBL_MAILSMTP_TO_SEND_DESCRIPTION','index.php?module=MailSmtp&parent=Settings&view=List',1,0,1,0,NULL),
			(106,5,'LBL_WEBSERVICE_USERS','adminIcon-webservice-users','LBL_WEBSERVICE_USERS_DESCRIPTION','index.php?module=WebserviceUsers&view=List&parent=Settings',11,0,0,0,NULL),
			(107,5,'LBL_SMSNOTIFIER','yfi yfi-adminIcon-vendor-sms','LBL_SMSNOTIFIER_DESCRIPTION','index.php?module=SMSNotifier&parent=Settings&view=List',12,0,0,0,NULL),
			(108,4,'LBL_COUNTRY_SETTINGS','yfi yfi-adminIcon-countries','LBL_COUNTRY_DESCRIPTION','index.php?module=Countries&parent=Settings&view=Index',12,0,0,0,NULL),
			(109,7,'LBL_ENCRYPTION','fas fa-key',NULL,'index.php?module=Password&parent=Settings&view=Encryption',4,0,0,0,NULL),
			(111,7,'LBL_2FA_CONF','adminIcon-passwords-configuration','LBL_2FA_DESCRIPTION','index.php?module=TwoFactorAuthentication&parent=Settings&view=Index',5,0,0,0,NULL),
			(113,9,'LBL_YETIFORCE_WATCHDOG_HEADER','fas fa-thermometer-half','LBL_YETIFORCE_WATCHDOG_DESC','index.php?module=Watchdog&parent=Settings&view=Index',6,0,0,0,NULL),
			(114,7,'LBL_LOGS','yfi yfi-security-incidents','LBL_LOGS_DESC','index.php?parent=Settings&module=Log&view=LogsOwasp',6,0,0,0,NULL),
			(116,4,'LBL_BACKUP_MANAGER','yfi yfi-adminIcon-backup','LBL_BACKUP_MANAGER_DESCRIPTION','index.php?module=Backup&parent=Settings&view=Index',14,0,0,0,NULL),
			(117,3,'LBL_BUSINESS_HOURS','fas fa-business-time','LBL_BUSINESS_HOURS_DESCRIPTION','index.php?module=BusinessHours&parent=Settings&view=List',4,0,0,0,NULL),
			(119,6,'LBL_SLA_POLICY','yfi yfi-adminIcon-sla-policy','LBL_SLA_POLICY','index.php?module=SlaPolicy&parent=Settings&view=List',7,0,0,0,NULL),
			(121,14,'LBL_SYSTEM_WARNINGS','yfi yfi-system-warnings-2',NULL,'index.php?parent=Settings&module=Logs&view=SystemWarnings',5,0,0,0,NULL),
			(123,5,'LBL_MAP','yfi yfi-map','LBL_MAP_DESCRIPTION','index.php?parent=Settings&module=Map&view=Config',6,0,0,0,NULL),
			(124,5,'LBL_MAGENTO','fab fa-magento','LBL_MAGENTO_DESCRIPTION','index.php?parent=Settings&module=Magento&view=List',13,1,0,1,NULL),
			(125,4,'LBL_EVENT_HANDLER','yfi yfi-event-handlers','LBL_EVENT_HANDLER_DESC','index.php?parent=Settings&module=EventHandler&view=Index',13,0,0,0,NULL),
			(126,5,'LBL_MEETING_SERVICES','mdi mdi-server-network','LBL_MEETING_SERVICES_DESCRIPTION','index.php?parent=Settings&module=MeetingServices&view=List',15,0,0,0,NULL),
			(127,4,'LBL_CONFLICT_OF_INTEREST','yfi-conflict-interests','LBL_CONFLICT_OF_INTEREST_DESCRIPTION','index.php?parent=Settings&module=InterestsConflict&view=Index',15,0,0,0,NULL),
			(128,1,'LBL_ADMIN_ACCESS','yfi yfi-admin-access','LBL_ADMIN_ACCESS_DESCRIPTION','index.php?parent=Settings&module=AdminAccess&view=Index',12,0,0,0,NULL),
			(130,2,'LBL_FIELDS_DEPENDENCY','yfi yfi-dependent-fields','LBL_FIELDS_DEPENDENCY_DESCRIPTION','index.php?parent=Settings&module=FieldsDependency&view=List',7,0,0,0,NULL),
			(131,5,'LBL_MAIL_INTEGRATION','yfi yfi-mail-integrator-panel','LBL_MAIL_INTEGRATION_DESCRIPTION','index.php?parent=Settings&module=MailIntegration&view=Index',16,0,0,1,NULL),
			(133,14,'LBL_LOGS_VIEWER','yfi yfi-view-logs','LBL_LOGS_VIEWER_DESCRIPTION','index.php?parent=Settings&module=Log&view=LogsViewer',6,0,0,0,NULL),
			(134,7,'LBL_CONFIG_PROXY','yfi yfi-server-configuration','LBL_CONFIG_PROXY_DESCRIPTION','index.php?parent=Settings&module=Proxy&view=Index',8,0,0,0,NULL),
			(135,2,'LBL_KANBAN','yfi yfi-kanban','LBL_KANBAN_DESCRIPTION','index.php?parent=Settings&module=Kanban&view=Index',17,0,0,1,NULL),
			(136,5,'LBL_WAPRO_ERP','fab fa-connectdevelop','LBL_WAPRO_ERP_DESCRIPTION','index.php?parent=Settings&module=Wapro&view=List',17,1,0,1,NULL),
			(137,5,'LBL_RECORD_COLLECTOR','yfi-record-collectors','LBL_RECORD_COLLECTOR_DESCRIPTION','index.php?parent=Settings&module=RecordCollector&view=List',18,0,0,0,NULL),
			(138,8,'LBL_MAIL_SERVERS','fas fa-server','LBL_MAIL_SERVERS_DESCRIPTION','index.php?module=MailServers&parent=Settings&view=List',2,0,0,0,NULL),
			(139,5,'LBL_WOOCOMMERCE','fa-solid fa-cash-register','LBL_WOOCOMMERCE_DESCRIPTION','index.php?parent=Settings&module=WooCommerce&view=List',19,0,0,1,NULL),
			(140,8,'LBL_MAIL_SIGNATURE','fa-solid fa-signature','LBL_MAIL_SIGNATURE_DESCRIPTION','index.php?parent=Settings&module=MailSignature&view=List',6,0,0,0,NULL),
			(141,5,'LBL_COMARCH','fa-brands fa-connectdevelop','LBL_COMARCH_DESCRIPTION','index.php?parent=Settings&module=Comarch&view=List',20,0,0,1,NULL),
			(142,8,'LBL_AUTOLOGIN','adminIcon-mail-auto-login','LBL_AUTOLOGIN_DESCRIPTION','index.php?parent=Settings&module=Mail&view=Autologin',4,0,0,0,NULL),
			(143,8,'Mail Scanner','adminIcon-mail-scanner','LBL_MAIL_SCANNER_DESCRIPTION','index.php?module=OSSMailScanner&parent=Settings&view=List',3,0,0,0,NULL);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_smsnotifier_status`(`smsnotifier_statusid`,`smsnotifier_status`,`presence`,`sortorderid`,`picklist_valueid`) values
			(1,'PLL_UNDEFINED',0,1,957),
			(2,'PLL_DELIVERED',0,2,958),
			(3,'PLL_FAILED',0,3,959),
			(4,'PLL_SENT',0,4,960),
			(5,'PLL_QUEUE',0,5,961),
			(6,'PLL_REPLY',0,6,962);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_squoteenquiries_status`(`squoteenquiries_statusid`,`squoteenquiries_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,860),
			(2,'PLL_IN_REALIZATION',2,1,861),
			(3,'PLL_FOR_VERIFICATION',3,1,862),
			(4,'PLL_CANCELLED',4,0,863),
			(5,'PLL_COMPLETED',5,0,864);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_squotes_status`(`squotes_statusid`,`squotes_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,865),
			(2,'PLL_IN_REALIZATION',2,1,866),
			(3,'PLL_FOR_VERIFICATION',3,1,867),
			(4,'PLL_AWAITING_DECISION',4,1,868),
			(5,'PLL_NEGOTIATIONS',5,1,869),
			(6,'PLL_CANCELLED',6,0,870),
			(7,'PLL_ACCEPTED',7,0,871);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_srecurringorders_status`(`srecurringorders_statusid`,`srecurringorders_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,872),
			(2,'PLL_REQUIRES_TO_BE_COMPLEMENTED',2,1,873),
			(3,'PLL_REQUIRES_CONSULTATION',3,1,874),
			(4,'PLL_WAITING_FOR_SHIPPING',4,1,875),
			(5,'PLL_WAITING_FOR_SIGNATURE',5,1,876),
			(6,'PLL_WAITING_FOR_REALIZATION',6,1,877),
			(7,'PLL_AUTOMATIC_GENERATION',7,0,878),
			(8,'PLL_UNREALIZED',8,0,879),
			(9,'PLL_REALIZED',9,0,880);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_srequirementscards_status`(`srequirementscards_statusid`,`srequirementscards_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_DRAFT',1,1,881),
			(2,'PLL_IN_REALIZATION',2,1,882),
			(3,'PLL_FOR_VERIFICATION',3,1,883),
			(4,'PLL_CANCELLED',4,0,884),
			(5,'PLL_COMPLETED',5,0,885);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ssalesprocesses_source`(`ssalesprocesses_sourceid`,`ssalesprocesses_source`,`sortorderid`,`presence`) values
			(1,'PLL_WEBSITE',1,1),
			(2,'PLL_PHONE',2,1),
			(3,'PLL_MAIL_CAMPAIGN',3,1),
			(4,'PLL_CONFERENCE',4,1),
			(5,'PLL_RECOMMENDATION',5,1),
			(6,'PLL_MEETING',6,1),
			(7,'PLL_ADVERTISING',7,1),
			(8,'PLL_COMMUNITY',8,1),
			(9,'PLL_OTHER',9,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ssalesprocesses_status`(`ssalesprocesses_statusid`,`ssalesprocesses_status`,`sortorderid`,`presence`,`picklist_valueid`,`record_state`) values
			(1,'PLL_DRAFT',1,1,886,0),
			(2,'PLL_FOR_REALIZATION',2,1,887,0),
			(3,'PLL_QUOTE_ENQUIRY',3,1,888,0),
			(4,'PLL_REQUIREMENTS_CARD',4,1,889,0),
			(5,'PLL_CALCULATION',5,1,890,0),
			(6,'PLL_QUOTE',6,1,891,0),
			(7,'PLL_NEGOTIATIONS',7,1,892,0),
			(8,'PLL_AWAITING_DECISION',8,1,893,0),
			(9,'PLL_AWAITING_SIGNATURES',9,1,894,0),
			(10,'PLL_ORDER',10,1,895,0),
			(11,'PLL_REALIZATION',11,1,896,0),
			(12,'PLL_AWAITING_PAYMENT',12,1,897,0),
			(13,'PLL_INVOICING',13,1,898,0),
			(14,'PLL_SALE_COMPLETED',14,0,899,2),
			(15,'PLL_SALE_FAILED',15,0,900,2),
			(16,'PLL_SALE_CANCELLED',16,0,901,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ssalesprocesses_type`(`ssalesprocesses_typeid`,`ssalesprocesses_type`,`sortorderid`,`presence`) values
			(1,'PLL_NEW_SALES',1,1),
			(2,'PLL_RENEWAL',2,1),
			(3,'PLL_AFTERSALES',3,1),
			(4,'PLL_TENDER',4,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ssingleorders_source`(`ssingleorders_sourceid`,`ssingleorders_source`,`sortorderid`,`presence`) values
			(1,'PLL_MANUAL',1,0),
			(2,'PLL_POS',2,0),
			(3,'PLL_SHOP',3,0),
			(4,'PLL_PORTAL',4,1),
			(5,'PLL_MAGENTO',5,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ssingleorders_status`(`ssingleorders_statusid`,`ssingleorders_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_NEW',1,1,902),
			(2,'PLL_PAYMENT_REVIEW',2,1,903),
			(3,'PLL_ON_HOLD',3,1,904),
			(4,'PLL_PROCESSING',4,1,905),
			(5,'PLL_COMPLETE',5,1,906),
			(6,'PLL_CLOSED',6,0,907),
			(7,'PLL_CANCELLED',7,0,949);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ssservicesstatus`(`ssservicesstatusid`,`ssservicesstatus`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_DRAFT',1,416,1),
			(2,'PLL_WAITING_FOR_VERIFICATION',1,417,2),
			(3,'PLL_WAITING_FOR_ACCEPTANCE',1,418,3),
			(4,'PLL_ACCEPTED',0,689,4),
			(5,'PLL_CANCELLED',0,690,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_start_hour`(`start_hourid`,`start_hour`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'00:00',1,297,1),
			(2,'01:00',1,298,2),
			(3,'02:00',1,299,3),
			(4,'03:00',1,300,4),
			(5,'04:00',1,301,5),
			(6,'05:00',1,302,6),
			(7,'06:00',1,303,7),
			(8,'07:00',1,304,8),
			(9,'08:00',1,305,9),
			(10,'09:00',1,306,10),
			(11,'10:00',1,307,11),
			(12,'11:00',1,308,12),
			(13,'12:00',1,309,13),
			(14,'13:00',1,310,14),
			(15,'14:00',1,311,15),
			(16,'15:00',1,312,16),
			(17,'16:00',1,313,17),
			(18,'17:00',1,314,18),
			(19,'18:00',1,315,19),
			(20,'19:00',1,316,20),
			(21,'20:00',1,317,21),
			(22,'21:00',1,318,22),
			(23,'22:00',1,319,23),
			(24,'23:00',1,320,24);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_state`(`stateid`,`state`,`sortorderid`,`presence`) values
			(1,'PLL_OPAQUE',1,1),
			(2,'PLL_TRANSPARENT',2,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_status`(`statusid`,`status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Active',0,1,1),
			(2,'Inactive',1,1,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_status_rel`(`status_relid`,`status_rel`,`presence`,`sortorderid`) values
			(1,'PLL_REGISTERED',1,1),
			(2,'PLL_APPROVED',1,2),
			(3,'PLL_PRESENT',1,3),
			(4,'PLL_ABSENT',1,4);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_storage_status`(`storage_statusid`,`storage_status`,`sortorderid`,`presence`,`picklist_valueid`) values
			(1,'PLL_ACTIVE',1,1,908),
			(2,'PLL_INACTIVE',2,1,909);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_storage_type`(`storage_typeid`,`storage_type`,`sortorderid`,`presence`) values
			(1,'PLL_INTERNAL',1,1),
			(2,'PLL_EXTERNAL',2,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_subindustry`(`subindustryid`,`subindustry`,`sortorderid`,`presence`) values
			(1,'Ministry',1,1),
			(2,'Chancellery',2,1),
			(3,'Voivodeship Office',3,1),
			(4,'Marshal Office',4,1),
			(5,'District',5,1),
			(6,'City/Township/District',6,1),
			(7,'Social Welfare Centre',7,1),
			(8,'Water and Sewerage Company',8,1),
			(9,'Voivodeship Job Centre',9,1),
			(10,'District Job Center',10,1),
			(11,'Court of justice',11,1),
			(12,'Attorney General\'s Office',12,1),
			(13,'Other',44,1),
			(14,'Developers',14,1),
			(15,'Real Estate',15,1),
			(16,'Primary Schools',16,1),
			(17,'High Schools',17,1),
			(18,'Banking',18,1),
			(19,'Capital Market',19,1),
			(20,'Financial Services',20,1),
			(21,'Investments',21,1),
			(22,'Insurance',22,1),
			(23,'Retail',23,1),
			(24,'Wholesale',24,1),
			(25,'Resale',25,1),
			(26,'Automotive',26,1),
			(27,'Plastics',27,1),
			(28,'Chamical',28,1),
			(29,'Raw material',29,1),
			(30,'Fuel',30,1),
			(31,'Wood and paper',31,1),
			(32,'Electromechanical',32,1),
			(33,'Pharmaceutical',33,1),
			(34,'Building Materials',34,1),
			(35,'Metal',35,1),
			(36,'Light',36,1),
			(37,'Food industry',37,1),
			(38,'Recycling',38,1),
			(39,'Army',39,1),
			(40,'Police',40,1),
			(41,'Information Technology',41,1),
			(42,'Telecommunication',42,1),
			(43,'Media',43,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_subunit`(`subunitid`,`subunit`,`sortorderid`,`presence`) values
			(1,'50g',1,1),
			(2,'100g',2,1),
			(3,'300g',3,1),
			(4,'500g',4,1),
			(5,'100ml',5,1),
			(6,'250ml',6,1),
			(7,'330ml',7,1),
			(8,'500ml',8,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_support_processes`(`id`,`ticket_status_indicate_closing`) values
			(1,'');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_svendorenquiries_status`(`svendorenquiries_statusid`,`svendorenquiries_status`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'PLL_DRAFT',1,773,1),
			(2,'PLL_IN_REALIZATION',1,774,2),
			(3,'PLL_FOR_VERIFICATION',1,775,3),
			(4,'PLL_CANCELLED',1,776,4),
			(5,'PLL_COMPLETED',1,777,5);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_sync_caldav`(`sync_caldavid`,`sync_caldav`,`presence`,`sortorderid`) values
			(1,'PLL_OWNER',1,1),
			(2,'PLL_OWNER_PERSON',1,2),
			(3,'PLL_OWNER_PERSON_GROUP',1,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_sync_carddav`(`sync_carddavid`,`sync_carddav`,`presence`,`sortorderid`) values
			(1,'PLL_OWNER',1,1),
			(2,'PLL_OWNER_PERSON',1,2),
			(3,'PLL_OWNER_PERSON_GROUP',1,3),
			(4,'PLL_BASED_CREDENTIALS',1,4);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_tab`(`tabid`,`name`,`presence`,`tabsequence`,`tablabel`,`customized`,`ownedby`,`isentitytype`,`version`,`color`,`coloractive`,`type`,`premium`) values
			(1,'Dashboard',0,12,'Dashboards',0,1,0,NULL,NULL,0,0,0),
			(3,'Home',0,1,'Home',0,1,0,NULL,NULL,0,0,0),
			(4,'Contacts',0,6,'Contacts',0,0,1,NULL,NULL,0,0,0),
			(6,'Accounts',0,5,'Accounts',0,0,1,NULL,NULL,0,0,0),
			(7,'Leads',0,4,'Leads',0,0,1,NULL,NULL,0,0,0),
			(8,'Documents',0,9,'Documents',0,0,1,NULL,NULL,0,0,0),
			(9,'Calendar',0,3,'Calendar',0,0,1,NULL,NULL,0,0,0),
			(13,'HelpDesk',0,11,'HelpDesk',0,0,1,NULL,NULL,0,0,0),
			(14,'Products',0,8,'Products',0,0,1,NULL,NULL,0,0,0),
			(15,'Faq',0,-1,'Faq',0,1,1,NULL,NULL,0,0,0),
			(18,'Vendors',1,-1,'Vendors',0,0,1,NULL,NULL,0,0,0),
			(19,'PriceBooks',0,-1,'PriceBooks',0,1,1,NULL,NULL,0,0,0),
			(24,'Rss',1,-1,'Rss',0,1,0,NULL,NULL,0,0,0),
			(26,'Campaigns',0,-1,'Campaigns',0,0,1,NULL,NULL,0,0,0),
			(29,'Users',0,-1,'Users',0,1,0,NULL,NULL,0,0,0),
			(30,'Import',0,-1,'Import',1,0,0,'1.7',NULL,0,0,0),
			(32,'ModTracker',0,-1,'ModTracker',0,0,0,'1.2',NULL,0,0,0),
			(34,'ServiceContracts',0,-1,'Service Contracts',0,0,1,'2.4',NULL,0,0,0),
			(35,'Services',0,-1,'Services',0,0,1,'2.6',NULL,0,0,0),
			(37,'Assets',1,-1,'Assets',0,0,1,'2.0',NULL,0,0,0),
			(40,'ModComments',0,-1,'Comments',0,0,1,'2.1',NULL,0,0,0),
			(41,'ProjectMilestone',0,-1,'ProjectMilestone',0,0,1,'3.0',NULL,0,0,0),
			(42,'ProjectTask',0,-1,'ProjectTask',0,0,1,'3.1',NULL,0,0,0),
			(43,'Project',0,-1,'Project',0,0,1,'3.3',NULL,0,0,0),
			(45,'SMSNotifier',0,-1,'SMSNotifier',0,0,1,'1.9',NULL,0,0,0),
			(48,'OSSMail',1,-1,'OSSMail',0,0,0,'1.50',NULL,0,0,0),
			(51,'OSSTimeControl',0,-1,'OSSTimeControl',0,0,1,'1.0.4',NULL,0,0,0),
			(53,'OSSMailScanner',0,-1,'OSSMailScanner',0,0,0,'1.30',NULL,0,0,0),
			(54,'OSSMailView',0,-1,'OSSMailView',0,0,1,'1.36',NULL,0,0,0),
			(57,'OSSOutsourcedServices',1,-1,'OSSOutsourcedServices',0,0,1,'1.0.2',NULL,0,0,0),
			(58,'OSSSoldServices',1,-1,'OSSSoldServices',0,0,1,'1.0.2',NULL,0,0,0),
			(59,'OutsourcedProducts',1,-1,'OutsourcedProducts',0,0,1,'1.0',NULL,0,0,0),
			(61,'OSSEmployees',0,-1,'OSSEmployees',0,0,1,'1.0.1',NULL,0,0,0),
			(73,'ApiAddress',0,-1,'Api Address',0,0,0,'0.1',NULL,0,0,0),
			(74,'CallHistory',0,-1,'CallHistory',0,0,1,'0',NULL,0,0,0),
			(75,'Ideas',1,-1,'Ideas',0,0,1,'0',NULL,0,0,0),
			(78,'HolidaysEntitlement',1,-1,'HolidaysEntitlement',0,0,1,'0',NULL,0,0,0),
			(79,'PaymentsIn',0,-1,'PaymentsIn',0,0,1,'1.0.12',NULL,0,0,0),
			(80,'PaymentsOut',0,-1,'PaymentsOut',0,0,1,'1.0.2',NULL,0,0,0),
			(81,'LettersIn',0,-1,'LettersIn',0,0,1,'1.0.0',NULL,0,0,0),
			(82,'LettersOut',0,-1,'LettersOut',0,0,1,'1.0.0',NULL,0,0,0),
			(83,'Announcements',0,-1,'Announcements',0,0,1,'0',NULL,0,0,0),
			(84,'Reservations',1,-1,'Reservations',0,0,1,'1.0.0',NULL,0,0,0),
			(85,'SQuoteEnquiries',0,-1,'SQuoteEnquiries',0,0,1,'0',NULL,0,0,0),
			(86,'SSalesProcesses',0,-1,'SSalesProcesses',0,0,1,'0',NULL,0,0,0),
			(87,'SRequirementsCards',0,-1,'SRequirementsCards',0,0,1,'0',NULL,0,1,0),
			(88,'SCalculations',0,-1,'SCalculations',0,0,1,'0',NULL,0,1,0),
			(89,'SQuotes',0,-1,'SQuotes',0,0,1,'0',NULL,0,1,0),
			(90,'SSingleOrders',0,-1,'SSingleOrders',0,0,1,'0',NULL,0,1,0),
			(91,'SRecurringOrders',0,-1,'SRecurringOrders',0,0,1,'0',NULL,0,1,0),
			(92,'Partners',1,-1,'Partners',0,0,1,'0',NULL,0,0,0),
			(93,'Competition',1,-1,'Competition',0,0,1,'0',NULL,0,0,0),
			(94,'FBookkeeping',0,-1,'FBookkeeping',0,0,1,'0',NULL,0,0,0),
			(95,'FInvoice',0,-1,'FInvoice',0,0,1,'0',NULL,0,1,0),
			(96,'KnowledgeBase',0,-1,'KnowledgeBase',0,0,1,'0',NULL,0,0,0),
			(97,'IStorages',1,-1,'IStorages',0,0,1,'0',NULL,0,0,0),
			(98,'IGRN',1,-1,'IGRN',0,0,1,'0',NULL,0,1,0),
			(99,'FInvoiceProforma',0,-1,'FInvoiceProforma',0,0,1,'0',NULL,0,1,0),
			(100,'IGDN',1,-1,'IGDN',0,0,1,'0',NULL,0,1,0),
			(101,'IIDN',1,-1,'IIDN',0,0,1,'0',NULL,0,1,0),
			(102,'IGIN',1,-1,'IGIN',0,0,1,'0',NULL,0,1,0),
			(103,'IPreOrder',1,-1,'IPreOrder',0,0,1,'0',NULL,0,1,0),
			(104,'ISTDN',1,-1,'ISTDN',0,0,1,'0',NULL,0,1,0),
			(105,'ISTN',1,-1,'ISTN',0,0,1,'0',NULL,0,0,0),
			(106,'ISTRN',1,-1,'ISTRN',0,0,1,'0',NULL,0,1,0),
			(107,'FCorectingInvoice',0,-1,'FCorectingInvoice',0,0,1,'0',NULL,0,1,0),
			(108,'IGRNC',1,-1,'IGRNC',0,0,1,'0',NULL,0,1,0),
			(109,'IGDNC',1,-1,'IGDNC',0,0,1,'0',NULL,0,1,0),
			(110,'OpenStreetMap',0,-1,'OpenStreetMap',0,0,0,'0',NULL,0,0,0),
			(111,'Notification',0,-1,'Notification',0,0,1,'0',NULL,0,0,0),
			(112,'EmailTemplates',0,13,'EmailTemplates',0,0,1,'0',NULL,0,0,0),
			(113,'CFixedAssets',1,14,'CFixedAssets',0,0,1,'0',NULL,0,0,0),
			(114,'CInternalTickets',0,15,'CInternalTickets',0,0,1,'0',NULL,0,0,0),
			(115,'FInvoiceCost',0,16,'FInvoiceCost',0,0,1,'0',NULL,0,1,0),
			(116,'CMileageLogbook',1,17,'CMileageLogbook',0,0,1,'0',NULL,0,0,0),
			(117,'SVendorEnquiries',1,18,'SVendorEnquiries',0,0,1,'0',NULL,0,1,0),
			(118,'Chat',1,19,'Chat',0,0,0,'0',NULL,0,0,0),
			(119,'MultiCompany',0,20,'MultiCompany',0,0,1,'0',NULL,0,0,0),
			(120,'PermissionInspector',0,21,'PermissionInspector',0,0,0,'0.16',NULL,0,0,0),
			(121,'DataSetRegister',1,22,'DataSetRegister',0,0,1,'0',NULL,0,0,0),
			(122,'ActivityRegister',1,23,'ActivityRegister',0,0,1,'0',NULL,0,0,0),
			(123,'LocationRegister',1,24,'LocationRegister',0,0,1,'0',NULL,0,0,0),
			(124,'IncidentRegister',1,25,'IncidentRegister',0,0,1,'0',NULL,0,0,0),
			(125,'AuditRegister',1,26,'AuditRegister',0,0,1,'0',NULL,0,0,0),
			(126,'RecycleBin',0,27,'RecycleBin',0,0,0,'0',NULL,0,0,0),
			(127,'Approvals',1,28,'Approvals',0,0,1,'0',NULL,0,0,0),
			(128,'ApprovalsRegister',1,29,'ApprovalsRegister',0,0,1,'0',NULL,0,0,0),
			(129,'MailIntegration',0,30,'MailIntegration',0,0,0,'0',NULL,0,0,1),
			(130,'Locations',0,31,'Locations',0,0,1,'0',NULL,0,0,0),
			(131,'Occurrences',0,32,'Occurrences',0,0,1,'0',NULL,0,0,0),
			(132,'ProductCategory',1,33,'ProductCategory',0,0,1,'0',NULL,0,0,0),
			(133,'BankAccounts',0,34,'BankAccounts',0,0,1,'0',NULL,0,0,0),
			(134,'Queue',0,35,'Queue',0,0,1,'0',NULL,0,0,0),
			(135,'Passwords',1,36,'Passwords',0,0,1,'0',NULL,0,0,0),
			(136,'SMSTemplates',0,37,'SMSTemplates',0,0,1,'0',NULL,0,0,0),
			(138,'ReportTemplate',0,39,'ReportTemplate',0,0,1,'0',NULL,0,0,0);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_tab_info`(`tabid`,`prefname`,`prefvalue`) values
			(30,'vtiger_min_version','6.0.0rc'),
			(30,'vtiger_max_version','6.*'),
			(32,'vtiger_min_version','6.0.0rc'),
			(34,'vtiger_min_version','6.0.0rc'),
			(35,'vtiger_min_version','6.0.0rc'),
			(35,'vtiger_max_version','6.*'),
			(37,'vtiger_min_version','6.0.0rc'),
			(37,'vtiger_max_version','6.*'),
			(40,'vtiger_min_version','6.0.0rc'),
			(40,'vtiger_max_version','6.*'),
			(41,'vtiger_min_version','6.0.0rc'),
			(41,'vtiger_max_version','6.*'),
			(42,'vtiger_min_version','6.0.0rc'),
			(43,'vtiger_min_version','6.0.0rc'),
			(45,'vtiger_min_version','6.0.0rc'),
			(45,'vtiger_max_version','6.*'),
			(48,'vtiger_min_version','6.0.0'),
			(48,'vtiger_max_version','6.*'),
			(51,'vtiger_min_version','6.1.0'),
			(51,'vtiger_max_version','6.*'),
			(53,'vtiger_min_version','6.0.0'),
			(53,'vtiger_max_version','6.*'),
			(54,'vtiger_min_version','6.0.0'),
			(54,'vtiger_max_version','6.*'),
			(57,'vtiger_min_version','6.0.0'),
			(57,'vtiger_max_version','6.*'),
			(58,'vtiger_min_version','6.0.0'),
			(58,'vtiger_max_version','6.*'),
			(59,'vtiger_min_version','6.0.0'),
			(61,'vtiger_min_version','6.0.0'),
			(61,'vtiger_max_version','6.*'),
			(73,'vtiger_min_version','6.0.0rc'),
			(73,'vtiger_max_version','6.*'),
			(74,'vtiger_min_version','1.1.25 RC'),
			(75,'vtiger_min_version','1.2.100 RC'),
			(78,'vtiger_min_version','1.3.103 RC'),
			(79,'vtiger_min_version','6.0.0'),
			(80,'vtiger_min_version','6.0.0'),
			(81,'vtiger_min_version','6.0.0'),
			(81,'vtiger_max_version','6.*'),
			(82,'vtiger_min_version','6.0.0'),
			(82,'vtiger_max_version','6.*'),
			(83,'vtiger_min_version','1.3.150 RC'),
			(84,'vtiger_min_version','6.1.0'),
			(84,'vtiger_max_version','6.*'),
			(85,'vtiger_min_version','2.3.387'),
			(86,'vtiger_min_version','2.3.413'),
			(87,'vtiger_min_version','2.3.426'),
			(88,'vtiger_min_version','2.3.445'),
			(89,'vtiger_min_version','2.3.457'),
			(90,'vtiger_min_version','2.3.461'),
			(91,'vtiger_min_version','2.3.471'),
			(92,'vtiger_min_version','2.3.774'),
			(93,'vtiger_min_version','2.3.782'),
			(95,'vtiger_min_version','2.3.1075'),
			(97,'vtiger_min_version','2.3.1118'),
			(98,'vtiger_min_version','2.3.1153'),
			(99,'vtiger_min_version','2.3.1096'),
			(100,'vtiger_min_version','2.3.1158'),
			(101,'vtiger_min_version','2.3.1175'),
			(102,'vtiger_min_version','2.3.1180'),
			(103,'vtiger_min_version','2.3.1184'),
			(104,'vtiger_min_version','2.3.1315'),
			(105,'vtiger_min_version','2.3.1321'),
			(106,'vtiger_min_version','2.3.1326'),
			(107,'vtiger_min_version','2.3.1422'),
			(108,'vtiger_min_version','2.3.1514'),
			(109,'vtiger_min_version','2.3.1528'),
			(110,'vtiger_min_version','3.2.999'),
			(111,'vtiger_min_version','3.3.999'),
			(113,'vtiger_min_version','3.5'),
			(114,'vtiger_min_version','3.5'),
			(115,'vtiger_min_version','3.5'),
			(116,'vtiger_min_version','3.4.1517'),
			(117,'vtiger_min_version','3.5'),
			(118,'vtiger_min_version','4.0.999'),
			(120,'vtiger_min_version','4.4.0'),
			(126,'vtiger_min_version','4.4.0'),
			(127,'vtiger_min_version','5.2.x'),
			(128,'vtiger_min_version','5.2.x'),
			(129,'vtiger_min_version','5.2.x'),
			(130,'vtiger_min_version','5.2.105'),
			(131,'vtiger_min_version','5.2.105'),
			(133,'vtiger_min_version','5.3.220'),
			(134,'vtiger_min_version','6.1.139'),
			(135,'vtiger_min_version','6.2.85'),
			(136,'vtiger_min_version','6.3.199');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_taskpriority`(`taskpriorityid`,`taskpriority`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'High',1,170,0),
			(2,'Medium',1,171,1),
			(3,'Low',1,172,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ticketpriorities`(`ticketpriorities_id`,`ticketpriorities`,`presence`,`picklist_valueid`,`sortorderid`,`color`) values
			(1,'Low',1,182,0,'	#E6FAD8'),
			(2,'Normal',1,183,1,'	#E6FAD8'),
			(3,'High',1,184,2,'	#E6FAD8'),
			(4,'Urgent',1,185,3,'	#E6FAD8');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ticketseverities`(`ticketseverities_id`,`ticketseverities`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Minor',1,186,0),
			(2,'Major',1,187,1),
			(3,'Feature',1,188,2),
			(4,'Critical',1,189,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_ticketstatus`(`ticketstatus_id`,`ticketstatus`,`presence`,`picklist_valueid`,`sortorderid`,`color`,`record_state`,`time_counting`) values
			(1,'Open',0,190,1,'855000',1,1),
			(2,'In Progress',0,191,5,'42c6ff',1,2),
			(3,'Wait For Response',0,192,2,'ffa800',1,3),
			(4,'Closed',0,193,8,'00ff43',2,0),
			(5,'Answered',0,387,3,'0038ff',1,2),
			(6,'Rejected',0,557,9,'e33d3d',2,0),
			(7,'PLL_SUBMITTED_COMMENTS',1,694,4,'fff500',1,2),
			(8,'PLL_FOR_APPROVAL',1,695,6,'8c4381',1,2),
			(9,'PLL_TO_CLOSE',1,696,7,'ffb0e7',1,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_time_zone`(`time_zoneid`,`time_zone`,`sortorderid`,`presence`) values
			(1,'Pacific/Midway',0,1),
			(2,'Pacific/Samoa',1,1),
			(3,'Pacific/Honolulu',2,1),
			(4,'America/Anchorage',3,1),
			(5,'America/Los_Angeles',4,1),
			(6,'America/Tijuana',5,1),
			(7,'America/Denver',6,1),
			(8,'America/Chihuahua',7,1),
			(9,'America/Mazatlan',8,1),
			(10,'America/Phoenix',9,1),
			(11,'America/Regina',10,1),
			(12,'America/Tegucigalpa',11,1),
			(13,'America/Chicago',12,1),
			(14,'America/Mexico_City',13,1),
			(15,'America/Monterrey',14,1),
			(16,'America/New_York',15,1),
			(17,'America/Bogota',16,1),
			(18,'America/Lima',17,1),
			(19,'America/Rio_Branco',18,1),
			(20,'America/Indiana/Indianapolis',19,1),
			(21,'America/Caracas',20,1),
			(22,'America/Halifax',21,1),
			(23,'America/Manaus',22,1),
			(24,'America/Santiago',23,1),
			(25,'America/La_Paz',24,1),
			(26,'America/Cuiaba',25,1),
			(27,'America/Asuncion',26,1),
			(28,'America/St_Johns',27,1),
			(29,'America/Argentina/Buenos_Aires',28,1),
			(30,'America/Sao_Paulo',29,1),
			(31,'America/Godthab',30,1),
			(32,'America/Montevideo',31,1),
			(33,'Atlantic/South_Georgia',32,1),
			(34,'Atlantic/Azores',33,1),
			(35,'Atlantic/Cape_Verde',34,1),
			(36,'Europe/London',35,1),
			(37,'UTC',36,1),
			(38,'Africa/Monrovia',37,1),
			(39,'Africa/Casablanca',38,1),
			(40,'Europe/Belgrade',39,1),
			(41,'Europe/Sarajevo',40,1),
			(42,'Europe/Brussels',41,1),
			(43,'Africa/Algiers',42,1),
			(44,'Europe/Amsterdam',43,1),
			(45,'Europe/Minsk',44,1),
			(46,'Africa/Cairo',45,1),
			(47,'Europe/Helsinki',46,1),
			(48,'Europe/Athens',47,1),
			(49,'Europe/Istanbul',48,1),
			(50,'Asia/Jerusalem',49,1),
			(51,'Asia/Amman',50,1),
			(52,'Asia/Beirut',51,1),
			(53,'Africa/Windhoek',52,1),
			(54,'Africa/Harare',53,1),
			(55,'Asia/Kuwait',54,1),
			(56,'Asia/Baghdad',55,1),
			(57,'Africa/Nairobi',56,1),
			(58,'Asia/Tehran',57,1),
			(59,'Asia/Tbilisi',58,1),
			(60,'Europe/Moscow',59,1),
			(61,'Asia/Muscat',60,1),
			(62,'Asia/Baku',61,1),
			(63,'Asia/Yerevan',62,1),
			(64,'Asia/Karachi',63,1),
			(65,'Asia/Tashkent',64,1),
			(66,'Asia/Kolkata',65,1),
			(67,'Asia/Colombo',66,1),
			(68,'Asia/Katmandu',67,1),
			(69,'Asia/Dhaka',68,1),
			(70,'Asia/Almaty',69,1),
			(71,'Asia/Yekaterinburg',70,1),
			(72,'Asia/Rangoon',71,1),
			(73,'Asia/Novosibirsk',72,1),
			(74,'Asia/Bangkok',73,1),
			(75,'Asia/Brunei',74,1),
			(76,'Asia/Krasnoyarsk',75,1),
			(77,'Asia/Ulaanbaatar',76,1),
			(78,'Asia/Kuala_Lumpur',77,1),
			(79,'Asia/Taipei',78,1),
			(80,'Australia/Perth',79,1),
			(81,'Asia/Irkutsk',80,1),
			(82,'Asia/Seoul',81,1),
			(83,'Asia/Tokyo',82,1),
			(84,'Australia/Darwin',83,1),
			(85,'Australia/Adelaide',84,1),
			(86,'Australia/Canberra',85,1),
			(87,'Australia/Brisbane',86,1),
			(88,'Australia/Hobart',87,1),
			(89,'Asia/Vladivostok',88,1),
			(90,'Pacific/Guam',89,1),
			(91,'Asia/Yakutsk',90,1),
			(92,'Pacific/Fiji',92,1),
			(93,'Asia/Kamchatka',93,1),
			(94,'Pacific/Auckland',94,1),
			(95,'Asia/Magadan',95,1),
			(96,'Pacific/Tongatapu',96,1),
			(97,'Etc/GMT-11',91,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_timecontrol_type`(`timecontrol_typeid`,`timecontrol_type`,`sortorderid`,`presence`,`color`) values
			(1,'PLL_WORKING_TIME',1,1,'#EDC240'),
			(2,'PLL_BREAK_TIME',2,1,'#AFD8F8'),
			(3,'PLL_HOLIDAY_TIME',3,1,'#CB4B4B'),
			(4,'PLL_UNPAID_LEAVE',4,1,'#5E666C'),
			(5,'PLL_SICK_LEAVE',5,1,'#9900FF');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_tracking_unit`(`tracking_unitid`,`tracking_unit`,`presence`,`picklist_valueid`,`sortorderid`) values
			(2,'Hours',1,211,2),
			(3,'Days',1,212,3),
			(4,'Incidents',1,213,4);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_trees_templates`(`templateid`,`name`,`tabid`,`access`,`share`) values
			(1,'System',8,0,NULL),
			(2,'Category',14,0,NULL),
			(3,'Category',35,0,NULL),
			(4,'Category',57,0,NULL),
			(5,'Category',58,0,NULL),
			(6,'Category',59,0,NULL),
			(7,'Reservations',84,0,NULL),
			(8,'Category',85,0,NULL),
			(9,'Category',86,0,NULL),
			(10,'Category',87,0,NULL),
			(11,'Category',88,0,NULL),
			(12,'Category',89,0,NULL),
			(13,'Category',90,0,NULL),
			(14,'Category',91,0,NULL),
			(15,'Category',37,0,NULL),
			(16,'Category',96,0,NULL),
			(17,'Category',13,0,NULL),
			(18,'Category',92,0,NULL),
			(19,'Category',113,1,NULL),
			(20,'Category',115,1,NULL),
			(21,'Category',95,1,NULL),
			(22,'Category',117,0,NULL),
			(25,'LBL_LEGAL_BASIS',121,1,''),
			(26,'LBL_SCOPE_DATA',121,1,''),
			(27,'LBL_ACTIVITY_TYPE',122,1,''),
			(28,'LBL_SECURITY_TYPE',123,1,''),
			(29,'Category',15,1,''),
			(30,'Category',111,1,''),
			(31,'LBL_MULTICATEGORY',14,0,'');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_trees_templates_data`(`templateid`,`name`,`tree`,`parentTree`,`depth`,`label`,`state`,`icon`) values
			(2,'Hardware','T1','T1',0,'Hardware','',''),
			(2,'Software','T2','T2',0,'Software','',''),
			(2,'CRM Applications','T3','T3',0,'CRM Applications','',''),
			(2,'Antivirus','T4','T4',0,'Antivirus','',''),
			(2,'Backup','T5','T5',0,'Backup','',''),
			(3,'Hardware','T1','T1',0,'Hardware','',''),
			(3,'Software','T2','T2',0,'Software','',''),
			(3,'CRM Applications','T3','T3',0,'CRM Applications','',''),
			(3,'Antivirus','T4','T4',0,'Antivirus','',''),
			(3,'Backup','T5','T5',0,'Backup','',''),
			(4,'Hardware','T1','T1',0,'Hardware','',''),
			(4,'Software','T2','T2',0,'Software','',''),
			(4,'CRM Applications','T3','T3',0,'CRM Applications','',''),
			(4,'Antivirus','T4','T4',0,'Antivirus','',''),
			(4,'Backup','T5','T5',0,'Backup','',''),
			(5,'Hardware','T1','T1',0,'Hardware','',''),
			(5,'Software','T2','T2',0,'Software','',''),
			(5,'CRM Applications','T3','T3',0,'CRM Applications','',''),
			(5,'Antivirus','T4','T4',0,'Antivirus','',''),
			(5,'Backup','T5','T5',0,'Backup','',''),
			(6,'Hardware','T1','T1',0,'Hardware','',''),
			(6,'Software','T2','T2',0,'Software','',''),
			(6,'CRM Applications','T3','T3',0,'CRM Applications','',''),
			(6,'Antivirus','T4','T4',0,'Antivirus','',''),
			(6,'Backup','T5','T5',0,'Backup','',''),
			(7,'LBL_MEETING_ROOMS','T3','T3',0,'LBL_MEETING_ROOMS','',''),
			(7,'LBL_EQUIPMENT','T2','T2',0,'LBL_EQUIPMENT','',''),
			(7,'LBL_CARS','T1','T1',0,'LBL_CARS','',''),
			(8,'LBL_NONE','T1','T1',0,'LBL_NONE','',''),
			(9,'LBL_NONE','T1','T1',0,'LBL_NONE','',''),
			(10,'LBL_NONE','T1','T1',0,'LBL_NONE','',''),
			(11,'LBL_NONE','T1','T1',0,'LBL_NONE','',''),
			(12,'LBL_NONE','T1','T1',0,'LBL_NONE','',''),
			(13,'LBL_NONE','T1','T1',0,'LBL_NONE','',''),
			(14,'LBL_NONE','T1','T1',0,'LBL_NONE','',''),
			(15,'LBL_NONE','T1','T1',0,'LBL_NONE','',''),
			(1,'Default','T1','T1',0,'Default','',''),
			(1,'Mails','T2','T2',0,'Mails','',''),
			(16,'LBL_NONE','T1','T1',0,'LBL_NONE','',''),
			(17,'LBL_NONE','T1','T1',0,'LBL_NONE','',''),
			(18,'LBL_NONE','T1','T1',0,'LBL_NONE','',''),
			(19,'none','T1','T1',0,'none','',''),
			(20,'none','T1','T1',0,'none','',''),
			(21,'none','T1','T1',0,'none','',''),
			(22,'LBL_NONE','T1','T1',0,'LBL_NONE','',''),
			(25,'PLL_CONSENT','T1','T1',0,'PLL_CONSENT','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(25,'PLL_FULFIILMENT','T2','T2',0,'PLL_FULFIILMENT','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(25,'PLL_EXECUCTION_OF_AGREMMENT','T3','T3',0,'PLL_EXECUCTION_OF_AGREMMENT','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(25,'PLL_PERFORMACNE_PUBLIC_TASKS','T4','T4',0,'PLL_PERFORMACNE_PUBLIC_TASKS','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(25,'PLL_JUSTIFIED_ADMIN_DATA','T5','T5',0,'PLL_JUSTIFIED_ADMIN_DATA','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(26,'PLL_NAME_AND_LASTNAME','T1','T1',0,'PLL_NAME_AND_LASTNAME','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(26,'PLL_PARENTS_NAMES','T2','T2',0,'PLL_PARENTS_NAMES','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(26,'PLL_BIRTHDAY','T3','T3',0,'PLL_BIRTHDAY','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(26,'PLL_PLACE_OF_BIRTH','T4','T4',0,'PLL_PLACE_OF_BIRTH','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(26,'PLL_ADDRESS','T5','T5',0,'PLL_ADDRESS','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(26,'PLL_PESEL_NUMBER','T6','T6',0,'PLL_PESEL_NUMBER','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(26,'PLL_VAT','T7','T7',0,'PLL_VAT','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(26,'PLL_EDUCATION','T8','T8',0,'PLL_EDUCATION','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(26,'PLL_ID_CARD_NUMBER','T10','T10',0,'PLL_ID_CARD_NUMBER','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(26,'PLL_PHONE','T11','T11',0,'PLL_PHONE','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(26,'PLL_EMAIL','T12','T12',0,'PLL_EMAIL','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(26,'PLL_EMPLOYMENT_PLACE','T13','T13',0,'PLL_EMPLOYMENT_PLACE','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(26,'PLL_PROFESSION','T14','T14',0,'PLL_PROFESSION','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(27,'PLL_ENTRUSTMENT','T1','T1',0,'PLL_ENTRUSTMENT','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(27,'PLL_SHARING','T2','T2',0,'PLL_SHARING','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(27,'PLL_TRANSFER','T3','T3',0,'PLL_TRANSFER','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(27,'PLL_ENTRUSTMENT_ACCEPTANCE','T4','T4',0,'PLL_ENTRUSTMENT_ACCEPTANCE','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(27,'PLL_INTERNAL','T5','T5',0,'PLL_INTERNAL','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(28,'PLL_PHYSICAL','T1','T1',0,'PLL_PHYSICAL','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(28,'PLL_ELECTRONIC','T2','T2',0,'PLL_ELECTRONIC','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(29,'None','T1','T1',0,'None','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(30,'Base','T1','T1',0,'Base','{\"loaded\":\"1\",\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(31,'Hardware','T1','T1',0,'Hardware','{\"loaded\":true,\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(31,'Software','T2','T2',0,'Software','{\"loaded\":true,\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(31,'CRM Applications','T3','T3',0,'CRM Applications','{\"loaded\":true,\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(31,'Antivirus','T4','T4',0,'Antivirus','{\"loaded\":true,\"opened\":false,\"selected\":false,\"disabled\":false}',''),
			(31,'Backup','T5','T5',0,'Backup','{\"loaded\":true,\"opened\":false,\"selected\":false,\"disabled\":false}','');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_usageunit`(`usageunitid`,`usageunit`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'pcs',1,194,0),
			(2,'pack',1,195,1),
			(3,'kg',1,196,2),
			(4,'m',1,197,3),
			(5,'l',1,198,4);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_user2role`(`userid`,`roleid`) values
			(1,'H2');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_users`(`id`,`user_name`,`first_name`,`last_name`,`email1`,`is_admin`,`status`,`deleted`,`language`,`user_password`,`internal_mailer`,`reports_to_id`,`modified_user_id`,`currency_id`,`description`,`date_entered`,`date_modified`,`date_password_change`,`force_password_change`,`holidays`,`namedays`,`workdays`,`weekstart`,`date_format`,`hour_format`,`start_hour`,`end_hour`,`view_date_format`,`activity_view`,`imagename`,`reminder_interval`,`reminder_next_time`,`theme`,`tz`,`time_zone`,`currency_grouping_pattern`,`currency_decimal_separator`,`currency_grouping_separator`,`currency_symbol_placement`,`no_of_currency_decimals`,`truncate_trailing_zeros`,`dayoftheweek`,`othereventduration`,`default_record_view`,`leftpanelhide`,`rowheight`,`defaulteventstatus`,`defaultactivitytype`,`is_owner`,`emailoptout`,`available`,`auto_assign`,`records_limit`,`phone_crm_extension`,`phone_crm_extension_extra`,`accesskey`,`confirm_password`,`cal_color`,`user_preferences`,`authy_methods`,`authy_secret_totp`,`login_method`,`sync_carddav`,`sync_caldav`,`sync_carddav_default_country`,`default_search_module`,`default_search_override`,`primary_phone`,`primary_phone_extra`,`mail_scanner_actions`,`mail_scanner_fields`,`secondary_email`,`default_search_operator`,`super_user`,`calendar_all_users_by_default`,`user_pbx`,`mail_popup`) values
			(1,'admin','','Administrator','help@yetiforce.com','on','Active',0,'pl-PL','$2y$10$mvy47VqQjd853TpAUr5aE.pd2fSTjBv.Z3G0g8AqyPwPNcV/YtB02','',0,'1',1,'','2016-12-06 09:29:00','2017-10-31 21:32:46',NULL,NULL,NULL,NULL,NULL,NULL,'yyyy-mm-dd','24','08:00','23:00','PLL_ELAPSED','This Month','','15 Minutes','2017-10-31 21:32','twilight',NULL,'Europe/Sarajevo','123456789','.',' ','1.0$','2',1,'Monday','[{\"activitytype\":\"Call\",\"duration\":\"60\"},{\"activitytype\":\"Meeting\",\"duration\":\"60\"},{\"activitytype\":\"Task\",\"duration\":\"60\"}]','Summary',0,'medium','PLL_PLANNED','Meeting','1',1,1,0,NULL,'',NULL,'aOFXop10GCJ1uw0P','','#E6FAD8',NULL,NULL,NULL,'PLL_PASSWORD','PLL_OWNER','PLL_OWNER',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'','PLL_CONTAINS',1,NULL,0,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_users2group`(`groupid`,`userid`) values
			(3,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_users_seq`(`id`) values
			(4);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_verification`(`verificationid`,`verification`,`presence`,`picklist_valueid`,`sortorderid`) values
			(1,'Address details',1,440,1),
			(5,'Contact details',1,444,2),
			(6,'Registration details',1,445,3);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_version`(`id`,`old_version`,`current_version`) values
			(1,'7.0.0','7.0.0');
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_view_date_format`(`view_date_formatid`,`view_date_format`,`presence`,`sortorderid`) values
			(1,'PLL_FULL',1,1),
			(2,'PLL_ELAPSED',1,2);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_visibility`(`visibilityid`,`visibility`,`sortorderid`,`presence`) values
			(1,'Private',0,1),
			(2,'Public',1,1);
			STR);

		$this->addSql(<<<'STR'
			insert  into `vtiger_widgets`(`id`,`tabid`,`type`,`label`,`wcol`,`sequence`,`data`) values
			(1,6,'Summary',NULL,1,0,'[]'),
			(2,6,'Comments','ModComments',3,4,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(4,6,'Activities','Calendar',2,1,'{\"limit\":\"5\"}'),
			(5,6,'RelatedModule','Contacts',2,2,'{\"relatedmodule\":\"4\",\"relatedfields\":[\"4::firstname\",\"4::lastname\",\"4::phone\",\"4::email\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":1}'),
			(7,7,'Summary',NULL,1,0,'[]'),
			(8,7,'Comments','ModComments',3,3,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(10,7,'Activities','Calendar',2,1,'{\"limit\":\"5\"}'),
			(11,7,'EmailList','Emails',3,4,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(12,6,'EmailList','Emails',3,5,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(14,4,'Summary',NULL,1,0,'[]'),
			(15,4,'Comments','ModComments',3,3,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(17,4,'Activities','Calendar',2,2,'{\"limit\":\"5\"}'),
			(18,4,'EmailList','Emails',3,4,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(26,43,'Summary',NULL,1,1,'[]'),
			(27,43,'Comments','ModComments',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(28,43,'Updates','LBL_UPDATES',1,3,'[]'),
			(30,43,'EmailList','Emails',1,5,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(31,43,'RelatedModule','ProjectTask',2,6,'{\"relatedmodule\":\"42\",\"relatedfields\":[\"42::projecttaskname\",\"42::projecttaskpriority\",\"42::projecttaskstatus\",\"42::projecttaskprogress\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":173}'),
			(32,43,'RelatedModule','ProjectMilestone',2,7,'{\"relatedmodule\":\"41\",\"relatedfields\":[\"41::projectmilestonename\",\"41::projectmilestonedate\",\"41::projectmilestone_progress\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":174}'),
			(34,13,'Summary',NULL,1,1,'[]'),
			(35,13,'Comments','ModComments',1,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(36,13,'Updates','LBL_UPDATES',1,3,'[]'),
			(37,13,'EmailList','Emails',2,4,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(38,13,'Activities','Calendar',2,5,'{\"limit\":\"5\"}'),
			(39,13,'RelatedModule','Documents',2,6,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":55}'),
			(40,51,'Summary',NULL,1,1,'[]'),
			(41,51,'Comments','ModComments',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(42,51,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":182}'),
			(43,7,'RelatedModule','Contacts',2,2,'{\"relatedmodule\":\"4\",\"relatedfields\":[\"4::firstname\",\"4::lastname\",\"4::phone\",\"4::email\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":239}'),
			(47,13,'WYSIWYG','WYSIWYG',1,7,'{\"field_name\":\"description\"}'),
			(48,54,'PreviewMail',NULL,1,1,'{\"relatedmodule\":\"Emails\"}'),
			(49,42,'Summary',NULL,1,0,'[]'),
			(50,42,'Comments','ModComments',2,1,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(51,84,'Summary',NULL,1,0,'[]'),
			(52,84,'Comments','',2,1,'{\"relatedmodule\":\"ModComments\",\"limit\":\"10\"}'),
			(55,85,'Summary',NULL,1,0,'[]'),
			(56,85,'EmailList','Emails',2,6,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(57,85,'RelatedModule','Documents',2,4,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":373}'),
			(58,85,'Comments','ModComments',2,3,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(59,85,'Updates','LBL_UPDATES',1,1,'[]'),
			(60,87,'Summary',NULL,1,0,'[]'),
			(61,87,'EmailList','Emails',2,4,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(62,87,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":377}'),
			(63,87,'Comments','ModComments',2,5,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(64,87,'Updates','LBL_UPDATES',1,1,'[]'),
			(65,88,'Summary',NULL,1,0,'[]'),
			(66,88,'Updates','LBL_UPDATES',1,1,'[]'),
			(67,88,'Comments','ModComments',2,5,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(68,88,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":381}'),
			(69,88,'EmailList','Emails',2,4,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(70,89,'Summary',NULL,1,0,'[]'),
			(71,89,'Updates','LBL_UPDATES',1,1,'[]'),
			(72,89,'Comments','ModComments',2,5,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(73,89,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":385}'),
			(74,89,'EmailList','Emails',2,4,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(75,90,'Summary',NULL,1,0,'[]'),
			(76,90,'Updates','LBL_UPDATES',1,1,'[]'),
			(77,90,'Comments','ModComments',2,5,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(78,90,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":389}'),
			(79,90,'EmailList','Emails',2,4,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(80,86,'Summary',NULL,1,0,'[]'),
			(81,86,'Updates','LBL_UPDATES',1,1,'[]'),
			(82,86,'Comments','ModComments',2,6,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(83,86,'RelatedModule','Documents',2,4,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":375}'),
			(84,86,'EmailList','Emails',2,5,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(85,92,'Summary',NULL,1,0,'[]'),
			(87,92,'Comments','ModComments',3,3,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(88,92,'RelatedModule','Documents',2,2,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":400}'),
			(89,92,'EmailList','Emails',3,4,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(90,93,'Summary',NULL,1,0,'[]'),
			(92,93,'Comments','ModComments',3,3,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(93,93,'RelatedModule','Documents',2,2,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":402}'),
			(94,93,'EmailList','Emails',3,4,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(95,18,'Summary',NULL,1,0,'[]'),
			(97,18,'Comments','ModComments',3,3,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(98,18,'RelatedModule','Documents',2,2,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":399}'),
			(99,18,'EmailList','Emails',3,4,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(100,86,'RelatedModule','Contacts',1,2,'{\"relatedmodule\":\"4\",\"relatedfields\":[\"4::firstname\",\"4::lastname\",\"4::phone\",\"4::email\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":424}'),
			(101,92,'RelatedModule','Contacts',2,1,'{\"relatedmodule\":\"4\",\"relatedfields\":[\"4::firstname\",\"4::lastname\",\"4::phone\",\"4::email\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":425}'),
			(102,93,'RelatedModule','Contacts',2,1,'{\"relatedmodule\":\"4\",\"relatedfields\":[\"4::firstname\",\"4::lastname\",\"4::phone\",\"4::email\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":426}'),
			(103,6,'RelatedModule','',2,3,'{\"relatedmodule\":\"86\",\"relatedfields\":[\"86::subject\",\"86::related_to\",\"86::assigned_user_id\",\"86::ssalesprocesses_type\"],\"viewtype\":\"List\",\"limit\":\"10\",\"action\":\"1\",\"switchHeader\":\"0\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":452}'),
			(104,100,'Summary',NULL,1,0,'[]'),
			(105,100,'Updates','LBL_UPDATES',1,1,'[]'),
			(106,100,'Comments','ModComments',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(107,100,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":455}'),
			(108,101,'Summary',NULL,1,0,'[]'),
			(109,101,'Updates','LBL_UPDATES',1,1,'[]'),
			(110,101,'Comments','ModComments',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(111,101,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":456}'),
			(112,98,'Summary',NULL,1,0,'[]'),
			(113,98,'Updates','LBL_UPDATES',1,1,'[]'),
			(114,98,'Comments','ModComments',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(115,98,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":458}'),
			(116,102,'Comments','',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(117,102,'Updates','LBL_UPDATES',1,1,'[]'),
			(118,102,'Summary',NULL,1,0,'[]'),
			(119,102,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":460}'),
			(120,103,'Summary',NULL,1,0,'[]'),
			(121,103,'Updates','LBL_UPDATES',1,1,'[]'),
			(122,103,'Comments','',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(123,103,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":464}'),
			(124,97,'Summary',NULL,1,0,'[]'),
			(125,97,'Updates','LBL_UPDATES',1,1,'[]'),
			(126,97,'Comments','ModComments',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(127,97,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":466}'),
			(128,94,'Summary',NULL,1,0,'[]'),
			(129,94,'Updates','LBL_UPDATES',1,1,'[]'),
			(130,94,'Comments','ModComments',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(131,94,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":467}'),
			(132,104,'Comments','',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(133,104,'Summary',NULL,1,0,'[]'),
			(134,104,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":468}'),
			(135,104,'Updates','LBL_UPDATES',1,1,'[]'),
			(136,105,'Comments','',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(137,105,'Summary',NULL,1,0,'[]'),
			(138,105,'Updates','LBL_UPDATES',1,1,'[]'),
			(139,105,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":470}'),
			(140,106,'Summary',NULL,1,0,'[]'),
			(141,106,'Comments','',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(142,106,'Updates','LBL_UPDATES',1,1,'[]'),
			(143,106,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":478}'),
			(144,96,'Comments','',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(145,96,'Updates','LBL_UPDATES',1,1,'[]'),
			(146,96,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":485}'),
			(147,96,'Summary',NULL,1,0,'[]'),
			(148,86,'Activities','Calendar',2,3,'{\"limit\":\"5\"}'),
			(149,88,'Activities','Calendar',2,2,'{\"limit\":\"5\"}'),
			(150,85,'Activities','Calendar',1,2,'{\"limit\":\"5\"}'),
			(151,89,'Activities','Calendar',2,2,'{\"limit\":\"5\"}'),
			(152,91,'Activities','Calendar',2,2,'{\"limit\":\"5\"}'),
			(153,87,'Activities','Calendar',2,2,'{\"limit\":\"5\"}'),
			(154,90,'Activities','Calendar',2,2,'{\"limit\":\"5\"}'),
			(155,91,'Summary',NULL,1,0,'[]'),
			(156,91,'Updates','LBL_UPDATES',1,1,'[]'),
			(157,91,'RelatedModule','Documents',2,3,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":393}'),
			(158,91,'EmailList','Emails',2,4,'{\"relatedmodule\":\"OSSMailView\",\"limit\":\"5\"}'),
			(159,91,'Comments','ModComments',2,5,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(160,26,'Summary',NULL,1,0,'[]'),
			(161,26,'Comments','ModComments',2,3,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(162,26,'RelatedModule','Documents',2,2,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":509}'),
			(163,26,'Updates','LBL_UPDATES',1,1,'[]'),
			(164,113,'Summary',NULL,1,0,'[]'),
			(165,113,'Comments','',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(166,113,'RelatedModule','Documents',1,1,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":526}'),
			(167,114,'Summary',NULL,1,0,'[]'),
			(168,114,'RelatedModule','Documents',1,1,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":527}'),
			(169,114,'Comments','',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(170,115,'Summary',NULL,1,0,'[]'),
			(171,115,'Comments','',2,2,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(172,115,'RelatedModule','Documents',1,1,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::folderid\",\"8::filelocationtype\",\"8::filename\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"1\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":528}'),
			(173,117,'Activities','',2,2,'{\"limit\":\"5\"}'),
			(174,117,'EmailList','Emails',2,3,'{\"limit\":\"5\",\"relatedmodule\":\"OSSMailView\"}'),
			(175,117,'Comments','',1,1,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(176,117,'Summary',NULL,1,0,'[]'),
			(177,121,'Comments','ModComments',2,3,'{\"relatedmodule\":\"ModComments\",\"limit\":\"5\"}'),
			(178,121,'Summary',NULL,1,0,'[]'),
			(179,121,'Updates','LBL_UPDATES',1,1,'[]'),
			(180,121,'RelatedModule','',2,2,'{\"relatedmodule\":\"8\",\"relatedfields\":[\"8::notes_title\",\"8::assigned_user_id\",\"8::ossdc_status\"],\"viewtype\":\"List\",\"limit\":\"5\",\"action\":\"0\",\"actionSelect\":\"0\",\"no_result_text\":\"0\",\"switchHeader\":\"-\",\"filter\":\"-\",\"checkbox\":\"-\",\"relation_id\":542}'),
			(182,122,'Summar