<?php
/**
 * ProjectTask ProjectTaskHandler handler file.
 *
 * @package   Handler
 *
 * @copyright YetiForce S.A.
 * @license   YetiForce Public License 7.0 (licenses/LicenseEN.txt or yetiforce.com)
 */
use App\BatchMethod;
use App\EventHandler;

/**
 * ProjectTask ProjectTaskHandler handler class.
 */
class ProjectTask_ProjectTaskHandler_Handler
{
	/**
	 * EntityAfterSave handler function.
	 *
	 * @param EventHandler $eventHandler
	 */
	public function entityAfterSave(EventHandler $eventHandler)
	{
		$recordModel = $eventHandler->getRecordModel();
		if ($recordModel->isNew()) {
			$this->addMilestoneToBatchMethod($recordModel->get('projectmilestoneid'));
		} else {
			$delta = $recordModel->getPreviousValue();
			$calculateMilestone = $calculateProject = [];
			foreach ($delta as $name => $value) {
				if ('projectmilestoneid' === $name || 'estimated_work_time' === $name || 'projecttaskprogress' === $name) {
					if ('projectmilestoneid' === $name) {
						$calculateMilestone[$recordModel->get($name)] = true;
						$calculateMilestone[$value] = true;
					} else {
						$calculateMilestone[$recordModel->get('projectmilestoneid')] = true;
					}
					$calculateProject[$recordModel->get('projectid')] = true;
				} elseif ('projectid' === $name) {
					$calculateProject[$recordModel->get($name)] = true;
					$calculateProject[$value] = true;
				}
			}
			foreach ($calculateMilestone as $milestoneId => $val) {
				$this->addMilestoneToBatchMethod($milestoneId);
			}
			foreach ($calculateProject as $projectId => $val) {
				$this->addProjectToBatchMethod($projectId);
			}
		}
	}

	/**
	 * EntityAfterDelete handler function.
	 *
	 * @param EventHandler $eventHandler
	 */
	public function entityAfterDelete(EventHandler $eventHandler)
	{
		$this->entityChangeState($eventHandler);
	}

	/**
	 * EntityChangeState handler function.
	 *
	 * @param EventHandler $eventHandler
	 */
	public function entityChangeState(EventHandler $eventHandler)
	{
		$recordModel = $eventHandler->getRecordModel();
		$this->addMilestoneToBatchMethod($recordModel->get('projectmilestoneid'));
	}

	/**
	 * Add batch method for progress calculation.
	 *
	 * @param int|null $milestoneId
	 *
	 * @return void
	 */
	private function addMilestoneToBatchMethod($milestoneId)
	{
		if ($milestoneId) {
			(new BatchMethod(['method' => 'ProjectMilestone_Module_Model::updateProgress', 'params' => [$milestoneId]]))->save();
		}
	}

	/**
	 * Add batch method for progress calculation.
	 *
	 * @param int|null $projectId
	 *
	 * @return void
	 */
	private function addProjectToBatchMethod($projectId)
	{
		if ($projectId) {
			(new BatchMethod(['method' => 'Project_Module_Model::updateProgress', 'params' => [$projectId]]))->save();
		}
	}
}
