'use strict';

/* {[The file is published on the basis of YetiForce Public License 7.0 that can be found in the following directory: licenses/LicenseEN.txt or yetiforce.com]} */"use strict";Vtiger_Detail_Js("HelpDesk_Detail_Js",{setAccountsReference:function setAccountsReference(){app.showRecordsList({module:"Accounts",src_module:"HelpDesk",src_record:app.getRecordId()},function(_modal,instance){instance.setSelectEvent(function(responseData){Vtiger_Detail_Js.getInstance().saveFieldValues({field:"parent_id",value:responseData.id}).done(function(){location.reload();});});});}},{registerSetServiceContracts:function registerSetServiceContracts(){var thisInstance=this;$(".selectServiceContracts").on("click","ul li",function(e){var element=jQuery(e.currentTarget);thisInstance.saveFieldValues({setRelatedFields:!0,field:"servicecontractsid",value:element.data("id")}).done(function(){location.reload();});});},/**
		 * Function to get response from hierarchy
		 * @param {array} params
		 * @returns {Promise}
		 */getHierarchyResponseData:function getHierarchyResponseData(params){var thisInstance=this,aDeferred=$.Deferred();return $.isEmptyObject(thisInstance.hierarchyResponseCache)?AppConnector.request(params).then(function(data){thisInstance.hierarchyResponseCache=data,aDeferred.resolve(thisInstance.hierarchyResponseCache);}):aDeferred.resolve(thisInstance.hierarchyResponseCache),aDeferred.promise()},/**
		 * Function to display the hierarchy response data
		 * @param {array} data
		 */displayHierarchyResponseData:function displayHierarchyResponseData(data){var thisInstance=this,callbackFunction=function(){app.showScrollBar($("#hierarchyScroll"),{height:"300px",railVisible:!0,size:"6px"});};app.showModalWindow(data,function(modal){App.Components.Scrollbar.xy($("#hierarchyScroll")),thisInstance.registerChangeStatusInHierarchy(modal),"function"==typeof callbackFunction&&300<$("#hierarchyScroll").height()&&callbackFunction();});},/**
		 * Registers read count of hierarchy if it is possible
		 */registerHierarchyRecordCount:function registerHierarchyRecordCount(){var hierarchyButton=$(".js-detail-hierarchy"),params={module:app.getModuleName(),action:"RelationAjax",record:app.getRecordId(),mode:"getHierarchyCount"};hierarchyButton.length&&AppConnector.request(params).then(function(response){response.success&&$(".hierarchy .badge").html(response.result);});},/**
		 * Shows hierarchy
		 */registerShowHierarchy:function registerShowHierarchy(){var thisInstance=this,hierarchyButton=$(".detailViewTitle"),params={module:app.getModuleName(),view:"Hierarchy",record:app.getRecordId()};hierarchyButton.on("click",".js-detail-hierarchy",function(){var progressIndicatorElement=$.progressIndicator({position:"html",blockInfo:{enabled:!0}});thisInstance.getHierarchyResponseData(params).then(function(data){thisInstance.displayHierarchyResponseData(data),progressIndicatorElement.progressIndicator({mode:"hide"});});});},/**
		 * Function to register events on update hierarchy button
		 *
		 * @param {jQuery} container
		 */registerChangeStatusInHierarchy:function registerChangeStatusInHierarchy(container){container.find(".js-update-hierarchy").on("click",function(){var params={module:app.getModuleName(),action:"ChangeStatus",recordsType:container.find(".js-selected-records").val(),status:container.find(".js-status").val(),record:app.getRecordId()};AppConnector.request(params).done(function(data){data.success&&app.showNotify({text:data.result.data,type:"success"}),app.hideModalWindow();});});},/**
		 * Show confirmation on event click
		 * @param {jQuery} element
		 * @param {string} picklistName
		 */showProgressConfirmation:function showProgressConfirmation(element,picklistName){var _this=this,picklistValue=$(element).data("picklistValue");app.showConfirmModal({title:$(element).data("picklistLabel"),text:app.vtranslate("JS_CHANGE_VALUE_CONFIRMATION"),confirmedCallback:function confirmedCallback(){var progressIndicatorElement=$.progressIndicator();_this.saveFieldValues({value:picklistValue,field:picklistName}).done(function(data){progressIndicatorElement.progressIndicator({mode:"hide"}),data.success&&window.location.reload();}).fail(function(error,err){progressIndicatorElement.progressIndicator({mode:"hide"}),app.errorLog(error,err);});}});},/**
		 * Function save field values
		 * @param {array} fieldDetailList
		 * @returns {Promise}
		 */saveFieldValues:function saveFieldValues(fieldDetailList){var _this2=this,self=this,aDeferred=jQuery.Deferred(),recordId=app.getRecordId(),data={};"undefined"!=typeof fieldDetailList&&(data=fieldDetailList);var saveData=function(){var reload=!(0<arguments.length&&arguments[0]!==void 0)||arguments[0];data.record=recordId,data.module=app.getModuleName(),data.action="SaveAjax";var params={};params.data=data,params.async=!1,params.dataType="json",AppConnector.request(params).done(function(reponseData){aDeferred.resolve(reponseData),reload&&window.location.reload();});};return "ticketstatus"===fieldDetailList.field&&(CONFIG.checkIfRecordHasTimeControl||CONFIG.checkIfRelatedTicketsAreClosed)?(AppConnector.request({action:"CheckValidateToClose",module:app.getModuleName(),record:recordId,status:fieldDetailList.value}).done(function(response){if(response.result.hasTimeControl.result&&response.result.relatedTicketsClosed.result)saveData(!1);else {var addTimeControlCb=saveData;response.result.relatedTicketsClosed.result||(app.showNotify({text:response.result.relatedTicketsClosed.message,type:"info"}),addTimeControlCb=function(){_this2.saveFieldValues(fieldDetailList);}),response.result.hasTimeControl.result||(app.showNotify({text:response.result.hasTimeControl.message,type:"info"}),self.addTimeControl({recordId:recordId,url:"index.php?module=OSSTimeControl&view=Edit&sourceModule=HelpDesk&sourceRecord=".concat(recordId,"&relationOperation=true&subprocess=").concat(recordId,"&subprocess=").concat(recordId)},addTimeControlCb));}aDeferred.resolve({success:!1});}),aDeferred.promise()):(saveData(!1),aDeferred.promise())},/**
		 * Add time control when closed ticket
		 * @param {array} params
		 * @returns {Promise}
		 */addTimeControl:function addTimeControl(params){var callback=1<arguments.length&&void 0!==arguments[1]?arguments[1]:function(){},aDeferred=jQuery.Deferred(),parentId=params.recordId,quickCreateParams={},relatedParams={},relatedField="subprocess",fullFormUrl=params.url;relatedParams[relatedField]=parentId;var eliminatedKeys=new Array("view","module","mode","action"),preQuickCreateSave=function preQuickCreateSave(data){var index,queryParam,queryParamComponents,queryParameters=[];if("undefined"!=typeof fullFormUrl&&-1!==fullFormUrl.indexOf("?")){var urlSplit=fullFormUrl.split("?"),queryString=urlSplit[1];for(queryParameters=queryString.split("&"),index=0;index<queryParameters.length;index++)queryParam=queryParameters[index],queryParamComponents=queryParam.split("="),"mode"==queryParamComponents[0]&&"Calendar"==queryParamComponents[1]&&data.find("a[data-tab-name=\"Task\"]").trigger("click");}if(jQuery("<input type=\"hidden\" name=\"sourceModule\" value=\""+"HelpDesk"+"\" />").appendTo(data),jQuery("<input type=\"hidden\" name=\"sourceRecord\" value=\""+parentId+"\" />").appendTo(data),jQuery("<input type=\"hidden\" name=\"relationOperation\" value=\"true\" />").appendTo(data),"undefined"!=typeof relatedField){var field=data.find("[name=\""+relatedField+"\"]");0==field.length&&jQuery("<input type=\"hidden\" name=\""+relatedField+"\" value=\""+parentId+"\" />").appendTo(data);}for(index=0;index<queryParameters.length;index++)queryParam=queryParameters[index],queryParamComponents=queryParam.split("="),"-1"==jQuery.inArray(queryParamComponents[0],eliminatedKeys)&&0==data.find("[name=\""+queryParamComponents[0]+"\"]").length&&jQuery("<input type=\"hidden\" name=\""+queryParamComponents[0]+"\" value=\""+queryParamComponents[1]+"\" />").appendTo(data);};if("undefined"!=typeof fullFormUrl&&-1!==fullFormUrl.indexOf("?"))for(var urlSplit=fullFormUrl.split("?"),queryString=urlSplit[1],queryParameters=queryString.split("&"),index=0;index<queryParameters.length;index++){var queryParam=queryParameters[index],queryParamComponents=queryParam.split("=");"-1"==jQuery.inArray(queryParamComponents[0],eliminatedKeys)&&(relatedParams[queryParamComponents[0]]=queryParamComponents[1]);}return quickCreateParams.data=relatedParams,quickCreateParams.callbackFunction=callback,quickCreateParams.callbackPostShown=preQuickCreateSave,quickCreateParams.noCache=!0,App.Components.QuickCreate.createRecord("OSSTimeControl",quickCreateParams),aDeferred.promise()},registerEvents:function registerEvents(){this._super(),this.registerSetServiceContracts(),this.registerHierarchyRecordCount(),this.registerShowHierarchy();}});
//# sourceMappingURL=Detail.min.js.map
